/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_6_IV0$;
import kafka.api.KAFKA_2_7_IV0$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.controller.AlterIsrReceived;
import kafka.controller.ApiPartitionReassignment;
import kafka.controller.ControlledShutdown;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerEventManager;
import kafka.controller.ControllerState;
import kafka.controller.ElectionTrigger;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ListPartitionReassignments;
import kafka.controller.MockEvent;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaLeaderElection;
import kafka.controller.ZkTriggered$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.LogCaptureAppender;
import kafka.utils.LogCaptureAppender$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import kafka.utils.TestUtils$Checkpoint$;
import kafka.zk.AdminZkClient;
import kafka.zk.FeatureZNode;
import kafka.zk.FeatureZNode$;
import kafka.zk.FeatureZNodeStatus;
import kafka.zk.PreferredReplicaElectionZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\r\u0005a\u0001\u0002%J\u00019CQ!\u0016\u0001\u0005\u0002YCq!\u0017\u0001A\u0002\u0013\u0005!\fC\u0004j\u0001\u0001\u0007I\u0011\u00016\t\rE\u0004\u0001\u0015)\u0003\\\u0011\u001d\u0011\bA1A\u0005\u0002MDaa\u001e\u0001!\u0002\u0013!\bb\u0002=\u0001\u0005\u0004%\ta\u001d\u0005\u0007s\u0002\u0001\u000b\u0011\u0002;\t\u000bi\u0004A\u0011I>\t\r\u0005M\u0001\u0001\"\u0011|\u0011\u0019\ti\u0002\u0001C\u0001w\"1\u0011q\u0005\u0001\u0005\u0002mDa!a\u000b\u0001\t\u0003Y\bBBA\u0018\u0001\u0011\u00051\u0010\u0003\u0004\u00024\u0001!\ta\u001f\u0005\u0007\u0003o\u0001A\u0011A>\t\r\u0005m\u0002\u0001\"\u0001|\u0011\u0019\ty\u0004\u0001C\u0001w\"1\u00111\t\u0001\u0005\u0002mDa!a\u0012\u0001\t\u0003Y\bBBA&\u0001\u0011\u00051\u0010\u0003\u0004\u0002P\u0001!\ta\u001f\u0005\u0007\u0003'\u0002A\u0011A>\t\r\u0005]\u0003\u0001\"\u0001|\u0011\u0019\tY\u0006\u0001C\u0001w\"1\u0011q\f\u0001\u0005\u0002mDa!a\u0019\u0001\t\u0003Y\bBBA4\u0001\u0011\u00051\u0010\u0003\u0004\u0002l\u0001!\ta\u001f\u0005\u0007\u0003_\u0002A\u0011A>\t\r\u0005M\u0004\u0001\"\u0001|\u0011\u0019\t9\b\u0001C\u0001w\"1\u00111\u0010\u0001\u0005\u0002mDa!a \u0001\t\u0003Y\bBBAB\u0001\u0011\u00051\u0010\u0003\u0004\u0002\b\u0002!\ta\u001f\u0005\u0007\u0003\u0017\u0003A\u0011A>\t\r\u0005=\u0005\u0001\"\u0001|\u0011\u0019\t\u0019\n\u0001C\u0001w\"1\u0011q\u0013\u0001\u0005\u0002mDa!a'\u0001\t\u0003Y\bBBAP\u0001\u0011\u00051\u0010\u0003\u0004\u0002$\u0002!\ta\u001f\u0005\u0007\u0003O\u0003A\u0011A>\t\r\u0005-\u0006\u0001\"\u0001|\u0011\u001d\ty\u000b\u0001C\u0005\u0003cCa!!5\u0001\t\u0003Y\bBBAk\u0001\u0011\u00051\u0010\u0003\u0004\u0002Z\u0002!\ta\u001f\u0005\u0007\u0003;\u0004A\u0011A>\t\r\u0005\u0005\b\u0001\"\u0001|\u0011\u0019\t)\u000f\u0001C\u0001w\"1\u0011\u0011\u001e\u0001\u0005\u0002mDa!!<\u0001\t\u0003Y\bBBAy\u0001\u0011\u00051\u0010C\u0004\u0002v\u0002!I!a>\t\u000f\t\r\u0001\u0001\"\u0003\u0003\u0006!9!1\t\u0001\u0005\n\t\u0015\u0003b\u0002B+\u0001\u0011%!q\u000b\u0005\b\u0005O\u0002A\u0011\u0002B5\u0011\u001d\u0011\t\t\u0001C\u0005\u0005\u0007C\u0011Ba+\u0001#\u0003%IA!,\t\u0013\t\r\u0007!%A\u0005\n\t5\u0006\"\u0003Bc\u0001E\u0005I\u0011\u0002BW\u0011%\u00119\rAI\u0001\n\u0013\u0011I\rC\u0005\u0003N\u0002\t\n\u0011\"\u0003\u0003J\"I!q\u001a\u0001\u0012\u0002\u0013%!\u0011\u001a\u0005\n\u0005#\u0004\u0011\u0013!C\u0005\u0005'D\u0011Ba6\u0001#\u0003%IA!7\t\u000f\tu\u0007\u0001\"\u0003\u0003`\"9!Q \u0001\u0005\n\t}(!G\"p]R\u0014x\u000e\u001c7fe&sG/Z4sCRLwN\u001c+fgRT!AS&\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001M\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A(\u0011\u0005A\u001bV\"A)\u000b\u0005I[\u0015A\u0001>l\u0013\t!\u0016K\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0003\"\u0001\u0017\u0001\u000e\u0003%\u000bqa]3sm\u0016\u00148/F\u0001\\!\ra\u0016mY\u0007\u0002;*\u0011alX\u0001\u000bG>dG.Z2uS>t'\"\u00011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tl&aA*fcB\u0011AmZ\u0007\u0002K*\u0011amS\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005!,'aC&bM.\f7+\u001a:wKJ\f1b]3sm\u0016\u00148o\u0018\u0013fcR\u00111n\u001c\t\u0003Y6l\u0011aX\u0005\u0003]~\u0013A!\u00168ji\"9\u0001oAA\u0001\u0002\u0004Y\u0016a\u0001=%c\u0005A1/\u001a:wKJ\u001c\b%\u0001\u000bgSJ\u001cHoQ8oiJ|G\u000e\\3s\u000bB|7\r[\u000b\u0002iB\u0011A.^\u0005\u0003m~\u00131!\u00138u\u0003U1\u0017N]:u\u0007>tGO]8mY\u0016\u0014X\t]8dQ\u0002\nQDZ5sgR\u001cuN\u001c;s_2dWM]#q_\u000eD'l\u001b,feNLwN\\\u0001\u001fM&\u00148\u000f^\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195[WZ+'o]5p]\u0002\nQa]3u+B$\u0012a\u001b\u0015\u0003\u0013u\u00042A`A\b\u001b\u0005y(\u0002BA\u0001\u0003\u0007\t1!\u00199j\u0015\u0011\t)!a\u0002\u0002\u000f),\b/\u001b;fe*!\u0011\u0011BA\u0006\u0003\u0015QWO\\5u\u0015\t\ti!A\u0002pe\u001eL1!!\u0005\u0000\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001a!\"a\u0006\u0011\u0007y\fI\"C\u0002\u0002\u001c}\u0014\u0011\"\u00114uKJ,\u0015m\u00195\u0002!Q,7\u000f^#naRL8\t\\;ti\u0016\u0014\bfA\u0006\u0002\"A\u0019a0a\t\n\u0007\u0005\u0015rP\u0001\u0003UKN$\u0018!\f;fgR\u001cuN\u001c;s_2dWM]#q_\u000eD\u0007+\u001a:tSN$8o\u00165f]\u0006cGN\u0011:pW\u0016\u00148\u000fR8x]\"\u001aA\"!\t\u0002WQ,7\u000f^\"p]R\u0014x\u000e\u001c7fe6{g/Z%oGJ,W.\u001a8ug\u000e{g\u000e\u001e:pY2,'/\u00129pG\"D3!DA\u0011\u0003\u0015\"Xm\u001d;NKR\fG-\u0019;b!J|\u0007/Y4bi&|gn\u00148D_:$(o\u001c7QY\u0006tW\rK\u0002\u000f\u0003C\tQ\u0005^3ti6+G/\u00193bi\u0006\u0004&o\u001c9bO\u0006$\u0018n\u001c8P]\n\u0013xn[3s\u0007\"\fgnZ3)\u0007=\t\t#A\u0015uKN$X*\u001a;bI\u0006$\u0018\r\u0015:pa\u0006<\u0017\r^5p]\u001a{'o\u00144gY&tWMU3qY&\u001c\u0017m\u001d\u0015\u0004!\u0005\u0005\u0012!\u0005;fgR$v\u000e]5d\u0007J,\u0017\r^5p]\"\u001a\u0011#!\t\u0002GQ,7\u000f\u001e+pa&\u001c7I]3bi&|gnV5uQ>3g\r\\5oKJ+\u0007\u000f\\5dC\"\u001a!#!\t\u00027Q,7\u000f\u001e+pa&\u001c\u0007+\u0019:uSRLwN\\#ya\u0006t7/[8oQ\r\u0019\u0012\u0011E\u0001.i\u0016\u001cH\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0012=qC:\u001c\u0018n\u001c8XSRDwJ\u001a4mS:,'+\u001a9mS\u000e\f\u0007f\u0001\u000b\u0002\"\u0005IB/Z:u!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8uQ\r)\u0012\u0011E\u00013i\u0016\u001cH\u000fU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tG\u000fV8Ce>\\WM],ji\"|eM\u001a7j]\u0016dun\u001a#je\"\u001aa#!\t\u0002uQ,7\u000f\u001e)beRLG/[8o%\u0016\f7o]5h]6,g\u000e^,ji\"|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006D\u0015\r\u001c;j]\u001e\u0004&o\\4sKN\u001c\bfA\f\u0002\"\u00059D/Z:u!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8u%\u0016\u001cX/\\3t\u0003\u001a$XM\u001d*fa2L7-Y\"p[\u0016\u001cxJ\u001c7j]\u0016D3\u0001GA\u0011\u0003\t\"Xm\u001d;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC2+\u0017\rZ3s\u000b2,7\r^5p]\"\u001a\u0011$!\t\u0002[Q,7\u000f\u001e\"bG.$vNQ1dWB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fG*Z1eKJ,E.Z2uS>t7\u000fK\u0002\u001b\u0003C\tQ\b^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fG*Z1eKJ,E.Z2uS>tw+\u001b;i\u001f\u001a4G.\u001b8f!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006D3aGA\u0011\u0003\u0019\"Xm\u001d;BkR|\u0007K]3gKJ\u0014X\r\u001a*fa2L7-\u0019'fC\u0012,'/\u00127fGRLwN\u001c\u0015\u00049\u0005\u0005\u0012\u0001\u0012;fgRdU-\u00193fe\u0006sG-S:s/\",g.\u00128uSJ,\u0017j\u001d:PM\u001ad\u0017N\\3B]\u0012,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:$\u0015n]1cY\u0016$\u0007fA\u000f\u0002\"\u0005\u0019E/Z:u\u0019\u0016\fG-\u001a:B]\u0012L5O],iK:,e\u000e^5sK&\u001b(o\u00144gY&tW-\u00118e+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\u000b:\f'\r\\3eQ\rq\u0012\u0011E\u0001\u0017i\u0016\u001cHoQ8oiJ|G\u000e\\3e'\",H\u000fZ8x]\"\u001aq$!\t\u0002\u0003R,7\u000f^\"p]R\u0014x\u000e\u001c7feJ+'.Z2u\u0007>tGO]8mY\u0016$7\u000b[;uI><hNU3rk\u0016\u001cHoV5uQN#\u0018\r\\3Ce>\\WM]#q_\u000eD\u0007f\u0001\u0011\u0002\"\u0005\tC/Z:u\u0007>tGO]8mY\u0016\u0014Xj\u001c<f\u001f:$v\u000e]5d\u0007J,\u0017\r^5p]\"\u001a\u0011%!\t\u0002CQ,7\u000f^\"p]R\u0014x\u000e\u001c7fe6{g/Z(o)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8)\u0007\t\n\t#\u0001\u0017uKN$8i\u001c8ue>dG.\u001a:N_Z,wJ\u001c)sK\u001a,'O]3e%\u0016\u0004H.[2b\u000b2,7\r^5p]\"\u001a1%!\t\u0002SQ,7\u000f^\"p]R\u0014x\u000e\u001c7fe6{g/Z(o!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8uQ\r!\u0013\u0011E\u0001Yi\u0016\u001cHoQ8oiJ|G\u000e\\3s\r\u0016\fG/\u001e:f5:{G-Z*fiV\u0004x\u000b[3o\r\u0016\fG/\u001e:f-\u0016\u00148/[8oS:<\u0017j]#oC\ndW\rZ,ji\"tuN\\#ySN$\u0018N\\4GK\u0006$XO]3[\u001d>$W\rK\u0002&\u0003C\tQ\f^3ti\u000e{g\u000e\u001e:pY2,'OR3biV\u0014XM\u0017(pI\u0016\u001cV\r^;q/\",gNR3biV\u0014XMV3sg&|g.\u001b8h\u0013N,e.\u00192mK\u0012<\u0016\u000e\u001e5ESN\f'\r\\3e\u000bbL7\u000f^5oO\u001a+\u0017\r^;sKjsu\u000eZ3)\u0007\u0019\n\t#\u0001/uKN$8i\u001c8ue>dG.\u001a:GK\u0006$XO]3[\u001d>$WmU3ukB<\u0006.\u001a8GK\u0006$XO]3WKJ\u001c\u0018n\u001c8j]\u001eL5/\u00128bE2,GmV5uQ\u0016s\u0017M\u00197fI\u0016C\u0018n\u001d;j]\u001e4U-\u0019;ve\u0016Tfj\u001c3fQ\r9\u0013\u0011E\u0001Zi\u0016\u001cHoQ8oiJ|G\u000e\\3s\r\u0016\fG/\u001e:f5:{G-Z*fiV\u0004x\u000b[3o\r\u0016\fG/\u001e:f-\u0016\u00148/[8oS:<\u0017j\u001d#jg\u0006\u0014G.\u001a3XSRDgj\u001c8Fq&\u001cH/\u001b8h\r\u0016\fG/\u001e:f5:{G-\u001a\u0015\u0004Q\u0005\u0005\u0012A\u0018;fgR\u001cuN\u001c;s_2dWM\u001d$fCR,(/\u001a.O_\u0012,7+\u001a;va^CWM\u001c$fCR,(/\u001a,feNLwN\\5oO&\u001bH)[:bE2,GmV5uQ\u0012K7/\u00192mK\u0012,\u00050[:uS:<g)Z1ukJ,'LT8eK\"\u001a\u0011&!\t\u0002;R,7\u000f^\"p]R\u0014x\u000e\u001c7fe\u001a+\u0017\r^;sKjsu\u000eZ3TKR,\bo\u00165f]\u001a+\u0017\r^;sKZ+'o]5p]&tw-S:ESN\f'\r\\3e/&$\b.\u00128bE2,G-\u0012=jgRLgn\u001a$fCR,(/\u001a.O_\u0012,\u0007f\u0001\u0016\u0002\"\u0005\u0019C/Z:u\u0007>tGO]8mY\u0016\u0014H)\u001a;fGR\u001c(i\\;oG\u0016$'I]8lKJ\u001c\bfA\u0016\u0002\"\u0005\u0011C/Z:u!J,W-\u001c9uS>twJ\\\"p]R\u0014x\u000e\u001c7feNCW\u000f\u001e3po:D3\u0001LA\u0011\u0003m!Xm\u001d;Qe\u0016,W\u000e\u001d;j_:<\u0016\u000e\u001e5DC2d'-Y2lg\"\u001aQ&!\t\u0002?Q,7\u000f^\"p]R\u0014x\u000e\u001c7fe\u001a+\u0017\r^;sKjsu\u000eZ3TKR,\b\u000fF\u0003l\u0003g\u000b\u0019\rC\u0004\u00026:\u0002\r!a.\u0002\u0019%t\u0017\u000e^5bYjsu\u000eZ3\u0011\u000b1\fI,!0\n\u0007\u0005mvL\u0001\u0004PaRLwN\u001c\t\u0004!\u0006}\u0016bAAa#\naa)Z1ukJ,'LT8eK\"9\u0011Q\u0019\u0018A\u0002\u0005\u001d\u0017AG5oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>dg+\u001a:tS>t\u0007\u0003BAe\u0003\u001bl!!a3\u000b\u0007\u0005\u00051*\u0003\u0003\u0002P\u0006-'AC!qSZ+'o]5p]\u00061B/Z:u\u0013\u0012,W\u000e]8uK:$\u0018\t\u001c;fe&\u001b(\u000fK\u00020\u0003C\tA\u0003^3tiR{\u0007/[2JIN\f%/Z!eI\u0016$\u0007f\u0001\u0019\u0002\"\u00059B/Z:u)>\u0004\u0018nY%eg\u0006\u0013XMT8u\u0003\u0012$W\r\u001a\u0015\u0004c\u0005\u0005\u0012a\b;fgR$v\u000e]5d\u0013\u0012l\u0015n\u001a:bi&|g.\u00118e\u0011\u0006tG\r\\5oO\"\u001a!'!\t\u0002_Q,7\u000f\u001e+pa&\u001c\u0017\nZ'jOJ\fG/[8o\u0003:$\u0007*\u00198eY&twmV5uQ>cG-\u001a:WKJ\u001c\u0018n\u001c8)\u0007M\n\t#\u0001\u0018uKN$Hk\u001c9jG&#\u0007+\u001a:tSN$8\u000f\u00165s_V<\u0007nQ8oiJ|G\u000e\\3s%\u0016,G.Z2uS>t\u0007f\u0001\u001b\u0002\"\u0005\u0001D/Z:u\u001d>$v\u000e]5d\u0013\u0012\u0004VM]:jgR\u001cH\u000b\u001b:pk\u001eD7i\u001c8ue>dG.\u001a:SK\u0016dWm\u0019;j_:D3!NA\u0011\u0003-\"Xm\u001d;U_BL7-\u00133QKJ\u001c\u0018n\u001d;t)\"\u0014x.^4i\u0007>tGO]8mY\u0016\u0014(+Z:uCJ$\bf\u0001\u001c\u0002\"\u0005YB/Z:u)>\u0004\u0018nY%e\u0007J,\u0017\r^3e\u001f:,\u0006o\u001a:bI\u0016D3aNA\u0011\u0003I!Xm\u001d;D_:$(o\u001c7mKJluN^3\u0015\u0007-\fI\u0010C\u0004\u0002|b\u0002\r!!@\u0002\u0007\u0019,h\u000e\u0005\u0003m\u0003\u007f\\\u0017b\u0001B\u0001?\nIa)\u001e8di&|g\u000eM\u0001\u001faJ,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006dU-\u00193fe\u0016cWm\u0019;j_:$2b\u001bB\u0004\u0005\u0017\u0011yA!\n\u0003@!1!\u0011B\u001dA\u0002Q\fAbY8oiJ|G\u000e\\3s\u0013\u0012DaA!\u0004:\u0001\u0004\u0019\u0017aC8uQ\u0016\u0014(I]8lKJDqA!\u0005:\u0001\u0004\u0011\u0019\"\u0001\u0002uaB!!Q\u0003B\u0011\u001b\t\u00119B\u0003\u0003\u0003\u001a\tm\u0011AB2p[6|gNC\u0002M\u0005;QAAa\b\u0002\f\u00051\u0011\r]1dQ\u0016LAAa\t\u0003\u0018\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007b\u0002B\u0014s\u0001\u0007!\u0011F\u0001\te\u0016\u0004H.[2bgB)!1\u0006B\u001di:!!Q\u0006B\u001b!\r\u0011ycX\u0007\u0003\u0005cQ1Aa\rN\u0003\u0019a$o\\8u}%\u0019!qG0\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011YD!\u0010\u0003\u0007M+GOC\u0002\u00038}CaA!\u0011:\u0001\u0004!\u0018a\u00037fC\u0012,'/\u00129pG\"\f\u0001d^1jiVsG/\u001b7D_:$(o\u001c7mKJ,\u0005o\\2i)\u0015Y'q\tB&\u0011\u0019\u0011IE\u000fa\u0001i\u0006)Q\r]8dQ\"9!Q\n\u001eA\u0002\t=\u0013aB7fgN\fw-\u001a\t\u0005\u0005W\u0011\t&\u0003\u0003\u0003T\tu\"AB*ue&tw-A\u000bxC&$hi\u001c:QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0015\u0017-\u0014IFa\u0017\u0003`\t\r$Q\r\u0005\b\u0005#Y\u0004\u0019\u0001B\n\u0011\u0019\u0011if\u000fa\u0001i\u0006y1m\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000e\u0003\u0004\u0003bm\u0002\r\u0001^\u0001\u0007Y\u0016\fG-\u001a:\t\r\t\u00053\b1\u0001u\u0011\u001d\u0011ie\u000fa\u0001\u0005\u001f\n\u0001$[:FqB,7\r^3e!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f))\u0011YG!\u001d\u0003|\tu$q\u0010\t\u0004Y\n5\u0014b\u0001B8?\n9!i\\8mK\u0006t\u0007b\u0002B:y\u0001\u0007!QO\u0001\u001cY\u0016\fG-\u001a:JgJ\fe\u000eZ\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\u0011\u0007a\u00139(C\u0002\u0003z%\u00131\u0004T3bI\u0016\u0014\u0018j\u001d:B]\u0012\u001cuN\u001c;s_2dWM]#q_\u000eD\u0007B\u0002B/y\u0001\u0007A\u000f\u0003\u0004\u0003bq\u0002\r\u0001\u001e\u0005\u0007\u0005\u0003b\u0004\u0019\u0001;\u0002\u00175\f7.Z*feZ,'o\u001d\u000b\u00147\n\u0015%\u0011\u0012BG\u0005#\u0013)Ja'\u0003 \n\r&q\u0015\u0005\u0007\u0005\u000fk\u0004\u0019\u0001;\u0002\u00159,XnQ8oM&<7\u000fC\u0005\u0003\fv\u0002\n\u00111\u0001\u0003l\u0005I\u0012-\u001e;p\u0019\u0016\fG-\u001a:SK\n\fG.\u00198dK\u0016s\u0017M\u00197f\u0011%\u0011y)\u0010I\u0001\u0002\u0004\u0011Y'A\u000ev]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8F]\u0006\u0014G.\u001a\u0005\n\u0005'k\u0004\u0013!a\u0001\u0005W\n\u0001$\u001a8bE2,7i\u001c8ue>dG.\u001a3TQV$Hm\\<o\u0011%\u00119*\u0010I\u0001\u0002\u0004\u0011I*A\u0005mSN$XM\\3sgB)A.!/\u0003P!I!QT\u001f\u0011\u0002\u0003\u0007!\u0011T\u0001\u001cY&\u001cH/\u001a8feN+7-\u001e:jif\u0004&o\u001c;pG>dW*\u00199\t\u0013\t\u0005V\b%AA\u0002\te\u0015\u0001G2p]R\u0014x\u000e\u001c)mC:,G*[:uK:,'OT1nK\"I\u0011QY\u001f\u0011\u0002\u0003\u0007!Q\u0015\t\u0006Y\u0006e\u0016q\u0019\u0005\t\u0005Sk\u0004\u0013!a\u0001i\u0006YAn\\4ESJ\u001cu.\u001e8u\u0003Ui\u0017m[3TKJ4XM]:%I\u00164\u0017-\u001e7uII*\"Aa,+\t\t-$\u0011W\u0016\u0003\u0005g\u0003BA!.\u0003@6\u0011!q\u0017\u0006\u0005\u0005s\u0013Y,A\u0005v]\u000eDWmY6fI*\u0019!QX0\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003B\n]&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006)R.Y6f'\u0016\u0014h/\u001a:tI\u0011,g-Y;mi\u0012\u001a\u0014!F7bW\u0016\u001cVM\u001d<feN$C-\u001a4bk2$H\u0005N\u0001\u0016[\u0006\\WmU3sm\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011YM\u000b\u0003\u0003\u001a\nE\u0016!F7bW\u0016\u001cVM\u001d<feN$C-\u001a4bk2$HEN\u0001\u0016[\u0006\\WmU3sm\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00138\u0003Ui\u0017m[3TKJ4XM]:%I\u00164\u0017-\u001e7uIa*\"A!6+\t\t\u0015&\u0011W\u0001\u0016[\u0006\\WmU3sm\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u0013:+\t\u0011YNK\u0002u\u0005c\u000bQ\u0001^5nKJ$BA!9\u0003zB!!1\u001dB{\u001b\t\u0011)O\u0003\u0003\u0003h\n%\u0018\u0001B2pe\u0016TAAa;\u0003n\u00069Q.\u001a;sS\u000e\u001c(\u0002\u0002Bx\u0005c\fa!_1n[\u0016\u0014(B\u0001Bz\u0003\r\u0019w.\\\u0005\u0005\u0005o\u0014)OA\u0003US6,'\u000fC\u0004\u0003|\u001a\u0003\rAa\u0014\u0002\u00155,GO]5d\u001d\u0006lW-A\u0007hKR\u001cuN\u001c;s_2dWM\u001d\u000b\u0002G\u0002")
public class ControllerIntegrationTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final int firstControllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() + 1;
    private final int firstControllerEpochZkVersion = KafkaController$.MODULE$.InitialControllerEpochZkVersion() + 1;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int firstControllerEpoch() {
        return this.firstControllerEpoch;
    }

    public int firstControllerEpochZkVersion() {
        return this.firstControllerEpochZkVersion;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.empty()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testEmptyCluster() {
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testEmptyCluster$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"failed to elect a controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
    }

    @Test
    public void testControllerEpochPersistsWhenAllBrokersDown() {
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerEpochPersistsWhenAllBrokersDown$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"failed to elect a controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerEpochPersistsWhenAllBrokersDown$3(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"failed to kill controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "controller epoch was not persisted after broker failure");
    }

    @Test
    public void testControllerMoveIncrementsControllerEpoch() {
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerMoveIncrementsControllerEpoch$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"failed to elect a controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        ((KafkaServer)this.servers().head()).startup();
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerMoveIncrementsControllerEpoch$3(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"failed to elect a controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        this.waitUntilControllerEpoch(this.firstControllerEpoch() + 1, "controller epoch was not incremented after controller move");
    }

    @Test
    public void testMetadataPropagationOnControlPlane() {
        None$ none$;
        Some x$2 = new Some((Object)"PLAINTEXT://localhost:0,CONTROLLER://localhost:0");
        Some x$3 = new Some((Object)"PLAINTEXT:PLAINTEXT,CONTROLLER:PLAINTEXT");
        Some x$4 = new Some((Object)"CONTROLLER");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$2;
        int n = 1;
        this.servers_$eq(this.makeServers(1, bl, bl2, bl3, (Option<String>)x$2, (Option<String>)x$3, (Option<String>)x$4, (Option<ApiVersion>)x$8, n));
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), 15000L);
        scala.collection.mutable.Map controlPlaneMetricMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map dataPlaneMetricMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ((KafkaServer)this.servers().head()).metrics().metrics().values().forEach(kafkaMetric -> {
            if (kafkaMetric.metricName().tags().values().contains("CONTROLLER")) {
                controlPlaneMetricMap.put((Object)kafkaMetric.metricName().name(), kafkaMetric);
            }
            if (kafkaMetric.metricName().tags().values().contains("PLAINTEXT")) {
                dataPlaneMetricMap.put((Object)kafkaMetric.metricName().name(), kafkaMetric);
            }
        });
        Assertions.assertEquals((double)1.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.apply((Object)"response-total")).metricValue()), (double)0.0);
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.apply((Object)"response-total")).metricValue()), (double)0.0);
        Assertions.assertEquals((double)1.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.apply((Object)"request-total")).metricValue()), (double)0.0);
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.apply((Object)"request-total")).metricValue()), (double)0.0);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.apply((Object)"incoming-byte-total")).metricValue()) > 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.apply((Object)"incoming-byte-total")).metricValue()) == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.apply((Object)"network-io-total")).metricValue()) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.apply((Object)"network-io-total")).metricValue()) == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testMetadataPropagationOnBrokerChange() {
        this.servers_$eq(this.makeServers(3, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), 15000L);
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaServer testBroker = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$1(controllerId, e)))).head();
        Seq remainingBrokers = (Seq)this.servers().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$2(testBroker, x$1)));
        String topic = "topic1";
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaServer)remainingBrokers.apply(0)).config().brokerId(), testBroker.config().brokerId()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), remainingBrokers.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$3(x$2))))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)assignment, this.servers());
        testBroker.shutdown();
        testBroker.awaitShutdown();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)remainingBrokers, 15000L);
        remainingBrokers.foreach((Function1 & Serializable)server -> {
            ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$4(topic, testBroker, assignment, remainingBrokers, server);
            return BoxedUnit.UNIT;
        });
        testBroker.startup();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$5(this, assignment, topic)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Inconsistent metadata after broker startup");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    @Test
    public void testMetadataPropagationForOfflineReplicas() {
        this.servers_$eq(this.makeServers(3, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), 15000L);
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaServer replicaBroker = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationForOfflineReplicas$1(controllerId, e)))).head();
        KafkaServer controllerBroker = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationForOfflineReplicas$2(controllerId, e)))).head();
        KafkaServer otherBroker = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationForOfflineReplicas$3(controllerId, replicaBroker, e)))).head();
        String topic = "topic1";
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{replicaBroker.config().brokerId()})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)assignment, this.servers());
        otherBroker.shutdown();
        otherBroker.awaitShutdown();
        replicaBroker.shutdown();
        replicaBroker.awaitShutdown();
        controllerBroker.shutdown();
        controllerBroker.awaitShutdown();
        ControllerIntegrationTest.verifyMetadata$1(controllerBroker, topic);
        ControllerIntegrationTest.verifyMetadata$1(otherBroker, topic);
    }

    @Test
    public void testTopicCreation() {
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
    }

    @Test
    public void testTopicCreationWithOfflineReplica() {
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.servers().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testTopicCreationWithOfflineReplica$1(x$3)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> x$4 != controllerId)).head());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, (Seq<KafkaServer>)((Seq)this.servers().take(1)));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicPartitionExpansion() {
        void apply_removingReplicas;
        void apply_addingReplicas;
        void apply_removingReplicas2;
        void apply_addingReplicas2;
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        TopicPartition tp0 = new TopicPartition("t", 0);
        TopicPartition tp1 = new TopicPartition("t", 1);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}));
        Object[] objectArray = new Tuple2[2];
        Nil$ nil$ = Nil$.MODULE$;
        Nil$ nil$2 = Nil$.MODULE$;
        Seq apply_replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        Object var5_6 = null;
        nil$2 = null;
        nil$ = null;
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)new ReplicaAssignment(apply_replicas, (Seq)apply_addingReplicas2, (Seq)apply_removingReplicas2));
        Nil$ nil$3 = Nil$.MODULE$;
        Nil$ nil$4 = Nil$.MODULE$;
        Seq apply_replicas2 = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        Object var8_9 = null;
        nil$4 = null;
        nil$3 = null;
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)new ReplicaAssignment(apply_replicas2, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas));
        Map expandedAssignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp0.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.zkClient().setTopicAssignment(tp0.topic(), (Option)new Some((Object)Uuid.randomUuid()), expandedAssignment, this.firstControllerEpochZkVersion());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic partition expansion");
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), tp1.topic(), tp1.partition(), 15000L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicPartitionExpansionWithOfflineReplica() {
        void apply_removingReplicas;
        void apply_addingReplicas;
        void apply_removingReplicas2;
        void apply_addingReplicas2;
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.servers().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testTopicPartitionExpansionWithOfflineReplica$1(x$5)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$6 -> x$6 != controllerId)).head());
        TopicPartition tp0 = new TopicPartition("t", 0);
        TopicPartition tp1 = new TopicPartition("t", 1);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        Object[] objectArray = new Tuple2[2];
        Nil$ nil$ = Nil$.MODULE$;
        Nil$ nil$2 = Nil$.MODULE$;
        Seq apply_replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId}));
        Object var7_8 = null;
        nil$2 = null;
        nil$ = null;
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)new ReplicaAssignment(apply_replicas, (Seq)apply_addingReplicas2, (Seq)apply_removingReplicas2));
        Nil$ nil$3 = Nil$.MODULE$;
        Nil$ nil$4 = Nil$.MODULE$;
        Seq apply_replicas2 = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId}));
        Object var10_11 = null;
        nil$4 = null;
        nil$3 = null;
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)new ReplicaAssignment(apply_replicas2, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas));
        Map expandedAssignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp0.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().setTopicAssignment(tp0.topic(), (Option)new Some((Object)Uuid.randomUuid()), expandedAssignment, this.firstControllerEpochZkVersion());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic partition expansion");
        TestUtils$.MODULE$.waitForPartitionMetadata((Seq<KafkaServer>)new .colon.colon((Object)((KafkaServer)this.servers().apply(controllerId)), (List)Nil$.MODULE$), tp1.topic(), tp1.partition(), 15000L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionReassignment() {
        void apply_removingReplicas;
        void apply_addingReplicas;
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        String metricName = new StringBuilder(43).append("kafka.controller:type=ControllerStats,name=").append(new Some((Object)"PartitionReassignmentRateAndTimeMs").get()).toString();
        long timerCount = this.timer(metricName).count();
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.servers().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignment$1(x$7)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$8 -> x$8 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        Object[] objectArray = new Tuple2[1];
        Seq seq = (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Seq seq2 = (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Seq apply_replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId}));
        Object var15_9 = null;
        seq2 = null;
        seq = null;
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new ReplicaAssignment(apply_replicas, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas));
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.zkClient().createPartitionReassignment((Map)reassignment.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.replicas());
            return tuple2;
        }));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 3, "failed to get expected partition state after partition reassignment");
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignment$4(this, tp, reassignment)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"failed to get updated partition assignment on topic znode after partition reassignment");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignment$6(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"failed to remove reassign partitions path after completion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        long updatedTimerCount = this.timer(metricName).count();
        Assertions.assertTrue((updatedTimerCount > timerCount ? 1 : 0) != 0, (String)new StringBuilder(36).append("Timer count ").append(updatedTimerCount).append(" should be greater than ").append(timerCount).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionReassignmentToBrokerWithOfflineLogDir() {
        void apply_removingReplicas;
        void apply_addingReplicas;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$92 = none$8;
        this.servers_$eq(this.makeServers(2, bl, bl2, bl3, (Option<String>)x$6, (Option<String>)x$7, (Option<String>)x$8, (Option<ApiVersion>)x$92, 2));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        String metricName = new StringBuilder(43).append("kafka.controller:type=ControllerStats,name=").append(new Some((Object)"PartitionReassignmentRateAndTimeMs").get()).toString();
        long timerCount = this.timer(metricName).count();
        KafkaServer otherBroker = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$1(controllerId, x$9)))).head();
        int otherBrokerId = otherBroker.config().brokerId();
        TopicPartition topicPartitionToPutOffline = new TopicPartition("filler", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topicPartitionToPutOffline.topic(), (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartitionToPutOffline.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}))), this.servers());
        TestUtils$.MODULE$.causeLogDirFailure(TestUtils$Checkpoint$.MODULE$, otherBroker, topicPartitionToPutOffline);
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        Object[] objectArray = new Tuple2[1];
        Seq seq = (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Seq seq2 = (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Seq apply_replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId}));
        Object var21_22 = null;
        seq2 = null;
        seq = null;
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new ReplicaAssignment(apply_replicas, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas));
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.zkClient().createPartitionReassignment((Map)reassignment.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.replicas());
            return tuple2;
        }));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 3, "with an offline log directory on the target broker, the partition reassignment stalls");
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$3(this, tp, reassignment)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"failed to get updated partition assignment on topic znode after partition reassignment");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$5(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"failed to remove reassign partitions path after completion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        long updatedTimerCount = this.timer(metricName).count();
        Assertions.assertTrue((updatedTimerCount > timerCount ? 1 : 0) != 0, (String)new StringBuilder(36).append("Timer count ").append(updatedTimerCount).append(" should be greater than ").append(timerCount).toString());
    }

    @Test
    public void testPartitionReassignmentWithOfflineReplicaHaltingProgress() {
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.servers().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$1(x$10)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$11 -> x$11 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        KafkaServer controller = this.getController();
        this.zkClient().setOrCreatePartitionReassignment(reassignment, controller.kafkaController().controllerContext().epochZkVersion());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state during partition reassignment with offline replica");
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$3(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"partition reassignment path should remain while reassignment in progress");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionReassignmentResumesAfterReplicaComesOnline() {
        void apply_removingReplicas;
        void apply_addingReplicas;
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.servers().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$1(x$12)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$13 -> x$13 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        Object[] objectArray = new Tuple2[1];
        Seq seq = (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Seq seq2 = (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Seq apply_replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId}));
        Object var10_7 = null;
        seq2 = null;
        seq = null;
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new ReplicaAssignment(apply_replicas, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas));
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().createPartitionReassignment((Map)reassignment.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.replicas());
            return tuple2;
        }));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state during partition reassignment with offline replica");
        ((KafkaServer)this.servers().apply(otherBrokerId)).startup();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 4, "failed to get expected partition state after partition reassignment");
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$4(this, tp, reassignment)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"failed to get updated partition assignment on topic znode after partition reassignment");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$6(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"failed to remove reassign partitions path after completion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
    }

    @Test
    public void testPreferredReplicaLeaderElection() {
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testPreferredReplicaLeaderElection$1(controllerId, x$14))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((IterableOnceOps)assignment.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch());
    }

    @Test
    public void testBackToBackPreferredReplicaLeaderElections() {
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testBackToBackPreferredReplicaLeaderElections$1(controllerId, x$15))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((IterableOnceOps)assignment.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((IterableOnceOps)assignment.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2);
    }

    @Test
    public void testPreferredReplicaLeaderElectionWithOfflinePreferredReplica() {
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.servers().map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$1(x$16)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$17 -> x$17 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$3(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"failed to remove preferred replica leader election path after giving up");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state upon broker shutdown");
    }

    @Test
    public void testAutoPreferredReplicaLeaderElection() {
        this.servers_$eq(this.makeServers(2, true, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.servers().map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testAutoPreferredReplicaLeaderElection$1(x$18)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$19 -> x$19 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state upon broker shutdown");
        ((KafkaServer)this.servers().apply(otherBrokerId)).startup();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2, "failed to get expected partition state upon broker startup");
    }

    @Test
    public void testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled() {
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.servers().map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$1(x$20)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$21 -> x$21 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$3(this, tp, otherBrokerId)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"failed to get expected partition state after entire isr went offline");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    @Test
    public void testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        boolean bl = false;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$5 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$6 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$7 = none$7;
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$8;
        int n = 1;
        this.servers_$eq(this.makeServers(2, bl, true, bl2, (Option<String>)x$5, (Option<String>)x$6, (Option<String>)x$7, (Option<ApiVersion>)x$8, n));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.servers().map((Function1 & Serializable)x$22 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$1(x$22)))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$23 -> x$23 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$3(this, tp, otherBrokerId)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"failed to get expected partition state after entire isr went offline");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControlledShutdown() {
        void var13_17;
        Map expectedReplicaAssignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 0;
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
        this.servers_$eq((Seq<KafkaServer>)((Seq)((IterableOps)serverConfigs.reverse()).map((Function1 & Serializable)s -> {
            Time time;
            Time time2 = time = Time.SYSTEM;
            time = null;
            Time createServer_time = time2;
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            return createServer_this.createServer((KafkaConfig)s, createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false);
        })));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().get());
        KafkaController controller = ((KafkaServer)this.servers().find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$3(controllerId, p))).get()).kafkaController();
        LinkedBlockingQueue resultQueue = new LinkedBlockingQueue();
        Function1 & Serializable controlledShutdownCallback = (Function1 & Serializable)controlledShutdownResult -> {
            resultQueue.put(controlledShutdownResult);
            return BoxedUnit.UNIT;
        };
        controller.controlledShutdown(2, ((KafkaServer)this.servers().find((Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$5(x$24))).get()).kafkaController().brokerEpoch(), (Function1)controlledShutdownCallback);
        Set partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        Seq seq = (Seq)this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$6(s)));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!seq.forall((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$8(topic$3, partition$1, x$25)))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Topic test not created after timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Assertions.assertEquals((int)0, (int)partitionsRemaining.size());
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionStateInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaServer)seq.head()).dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic, partition).get();
        int leaderAfterShutdown = partitionStateInfo.leader();
        Assertions.assertEquals((int)0, (int)leaderAfterShutdown);
        Assertions.assertEquals((int)2, (int)partitionStateInfo.isr().size());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionStateInfo.isr()).asScala());
        controller.controlledShutdown(1, ((KafkaServer)this.servers().find((Function1 & Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$10(x$26))).get()).kafkaController().brokerEpoch(), (Function1)controlledShutdownCallback);
        Try try_ = (Try)resultQueue.take();
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                throw new AssertionError("Controlled shutdown failed due to error", exception);
            }
            throw new MatchError((Object)try_);
        }
        Set partitions = (Set)((Success)try_).value();
        partitionsRemaining = var13_17;
        Assertions.assertEquals((int)0, (int)partitionsRemaining.size());
        seq = (Seq)this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$11(s)));
        partitionStateInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaServer)seq.head()).dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic, partition).get();
        leaderAfterShutdown = partitionStateInfo.leader();
        Assertions.assertEquals((int)0, (int)leaderAfterShutdown);
        Assertions.assertTrue((boolean)this.servers().forall((Function1 & Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$12(topic, partition, x$27))));
        controller.controlledShutdown(0, ((KafkaServer)this.servers().find((Function1 & Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$13(x$28))).get()).kafkaController().brokerEpoch(), (Function1)controlledShutdownCallback);
        partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        Assertions.assertEquals((int)1, (int)partitionsRemaining.size());
        Assertions.assertTrue((boolean)this.servers().forall((Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$14(topic, partition, x$29))));
    }

    @Test
    public void testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch() {
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
        this.servers_$eq((Seq<KafkaServer>)((Seq)((IterableOps)serverConfigs.reverse()).map((Function1 & Serializable)s -> {
            Time time;
            Time time2 = time = Time.SYSTEM;
            time = null;
            Time createServer_time = time2;
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            return createServer_this.createServer((KafkaConfig)s, createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false);
        })));
        KafkaController controller = this.getController().kafkaController();
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$3(controller, e))).get();
        VolatileBooleanRef staleBrokerEpochDetected = VolatileBooleanRef.create((boolean)false);
        controller.controlledShutdown(otherBroker.config().brokerId(), otherBroker.kafkaController().brokerEpoch() - 1L, (Function1 & Serializable)x0$1 -> {
            ControllerIntegrationTest.$anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$4(staleBrokerEpochDetected, x0$1);
            return BoxedUnit.UNIT;
        });
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!staleBrokerEpochDetected.elem) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Fail to detect stale broker epoch");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    @Test
    public void testControllerMoveOnTopicCreation() {
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}));
        KafkaController testControllerMove_controller = this.getController().kafkaController();
        LogCaptureAppender testControllerMove_appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level testControllerMove_previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.getClass(), Level.INFO);
        try {
            long l = 15000L;
            long l2 = 100L;
            long testControllerMove_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$1(testControllerMove_controller)) {
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"Controller event thread is still busy");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            CountDownLatch testControllerMove_latch = new CountDownLatch(1);
            testControllerMove_controller.eventManager().put((ControllerEvent)new MockEvent(null, testControllerMove_latch){
                private final CountDownLatch latch$6;

                public void process() {
                    this.latch$6.await();
                }

                public void preempt() {
                }
                {
                    this.latch$6 = latch$6;
                    super((ControllerState)ControllerState.TopicChange$.MODULE$);
                }
            });
            ControllerIntegrationTest.$anonfun$testControllerMoveOnTopicCreation$1(this, tp, assignment);
            this.zkClient().deleteController(testControllerMove_controller.controllerContext().epochZkVersion());
            this.zkClient().registerControllerAndIncrementControllerEpoch(this.servers().size());
            testControllerMove_latch.countDown();
            long l3 = 15000L;
            long l4 = 100L;
            long testControllerMove_waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$3(testControllerMove_controller)) {
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime2 + l3) {
                    Assertions.fail((String)"Controller fails to resign");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
            }
            Assertions.assertTrue((boolean)testControllerMove_appender.getMessages().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e))).isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(testControllerMove_appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.eventManager().thread().getClass(), testControllerMove_previousLevel);
        }
    }

    @Test
    public void testControllerMoveOnTopicDeletion() {
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        KafkaController testControllerMove_controller = this.getController().kafkaController();
        LogCaptureAppender testControllerMove_appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level testControllerMove_previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.getClass(), Level.INFO);
        try {
            long l = 15000L;
            long l2 = 100L;
            long testControllerMove_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$1(testControllerMove_controller)) {
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"Controller event thread is still busy");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            CountDownLatch testControllerMove_latch = new CountDownLatch(1);
            testControllerMove_controller.eventManager().put((ControllerEvent)new /* invalid duplicate definition of identical inner class */);
            ControllerIntegrationTest.$anonfun$testControllerMoveOnTopicDeletion$1(this, tp);
            this.zkClient().deleteController(testControllerMove_controller.controllerContext().epochZkVersion());
            this.zkClient().registerControllerAndIncrementControllerEpoch(this.servers().size());
            testControllerMove_latch.countDown();
            long l3 = 15000L;
            long l4 = 100L;
            long testControllerMove_waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$3(testControllerMove_controller)) {
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime2 + l3) {
                    Assertions.fail((String)"Controller fails to resign");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
            }
            Assertions.assertTrue((boolean)testControllerMove_appender.getMessages().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e))).isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(testControllerMove_appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.eventManager().thread().getClass(), testControllerMove_previousLevel);
        }
    }

    @Test
    public void testControllerMoveOnPreferredReplicaElection() {
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        KafkaController testControllerMove_controller = this.getController().kafkaController();
        LogCaptureAppender testControllerMove_appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level testControllerMove_previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.getClass(), Level.INFO);
        try {
            long l = 15000L;
            long l2 = 100L;
            long testControllerMove_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$1(testControllerMove_controller)) {
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"Controller event thread is still busy");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            CountDownLatch testControllerMove_latch = new CountDownLatch(1);
            testControllerMove_controller.eventManager().put((ControllerEvent)new /* invalid duplicate definition of identical inner class */);
            ControllerIntegrationTest.$anonfun$testControllerMoveOnPreferredReplicaElection$1(this, tp);
            this.zkClient().deleteController(testControllerMove_controller.controllerContext().epochZkVersion());
            this.zkClient().registerControllerAndIncrementControllerEpoch(this.servers().size());
            testControllerMove_latch.countDown();
            long l3 = 15000L;
            long l4 = 100L;
            long testControllerMove_waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$3(testControllerMove_controller)) {
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime2 + l3) {
                    Assertions.fail((String)"Controller fails to resign");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
            }
            Assertions.assertTrue((boolean)testControllerMove_appender.getMessages().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e))).isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(testControllerMove_appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.eventManager().thread().getClass(), testControllerMove_previousLevel);
        }
    }

    @Test
    public void testControllerMoveOnPartitionReassignment() {
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}));
        KafkaController testControllerMove_controller = this.getController().kafkaController();
        LogCaptureAppender testControllerMove_appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level testControllerMove_previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.getClass(), Level.INFO);
        try {
            long l = 15000L;
            long l2 = 100L;
            long testControllerMove_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$1(testControllerMove_controller)) {
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"Controller event thread is still busy");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            CountDownLatch testControllerMove_latch = new CountDownLatch(1);
            testControllerMove_controller.eventManager().put((ControllerEvent)new /* invalid duplicate definition of identical inner class */);
            ControllerIntegrationTest.$anonfun$testControllerMoveOnPartitionReassignment$1(this, reassignment);
            this.zkClient().deleteController(testControllerMove_controller.controllerContext().epochZkVersion());
            this.zkClient().registerControllerAndIncrementControllerEpoch(this.servers().size());
            testControllerMove_latch.countDown();
            long l3 = 15000L;
            long l4 = 100L;
            long testControllerMove_waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$3(testControllerMove_controller)) {
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime2 + l3) {
                    Assertions.fail((String)"Controller fails to resign");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
            }
            Assertions.assertTrue((boolean)testControllerMove_appender.getMessages().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e))).isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(testControllerMove_appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.eventManager().thread().getClass(), testControllerMove_previousLevel);
        }
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsEnabledWithNonExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)Option$.MODULE$.empty(), (ApiVersion)KAFKA_2_7_IV0$.MODULE$);
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsEnabledWithDisabledExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)new Some((Object)new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Disabled$.MODULE$, Features.emptyFinalizedFeatures())), (ApiVersion)KAFKA_2_7_IV0$.MODULE$);
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsEnabledWithEnabledExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)new Some((Object)new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, Features.emptyFinalizedFeatures())), (ApiVersion)KAFKA_2_7_IV0$.MODULE$);
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsDisabledWithNonExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)Option$.MODULE$.empty(), (ApiVersion)KAFKA_2_6_IV0$.MODULE$);
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsDisabledWithDisabledExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)new Some((Object)new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Disabled$.MODULE$, Features.emptyFinalizedFeatures())), (ApiVersion)KAFKA_2_6_IV0$.MODULE$);
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsDisabledWithEnabledExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)new Some((Object)new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, Features.emptyFinalizedFeatures())), (ApiVersion)KAFKA_2_6_IV0$.MODULE$);
    }

    @Test
    public void testControllerDetectsBouncedBrokers() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        boolean bl = false;
        boolean bl2 = false;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$5 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$6 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$7 = none$7;
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$8;
        int n = 1;
        this.servers_$eq(this.makeServers(2, bl, bl2, false, (Option<String>)x$5, (Option<String>)x$6, (Option<String>)x$7, (Option<ApiVersion>)x$8, n));
        KafkaController controller = this.getController().kafkaController();
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerDetectsBouncedBrokers$1(controller, e))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerDetectsBouncedBrokers$2(controller)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Controller event thread is still busy");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        CountDownLatch latch = new CountDownLatch(1);
        controller.eventManager().put((ControllerEvent)new MockEvent(null, latch){
            private final CountDownLatch latch$1;

            public void process() {
                this.latch$1.await();
            }

            public void preempt() {
            }
            {
                this.latch$1 = latch$1;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        });
        otherBroker.shutdown();
        otherBroker.startup();
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)otherBroker.replicaManager().partitionCount().value()));
        latch.countDown();
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerDetectsBouncedBrokers$4(otherBroker)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"Broker fail to initialize after restart");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
    }

    @Test
    public void testPreemptionOnControllerShutdown() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        boolean bl = false;
        boolean bl2 = false;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$5 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$6 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$7 = none$7;
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$8;
        int n = 1;
        this.servers_$eq(this.makeServers(1, bl, bl2, false, (Option<String>)x$5, (Option<String>)x$6, (Option<String>)x$7, (Option<ApiVersion>)x$8, n));
        KafkaController controller = this.getController().kafkaController();
        IntRef count = IntRef.create((int)2);
        CountDownLatch latch = new CountDownLatch(1);
        ControllerEventManager.ControllerEventThread spyThread = (ControllerEventManager.ControllerEventThread)Mockito.spy((Object)controller.eventManager().thread());
        controller.eventManager().thread_$eq(spyThread);
        MockEvent processedEvent = new MockEvent(null, latch){
            private final CountDownLatch latch$2;

            public void process() {
                this.latch$2.await();
            }

            public void preempt() {
            }
            {
                this.latch$2 = latch$2;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        };
        MockEvent preemptedEvent = new MockEvent(null, count){
            private final IntRef count$1;

            public void process() {
            }

            public void preempt() {
                --this.count$1.elem;
            }
            {
                this.count$1 = count$1;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        };
        controller.eventManager().put((ControllerEvent)processedEvent);
        controller.eventManager().put((ControllerEvent)preemptedEvent);
        controller.eventManager().put((ControllerEvent)preemptedEvent);
        ((ShutdownableThread)Mockito.doAnswer(x$30 -> {
            latch.countDown();
            return BoxedUnit.UNIT;
        }).doCallRealMethod().when((Object)spyThread)).awaitShutdown();
        controller.shutdown();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(count.elem == 0)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"preemption was not fully completed before shutdown");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        ((ShutdownableThread)Mockito.verify((Object)spyThread)).awaitShutdown();
    }

    @Test
    public void testPreemptionWithCallbacks() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        boolean bl = false;
        boolean bl2 = false;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$5 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$6 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$7 = none$7;
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$8;
        int n = 1;
        this.servers_$eq(this.makeServers(1, bl, bl2, false, (Option<String>)x$5, (Option<String>)x$6, (Option<String>)x$7, (Option<ApiVersion>)x$8, n));
        KafkaController controller = this.getController().kafkaController();
        CountDownLatch latch = new CountDownLatch(1);
        ControllerEventManager.ControllerEventThread spyThread = (ControllerEventManager.ControllerEventThread)Mockito.spy((Object)controller.eventManager().thread());
        controller.eventManager().thread_$eq(spyThread);
        MockEvent processedEvent = new MockEvent(null, latch){
            private final CountDownLatch latch$3;

            public void process() {
                this.latch$3.await();
            }

            public void preempt() {
            }
            {
                this.latch$3 = latch$3;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        };
        TopicPartition tp0 = new TopicPartition("t", 0);
        TopicPartition tp1 = new TopicPartition("t", 1);
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1}));
        ReplicaLeaderElection event1 = new ReplicaLeaderElection((Option)new Some((Object)partitions), ElectionType.PREFERRED, (ElectionTrigger)ZkTriggered$.MODULE$, (Function1 & Serializable)partitionsMap -> {
            partitionsMap.foreach((Function1 & Serializable)partition -> {
                ControllerIntegrationTest.$anonfun$testPreemptionWithCallbacks$2(partition);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        ControlledShutdown event2 = new ControlledShutdown(0, 0L, (Function1 & Serializable)x0$1 -> {
            ControllerIntegrationTest.$anonfun$testPreemptionWithCallbacks$3(x0$1);
            return BoxedUnit.UNIT;
        });
        ApiPartitionReassignment event3 = new ApiPartitionReassignment((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)None$.MODULE$)})), (Function1 & Serializable)x0$2 -> {
            ControllerIntegrationTest.$anonfun$testPreemptionWithCallbacks$4(x0$2);
            return BoxedUnit.UNIT;
        });
        ListPartitionReassignments event4 = new ListPartitionReassignments((Option)new Some((Object)partitions), (Function1 & Serializable)x0$3 -> {
            ControllerIntegrationTest.$anonfun$testPreemptionWithCallbacks$5(x0$3);
            return BoxedUnit.UNIT;
        });
        controller.eventManager().put((ControllerEvent)processedEvent);
        controller.eventManager().put((ControllerEvent)event1);
        controller.eventManager().put((ControllerEvent)event2);
        controller.eventManager().put((ControllerEvent)event3);
        controller.eventManager().put((ControllerEvent)event4);
        ((ShutdownableThread)Mockito.doAnswer(x$31 -> {
            latch.countDown();
            return BoxedUnit.UNIT;
        }).doCallRealMethod().when((Object)spyThread)).awaitShutdown();
        controller.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    private void testControllerFeatureZNodeSetup(Option<FeatureZNode> initialZNode, ApiVersion interBrokerProtocolVersion) {
        void var12_19;
        None$ none$;
        None$ none$2;
        None$ none$3;
        Option option;
        if (initialZNode instanceof Some) {
            FeatureZNode node = (FeatureZNode)((Some)initialZNode).value();
            this.zkClient().createFeatureZNode(node);
            option = new Some((Object)BoxesRunTime.boxToInteger((int)this.zkClient().getDataAndVersion("/feature")._2$mcI$sp()));
        } else if (None$.MODULE$.equals(initialZNode)) {
            option = Option$.MODULE$.empty();
        } else {
            throw new MatchError(initialZNode);
        }
        Some x$2 = new Some((Object)interBrokerProtocolVersion);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        None$ none$4 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$6 = none$4;
        None$ none$5 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$7 = none$5;
        None$ none$6 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$6;
        int n = 1;
        this.servers_$eq(this.makeServers(1, bl, bl2, bl3, (Option<String>)x$6, (Option<String>)x$7, (Option<String>)x$8, (Option<ApiVersion>)x$2, n));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaController controller = this.getController().kafkaController();
        CountDownLatch latch = new CountDownLatch(1);
        controller.eventManager().put((ControllerEvent)new MockEvent(null, latch){
            private final CountDownLatch latch$4;

            public void process() {
                this.latch$4.countDown();
            }

            public void preempt() {
            }
            {
                this.latch$4 = latch$4;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        });
        latch.await();
        Tuple2 tuple2 = this.zkClient().getDataAndVersion("/feature");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeBytes = (Option)tuple2._1();
        int n2 = tuple2._2$mcI$sp();
        FeatureZNode newZNode = FeatureZNode$.MODULE$.decode((byte[])var12_19.get());
        if (interBrokerProtocolVersion.$greater$eq((Object)KAFKA_2_7_IV0$.MODULE$)) {
            FeatureZNode emptyZNode = new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, Features.emptyFinalizedFeatures());
            if (initialZNode instanceof Some) {
                FeatureZNode node = (FeatureZNode)((Some)initialZNode).value();
                FeatureZNodeStatus featureZNodeStatus = node.status();
                if (FeatureZNodeStatus.Enabled$.MODULE$.equals(featureZNodeStatus)) {
                    Assertions.assertEquals((int)BoxesRunTime.unboxToInt((Object)option.get()), (int)n2);
                    Assertions.assertEquals((Object)node, (Object)newZNode);
                    return;
                }
                if (FeatureZNodeStatus.Disabled$.MODULE$.equals(featureZNodeStatus)) {
                    Assertions.assertEquals((int)(BoxesRunTime.unboxToInt((Object)option.get()) + 1), (int)n2);
                    Assertions.assertEquals((Object)emptyZNode, (Object)newZNode);
                    return;
                }
                throw new MatchError((Object)featureZNodeStatus);
            }
            if (None$.MODULE$.equals(initialZNode)) {
                Assertions.assertEquals((int)0, (int)n2);
                Assertions.assertEquals((Object)new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, Features.emptyFinalizedFeatures()), (Object)newZNode);
                return;
            }
            throw new MatchError(initialZNode);
        }
        FeatureZNode emptyZNode = new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Disabled$.MODULE$, Features.emptyFinalizedFeatures());
        if (initialZNode instanceof Some) {
            FeatureZNodeStatus featureZNodeStatus = ((FeatureZNode)((Some)initialZNode).value()).status();
            if (FeatureZNodeStatus.Enabled$.MODULE$.equals(featureZNodeStatus)) {
                Assertions.assertEquals((int)(BoxesRunTime.unboxToInt((Object)option.get()) + 1), (int)n2);
                Assertions.assertEquals((Object)emptyZNode, (Object)newZNode);
                return;
            }
            if (FeatureZNodeStatus.Disabled$.MODULE$.equals(featureZNodeStatus)) {
                Assertions.assertEquals((int)BoxesRunTime.unboxToInt((Object)option.get()), (int)n2);
                Assertions.assertEquals((Object)emptyZNode, (Object)newZNode);
                return;
            }
            throw new MatchError((Object)featureZNodeStatus);
        }
        if (None$.MODULE$.equals(initialZNode)) {
            Assertions.assertEquals((int)0, (int)n2);
            Assertions.assertEquals((Object)new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Disabled$.MODULE$, Features.emptyFinalizedFeatures()), (Object)newZNode);
            return;
        }
        throw new MatchError(initialZNode);
    }

    @Test
    public void testIdempotentAlterIsr() {
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testIdempotentAlterIsr$1(controllerId, x$33))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        CountDownLatch latch = new CountDownLatch(1);
        KafkaController controller = this.getController().kafkaController();
        LeaderAndIsr newLeaderAndIsr = ((LeaderIsrAndControllerEpoch)this.zkClient().getTopicPartitionStates((Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).apply((Object)tp)).leaderAndIsr();
        Function1 & Serializable callback = (Function1 & Serializable)result -> {
            ControllerIntegrationTest.$anonfun$testIdempotentAlterIsr$2(tp, newLeaderAndIsr, latch, result);
            return BoxedUnit.UNIT;
        };
        long brokerEpoch = BoxesRunTime.unboxToLong((Object)controller.controllerContext().liveBrokerIdAndEpochs().get((Object)BoxesRunTime.boxToInteger((int)otherBroker.config().brokerId())).get());
        controller.eventManager().put((ControllerEvent)new AlterIsrReceived(otherBroker.config().brokerId(), brokerEpoch, (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)newLeaderAndIsr)})), (Function1)callback));
        latch.await();
    }

    @Test
    public void testTopicIdsAreAdded() {
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaController controller = this.getController().kafkaController();
        TopicPartition tp1 = new TopicPartition("t1", 0);
        Map assignment1 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp1.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t1"));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp1.topic(), (Map<Object, Seq<Object>>)assignment1, this.servers());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t1"));
        Uuid topicId1 = (Uuid)controller.controllerContext().topicIds().apply((Object)"t1");
        Assertions.assertEquals((Object)"t1", (Object)controller.controllerContext().topicNames().apply((Object)topicId1));
        TopicPartition tp2 = new TopicPartition("t2", 0);
        Map assignment2 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp2.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp2.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.waitForPartitionState(tp2, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t2"));
        Uuid topicId2 = (Uuid)controller.controllerContext().topicIds().apply((Object)"t2");
        Assertions.assertEquals((Object)"t2", (Object)controller.controllerContext().topicNames().apply((Object)topicId2));
        Assertions.assertEquals((Object)topicId1, (Object)controller.controllerContext().topicIds().get((Object)"t1").get());
        Assertions.assertNotEquals((Object)topicId1, (Object)topicId2);
    }

    @Test
    public void testTopicIdsAreNotAdded() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        Some x$2 = new Some((Object)KAFKA_2_7_IV0$.MODULE$);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        None$ none$4 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$6 = none$4;
        None$ none$5 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$7 = none$5;
        None$ none$6 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$6;
        int n = 1;
        this.servers_$eq(this.makeServers(1, bl, bl2, bl3, (Option<String>)x$6, (Option<String>)x$7, (Option<String>)x$8, (Option<ApiVersion>)x$2, n));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaController controller = this.getController().kafkaController();
        TopicPartition tp1 = new TopicPartition("t1", 0);
        Map assignment1 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp1.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t1"));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp1.topic(), (Map<Object, Seq<Object>>)assignment1, this.servers());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t1"));
        TopicPartition tp2 = new TopicPartition("t2", 0);
        Map assignment2 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp2.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp2.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.waitForPartitionState(tp2, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t2"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t1"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicIdMigrationAndHandling() {
        void apply_removingReplicas;
        void apply_addingReplicas;
        TopicPartition tp = new TopicPartition("t", 0);
        Object[] objectArray = new Tuple2[1];
        Seq seq = (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Seq seq2 = (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Seq apply_replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        Object var8_4 = null;
        seq2 = null;
        seq = null;
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)new ReplicaAssignment(apply_replicas, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas));
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        adminZkClient.createTopic(tp.topic(), 1, 1, adminZkClient.createTopic$default$4(), adminZkClient.createTopic$default$5(), adminZkClient.createTopic$default$6());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Option topicIdAfterCreate = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertTrue((boolean)topicIdAfterCreate.isDefined());
        Assertions.assertEquals((Object)topicIdAfterCreate, (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic()), (String)"correct topic ID cannot be found in the controller context");
        adminZkClient.addPartitions(tp.topic(), assignment, adminZkClient.getBrokerMetadatas(adminZkClient.getBrokerMetadatas$default$1(), adminZkClient.getBrokerMetadatas$default$2()), 2, adminZkClient.addPartitions$default$5(), adminZkClient.addPartitions$default$6());
        Option topicIdAfterAddition = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertEquals((Object)topicIdAfterCreate, (Object)topicIdAfterAddition);
        Assertions.assertEquals((Object)topicIdAfterCreate, (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic()), (String)"topic ID changed after partition additions");
        adminZkClient.deleteTopic(tp.topic());
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdMigrationAndHandling$1(this, tp)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"topic ID for topic should have been removed from controller context after deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicIdMigrationAndHandlingWithOlderVersion() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        void apply_removingReplicas;
        void apply_addingReplicas;
        TopicPartition tp = new TopicPartition("t", 0);
        Object[] objectArray = new Tuple2[1];
        Seq seq = (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Seq seq2 = (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Seq apply_replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        Object var12_4 = null;
        seq2 = null;
        seq = null;
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)new ReplicaAssignment(apply_replicas, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas));
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
        Some x$2 = new Some((Object)KAFKA_2_7_IV0$.MODULE$);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        None$ none$4 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$6 = none$4;
        None$ none$5 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$7 = none$5;
        None$ none$6 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$6;
        int n = 1;
        this.servers_$eq(this.makeServers(1, bl, bl2, bl3, (Option<String>)x$6, (Option<String>)x$7, (Option<String>)x$8, (Option<ApiVersion>)x$2, n));
        adminZkClient.createTopic(tp.topic(), 1, 1, adminZkClient.createTopic$default$4(), adminZkClient.createTopic$default$5(), adminZkClient.createTopic$default$6());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Option topicIdAfterCreate = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)topicIdAfterCreate);
        Assertions.assertEquals((Object)topicIdAfterCreate, (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic()), (String)"incorrect topic ID can be found in the controller context");
        adminZkClient.addPartitions(tp.topic(), assignment, adminZkClient.getBrokerMetadatas(adminZkClient.getBrokerMetadatas$default$1(), adminZkClient.getBrokerMetadatas$default$2()), 2, adminZkClient.addPartitions$default$5(), adminZkClient.addPartitions$default$6());
        Option topicIdAfterAddition = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertEquals((Object)topicIdAfterCreate, (Object)topicIdAfterAddition);
        Assertions.assertEquals((Object)topicIdAfterCreate, (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic()), (String)"topic ID changed after partition additions");
        adminZkClient.deleteTopic(tp.topic());
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdMigrationAndHandlingWithOlderVersion$1(this, tp)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"topic should have been removed from controller context after deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    @Test
    public void testTopicIdPersistsThroughControllerReelection() {
        this.servers_$eq(this.makeServers(2, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaController controller = this.getController().kafkaController();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Uuid topicId = (Uuid)controller.controllerContext().topicIds().get((Object)"t").get();
        ((KafkaServer)this.servers().apply(controllerId)).shutdown();
        ((KafkaServer)this.servers().apply(controllerId)).awaitShutdown();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdPersistsThroughControllerReelection$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"failed to elect a controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        KafkaController controller2 = this.getController().kafkaController();
        Assertions.assertEquals((Object)topicId, (Object)controller2.controllerContext().topicIds().get((Object)"t").get());
    }

    @Test
    public void testNoTopicIdPersistsThroughControllerReelection() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        Some x$2 = new Some((Object)KAFKA_2_7_IV0$.MODULE$);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        None$ none$4 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$6 = none$4;
        None$ none$5 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$7 = none$5;
        None$ none$6 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$6;
        int n = 1;
        this.servers_$eq(this.makeServers(2, bl, bl2, bl3, (Option<String>)x$6, (Option<String>)x$7, (Option<String>)x$8, (Option<ApiVersion>)x$2, n));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaController controller = this.getController().kafkaController();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Option emptyTopicId = controller.controllerContext().topicIds().get((Object)"t");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)emptyTopicId);
        ((KafkaServer)this.servers().apply(controllerId)).shutdown();
        ((KafkaServer)this.servers().apply(controllerId)).awaitShutdown();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testNoTopicIdPersistsThroughControllerReelection$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"failed to elect a controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        KafkaController controller2 = this.getController().kafkaController();
        Assertions.assertEquals((Object)emptyTopicId, (Object)controller2.controllerContext().topicIds().get((Object)"t"));
    }

    @Test
    public void testTopicIdPersistsThroughControllerRestart() {
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaController controller = this.getController().kafkaController();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Uuid topicId = (Uuid)controller.controllerContext().topicIds().get((Object)"t").get();
        ((KafkaServer)this.servers().apply(controllerId)).shutdown();
        ((KafkaServer)this.servers().apply(controllerId)).awaitShutdown();
        ((KafkaServer)this.servers().apply(controllerId)).startup();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdPersistsThroughControllerRestart$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"failed to elect a controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        KafkaController controller2 = this.getController().kafkaController();
        Assertions.assertEquals((Object)topicId, (Object)controller2.controllerContext().topicIds().get((Object)"t").get());
    }

    @Test
    public void testTopicIdCreatedOnUpgrade() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        Some x$2 = new Some((Object)KAFKA_2_7_IV0$.MODULE$);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        None$ none$4 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$6 = none$4;
        None$ none$5 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$7 = none$5;
        None$ none$6 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$6;
        int n = 1;
        this.servers_$eq(this.makeServers(1, bl, bl2, bl3, (Option<String>)x$6, (Option<String>)x$7, (Option<String>)x$8, (Option<ApiVersion>)x$2, n));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaController controller = this.getController().kafkaController();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Option topicIdAfterCreate = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)topicIdAfterCreate);
        Option emptyTopicId = controller.controllerContext().topicIds().get((Object)"t");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)emptyTopicId);
        ((KafkaServer)this.servers().apply(controllerId)).shutdown();
        ((KafkaServer)this.servers().apply(controllerId)).awaitShutdown();
        this.servers_$eq(this.makeServers(1, false, false, true, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<ApiVersion>)None$.MODULE$, 1));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgrade$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"failed to elect a controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Option topicIdAfterUpgrade = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertNotEquals((Object)emptyTopicId, (Object)topicIdAfterUpgrade);
        KafkaController controller2 = this.getController().kafkaController();
        Assertions.assertNotEquals((Object)emptyTopicId, (Object)controller2.controllerContext().topicIds().get((Object)"t"));
        Uuid topicId = (Uuid)controller2.controllerContext().topicIds().get((Object)"t").get();
        Assertions.assertEquals((Object)topicIdAfterUpgrade.get(), (Object)topicId);
        Assertions.assertEquals((Object)"t", (Object)controller2.controllerContext().topicNames().apply((Object)topicId));
        this.adminZkClient().deleteTopic(tp.topic());
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgrade$3(this, tp)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"topic should have been removed from controller context after deletion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
    }

    private void testControllerMove(Function0<BoxedUnit> fun) {
        KafkaController controller = this.getController().kafkaController();
        LogCaptureAppender appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(controller.getClass(), Level.INFO);
        try {
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$1(controller)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"Controller event thread is still busy");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            CountDownLatch latch = new CountDownLatch(1);
            controller.eventManager().put((ControllerEvent)new /* invalid duplicate definition of identical inner class */);
            fun.apply$mcV$sp();
            this.zkClient().deleteController(controller.controllerContext().epochZkVersion());
            this.zkClient().registerControllerAndIncrementControllerEpoch(this.servers().size());
            latch.countDown();
            long l3 = 15000L;
            long l4 = 100L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$3(controller)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                    Assertions.fail((String)"Controller fails to resign");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
            }
            Assertions.assertTrue((boolean)appender.getMessages().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e))).isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(controller.eventManager().thread().getClass(), previousLevel);
        }
    }

    private void preferredReplicaLeaderElection(int controllerId, KafkaServer otherBroker, TopicPartition tp, scala.collection.immutable.Set<Object> replicas, int leaderEpoch) {
        otherBroker.shutdown();
        otherBroker.awaitShutdown();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, leaderEpoch + 1, "failed to get expected partition state upon broker shutdown");
        otherBroker.startup();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$preferredReplicaLeaderElection$1(this, tp, replicas)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"restarted broker failed to join in-sync replicas");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$preferredReplicaLeaderElection$3(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"failed to remove preferred replica leader election path after completion");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBroker.config().brokerId(), leaderEpoch + 2, "failed to get expected partition state upon broker startup");
    }

    private void waitUntilControllerEpoch(int epoch, String message) {
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$waitUntilControllerEpoch$1(this, epoch)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)message);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    private void waitForPartitionState(TopicPartition tp, int controllerEpoch, int leader, int leaderEpoch, String message) {
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$waitForPartitionState$1(this, tp, controllerEpoch, leader, leaderEpoch)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)message);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    private boolean isExpectedPartitionState(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, int controllerEpoch, int leader, int leaderEpoch) {
        return leaderIsrAndControllerEpoch.controllerEpoch() == controllerEpoch && leaderIsrAndControllerEpoch.leaderAndIsr().leader() == leader && leaderIsrAndControllerEpoch.leaderAndIsr().leaderEpoch() == leaderEpoch;
    }

    private Seq<KafkaServer> makeServers(int numConfigs, boolean autoLeaderRebalanceEnable, boolean uncleanLeaderElectionEnable, boolean enableControlledShutdown, Option<String> listeners, Option<String> listenerSecurityProtocolMap, Option<String> controlPlaneListenerName, Option<ApiVersion> interBrokerProtocolVersion, int logDirCount) {
        Map map;
        None$ none$;
        None$ none$2;
        None$ none$3;
        String x$2 = this.zkConnect();
        boolean bl = true;
        None$ none$4 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$6 = none$4;
        None$ none$5 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$7 = none$5;
        None$ none$6 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$6;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Map map2 = map = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        map = null;
        Map x$13 = map2;
        boolean bl6 = false;
        int n = 1;
        short s = 1;
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(numConfigs, x$2, enableControlledShutdown, bl, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl2, bl3, bl4, bl5, (Map<Object, String>)x$13, logDirCount, bl6, n, s);
        configs.foreach((Function1 & Serializable)config -> {
            ControllerIntegrationTest.$anonfun$makeServers$1(autoLeaderRebalanceEnable, uncleanLeaderElectionEnable, listeners, listenerSecurityProtocolMap, controlPlaneListenerName, interBrokerProtocolVersion, config);
            return BoxedUnit.UNIT;
        });
        return (Seq)configs.map((Function1 & Serializable)config -> {
            void createServer_time;
            Time time;
            Time time2 = time = Time.SYSTEM;
            time = null;
            Time time3 = time2;
            KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(config);
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            return createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false);
        });
    }

    private boolean makeServers$default$2() {
        return false;
    }

    private boolean makeServers$default$3() {
        return false;
    }

    private boolean makeServers$default$4() {
        return true;
    }

    private Option<String> makeServers$default$5() {
        return None$.MODULE$;
    }

    private Option<String> makeServers$default$6() {
        return None$.MODULE$;
    }

    private Option<String> makeServers$default$7() {
        return None$.MODULE$;
    }

    private Option<ApiVersion> makeServers$default$8() {
        return None$.MODULE$;
    }

    private int makeServers$default$9() {
        return 1;
    }

    private Timer timer(String metricName) {
        return (Timer)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$timer$1(metricName, x0$1)))).values().headOption().getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(22).append("Unable to find metric ").append(metricName).toString());
        });
    }

    private KafkaServer getController() {
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        return (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$getController$1(controllerId, s)))).head();
    }

    public static final /* synthetic */ boolean $anonfun$testEmptyCluster$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testEmptyCluster$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerEpochPersistsWhenAllBrokersDown$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testControllerEpochPersistsWhenAllBrokersDown$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerEpochPersistsWhenAllBrokersDown$3(ControllerIntegrationTest $this) {
        return !$this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testControllerEpochPersistsWhenAllBrokersDown$4() {
        return "failed to kill controller";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMoveIncrementsControllerEpoch$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testControllerMoveIncrementsControllerEpoch$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMoveIncrementsControllerEpoch$3(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testControllerMoveIncrementsControllerEpoch$4() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerChange$1(int controllerId$1, KafkaServer e) {
        return e.config().brokerId() != controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerChange$2(KafkaServer testBroker$1, KafkaServer x$1) {
        return x$1.config().brokerId() != testBroker$1.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testMetadataPropagationOnBrokerChange$3(KafkaServer x$2) {
        return x$2.config().brokerId();
    }

    public static final /* synthetic */ void $anonfun$testMetadataPropagationOnBrokerChange$4(String topic$1, KafkaServer testBroker$1, Map assignment$1, Seq remainingBrokers$1, KafkaServer server) {
        UpdateMetadataRequestData.UpdateMetadataPartitionState offlineReplicaPartitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)server.metadataCache().getPartitionInfo(topic$1, 0).get();
        Assertions.assertEquals((int)1, (int)offlineReplicaPartitionInfo.offlineReplicas().size());
        Assertions.assertEquals((int)testBroker$1.config().brokerId(), (Integer)((Integer)offlineReplicaPartitionInfo.offlineReplicas().get(0)));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)assignment$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).asJava(), (Object)offlineReplicaPartitionInfo.replicas());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaServer)remainingBrokers$1.head()).config().brokerId()}))).asJava(), (Object)offlineReplicaPartitionInfo.isr());
        UpdateMetadataRequestData.UpdateMetadataPartitionState onlinePartitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)server.metadataCache().getPartitionInfo(topic$1, 1).get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)assignment$1.apply((Object)BoxesRunTime.boxToInteger((int)1))).asJava(), (Object)onlinePartitionInfo.replicas());
        Assertions.assertTrue((boolean)onlinePartitionInfo.offlineReplicas().isEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerChange$7(KafkaServer server$1, String topic$1, Tuple2 x0$1) {
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionInfo;
        Seq replicas;
        int partitionId;
        if (x0$1 != null) {
            partitionId = x0$1._1$mcI$sp();
            replicas = (Seq)x0$1._2();
        } else {
            throw new MatchError(null);
        }
        Option partitionInfoOpt = server$1.metadataCache().getPartitionInfo(topic$1, partitionId);
        boolean bl = partitionInfoOpt.isDefined() ? !(partitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)partitionInfoOpt.get()).offlineReplicas().isEmpty() || !CollectionConverters$.MODULE$.ListHasAsScala(partitionInfo.replicas()).asScala().equals((Object)replicas) : true;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerChange$5(ControllerIntegrationTest $this, Map assignment$1, String topic$1) {
        return !$this.servers().exists((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)assignment$1.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$7(server, topic$1, x0$1)))));
    }

    public static final /* synthetic */ String $anonfun$testMetadataPropagationOnBrokerChange$8() {
        return "Inconsistent metadata after broker startup";
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationForOfflineReplicas$1(int controllerId$2, KafkaServer e) {
        return e.config().brokerId() != controllerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationForOfflineReplicas$2(int controllerId$2, KafkaServer e) {
        return e.config().brokerId() == controllerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationForOfflineReplicas$3(int controllerId$2, KafkaServer replicaBroker$1, KafkaServer e) {
        return e.config().brokerId() != controllerId$2 && e.config().brokerId() != replicaBroker$1.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationForOfflineReplicas$4(KafkaServer broker$1, String topic$2) {
        Option partitionInfoOpt = broker$1.metadataCache().getPartitionInfo(topic$2, 0);
        if (partitionInfoOpt.isDefined()) {
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)partitionInfoOpt.get();
            return !partitionInfo.offlineReplicas().isEmpty() && partitionInfo.leader() == -1 && !partitionInfo.replicas().isEmpty() && !partitionInfo.isr().isEmpty();
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testMetadataPropagationForOfflineReplicas$5() {
        return "Inconsistent metadata after broker startup";
    }

    private static final void verifyMetadata$1(KafkaServer broker, String topic$2) {
        broker.startup();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testMetadataPropagationForOfflineReplicas$4(broker, topic$2)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Inconsistent metadata after broker startup");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    public static final /* synthetic */ int $anonfun$testTopicCreationWithOfflineReplica$1(KafkaServer x$3) {
        return x$3.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testTopicPartitionExpansionWithOfflineReplica$1(KafkaServer x$5) {
        return x$5.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignment$1(KafkaServer x$7) {
        return x$7.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignment$4(ControllerIntegrationTest $this, TopicPartition tp$1, Map reassignment$1) {
        Map map = $this.zkClient().getFullReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tp$1.topic()})));
        return !(map != null ? !map.equals(reassignment$1) : reassignment$1 != null);
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignment$5() {
        return "failed to get updated partition assignment on topic znode after partition reassignment";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignment$6(ControllerIntegrationTest $this) {
        return !$this.zkClient().reassignPartitionsInProgress();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignment$7() {
        return "failed to remove reassign partitions path after completion";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$1(int controllerId$6, KafkaServer x$9) {
        return x$9.config().brokerId() != controllerId$6;
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$3(ControllerIntegrationTest $this, TopicPartition tp$2, Map reassignment$2) {
        Map map = $this.zkClient().getFullReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tp$2.topic()})));
        return !(map != null ? !map.equals(reassignment$2) : reassignment$2 != null);
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$4() {
        return "failed to get updated partition assignment on topic znode after partition reassignment";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$5(ControllerIntegrationTest $this) {
        return !$this.zkClient().reassignPartitionsInProgress();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$6() {
        return "failed to remove reassign partitions path after completion";
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$1(KafkaServer x$10) {
        return x$10.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$3(ControllerIntegrationTest $this) {
        return $this.zkClient().reassignPartitionsInProgress();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$4() {
        return "partition reassignment path should remain while reassignment in progress";
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$1(KafkaServer x$12) {
        return x$12.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$4(ControllerIntegrationTest $this, TopicPartition tp$3, Map reassignment$3) {
        Map map = $this.zkClient().getFullReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tp$3.topic()})));
        return !(map != null ? !map.equals(reassignment$3) : reassignment$3 != null);
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$5() {
        return "failed to get updated partition assignment on topic znode after partition reassignment";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$6(ControllerIntegrationTest $this) {
        return !$this.zkClient().reassignPartitionsInProgress();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$7() {
        return "failed to remove reassign partitions path after completion";
    }

    public static final /* synthetic */ boolean $anonfun$testPreferredReplicaLeaderElection$1(int controllerId$9, KafkaServer x$14) {
        return x$14.config().brokerId() != controllerId$9;
    }

    public static final /* synthetic */ boolean $anonfun$testBackToBackPreferredReplicaLeaderElections$1(int controllerId$10, KafkaServer x$15) {
        return x$15.config().brokerId() != controllerId$10;
    }

    public static final /* synthetic */ int $anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$1(KafkaServer x$16) {
        return x$16.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$3(ControllerIntegrationTest $this) {
        return !$this.zkClient().pathExists(PreferredReplicaElectionZNode$.MODULE$.path());
    }

    public static final /* synthetic */ String $anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$4() {
        return "failed to remove preferred replica leader election path after giving up";
    }

    public static final /* synthetic */ int $anonfun$testAutoPreferredReplicaLeaderElection$1(KafkaServer x$18) {
        return x$18.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$1(KafkaServer x$20) {
        return x$20.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$3(ControllerIntegrationTest $this, TopicPartition tp$4, int otherBrokerId$1) {
        Map leaderIsrAndControllerEpochMap = $this.zkClient().getTopicPartitionStates((Seq)new .colon.colon((Object)tp$4, (List)Nil$.MODULE$));
        if (leaderIsrAndControllerEpochMap.contains((Object)tp$4) && $this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp$4), $this.firstControllerEpoch(), LeaderAndIsr$.MODULE$.NoLeader(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1)) {
            List list = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp$4)).leaderAndIsr().isr();
            Object object = package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId$1}));
            if (!(list != null ? !list.equals(object) : object != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$4() {
        return "failed to get expected partition state after entire isr went offline";
    }

    public static final /* synthetic */ int $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$1(KafkaServer x$22) {
        return x$22.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$3(ControllerIntegrationTest $this, TopicPartition tp$5, int otherBrokerId$2) {
        Map leaderIsrAndControllerEpochMap = $this.zkClient().getTopicPartitionStates((Seq)new .colon.colon((Object)tp$5, (List)Nil$.MODULE$));
        if (leaderIsrAndControllerEpochMap.contains((Object)tp$5) && $this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp$5), $this.firstControllerEpoch(), LeaderAndIsr$.MODULE$.NoLeader(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1)) {
            List list = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp$5)).leaderAndIsr().isr();
            Object object = package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId$2}));
            if (!(list != null ? !list.equals(object) : object != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$4() {
        return "failed to get expected partition state after entire isr went offline";
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$3(int controllerId$15, KafkaServer p) {
        return p.config().brokerId() == controllerId$15;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$5(KafkaServer x$24) {
        return x$24.config().brokerId() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$6(KafkaServer s) {
        return s.config().brokerId() != 2;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$8(String topic$3, int partition$1, KafkaServer x$25) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$25.dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic$3, partition$1).get()).isr().size() != 3;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$7(ObjectRef activeServers$1, String topic$3, int partition$1) {
        return ((Seq)activeServers$1.elem).forall((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$8(topic$3, partition$1, x$25)));
    }

    public static final /* synthetic */ String $anonfun$testControlledShutdown$9() {
        return "Topic test not created after timeout";
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$10(KafkaServer x$26) {
        return x$26.config().brokerId() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$11(KafkaServer s) {
        return s.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$12(String topic$3, int partition$1, KafkaServer x$27) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$27.dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic$3, partition$1).get()).leader() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$13(KafkaServer x$28) {
        return x$28.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$14(String topic$3, int partition$1, KafkaServer x$29) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$29.dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic$3, partition$1).get()).leader() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$3(KafkaController controller$1, KafkaServer e) {
        return e.config().brokerId() != controller$1.config().brokerId();
    }

    public static final /* synthetic */ void $anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$4(VolatileBooleanRef staleBrokerEpochDetected$1, Try x0$1) {
        if (x0$1 instanceof Failure && ((Failure)x0$1).exception() instanceof StaleBrokerEpochException) {
            staleBrokerEpochDetected$1.elem = true;
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$5(VolatileBooleanRef staleBrokerEpochDetected$1) {
        return staleBrokerEpochDetected$1.elem;
    }

    public static final /* synthetic */ String $anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$6() {
        return "Fail to detect stale broker epoch";
    }

    public static final /* synthetic */ void $anonfun$testControllerMoveOnTopicCreation$1(ControllerIntegrationTest $this, TopicPartition tp$6, Map assignment$2) {
        AdminZkClient adminZkClient = new AdminZkClient($this.zkClient());
        adminZkClient.createTopicWithAssignment(tp$6.topic(), new Properties(), assignment$2, adminZkClient.createTopicWithAssignment$default$4(), adminZkClient.createTopicWithAssignment$default$5());
    }

    public static final /* synthetic */ void $anonfun$testControllerMoveOnTopicDeletion$1(ControllerIntegrationTest $this, TopicPartition tp$7) {
        new AdminZkClient($this.zkClient()).deleteTopic(tp$7.topic());
    }

    public static final /* synthetic */ void $anonfun$testControllerMoveOnPreferredReplicaElection$1(ControllerIntegrationTest $this, TopicPartition tp$8) {
        $this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp$8})));
    }

    public static final /* synthetic */ void $anonfun$testControllerMoveOnPartitionReassignment$1(ControllerIntegrationTest $this, Map reassignment$4) {
        $this.zkClient().createPartitionReassignment(reassignment$4);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerDetectsBouncedBrokers$1(KafkaController controller$2, KafkaServer e) {
        return e.config().brokerId() != controller$2.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testControllerDetectsBouncedBrokers$2(KafkaController controller$2) {
        ControllerState controllerState = controller$2.eventManager().state();
        ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
        return controllerState != null && controllerState.equals(idle$);
    }

    public static final /* synthetic */ String $anonfun$testControllerDetectsBouncedBrokers$3() {
        return "Controller event thread is still busy";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerDetectsBouncedBrokers$4(KafkaServer otherBroker$1) {
        return BoxesRunTime.unboxToInt((Object)otherBroker$1.replicaManager().partitionCount().value()) == 1 && otherBroker$1.replicaManager().metadataCache().getAllTopics().size() == 1 && otherBroker$1.replicaManager().metadataCache().getAliveBrokers().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testControllerDetectsBouncedBrokers$5() {
        return "Broker fail to initialize after restart";
    }

    public static final /* synthetic */ boolean $anonfun$testPreemptionOnControllerShutdown$2(IntRef count$1) {
        return count$1.elem == 0;
    }

    public static final /* synthetic */ String $anonfun$testPreemptionOnControllerShutdown$3() {
        return "preemption was not fully completed before shutdown";
    }

    public static final /* synthetic */ void $anonfun$testPreemptionWithCallbacks$2(Tuple2 partition) {
        Either either = (Either)partition._2();
        if (either instanceof Left) {
            ApiError e = (ApiError)((Left)either).value();
            Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)e.error());
            return;
        }
        if (either instanceof Right) {
            throw new AssertionError((Object)"replica leader election should error");
        }
        throw new MatchError((Object)either);
    }

    public static final /* synthetic */ void $anonfun$testPreemptionWithCallbacks$3(Try x0$1) {
        if (x0$1 instanceof Success) {
            throw new AssertionError((Object)"controlled shutdown should error");
        }
        if (x0$1 instanceof Failure) {
            Throwable e = ((Failure)x0$1).exception();
            Assertions.assertEquals(ControllerMovedException.class, e.getClass());
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ void $anonfun$testPreemptionWithCallbacks$4(Either x0$2) {
        if (x0$2 instanceof Left) {
            throw new AssertionError((Object)"api partition reassignment should error");
        }
        if (x0$2 instanceof Right) {
            ApiError e = (ApiError)((Right)x0$2).value();
            Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)e.error());
            return;
        }
        throw new MatchError((Object)x0$2);
    }

    public static final /* synthetic */ void $anonfun$testPreemptionWithCallbacks$5(Either x0$3) {
        if (x0$3 instanceof Left) {
            throw new AssertionError((Object)"api partition reassignment should error");
        }
        if (x0$3 instanceof Right) {
            ApiError e = (ApiError)((Right)x0$3).value();
            Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)e.error());
            return;
        }
        throw new MatchError((Object)x0$3);
    }

    public static final /* synthetic */ boolean $anonfun$testIdempotentAlterIsr$1(int controllerId$16, KafkaServer x$33) {
        return x$33.config().brokerId() != controllerId$16;
    }

    public static final /* synthetic */ void $anonfun$testIdempotentAlterIsr$2(TopicPartition tp$9, LeaderAndIsr newLeaderAndIsr$1, CountDownLatch latch$5, Either result) {
        LeaderAndIsr leaderAndIsr;
        Map partitionResults;
        if (result instanceof Left && (partitionResults = (Map)((Left)result).value()) != null) {
            Either either;
            boolean bl = false;
            Some some = null;
            Option option = partitionResults.get((Object)tp$9);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                Either either2 = (Either)some.value();
                if (either2 instanceof Left && (Errors)((Left)either2).value() != null) {
                    throw new AssertionError((Object)new StringBuilder(31).append("Should not have seen error for ").append(tp$9).toString());
                }
            }
            if (!bl || !((either = (Either)some.value()) instanceof Right) || (leaderAndIsr = (LeaderAndIsr)((Right)either).value()) == null) {
                if (None$.MODULE$.equals(option)) {
                    throw new AssertionError((Object)new StringBuilder(27).append("Should have seen ").append(tp$9).append(" in result").toString());
                }
                throw new MatchError((Object)option);
            }
        } else {
            if (result instanceof Right && ((Right)result).value() != null) {
                throw new AssertionError((Object)"Should not have had top-level error here");
            }
            throw new MatchError((Object)result);
        }
        Assertions.assertEquals((Object)leaderAndIsr, (Object)newLeaderAndIsr$1, (String)"ISR should remain unchanged");
        latch$5.countDown();
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdMigrationAndHandling$1(ControllerIntegrationTest $this, TopicPartition tp$10) {
        return ((KafkaServer)$this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp$10.topic()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testTopicIdMigrationAndHandling$2() {
        return "topic ID for topic should have been removed from controller context after deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdMigrationAndHandlingWithOlderVersion$1(ControllerIntegrationTest $this, TopicPartition tp$11) {
        return !((KafkaServer)$this.servers().head()).kafkaController().controllerContext().allTopics().contains((Object)tp$11.topic());
    }

    public static final /* synthetic */ String $anonfun$testTopicIdMigrationAndHandlingWithOlderVersion$2() {
        return "topic should have been removed from controller context after deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdPersistsThroughControllerReelection$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicIdPersistsThroughControllerReelection$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testNoTopicIdPersistsThroughControllerReelection$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testNoTopicIdPersistsThroughControllerReelection$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdPersistsThroughControllerRestart$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicIdPersistsThroughControllerRestart$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdCreatedOnUpgrade$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicIdCreatedOnUpgrade$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdCreatedOnUpgrade$3(ControllerIntegrationTest $this, TopicPartition tp$12) {
        return !((KafkaServer)$this.servers().head()).kafkaController().controllerContext().allTopics().contains((Object)tp$12.topic());
    }

    public static final /* synthetic */ String $anonfun$testTopicIdCreatedOnUpgrade$4() {
        return "topic should have been removed from controller context after deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMove$1(KafkaController controller$3) {
        ControllerState controllerState = controller$3.eventManager().state();
        ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
        return controllerState != null && controllerState.equals(idle$);
    }

    public static final /* synthetic */ String $anonfun$testControllerMove$2() {
        return "Controller event thread is still busy";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMove$3(KafkaController controller$3) {
        return !controller$3.isActive();
    }

    public static final /* synthetic */ String $anonfun$testControllerMove$4() {
        return "Controller fails to resign";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMove$5(LoggingEvent e) {
        Level level = e.getLevel();
        Level level2 = Level.INFO;
        if (!(level != null ? !level.equals(level2) : level2 != null)) {
            if (e.getThrowableInformation() != null && e.getThrowableInformation().getThrowable().getClass().getName().equals(ControllerMovedException.class.getName())) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$preferredReplicaLeaderElection$1(ControllerIntegrationTest $this, TopicPartition tp$13, scala.collection.immutable.Set replicas$1) {
        scala.collection.immutable.Set set = ((IterableOnceOps)$this.zkClient().getInSyncReplicasForPartition(new TopicPartition(tp$13.topic(), tp$13.partition())).get()).toSet();
        return !(set != null ? !set.equals(replicas$1) : replicas$1 != null);
    }

    public static final /* synthetic */ String $anonfun$preferredReplicaLeaderElection$2() {
        return "restarted broker failed to join in-sync replicas";
    }

    public static final /* synthetic */ boolean $anonfun$preferredReplicaLeaderElection$3(ControllerIntegrationTest $this) {
        return !$this.zkClient().pathExists(PreferredReplicaElectionZNode$.MODULE$.path());
    }

    public static final /* synthetic */ String $anonfun$preferredReplicaLeaderElection$4() {
        return "failed to remove preferred replica leader election path after completion";
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilControllerEpoch$1(ControllerIntegrationTest $this, int epoch$1) {
        return $this.zkClient().getControllerEpoch().map((Function1 & Serializable)x$34 -> BoxesRunTime.boxToInteger((int)x$34._1$mcI$sp())).contains((Object)BoxesRunTime.boxToInteger((int)epoch$1));
    }

    public static final /* synthetic */ String $anonfun$waitUntilControllerEpoch$3(String message$1) {
        return message$1;
    }

    public static final /* synthetic */ boolean $anonfun$waitForPartitionState$1(ControllerIntegrationTest $this, TopicPartition tp$14, int controllerEpoch$1, int leader$1, int leaderEpoch$1) {
        Map leaderIsrAndControllerEpochMap = $this.zkClient().getTopicPartitionStates((Seq)new .colon.colon((Object)tp$14, (List)Nil$.MODULE$));
        return leaderIsrAndControllerEpochMap.contains((Object)tp$14) && $this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp$14), controllerEpoch$1, leader$1, leaderEpoch$1);
    }

    public static final /* synthetic */ String $anonfun$waitForPartitionState$2(String message$2) {
        return message$2;
    }

    public static final /* synthetic */ void $anonfun$makeServers$1(boolean autoLeaderRebalanceEnable$1, boolean uncleanLeaderElectionEnable$1, Option listeners$1, Option listenerSecurityProtocolMap$1, Option controlPlaneListenerName$1, Option interBrokerProtocolVersion$1, Properties config) {
        config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), Boolean.toString(autoLeaderRebalanceEnable$1));
        config.setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(uncleanLeaderElectionEnable$1));
        config.setProperty(KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp(), "1");
        listeners$1.foreach((Function1 & Serializable)listener -> config.setProperty(KafkaConfig$.MODULE$.ListenersProp(), (String)listener));
        listenerSecurityProtocolMap$1.foreach((Function1 & Serializable)listenerMap -> config.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), (String)listenerMap));
        controlPlaneListenerName$1.foreach((Function1 & Serializable)controlPlaneListener -> config.setProperty(KafkaConfig$.MODULE$.ControlPlaneListenerNameProp(), (String)controlPlaneListener));
        interBrokerProtocolVersion$1.foreach((Function1 & Serializable)ibp -> config.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), ibp.toString()));
    }

    public static final /* synthetic */ boolean $anonfun$timer$1(String metricName$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$1._1()).getMBeanName();
        boolean bl = !(string != null ? !string.equals(metricName$1) : metricName$1 != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(int controllerId$17, KafkaServer s) {
        return s.config().brokerId() == controllerId$17;
    }
}

