/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.ClientRecordDeletion$;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.server.LogOffsetTest$;
import kafka.utils.MockTime;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.LazyZip2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.View;
import scala.collection.WithFilter;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005Ef\u0001B\n\u0015\u0001eAQA\b\u0001\u0005\u0002}A\u0001\"\t\u0001\t\u0006\u0004%IA\t\u0005\u0006S\u0001!\tE\u000b\u0005\u0006c\u0001!\tF\r\u0005\u0006k\u0001!\tF\u000e\u0005\u0006\t\u0002!\t!\u0012\u0005\u00067\u0002!\t!\u0012\u0005\u0006=\u0002!\t!\u0012\u0005\u0006A\u0002!\t!\u0012\u0005\u0006E\u0002!\t!\u0012\u0005\u0006O\u0002!\t!\u0012\u0005\u0006U\u0002!\t!\u0012\u0005\u0006Y\u0002!\t!\u0012\u0005\u0006+\u0001!IA\u001c\u0005\u0006e\u0002!Ia\u001d\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0011\u001d\t9\u0003\u0001C\u0005\u0003SAq!a!\u0001\t\u0013\t)IA\u0007M_\u001e|eMZ:fiR+7\u000f\u001e\u0006\u0003+Y\taa]3sm\u0016\u0014(\"A\f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0007\t\u00037qi\u0011\u0001F\u0005\u0003;Q\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"a\u0007\u0001\u0002\tQLW.Z\u000b\u0002GA\u0011AeJ\u0007\u0002K)\u0011aEF\u0001\u0006kRLGn]\u0005\u0003Q\u0015\u0012\u0001\"T8dWRKW.Z\u0001\fEJ|7.\u001a:D_VtG/F\u0001,!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\rIe\u000e^\u0001\u000bEJ|7.\u001a:US6,GCA\u00124\u0011\u0015!D\u00011\u0001,\u0003!\u0011'o\\6fe&#\u0017a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\t9$\b\u0005\u0002-q%\u0011\u0011(\f\u0002\u0005+:LG\u000fC\u0003<\u000b\u0001\u0007A(A\u0003qe>\u00048\u000f\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u0006!Q\u000f^5m\u0015\u0005\t\u0015\u0001\u00026bm\u0006L!a\u0011 \u0003\u0015A\u0013x\u000e]3si&,7/A\u000fuKN$x)\u001a;PM\u001a\u001cX\r^:G_J,fn\u001b8po:$v\u000e]5d)\u00059\u0004F\u0001\u0004H!\tA\u0015+D\u0001J\u0015\tQ5*A\u0002ba&T!\u0001T'\u0002\u000f),\b/\u001b;fe*\u0011ajT\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002!\u0006\u0019qN]4\n\u0005IK%\u0001\u0002+fgRDCA\u0002+X3B\u0011A&V\u0005\u0003-6\u0012!\u0002Z3qe\u0016\u001c\u0017\r^3eC\u0005A\u0016!\u0006'jgR|eMZ:fiN\u0014V-];fgR\u0004c\u000bM\u0011\u00025\u0006\u0001\u0011\u0001\t;fgR<U\r^(gMN,Go]!gi\u0016\u0014H)\u001a7fi\u0016\u0014VmY8sIND#aB$)\t\u001d!v+W\u0001\u001fi\u0016\u001cHoR3u\u001f\u001a47/\u001a;t\u0005\u00164wN]3MCR,7\u000f\u001e+j[\u0016D#\u0001C$\u0002/Q,7\u000f^#naRLHj\\4t\u000f\u0016$xJ\u001a4tKR\u001c\bFA\u0005H\u0003]!Xm\u001d;HKR|eMZ:fiN\u0014UMZ8sK:{w\u000f\u000b\u0002\u000b\u000f\"\"!\u0002V3ZC\u00051\u0017\u0001\u00077fO\u0006\u001c\u0017PR3uG\"|eMZ:fiN\u0014UMZ8sK\u0006\u0001C/Z:u\u000f\u0016$xJ\u001a4tKR\u001c()\u001a4pe\u0016,\u0015M\u001d7jKN$H+[7fQ\tYq\t\u000b\u0003\f)\u0016L\u0016!\f;fgR4U\r^2i\u001f\u001a47/\u001a;t\u0005\u00164wN]3XSRD7\t[1oO&twmU3h[\u0016tGoU5{K\"\u0012AbR\u0001+i\u0016\u001cHOR3uG\"|eMZ:fiN\u0014UMZ8sK^KG\u000f[\"iC:<\u0017N\\4TK\u001elWM\u001c;tQ\tiq)F\u0001p!\tY\u0002/\u0003\u0002r)\tY1*\u00194lCN+'O^3s\u0003Y\u0019XM\u001c3MSN$xJ\u001a4tKR\u001c(+Z9vKN$HC\u0001;\u0000!\t)X0D\u0001w\u0015\t9\b0\u0001\u0005sKF,Xm\u001d;t\u0015\tI(0\u0001\u0004d_6lwN\u001c\u0006\u0003/mT!\u0001`(\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tqhOA\nMSN$xJ\u001a4tKR\u001c(+Z:q_:\u001cX\rC\u0004\u0002\u0002=\u0001\r!a\u0001\u0002\u000fI,\u0017/^3tiB\u0019Q/!\u0002\n\u0007\u0005\u001daO\u0001\nMSN$xJ\u001a4tKR\u001c(+Z9vKN$\u0018\u0001E:f]\u00124U\r^2i%\u0016\fX/Z:u)\u0011\ti!a\b\u0011\u000bU\fy!a\u0005\n\u0007\u0005EaOA\u0007GKR\u001c\u0007NU3ta>t7/\u001a\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u0004=\u0002\rI,7m\u001c:e\u0013\u0011\ti\"a\u0006\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u001d\t\t\u0001\u0005a\u0001\u0003C\u00012!^A\u0012\u0013\r\t)C\u001e\u0002\r\r\u0016$8\r\u001b*fcV,7\u000f^\u0001\u0011EVLG\u000e\u001a+be\u001e,G\u000fV5nKN$\u0002\"a\u000b\u0002j\u0005U\u0014q\u0010\t\u0007\u0003[\ti$a\u0011\u000f\t\u0005=\u0012\u0011\b\b\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011Q\u0007\r\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0013bAA\u001e[\u00059\u0001/Y2lC\u001e,\u0017\u0002BA \u0003\u0003\u0012A\u0001T5ti*\u0019\u00111H\u0017\u0011\t\u0005\u0015\u00131\r\b\u0005\u0003\u000f\niF\u0004\u0003\u0002J\u0005ec\u0002BA&\u0003/rA!!\u0014\u0002V9!\u0011qJA*\u001d\u0011\t\t$!\u0015\n\u0003AK!\u0001`(\n\u0005]Y\u0018BA={\u0013\r\tY\u0006_\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\ty&!\u0019\u0002-1K7\u000f^(gMN,Go\u001d*fcV,7\u000f\u001e#bi\u0006T1!a\u0017y\u0013\u0011\t)'a\u001a\u0003!1K7\u000f^(gMN,Go\u001d+pa&\u001c'\u0002BA0\u0003CBq!a\u001b\u0012\u0001\u0004\ti'\u0001\u0002uaB!\u0011qNA9\u001b\u0005A\u0018bAA:q\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA<#\u0001\u0007\u0011\u0011P\u0001\ni&lWm\u001d;b[B\u00042\u0001LA>\u0013\r\ti(\f\u0002\u0005\u0019>tw\r\u0003\u0004\u0002\u0002F\u0001\raK\u0001\u000e[\u0006Dh*^7PM\u001a\u001cX\r^:\u0002\u001b\u0019Lg\u000e\u001a)beRLG/[8o)\u0019\t9)!&\u00020B!\u0011\u0011RAH\u001d\u0011\t9%a#\n\t\u00055\u0015\u0011M\u0001\u0018\u0019&\u001cHo\u00144gg\u0016$8OU3ta>t7/\u001a#bi\u0006LA!!%\u0002\u0014\naB*[:u\u001f\u001a47/\u001a;t!\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,'\u0002BAG\u0003CBq!a&\u0013\u0001\u0004\tI*\u0001\u0004u_BL7m\u001d\t\u0007\u00037\u000b)+!+\u000e\u0005\u0005u%\u0002BAP\u0003C\u000bq!\\;uC\ndWMC\u0002\u0002$6\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9+!(\u0003\r\t+hMZ3s!\u0011\tI)a+\n\t\u00055\u00161\u0013\u0002\u0019\u0019&\u001cHo\u00144gg\u0016$8\u000fV8qS\u000e\u0014Vm\u001d9p]N,\u0007bBA6%\u0001\u0007\u0011Q\u000e")
public class LogOffsetTest
extends BaseRequestTest {
    private MockTime time;
    private volatile boolean bitmap$0;

    private MockTime time$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.time = new MockTime();
                this.bitmap$0 = true;
            }
        }
        return this.time;
    }

    private MockTime time() {
        if (!this.bitmap$0) {
            return this.time$lzycompute();
        }
        return this.time;
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    public MockTime brokerTime(int brokerId) {
        return this.time();
    }

    @Override
    public void brokerPropertyOverrides(Properties props) {
        props.put("log.flush.interval.messages", "1");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", Integer.toString(300000));
        props.put("log.segment.bytes", "140");
    }

    @Test
    public void testGetOffsetsForUnknownTopic() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        ListOffsetsRequest request = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 10)).asJava()).build((short)0);
        ListOffsetsResponse response = this.sendListOffsetsRequest(request);
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala(), topicPartition).errorCode());
    }

    @Test
    public void testGetOffsetsAfterDeleteRecords() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$testGetOffsetsAfterDeleteRecords$1(logManager, topicPartition)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Log for partition [topic,0] should be created");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Log log = (Log)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$1 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()));
        log.flush();
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(3L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        log.deleteOldSegments();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)offsets);
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)consumerOffsets);
    }

    @Test
    public void testGetOffsetsBeforeLatestTime() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$testGetOffsetsBeforeLatestTime$1(logManager, topicPartition)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)LogOffsetTest.$anonfun$testGetOffsetsBeforeLatestTime$2(topicPartition));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Log log = (Log)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$2 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()));
        log.flush();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new FetchRequest.PartitionData(Predef$.MODULE$.Long2long((Long)consumerOffsets.head()), -1L, 307200, Optional.empty()))}))).asJava()).build();
        Assertions.assertFalse((boolean)((MemoryRecords)((FetchResponse.PartitionData)this.sendFetchRequest(fetchRequest).responseData().get(topicPartition)).records()).batches().iterator().hasNext());
    }

    @Test
    public void testEmptyLogsGetOffsets() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(10));
        String topicPartitionPath = new java.lang.StringBuilder(2).append(TestUtils.tempDirectory(null, null).getAbsolutePath()).append("/").append(topic).append("-").append(topicPartition.partition()).toString();
        new File(topicPartitionPath).mkdir();
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        BooleanRef offsetChanged = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 14).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            TopicPartition topicPartition = new TopicPartition(topic, 0);
            ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -2L, 1)).asJava()).build();
            if (BoxesRunTime.equals((Object)CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala().head(), (Object)BoxesRunTime.boxToInteger((int)1))) {
                offsetChanged$1.elem = true;
                return;
            }
        });
        Assertions.assertFalse((boolean)offsetChanged.elem);
    }

    @Test
    public void testGetOffsetsBeforeNow() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        Log log = logManager.getOrCreateLog(topicPartition, logManager.getOrCreateLog$default$2(), logManager.getOrCreateLog$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$4 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()));
        log.flush();
        long now = this.time().milliseconds() + 30000L;
        Seq offsets = log.legacyFetchOffsetsBefore(now, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, now, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
    }

    @Test
    public void testGetOffsetsBeforeEarliestTime() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        Log log = logManager.getOrCreateLog(topicPartition, logManager.getOrCreateLog$default$2(), logManager.getOrCreateLog$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$5 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()));
        log.flush();
        Seq offsets = log.legacyFetchOffsetsBefore(-2L, 10);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L})), (Object)offsets);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -2L, 10)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L})), (Object)consumerOffsets);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegmentSize() {
        Log log = (Log)EasyMock.niceMock(Log.class);
        LogSegment logSegment = (LogSegment)EasyMock.niceMock(LogSegment.class);
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).andStubAnswer((IAnswer)new IAnswer<Object>(null){
            private final AtomicInteger value;

            private AtomicInteger value() {
                return this.value;
            }

            public int answer() {
                return this.value().getAndIncrement();
            }
            {
                this.value = new AtomicInteger(0);
            }
        });
        EasyMock.replay((Object[])new Object[]{logSegment});
        scala.collection.immutable.Seq logSegments = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{logSegment}));
        EasyMock.expect((Object)log.logSegments()).andStubReturn((Object)logSegments);
        EasyMock.replay((Object[])new Object[]{log});
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegments() {
        Log log = (Log)EasyMock.niceMock(Log.class);
        LogSegment logSegment = (LogSegment)EasyMock.niceMock(LogSegment.class);
        EasyMock.expect((Object)log.logSegments()).andStubAnswer((IAnswer)new IAnswer<Iterable<LogSegment>>(null, logSegment){
            public final LogSegment logSegment$1;

            public Iterable<LogSegment> answer() {
                return new Iterable<LogSegment>(this){
                    private final /* synthetic */ $anon$2 $outer;

                    public final Iterable<LogSegment> toIterable() {
                        return Iterable.toIterable$((Iterable)this);
                    }

                    public final Iterable<LogSegment> coll() {
                        return Iterable.coll$((Iterable)this);
                    }

                    public IterableFactory<Iterable> iterableFactory() {
                        return Iterable.iterableFactory$((Iterable)this);
                    }

                    public Iterable<LogSegment> seq() {
                        return Iterable.seq$((Iterable)this);
                    }

                    public String className() {
                        return Iterable.className$((Iterable)this);
                    }

                    public final String collectionClassName() {
                        return Iterable.collectionClassName$((Iterable)this);
                    }

                    public String stringPrefix() {
                        return Iterable.stringPrefix$((Iterable)this);
                    }

                    public String toString() {
                        return Iterable.toString$((Iterable)this);
                    }

                    public <B> LazyZip2<LogSegment, B, Iterable> lazyZip(Iterable<B> that) {
                        return Iterable.lazyZip$((Iterable)this, that);
                    }

                    public IterableOps fromSpecific(IterableOnce coll) {
                        return IterableFactoryDefaults.fromSpecific$((IterableFactoryDefaults)this, (IterableOnce)coll);
                    }

                    public Builder<LogSegment, Iterable<LogSegment>> newSpecificBuilder() {
                        return IterableFactoryDefaults.newSpecificBuilder$((IterableFactoryDefaults)this);
                    }

                    public IterableOps empty() {
                        return IterableFactoryDefaults.empty$((IterableFactoryDefaults)this);
                    }

                    public final Iterable<LogSegment> toTraversable() {
                        return IterableOps.toTraversable$((IterableOps)this);
                    }

                    public boolean isTraversableAgain() {
                        return IterableOps.isTraversableAgain$((IterableOps)this);
                    }

                    public final Object repr() {
                        return IterableOps.repr$((IterableOps)this);
                    }

                    public IterableFactory<Iterable> companion() {
                        return IterableOps.companion$((IterableOps)this);
                    }

                    public Object head() {
                        return IterableOps.head$((IterableOps)this);
                    }

                    public Option<LogSegment> headOption() {
                        return IterableOps.headOption$((IterableOps)this);
                    }

                    public Object last() {
                        return IterableOps.last$((IterableOps)this);
                    }

                    public Option<LogSegment> lastOption() {
                        return IterableOps.lastOption$((IterableOps)this);
                    }

                    public View<LogSegment> view() {
                        return IterableOps.view$((IterableOps)this);
                    }

                    public int sizeCompare(int otherSize) {
                        return IterableOps.sizeCompare$((IterableOps)this, (int)otherSize);
                    }

                    public final IterableOps sizeIs() {
                        return IterableOps.sizeIs$((IterableOps)this);
                    }

                    public int sizeCompare(Iterable<?> that) {
                        return IterableOps.sizeCompare$((IterableOps)this, that);
                    }

                    public View<LogSegment> view(int from, int until) {
                        return IterableOps.view$((IterableOps)this, (int)from, (int)until);
                    }

                    public Object transpose(Function1 asIterable) {
                        return IterableOps.transpose$((IterableOps)this, (Function1)asIterable);
                    }

                    public Object filter(Function1 pred) {
                        return IterableOps.filter$((IterableOps)this, (Function1)pred);
                    }

                    public Object filterNot(Function1 pred) {
                        return IterableOps.filterNot$((IterableOps)this, (Function1)pred);
                    }

                    public WithFilter<LogSegment, Iterable> withFilter(Function1<LogSegment, Object> p) {
                        return IterableOps.withFilter$((IterableOps)this, p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> partition(Function1<LogSegment, Object> p) {
                        return IterableOps.partition$((IterableOps)this, p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> splitAt(int n) {
                        return IterableOps.splitAt$((IterableOps)this, (int)n);
                    }

                    public Object take(int n) {
                        return IterableOps.take$((IterableOps)this, (int)n);
                    }

                    public Object takeRight(int n) {
                        return IterableOps.takeRight$((IterableOps)this, (int)n);
                    }

                    public Object takeWhile(Function1 p) {
                        return IterableOps.takeWhile$((IterableOps)this, (Function1)p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> span(Function1<LogSegment, Object> p) {
                        return IterableOps.span$((IterableOps)this, p);
                    }

                    public Object drop(int n) {
                        return IterableOps.drop$((IterableOps)this, (int)n);
                    }

                    public Object dropRight(int n) {
                        return IterableOps.dropRight$((IterableOps)this, (int)n);
                    }

                    public Object dropWhile(Function1 p) {
                        return IterableOps.dropWhile$((IterableOps)this, (Function1)p);
                    }

                    public Iterator<Iterable<LogSegment>> grouped(int size) {
                        return IterableOps.grouped$((IterableOps)this, (int)size);
                    }

                    public Iterator<Iterable<LogSegment>> sliding(int size) {
                        return IterableOps.sliding$((IterableOps)this, (int)size);
                    }

                    public Iterator<Iterable<LogSegment>> sliding(int size, int step) {
                        return IterableOps.sliding$((IterableOps)this, (int)size, (int)step);
                    }

                    public Object tail() {
                        return IterableOps.tail$((IterableOps)this);
                    }

                    public Object init() {
                        return IterableOps.init$((IterableOps)this);
                    }

                    public Object slice(int from, int until) {
                        return IterableOps.slice$((IterableOps)this, (int)from, (int)until);
                    }

                    public <K> scala.collection.immutable.Map<K, Iterable<LogSegment>> groupBy(Function1<LogSegment, K> f) {
                        return IterableOps.groupBy$((IterableOps)this, f);
                    }

                    public <K, B> scala.collection.immutable.Map<K, Iterable<B>> groupMap(Function1<LogSegment, K> key, Function1<LogSegment, B> f) {
                        return IterableOps.groupMap$((IterableOps)this, key, f);
                    }

                    public <K, B> scala.collection.immutable.Map<K, B> groupMapReduce(Function1<LogSegment, K> key, Function1<LogSegment, B> f, Function2<B, B, B> reduce) {
                        return IterableOps.groupMapReduce$((IterableOps)this, key, f, reduce);
                    }

                    public Object scan(Object z, Function2 op) {
                        return IterableOps.scan$((IterableOps)this, (Object)z, (Function2)op);
                    }

                    public Object scanLeft(Object z, Function2 op) {
                        return IterableOps.scanLeft$((IterableOps)this, (Object)z, (Function2)op);
                    }

                    public Object scanRight(Object z, Function2 op) {
                        return IterableOps.scanRight$((IterableOps)this, (Object)z, (Function2)op);
                    }

                    public Object map(Function1 f) {
                        return IterableOps.map$((IterableOps)this, (Function1)f);
                    }

                    public Object flatMap(Function1 f) {
                        return IterableOps.flatMap$((IterableOps)this, (Function1)f);
                    }

                    public Object flatten(Function1 asIterable) {
                        return IterableOps.flatten$((IterableOps)this, (Function1)asIterable);
                    }

                    public Object collect(PartialFunction pf) {
                        return IterableOps.collect$((IterableOps)this, (PartialFunction)pf);
                    }

                    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> partitionMap(Function1<LogSegment, Either<A1, A2>> f) {
                        return IterableOps.partitionMap$((IterableOps)this, f);
                    }

                    public Object concat(IterableOnce suffix) {
                        return IterableOps.concat$((IterableOps)this, (IterableOnce)suffix);
                    }

                    public final Object $plus$plus(IterableOnce suffix) {
                        return IterableOps.$plus$plus$((IterableOps)this, (IterableOnce)suffix);
                    }

                    public Object zip(IterableOnce that) {
                        return IterableOps.zip$((IterableOps)this, (IterableOnce)that);
                    }

                    public Object zipWithIndex() {
                        return IterableOps.zipWithIndex$((IterableOps)this);
                    }

                    public Object zipAll(Iterable that, Object thisElem, Object thatElem) {
                        return IterableOps.zipAll$((IterableOps)this, (Iterable)that, (Object)thisElem, (Object)thatElem);
                    }

                    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<LogSegment, Tuple2<A1, A2>> asPair) {
                        return IterableOps.unzip$((IterableOps)this, asPair);
                    }

                    public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<LogSegment, Tuple3<A1, A2, A3>> asTriple) {
                        return IterableOps.unzip3$((IterableOps)this, asTriple);
                    }

                    public Iterator<Iterable<LogSegment>> tails() {
                        return IterableOps.tails$((IterableOps)this);
                    }

                    public Iterator<Iterable<LogSegment>> inits() {
                        return IterableOps.inits$((IterableOps)this);
                    }

                    public Object tapEach(Function1 f) {
                        return IterableOps.tapEach$((IterableOps)this, (Function1)f);
                    }

                    public Object $plus$plus$colon(IterableOnce that) {
                        return IterableOps.$plus$plus$colon$((IterableOps)this, (IterableOnce)that);
                    }

                    public boolean hasDefiniteSize() {
                        return IterableOnceOps.hasDefiniteSize$((IterableOnceOps)this);
                    }

                    public <U> void foreach(Function1<LogSegment, U> f) {
                        IterableOnceOps.foreach$((IterableOnceOps)this, f);
                    }

                    public boolean forall(Function1<LogSegment, Object> p) {
                        return IterableOnceOps.forall$((IterableOnceOps)this, p);
                    }

                    public boolean exists(Function1<LogSegment, Object> p) {
                        return IterableOnceOps.exists$((IterableOnceOps)this, p);
                    }

                    public int count(Function1<LogSegment, Object> p) {
                        return IterableOnceOps.count$((IterableOnceOps)this, p);
                    }

                    public Option<LogSegment> find(Function1<LogSegment, Object> p) {
                        return IterableOnceOps.find$((IterableOnceOps)this, p);
                    }

                    public <B> B foldLeft(B z, Function2<B, LogSegment, B> op) {
                        return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
                    }

                    public <B> B foldRight(B z, Function2<LogSegment, B, B> op) {
                        return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
                    }

                    public final <B> B $div$colon(B z, Function2<B, LogSegment, B> op) {
                        return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
                    }

                    public final <B> B $colon$bslash(B z, Function2<LogSegment, B, B> op) {
                        return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
                    }

                    public <B> B reduce(Function2<B, B, B> op) {
                        return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
                    }

                    public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                        return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
                    }

                    public <B> B reduceLeft(Function2<B, LogSegment, B> op) {
                        return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
                    }

                    public <B> B reduceRight(Function2<LogSegment, B, B> op) {
                        return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, LogSegment, B> op) {
                        return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<LogSegment, B, B> op) {
                        return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
                    }

                    public boolean isEmpty() {
                        return IterableOnceOps.isEmpty$((IterableOnceOps)this);
                    }

                    public boolean nonEmpty() {
                        return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
                    }

                    public final <B> void copyToBuffer(Buffer<B> dest) {
                        IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
                    }

                    public <B> int copyToArray(Object xs) {
                        return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
                    }

                    public <B> int copyToArray(Object xs, int start) {
                        return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
                    }

                    public <B> int copyToArray(Object xs, int start, int len) {
                        return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
                    }

                    public Object min(Ordering ord) {
                        return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
                    }

                    public <B> Option<LogSegment> minOption(Ordering<B> ord) {
                        return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
                    }

                    public Object max(Ordering ord) {
                        return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
                    }

                    public <B> Option<LogSegment> maxOption(Ordering<B> ord) {
                        return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> Option<LogSegment> maxByOption(Function1<LogSegment, B> f, Ordering<B> cmp) {
                        return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> Option<LogSegment> minByOption(Function1<LogSegment, B> f, Ordering<B> cmp) {
                        return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<LogSegment, B> pf) {
                        return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, LogSegment, B> seqop, Function2<B, B, B> combop) {
                        return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
                    }

                    public <B> boolean corresponds(IterableOnce<B> that, Function2<LogSegment, B, Object> p) {
                        return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
                    }

                    public final String mkString(String start, String sep, String end) {
                        return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
                    }

                    public final String mkString(String sep) {
                        return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
                    }

                    public final String mkString() {
                        return IterableOnceOps.mkString$((IterableOnceOps)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public final StringBuilder addString(StringBuilder b, String sep) {
                        return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
                    }

                    public final StringBuilder addString(StringBuilder b) {
                        return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
                    }

                    public <C1> C1 to(Factory<LogSegment, C1> factory) {
                        return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
                    }

                    public final Iterator<LogSegment> toIterator() {
                        return IterableOnceOps.toIterator$((IterableOnceOps)this);
                    }

                    public List<LogSegment> toList() {
                        return IterableOnceOps.toList$((IterableOnceOps)this);
                    }

                    public Vector<LogSegment> toVector() {
                        return IterableOnceOps.toVector$((IterableOnceOps)this);
                    }

                    public <K, V> scala.collection.immutable.Map<K, V> toMap(.less.colon.less<LogSegment, Tuple2<K, V>> ev) {
                        return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
                    }

                    public <B> Set<B> toSet() {
                        return IterableOnceOps.toSet$((IterableOnceOps)this);
                    }

                    public scala.collection.immutable.Seq<LogSegment> toSeq() {
                        return IterableOnceOps.toSeq$((IterableOnceOps)this);
                    }

                    public IndexedSeq<LogSegment> toIndexedSeq() {
                        return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
                    }

                    public final Stream<LogSegment> toStream() {
                        return IterableOnceOps.toStream$((IterableOnceOps)this);
                    }

                    public final <B> Buffer<B> toBuffer() {
                        return IterableOnceOps.toBuffer$((IterableOnceOps)this);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$2) {
                        return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
                    }

                    public Iterable<LogSegment> reversed() {
                        return IterableOnceOps.reversed$((IterableOnceOps)this);
                    }

                    public <S extends Stepper<?>> S stepper(StepperShape<LogSegment, S> shape) {
                        return (S)IterableOnce.stepper$((IterableOnce)this, shape);
                    }

                    public int knownSize() {
                        return IterableOnce.knownSize$((IterableOnce)this);
                    }

                    public int size() {
                        return 2;
                    }

                    public Iterator<LogSegment> iterator() {
                        return package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{this.$outer.logSegment$1})).iterator();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        IterableOnce.$init$((IterableOnce)this);
                        IterableOnceOps.$init$((IterableOnceOps)this);
                        IterableOps.$init$((IterableOps)this);
                        IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
                        Iterable.$init$((Iterable)this);
                    }
                };
            }
            {
                this.logSegment$1 = logSegment$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logSegment});
        EasyMock.replay((Object[])new Object[]{log});
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    private KafkaServer server() {
        return (KafkaServer)this.servers().head();
    }

    private ListOffsetsResponse sendListOffsetsRequest(ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private FetchResponse<MemoryRecords> sendFetchRequest(FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private List<ListOffsetsRequestData.ListOffsetsTopic> buildTargetTimes(TopicPartition tp, long timestamp, int maxNumOffsets) {
        return (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ListOffsetsRequestData.ListOffsetsTopic[]{new ListOffsetsRequestData.ListOffsetsTopic().setName(tp.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ListOffsetsRequestData.ListOffsetsPartition[]{new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(tp.partition()).setTimestamp(timestamp).setMaxNumOffsets(maxNumOffsets)}))).asJava())}));
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse findPartition(Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse> topics, TopicPartition tp) {
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)topics.find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$1(tp, x$6))).get()).partitions()).asScala().find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$2(tp, x$7))).get();
    }

    public static final /* synthetic */ boolean $anonfun$testGetOffsetsAfterDeleteRecords$1(LogManager logManager$1, TopicPartition topicPartition$1) {
        return logManager$1.getLog(topicPartition$1, logManager$1.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$2() {
        return "Log for partition [topic,0] should be created";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$5() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ boolean $anonfun$testGetOffsetsBeforeLatestTime$1(LogManager logManager$2, TopicPartition topicPartition$2) {
        return logManager$2.getLog(topicPartition$2, logManager$2.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$2(TopicPartition topicPartition$2) {
        return new java.lang.StringBuilder(36).append("Log for partition ").append(topicPartition$2).append(" should be created").toString();
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$5() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeNow$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeEarliestTime$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$1(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$6) {
        String string = x$6.name();
        String string2 = tp$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$2(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$7) {
        return x$7.partitionIndex() == tp$1.partition();
    }
}

