/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.network.SocketServer;
import kafka.server.AbstractMetadataRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005Y3AAE\n\u00011!)Q\u0004\u0001C\u0001=!)\u0001\u0005\u0001C!C!)Q\u0007\u0001C\u0001C!)!\b\u0001C\u0001C!)A\b\u0001C\u0001C!)a\b\u0001C\u0001C!)\u0001\t\u0001C\u0001C!)!\t\u0001C\u0001C!)A\t\u0001C\u0001C!)a\t\u0001C\u0001C!)\u0001\n\u0001C\u0001C!)!\n\u0001C\u0001C!)A\n\u0001C\u0001C!)a\n\u0001C\u0001C!)\u0001\u000b\u0001C\u0001C!)!\u000b\u0001C\u0001C!)A\u000b\u0001C\u0001C\t\u0019R*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fV3ti*\u0011A#F\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003Y\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00013A\u0011!dG\u0007\u0002'%\u0011Ad\u0005\u0002\u001c\u0003\n\u001cHO]1di6+G/\u00193bi\u0006\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u000e\u0001\u0003\u0015\u0019X\r^+q)\u0005\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#\u0001B+oSRD#AA\u0015\u0011\u0005)\u001aT\"A\u0016\u000b\u00051j\u0013aA1qS*\u0011afL\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0001\u0014'A\u0003kk:LGOC\u00013\u0003\ry'oZ\u0005\u0003i-\u0012!BQ3g_J,W)Y2i\u0003\u0001\"Xm\u001d;DYV\u001cH/\u001a:JI^KG\u000f\u001b*fcV,7\u000f\u001e,feNLwN\\\u0019)\u0005\r9\u0004C\u0001\u00169\u0013\tI4F\u0001\u0003UKN$\u0018\u0001\u0006;fgR\u001cE.^:uKJLE-S:WC2LG\r\u000b\u0002\u0005o\u0005\u0001B/Z:u\u0007>tGO]8mY\u0016\u0014\u0018\n\u001a\u0015\u0003\u000b]\n\u0001\u0002^3tiJ\u000b7m\u001b\u0015\u0003\r]\na\u0002^3ti&\u001b\u0018J\u001c;fe:\fG\u000e\u000b\u0002\bo\u0005\u0019B/Z:u\u001d>$v\u000e]5dgJ+\u0017/^3ti\"\u0012\u0001bN\u0001\u0016i\u0016\u001cH/Q;u_R{\u0007/[2De\u0016\fG/[8oQ\tIq'A\u0018uKN$\u0018)\u001e;p\u0007J,\u0017\r^3U_BL7mV5uQ&sg/\u00197jIJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000f\u000b\u0002\u000bo\u0005yB/Z:u\u0003V$xn\u0011:fCR,wJZ\"pY2LG-\u001b8h)>\u0004\u0018nY:)\u0005-9\u0014\u0001\u0006;fgR\fE\u000e\u001c+pa&\u001c7OU3rk\u0016\u001cH\u000f\u000b\u0002\ro\u00051B/Z:u)>\u0004\u0018nY%eg&s'+Z:q_:\u001cX\r\u000b\u0002\u000eo\u0005!B/Z:u!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006D#AD\u001c\u0002/Q,7\u000f\u001e*fa2L7-\u0019#po:\u0014Vm\u001d9p]N,\u0007FA\b8\u0003\u0019\"Xm\u001d;JgJ\fe\r^3s\u0005J|7.\u001a:TQV$Hi\\<o\u0003:$'j\\5og\n\u000b7m\u001b\u0015\u0003!]\nA\u0004^3ti\u0006c\u0017N^3Ce>\\WM]:XSRDgj\u001c+pa&\u001c7\u000f\u000b\u0002\u0012o\u0001")
public class MetadataRequestTest
extends AbstractMetadataRequestTest {
    @Override
    @BeforeEach
    public void setUp() {
        this.doSetup(false);
    }

    @Test
    public void testClusterIdWithRequestVersion1() {
        Assertions.assertNull((Object)this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2()).clusterId(), (String)"v1 clusterId should be null");
    }

    @Test
    public void testClusterIdIsValid() {
        TestUtils.isValidClusterId((String)this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)2), this.sendMetadataRequest$default$2()).clusterId());
    }

    @Test
    public void testControllerId() {
        KafkaServer controllerServer = (KafkaServer)this.servers().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testControllerId$1(x$1))).get();
        int controllerId = controllerServer.config().brokerId();
        MetadataResponse metadataResponse = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((int)controllerId, (int)metadataResponse.controller().id(), (String)"Controller id should match the active controller");
        controllerServer.shutdown();
        controllerServer.startup();
        KafkaServer controllerServer2 = (KafkaServer)this.servers().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testControllerId$2(x$2))).get();
        int controllerId2 = controllerServer2.config().brokerId();
        Assertions.assertNotEquals((int)controllerId, (int)controllerId2, (String)"Controller id should switch to a new broker");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 5000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataRequestTest.$anonfun$testControllerId$3(this, controllerServer2)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Controller id should match the active controller after failover");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
    }

    @Test
    public void testRack() {
        this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2()).brokers().forEach(broker -> Assertions.assertEquals((Object)new StringBuilder(5).append("rack/").append(broker.id()).toString(), (Object)broker.rack(), (String)"Rack information should match config"));
    }

    @Test
    public void testIsInternal() {
        String internalTopic = "__consumer_offsets";
        String notInternalTopic = "notInternal";
        this.createTopic(internalTopic, 3, 2, this.createTopic$default$4());
        this.createTopic(notInternalTopic, 3, 2, this.createTopic$default$4());
        MetadataResponse metadataResponse = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        Assertions.assertTrue((boolean)metadataResponse.errors().isEmpty(), (String)"Response should have no errors");
        Iterable topicMetadata = CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.topicMetadata()).asScala();
        MetadataResponse.TopicMetadata internalTopicMetadata = (MetadataResponse.TopicMetadata)topicMetadata.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsInternal$1(internalTopic, x$3))).get();
        MetadataResponse.TopicMetadata notInternalTopicMetadata = (MetadataResponse.TopicMetadata)topicMetadata.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsInternal$2(notInternalTopic, x$4))).get();
        Assertions.assertTrue((boolean)internalTopicMetadata.isInternal(), (String)"internalTopic should show isInternal");
        Assertions.assertFalse((boolean)notInternalTopicMetadata.isInternal(), (String)"notInternalTopic topic not should show isInternal");
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{internalTopic}))).asJava(), (Object)metadataResponse.cluster().internalTopics());
    }

    @Test
    public void testNoTopicsRequest() {
        this.createTopic("t1", 3, 2, this.createTopic$default$4());
        this.createTopic("t2", 3, 2, this.createTopic$default$4());
        MetadataResponse metadataResponse = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$)).asJava(), true, (short)1).build(), this.sendMetadataRequest$default$2());
        Assertions.assertTrue((boolean)metadataResponse.errors().isEmpty(), (String)"Response should have no errors");
        Assertions.assertTrue((boolean)metadataResponse.topicMetadata().isEmpty(), (String)"Response should have no topics");
    }

    @Test
    public void testAutoTopicCreation() {
        String topic1 = "t1";
        String topic2 = "t2";
        String topic3 = "t3";
        String topic4 = "t4";
        String topic5 = "t5";
        this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assertions.assertNull(response1.errors().get(topic1));
        this.checkAutoCreatedTopic(topic2, response1);
        MetadataResponse response2 = this.sendMetadataRequest(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)).asJava(), true).build((short)1), this.sendMetadataRequest$default$2());
        this.checkAutoCreatedTopic(topic3, response2);
        Assertions.assertThrows(UnsupportedVersionException.class, () -> this.sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic4}))), false), (short)3), this.sendMetadataRequest$default$2()));
        MetadataResponse response3 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic4, (List)new .colon.colon((Object)topic5, (List)Nil$.MODULE$))).asJava(), false, (short)4).build(), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response3.errors().get(topic4));
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response3.errors().get(topic5));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionCount(topic5));
    }

    @Test
    public void testAutoCreateTopicWithInvalidReplicationFactor() {
        ((IterableOnceOps)this.servers().tail()).foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)this.servers().tail()).foreach((Function1 & Serializable)x$6 -> {
            x$6.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        String topic1 = "testAutoCreateTopic";
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((int)1, (int)response1.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response1.topicMetadata()).asScala().head();
        Assertions.assertEquals((Object)Errors.INVALID_REPLICATION_FACTOR, (Object)topicMetadata.error());
        Assertions.assertEquals((Object)topic1, (Object)topicMetadata.topic());
        Assertions.assertEquals((int)0, (int)topicMetadata.partitionMetadata().size());
    }

    @Test
    public void testAutoCreateOfCollidingTopics() {
        String topic1 = "testAutoCreate.Topic";
        String topic2 = "testAutoCreate_Topic";
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((int)2, (int)response1.topicMetadata().size());
        scala.collection.immutable.Map responseMap = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(response1.topicMetadata()).asScala().map((Function1 & Serializable)metadata -> new Tuple2((Object)metadata.topic(), (Object)metadata.error()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), (Object)responseMap.keySet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Errors[]{Errors.LEADER_NOT_AVAILABLE, Errors.INVALID_TOPIC_EXCEPTION})), (Object)responseMap.values().toSet());
        String topicCreated = (String)((Tuple2)responseMap.head())._1();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topicCreated, 0, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        TestUtils$.MODULE$.waitForPartitionMetadata((Seq<KafkaServer>)this.servers(), topicCreated, 0, 15000L);
        MetadataResponse response2 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicCreated, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        MetadataResponse.TopicMetadata topicMetadata1 = (MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response2.topicMetadata()).asScala().head();
        Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata1.error());
        Assertions.assertEquals((Object)new .colon.colon((Object)Errors.NONE, (List)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata1.partitionMetadata()).asScala().map((Function1 & Serializable)x$7 -> x$7.error));
        Assertions.assertEquals((int)1, (int)topicMetadata1.partitionMetadata().size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata1.partitionMetadata()).asScala().head();
        Assertions.assertEquals((int)0, (int)partitionMetadata.partition());
        Assertions.assertEquals((int)2, (int)partitionMetadata.replicaIds.size());
        Assertions.assertTrue((boolean)partitionMetadata.leaderId.isPresent());
        Assertions.assertTrue((Predef$.MODULE$.Integer2int((Integer)partitionMetadata.leaderId.get()) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAllTopicsRequest() {
        this.createTopic("t1", 3, 2, this.createTopic$default$4());
        this.createTopic("t2", 3, 2, this.createTopic$default$4());
        MetadataResponse metadataResponseV0 = this.sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), true), (short)0), this.sendMetadataRequest$default$2());
        Assertions.assertTrue((boolean)metadataResponseV0.errors().isEmpty(), (String)"V0 Response should have no errors");
        Assertions.assertEquals((int)2, (int)metadataResponseV0.topicMetadata().size(), (String)"V0 Response should have 2 (all) topics");
        MetadataResponse metadataResponseV1 = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        Assertions.assertTrue((boolean)metadataResponseV1.errors().isEmpty(), (String)"V1 Response should have no errors");
        Assertions.assertEquals((int)2, (int)metadataResponseV1.topicMetadata().size(), (String)"V1 Response should have 2 (all) topics");
    }

    @Test
    public void testTopicIdsInResponse() {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, (Map<Object, Seq<Object>>)replicaAssignment);
        this.createTopic(topic2, (Map<Object, Seq<Object>>)replicaAssignment);
        MetadataResponse resp1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true, 0, 9).build(), (Option<SocketServer>)new Some((Object)this.controllerSocketServer()));
        Assertions.assertEquals((int)2, (int)resp1.topicMetadata().size());
        resp1.topicMetadata().forEach(topicMetadata -> {
            Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
            Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)topicMetadata.topicId());
        });
        MetadataResponse resp2 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true, 10, 10).build(), (Option<SocketServer>)new Some((Object)this.notControllerSocketServer()));
        Assertions.assertEquals((int)2, (int)resp2.topicMetadata().size());
        resp2.topicMetadata().forEach(topicMetadata -> {
            Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
            Assertions.assertNotEquals((Object)Uuid.ZERO_UUID, (Object)topicMetadata.topicId());
            Assertions.assertNotNull((Object)topicMetadata.topicId());
        });
    }

    @Test
    public void testPreferredReplica() {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        this.createTopic("t1", (Map<Object, Seq<Object>>)replicaAssignment);
        new .colon.colon((Object)this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"t1", (List)Nil$.MODULE$)).asJava(), true).build(), (Option<SocketServer>)new Some((Object)this.controllerSocketServer())), (List)new .colon.colon((Object)this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"t1", (List)Nil$.MODULE$)).asJava(), true).build(), (Option<SocketServer>)new Some((Object)this.notControllerSocketServer())), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)response -> {
            MetadataRequestTest.$anonfun$testPreferredReplica$1(replicaAssignment, response);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testReplicaDownResponse() {
        String replicaDownTopic = "replicaDown";
        int replicaCount = 3;
        this.createTopic(replicaDownTopic, 1, replicaCount, this.createTopic$default$4());
        MetadataResponse metadataResponse = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{replicaDownTopic}))).asJava(), true).build(), this.sendMetadataRequest$default$2());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.topicMetadata()).asScala().head()).partitionMetadata()).asScala().head();
        KafkaServer downNode = (KafkaServer)this.servers().find((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testReplicaDownResponse$1(partitionMetadata, server))).get();
        downNode.shutdown();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 5000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataRequestTest.$anonfun$testReplicaDownResponse$2(this, replicaDownTopic, downNode)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Replica was not found down");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        MetadataResponse v0MetadataResponse = this.sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{replicaDownTopic}))), true), (short)0), this.sendMetadataRequest$default$2());
        scala.collection.immutable.Seq v0BrokerIds = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(v0MetadataResponse.brokers()).asScala().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()))).toSeq();
        Assertions.assertTrue((boolean)v0MetadataResponse.errors().isEmpty(), (String)"Response should have no errors");
        Assertions.assertFalse((boolean)v0BrokerIds.contains((Object)BoxesRunTime.boxToInteger((int)downNode.config().brokerId())), (String)"The downed broker should not be in the brokers list");
        Assertions.assertTrue((v0MetadataResponse.topicMetadata().size() == 1 ? 1 : 0) != 0, (String)"Response should have one topic");
        MetadataResponse.PartitionMetadata v0PartitionMetadata = (MetadataResponse.PartitionMetadata)CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(v0MetadataResponse.topicMetadata()).asScala().head()).partitionMetadata()).asScala().head();
        Errors errors = v0PartitionMetadata.error;
        Errors errors2 = Errors.REPLICA_NOT_AVAILABLE;
        Assertions.assertTrue((!(errors != null ? !errors.equals(errors2) : errors2 != null) ? 1 : 0) != 0, (String)"PartitionMetadata should have an error");
        Assertions.assertTrue((v0PartitionMetadata.replicaIds.size() == replicaCount - 1 ? 1 : 0) != 0, (String)new StringBuilder(30).append("Response should have ").append(replicaCount - 1).append(" replicas").toString());
        MetadataResponse v1MetadataResponse = this.sendMetadataRequest(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{replicaDownTopic}))).asJava(), true).build((short)1), this.sendMetadataRequest$default$2());
        scala.collection.immutable.Seq v1BrokerIds = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(v1MetadataResponse.brokers()).asScala().map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.id()))).toSeq();
        Assertions.assertTrue((boolean)v1MetadataResponse.errors().isEmpty(), (String)"Response should have no errors");
        Assertions.assertFalse((boolean)v1BrokerIds.contains((Object)BoxesRunTime.boxToInteger((int)downNode.config().brokerId())), (String)"The downed broker should not be in the brokers list");
        Assertions.assertEquals((int)1, (int)v1MetadataResponse.topicMetadata().size(), (String)"Response should have one topic");
        MetadataResponse.PartitionMetadata v1PartitionMetadata = (MetadataResponse.PartitionMetadata)CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(v1MetadataResponse.topicMetadata()).asScala().head()).partitionMetadata()).asScala().head();
        Assertions.assertEquals((Object)Errors.NONE, (Object)v1PartitionMetadata.error, (String)"PartitionMetadata should have no errors");
        Assertions.assertEquals((int)replicaCount, (int)v1PartitionMetadata.replicaIds.size(), (String)new StringBuilder(30).append("Response should have ").append(replicaCount).append(" replicas").toString());
    }

    @Test
    public void testIsrAfterBrokerShutDownAndJoinsBack() {
        String topic = "isr-after-broker-shutdown";
        int replicaCount = 3;
        this.createTopic(topic, 1, replicaCount, this.createTopic$default$4());
        ((KafkaServer)this.servers().last()).shutdown();
        ((KafkaServer)this.servers().last()).awaitShutdown();
        ((KafkaServer)this.servers().last()).startup();
        this.checkIsr$1((Seq)this.servers(), topic);
    }

    @Test
    public void testAliveBrokersWithNoTopics() {
        KafkaServer serverToShutdown = (KafkaServer)((IterableOps)this.servers().filterNot((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$11(x$20)))).last();
        serverToShutdown.shutdown();
        serverToShutdown.awaitShutdown();
        this.checkMetadata$1((Seq)this.servers(), this.servers().size() - 1);
        serverToShutdown.startup();
        this.checkMetadata$1((Seq)this.servers(), this.servers().size());
    }

    public static final /* synthetic */ boolean $anonfun$testControllerId$1(KafkaServer x$1) {
        return x$1.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testControllerId$2(KafkaServer x$2) {
        return x$2.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testControllerId$3(MetadataRequestTest $this, KafkaServer controllerServer2$1) {
        MetadataResponse metadataResponse2 = $this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), $this.sendMetadataRequest$default$2());
        return metadataResponse2.controller() != null && controllerServer2$1.dataPlaneRequestProcessor().brokerId() == metadataResponse2.controller().id();
    }

    public static final /* synthetic */ String $anonfun$testControllerId$4() {
        return "Controller id should match the active controller after failover";
    }

    public static final /* synthetic */ boolean $anonfun$testIsInternal$1(String internalTopic$1, MetadataResponse.TopicMetadata x$3) {
        String string = x$3.topic();
        return !(string != null ? !string.equals(internalTopic$1) : internalTopic$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testIsInternal$2(String notInternalTopic$1, MetadataResponse.TopicMetadata x$4) {
        String string = x$4.topic();
        return !(string != null ? !string.equals(notInternalTopic$1) : notInternalTopic$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testPreferredReplica$1(scala.collection.immutable.Map replicaAssignment$1, MetadataResponse response) {
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)response.topicMetadata().iterator().next();
        Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        Assertions.assertEquals((Object)"t1", (Object)topicMetadata.topic());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitionMetadata()).asScala().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.partition()))).toSet());
        topicMetadata.partitionMetadata().forEach(partitionMetadata -> {
            Seq assignment = (Seq)replicaAssignment$1.apply((Object)BoxesRunTime.boxToInteger((int)partitionMetadata.partition()));
            Assertions.assertEquals((Object)assignment, (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaIds).asScala());
            Assertions.assertEquals((Object)assignment, (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.inSyncReplicaIds).asScala());
            Assertions.assertEquals(Optional.of(assignment.head()), (Object)partitionMetadata.leaderId);
        });
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$1(MetadataResponse.PartitionMetadata partitionMetadata$1, KafkaServer server) {
        int serverId = server.dataPlaneRequestProcessor().brokerId();
        Optional leaderId = partitionMetadata$1.leaderId;
        Buffer replicaIds = CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata$1.replicaIds).asScala();
        return leaderId.isPresent() && !BoxesRunTime.equals(leaderId.get(), (Object)BoxesRunTime.boxToInteger((int)serverId)) && replicaIds.contains((Object)BoxesRunTime.boxToInteger((int)serverId));
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$3(KafkaServer downNode$1, Node x$9) {
        return x$9.id() == downNode$1.dataPlaneRequestProcessor().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$2(MetadataRequestTest $this, String replicaDownTopic$1, KafkaServer downNode$1) {
        MetadataResponse response = $this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{replicaDownTopic$1}))).asJava(), true).build(), $this.sendMetadataRequest$default$2());
        return !CollectionConverters$.MODULE$.CollectionHasAsScala(response.brokers()).asScala().exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testReplicaDownResponse$3(downNode$1, x$9)));
    }

    public static final /* synthetic */ String $anonfun$testReplicaDownResponse$4() {
        return "Replica was not found down";
    }

    public static final /* synthetic */ boolean $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$1(KafkaServer x$12) {
        Object v = x$12.brokerState().get();
        BrokerState brokerState = BrokerState.NOT_RUNNING;
        return v == null ? brokerState != null : !v.equals(brokerState);
    }

    public static final /* synthetic */ int $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$2(KafkaServer x$13) {
        return x$13.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$7(Object x) {
        return BoxesRunTime.unboxToInt((Object)x);
    }

    public static final /* synthetic */ boolean $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$4(MetadataRequestTest $this, String topic$1, KafkaServer broker$1, ObjectRef actualIsr$1, scala.collection.immutable.Set expectedIsr$1) {
        MetadataResponse metadataResponse = $this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic$1, (List)Nil$.MODULE$)).asJava(), false).build(), (Option<SocketServer>)new Some((Object)$this.brokerSocketServer(broker$1.config().brokerId())));
        Option firstPartitionMetadata = CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.topicMetadata()).asScala().headOption().flatMap((Function1 & Serializable)x$14 -> CollectionConverters$.MODULE$.ListHasAsScala(x$14.partitionMetadata()).asScala().headOption());
        actualIsr$1.elem = (scala.collection.immutable.Set)firstPartitionMetadata.map((Function1 & Serializable)partitionMetadata -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.inSyncReplicaIds).asScala().map((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$7(x)))).toSet()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
        scala.collection.immutable.Set set = expectedIsr$1;
        scala.collection.immutable.Set set2 = (scala.collection.immutable.Set)actualIsr$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$9(KafkaServer broker$1, scala.collection.immutable.Set expectedIsr$1, ObjectRef actualIsr$1) {
        return new StringBuilder(0).append(new StringBuilder(48).append("Topic metadata not updated correctly in broker ").append(broker$1).append("\n").toString()).append(new StringBuilder(16).append("Expected ISR: ").append(expectedIsr$1).append(" \n").toString()).append(new StringBuilder(13).append("Actual ISR : ").append((scala.collection.immutable.Set)actualIsr$1.elem).toString()).toString();
    }

    public static final /* synthetic */ void $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$3(MetadataRequestTest $this, String topic$1, scala.collection.immutable.Set expectedIsr$1, KafkaServer broker) {
        Predef$.MODULE$.Set().empty();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            MetadataResponse $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$4_metadataResponse = $this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic$1, (List)Nil$.MODULE$)).asJava(), false).build(), (Option<SocketServer>)new Some((Object)$this.brokerSocketServer(broker.config().brokerId())));
            scala.collection.immutable.Set set = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.CollectionHasAsScala($anonfun$testIsrAfterBrokerShutDownAndJoinsBack$4_metadataResponse.topicMetadata()).asScala().headOption().flatMap((Function1 & Serializable)x$14 -> CollectionConverters$.MODULE$.ListHasAsScala(x$14.partitionMetadata()).asScala().headOption()).map((Function1 & Serializable)partitionMetadata -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.inSyncReplicaIds).asScala().map((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$7(x)))).toSet()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
            scala.collection.immutable.Set set2 = expectedIsr$1;
            Object var10_7 = null;
            if (!(set2 != null ? !set2.equals(set) : set != null)) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)new StringBuilder(0).append(new StringBuilder(48).append("Topic metadata not updated correctly in broker ").append(broker).append("\n").toString()).append(new StringBuilder(16).append("Expected ISR: ").append(expectedIsr$1).append(" \n").toString()).append(new StringBuilder(13).append("Actual ISR : ").append(set).toString()).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    private final void checkIsr$1(Seq servers, String topic) {
        Seq activeBrokers = (Seq)servers.filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$1(x$12)));
        scala.collection.immutable.Set expectedIsr = ((IterableOnceOps)activeBrokers.map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$2(x$13)))).toSet();
        activeBrokers.foreach((Function1 & Serializable)broker -> {
            MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$3(this, topic, expectedIsr, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$1(MetadataRequestTest $this, ObjectRef controllerMetadataResponse$1, int expectedBrokersCount$1) {
        MetadataResponse metadataResponse = $this.sendMetadataRequest((MetadataRequest)MetadataRequest.Builder.allTopics().build(), (Option<SocketServer>)new Some((Object)$this.controllerSocketServer()));
        controllerMetadataResponse$1.elem = new Some((Object)metadataResponse);
        return metadataResponse.brokers().size() == expectedBrokersCount$1;
    }

    public static final /* synthetic */ String $anonfun$testAliveBrokersWithNoTopics$2(int expectedBrokersCount$1, ObjectRef controllerMetadataResponse$1) {
        return new StringBuilder(27).append(new StringBuilder(34).append("Expected ").append(expectedBrokersCount$1).append(" brokers, but there are ").append(((MetadataResponse)((Option)controllerMetadataResponse$1.elem).get()).brokers().size()).append(" ").toString()).append("according to the Controller").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$4(KafkaServer x$16) {
        Object v = x$16.brokerState().get();
        BrokerState brokerState = BrokerState.NOT_RUNNING;
        return v == null ? brokerState != null : !v.equals(brokerState);
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$6(MetadataRequestTest $this, KafkaServer broker$2, scala.collection.immutable.Seq brokersInController$1) {
        MetadataResponse metadataResponse = $this.sendMetadataRequest((MetadataRequest)MetadataRequest.Builder.allTopics().build(), (Option<SocketServer>)new Some((Object)$this.brokerSocketServer(broker$2.config().brokerId())));
        scala.collection.immutable.Seq brokers = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.brokers()).asScala().toSeq().sortBy((Function1 & Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.id()), (Ordering)Ordering.Int$.MODULE$);
        scala.collection.immutable.Seq topicMetadata = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.topicMetadata()).asScala().toSeq().sortBy((Function1 & Serializable)x$18 -> x$18.topic(), (Ordering)Ordering.String$.MODULE$);
        scala.collection.immutable.Seq seq = brokersInController$1;
        if (!(seq != null ? !seq.equals(brokers) : brokers != null)) {
            Object object = CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.topicMetadata()).asScala().toSeq().sortBy((Function1 & Serializable)x$19 -> x$19.topic(), (Ordering)Ordering.String$.MODULE$);
            if (!(object != null ? !object.equals(topicMetadata) : topicMetadata != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testAliveBrokersWithNoTopics$10() {
        return "Topic metadata not updated correctly";
    }

    public static final /* synthetic */ void $anonfun$testAliveBrokersWithNoTopics$5(MetadataRequestTest $this, scala.collection.immutable.Seq brokersInController$1, KafkaServer broker) {
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$6($this, broker, brokersInController$1)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Topic metadata not updated correctly");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    private final void checkMetadata$1(Seq servers, int expectedBrokersCount) {
        Some some;
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            MetadataResponse $anonfun$testAliveBrokersWithNoTopics$1_metadataResponse = this.sendMetadataRequest((MetadataRequest)MetadataRequest.Builder.allTopics().build(), (Option<SocketServer>)new Some((Object)this.controllerSocketServer()));
            some = new Some((Object)$anonfun$testAliveBrokersWithNoTopics$1_metadataResponse);
            Object var10_6 = null;
            if ($anonfun$testAliveBrokersWithNoTopics$1_metadataResponse.brokers().size() == expectedBrokersCount) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)new StringBuilder(27).append(new StringBuilder(34).append("Expected ").append(expectedBrokersCount).append(" brokers, but there are ").append(((MetadataResponse)some.get()).brokers().size()).append(" ").toString()).append("according to the Controller").toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        scala.collection.immutable.Seq brokersInController = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(((MetadataResponse)some.get()).brokers()).asScala().toSeq().sortBy((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.id()), (Ordering)Ordering.Int$.MODULE$);
        ((IterableOnceOps)servers.filter((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$4(x$16)))).foreach((Function1 & Serializable)broker -> {
            MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$5(this, brokersInController, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$11(KafkaServer x$20) {
        return x$20.kafkaController().isActive();
    }
}

