/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import kafka.server.metadata.MetadataPartition;
import kafka.server.metadata.MetadataPartitions;
import kafka.server.metadata.MetadataPartitions$;
import kafka.server.metadata.MetadataPartitionsBuilder;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashSet;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120000L, unit=TimeUnit.MILLISECONDS)
@ScalaSignature(bytes="\u0006\u0005\u0005-f\u0001B\f\u0019\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013%1\u0006\u0003\u00040\u0001\u0001\u0006I\u0001\f\u0005\u0006a\u0001!I!\r\u0005\b3\u0002\t\n\u0011\"\u0003[\u0011\u001d)\u0007!%A\u0005\niCqA\u001a\u0001\u0012\u0002\u0013%q\rC\u0003j\u0001\u0011\u0005!\u000eC\u0003|\u0001\u0011\u0005!\u000eC\u0003~\u0001\u0011\u0005!\u000eC\u0003\u0000\u0001\u0011\u0005!\u000e\u0003\u0004\u0002\u0004\u0001!\tA\u001b\u0005\u0007\u0003\u000f\u0001A\u0011\u00016\t\r\u0005-\u0001\u0001\"\u0001k\u0011\u0019\ty\u0001\u0001C\u0001U\"1\u00111\u0003\u0001\u0005\u0002)Dq!a\u0006\u0001\t\u0013\tI\u0002C\u0004\u0002>\u0001!I!a\u0010\t\u000f\u0005\r\u0003\u0001\"\u0003\u0002F!9\u00111\t\u0001\u0005\n\u00055\u0003bBA+\u0001\u0011%\u0011q\u000b\u0005\b\u0003O\u0002A\u0011BA5\u0005YiU\r^1eCR\f\u0007+\u0019:uSRLwN\\:UKN$(BA\r\u001b\u0003!iW\r^1eCR\f'BA\u000e\u001d\u0003\u0019\u0019XM\u001d<fe*\tQ$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011\u0011\u0006A\u0007\u00021\u0005yQ-\u001c9usB\u000b'\u000f^5uS>t7/F\u0001-!\tIS&\u0003\u0002/1\t\u0011R*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8t\u0003A)W\u000e\u001d;z!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u0007oK^\u0004\u0016M\u001d;ji&|g\u000e\u0006\u00043k\t;Uk\u0016\t\u0003SMJ!\u0001\u000e\r\u0003#5+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|g\u000eC\u00037\t\u0001\u0007q'A\u0005u_BL7MT1nKB\u0011\u0001h\u0010\b\u0003su\u0002\"A\u000f\u0012\u000e\u0003mR!\u0001\u0010\u0010\u0002\rq\u0012xn\u001c;?\u0013\tq$%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0001\u0006\u0013aa\u0015;sS:<'B\u0001 #\u0011\u0015\u0019E\u00011\u0001E\u00039\u0001\u0018M\u001d;ji&|g.\u00138eKb\u0004\"!I#\n\u0005\u0019\u0013#aA%oi\"9\u0001\n\u0002I\u0001\u0002\u0004I\u0015\u0001\u0003:fa2L7-Y:\u0011\u0007\u0005RE*\u0003\u0002LE\t1q\n\u001d;j_:\u00042!\u0014*E\u001d\tq\u0005K\u0004\u0002;\u001f&\t1%\u0003\u0002RE\u00059\u0001/Y2lC\u001e,\u0017BA*U\u0005\r\u0019V-\u001d\u0006\u0003#\nBqA\u0016\u0003\u0011\u0002\u0003\u0007\u0011*A\u0002jgJDq\u0001\u0017\u0003\u0011\u0002\u0003\u0007A)\u0001\u0006ok6\u0014%o\\6feN\faC\\3x!\u0006\u0014H/\u001b;j_:$C-\u001a4bk2$HeM\u000b\u00027*\u0012\u0011\nX\u0016\u0002;B\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\nk:\u001c\u0007.Z2lK\u0012T!A\u0019\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002e?\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002-9,w\u000fU1si&$\u0018n\u001c8%I\u00164\u0017-\u001e7uIQ\naC\\3x!\u0006\u0014H/\u001b;j_:$C-\u001a4bk2$H%N\u000b\u0002Q*\u0012A\tX\u0001\u0014i\u0016\u001cHOQ;jY\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0002WB\u0011\u0011\u0005\\\u0005\u0003[\n\u0012A!\u00168ji\"\u0012\u0001b\u001c\t\u0003afl\u0011!\u001d\u0006\u0003eN\f1!\u00199j\u0015\t!X/A\u0004kkBLG/\u001a:\u000b\u0005Y<\u0018!\u00026v]&$(\"\u0001=\u0002\u0007=\u0014x-\u0003\u0002{c\n!A+Z:u\u0003e!Xm\u001d;BY2\u0004\u0016M\u001d;ji&|gn]%uKJ\fGo\u001c:)\u0005%y\u0017A\u0007;fgRdunY1m\u0007\"\fgnZ3e\u0003:$'+Z7pm\u0016$\u0007F\u0001\u0006p\u0003E!Xm\u001d;BY2$v\u000e]5d\u001d\u0006lWm\u001d\u0015\u0003\u0017=\f\u0001\u0003^3tiV+\u0018\u000eZ'baBLgnZ:)\u00051y\u0017A\b;fgRlUM]4f!\u0006\u0014H/\u001b;j_:\u001c\u0005.\u00198hKJ+7m\u001c:eQ\tiq.\u0001\ruKN$Hk\u001c9jG\u000e\u0013X-\u0019;f\u0003:$G)\u001a7fi\u0016D#AD8\u0002!Q,7\u000f\u001e+pa&\u001c'+Z7pm\u0006d\u0007FA\bp\u0003i!Xm\u001d;U_BL7\rR3mKR,\u0017I\u001c3SK\u000e\u0014X-\u0019;fQ\t\u0001r.\u0001\u0007m_\u000e\fGNU3n_Z,G\r\u0006\u0003\u0002\u001c\u0005M\u0002#\u0002\u001d\u0002\u001e\u0005\u0005\u0012bAA\u0010\u0003\n\u00191+\u001a;\u0011\t\u0005\r\u0012qF\u0007\u0003\u0003KQA!a\n\u0002*\u000511m\\7n_:T1!HA\u0016\u0015\r\tic^\u0001\u0007CB\f7\r[3\n\t\u0005E\u0012Q\u0005\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t)$\u0005a\u0001\u0003o\tqAY;jY\u0012,'\u000fE\u0002*\u0003sI1!a\u000f\u0019\u0005eiU\r^1eCR\f\u0007+\u0019:uSRLwN\\:Ck&dG-\u001a:\u0002\u00191|7-\u00197DQ\u0006tw-\u001a3\u0015\t\u0005m\u0011\u0011\t\u0005\b\u0003k\u0011\u0002\u0019AA\u001c\u0003A1\u0017\u000e\u001c;feB\u000b'\u000f^5uS>t7\u000f\u0006\u0004\u0002\u001c\u0005\u001d\u0013\u0011\n\u0005\u00063M\u0001\r\u0001\f\u0005\u0007\u0003\u0017\u001a\u0002\u0019A\u001c\u0002\u000bQ|\u0007/[2\u0015\r\u0005m\u0011qJA)\u0011\u001d\t)\u0004\u0006a\u0001\u0003oAq!a\u0015\u0015\u0001\u0004\tY\"A\bu_BL7\rU1si&$\u0018n\u001c8t\u0003-\u0019'/Z1uKR{\u0007/[2\u0015\u0011\u0005e\u0013qLA1\u0003K\u0002B!a\t\u0002\\%!\u0011QLA\u0013\u0005\u0011)V/\u001b3\t\r\u0005-S\u00031\u00018\u0011\u0019\t\u0019'\u0006a\u0001\t\u0006ia.^7QCJ$\u0018\u000e^5p]NDq!!\u000e\u0016\u0001\u0004\t9$\u0001\u0006bg*\u000bg/\u0019'jgR$B!a\u001b\u0002\bB1\u0011QNA<\u0003wj!!a\u001c\u000b\t\u0005E\u00141O\u0001\u0005kRLGN\u0003\u0002\u0002v\u0005!!.\u0019<b\u0013\u0011\tI(a\u001c\u0003\t1K7\u000f\u001e\t\u0005\u0003{\n\u0019)\u0004\u0002\u0002\u0000)!\u0011\u0011QA:\u0003\u0011a\u0017M\\4\n\t\u0005\u0015\u0015q\u0010\u0002\b\u0013:$XmZ3s\u0011\u0019Ae\u00031\u0001\u0002\nB!Q*a#E\u0013\r\ti\t\u0016\u0002\t\u0013R,'/\u00192mK\"Z\u0001!!%\u0002\u0018\u0006e\u00151TAO!\r\u0001\u00181S\u0005\u0004\u0003+\u000b(a\u0002+j[\u0016|W\u000f^\u0001\u0006m\u0006dW/\u001a\u0010\u0004\u0003Q\u0007\u001d\u0001B;oSR$#!a(\n\t\u0005\u0005\u00161U\u0001\r\u001b&cE*S*F\u0007>sEi\u0015\u0006\u0005\u0003K\u000b9+\u0001\u0005US6,WK\\5u\u0015\u0011\tI+a\u001c\u0002\u0015\r|gnY;se\u0016tG\u000f")
public class MetadataPartitionsTest {
    private final MetadataPartitions emptyPartitions = MetadataPartitions$.MODULE$.apply(Collections.emptyMap(), Collections.emptyMap());

    private MetadataPartitions emptyPartitions() {
        return this.emptyPartitions;
    }

    private MetadataPartition newPartition(String topicName, int partitionIndex, Option<scala.collection.immutable.Seq<Object>> replicas, Option<scala.collection.immutable.Seq<Object>> isr, int numBrokers) {
        java.util.List list;
        java.util.List effectiveReplicas = this.asJavaList((Iterable<Object>)((Iterable)replicas.getOrElse((Function0 & Serializable)() -> {
            int preferredLeaderId = partitionIndex % numBrokers;
            return (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{preferredLeaderId, preferredLeaderId + 1, preferredLeaderId + 2}));
        })));
        if (None$.MODULE$.equals(isr)) {
            list = effectiveReplicas;
        } else if (isr instanceof Some) {
            scala.collection.immutable.Seq s = (scala.collection.immutable.Seq)((Some)isr).value();
            list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)s.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).toList()).asJava();
        } else {
            throw new MatchError(isr);
        }
        return new MetadataPartition(topicName, partitionIndex, Predef$.MODULE$.Integer2int((Integer)CollectionConverters$.MODULE$.ListHasAsScala(effectiveReplicas).asScala().head()), 100, effectiveReplicas, list, 200, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    private Option<scala.collection.immutable.Seq<Object>> newPartition$default$3() {
        return None$.MODULE$;
    }

    private Option<scala.collection.immutable.Seq<Object>> newPartition$default$4() {
        return None$.MODULE$;
    }

    private int newPartition$default$5() {
        return 6;
    }

    @Test
    public void testBuildPartitions() {
        MetadataPartitionsBuilder builder = new MetadataPartitionsBuilder(0, this.emptyPartitions());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)builder.get("foo", 0));
        builder.set(this.newPartition("foo", 0, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6));
        Assertions.assertEquals((Object)new Some((Object)this.newPartition("foo", 0, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6)), (Object)builder.get("foo", 0));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)builder.get("foo", 1));
        builder.set(this.newPartition("foo", 1, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6));
        builder.set(this.newPartition("bar", 0, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6));
        MetadataPartitions partitions = builder.build();
        Assertions.assertEquals((Object)new Some((Object)this.newPartition("foo", 0, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6)), (Object)partitions.topicPartition("foo", 0));
        Assertions.assertEquals((Object)new Some((Object)this.newPartition("foo", 1, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6)), (Object)partitions.topicPartition("foo", 1));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)partitions.topicPartition("foo", 2));
        Assertions.assertEquals((Object)new Some((Object)this.newPartition("bar", 0, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6)), (Object)partitions.topicPartition("bar", 0));
    }

    @Test
    public void testAllPartitionsIterator() {
        MetadataPartitionsBuilder builder = new MetadataPartitionsBuilder(0, this.emptyPartitions());
        HashSet expected = new HashSet();
        expected.$plus$eq((Object)this.newPartition("foo", 0, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6));
        expected.$plus$eq((Object)this.newPartition("foo", 1, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6));
        expected.$plus$eq((Object)this.newPartition("foo", 2, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6));
        expected.$plus$eq((Object)this.newPartition("bar", 0, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6));
        expected.$plus$eq((Object)this.newPartition("bar", 1, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6));
        expected.$plus$eq((Object)this.newPartition("baz", 0, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6));
        expected.foreach((Function1 & Serializable)partition -> {
            builder.set(partition);
            return BoxedUnit.UNIT;
        });
        MetadataPartitions partitions = builder.build();
        HashSet found = new HashSet();
        partitions.allPartitions().foreach((Function1 & Serializable)x$1 -> (HashSet)found.$plus$eq(x$1));
        Assertions.assertEquals((Object)expected, (Object)found);
    }

    @Test
    public void testLocalChangedAndRemoved() {
        None$ none$;
        None$ none$2;
        MetadataPartitionsBuilder builder = new MetadataPartitionsBuilder(0, this.emptyPartitions());
        builder.set(this.newPartition("foo", 0, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6));
        Assertions.assertTrue((boolean)this.newPartition("foo", 0, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6).isReplicaFor(0));
        Assertions.assertFalse((boolean)this.newPartition("foo", 0, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6).isReplicaFor(4));
        builder.set(this.newPartition("foo", 1, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6));
        builder.set(this.newPartition("foo", 2, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6));
        builder.set(this.newPartition("bar", 0, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6));
        HashSet expectedLocalChanged = new HashSet();
        expectedLocalChanged.$plus$eq((Object)this.newPartition("foo", 0, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6));
        expectedLocalChanged.$plus$eq((Object)this.newPartition("bar", 0, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6));
        Assertions.assertEquals((Object)expectedLocalChanged, (Object)builder.localChanged());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)builder.localRemoved());
        MetadataPartitions image = builder.build();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)3)), (Object)image.numTopicPartitions("foo"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)image.numTopicPartitions("quux"));
        MetadataPartitionsBuilder builder2 = new MetadataPartitionsBuilder(1, image);
        builder2.set(this.newPartition("foo", 0, (Option<scala.collection.immutable.Seq<Object>>)new Some((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))), (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6));
        Some x$3 = new Some((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})));
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$4 = none$3;
        int n = 6;
        builder2.set(this.newPartition("foo", 1, (Option<scala.collection.immutable.Seq<Object>>)x$4, (Option<scala.collection.immutable.Seq<Object>>)x$3, n));
        builder2.set(this.newPartition("bar", 2, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6));
        builder2.remove("bar", 0);
        builder2.remove("foo", 2);
        HashSet expectedLocalChanged2 = new HashSet();
        Some x$8 = new Some((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})));
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$9 = none$4;
        int n2 = 6;
        expectedLocalChanged2.$plus$eq((Object)this.newPartition("foo", 1, (Option<scala.collection.immutable.Seq<Object>>)x$9, (Option<scala.collection.immutable.Seq<Object>>)x$8, n2));
        Assertions.assertEquals((Object)expectedLocalChanged2, (Object)builder2.localChanged());
        HashSet expectedLocalRemoved2 = new HashSet();
        expectedLocalRemoved2.$plus$eq((Object)this.newPartition("bar", 0, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6));
        expectedLocalRemoved2.$plus$eq((Object)this.newPartition("foo", 0, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6));
        Assertions.assertEquals((Object)expectedLocalRemoved2, (Object)builder2.localRemoved());
    }

    @Test
    public void testAllTopicNames() {
        MetadataPartitionsBuilder builder = new MetadataPartitionsBuilder(0, this.emptyPartitions());
        this.createTopic("foo", 3, builder);
        this.createTopic("bar", 2, builder);
        this.createTopic("baz", 3, builder);
        MetadataPartitions image = builder.build();
        HashSet expectedTopicNames = new HashSet();
        expectedTopicNames.$plus$eq((Object)"foo");
        expectedTopicNames.$plus$eq((Object)"bar");
        expectedTopicNames.$plus$eq((Object)"baz");
        Assertions.assertEquals((Object)expectedTopicNames, (Object)image.allTopicNames());
    }

    @Test
    public void testUuidMappings() {
        MetadataPartitionsBuilder builder = new MetadataPartitionsBuilder(0, this.emptyPartitions());
        builder.addUuidMapping("foo", Uuid.fromString((String)"qbUrhSpXTau_836U7T5ktg"));
        builder.addUuidMapping("bar", Uuid.fromString((String)"a1I0JF3yRzWFyOuY3F_vHw"));
        builder.removeUuidMapping(Uuid.fromString((String)"gdMy05W7QWG4ZjWir1DjBw"));
        MetadataPartitions image = builder.build();
        Assertions.assertEquals((Object)new Some((Object)"foo"), (Object)image.topicIdToName(Uuid.fromString((String)"qbUrhSpXTau_836U7T5ktg")));
        Assertions.assertEquals((Object)new Some((Object)"bar"), (Object)image.topicIdToName(Uuid.fromString((String)"a1I0JF3yRzWFyOuY3F_vHw")));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)image.topicIdToName(Uuid.fromString((String)"gdMy05W7QWG4ZjWir1DjBw")));
    }

    @Test
    public void testMergePartitionChangeRecord() {
        MetadataPartition initialMetadata = this.newPartition("foo", 0, (Option<scala.collection.immutable.Seq<Object>>)new Some((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (Option<scala.collection.immutable.Seq<Object>>)new Some((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 6);
        Assertions.assertEquals((int)1, (int)initialMetadata.leaderId());
        MetadataPartition updatedIsr = initialMetadata.merge(new PartitionChangeRecord().setPartitionId(0).setIsr(this.asJavaList((Iterable<Object>)((Iterable)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))))));
        Assertions.assertEquals(this.asJavaList((Iterable<Object>)((Iterable)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})))), (Object)updatedIsr.isr());
        Assertions.assertEquals((int)initialMetadata.leaderEpoch(), (int)updatedIsr.leaderEpoch());
        Assertions.assertEquals((int)(initialMetadata.partitionEpoch() + 1), (int)updatedIsr.partitionEpoch());
        Assertions.assertEquals((int)initialMetadata.leaderId(), (int)updatedIsr.leaderId());
        MetadataPartition updatedLeader = initialMetadata.merge(new PartitionChangeRecord().setPartitionId(0).setLeader(2).setIsr(this.asJavaList((Iterable<Object>)((Iterable)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}))))));
        Assertions.assertEquals(this.asJavaList((Iterable<Object>)((Iterable)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})))), (Object)updatedLeader.isr());
        Assertions.assertEquals((int)(initialMetadata.leaderEpoch() + 1), (int)updatedLeader.leaderEpoch());
        Assertions.assertEquals((int)(initialMetadata.partitionEpoch() + 1), (int)updatedLeader.partitionEpoch());
        Assertions.assertEquals((int)2, (int)updatedLeader.leaderId());
    }

    @Test
    public void testTopicCreateAndDelete() {
        String topic = "foo";
        int numPartitions = 3;
        scala.collection.immutable.Set topicPartitions = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable)x$2 -> MetadataPartitionsTest.$anonfun$testTopicCreateAndDelete$1(topic, BoxesRunTime.unboxToInt((Object)x$2))).toSet();
        MetadataPartitionsBuilder builder = new MetadataPartitionsBuilder(0, this.emptyPartitions());
        Uuid topicId = this.createTopic(topic, numPartitions, builder);
        scala.collection.immutable.Set<TopicPartition> localTopicPartitions = this.localChanged(builder);
        Assertions.assertTrue((boolean)localTopicPartitions.subsetOf((Set)topicPartitions));
        Assertions.assertTrue((boolean)localTopicPartitions.nonEmpty());
        Assertions.assertNotEquals((Object)topicPartitions, localTopicPartitions);
        builder.removeTopicById(topicId);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)builder.topicIdToName(topicId));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)builder.topicNameToId(topic));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.filterPartitions(builder, (scala.collection.immutable.Set<TopicPartition>)topicPartitions));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.localRemoved(builder));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.localChanged(builder));
        MetadataPartitions metadata = builder.build();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)metadata.allTopicNames());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)metadata.topicIdToName(topicId));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)metadata.topicNameToId(topic));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)metadata.topicPartitions(topic).toSet());
    }

    @Test
    public void testTopicRemoval() {
        int brokerId = 0;
        String topic = "foo";
        int numPartitions = 3;
        scala.collection.immutable.Set topicPartitions = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable)x$3 -> MetadataPartitionsTest.$anonfun$testTopicRemoval$1(topic, BoxesRunTime.unboxToInt((Object)x$3))).toSet();
        MetadataPartitionsBuilder createBuilder = new MetadataPartitionsBuilder(brokerId, this.emptyPartitions());
        Uuid topicId = this.createTopic(topic, numPartitions, createBuilder);
        scala.collection.immutable.Set<TopicPartition> localTopicPartitions = this.localChanged(createBuilder);
        MetadataPartitions createMetadata = createBuilder.build();
        Assertions.assertTrue((boolean)localTopicPartitions.subsetOf((Set)topicPartitions));
        Assertions.assertTrue((boolean)localTopicPartitions.nonEmpty());
        Assertions.assertNotEquals((Object)topicPartitions, localTopicPartitions);
        MetadataPartitionsBuilder deleteBuilder = new MetadataPartitionsBuilder(0, createMetadata);
        deleteBuilder.removeTopicById(topicId);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)deleteBuilder.topicIdToName(topicId));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)deleteBuilder.topicNameToId(topic));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.filterPartitions(deleteBuilder, (scala.collection.immutable.Set<TopicPartition>)topicPartitions));
        Assertions.assertEquals(localTopicPartitions, this.localRemoved(deleteBuilder));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.localChanged(deleteBuilder));
        MetadataPartitions deleteMetadata = deleteBuilder.build();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)deleteMetadata.allTopicNames());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)deleteMetadata.topicIdToName(topicId));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)deleteMetadata.topicNameToId(topic));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)deleteMetadata.topicPartitions(topic).toSet());
    }

    @Test
    public void testTopicDeleteAndRecreate() {
        String topic = "foo";
        int numPartitions = 3;
        MetadataPartitionsBuilder initialBuilder = new MetadataPartitionsBuilder(0, this.emptyPartitions());
        Uuid initialTopicId = this.createTopic(topic, numPartitions, initialBuilder);
        scala.collection.immutable.Set initialLocalTopicPartitions = ((IterableOnceOps)initialBuilder.localChanged().map((Function1 & Serializable)x$4 -> x$4.toTopicPartition())).toSet();
        MetadataPartitions initialMetadata = initialBuilder.build();
        MetadataPartitionsBuilder recreateBuilder = new MetadataPartitionsBuilder(0, initialMetadata);
        recreateBuilder.removeTopicById(initialTopicId);
        Assertions.assertEquals((Object)initialLocalTopicPartitions, this.localRemoved(recreateBuilder));
        int recreatedNumPartitions = 10;
        Uuid recreatedTopicId = this.createTopic(topic, recreatedNumPartitions, recreateBuilder);
        scala.collection.immutable.Set recreatedTopicPartitions = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), recreatedNumPartitions).map((Function1 & Serializable)x$5 -> MetadataPartitionsTest.$anonfun$testTopicDeleteAndRecreate$2(topic, BoxesRunTime.unboxToInt((Object)x$5))).toSet();
        scala.collection.immutable.Set<TopicPartition> recreatedLocalTopicPartitions = this.localChanged(recreateBuilder);
        Assertions.assertTrue((boolean)recreatedLocalTopicPartitions.nonEmpty());
        Assertions.assertNotEquals(recreatedLocalTopicPartitions, (Object)recreatedTopicPartitions);
        Assertions.assertTrue((boolean)recreatedLocalTopicPartitions.subsetOf((Set)recreatedTopicPartitions));
        Assertions.assertFalse((boolean)recreatedLocalTopicPartitions.subsetOf((Set)initialLocalTopicPartitions));
        Assertions.assertEquals((Object)new Some((Object)topic), (Object)recreateBuilder.topicIdToName(recreatedTopicId));
        Assertions.assertEquals((Object)new Some((Object)recreatedTopicId), (Object)recreateBuilder.topicNameToId(topic));
        Assertions.assertEquals((Object)recreatedTopicPartitions, this.filterPartitions(recreateBuilder, (scala.collection.immutable.Set<TopicPartition>)recreatedTopicPartitions));
        Assertions.assertEquals((Object)initialLocalTopicPartitions, this.localRemoved(recreateBuilder));
        MetadataPartitions recreatedMetadata = recreateBuilder.build();
        Assertions.assertEquals((Object)recreatedTopicPartitions, this.filterPartitions(recreatedMetadata, topic));
        Assertions.assertEquals((Object)new Some((Object)recreatedTopicId), (Object)recreatedMetadata.topicNameToId(topic));
        Assertions.assertEquals((Object)new Some((Object)topic), (Object)recreatedMetadata.topicIdToName(recreatedTopicId));
    }

    private scala.collection.immutable.Set<TopicPartition> localRemoved(MetadataPartitionsBuilder builder) {
        return (scala.collection.immutable.Set)builder.localRemoved().toSet().map((Function1 & Serializable)x$6 -> x$6.toTopicPartition());
    }

    private scala.collection.immutable.Set<TopicPartition> localChanged(MetadataPartitionsBuilder builder) {
        return (scala.collection.immutable.Set)builder.localChanged().toSet().map((Function1 & Serializable)x$7 -> x$7.toTopicPartition());
    }

    private scala.collection.immutable.Set<TopicPartition> filterPartitions(MetadataPartitions metadata, String topic) {
        return metadata.topicPartitions(topic).map((Function1 & Serializable)x$8 -> x$8.toTopicPartition()).toSet();
    }

    private scala.collection.immutable.Set<TopicPartition> filterPartitions(MetadataPartitionsBuilder builder, scala.collection.immutable.Set<TopicPartition> topicPartitions) {
        return (scala.collection.immutable.Set)topicPartitions.filter((Function1 & Serializable)topicPartition -> BoxesRunTime.boxToBoolean((boolean)MetadataPartitionsTest.$anonfun$filterPartitions$2(builder, topicPartition)));
    }

    private Uuid createTopic(String topic, int numPartitions, MetadataPartitionsBuilder builder) {
        Uuid topicId = Uuid.randomUuid();
        builder.addUuidMapping(topic, topicId);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> builder.set(this.newPartition(topic, partition, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, (Option<scala.collection.immutable.Seq<Object>>)None$.MODULE$, 6)));
        return topicId;
    }

    private java.util.List<Integer> asJavaList(Iterable<Object> replicas) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)replicas.map((Function1 & Serializable)x -> MetadataPartitionsTest.$anonfun$asJavaList$1(BoxesRunTime.unboxToInt((Object)x)))).toList()).asJava();
    }

    public static final /* synthetic */ TopicPartition $anonfun$testTopicCreateAndDelete$1(String topic$1, int x$2) {
        return new TopicPartition(topic$1, x$2);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testTopicRemoval$1(String topic$2, int x$3) {
        return new TopicPartition(topic$2, x$3);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testTopicDeleteAndRecreate$2(String topic$3, int x$5) {
        return new TopicPartition(topic$3, x$5);
    }

    public static final /* synthetic */ boolean $anonfun$filterPartitions$2(MetadataPartitionsBuilder builder$2, TopicPartition topicPartition) {
        return builder$2.get(topicPartition.topic(), topicPartition.partition()).isDefined();
    }

    public static final /* synthetic */ Integer $anonfun$asJavaList$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }
}

