/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import kafka.api.LeaderAndIsr$;
import kafka.server.CreatePartitionsMetadata;
import kafka.server.DelayedOperation;
import kafka.server.ZkAdminManager;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u000594Aa\u0003\u0007\u0001#!Ia\u0003\u0001B\u0001B\u0003%q#\b\u0005\t=\u0001\u0011\t\u0011)A\u0005?!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015a\u0006\u0001\"\u0011\\\u0011\u0015i\u0006\u0001\"\u0003_\u0011\u0015I\u0007\u0001\"\u0003k\u0005]!U\r\\1zK\u0012\u001c%/Z1uKB\u000b'\u000f^5uS>t7O\u0003\u0002\u000e\u001d\u000511/\u001a:wKJT\u0011aD\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\tA\"\u0003\u0002\u0016\u0019\t\u0001B)\u001a7bs\u0016$w\n]3sCRLwN\\\u0001\bI\u0016d\u0017-_'t!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0011auN\\4\n\u0005Y!\u0012AD2sK\u0006$X-T3uC\u0012\fG/\u0019\t\u0004A\r*S\"A\u0011\u000b\u0005\tJ\u0012AC2pY2,7\r^5p]&\u0011A%\t\u0002\u0004'\u0016\f\bCA\n'\u0013\t9CB\u0001\rDe\u0016\fG/\u001a)beRLG/[8og6+G/\u00193bi\u0006\fA\"\u00193nS:l\u0015M\\1hKJ\u0004\"a\u0005\u0016\n\u0005-b!A\u0004.l\u0003\u0012l\u0017N\\'b]\u0006<WM]\u0001\u0011e\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u0004B\u0001\u0007\u00181\u0017&\u0011q&\u0007\u0002\n\rVt7\r^5p]F\u0002B\u0001I\u00194}%\u0011!'\t\u0002\u0004\u001b\u0006\u0004\bC\u0001\u001b<\u001d\t)\u0014\b\u0005\u0002735\tqG\u0003\u00029!\u00051AH]8pizJ!AO\r\u0002\rA\u0013X\rZ3g\u0013\taTH\u0001\u0004TiJLgn\u001a\u0006\u0003ue\u0001\"aP%\u000e\u0003\u0001S!!\u0011\"\u0002\u0011I,\u0017/^3tiNT!a\u0011#\u0002\r\r|W.\\8o\u0015\tyQI\u0003\u0002G\u000f\u00061\u0011\r]1dQ\u0016T\u0011\u0001S\u0001\u0004_J<\u0017B\u0001&A\u0005!\t\u0005/[#se>\u0014\bC\u0001\rM\u0013\ti\u0015D\u0001\u0003V]&$\u0018A\u0002\u001fj]&$h\bF\u0003Q#J\u001bF\u000b\u0005\u0002\u0014\u0001!)a#\u0002a\u0001/!)a$\u0002a\u0001?!)\u0001&\u0002a\u0001S!)A&\u0002a\u0001[\u0005YAO]=D_6\u0004H.\u001a;f)\u00059\u0006C\u0001\rY\u0013\tI\u0016DA\u0004C_>dW-\u00198\u0002\u0015=t7i\\7qY\u0016$X\rF\u0001L\u00031yg.\u0012=qSJ\fG/[8o\u0003Ii\u0017n]:j]\u001edU-\u00193fe\u000e{WO\u001c;\u0015\u0007}\u0013G\r\u0005\u0002\u0019A&\u0011\u0011-\u0007\u0002\u0004\u0013:$\b\"B2\n\u0001\u0004\u0019\u0014!\u0002;pa&\u001c\u0007\"B3\n\u0001\u00041\u0017A\u00039beRLG/[8ogB\u0019\u0001eZ0\n\u0005!\f#aA*fi\u0006y\u0011n]'jgNLgn\u001a'fC\u0012,'\u000fF\u0002XW2DQa\u0019\u0006A\u0002MBQ!\u001c\u0006A\u0002}\u000b\u0011\u0002]1si&$\u0018n\u001c8")
public class DelayedCreatePartitions
extends DelayedOperation {
    private final Seq<CreatePartitionsMetadata> createMetadata;
    private final ZkAdminManager adminManager;
    private final Function1<Map<String, ApiError>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Trying to complete operation for ").append($this.createMetadata).toString());
        int leaderlessPartitionCount = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.createMetadata.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedCreatePartitions.$anonfun$tryComplete$2(x$1)))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)DelayedCreatePartitions.$anonfun$tryComplete$3(this, BoxesRunTime.unboxToInt((Object)x0$1), x1$1))));
        if (leaderlessPartitionCount == 0) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> "All partitions have a leader, completing the delayed operation");
            return this.forceComplete();
        }
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append(leaderlessPartitionCount).append(" partitions do not have a leader, not completing the delayed operation").toString());
        return false;
    }

    @Override
    public void onComplete() {
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(25).append("Completing operation for ").append($this.createMetadata).toString());
        scala.collection.immutable.Map results = ((IterableOnceOps)this.createMetadata.map((Function1 & Serializable)metadata -> {
            if (metadata.error().isSuccess() && this.missingLeaderCount(metadata.topic(), metadata.partitions()) > 0) {
                return new Tuple2((Object)metadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null));
            }
            return new Tuple2((Object)metadata.topic(), (Object)metadata.error());
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.responseCallback.apply((Object)results);
    }

    @Override
    public void onExpiration() {
    }

    private int missingLeaderCount(String topic, Set<Object> partitions) {
        return BoxesRunTime.unboxToInt((Object)partitions.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(x0$1, x1$1) -> {
            if (this.isMissingLeader(topic, x1$1)) {
                return x0$1 + 1;
            }
            return x0$1;
        }));
    }

    private boolean isMissingLeader(String topic, int partition) {
        return this.adminManager.metadataCache().getPartitionInfo(topic, partition).forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DelayedCreatePartitions.$anonfun$isMissingLeader$1(x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$tryComplete$2(CreatePartitionsMetadata x$1) {
        return x$1.error().isSuccess();
    }

    public static final /* synthetic */ int $anonfun$tryComplete$3(DelayedCreatePartitions $this, int x0$1, CreatePartitionsMetadata x1$1) {
        return x0$1 + $this.missingLeaderCount(x1$1.topic(), x1$1.partitions());
    }

    public static final /* synthetic */ boolean $anonfun$isMissingLeader$1(UpdateMetadataRequestData.UpdateMetadataPartitionState x$2) {
        return x$2.leader() == LeaderAndIsr$.MODULE$.NoLeader();
    }

    public DelayedCreatePartitions(long delayMs, Seq<CreatePartitionsMetadata> createMetadata, ZkAdminManager adminManager, Function1<Map<String, ApiError>, BoxedUnit> responseCallback) {
        this.createMetadata = createMetadata;
        this.adminManager = adminManager;
        this.responseCallback = responseCallback;
        super(delayMs, (Option<Lock>)None$.MODULE$);
    }
}

