/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.checkpoints;

import com.typesafe.scalalogging.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import kafka.server.checkpoints.CheckpointFileFormatter;
import kafka.utils.Logging;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005U3Aa\u0002\u0005\u0001\u001f!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0011!\u0011\u0004A!A!\u0002\u0013\u0019\u0004\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u000b\u0019\u0003A\u0011A$\t\u000b5\u0003A\u0011\u0001(\u0003)\rCWmY6q_&tGOU3bI\n+hMZ3s\u0015\tI!\"A\u0006dQ\u0016\u001c7\u000e]8j]R\u001c(BA\u0006\r\u0003\u0019\u0019XM\u001d<fe*\tQ\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0016\u0005Ai4c\u0001\u0001\u0012/A\u0011!#F\u0007\u0002')\tA#A\u0003tG\u0006d\u0017-\u0003\u0002\u0017'\t1\u0011I\\=SK\u001a\u0004\"\u0001G\u000e\u000e\u0003eQ!A\u0007\u0007\u0002\u000bU$\u0018\u000e\\:\n\u0005qI\"a\u0002'pO\u001eLgnZ\u0001\tY>\u001c\u0017\r^5p]B\u0011qD\n\b\u0003A\u0011\u0002\"!I\n\u000e\u0003\tR!a\t\b\u0002\rq\u0012xn\u001c;?\u0013\t)3#\u0001\u0004Qe\u0016$WMZ\u0005\u0003O!\u0012aa\u0015;sS:<'BA\u0013\u0014\u0003\u0019\u0011X-\u00193feB\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\u0003S>T\u0011aL\u0001\u0005U\u00064\u0018-\u0003\u00022Y\tq!)\u001e4gKJ,GMU3bI\u0016\u0014\u0018a\u0002<feNLwN\u001c\t\u0003%QJ!!N\n\u0003\u0007%sG/A\u0005g_Jl\u0017\r\u001e;feB\u0019\u0001(O\u001e\u000e\u0003!I!A\u000f\u0005\u0003/\rCWmY6q_&tGOR5mK\u001a{'/\\1ui\u0016\u0014\bC\u0001\u001f>\u0019\u0001!QA\u0010\u0001C\u0002}\u0012\u0011\u0001V\t\u0003\u0001\u000e\u0003\"AE!\n\u0005\t\u001b\"a\u0002(pi\"Lgn\u001a\t\u0003%\u0011K!!R\n\u0003\u0007\u0005s\u00170\u0001\u0004=S:LGO\u0010\u000b\u0006\u0011&S5\n\u0014\t\u0004q\u0001Y\u0004\"B\u000f\u0006\u0001\u0004q\u0002\"B\u0015\u0006\u0001\u0004Q\u0003\"\u0002\u001a\u0006\u0001\u0004\u0019\u0004\"\u0002\u001c\u0006\u0001\u00049\u0014\u0001\u0002:fC\u0012$\u0012a\u0014\t\u0004!N[T\"A)\u000b\u0005I\u001b\u0012AC2pY2,7\r^5p]&\u0011A+\u0015\u0002\u0004'\u0016\f\b")
public class CheckpointReadBuffer<T>
implements Logging {
    private final String location;
    private final BufferedReader reader;
    private final int version;
    private final CheckpointFileFormatter<T> formatter;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<T> read() {
        Buffer buffer;
        String line = null;
        try {
            Buffer entries;
            line = this.reader.readLine();
            if (line == null) {
                return (Seq)Seq$.MODULE$.empty();
            }
            int n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(line));
            switch (n) {
                default: 
            }
            if (n == this.version) {
                line = this.reader.readLine();
                if (line == null) {
                    return (Seq)Seq$.MODULE$.empty();
                }
                int expectedSize = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(line));
                entries = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
                line = this.reader.readLine();
                while (line != null) {
                    Option<T> entry = this.formatter.fromLine(line);
                    if (entry instanceof Some) {
                        Object e = ((Some)entry).value();
                        entries.$plus$eq(e);
                        line = this.reader.readLine();
                        continue;
                    }
                    throw this.malformedLineException$1(line);
                }
                if (entries.size() != expectedSize) {
                    throw new IOException(new StringBuilder(56).append("Expected ").append(expectedSize).append(" entries in checkpoint file (").append(this.location).append("), but found only ").append(entries.size()).toString());
                }
            } else {
                throw new IOException(new StringBuilder(0).append(new StringBuilder(48).append("Unrecognized version of the checkpoint file (").append(this.location).append("): ").toString()).append(this.version).toString());
            }
            buffer = entries;
        }
        catch (NumberFormatException numberFormatException) {
            throw this.malformedLineException$1(line);
        }
        return buffer;
    }

    private final IOException malformedLineException$1(String line) {
        return new IOException(new StringBuilder(40).append("Malformed line in checkpoint file (").append(this.location).append("): '").append(line).append("'").toString());
    }

    public CheckpointReadBuffer(String location, BufferedReader reader, int version, CheckpointFileFormatter<T> formatter) {
        this.location = location;
        this.reader = reader;
        this.version = version;
        this.formatter = formatter;
    }
}

