/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnIdAndMarkerEntry;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005Q3Aa\u0002\u0005\u0001\u001f!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0011!)\u0004A!A!\u0002\u00131\u0004\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u000b\r\u0003A\u0011\u0001#\t\u000b)\u0003A\u0011I&\u0003SQ\u0013\u0018M\\:bGRLwN\\'be.,'OU3rk\u0016\u001cHoQ8na2,G/[8o\u0011\u0006tG\r\\3s\u0015\tI!\"A\u0006ue\u0006t7/Y2uS>t'BA\u0006\r\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u00035\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001!a\u0019\u0003CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005e\tS\"\u0001\u000e\u000b\u0005ma\u0012aB2mS\u0016tGo\u001d\u0006\u0003\u001buQ!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sO&\u0011!E\u0007\u0002\u0019%\u0016\fX/Z:u\u0007>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014\bC\u0001\u0013(\u001b\u0005)#B\u0001\u0014\r\u0003\u0015)H/\u001b7t\u0013\tASEA\u0004M_\u001e<\u0017N\\4\u0002\u0011\t\u0014xn[3s\u0013\u0012\u0004\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u00121!\u00138u\u0003=!\bP\\*uCR,W*\u00198bO\u0016\u0014\bC\u0001\u001a4\u001b\u0005A\u0011B\u0001\u001b\t\u0005]!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-T1oC\u001e,'/A\fuq:l\u0015M]6fe\u000eC\u0017M\u001c8fY6\u000bg.Y4feB\u0011!gN\u0005\u0003q!\u0011q\u0004\u0016:b]N\f7\r^5p]6\u000b'o[3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0003U!\bP\\%e\u0003:$W*\u0019:lKJ,e\u000e\u001e:jKN\u00042a\u000f A\u001b\u0005a$BA\u001f\u0015\u0003\u0011)H/\u001b7\n\u0005}b$\u0001\u0002'jgR\u0004\"AM!\n\u0005\tC!a\u0005+y]&#\u0017I\u001c3NCJ\\WM]#oiJL\u0018A\u0002\u001fj]&$h\bF\u0003F\r\u001eC\u0015\n\u0005\u00023\u0001!)\u0011&\u0002a\u0001U!)\u0001'\u0002a\u0001c!)Q'\u0002a\u0001m!)\u0011(\u0002a\u0001u\u0005QqN\\\"p[BdW\r^3\u0015\u00051{\u0005CA\u0016N\u0013\tqEF\u0001\u0003V]&$\b\"\u0002)\u0007\u0001\u0004\t\u0016\u0001\u0003:fgB|gn]3\u0011\u0005e\u0011\u0016BA*\u001b\u00059\u0019E.[3oiJ+7\u000f]8og\u0016\u0004")
public class TransactionMarkerRequestCompletionHandler
implements RequestCompletionHandler,
Logging {
    private final TransactionStateManager txnStateManager;
    private final TransactionMarkerChannelManager txnMarkerChannelManager;
    private final List<TxnIdAndMarkerEntry> txnIdAndMarkerEntries;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void onComplete(ClientResponse response) {
        RequestHeader requestHeader = response.requestHeader();
        int correlationId = requestHeader.correlationId();
        if (response.wasDisconnected()) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Cancelled request with header ").append(requestHeader).append(" due to node ").append(response.destination()).append(" being disconnected").toString());
            CollectionConverters$.MODULE$.ListHasAsScala(this.txnIdAndMarkerEntries).asScala().foreach((Function1 & Serializable)txnIdAndMarker -> {
                TransactionMarkerRequestCompletionHandler.$anonfun$onComplete$2(this, txnIdAndMarker);
                return BoxedUnit.UNIT;
            });
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Received WriteTxnMarker response ").append(response).append(" from node ").append(response.destination()).append(" with correlation id ").append(correlationId).toString());
        Map responseErrors = ((WriteTxnMarkersResponse)response.responseBody()).errorsByProducerId();
        CollectionConverters$.MODULE$.ListHasAsScala(this.txnIdAndMarkerEntries).asScala().foreach((Function1 & Serializable)txnIdAndMarker -> {
            TransactionMarkerRequestCompletionHandler.$anonfun$onComplete$8(this, responseErrors, txnIdAndMarker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$onComplete$2(TransactionMarkerRequestCompletionHandler $this, TxnIdAndMarkerEntry txnIdAndMarker) {
        Option option;
        Errors errors;
        String transactionalId = txnIdAndMarker.txnId();
        WriteTxnMarkersRequest.TxnMarkerEntry txnMarker = txnIdAndMarker.txnMarkerEntry();
        boolean bl = false;
        Left left = null;
        boolean bl2 = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnStateManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Errors errors2 = (Errors)left.value();
            if (Errors.NOT_COORDINATOR.equals(errors2)) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("I am no longer the coordinator for ").append(transactionalId).append("; cancel sending transaction markers ").append(txnMarker).append(" to the brokers").toString());
                $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId);
                return;
            }
        }
        if (bl && Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(errors = (Errors)left.value())) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(108).append("I am loading the transaction partition that contains ").append(transactionalId).append(" which means the current markers have to be obsoleted; ").toString()).append(new StringBuilder(50).append("cancel sending transaction markers ").append(txnMarker).append(" to the brokers").toString()).toString());
            $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId);
            return;
        }
        if (bl) {
            Errors unexpectedError = (Errors)left.value();
            $this.txnStateManager.stateErrorSensor().record();
            throw new IllegalStateException(new StringBuilder(56).append("Unhandled error ").append(unexpectedError).append(" when fetching current transaction state").toString());
        }
        if (either instanceof Right) {
            bl2 = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                $this.txnStateManager.stateErrorSensor().record();
                throw new IllegalStateException(new StringBuilder(0).append(new StringBuilder(72).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").toString()).append("no metadata in the cache; this is not expected").toString());
            }
        }
        if (bl2 && (option = (Option)right.value()) instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
            if (epochAndMetadata.coordinatorEpoch() != txnMarker.coordinatorEpoch()) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(56).append("Transaction coordinator epoch for ").append(transactionalId).append(" has changed from ").append(txnMarker.coordinatorEpoch()).append(" to ").toString()).append(new StringBuilder(52).append(epochAndMetadata.coordinatorEpoch()).append("; cancel sending transaction markers ").append(txnMarker).append(" to the brokers").toString()).toString());
                $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId);
                return;
            }
            $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(56).append("Re-enqueuing ").append(txnMarker.transactionResult()).append(" transaction markers for transactional id ").append(transactionalId).append(" ").toString()).append(new StringBuilder(24).append("under coordinator epoch ").append(txnMarker.coordinatorEpoch()).toString()).toString());
            $this.txnMarkerChannelManager.addTxnMarkersToBrokerQueue(transactionalId, txnMarker.producerId(), txnMarker.producerEpoch(), txnMarker.transactionResult(), txnMarker.coordinatorEpoch(), (scala.collection.immutable.Set<TopicPartition>)CollectionConverters$.MODULE$.ListHasAsScala(txnMarker.partitions()).asScala().toSet());
            return;
        }
        throw new MatchError(either);
    }

    public static final /* synthetic */ void $anonfun$onComplete$8(TransactionMarkerRequestCompletionHandler $this, Map responseErrors$1, TxnIdAndMarkerEntry txnIdAndMarker) {
        Option option;
        Errors errors;
        String transactionalId = txnIdAndMarker.txnId();
        WriteTxnMarkersRequest.TxnMarkerEntry txnMarker = txnIdAndMarker.txnMarkerEntry();
        Map errors2 = (Map)responseErrors$1.get(BoxesRunTime.boxToLong((long)txnMarker.producerId()));
        if (errors2 == null) {
            $this.txnStateManager.stateErrorSensor().record();
            throw new IllegalStateException(new StringBuilder(75).append("WriteTxnMarkerResponse does not contain expected error map for producer id ").append(txnMarker.producerId()).toString());
        }
        boolean bl = false;
        Left left = null;
        boolean bl2 = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnStateManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Errors errors3 = (Errors)left.value();
            if (Errors.NOT_COORDINATOR.equals(errors3)) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("I am no longer the coordinator for ").append(transactionalId).append("; cancel sending transaction markers ").append(txnMarker).append(" to the brokers").toString());
                $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId);
                return;
            }
        }
        if (bl && Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(errors = (Errors)left.value())) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(108).append("I am loading the transaction partition that contains ").append(transactionalId).append(" which means the current markers have to be obsoleted; ").toString()).append(new StringBuilder(50).append("cancel sending transaction markers ").append(txnMarker).append(" to the brokers").toString()).toString());
            $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId);
            return;
        }
        if (bl) {
            Errors unexpectedError = (Errors)left.value();
            $this.txnStateManager.stateErrorSensor().record();
            throw new IllegalStateException(new StringBuilder(56).append("Unhandled error ").append(unexpectedError).append(" when fetching current transaction state").toString());
        }
        if (either instanceof Right) {
            bl2 = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                $this.txnStateManager.stateErrorSensor().record();
                throw new IllegalStateException(new StringBuilder(0).append(new StringBuilder(72).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").toString()).append("no metadata in the cache; this is not expected").toString());
            }
        }
        if (bl2 && (option = (Option)right.value()) instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
            TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
            Set retryPartitions = (Set)Set$.MODULE$.empty();
            BooleanRef abortSending = BooleanRef.create((boolean)false);
            if (epochAndMetadata.coordinatorEpoch() != txnMarker.coordinatorEpoch()) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(56).append("Transaction coordinator epoch for ").append(transactionalId).append(" has changed from ").append(txnMarker.coordinatorEpoch()).append(" to ").toString()).append(new StringBuilder(52).append(epochAndMetadata.coordinatorEpoch()).append("; cancel sending transaction markers ").append(txnMarker).append(" to the brokers").toString()).toString());
                $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId);
                abortSending.elem = true;
            } else {
                txnMetadata.inLock((JFunction0.mcV.sp & Serializable)() -> CollectionConverters$.MODULE$.MapHasAsScala(errors2).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$1 -> {
                    if (x$1 == null) throw new MatchError(null);
                    TopicPartition topicPartition = (TopicPartition)x$1._1();
                    Errors error = (Errors)x$1._2();
                    if (Errors.NONE.equals(error)) {
                        txnMetadata.removePartition(topicPartition);
                        return BoxedUnit.UNIT;
                    }
                    boolean bl = Errors.CORRUPT_MESSAGE.equals(error) ? true : (Errors.MESSAGE_TOO_LARGE.equals(error) ? true : (Errors.RECORD_LIST_TOO_LARGE.equals(error) ? true : Errors.INVALID_REQUIRED_ACKS.equals(error)));
                    if (bl) {
                        $this.txnStateManager.stateErrorSensor().record();
                        throw new IllegalStateException(new StringBuilder(51).append("Received fatal error ").append(error.exceptionName()).append(" while sending txn marker for ").append(transactionalId).toString());
                    }
                    boolean bl2 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(error) ? true : (Errors.NOT_LEADER_OR_FOLLOWER.equals(error) ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(error) ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(error) ? true : (Errors.REQUEST_TIMED_OUT.equals(error) ? true : Errors.KAFKA_STORAGE_ERROR.equals(error)))));
                    if (bl2) {
                        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(78).append("Sending ").append(transactionalId).append("'s transaction marker for partition ").append(topicPartition).append(" has failed with error ").append(error.exceptionName()).append(", retrying ").toString()).append(new StringBuilder(31).append("with current coordinator epoch ").append(epochAndMetadata.coordinatorEpoch()).toString()).toString());
                        return retryPartitions.$plus$eq((Object)topicPartition);
                    }
                    boolean bl3 = Errors.INVALID_PRODUCER_EPOCH.equals(error) ? true : Errors.TRANSACTION_COORDINATOR_FENCED.equals(error);
                    if (bl3) {
                        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(80).append("Sending ").append(transactionalId).append("'s transaction marker for partition ").append(topicPartition).append(" has permanently failed with error ").append(error.exceptionName()).append(" ").toString()).append(new StringBuilder(96).append("with the current coordinator epoch ").append(epochAndMetadata.coordinatorEpoch()).append("; cancel sending any more transaction markers ").append(txnMarker).append(" to the brokers").toString()).toString());
                        $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId);
                        abortSending$1.elem = true;
                        return BoxedUnit.UNIT;
                    }
                    boolean bl4 = Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT.equals(error) ? true : Errors.UNSUPPORTED_VERSION.equals(error);
                    if (bl4) {
                        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(62).append("Sending ").append(transactionalId).append("'s transaction marker from partition ").append(topicPartition).append(" has failed with ").toString()).append(new StringBuilder(60).append(" ").append(error.name()).append(". This partition will be removed from the set of partitions").toString()).append(" waiting for completion").toString());
                        txnMetadata.removePartition(topicPartition);
                        return BoxedUnit.UNIT;
                    }
                    $this.txnStateManager.stateErrorSensor().record();
                    throw new IllegalStateException(new StringBuilder(47).append("Unexpected error ").append(error.exceptionName()).append(" while sending txn marker for ").append(transactionalId).toString());
                }));
            }
            if (!abortSending.elem) {
                if (retryPartitions.nonEmpty()) {
                    $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(56).append("Re-enqueuing ").append(txnMarker.transactionResult()).append(" transaction markers for transactional id ").append(transactionalId).append(" ").toString()).append(new StringBuilder(24).append("under coordinator epoch ").append(txnMarker.coordinatorEpoch()).toString()).toString());
                    $this.txnMarkerChannelManager.addTxnMarkersToBrokerQueue(transactionalId, txnMarker.producerId(), txnMarker.producerEpoch(), txnMarker.transactionResult(), txnMarker.coordinatorEpoch(), (scala.collection.immutable.Set<TopicPartition>)retryPartitions.toSet());
                    return;
                }
                $this.txnMarkerChannelManager.maybeWriteTxnCompletion(transactionalId);
                return;
            }
        } else {
            throw new MatchError(either);
        }
    }

    public TransactionMarkerRequestCompletionHandler(int brokerId, TransactionStateManager txnStateManager, TransactionMarkerChannelManager txnMarkerChannelManager, List<TxnIdAndMarkerEntry> txnIdAndMarkerEntries) {
        this.txnStateManager = txnStateManager;
        this.txnMarkerChannelManager = txnMarkerChannelManager;
        this.txnIdAndMarkerEntries = txnIdAndMarkerEntries;
        this.logIdent_$eq(new StringBuilder(50).append("[Transaction Marker Request Completion Handler ").append(brokerId).append("]: ").toString());
    }
}

