/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionState$;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndMetadata;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndTransitMetadata;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin$Coordinator$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.message.UncompressedCodec$;
import kafka.server.AbstractFetchDataInfo;
import kafka.server.FetchDataInfo;
import kafka.server.FetchLogEnd$;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Scheduler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\r=w!B*U\u0011\u0003Yf!B/U\u0011\u0003q\u0006\"B3\u0002\t\u00031\u0007bB4\u0002\u0005\u0004%\t\u0001\u001b\u0005\u0007Y\u0006\u0001\u000b\u0011B5\t\u000f5\f!\u0019!C\u0001Q\"1a.\u0001Q\u0001\n%Dqa\\\u0001C\u0002\u0013\u0005\u0001\u000e\u0003\u0004q\u0003\u0001\u0006I!\u001b\u0005\bc\u0006\u0011\r\u0011\"\u0001i\u0011\u0019\u0011\u0018\u0001)A\u0005S\"91/\u0001b\u0001\n\u0003!\bbBA\u0001\u0003\u0001\u0006I!\u001e\u0005\t\u0003\u0007\t!\u0019!C\u0001i\"9\u0011QA\u0001!\u0002\u0013)\b\u0002CA\u0004\u0003\t\u0007I\u0011\u0001;\t\u000f\u0005%\u0011\u0001)A\u0005k\"A\u00111B\u0001C\u0002\u0013\u0005A\u000fC\u0004\u0002\u000e\u0005\u0001\u000b\u0011B;\u0007\u000bu#\u0006!a\u0004\t\u0013\u0005u1C!A!\u0002\u0013I\u0007BCA\u0010'\t\u0005\t\u0015!\u0003\u0002\"!Q\u0011qE\n\u0003\u0002\u0003\u0006I!!\u000b\t\u0015\u0005U2C!A!\u0002\u0013\t9\u0004\u0003\u0006\u0002>M\u0011\t\u0011)A\u0005\u0003\u007fA!\"a\u0016\u0014\u0005\u0003\u0005\u000b\u0011BA-\u0011\u0019)7\u0003\"\u0001\u0002d\u00151\u00111O\n\u0001\u0003kB\u0011\"!'\u0014\u0005\u0004%I!a'\t\u0011\u0005U6\u0003)A\u0005\u0003;C\u0011\"a.\u0014\u0005\u0004%I!!/\t\u0011\u0005\u001d7\u0003)A\u0005\u0003wC!\"!3\u0014\u0005\u0004%\t\u0001VAf\u0011!\t\u0019o\u0005Q\u0001\n\u00055\u0007BCAs'\t\u0007I\u0011\u0001+\u0002h\"A\u0011Q_\n!\u0002\u0013\tI\u000fC\u0006\u0002xN\u0001\r\u00111A\u0005\n\u0005e\bb\u0003B\u0001'\u0001\u0007\t\u0019!C\u0005\u0005\u0007A1B!\u0003\u0014\u0001\u0004\u0005\t\u0015)\u0003\u0002|\"Q!1B\nA\u0002\u0003\u0007I\u0011\u00025\t\u0017\t51\u00031AA\u0002\u0013%!q\u0002\u0005\u000b\u0005'\u0019\u0002\u0019!A!B\u0013I\u0007\"\u0003B\u000f'\t\u0007I\u0011\u0002B\u0010\u0011!\u00119c\u0005Q\u0001\n\t\u0005\u0002\"\u0003B\u0015'\t\u0007I\u0011\u0002B\u0016\u0011!\u0011)d\u0005Q\u0001\n\t5\u0002B\u0003B\u001c'\t\u0007I\u0011\u0001+\u0003 !A!\u0011H\n!\u0002\u0013\u0011\t\u0003C\u0005\u0003<M\u0011\r\u0011\"\u0003\u0003,!A!QH\n!\u0002\u0013\u0011i\u0003C\u0005\u0003@M\u0011\r\u0011\"\u0003\u0003,!A!\u0011I\n!\u0002\u0013\u0011i\u0003\u0003\u0006\u0003DM\u0011\r\u0011\"\u0001U\u0005?A\u0001B!\u0012\u0014A\u0003%!\u0011\u0005\u0005\n\u0005\u000f\u001a\"\u0019!C\u0005\u0005WA\u0001B!\u0013\u0014A\u0003%!Q\u0006\u0005\n\u0005\u0017\u001a\"\u0019!C\u0005\u0005WA\u0001B!\u0014\u0014A\u0003%!Q\u0006\u0005\t\u0005\u001f\u001aB\u0011\u0001+\u0003R!9!1L\n\u0005\u0002\tu\u0003b\u0002B<'\u0011%!\u0011\u0010\u0005\b\u0005\u0013\u001bB\u0011\u0002BF\u0011\u001d\u0011\tk\u0005C\u0005\u0005GC\u0001Ba\u001e\u0014\t\u0003!&\u0011\u0018\u0005\b\u0005w\u001bB\u0011\u0002B_\u0011\u001d\u00119n\u0005C\u0001\u0005sCqA!7\u0014\t\u0003\u0011Y\u000eC\u0004\u0003\u0000N!\ta!\u0001\t\u000f\r\u001d1\u0003\"\u0001\u0004\n!91QE\n\u0005\n\r\u001d\u0002bBB\u0019'\u0011\u000511\u0007\u0005\b\u0007s\u0019B\u0011AB\u001e\u0011\u001d\u0019)e\u0005C\u0001\u0007\u000fBqaa\u0013\u0014\t\u0013\u0019i\u0005\u0003\u0005\u0004\\M!\t\u0001VB/\u0011\u001d\u0019Ig\u0005C\u0001\u0007WBqa!\u001f\u0014\t\u0003\u0019Y\bC\u0004\u0004zM!\taa \t\u000f\r\u00155\u0003\"\u0003\u0003:\"91qQ\n\u0005\u0002\r%\u0005\"CBW'E\u0005I\u0011ABX\u0011\u001d\u0019)m\u0005C\u0001\u0007\u000fDqa!4\u0014\t\u0003\u0011I,A\fUe\u0006t7/Y2uS>t7\u000b^1uK6\u000bg.Y4fe*\u0011QKV\u0001\fiJ\fgn]1di&|gN\u0003\u0002X1\u0006Y1m\\8sI&t\u0017\r^8s\u0015\u0005I\u0016!B6bM.\f7\u0001\u0001\t\u00039\u0006i\u0011\u0001\u0016\u0002\u0018)J\fgn]1di&|gn\u0015;bi\u0016l\u0015M\\1hKJ\u001c\"!A0\u0011\u0005\u0001\u001cW\"A1\u000b\u0003\t\fQa]2bY\u0006L!\u0001Z1\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1,A\u0010EK\u001a\fW\u000f\u001c;Ue\u0006t7/Y2uS>t7/T1y)&lWm\\;u\u001bN,\u0012!\u001b\t\u0003A*L!a[1\u0003\u0007%sG/\u0001\u0011EK\u001a\fW\u000f\u001c;Ue\u0006t7/Y2uS>t7/T1y)&lWm\\;u\u001bN\u0004\u0013A\t#fM\u0006,H\u000e\u001e+sC:\u001c\u0018m\u0019;j_:\fG.\u00133FqBL'/\u0019;j_:l5/A\u0012EK\u001a\fW\u000f\u001c;Ue\u0006t7/Y2uS>t\u0017\r\\%e\u000bb\u0004\u0018N]1uS>tWj\u001d\u0011\u0002U\u0011+g-Y;mi\u0006\u0013wN\u001d;US6,GmT;u)J\fgn]1di&|gn]%oi\u0016\u0014h/\u00197Ng\u0006YC)\u001a4bk2$\u0018IY8siRKW.\u001a3PkR$&/\u00198tC\u000e$\u0018n\u001c8t\u0013:$XM\u001d<bY6\u001b\b%\u0001\u0018EK\u001a\fW\u000f\u001c;SK6|g/Z#ya&\u0014X\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133t\u0013:$XM\u001d<bY6\u001b\u0018a\f#fM\u0006,H\u000e\u001e*f[>4X-\u0012=qSJ,G\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:J]R,'O^1m\u001bN\u0004\u0013\u0001D'fiJL7m]$s_V\u0004X#A;\u0011\u0005YlhBA<|!\tA\u0018-D\u0001z\u0015\tQ(,\u0001\u0004=e>|GOP\u0005\u0003y\u0006\fa\u0001\u0015:fI\u00164\u0017B\u0001@\u0000\u0005\u0019\u0019FO]5oO*\u0011A0Y\u0001\u000e\u001b\u0016$(/[2t\u000fJ|W\u000f\u001d\u0011\u0002\u001d1{\u0017\r\u001a+j[\u0016\u001cVM\\:pe\u0006yAj\\1e)&lWmU3og>\u0014\b%A\u0007US6,w.\u001e;TK:\u001cxN]\u0001\u000f)&lWm\\;u'\u0016t7o\u001c:!\u0003A\u0019F/\u0019;f\u000bJ\u0014xN]*f]N|'/A\tTi\u0006$X-\u0012:s_J\u001cVM\\:pe\u0002\u001aBaE0\u0002\u0012A!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018a\u000bQ!\u001e;jYNLA!a\u0007\u0002\u0016\t9Aj\\4hS:<\u0017\u0001\u00032s_.,'/\u00133\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\b\u0003BA\n\u0003GIA!!\n\u0002\u0016\tI1k\u00195fIVdWM]\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u00181\u000611/\u001a:wKJLA!a\r\u0002.\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018AB2p]\u001aLw\rE\u0002]\u0003sI1!a\u000fU\u0005E!&/\u00198tC\u000e$\u0018n\u001c8D_:4\u0017nZ\u0001\u0005i&lW\r\u0005\u0003\u0002B\u0005MSBAA\"\u0015\u0011\t9\"!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\u0007G>lWn\u001c8\u000b\u0007e\u000bYE\u0003\u0003\u0002N\u0005=\u0013AB1qC\u000eDWM\u0003\u0002\u0002R\u0005\u0019qN]4\n\t\u0005U\u00131\t\u0002\u0005)&lW-A\u0004nKR\u0014\u0018nY:\u0011\t\u0005m\u0013qL\u0007\u0003\u0003;RA!a\u0016\u0002F%!\u0011\u0011MA/\u0005\u001diU\r\u001e:jGN$b\"!\u001a\u0002h\u0005%\u00141NA7\u0003_\n\t\b\u0005\u0002]'!1\u0011Q\u0004\u000eA\u0002%Dq!a\b\u001b\u0001\u0004\t\t\u0003C\u0004\u0002(i\u0001\r!!\u000b\t\u000f\u0005U\"\u00041\u0001\u00028!9\u0011Q\b\u000eA\u0002\u0005}\u0002bBA,5\u0001\u0007\u0011\u0011\f\u0002\u0017'\u0016tG\r\u0016=o\u001b\u0006\u00148.\u001a:t\u0007\u0006dGNY1dWBa\u0001-a\u001ej\u0003w\n9)!$\u0002\u0014&\u0019\u0011\u0011P1\u0003\u0013\u0019+hn\u0019;j_:$\u0004\u0003BA?\u0003\u0007k!!a \u000b\t\u0005\u0005\u0015QI\u0001\te\u0016\fX/Z:ug&!\u0011QQA@\u0005E!&/\u00198tC\u000e$\u0018n\u001c8SKN,H\u000e\u001e\t\u00049\u0006%\u0015bAAF)\n\u0019BK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCB\u0019A,a$\n\u0007\u0005EEK\u0001\nUq:$&/\u00198tSRlU\r^1eCR\f\u0007c\u00011\u0002\u0016&\u0019\u0011qS1\u0003\tUs\u0017\u000e^\u0001\rg\",H\u000f^5oO\u0012{wO\\\u000b\u0003\u0003;\u0003B!a(\u000226\u0011\u0011\u0011\u0015\u0006\u0005\u0003G\u000b)+\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003O\u000bI+\u0001\u0006d_:\u001cWO\u001d:f]RTA!a+\u0002.\u0006!Q\u000f^5m\u0015\t\ty+\u0001\u0003kCZ\f\u0017\u0002BAZ\u0003C\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017!D:ikR$\u0018N\\4E_^t\u0007%A\u0005ti\u0006$X\rT8dWV\u0011\u00111\u0018\t\u0005\u0003{\u000b\u0019-\u0004\u0002\u0002@*!\u0011\u0011YAS\u0003\u0015awnY6t\u0013\u0011\t)-a0\u0003-I+WM\u001c;sC:$(+Z1e/JLG/\u001a'pG.\f!b\u001d;bi\u0016dunY6!\u0003Eaw.\u00193j]\u001e\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003\u001b\u0004b!a4\u0002Z\u0006uWBAAi\u0015\u0011\t\u0019.!6\u0002\u000f5,H/\u00192mK*\u0019\u0011q[1\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\\\u0006E'aA*fiB\u0019A,a8\n\u0007\u0005\u0005HK\u0001\u0012Ue\u0006t7/Y2uS>t\u0007+\u0019:uSRLwN\\!oI2+\u0017\rZ3s\u000bB|7\r[\u0001\u0013Y>\fG-\u001b8h!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\rue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018mQ1dQ\u0016,\"!!;\u0011\u000f\u0005=\u00171^5\u0002p&!\u0011Q^Ai\u0005\ri\u0015\r\u001d\t\u00049\u0006E\u0018bAAz)\n)B\u000b\u001f8NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z#oiJL\u0018!\u0007;sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f7)Y2iK\u0002\naE]3ue&,g/\u001a+sC:\u001c\u0018m\u0019;j_:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u+\t\tY\u0010\u0005\u0003a\u0003{L\u0017bAA\u0000C\nIa)\u001e8di&|g\u000eM\u0001+e\u0016$(/[3wKR\u0013\u0018M\\:bGRLwN\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\\"pk:$x\fJ3r)\u0011\t\u0019J!\u0002\t\u0013\t\u001dQ%!AA\u0002\u0005m\u0018a\u0001=%c\u00059#/\u001a;sS\u00164X\r\u0016:b]N\f7\r^5p]R{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;!\u0003y!(/\u00198tC\u000e$\u0018n\u001c8U_BL7\rU1si&$\u0018n\u001c8D_VtG/\u0001\u0012ue\u0006t7/Y2uS>tGk\u001c9jGB\u000b'\u000f^5uS>t7i\\;oi~#S-\u001d\u000b\u0005\u0003'\u0013\t\u0002\u0003\u0005\u0003\b!\n\t\u00111\u0001j\u0003}!(/\u00198tC\u000e$\u0018n\u001c8U_BL7\rU1si&$\u0018n\u001c8D_VtG\u000f\t\u0015\u0004S\t]\u0001c\u00011\u0003\u001a%\u0019!1D1\u0003\u0011Y|G.\u0019;jY\u0016\f1\u0003]1si&$\u0018n\u001c8M_\u0006$7+\u001a8t_J,\"A!\t\u0011\t\u0005m#1E\u0005\u0005\u0005K\tiF\u0001\u0004TK:\u001cxN]\u0001\u0015a\u0006\u0014H/\u001b;j_:du.\u00193TK:\u001cxN\u001d\u0011\u000215\f\u0007p\u00149f]RCh\u000eV5nK6+GO]5d\u001d\u0006lW-\u0006\u0002\u0003.A!!q\u0006B\u0019\u001b\t\t)%\u0003\u0003\u00034\u0005\u0015#AC'fiJL7MT1nK\u0006IR.\u0019=Pa\u0016tG\u000b\u001f8US6,W*\u001a;sS\u000et\u0015-\\3!\u0003a!(/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;TK:\u001cxN]\u0001\u001aiJ\fgn]1di&|g\u000eV5nK>,HoU3og>\u0014\b%A\u000buS6,w.\u001e;SCR,W*\u001a;sS\u000et\u0015-\\3\u0002-QLW.Z8viJ\u000bG/Z'fiJL7MT1nK\u0002\na\u0003^5nK>,HoQ8v]RlU\r\u001e:jG:\u000bW.Z\u0001\u0018i&lWm\\;u\u0007>,h\u000e^'fiJL7MT1nK\u0002\n\u0001c\u001d;bi\u0016,%O]8s'\u0016t7o\u001c:\u0002#M$\u0018\r^3FeJ|'oU3og>\u0014\b%\u0001\rti\u0006$X-\u0012:s_J\u0014\u0016\r^3NKR\u0014\u0018n\u0019(b[\u0016\f\u0011d\u001d;bi\u0016,%O]8s%\u0006$X-T3ue&\u001cg*Y7fA\u0005I2\u000f^1uK\u0016\u0013(o\u001c:D_VtG/T3ue&\u001cg*Y7f\u0003i\u0019H/\u0019;f\u000bJ\u0014xN]\"pk:$X*\u001a;sS\u000et\u0015-\\3!\u0003M\tG\r\u001a'pC\u0012Lgn\u001a)beRLG/[8o)\u0019\t\u0019Ja\u0015\u0003X!1!Q\u000b\u001eA\u0002%\f1\u0002]1si&$\u0018n\u001c8JI\"1!\u0011\f\u001eA\u0002%\f\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\u0002)QLW.\u001a3PkR$&/\u00198tC\u000e$\u0018n\u001c8t)\t\u0011y\u0006\u0005\u0004\u0003b\t-$\u0011\u000f\b\u0005\u0005G\u00129GD\u0002y\u0005KJ\u0011AY\u0005\u0004\u0005S\n\u0017a\u00029bG.\fw-Z\u0005\u0005\u0005[\u0012yG\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\u0011I'\u0019\t\u00049\nM\u0014b\u0001B;)\n\tCK]1og\u0006\u001cG/[8oC2LE-\u00118e!J|G-^2fe&#W\t]8dQ\u0006i\"/Z7pm\u0016,\u0005\u0010]5sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY&#7\u000f\u0006\u0004\u0002\u0014\nm$Q\u0011\u0005\b\u0005{b\u0004\u0019\u0001B@\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8QCJ$\u0018\u000e^5p]B!!q\u0006BA\u0013\u0011\u0011\u0019)!\u0012\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9!q\u0011\u001fA\u0002\u0005=\u0018!\u0006;y]6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u000b:$(/_\u0001\rg\"|W\u000f\u001c3FqBL'/\u001a\u000b\u0007\u0005\u001b\u0013\u0019Ja&\u0011\u0007\u0001\u0014y)C\u0002\u0003\u0012\u0006\u0014qAQ8pY\u0016\fg\u000eC\u0004\u0003\u0016v\u0002\r!a\"\u0002\u0017QDh.T3uC\u0012\fG/\u0019\u0005\b\u00053k\u0004\u0019\u0001BN\u00035\u0019WO\u001d:f]R$\u0016.\\3NgB\u0019\u0001M!(\n\u0007\t}\u0015M\u0001\u0003M_:<\u0017!F7bs\n,\u0017\t\u001d9f]\u0012,\u0005\u0010]5sCRLwN\u001c\u000b\t\u0005\u001b\u0013)Ka*\u00038\"9!Q\u0013 A\u0002\u0005\u001d\u0005b\u0002BU}\u0001\u0007!1V\u0001\u000fe\u0016\u001cwN\u001d3t\u0005VLG\u000eZ3s!\u0011\u0011iKa-\u000e\u0005\t=&\u0002\u0002BY\u0003\u000b\naA]3d_J$\u0017\u0002\u0002B[\u0005_\u0013A#T3n_JL(+Z2pe\u0012\u001c()^5mI\u0016\u0014\bb\u0002BM}\u0001\u0007!1\u0014\u000b\u0003\u0003'\u000b\u0011f\u001e:ji\u0016$v.\u001c2ti>tWm\u001d$pe\u0016C\b/\u001b:fIR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001cH\u0003CAJ\u0005\u007f\u0013\tM!4\t\u000f\tu\u0004\t1\u0001\u0003\u0000!9!1\u0019!A\u0002\t\u0015\u0017aE3ya&\u0014X\r\u001a$peB\u000b'\u000f^5uS>t\u0007C\u0002B1\u0005W\u00129\rE\u0002]\u0005\u0013L1Aa3U\u0005)\"&/\u00198tC\u000e$\u0018n\u001c8bY&#7i\\8sI&t\u0017\r^8s\u000bB|7\r[!oI6+G/\u00193bi\u0006DqAa4A\u0001\u0004\u0011\t.\u0001\tu_6\u00147\u000f^8oKJ+7m\u001c:egB!!Q\u0016Bj\u0013\u0011\u0011)Na,\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0003})g.\u00192mKR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012,\u0005\u0010]5sCRLwN\\\u0001\u0014O\u0016$HK]1og\u0006\u001cG/[8o'R\fG/\u001a\u000b\u0005\u0005;\u0014Y\u0010\u0005\u0005\u0003b\t}'1\u001dBx\u0013\u0011\u0011\tOa\u001c\u0003\r\u0015KG\u000f[3s!\u0011\u0011)Oa;\u000e\u0005\t\u001d(\u0002\u0002Bu\u0003\u000b\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005[\u00149O\u0001\u0004FeJ|'o\u001d\t\u0006A\nE(Q_\u0005\u0004\u0005g\f'AB(qi&|g\u000eE\u0002]\u0005oL1A!?U\u0005y\u0019un\u001c:eS:\fGo\u001c:Fa>\u001c\u0007.\u00118e)btW*\u001a;bI\u0006$\u0018\r\u0003\u0004\u0003~\n\u0003\r!^\u0001\u0010iJ\fgn]1di&|g.\u00197JI\u0006q\u0002/\u001e;Ue\u0006t7/Y2uS>t7\u000b^1uK&3gj\u001c;Fq&\u001cHo\u001d\u000b\u0005\u0007\u0007\u0019)\u0001\u0005\u0005\u0003b\t}'1\u001dB{\u0011\u001d\u0011)j\u0011a\u0001\u0003\u000f\u000bQ\u0003\\5tiR\u0013\u0018M\\:bGRLwN\\*uCR,7\u000f\u0006\u0004\u0004\f\r]1q\u0004\t\u0005\u0007\u001b\u0019\u0019\"\u0004\u0002\u0004\u0010)!1\u0011CA#\u0003\u001diWm]:bO\u0016LAa!\u0006\u0004\u0010\taB*[:u)J\fgn]1di&|gn\u001d*fgB|gn]3ECR\f\u0007bBB\r\t\u0002\u000711D\u0001\u0012M&dG/\u001a:Qe>$WoY3s\u0013\u0012\u001c\b#\u0002<\u0004\u001e\tm\u0015bAAn\u007f\"91\u0011\u0005#A\u0002\r\r\u0012\u0001\u00054jYR,'o\u0015;bi\u0016t\u0015-\\3t!\u001118QD;\u0002=\u001d,G/\u00118e\u001b\u0006L(-Z!eIR\u0013\u0018M\\:bGRLwN\\*uCR,GC\u0002Bo\u0007S\u0019Y\u0003\u0003\u0004\u0003~\u0016\u0003\r!\u001e\u0005\b\u0007[)\u0005\u0019AB\u0018\u0003U\u0019'/Z1uK\u0012$\u0006P\\'fi\u0006$\u0017\r^1PaR\u0004R\u0001\u0019By\u0003\u000f\u000bAD^1mS\u0012\fG/\u001a+sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5\u000f\u0006\u0003\u0003\u000e\u000eU\u0002BBB\u001c\r\u0002\u0007\u0011.\u0001\u0007uq:$\u0016.\\3pkRl5/A\fue\u0006t7/Y2uS>tGk\u001c9jG\u000e{gNZ5hgV\u00111Q\b\t\u0005\u0007\u007f\u0019\t%\u0004\u0002\u0002*&!11IAU\u0005)\u0001&o\u001c9feRLWm]\u0001\ra\u0006\u0014H/\u001b;j_:4uN\u001d\u000b\u0004S\u000e%\u0003B\u0002B\u007f\u0011\u0002\u0007Q/A\fm_\u0006$GK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCR11qJB+\u00073\u0002r!a\u0005\u0004RU\f9)\u0003\u0003\u0004T\u0005U!\u0001\u0002)p_2Dqaa\u0016J\u0001\u0004\u0011y(\u0001\bu_BL7\rU1si&$\u0018n\u001c8\t\r\te\u0013\n1\u0001j\u0003q\tG\r\u001a'pC\u0012,G\r\u0016:b]N\f7\r^5p]N$vnQ1dQ\u0016$\u0002\"a%\u0004`\r\r4Q\r\u0005\u0007\u0007CR\u0005\u0019A5\u0002#QDh\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0003Z)\u0003\r!\u001b\u0005\b\u0007OR\u0005\u0019AB(\u0003Iaw.\u00193fIR\u0013\u0018M\\:bGRLwN\\:\u0002I1|\u0017\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001chi\u001c:Uq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:$\u0002\"a%\u0004n\r=4\u0011\u000f\u0005\u0007\u0005+Z\u0005\u0019A5\t\r\te3\n1\u0001j\u0011\u001d\u0019\u0019h\u0013a\u0001\u0007k\nab]3oIRCh.T1sW\u0016\u00148\u000fE\u0002\u0004xmi\u0011aE\u0001'e\u0016lwN^3Ue\u0006t7/Y2uS>t7OR8s)btGk\u001c9jGB\u000b'\u000f^5uS>tG\u0003BAJ\u0007{BaA!\u0016M\u0001\u0004IGCBAJ\u0007\u0003\u001b\u0019\t\u0003\u0004\u0003V5\u0003\r!\u001b\u0005\u0007\u00053j\u0005\u0019A5\u0002]Y\fG.\u001b3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8U_BL7\rU1si&$\u0018n\u001c8D_VtG/S:Ti\u0006\u0014G.Z\u0001\u0017CB\u0004XM\u001c3Ue\u0006t7/Y2uS>tGk\u001c'pORq\u00111SBF\u0007\u001b\u001byia%\u0004\u001e\u000e\r\u0006B\u0002B\u007f\u001f\u0002\u0007Q\u000f\u0003\u0004\u0003Z=\u0003\r!\u001b\u0005\b\u0007#{\u0005\u0019AAG\u0003-qWm^'fi\u0006$\u0017\r^1\t\u000f\rUu\n1\u0001\u0004\u0018\u0006\u0001\"/Z:q_:\u001cXmQ1mY\n\f7m\u001b\t\bA\u000ee%1]AJ\u0013\r\u0019Y*\u0019\u0002\n\rVt7\r^5p]FB\u0011ba(P!\u0003\u0005\ra!)\u0002\u0019I,GO]=P]\u0016\u0013(o\u001c:\u0011\u000f\u0001\u001cIJa9\u0003\u000e\"91QU(A\u0002\r\u001d\u0016\u0001\u0004:fcV,7\u000f\u001e'pG\u0006d\u0007\u0003BA\u0016\u0007SKAaa+\u0002.\ta!+Z9vKN$Hj\\2bY\u0006\u0001\u0013\r\u001d9f]\u0012$&/\u00198tC\u000e$\u0018n\u001c8U_2{w\r\n3fM\u0006,H\u000e\u001e\u00136+\t\u0019\tL\u000b\u0003\u0004\"\u000eM6FAB[!\u0011\u00199l!1\u000e\u0005\re&\u0002BB^\u0007{\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r}\u0016-\u0001\u0006b]:|G/\u0019;j_:LAaa1\u0004:\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u000fM$\u0018M\u001d;vaR1\u00111SBe\u0007\u0017Dq!a>R\u0001\u0004\tY\u0010C\u0004\u0003XF\u0003\rA!$\u0002\u0011MDW\u000f\u001e3po:\u0004")
public class TransactionStateManager
implements Logging {
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TransactionConfig config;
    private final Time time;
    private final Metrics metrics;
    private final AtomicBoolean shuttingDown;
    private final ReentrantReadWriteLock kafka$coordinator$transaction$TransactionStateManager$$stateLock;
    private final Set<TransactionPartitionAndLeaderEpoch> loadingPartitions;
    private final scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache;
    private Function0<Object> retrieveTransactionTopicPartitionCount;
    private volatile int transactionTopicPartitionCount;
    private final Sensor partitionLoadSensor;
    private final MetricName maxOpenTxnTimeMetricName;
    private final Sensor transactionTimeoutSensor;
    private final MetricName timeoutRateMetricName;
    private final MetricName timeoutCountMetricName;
    private final Sensor stateErrorSensor;
    private final MetricName stateErrorRateMetricName;
    private final MetricName stateErrorCountMetricName;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String StateErrorSensor() {
        return TransactionStateManager$.MODULE$.StateErrorSensor();
    }

    public static String TimeoutSensor() {
        return TransactionStateManager$.MODULE$.TimeoutSensor();
    }

    public static String LoadTimeSensor() {
        return TransactionStateManager$.MODULE$.LoadTimeSensor();
    }

    public static String MetricsGroup() {
        return TransactionStateManager$.MODULE$.MetricsGroup();
    }

    public static int DefaultRemoveExpiredTransactionalIdsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs();
    }

    public static int DefaultAbortTimedOutTransactionsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs();
    }

    public static int DefaultTransactionalIdExpirationMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs();
    }

    public static int DefaultTransactionsMaxTimeoutMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    public ReentrantReadWriteLock kafka$coordinator$transaction$TransactionStateManager$$stateLock() {
        return this.kafka$coordinator$transaction$TransactionStateManager$$stateLock;
    }

    public Set<TransactionPartitionAndLeaderEpoch> loadingPartitions() {
        return this.loadingPartitions;
    }

    public scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache() {
        return this.transactionMetadataCache;
    }

    private Function0<Object> retrieveTransactionTopicPartitionCount() {
        return this.retrieveTransactionTopicPartitionCount;
    }

    private void retrieveTransactionTopicPartitionCount_$eq(Function0<Object> x$1) {
        this.retrieveTransactionTopicPartitionCount = x$1;
    }

    private int transactionTopicPartitionCount() {
        return this.transactionTopicPartitionCount;
    }

    private void transactionTopicPartitionCount_$eq(int x$1) {
        this.transactionTopicPartitionCount = x$1;
    }

    private Sensor partitionLoadSensor() {
        return this.partitionLoadSensor;
    }

    private MetricName maxOpenTxnTimeMetricName() {
        return this.maxOpenTxnTimeMetricName;
    }

    public Sensor transactionTimeoutSensor() {
        return this.transactionTimeoutSensor;
    }

    private MetricName timeoutRateMetricName() {
        return this.timeoutRateMetricName;
    }

    private MetricName timeoutCountMetricName() {
        return this.timeoutCountMetricName;
    }

    public Sensor stateErrorSensor() {
        return this.stateErrorSensor;
    }

    private MetricName stateErrorRateMetricName() {
        return this.stateErrorRateMetricName;
    }

    private MetricName stateErrorCountMetricName() {
        return this.stateErrorCountMetricName;
    }

    public void addLoadingPartition(int partitionId, int coordinatorEpoch) {
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$addLoadingPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public Iterable<TransactionalIdAndProducerIdEpoch> timedOutTransactions() {
        scala.collection.mutable.Iterable iterable;
        long now = this.time.milliseconds();
        Lock inReadLock_inLock_lock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            iterable = TransactionStateManager.$anonfun$timedOutTransactions$1(this, now);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return iterable;
    }

    private void removeExpiredTransactionalIds(TopicPartition transactionPartition, TxnMetadataCacheEntry txnMetadataCacheEntry) {
        Lock inReadLock_inLock_lock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$1(this, transactionPartition, txnMetadataCacheEntry);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private boolean shouldExpire(TransactionMetadata txnMetadata, long currentTimeMs) {
        return txnMetadata.state().isExpirationAllowed() && txnMetadata.txnLastUpdateTimestamp() <= currentTimeMs - (long)this.config.transactionalIdExpirationMs();
    }

    private boolean maybeAppendExpiration(TransactionMetadata txnMetadata, MemoryRecordsBuilder recordsBuilder, long currentTimeMs) {
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(txnMetadata.transactionalId());
        if (recordsBuilder.hasRoomFor(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS)) {
            recordsBuilder.append(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS);
            return true;
        }
        return false;
    }

    public void removeExpiredTransactionalIds() {
        Lock inReadLock_inLock_lock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$4(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private void writeTombstonesForExpiredTransactionalIds(TopicPartition transactionPartition, Iterable<TransactionalIdCoordinatorEpochAndMetadata> expiredForPartition, MemoryRecords tombstoneRecords) {
        Lock inReadLock_inLock_lock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$7(this, transactionPartition, tombstoneRecords, expiredForPartition);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public void enableTransactionalIdExpiration() {
        this.scheduler.schedule("transactionalId-expiration", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.removeExpiredTransactionalIds(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.scheduler.schedule$default$5());
    }

    public Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getTransactionState(String transactionalId) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)None$.MODULE$);
    }

    public Either<Errors, CoordinatorEpochAndTxnMetadata> putTransactionStateIfNotExists(TransactionMetadata txnMetadata) {
        return this.getAndMaybeAddTransactionState(txnMetadata.transactionalId(), (Option<TransactionMetadata>)new Some((Object)txnMetadata)).map((Function1 & Serializable)x$3 -> (CoordinatorEpochAndTxnMetadata)x$3.getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(61).append("Unexpected empty transaction metadata returned while putting ").append(txnMetadata).toString());
        }));
    }

    public ListTransactionsResponseData listTransactionStates(scala.collection.immutable.Set<Object> filterProducerIds, scala.collection.immutable.Set<String> filterStateNames) {
        ListTransactionsResponseData listTransactionsResponseData;
        Lock inReadLock_inLock_lock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            listTransactionsResponseData = TransactionStateManager.$anonfun$listTransactionStates$1(this, filterStateNames, filterProducerIds);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return listTransactionsResponseData;
    }

    private Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getAndMaybeAddTransactionState(String transactionalId, Option<TransactionMetadata> createdTxnMetadataOpt) {
        Either either;
        Lock inReadLock_inLock_lock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            either = TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$1(this, transactionalId, createdTxnMetadataOpt);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return either;
    }

    public boolean validateTransactionTimeoutMs(int txnTimeoutMs) {
        return txnTimeoutMs <= this.config.transactionMaxTimeoutMs() && txnTimeoutMs > 0;
    }

    /*
     * WARNING - void declaration
     */
    public Properties transactionTopicConfigs() {
        void var1_1;
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        props.put(LogConfig$.MODULE$.CompressionTypeProp(), UncompressedCodec$.MODULE$.name());
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(this.config.transactionLogMinInsyncReplicas()));
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(this.config.transactionLogSegmentBytes()));
        props.put(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), this.config.transactionLogPlacementConstraints());
        return var1_1;
    }

    public int partitionFor(String transactionalId) {
        return Utils.abs((int)transactionalId.hashCode()) % this.transactionTopicPartitionCount();
    }

    private Pool<String, TransactionMetadata> loadTransactionMetadata(TopicPartition topicPartition, int coordinatorEpoch) {
        Pool<String, TransactionMetadata> loadedTransactions = new Pool<String, TransactionMetadata>((Option<Function1<String, TransactionMetadata>>)None$.MODULE$);
        Option<AbstractLog> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Attempted to load transaction metadata from ").append(topicPartition).append(", but found no log").toString());
        } else if (option instanceof Some) {
            AbstractLog log = (AbstractLog)((Some)option).value();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            LongRef currOffset = LongRef.create((long)log.logStartOffset());
            boolean readAtLeastOneRecord = true;
            try {
                while (currOffset.elem < this.logEndOffset$1(topicPartition) && readAtLeastOneRecord && !this.shuttingDown().get()) {
                    MemoryRecords memoryRecords;
                    boolean bl;
                    Lock inReadLock_inLock_lock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock().readLock();
                    inReadLock_inLock_lock.lock();
                    try {
                        bl = TransactionStateManager.$anonfun$loadTransactionMetadata$3(this, topicPartition, coordinatorEpoch);
                    }
                    finally {
                        inReadLock_inLock_lock.unlock();
                    }
                    Object var17_16 = null;
                    Object var18_17 = null;
                    if (!bl) break;
                    AbstractFetchDataInfo abstractFetchDataInfo = log.read(currOffset.elem, this.config.transactionLogLoadBufferSize(), FetchLogEnd$.MODULE$, true, false);
                    if (!(abstractFetchDataInfo instanceof FetchDataInfo)) {
                        throw new IllegalStateException("Unexpected tiered segment for __transaction_state topic");
                    }
                    FetchDataInfo fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
                    readAtLeastOneRecord = fetchDataInfo.records().sizeInBytes() > 0;
                    Records records = fetchDataInfo.records();
                    if (records instanceof MemoryRecords) {
                        memoryRecords = (MemoryRecords)records;
                    } else if (records instanceof FileRecords) {
                        MemoryRecords memoryRecords2;
                        FileRecords fileRecords = (FileRecords)records;
                        int sizeInBytes = fileRecords.sizeInBytes();
                        int bytesNeeded = Math.max(this.config.transactionLogLoadBufferSize(), sizeInBytes);
                        if (buffer.capacity() < bytesNeeded) {
                            if (this.config.transactionLogLoadBufferSize() < bytesNeeded) {
                                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(67).append("Loaded transaction metadata from ").append(topicPartition).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").toString()).append(new StringBuilder(58).append("configured transaction.state.log.load.buffer.size (").append($this.config.transactionLogLoadBufferSize()).append(" bytes)").toString()).toString());
                            }
                            buffer = ByteBuffer.allocate(bytesNeeded);
                        } else {
                            buffer.clear();
                        }
                        buffer.clear();
                        fileRecords.readInto(buffer, 0);
                        MemoryRecords memoryRecords3 = memoryRecords2 = new MemoryRecords(buffer);
                        memoryRecords2 = null;
                        memoryRecords = memoryRecords3;
                    } else {
                        throw new MatchError((Object)records);
                    }
                    memoryRecords.batches().forEach(batch -> CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                        TransactionStateManager.$anonfun$loadTransactionMetadata$7(loadedTransactions, currOffset, batch, record);
                        return BoxedUnit.UNIT;
                    }));
                }
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Error loading transactions from transaction log ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            }
        } else {
            throw new MatchError(option);
        }
        return loadedTransactions;
    }

    public void addLoadedTransactionsToCache(int txnTopicPartition, int coordinatorEpoch, Pool<String, TransactionMetadata> loadedTransactions) {
        TxnMetadataCacheEntry txnMetadataCacheEntry = new TxnMetadataCacheEntry(coordinatorEpoch, loadedTransactions);
        this.transactionMetadataCache().put((Object)BoxesRunTime.boxToInteger((int)txnTopicPartition), (Object)txnMetadataCacheEntry).foreach((Function1 & Serializable)previousTxnMetadataCacheEntry -> {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Unloaded transaction metadata ").append(previousTxnMetadataCacheEntry).append(" from ").append(txnTopicPartition$1).append(" as part of ").toString()).append(new StringBuilder(26).append("loading metadata at epoch ").append(coordinatorEpoch$2).toString()).toString());
            return BoxedUnit.UNIT;
        });
    }

    public void loadTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch, Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit> sendTxnMarkers) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var8_6 = null;
        long scheduleStartMs = this.time.milliseconds();
        this.scheduler.schedule(new StringBuilder(24).append("load-txns-for-partition-").append(topicPartition).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.loadTransactions$1(Predef$.MODULE$.long2Long(scheduleStartMs), topicPartition, coordinatorEpoch, partitionAndLeaderEpoch, sendTxnMarkers), this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        Lock inWriteLock_inLock_lock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$1(this, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$5(this, partitionAndLeaderEpoch, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private void validateTransactionTopicPartitionCountIsStable() {
        int curTransactionTopicPartitionCount;
        int previouslyDeterminedPartitionCount = this.transactionTopicPartitionCount();
        if (previouslyDeterminedPartitionCount != (curTransactionTopicPartitionCount = this.retrieveTransactionTopicPartitionCount().apply$mcI$sp())) {
            throw new KafkaException(new StringBuilder(60).append("Transaction topic number of partitions has changed from ").append(previouslyDeterminedPartitionCount).append(" to ").append(curTransactionTopicPartitionCount).toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void appendTransactionToLog(String transactionalId, int coordinatorEpoch, TxnTransitMetadata newMetadata, Function1<Errors, BoxedUnit> responseCallback, Function1<Errors, Object> retryOnError, RequestLocal requestLocal) {
        keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        valueBytes = TransactionLog$.MODULE$.valueToBytes(newMetadata);
        timestamp = this.time.milliseconds();
        var17_10 = new SimpleRecord[]{new SimpleRecord(timestamp, keyBytes, valueBytes)};
        withRecords_compressionType = TransactionLog$.MODULE$.EnforcedCompressionType();
        withRecords_magic = 2;
        var23_13 = TimestampType.CREATE_TIME;
        withRecords_initialOffset = 0L;
        v0 = var24_15 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        var23_13 = null;
        var24_15 = null;
        v1 = var20_16 = v0;
        var20_16 = null;
        v2 = var18_17 = v1;
        var16_11 = null;
        var17_10 = null;
        var18_17 = null;
        records = v2;
        topicPartition = new TopicPartition("__transaction_state", this.partitionFor(transactionalId));
        recordsPerPartition = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records)}));
        inReadLock_inLock_lock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            block10: {
                block9: {
                    var25_22 = false;
                    var26_23 = null;
                    var27_24 = this.getTransactionState(transactionalId);
                    if (!(var27_24 instanceof Left)) break block9;
                    $anonfun$appendTransactionToLog$13_err = (Errors)((Left)var27_24).value();
                    (BoxedUnit)responseCallback.apply((Object)$anonfun$appendTransactionToLog$13_err);
                    break block10;
                }
                if (!(var27_24 instanceof Right)) ** GOTO lbl-1000
                var25_22 = true;
                var26_23 = (Right)var27_24;
                var29_26 = (Option)var26_23.value();
                if (None$.MODULE$.equals(var29_26)) {
                    (BoxedUnit)responseCallback.apply((Object)Errors.NOT_COORDINATOR);
                } else if (var25_22 && (var30_27 = (Option)var26_23.value()) instanceof Some) {
                    $anonfun$appendTransactionToLog$13_epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var30_27).value();
                    if (BoxesRunTime.unboxToBoolean($anonfun$appendTransactionToLog$13_epochAndMetadata.transactionMetadata().inLock((JFunction0.mcZ.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$appendTransactionToLog$14(kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 ), ()Z)((CoordinatorEpochAndTxnMetadata)$anonfun$appendTransactionToLog$13_epochAndMetadata, (int)coordinatorEpoch, responseCallback)))) {
                        $anonfun$appendTransactionToLog$13_x$1 = newMetadata.txnTimeoutMs();
                        $anonfun$appendTransactionToLog$13_x$2 = TransactionLog$.MODULE$.EnforcedRequiredAcks();
                        $anonfun$appendTransactionToLog$13_x$4 = AppendOrigin$Coordinator$.MODULE$;
                        $anonfun$appendTransactionToLog$13_x$6 = (Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$appendTransactionToLog$15$adapted(kafka.coordinator.transaction.TransactionStateManager org.apache.kafka.common.TopicPartition java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int scala.Function1 scala.Function1 scala.collection.Map ), (Lscala/collection/Map;)Ljava/lang/Object;)((TransactionStateManager)this, (TopicPartition)topicPartition, (String)transactionalId, (TxnTransitMetadata)newMetadata, (int)coordinatorEpoch, retryOnError, responseCallback);
                        $anonfun$appendTransactionToLog$13_x$8 = this.replicaManager.appendRecords$default$7();
                        $anonfun$appendTransactionToLog$13_x$9 = this.replicaManager.appendRecords$default$8();
                        this.replicaManager.appendRecords($anonfun$appendTransactionToLog$13_x$1, $anonfun$appendTransactionToLog$13_x$2, true, $anonfun$appendTransactionToLog$13_x$4, (Map<TopicPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)$anonfun$appendTransactionToLog$13_x$6, $anonfun$appendTransactionToLog$13_x$8, $anonfun$appendTransactionToLog$13_x$9, requestLocal);
                        this.trace((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$16(kafka.coordinator.transaction.TxnTransitMetadata java.lang.String int ), ()Ljava/lang/String;)((TxnTransitMetadata)newMetadata, (String)transactionalId, (int)coordinatorEpoch));
                    }
                } else {
                    throw new MatchError(var27_24);
                }
            }
            var26_23 = null;
            var27_24 = null;
            var28_25 = null;
            var29_26 = null;
            var30_27 = null;
            var31_28 = null;
            var35_31 = null;
            var36_32 = null;
            var37_33 = null;
            var38_34 = null;
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public Function1<Errors, Object> appendTransactionToLog$default$5() {
        return (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$appendTransactionToLog$default$5$1(x$8));
    }

    public void startup(Function0<Object> retrieveTransactionTopicPartitionCount, boolean enableTransactionalIdExpiration) {
        this.retrieveTransactionTopicPartitionCount = retrieveTransactionTopicPartitionCount;
        this.transactionTopicPartitionCount_$eq(retrieveTransactionTopicPartitionCount.apply$mcI$sp());
        if (enableTransactionalIdExpiration) {
            this.enableTransactionalIdExpiration();
        }
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        this.loadingPartitions().clear();
        this.transactionMetadataCache().clear();
        this.metrics.removeMetric(this.maxOpenTxnTimeMetricName());
        this.metrics.removeSensor(TransactionStateManager$.MODULE$.LoadTimeSensor());
        this.metrics.removeSensor(TransactionStateManager$.MODULE$.TimeoutSensor());
        this.metrics.removeSensor(TransactionStateManager$.MODULE$.StateErrorSensor());
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutdown complete");
    }

    public static final /* synthetic */ boolean $anonfun$addLoadingPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$3(long now$2, Tuple2 x0$2) {
        boolean bl;
        if (x0$2 != null) {
            TransactionMetadata txnMetadata = (TransactionMetadata)x0$2._2();
            if (txnMetadata.pendingTransitionInProgress()) {
                bl = false;
            } else {
                TransactionState transactionState = txnMetadata.state();
                boolean bl2 = Ongoing$.MODULE$.equals(transactionState) ? txnMetadata.txnStartTimestamp() + (long)txnMetadata.txnTimeoutMs() < now$2 : false;
                bl = bl2;
            }
        } else {
            throw new MatchError(null);
        }
        boolean bl3 = bl;
        return bl3;
    }

    public static final /* synthetic */ scala.collection.mutable.Iterable $anonfun$timedOutTransactions$1(TransactionStateManager $this, long now$2) {
        return (scala.collection.mutable.Iterable)$this.transactionMetadataCache().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            IterableOnce iterableOnce = (IterableOnce)((IterableOps)((TxnMetadataCacheEntry)x0$1._2()).metadataPerTransactionalId().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$3(now$2, x0$2)))).map((Function1 & Serializable)x0$3 -> {
                if (x0$3 == null) {
                    throw new MatchError(null);
                }
                String txnId = (String)x0$3._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)x0$3._2();
                TransactionalIdAndProducerIdEpoch transactionalIdAndProducerIdEpoch = new TransactionalIdAndProducerIdEpoch(txnId, txnMetadata.producerId(), txnMetadata.producerEpoch());
                return transactionalIdAndProducerIdEpoch;
            });
            return iterableOnce;
        });
    }

    private final void flushRecordsBuilder$1(TopicPartition transactionPartition$1, ListBuffer expired$1, ObjectRef recordsBuilder$1) {
        this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired$1.toSeq(), ((MemoryRecordsBuilder)recordsBuilder$1.elem).build());
        expired$1.clear();
        recordsBuilder$1.elem = null;
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$1(TransactionStateManager $this, TopicPartition transactionPartition$1, TxnMetadataCacheEntry txnMetadataCacheEntry$1) {
        Option<LogConfig> option = $this.replicaManager.getLogConfig(transactionPartition$1);
        if (option instanceof Some) {
            LogConfig logConfig = (LogConfig)((Some)option).value();
            long currentTimeMs = $this.time.milliseconds();
            Integer maxBatchSize = logConfig.maxMessageSize();
            ListBuffer expired = ListBuffer$.MODULE$.empty();
            ObjectRef recordsBuilder = ObjectRef.create(null);
            BufferedIterator stateEntries = txnMetadataCacheEntry$1.metadataPerTransactionalId().values().iterator().buffered();
            while (stateEntries.hasNext()) {
                TransactionMetadata txnMetadata = (TransactionMetadata)stateEntries.head();
                String transactionalId = txnMetadata.transactionalId();
                BooleanRef fullBatch = BooleanRef.create((boolean)false);
                txnMetadata.inLock((Function0 & Serializable)() -> {
                    if (txnMetadata.pendingState().isEmpty() && $this.shouldExpire(txnMetadata, currentTimeMs)) {
                        if ((MemoryRecordsBuilder)recordsBuilder$1.elem == null) {
                            recordsBuilder$1.elem = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(package$.MODULE$.min(16384, Predef$.MODULE$.Integer2int(maxBatchSize))), (CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (TimestampType)TimestampType.CREATE_TIME, (long)0L, (int)Predef$.MODULE$.Integer2int(maxBatchSize));
                        }
                        if ($this.maybeAppendExpiration(txnMetadata, (MemoryRecordsBuilder)recordsBuilder$1.elem, currentTimeMs)) {
                            TxnTransitMetadata transitMetadata = txnMetadata.prepareDead();
                            return expired.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndMetadata(transactionalId, txnMetadataCacheEntry$1.coordinatorEpoch(), transitMetadata));
                        }
                        fullBatch$1.elem = true;
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                });
                if (fullBatch.elem) {
                    $this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired.toSeq(), ((MemoryRecordsBuilder)recordsBuilder.elem).build());
                    expired.clear();
                    recordsBuilder.elem = null;
                    continue;
                }
                stateEntries.next();
            }
            if (expired.nonEmpty()) {
                $this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired.toSeq(), ((MemoryRecordsBuilder)recordsBuilder.elem).build());
                expired.clear();
                recordsBuilder.elem = null;
                return;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(95).append(new StringBuilder(61).append("Transaction expiration for partition ").append(transactionPartition$1).append(" failed because the log ").toString()).append("config was not available, which likely means the partition is not online or is no longer local.").toString());
                return;
            }
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$5(TransactionStateManager $this, int partitionId, TxnMetadataCacheEntry partitionCacheEntry) {
        TopicPartition transactionPartition = new TopicPartition("__transaction_state", partitionId);
        $this.removeExpiredTransactionalIds(transactionPartition, partitionCacheEntry);
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$4(TransactionStateManager $this) {
        $this.transactionMetadataCache().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(partitionId, partitionCacheEntry) -> {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$5($this, BoxesRunTime.unboxToInt((Object)partitionId), partitionCacheEntry);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$2(TransactionStateManager $this, TopicPartition topicPartition$1, Iterable expiredForPartition$1, ProduceResponse.PartitionResponse response$1) {
        $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)topicPartition$1.partition())).foreach((Function1 & Serializable)txnMetadataCacheEntry -> {
            expiredForPartition$1.foreach((Function1 & Serializable)idCoordinatorEpochAndMetadata -> {
                String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
                TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
                return txnMetadata.inLock((Function0 & Serializable)() -> {
                    if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                        Errors errors = response$1.error;
                        Errors errors2 = Errors.NONE;
                        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                            return txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                        }
                    }
                    $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(42).append("Failed to remove expired transactionalId: ").append(transactionalId).toString()).append(new StringBuilder(43).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").toString()).append(new StringBuilder(33).append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").toString()).append(new StringBuilder(26).append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").toString()).append(new StringBuilder(48).append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").toString()).append(String.valueOf(BoxesRunTime.boxToInteger((int)idCoordinatorEpochAndMetadata.coordinatorEpoch()))).toString());
                    txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$1(TransactionStateManager $this, Iterable expiredForPartition$1, TopicPartition topicPartition, ProduceResponse.PartitionResponse response) {
        Lock inReadLock_inLock_lock = $this.kafka$coordinator$transaction$TransactionStateManager$$stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$2($this, topicPartition, expiredForPartition$1, response);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private final void removeFromCacheCallback$1(Map responses, Iterable expiredForPartition$1) {
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, response) -> {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$1(this, expiredForPartition$1, topicPartition, response);
            return BoxedUnit.UNIT;
        };
        responses.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$7(TransactionStateManager $this, TopicPartition transactionPartition$2, MemoryRecords tombstoneRecords$1, Iterable expiredForPartition$1) {
        long x$1 = $this.config.requestTimeoutMs();
        short x$2 = TransactionLog$.MODULE$.EnforcedRequiredAcks();
        AppendOrigin$Coordinator$ x$4 = AppendOrigin$Coordinator$.MODULE$;
        scala.collection.immutable.Map x$5 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)transactionPartition$2), (Object)tombstoneRecords$1)}));
        Function1 & Serializable x$6 = (Function1 & Serializable)responses -> {
            $this.removeFromCacheCallback$1(responses, expiredForPartition$1);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$7 = RequestLocal$.MODULE$.NoCaching();
        Option<Lock> x$8 = $this.replicaManager.appendRecords$default$7();
        Function1<Map<TopicPartition, RecordConversionStats>, BoxedUnit> x$9 = $this.replicaManager.appendRecords$default$8();
        $this.replicaManager.appendRecords(x$1, x$2, true, x$4, (Map<TopicPartition, MemoryRecords>)x$5, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)x$6, x$8, x$9, x$7);
    }

    private static final boolean shouldInclude$1(TransactionMetadata txnMetadata, scala.collection.immutable.Set filterProducerIds$1, scala.collection.immutable.Set filterStateNames$1, Set filterStates$1) {
        TransactionState transactionState = txnMetadata.state();
        Dead$ dead$ = Dead$.MODULE$;
        if (transactionState != null && transactionState.equals(dead$)) {
            return false;
        }
        if (filterProducerIds$1.nonEmpty() && !filterProducerIds$1.contains((Object)BoxesRunTime.boxToLong((long)txnMetadata.producerId()))) {
            return false;
        }
        return !filterStateNames$1.nonEmpty() || filterStates$1.contains((Object)txnMetadata.state());
    }

    public static final /* synthetic */ void $anonfun$listTransactionStates$3(ArrayList states$1, scala.collection.immutable.Set filterProducerIds$1, scala.collection.immutable.Set filterStateNames$1, Set filterStates$1, int x$4, TxnMetadataCacheEntry cache) {
        cache.metadataPerTransactionalId().values().foreach((Function1 & Serializable)txnMetadata -> txnMetadata.inLock((Function0 & Serializable)() -> {
            if (TransactionStateManager.shouldInclude$1(txnMetadata, filterProducerIds$1, filterStateNames$1, filterStates$1)) {
                return BoxesRunTime.boxToBoolean((boolean)states$1.add(new ListTransactionsResponseData.TransactionState().setTransactionalId(txnMetadata.transactionalId()).setProducerId(txnMetadata.producerId()).setTransactionState(txnMetadata.state().name())));
            }
            return BoxedUnit.UNIT;
        }));
    }

    public static final /* synthetic */ ListTransactionsResponseData $anonfun$listTransactionStates$1(TransactionStateManager $this, scala.collection.immutable.Set filterStateNames$1, scala.collection.immutable.Set filterProducerIds$1) {
        ListTransactionsResponseData response = new ListTransactionsResponseData();
        if ($this.loadingPartitions().nonEmpty()) {
            return response.setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code());
        }
        Set filterStates = (Set)Set$.MODULE$.empty();
        filterStateNames$1.foreach((Function1 & Serializable)stateName -> {
            Object object;
            Option<TransactionState> option = TransactionState$.MODULE$.fromName((String)stateName);
            if (option instanceof Some) {
                TransactionState state = (TransactionState)((Some)option).value();
                object = filterStates.$plus$eq((Object)state);
            } else if (None$.MODULE$.equals(option)) {
                object = BoxesRunTime.boxToBoolean((boolean)response.unknownStateFilters().add(stateName));
            } else {
                throw new MatchError(option);
            }
            return object;
        });
        ArrayList states = new ArrayList();
        $this.transactionMetadataCache().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(x$4, cache) -> {
            TransactionStateManager.$anonfun$listTransactionStates$3(states, filterProducerIds$1, filterStateNames$1, filterStates, BoxesRunTime.unboxToInt((Object)x$4), cache);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        return response.setErrorCode(Errors.NONE.code()).setTransactionStates(states);
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$2(int partitionId$1, TransactionPartitionAndLeaderEpoch x$5) {
        return x$5.txnPartitionId() == partitionId$1;
    }

    public static final /* synthetic */ Either $anonfun$getAndMaybeAddTransactionState$1(TransactionStateManager $this, String transactionalId$3, Option createdTxnMetadataOpt$1) {
        Left left;
        int partitionId = $this.partitionFor(transactionalId$3);
        if ($this.loadingPartitions().exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$2(partitionId, x$5)))) {
            return scala.package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        Option option = $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)partitionId));
        if (option instanceof Some) {
            TxnMetadataCacheEntry cacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            Option txnMetadata = Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().get(transactionalId$3)).orElse((Function0 & Serializable)() -> createdTxnMetadataOpt$1.map((Function1 & Serializable)createdTxnMetadata -> (TransactionMetadata)Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().putIfNotExists(transactionalId$3, (TransactionMetadata)createdTxnMetadata)).getOrElse((Function0 & Serializable)() -> createdTxnMetadata)));
            left = scala.package$.MODULE$.Right().apply((Object)txnMetadata.map((Function1 & Serializable)x$6 -> new CoordinatorEpochAndTxnMetadata(cacheEntry.coordinatorEpoch(), (TransactionMetadata)x$6)));
        } else if (None$.MODULE$.equals(option)) {
            left = scala.package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    private final long logEndOffset$1(TopicPartition topicPartition$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(topicPartition$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$4(TopicPartition topicPartition$2, int coordinatorEpoch$1, TransactionPartitionAndLeaderEpoch idAndEpoch) {
        return idAndEpoch.txnPartitionId() == topicPartition$2.partition() && idAndEpoch.coordinatorEpoch() == coordinatorEpoch$1;
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$3(TransactionStateManager $this, TopicPartition topicPartition$2, int coordinatorEpoch$1) {
        return $this.loadingPartitions().exists((Function1 & Serializable)idAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$loadTransactionMetadata$4(topicPartition$2, coordinatorEpoch$1, idAndEpoch)));
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$7(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch$1, Record record) {
        Predef$.MODULE$.require(record.hasKey(), (Function0 & Serializable)() -> "Transaction state log's key should not be null");
        String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
        Option<TransactionMetadata> option = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
        if (None$.MODULE$.equals(option)) {
            TransactionMetadata cfr_ignored_0 = (TransactionMetadata)loadedTransactions$1.remove(transactionalId);
        } else if (option instanceof Some) {
            TransactionMetadata txnMetadata = (TransactionMetadata)((Some)option).value();
            loadedTransactions$1.put(transactionalId, txnMetadata);
        } else {
            throw new MatchError(option);
        }
        currOffset$1.elem = batch$1.nextOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionsForTxnTopicPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$2);
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$4(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, TopicPartition topicPartition$3, int coordinatorEpoch$3, Pool loadedTransactions$2, Function4 sendTxnMarkers$1) {
        if ($this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
            $this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions$2);
            ListBuffer transactionsPendingForCompletion = new ListBuffer();
            loadedTransactions$2.foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String transactionalId = (String)x0$1._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                Object t = txnMetadata.inLock((Function0 & Serializable)() -> {
                    TransactionState transactionState = txnMetadata.state();
                    Object object = PrepareAbort$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : (PrepareCommit$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : BoxedUnit.UNIT);
                    return object;
                });
                return t;
            });
            $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
            transactionsPendingForCompletion.foreach((Function1 & Serializable)txnTransitMetadata -> {
                sendTxnMarkers$1.apply((Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                return BoxedUnit.UNIT;
            });
        }
    }

    private final void loadTransactions$1(Long startTimeMs, TopicPartition topicPartition$3, int coordinatorEpoch$3, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, Function4 sendTxnMarkers$1) {
        long schedulerTimeMs = this.time.milliseconds() - Predef$.MODULE$.Long2long(startTimeMs);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Loading transaction metadata from ").append(topicPartition$3).append(" at epoch ").append(coordinatorEpoch$3).toString());
        this.validateTransactionTopicPartitionCountIsStable();
        Pool<String, TransactionMetadata> loadedTransactions = this.loadTransactionMetadata(topicPartition$3, coordinatorEpoch$3);
        long endTimeMs = this.time.milliseconds();
        long totalLoadingTimeMs = endTimeMs - Predef$.MODULE$.Long2long(startTimeMs);
        this.partitionLoadSensor().record((double)totalLoadingTimeMs, endTimeMs, false);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Finished loading ").append(loadedTransactions.size()).append(" transaction metadata from ").append(topicPartition$3).append(" in ").toString()).append(new StringBuilder(65).append(totalLoadingTimeMs).append(" milliseconds, of which ").append(schedulerTimeMs).append(" milliseconds was spent in the scheduler.").toString()).toString());
        Lock inWriteLock_inLock_lock = this.kafka$coordinator$transaction$TransactionStateManager$$stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            if (this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
                this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions);
                ListBuffer $anonfun$loadTransactionsForTxnTopicPartition$4_transactionsPendingForCompletion = new ListBuffer();
                loadedTransactions.foreach((Function1 & Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    String transactionalId = (String)x0$1._1();
                    TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                    Object t = txnMetadata.inLock((Function0 & Serializable)() -> {
                        TransactionState transactionState = txnMetadata.state();
                        Object object = PrepareAbort$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : (PrepareCommit$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : BoxedUnit.UNIT);
                        return object;
                    });
                    return t;
                });
                this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
                $anonfun$loadTransactionsForTxnTopicPartition$4_transactionsPendingForCompletion.foreach((Function1 & Serializable)txnTransitMetadata -> {
                    sendTxnMarkers$1.apply((Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                    return BoxedUnit.UNIT;
                });
            }
            Object var15_11 = null;
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var13_10 = null;
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Completed loading transaction metadata from ").append(topicPartition$3).append(" for coordinator epoch ").append(coordinatorEpoch$3).toString());
    }

    public static final /* synthetic */ boolean $anonfun$removeTransactionsForTxnTopicPartition$2(int partitionId$2, TransactionPartitionAndLeaderEpoch x$7) {
        return x$7.txnPartitionId() == partitionId$2;
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$1(TransactionStateManager $this, int partitionId$2, TopicPartition topicPartition$4) {
        $this.loadingPartitions().$minus$minus$eq((IterableOnce)$this.loadingPartitions().filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$2(partitionId$2, x$7))));
        $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$2)).foreach((Function1 & Serializable)txnMetadataCacheEntry -> {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(46).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$4).append(" following ").toString()).append("local partition deletion").toString());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$5(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$3, int partitionId$3, TopicPartition topicPartition$5) {
        $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$3);
        Option option = $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$3));
        if (option instanceof Some) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$5).append(" on become-follower transition").toString());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("No cached transaction metadata found for ").append(topicPartition$5).append(" during become-follower transition").toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$1(String transactionalId$5, TxnTransitMetadata newMetadata$1, ProduceResponse.PartitionResponse status$1) {
        return new StringBuilder(41).append("Appending ").append(transactionalId$5).append("'s new metadata ").append(newMetadata$1).append(" failed due to ").append(status$1.error.exceptionName()).toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$2(String transactionalId$5, Errors err$1) {
        return new StringBuilder(0).append(new StringBuilder(63).append("Accessing the cached transaction metadata for ").append(transactionalId$5).append(" returns ").append(err$1).append(" error; ").toString()).append("aborting transition to the new metadata and setting the error in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$3(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndMetadata$1, int coordinatorEpoch$4, String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, TransactionMetadata metadata$1) {
        if (epochAndMetadata$1.coordinatorEpoch() != coordinatorEpoch$4) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(83).append("The cached coordinator epoch for ").append(transactionalId$5).append(" has changed to ").append(epochAndMetadata$1.coordinatorEpoch()).append(" after appended its new metadata ").append(newMetadata$1).append(" ").toString()).append(new StringBuilder(78).append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$5)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").toString()).append(new StringBuilder(70).append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString()).toString());
            responseError$1.elem = Errors.NOT_COORDINATOR;
            return;
        }
        metadata$1.completeTransitionTo(newMetadata$1);
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Updating ").append(transactionalId$5).append("'s transaction state to ").append(newMetadata$1).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" for ").append(transactionalId$5).append(" succeeded").toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$6(TransactionStateManager $this, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4) {
        return new StringBuilder(0).append(new StringBuilder(106).append("The cached coordinator metadata does not exist in the cache anymore for ").append(transactionalId$5).append(" after appended its new metadata ").append(newMetadata$1).append(" ").toString()).append(new StringBuilder(78).append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$5)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").toString()).append(new StringBuilder(70).append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString()).toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$7(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndTxnMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, ObjectRef responseError$1, TransactionMetadata metadata$2, TxnTransitMetadata newMetadata$1) {
        if (epochAndTxnMetadata$1.coordinatorEpoch() == coordinatorEpoch$4) {
            if (BoxesRunTime.unboxToBoolean((Object)retryOnError$1.apply((Object)((Errors)responseError$1.elem)))) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append(new StringBuilder(97).append("not resetting pending state ").append(metadata$2.pendingState()).append(" but just returning the error in the callback to let the caller retry").toString()).toString());
                return;
            }
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append(new StringBuilder(87).append("resetting pending state from ").append(metadata$2.pendingState()).append(", aborting state transition and returning ").append((Errors)responseError$1.elem).append(" in the callback").toString()).toString());
            metadata$2.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append(new StringBuilder(115).append("aborting state transition and returning the error in the callback since the coordinator epoch has changed from ").append(epochAndTxnMetadata$1.coordinatorEpoch()).append(" to ").append(coordinatorEpoch$4).toString()).toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$11(String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1) {
        return new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(transactionalId$5).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append("aborting state transition and returning the error in the callback since metadata is not available in the cache anymore").toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$12(String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, Errors error$1) {
        return new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(transactionalId$5).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").toString()).append(new StringBuilder(101).append("aborting state transition and returning the error in the callback since retrieving metadata returned ").append(error$1).toString()).toString();
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCacheCallback$1(Map responseStatus, TopicPartition topicPartition$6, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1) {
        block15: {
            block13: {
                block17: {
                    block16: {
                        block14: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$6)) {
                                throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Append status %s should only have one partition %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$6})));
                            }
                            status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$6);
                            v0 = status.error;
                            var14_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var14_9) == false : var14_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)status));
                                var15_10 = status.error;
                                var11_11 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var15_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var15_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var15_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var15_10) != false));
                                if (var11_11) {
                                    var8_12 = Errors.COORDINATOR_NOT_AVAILABLE;
                                } else {
                                    var10_13 = Errors.NOT_LEADER_OR_FOLLOWER.equals(var15_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var15_10) != false;
                                    if (var10_13) {
                                        var8_12 = Errors.NOT_COORDINATOR;
                                    } else {
                                        var9_14 = Errors.MESSAGE_TOO_LARGE.equals(var15_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var15_10) != false;
                                        var8_12 = var9_14 != false ? Errors.UNKNOWN_SERVER_ERROR : var15_10;
                                    }
                                }
                                v1 = var8_12;
                            }
                            responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)responseError.elem;
                            var16_16 = Errors.NONE;
                            if (v2 != null ? v2.equals(var16_16) == false : var16_16 != null) break block13;
                            var17_17 = false;
                            var18_18 = null;
                            var19_19 = this.getTransactionState(transactionalId$5);
                            if (!(var19_19 instanceof Left)) break block14;
                            err = (Errors)((Left)var19_19).value();
                            this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (Errors)err));
                            responseError.elem = err;
                            break block15;
                        }
                        if (!(var19_19 instanceof Right)) break block16;
                        var17_17 = true;
                        var18_18 = (Right)var19_19;
                        var21_21 = (Option)var18_18.value();
                        if (!(var21_21 instanceof Some)) break block16;
                        epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var21_21).value();
                        metadata = epochAndMetadata.transactionMetadata();
                        (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (TransactionMetadata)metadata));
                        break block15;
                    }
                    if (!var17_17 || !None$.MODULE$.equals(var24_24 = (Option)var18_18.value())) break block17;
                    this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)this, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    responseError.elem = Errors.NOT_COORDINATOR;
                    break block15;
                }
                throw new MatchError(var19_19);
            }
            var25_25 = false;
            var26_26 = null;
            var27_27 = this.getTransactionState(transactionalId$5);
            if (!(var27_27 instanceof Right)) ** GOTO lbl-1000
            var25_25 = true;
            var26_26 = (Right)var27_27;
            var28_28 = (Option)var26_26.value();
            if (var28_28 instanceof Some) {
                epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var28_28).value();
                metadata = epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, (ObjectRef)responseError, (TransactionMetadata)metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var25_25 && None$.MODULE$.equals(var31_31 = (Option)var26_26.value())) {
                this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError));
            } else if (var27_27 instanceof Left) {
                error = (Errors)((Left)var27_27).value();
                this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (Errors)error));
            } else {
                throw new MatchError(var27_27);
            }
        }
        responseCallback$1.apply((Object)((Errors)responseError.elem));
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$13(TransactionStateManager $this, String transactionalId$5, Function1 responseCallback$1, int coordinatorEpoch$4, TxnTransitMetadata newMetadata$1, scala.collection.immutable.Map recordsPerPartition$1, RequestLocal requestLocal$1, TopicPartition topicPartition$6, Function1 retryOnError$1) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.getTransactionState(transactionalId$5);
        if (either instanceof Left) {
            Errors err = (Errors)((Left)either).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$1.apply((Object)err);
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
            if (BoxesRunTime.unboxToBoolean(epochAndMetadata.transactionMetadata().inLock((JFunction0.mcZ.sp & Serializable)() -> {
                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch$4) {
                    responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                    return false;
                }
                return true;
            }))) {
                long x$1 = newMetadata$1.txnTimeoutMs();
                short x$2 = TransactionLog$.MODULE$.EnforcedRequiredAcks();
                AppendOrigin$Coordinator$ x$4 = AppendOrigin$Coordinator$.MODULE$;
                Function1 & Serializable x$6 = (Function1 & Serializable)responseStatus -> {
                    $this.updateCacheCallback$1(responseStatus, topicPartition$6, transactionalId$5, newMetadata$1, coordinatorEpoch$4, retryOnError$1, responseCallback$1);
                    return BoxedUnit.UNIT;
                };
                Option<Lock> x$8 = $this.replicaManager.appendRecords$default$7();
                Function1<Map<TopicPartition, RecordConversionStats>, BoxedUnit> x$9 = $this.replicaManager.appendRecords$default$8();
                $this.replicaManager.appendRecords(x$1, x$2, true, x$4, (Map<TopicPartition, MemoryRecords>)recordsPerPartition$1, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)x$6, x$8, x$9, requestLocal$1);
                $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(96).append("Appending new metadata ").append(newMetadata$1).append(" for transaction id ").append(transactionalId$5).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" to the local transaction log").toString());
                return;
            }
        } else {
            throw new MatchError(either);
        }
    }

    public static final /* synthetic */ boolean $anonfun$appendTransactionToLog$default$5$1(Errors x$8) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public TransactionStateManager(int brokerId, Scheduler scheduler, ReplicaManager replicaManager, TransactionConfig config, Time time, Metrics metrics) {
        void add_stat;
        void add_stat2;
        void add_stat3;
        void add_metricName;
        void add_stat4;
        void add_metricName2;
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.config = config;
        this.time = time;
        this.metrics = metrics;
        this.logIdent_$eq(new StringBuilder(30).append("[Transaction State Manager ").append(brokerId).append("]: ").toString());
        this.shuttingDown = new AtomicBoolean(false);
        this.kafka$coordinator$transaction$TransactionStateManager$$stateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionMetadataCache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.partitionLoadSensor = metrics.sensor(TransactionStateManager$.MODULE$.LoadTimeSensor());
        Sensor sensor = this.partitionLoadSensor();
        Max max = new Max();
        MetricName metricName = metrics.metricName("partition-load-time-max", TransactionStateManager$.MODULE$.MetricsGroup(), "The max time it took to load the partitions in the last 30sec");
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName2, (MeasurableStat)add_stat4, null);
        metricName = null;
        max = null;
        Sensor sensor2 = this.partitionLoadSensor();
        Avg avg = new Avg();
        MetricName metricName2 = metrics.metricName("partition-load-time-avg", TransactionStateManager$.MODULE$.MetricsGroup(), "The avg time it took to load the partitions in the last 30sec");
        if (sensor2 == null) {
            throw null;
        }
        sensor2.add((MetricName)add_metricName, (MeasurableStat)add_stat3, null);
        metricName2 = null;
        avg = null;
        this.maxOpenTxnTimeMetricName = metrics.metricName("active-transaction-total-time-max", TransactionStateManager$.MODULE$.MetricsGroup(), "The max time a currently-open transaction has been open");
        metrics.addMetric(this.maxOpenTxnTimeMetricName(), (MetricValueProvider)new Gauge<Object>(this){
            private final /* synthetic */ TransactionStateManager $outer;

            public long value(MetricConfig config, long now) {
                long l;
                Lock inReadLock_inLock_lock = this.$outer.kafka$coordinator$transaction$TransactionStateManager$$stateLock().readLock();
                inReadLock_inLock_lock.lock();
                try {
                    l = $anon$1.$anonfun$value$1(this, now);
                }
                finally {
                    inReadLock_inLock_lock.unlock();
                }
                return l;
            }

            public static final /* synthetic */ boolean $anonfun$value$3(Tuple2 x0$2) {
                boolean bl;
                if (x0$2 != null) {
                    TransactionState transactionState = ((TransactionMetadata)x0$2._2()).state();
                    boolean bl2 = Ongoing$.MODULE$.equals(transactionState) ? true : (PrepareAbort$.MODULE$.equals(transactionState) ? true : (PrepareCommit$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState)));
                    bl = bl2;
                } else {
                    throw new MatchError(null);
                }
                return bl;
            }

            public static final /* synthetic */ long $anonfun$value$4(Tuple2 x0$3) {
                if (x0$3 == null) {
                    throw new MatchError(null);
                }
                long l = ((TransactionMetadata)x0$3._2()).txnStartTimestamp();
                return l;
            }

            public static final /* synthetic */ long $anonfun$value$1($anon$1 $this, long now$1) {
                scala.collection.mutable.Iterable startTimestamps = (scala.collection.mutable.Iterable)$this.$outer.transactionMetadataCache().flatMap((Function1 & Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    Iterable iterable = (Iterable)((IterableOps)((TxnMetadataCacheEntry)x0$1._2()).metadataPerTransactionalId().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$value$3(x0$2)))).map((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToLong((long)$anon$1.$anonfun$value$4(x0$3)));
                    return iterable;
                });
                if (startTimestamps.isEmpty()) {
                    return 0L;
                }
                return Math.max(0L, now$1 - BoxesRunTime.unboxToLong((Object)startTimestamps.min((Ordering)Ordering.Long$.MODULE$)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$2(scala.Tuple2 ), $anonfun$value$3$adapted(scala.Tuple2 ), $anonfun$value$4$adapted(scala.Tuple2 )}, serializedLambda);
            }
        });
        this.transactionTimeoutSensor = metrics.sensor(TransactionStateManager$.MODULE$.TimeoutSensor());
        this.timeoutRateMetricName = metrics.metricName("transaction-timeout-rate", TransactionStateManager$.MODULE$.MetricsGroup(), "The rate at which transactions are timed out by the coordinator");
        this.timeoutCountMetricName = metrics.metricName("transaction-timeout-count", TransactionStateManager$.MODULE$.MetricsGroup(), "The total count of transactions timed out by the coordinator");
        Sensor sensor3 = this.transactionTimeoutSensor();
        Meter meter = new Meter(this.timeoutRateMetricName(), this.timeoutCountMetricName());
        if (sensor3 == null) {
            throw null;
        }
        sensor3.add((CompoundStat)add_stat2, null);
        meter = null;
        this.stateErrorSensor = metrics.sensor(TransactionStateManager$.MODULE$.StateErrorSensor());
        this.stateErrorRateMetricName = metrics.metricName("transaction-state-error-rate", TransactionStateManager$.MODULE$.MetricsGroup(), "The rate at which state errors occur within the transaction coordinator");
        this.stateErrorCountMetricName = metrics.metricName("transaction-state-error-count", TransactionStateManager$.MODULE$.MetricsGroup(), "The total count of state errors that have occurred within the transaction coordinator");
        Sensor sensor4 = this.stateErrorSensor();
        Meter meter2 = new Meter(this.stateErrorRateMetricName(), this.stateErrorCountMetricName());
        if (sensor4 == null) {
            throw null;
        }
        sensor4.add((CompoundStat)add_stat, null);
    }
}

