/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.events;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.DurabilityEventType$;
import kafka.durability.events.HealthCheckEvent$;
import kafka.durability.events.serdes.BaseInfo;
import kafka.durability.events.serdes.HealthCheck;
import org.apache.kafka.common.TopicPartition;
import scala.Enumeration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005b\u0001\u0002\u000b\u0016\u0001qA\u0011\"\t\u0001\u0003\u0002\u0003\u0006IAI\u0017\t\u00139\u0002!\u0011!Q\u0001\n=*\u0004\"\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u00188\u0011!A\u0004A!A!\u0002\u0013I\u0004\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011u\u0002!Q1A\u0005\u0002yB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\t\u0001\u0002\u0011)\u0019!C\u0001\u0003\"A!\t\u0001B\u0001B\u0003%\u0011\bC\u0003D\u0001\u0011\u0005A\tC\u0003N\u0001\u0011%a\nC\u0003X\u0001\u0011\u0005\u0003\fC\u0003Z\u0001\u0011\u0005#\fC\u0003l\u0001\u0011\u0005CnB\u0003v+!\u0005aOB\u0003\u0015+!\u0005q\u000fC\u0003D!\u0011\u00051\u0010C\u0003}!\u0011\u0005Q\u0010\u0003\u0004}!\u0011\u0005\u0011Q\u0002\u0002\u0011\u0011\u0016\fG\u000e\u001e5DQ\u0016\u001c7.\u0012<f]RT!AF\f\u0002\r\u00154XM\u001c;t\u0015\tA\u0012$\u0001\u0006ekJ\f'-\u001b7jifT\u0011AG\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001f?5\tQ#\u0003\u0002!+\t9\u0012IY:ue\u0006\u001cG\u000fR;sC\nLG.\u001b;z\u000bZ,g\u000e^\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\t\u00193&D\u0001%\u0015\t)c%\u0001\u0004d_6lwN\u001c\u0006\u00035\u001dR!\u0001K\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0013aA8sO&\u0011A\u0006\n\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0013\t\ts$A\u0004wKJ\u001c\u0018n\u001c8\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\u0007%sG/\u0003\u0002/?\u0005)Q\r]8dQ&\u0011agH\u0001\u000eQ&<\u0007nV1uKJl\u0017M]6\u0011\u0005AR\u0014BA\u001e2\u0005\u0011auN\\4\u0002\u001d1|wm\u0015;beR|eMZ:fi\u0006A!M]8lKJLE-F\u00010\u0003%\u0011'o\\6fe&#\u0007%A\u0005uS6,7\u000b^1naV\t\u0011(\u0001\u0006uS6,7\u000b^1na\u0002\na\u0001P5oSRtD\u0003C#G\u000f\"K%j\u0013'\u0011\u0005y\u0001\u0001\"B\u0011\u000b\u0001\u0004\u0011\u0003\"\u0002\u0018\u000b\u0001\u0004y\u0003\"\u0002\u001c\u000b\u0001\u0004y\u0003\"\u0002\u001d\u000b\u0001\u0004I\u0004\"\u0002\u001f\u000b\u0001\u0004I\u0004\"B\u001f\u000b\u0001\u0004y\u0003\"\u0002!\u000b\u0001\u0004I\u0014!C:fe&\fG.\u001b>f)\u0005y\u0005C\u0001)V\u001b\u0005\t&B\u0001*T\u0003\rq\u0017n\u001c\u0006\u0002)\u0006!!.\u0019<b\u0013\t1\u0016K\u0001\u0006CsR,')\u001e4gKJ\fQ\u0002]1zY>\fGMQ;gM\u0016\u0014X#A(\u0002\u0013\u00154XM\u001c;UsB,W#A.\u0011\u0005qCgBA/g\u001d\tqVM\u0004\u0002`I:\u0011\u0001mY\u0007\u0002C*\u0011!mG\u0001\u0007yI|w\u000e\u001e \n\u0003iI!\u0001G\r\n\u0005Y9\u0012BA4\u0016\u0003M!UO]1cS2LG/_#wK:$H+\u001f9f\u0013\tI'NA\nEkJ\f'-\u001b7jif,e/\u001a8u)f\u0004XM\u0003\u0002h+\u0005AAo\\*ue&tw\rF\u0001n!\tq'O\u0004\u0002paB\u0011\u0001-M\u0005\u0003cF\na\u0001\u0015:fI\u00164\u0017BA:u\u0005\u0019\u0019FO]5oO*\u0011\u0011/M\u0001\u0011\u0011\u0016\fG\u000e\u001e5DQ\u0016\u001c7.\u0012<f]R\u0004\"A\b\t\u0014\u0005AA\bC\u0001\u0019z\u0013\tQ\u0018G\u0001\u0004B]f\u0014VM\u001a\u000b\u0002m\u0006)\u0011\r\u001d9msRqQI`A\u0001\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0001\"B@\u0013\u0001\u0004\u0011\u0013AA5e\u0011\u0015q#\u00031\u00010\u0011\u00151$\u00031\u00010\u0011\u0015A$\u00031\u0001:\u0011\u0015a$\u00031\u0001:\u0011\u0015i$\u00031\u00010\u0011\u0015\u0001%\u00031\u0001:)\u0015)\u0015qBA\t\u0011\u0015y8\u00031\u0001#\u0011\u001d\t\u0019b\u0005a\u0001\u0003+\tA\u0001Z1uCB!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001cU\taa]3sI\u0016\u001c\u0018\u0002BA\u0010\u00033\u00111\u0002S3bYRD7\t[3dW\u0002")
public class HealthCheckEvent
extends AbstractDurabilityEvent {
    private final long highWatermark;
    private final long logStartOffset;
    private final int brokerId;
    private final long timeStamp;

    public static HealthCheckEvent apply(TopicPartition id, HealthCheck data) {
        return HealthCheckEvent$.MODULE$.apply(id, data);
    }

    public static HealthCheckEvent apply(TopicPartition id, int version, int epoch, long highWatermark, long logStartOffset, int brokerId, long timeStamp) {
        return new HealthCheckEvent(id, version, epoch, highWatermark, logStartOffset, brokerId, timeStamp);
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long timeStamp() {
        return this.timeStamp;
    }

    private ByteBuffer serialize() {
        FlatBufferBuilder builder = new FlatBufferBuilder(this.KEY_INITIAL_LENGTH()).forceDefaults(true);
        HealthCheck.startHealthCheck(builder);
        HealthCheck.addBrokerId(builder, this.brokerId());
        HealthCheck.addTimeStamp(builder, this.timeStamp());
        int info = BaseInfo.createBaseInfo(builder, super.version(), super.epoch(), this.highWatermark, this.logStartOffset);
        HealthCheck.addInfo(builder, info);
        int entryId = HealthCheck.endHealthCheck(builder);
        builder.finish(entryId);
        return HealthCheck.getRootAsHealthCheck(builder.dataBuffer()).getByteBuffer().duplicate();
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.serialize();
    }

    @Override
    public Enumeration.Value eventType() {
        return DurabilityEventType$.MODULE$.HealthCheckType();
    }

    public String toString() {
        return new StringBuilder(0).append(new StringBuilder(55).append("[TopicPartition: ").append(super.topicPartition()).append(", version: ").append(super.version()).append(", epoch: ").append(super.epoch()).append(", highWatermark: ").append(this.highWatermark).append(",").toString()).append(new StringBuilder(30).append(" logStartOffset: ").append(this.logStartOffset).append(", brokerId: ").append(this.brokerId()).append("]").toString()).toString();
    }

    public HealthCheckEvent(TopicPartition topicPartition, int version, int epoch, long highWatermark, long logStartOffset, int brokerId, long timeStamp) {
        this.highWatermark = highWatermark;
        this.logStartOffset = logStartOffset;
        this.brokerId = brokerId;
        this.timeStamp = timeStamp;
        super(topicPartition, epoch, version);
    }
}

