/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.events;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.DurabilityEventType$;
import kafka.durability.events.OffsetChangeEvent$;
import kafka.durability.events.serdes.BaseInfo;
import kafka.durability.events.serdes.OffsetChange;
import org.apache.kafka.common.TopicPartition;
import scala.Enumeration;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ub\u0001\u0002\f\u0018\u0001yA\u0011b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0018\t\u0013A\u0002!\u0011!Q\u0001\nE:\u0004\"\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u0019:\u0011!Q\u0004A!b\u0001\n\u0003Y\u0004\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u0011\u0001\u0003!Q1A\u0005\u0002mB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0005\u0002\u0011)\u0019!C\u0001\u0007\"Aq\n\u0001B\u0001B\u0003%A\tC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003Z\u0001\u0011%!\f\u0003\u0005d\u0001!\u0015\r\u0011\"\u0011e\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015!\b\u0001\"\u0011v\u000f\u0015Ix\u0003#\u0001{\r\u00151r\u0003#\u0001|\u0011\u0015\u0001\u0006\u0003\"\u0001\u0000\u0011\u001d\t\t\u0001\u0005C\u0001\u0003\u0007Aq!!\u0001\u0011\t\u0003\t\u0019\u0002C\u0004\u0002\u0002A!\t!!\b\t\u000f\u0005\u0005\u0001\u0003\"\u0001\u0002*\t\trJ\u001a4tKR\u001c\u0005.\u00198hK\u00163XM\u001c;\u000b\u0005aI\u0012AB3wK:$8O\u0003\u0002\u001b7\u0005QA-\u001e:bE&d\u0017\u000e^=\u000b\u0003q\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001?A\u0011\u0001%I\u0007\u0002/%\u0011!e\u0006\u0002\u0018\u0003\n\u001cHO]1di\u0012+(/\u00192jY&$\u00180\u0012<f]R\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002&[5\taE\u0003\u0002(Q\u000511m\\7n_:T!\u0001H\u0015\u000b\u0005)Z\u0013AB1qC\u000eDWMC\u0001-\u0003\ry'oZ\u0005\u0003]\u0019\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0003\u0002$C\u00059a/\u001a:tS>t\u0007C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$aA%oi&\u0011\u0001'I\u0001\u0006KB|7\r[\u0005\u0003q\u0005\nQ\u0002[5hQ^\u000bG/\u001a:nCJ\\W#\u0001\u001f\u0011\u0005Ij\u0014B\u0001 4\u0005\u0011auN\\4\u0002\u001d!Lw\r[,bi\u0016\u0014X.\u0019:lA\u0005qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$\u0018a\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0011\u0002\u0007%\u001c(/F\u0001E!\r)E*\r\b\u0003\r*\u0003\"aR\u001a\u000e\u0003!S!!S\u000f\u0002\rq\u0012xn\u001c;?\u0013\tY5'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001b:\u00131aU3u\u0015\tY5'\u0001\u0003jgJ\u0004\u0013A\u0002\u001fj]&$h\bF\u0004S'R+fk\u0016-\u0011\u0005\u0001\u0002\u0001\"B\u0012\u000b\u0001\u0004!\u0003\"\u0002\u0019\u000b\u0001\u0004\t\u0004\"\u0002\u001d\u000b\u0001\u0004\t\u0004\"\u0002\u001e\u000b\u0001\u0004a\u0004\"\u0002!\u000b\u0001\u0004a\u0004\"\u0002\"\u000b\u0001\u0004!\u0015!C:fe&\fG.\u001b>f)\u0005Y\u0006C\u0001/b\u001b\u0005i&B\u00010`\u0003\rq\u0017n\u001c\u0006\u0002A\u0006!!.\u0019<b\u0013\t\u0011WL\u0001\u0006CsR,')\u001e4gKJ\fQ\u0002]1zY>\fGMQ;gM\u0016\u0014X#A.\u0002\u0013\u00154XM\u001c;UsB,W#A4\u0011\u0005!\fhBA5p\u001d\tQgN\u0004\u0002l[:\u0011q\t\\\u0005\u00029%\u0011!dG\u0005\u00031eI!\u0001]\f\u0002'\u0011+(/\u00192jY&$\u00180\u0012<f]R$\u0016\u0010]3\n\u0005I\u001c(a\u0005#ve\u0006\u0014\u0017\u000e\\5us\u00163XM\u001c;UsB,'B\u00019\u0018\u0003!!xn\u0015;sS:<G#\u0001<\u0011\u0005\u0015;\u0018B\u0001=O\u0005\u0019\u0019FO]5oO\u0006\trJ\u001a4tKR\u001c\u0005.\u00198hK\u00163XM\u001c;\u0011\u0005\u0001\u00022C\u0001\t}!\t\u0011T0\u0003\u0002\u007fg\t1\u0011I\\=SK\u001a$\u0012A_\u0001\u0006CB\u0004H.\u001f\u000b\u000e%\u0006\u0015\u0011\u0011BA\u0006\u0003\u001b\ty!!\u0005\t\r\u0005\u001d!\u00031\u0001%\u0003\tIG\rC\u00031%\u0001\u0007\u0011\u0007C\u00039%\u0001\u0007\u0011\u0007C\u0003;%\u0001\u0007A\bC\u0003A%\u0001\u0007A\bC\u0003C%\u0001\u0007A\tF\u0005S\u0003+\t9\"!\u0007\u0002\u001c!1\u0011qA\nA\u0002\u0011BQ\u0001O\nA\u0002EBQAO\nA\u0002qBQ\u0001Q\nA\u0002q\"2BUA\u0010\u0003C\t\u0019#!\n\u0002(!1\u0011q\u0001\u000bA\u0002\u0011BQ\u0001\u000f\u000bA\u0002EBQA\u000f\u000bA\u0002qBQ\u0001\u0011\u000bA\u0002qBQA\u0011\u000bA\u0002\u0011#RAUA\u0016\u0003[Aa!a\u0002\u0016\u0001\u0004!\u0003bBA\u0018+\u0001\u0007\u0011\u0011G\u0001\u0005I\u0006$\u0018\r\u0005\u0003\u00024\u0005eRBAA\u001b\u0015\r\t9dF\u0001\u0007g\u0016\u0014H-Z:\n\t\u0005m\u0012Q\u0007\u0002\r\u001f\u001a47/\u001a;DQ\u0006tw-\u001a")
public class OffsetChangeEvent
extends AbstractDurabilityEvent {
    private ByteBuffer payloadBuffer;
    private final long highWatermark;
    private final long logStartOffset;
    private final Set<Object> isr;
    private volatile boolean bitmap$0;

    public static OffsetChangeEvent apply(TopicPartition id, OffsetChange data) {
        return OffsetChangeEvent$.MODULE$.apply(id, data);
    }

    public static OffsetChangeEvent apply(TopicPartition id, int epoch, long highWatermark, long logStartOffset, Set<Object> isr) {
        return OffsetChangeEvent$.MODULE$.apply(id, epoch, highWatermark, logStartOffset, isr);
    }

    public static OffsetChangeEvent apply(TopicPartition id, int epoch, long highWatermark, long logStartOffset) {
        return OffsetChangeEvent$.MODULE$.apply(id, epoch, highWatermark, logStartOffset);
    }

    public static OffsetChangeEvent apply(TopicPartition id, int version, int epoch, long highWatermark, long logStartOffset, Set<Object> isr) {
        return new OffsetChangeEvent(id, version, epoch, highWatermark, logStartOffset, isr);
    }

    public long highWatermark() {
        return this.highWatermark;
    }

    public long logStartOffset() {
        return this.logStartOffset;
    }

    public Set<Object> isr() {
        return this.isr;
    }

    private ByteBuffer serialize() {
        FlatBufferBuilder builder = new FlatBufferBuilder(this.KEY_INITIAL_LENGTH()).forceDefaults(true);
        int isrSerialized = OffsetChange.createIsrVector(builder, (int[])this.isr().toArray((ClassTag)ClassTag$.MODULE$.Int()));
        OffsetChange.startOffsetChange(builder);
        int infoOffset = BaseInfo.createBaseInfo(builder, super.version(), super.epoch(), this.highWatermark(), this.logStartOffset());
        OffsetChange.addInfo(builder, infoOffset);
        OffsetChange.addIsr(builder, isrSerialized);
        int entryId = OffsetChange.endOffsetChange(builder);
        builder.finish(entryId);
        return OffsetChange.getRootAsOffsetChange(builder.dataBuffer()).getByteBuffer().duplicate();
    }

    private ByteBuffer payloadBuffer$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.payloadBuffer = this.serialize();
                this.bitmap$0 = true;
            }
        }
        return this.payloadBuffer;
    }

    @Override
    public ByteBuffer payloadBuffer() {
        if (!this.bitmap$0) {
            return this.payloadBuffer$lzycompute();
        }
        return this.payloadBuffer;
    }

    @Override
    public Enumeration.Value eventType() {
        return DurabilityEventType$.MODULE$.OffsetChangeType();
    }

    public String toString() {
        return new StringBuilder(0).append(new StringBuilder(55).append("[TopicPartition: ").append(super.topicPartition()).append(", version: ").append(super.version()).append(", epoch: ").append(super.epoch()).append(", highWatermark: ").append(this.highWatermark()).append(",").toString()).append(new StringBuilder(25).append(" logStartOffset: ").append(this.logStartOffset()).append(", isr: ").append(this.isr()).append("]").toString()).toString();
    }

    public OffsetChangeEvent(TopicPartition topicPartition, int version, int epoch, long highWatermark, long logStartOffset, Set<Object> isr) {
        this.highWatermark = highWatermark;
        this.logStartOffset = logStartOffset;
        this.isr = isr;
        super(topicPartition, epoch, version);
    }
}

