/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import kafka.log.LogSegment;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005=f\u0001\u0002\u0011\"\u0001\u0019B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\u0006s\u0001!\tA\u000f\u0005\b}\u0001\u0011\r\u0011\"\u0003@\u0011\u0019\u0001\u0006\u0001)A\u0005\u0001\")\u0011\u000b\u0001C\u0001%\")Q\f\u0001C\u0001%\")q\f\u0001C\u0001A\")A\r\u0001C\u0001K\")A\u000e\u0001C\u0001[\")q\u000e\u0001C\u0001[\")\u0001\u000f\u0001C\u0001[\")\u0011\u000f\u0001C\u0001e\")1\u0010\u0001C\u0001y\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\u0010\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u000e\u0001\t\u0003\tY\u0004C\u0004\u0002F\u0001!\t!a\u0012\t\u000f\u0005-\u0003\u0001\"\u0003\u0002N!9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0004bBA7\u0001\u0011%\u0011q\u000e\u0005\b\u0003k\u0002A\u0011AA<\u0011\u001d\ti\b\u0001C\u0001\u0003\u007fBq!!\"\u0001\t\u0003\t9\tC\u0004\u0002\u000e\u0002!\t!a$\t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005m\u0005bBAP\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003G\u0003A\u0011AAN\u0011\u001d\t9\u000b\u0001C\u0001\u0003S\u00131\u0002T8h'\u0016<W.\u001a8ug*\u0011!eI\u0001\u0004Y><'\"\u0001\u0013\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\n\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B\u0011qfN\u0007\u0002a)\u0011\u0011GM\u0001\u0007G>lWn\u001c8\u000b\u0005\u0011\u001a$B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001eL!\u0001\u000f\u0019\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u00061A(\u001b8jiz\"\"aO\u001f\u0011\u0005q\u0002Q\"A\u0011\t\u000b5\u0012\u0001\u0019\u0001\u0018\u0002\u0011M,w-\\3oiN,\u0012\u0001\u0011\t\u0005\u0003\"SU*D\u0001C\u0015\t\u0019E)\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u0012$\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u000f\u0006!!.\u0019<b\u0013\tI%I\u0001\fD_:\u001cWO\u001d:f]Rt\u0015M^5hC\ndW-T1q!\tA3*\u0003\u0002MS\t!Aj\u001c8h!\tad*\u0003\u0002PC\tQAj\\4TK\u001elWM\u001c;\u0002\u0013M,w-\\3oiN\u0004\u0013aB5t\u000b6\u0004H/_\u000b\u0002'B\u0011\u0001\u0006V\u0005\u0003+&\u0012qAQ8pY\u0016\fg\u000e\u000b\u0002\u0006/B\u0011\u0001lW\u0007\u00023*\u0011!lI\u0001\u0006kRLGn]\u0005\u00039f\u0013!\u0002\u001e5sK\u0006$7/\u00194f\u0003!qwN\\#naRL\bF\u0001\u0004X\u0003\r\tG\r\u001a\u000b\u0003\u001b\u0006DQAY\u0004A\u00025\u000bqa]3h[\u0016tG\u000f\u000b\u0002\b/\u00061!/Z7pm\u0016$\"AZ5\u0011\u0005!:\u0017B\u00015*\u0005\u0011)f.\u001b;\t\u000b)D\u0001\u0019\u0001&\u0002\r=4gm]3uQ\tAq+A\u0003dY\u0016\f'\u000fF\u0001gQ\tIq+A\u0003dY>\u001cX-A\u0007dY>\u001cX\rS1oI2,'o]\u0001\u0010kB$\u0017\r^3QCJ,g\u000e\u001e#jeR\u0011am\u001d\u0005\u0006i2\u0001\r!^\u0001\u0004I&\u0014\bC\u0001<z\u001b\u00059(B\u0001=G\u0003\tIw.\u0003\u0002{o\n!a)\u001b7f\u0003AqW/\u001c2fe>37+Z4nK:$8/F\u0001~!\tAc0\u0003\u0002\u0000S\t\u0019\u0011J\u001c;)\u000559\u0016a\u00032bg\u0016|eMZ:fiN,\"!a\u0002\u0011\u000b\u0005%\u0011\u0011\u0004&\u000f\t\u0005-\u0011Q\u0003\b\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011C\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0013bAA\fS\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u000e\u0003;\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003/I\u0013\u0001C2p]R\f\u0017N\\:\u0015\u0007M\u000b\u0019\u0003C\u0003k\u001f\u0001\u0007!\n\u000b\u0002\u0010/\u0006\u0019q-\u001a;\u0015\t\u0005-\u0012\u0011\u0007\t\u0005Q\u00055R*C\u0002\u00020%\u0012aa\u00149uS>t\u0007\"\u00026\u0011\u0001\u0004Q\u0005F\u0001\tX\u0003\u00191\u0018\r\\;fgV\u0011\u0011\u0011\b\t\u0006\u0003\u0013\tI\"\u0014\u000b\u0007\u0003s\ti$!\u0011\t\r\u0005}\"\u00031\u0001K\u0003\u00111'o\\7\t\r\u0005\r#\u00031\u0001K\u0003\t!x.\u0001\ro_:\f5\r^5wK2{wmU3h[\u0016tGo\u001d$s_6$B!!\u000f\u0002J!1\u0011qH\nA\u0002)\u000b!B\u001a7p_J,e\u000e\u001e:z)\u0011\ty%!\u0019\u0011\u000b!\ni#!\u0015\u0011\r\u0005M\u00131\f&N\u001d\u0011\t)&a\u0016\u000e\u0003\u0011K1!!\u0017E\u0003\ri\u0015\r]\u0005\u0005\u0003;\nyFA\u0003F]R\u0014\u0018PC\u0002\u0002Z\u0011CQA\u001b\u000bA\u0002)C#\u0001F,\u0002\u0019\u0019dwn\u001c:TK\u001elWM\u001c;\u0015\t\u0005-\u0012\u0011\u000e\u0005\u0006UV\u0001\rA\u0013\u0015\u0003+]\u000b!\u0002\\8xKJ,e\u000e\u001e:z)\u0011\ty%!\u001d\t\u000b)4\u0002\u0019\u0001&)\u0005Y9\u0016\u0001\u00047po\u0016\u00148+Z4nK:$H\u0003BA\u0016\u0003sBQA[\fA\u0002)C#aF,\u0002\u0017!Lw\r[3s\u000b:$(/\u001f\u000b\u0005\u0003\u001f\n\t\tC\u0003k1\u0001\u0007!\n\u000b\u0002\u0019/\u0006i\u0001.[4iKJ\u001cVmZ7f]R$B!a\u000b\u0002\n\")!.\u0007a\u0001\u0015\"\u0012\u0011dV\u0001\u000f]\u0016DH\u000fT8h'\u0016<W.\u001a8u)\u0011\tY#!%\t\u000b\tT\u0002\u0019A'\u0002\u0015\u0019L'o\u001d;F]R\u0014\u00180\u0006\u0002\u0002P!\u00121dV\u0001\rM&\u00148\u000f^*fO6,g\u000e^\u000b\u0003\u0003WA#\u0001H,\u0002\u00131\f7\u000f^#oiJL\bFA\u000fX\u0003-a\u0017m\u001d;TK\u001elWM\u001c;)\u0005y9\u0016A\u00045jO\",'oU3h[\u0016tGo\u001d\u000b\u0005\u0003s\tY\u000b\u0003\u0004\u0002.~\u0001\rAS\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$\b")
public class LogSegments {
    private final TopicPartition topicPartition;
    private final ConcurrentNavigableMap<Object, LogSegment> segments;

    private ConcurrentNavigableMap<Object, LogSegment> segments() {
        return this.segments;
    }

    public boolean isEmpty() {
        return this.segments().isEmpty();
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public LogSegment add(LogSegment segment) {
        return this.segments().put(BoxesRunTime.boxToLong((long)segment.baseOffset()), segment);
    }

    public void remove(long offset) {
        this.segments().remove(BoxesRunTime.boxToLong((long)offset));
    }

    public void clear() {
        this.segments().clear();
    }

    public void close() {
        this.values().foreach((Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
    }

    public void closeHandlers() {
        this.values().foreach((Function1 & Serializable)x$2 -> {
            x$2.closeHandlers();
            return BoxedUnit.UNIT;
        });
    }

    public void updateParentDir(File dir) {
        this.values().foreach((Function1 & Serializable)x$3 -> {
            x$3.updateParentDir(dir);
            return BoxedUnit.UNIT;
        });
    }

    public int numberOfSegments() {
        return this.segments().size();
    }

    public Iterable<Object> baseOffsets() {
        return (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(this.segments().values()).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.baseOffset()));
    }

    public boolean contains(long offset) {
        return this.segments().containsKey(BoxesRunTime.boxToLong((long)offset));
    }

    public Option<LogSegment> get(long offset) {
        return Option$.MODULE$.apply(this.segments().get(BoxesRunTime.boxToLong((long)offset)));
    }

    public Iterable<LogSegment> values() {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(this.segments().values()).asScala();
    }

    public Iterable<LogSegment> values(long from, long to) {
        if (from == to) {
            return package$.MODULE$.List().empty();
        }
        if (to < from) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(50).append("Invalid log segment range: requested segments in ").append(this.topicPartition).append(" ").toString()).append(new StringBuilder(48).append("from offset ").append(from).append(" which is greater than limit offset ").append(to).toString()).toString());
        }
        ConcurrentNavigableMap view = (ConcurrentNavigableMap)Option$.MODULE$.apply(this.segments().floorKey(BoxesRunTime.boxToLong((long)from))).map((Function1 & Serializable)floor -> LogSegments.$anonfun$values$1(this, to, BoxesRunTime.unboxToLong((Object)floor))).getOrElse((Function0 & Serializable)() -> this.segments().headMap((Object)BoxesRunTime.boxToLong((long)to)));
        return CollectionConverters$.MODULE$.CollectionHasAsScala(view.values()).asScala();
    }

    public Iterable<LogSegment> nonActiveLogSegmentsFrom(long from) {
        LogSegment activeSegment = (LogSegment)this.lastSegment().get();
        if (from > activeSegment.baseOffset()) {
            return (Iterable)package$.MODULE$.Seq().empty();
        }
        return this.values(from, activeSegment.baseOffset());
    }

    private Option<Map.Entry<Object, LogSegment>> floorEntry(long offset) {
        return Option$.MODULE$.apply(this.segments().floorEntry(BoxesRunTime.boxToLong((long)offset)));
    }

    public Option<LogSegment> floorSegment(long offset) {
        return this.floorEntry(offset).map((Function1 & Serializable)x$5 -> (LogSegment)x$5.getValue());
    }

    private Option<Map.Entry<Object, LogSegment>> lowerEntry(long offset) {
        return Option$.MODULE$.apply(this.segments().lowerEntry(BoxesRunTime.boxToLong((long)offset)));
    }

    public Option<LogSegment> lowerSegment(long offset) {
        return this.lowerEntry(offset).map((Function1 & Serializable)x$6 -> (LogSegment)x$6.getValue());
    }

    public Option<Map.Entry<Object, LogSegment>> higherEntry(long offset) {
        return Option$.MODULE$.apply(this.segments().higherEntry(BoxesRunTime.boxToLong((long)offset)));
    }

    public Option<LogSegment> higherSegment(long offset) {
        return this.higherEntry(offset).map((Function1 & Serializable)x$7 -> (LogSegment)x$7.getValue());
    }

    public Option<LogSegment> nextLogSegment(LogSegment segment) {
        return this.higherSegment(segment.baseOffset());
    }

    public Option<Map.Entry<Object, LogSegment>> firstEntry() {
        return Option$.MODULE$.apply(this.segments().firstEntry());
    }

    public Option<LogSegment> firstSegment() {
        return this.firstEntry().map((Function1 & Serializable)x$8 -> (LogSegment)x$8.getValue());
    }

    public Option<Map.Entry<Object, LogSegment>> lastEntry() {
        return Option$.MODULE$.apply(this.segments().lastEntry());
    }

    public Option<LogSegment> lastSegment() {
        return this.lastEntry().map((Function1 & Serializable)x$9 -> (LogSegment)x$9.getValue());
    }

    public Iterable<LogSegment> higherSegments(long baseOffset) {
        java.util.Map view = (java.util.Map)Option$.MODULE$.apply(this.segments().higherKey(BoxesRunTime.boxToLong((long)baseOffset))).map((Function1 & Serializable)higherOffset -> LogSegments.$anonfun$higherSegments$1(this, BoxesRunTime.unboxToLong((Object)higherOffset))).getOrElse((Function0 & Serializable)() -> CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).asJava());
        return CollectionConverters$.MODULE$.CollectionHasAsScala(view.values()).asScala();
    }

    public static final /* synthetic */ ConcurrentNavigableMap $anonfun$values$1(LogSegments $this, long to$1, long floor) {
        return $this.segments().subMap((Object)BoxesRunTime.boxToLong((long)floor), (Object)BoxesRunTime.boxToLong((long)to$1));
    }

    public static final /* synthetic */ ConcurrentNavigableMap $anonfun$higherSegments$1(LogSegments $this, long higherOffset) {
        return $this.segments().tailMap((Object)BoxesRunTime.boxToLong((long)higherOffset), true);
    }

    public LogSegments(TopicPartition topicPartition) {
        this.topicPartition = topicPartition;
        this.segments = new ConcurrentSkipListMap<Object, LogSegment>();
    }
}

