/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Histogram;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import kafka.log.LoadLogParams;
import kafka.log.LoadedLogOffsets;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogLoader$;
import kafka.log.LogOffsetsListener;
import kafka.log.LogSegments;
import kafka.log.MergedLog;
import kafka.log.NoOpLogOffsetsListener$;
import kafka.log.ProducerStateManager;
import kafka.log.TierLogComponents;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.topic.TierTopicAdmin$;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class MergedLog$ {
    public static final MergedLog$ MODULE$ = new MergedLog$();

    public MergedLog apply(File dir, LogConfig config, LogSegments segments, long logStartOffset, long recoveryPoint, Scheduler scheduler, BrokerTopicStats brokerTopicStats, Metrics metrics, Time time, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, TopicPartition topicPartition, Option<LeaderEpochFileCache> leaderEpochCache, ProducerStateManager producerStateManager, LogDirFailureChannel logDirFailureChannel, TierLogComponents tierLogComponents, boolean hadCleanShutdown, Option<Uuid> topicId, boolean keepPartitionMetadataFile, LogOffsetsListener logOffsetsListener, Option<Histogram> messageBatchSizeHistogram) {
        TierPartitionState tierPartitionState = this.initTierPartitionState(dir, topicPartition, tierLogComponents.partitionStateFactory(), config, logDirFailureChannel, scheduler);
        LoadedLogOffsets offsets = LogLoader$.MODULE$.load(new LoadLogParams(dir, topicPartition, config, scheduler, time, logDirFailureChannel, hadCleanShutdown, segments, logStartOffset, recoveryPoint, maxProducerIdExpirationMs, leaderEpochCache, producerStateManager));
        long x$4 = offsets.recoveryPoint();
        LogOffsetMetadata x$5 = offsets.nextOffsetMetadata();
        JFunction0.mcJ.sp & Serializable x$152 = (JFunction0.mcJ.sp & Serializable)() -> logStartOffset;
        JFunction1.mcVJ.sp & Serializable x$16 = (JFunction1.mcVJ.sp & Serializable)x$15 -> {};
        Log localLog = new Log(dir, config, segments, x$4, x$5, scheduler, brokerTopicStats, metrics, time, producerIdExpirationCheckIntervalMs, topicPartition, leaderEpochCache, producerStateManager, logDirFailureChannel, logOffsetsListener, (Function1<Object, BoxedUnit>)x$16, (Function0<Object>)x$152, topicId, keepPartitionMetadataFile, messageBatchSizeHistogram);
        return new MergedLog(localLog, logStartOffset, hadCleanShutdown, tierPartitionState, tierLogComponents);
    }

    public MergedLog apply(File dir, LogConfig config, long logStartOffset, long recoveryPoint, Scheduler scheduler, BrokerTopicStats brokerTopicStats, Metrics metrics, Time time, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, LogDirFailureChannel logDirFailureChannel, TierLogComponents tierLogComponents, boolean lastShutdownClean, Option<Uuid> topicId, boolean keepPartitionMetadataFile, LogOffsetsListener logOffsetsListener, Option<Histogram> messageBatchSizeHistogram) {
        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        TopicPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(dir);
        LogSegments segments = new LogSegments(topicPartition);
        Option<LeaderEpochFileCache> leaderEpochCache = Log$.MODULE$.maybeCreateLeaderEpochCache(dir, topicPartition, logDirFailureChannel, config.messageFormatVersion().recordVersion(), new StringBuilder(29).append("[MergedLog partition=").append(topicPartition).append(", dir=").append(dir.getParent()).append("] ").toString());
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, dir, maxProducerIdExpirationMs, Time.SYSTEM);
        return this.apply(dir, config, segments, logStartOffset, recoveryPoint, scheduler, brokerTopicStats, metrics, time, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, topicPartition, leaderEpochCache, producerStateManager, logDirFailureChannel, tierLogComponents, lastShutdownClean, topicId, keepPartitionMetadataFile, logOffsetsListener, messageBatchSizeHistogram);
    }

    public Time apply$default$8() {
        return Time.SYSTEM;
    }

    public LogOffsetsListener apply$default$16() {
        return NoOpLogOffsetsListener$.MODULE$;
    }

    private TierPartitionState initTierPartitionState(File dir, TopicPartition topicPartition, TierPartitionStateFactory tierPartitionStateFactory, LogConfig config, LogDirFailureChannel logDirFailureChannel, Scheduler scheduler) {
        return tierPartitionStateFactory.initState(dir, topicPartition, config, logDirFailureChannel, scheduler);
    }

    public long kafka$log$MergedLog$$firstUntieredOffset(TierPartitionState tierPartitionState) {
        return tierPartitionState.endOffset() + 1L;
    }

    public boolean kafka$log$MergedLog$$isConfigValid(TopicPartition topicPartition, LogConfig config) {
        if (topicPartition.topic().startsWith("_confluent-tier-state")) {
            return TierTopicAdmin$.MODULE$.isConfigValid(config, topicPartition.topic());
        }
        return true;
    }

    private MergedLog$() {
    }
}

