/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.ActiveTenantsManager;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.BrokerBackpressureMetrics$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientRequestQuotaManager$;
import kafka.server.ExemptRequest$;
import kafka.server.NonExemptRequest$;
import kafka.server.QueueSizePercentiles;
import kafka.server.QuotaType$Request$;
import kafka.server.RequestQueueSizePercentiles$;
import kafka.server.RequestThrottleType;
import kafka.server.ThreadUsageMetrics$;
import kafka.server.ThreadUsageSensors;
import kafka.utils.QuotaUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u0015s!\u0002\u00192\u0011\u00031d!\u0002\u001d2\u0011\u0003I\u0004\"\u0002!\u0002\t\u0003\t\u0005b\u0002\"\u0002\u0005\u0004%\ta\u0011\u0005\u0007\u000f\u0006\u0001\u000b\u0011\u0002#\t\u000f!\u000b!\u0019!C\u0001\u0007\"1\u0011*\u0001Q\u0001\n\u0011CqAS\u0001C\u0002\u0013%1\n\u0003\u0004U\u0003\u0001\u0006I\u0001\u0014\u0004\u0005qE\u0002Q\u000b\u0003\u0005Z\u0013\t\u0015\r\u0011\"\u0003[\u0011!q\u0016B!A!\u0002\u0013Y\u0006\u0002C0\n\u0005\u000b\u0007I\u0011\u00021\t\u00115L!\u0011!Q\u0001\n\u0005D\u0011B\\\u0005\u0003\u0002\u0003\u0006Ia\\;\t\u0011YL!Q1A\u0005\n]D\u0011\"!\u0002\n\u0005\u0003\u0005\u000b\u0011\u0002=\t\u0015\u0005\u001d\u0011B!b\u0001\n\u0013\tI\u0001\u0003\u0006\u0002 %\u0011\t\u0011)A\u0005\u0003\u0017A!\"!\t\n\u0005\u0003\u0005\u000b\u0011BA\u0012\u0011\u0019\u0001\u0015\u0002\"\u0001\u0002,!I\u00111H\u0005C\u0002\u0013%\u0011Q\b\u0005\t\u0003\u000bJ\u0001\u0015!\u0003\u0002@!A\u0011qI\u0005A\u0002\u0013%1\tC\u0005\u0002J%\u0001\r\u0011\"\u0003\u0002L!9\u0011qK\u0005!B\u0013!\u0005\"CA-\u0013\t\u0007I\u0011BA.\u0011!\t\u0019'\u0003Q\u0001\n\u0005u\u0003\"CA3\u0013\t\u0007I\u0011BA4\u0011!\t\t(\u0003Q\u0001\n\u0005%\u0004BCA:\u0013!\u0015\r\u0011\"\u0001\u0002v!9\u0011QP\u0005\u0005\u0002\u0005U\u0004bBA@\u0013\u0011\u0005\u0011\u0011\u0011\u0005\b\u0003\u001fKA\u0011AAI\u0011\u001d\t9*\u0003C\u0001\u00033Cq!!(\n\t\u0003\ty\nC\u0004\u0002B&!\t!a1\t\u000f\u0005-\u0017\u0002\"\u0001\u0002N\"9\u0011q]\u0005\u0005\u0002\u0005%\bbBAw\u0013\u0011\u0005\u0013q\u001e\u0005\b\u0003oLA\u0011KA}\u0011\u001d\u00119!\u0003C)\u0005\u0013AqA!\u0006\n\t\u0013\u00119\u0002\u0003\u0004\u0003\u001e%!\te\u0011\u0005\b\u0005?IA\u0011\u0002B\u0011\u0011!\u0011\u0019$\u0003C)c\tU\u0002b\u0002B\u001d\u0013\u0011\u0005!1\b\u0005\u000e\u0005\u0003J\u0001\u0013aA\u0001\u0002\u0013%!1I;\u00023\rc\u0017.\u001a8u%\u0016\fX/Z:u#V|G/Y'b]\u0006<WM\u001d\u0006\u0003eM\naa]3sm\u0016\u0014(\"\u0001\u001b\u0002\u000b-\fgm[1\u0004\u0001A\u0011q'A\u0007\u0002c\tI2\t\\5f]R\u0014V-];fgR\fVo\u001c;b\u001b\u0006t\u0017mZ3s'\t\t!\b\u0005\u0002<}5\tAHC\u0001>\u0003\u0015\u00198-\u00197b\u0013\tyDH\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\n!$U;pi\u0006\u0014V-];fgR\u0004VM]2f]R$UMZ1vYR,\u0012\u0001\u0012\t\u0003w\u0015K!A\u0012\u001f\u0003\r\u0011{WO\u00197f\u0003m\tVo\u001c;b%\u0016\fX/Z:u!\u0016\u00148-\u001a8u\t\u00164\u0017-\u001e7uA\u0005Qb*\u00198pgR{\u0007+\u001a:dK:$\u0018mZ3QKJ\u001cVmY8oI\u0006Yb*\u00198pgR{\u0007+\u001a:dK:$\u0018mZ3QKJ\u001cVmY8oI\u0002\n\u0001#\u0012=f[B$8+\u001a8t_Jt\u0015-\\3\u0016\u00031\u0003\"!\u0014*\u000e\u00039S!a\u0014)\u0002\t1\fgn\u001a\u0006\u0002#\u0006!!.\u0019<b\u0013\t\u0019fJ\u0001\u0004TiJLgnZ\u0001\u0012\u000bb,W\u000e\u001d;TK:\u001cxN\u001d(b[\u0016\u00043CA\u0005W!\t9t+\u0003\u0002Yc\t\u00112\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003\u0019\u0019wN\u001c4jOV\t1\f\u0005\u000289&\u0011Q,\r\u0002\u0019\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'oQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\b[\u0016$(/[2t+\u0005\t\u0007C\u00012l\u001b\u0005\u0019'BA0e\u0015\t)g-\u0001\u0004d_6lwN\u001c\u0006\u0003i\u001dT!\u0001[5\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0017aA8sO&\u0011An\u0019\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001\u0002;j[\u0016\u0004\"\u0001]:\u000e\u0003ET!A\u001d3\u0002\u000bU$\u0018\u000e\\:\n\u0005Q\f(\u0001\u0002+j[\u0016L!A\\,\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&DX#\u0001=\u0011\u0007e\f\tA\u0004\u0002{}B\u00111\u0010P\u0007\u0002y*\u0011Q0N\u0001\u0007yI|w\u000e\u001e \n\u0005}d\u0014A\u0002)sK\u0012,g-C\u0002T\u0003\u0007Q!a \u001f\u0002#QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\b%A\u0007rk>$\u0018mQ1mY\n\f7m[\u000b\u0003\u0003\u0017\u0001RaOA\u0007\u0003#I1!a\u0004=\u0005\u0019y\u0005\u000f^5p]B!\u00111CA\u000e\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011!B9v_R\f'B\u0001\u001ag\u0013\u0011\ti\"!\u0006\u0003'\rc\u0017.\u001a8u#V|G/Y\"bY2\u0014\u0017mY6\u0002\u001dE,x\u000e^1DC2d'-Y2lA\u0005!\u0012m\u0019;jm\u0016$VM\\1oiNl\u0015M\\1hKJ\u0004RaOA\u0007\u0003K\u00012aNA\u0014\u0013\r\tI#\r\u0002\u0015\u0003\u000e$\u0018N^3UK:\fg\u000e^:NC:\fw-\u001a:\u0015\u001d\u00055\u0012qFA\u0019\u0003g\t)$a\u000e\u0002:A\u0011q'\u0003\u0005\u00063R\u0001\ra\u0017\u0005\u0006?R\u0001\r!\u0019\u0005\u0006]R\u0001\ra\u001c\u0005\u0006mR\u0001\r\u0001\u001f\u0005\b\u0003\u000f!\u0002\u0019AA\u0006\u0011\u001d\t\t\u0003\u0006a\u0001\u0003G\t!\u0003\u001e5sK\u0006$Wk]1hKN+gn]8sgV\u0011\u0011q\b\t\u0004o\u0005\u0005\u0013bAA\"c\t\u0011B\u000b\u001b:fC\u0012,6/Y4f'\u0016t7o\u001c:t\u0003M!\bN]3bIV\u001b\u0018mZ3TK:\u001cxN]:!\u0003Ma\u0017m\u001d;MS6LGoQ8se\u0016\u001cG/[8o\u0003]a\u0017m\u001d;MS6LGoQ8se\u0016\u001cG/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002N\u0005M\u0003cA\u001e\u0002P%\u0019\u0011\u0011\u000b\u001f\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003+B\u0012\u0011!a\u0001\t\u0006\u0019\u0001\u0010J\u0019\u0002)1\f7\u000f\u001e'j[&$8i\u001c:sK\u000e$\u0018n\u001c8!\u0003Ei\u0017\r\u001f+ie>$H\u000f\\3US6,Wj]\u000b\u0003\u0003;\u00022aOA0\u0013\r\t\t\u0007\u0010\u0002\u0005\u0019>tw-\u0001\nnCb$\u0006N]8ui2,G+[7f\u001bN\u0004\u0013\u0001E3yK6\u0004H/T3ue&\u001cg*Y7f+\t\tI\u0007\u0005\u0003\u0002l\u00055T\"\u00013\n\u0007\u0005=DM\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016\f\u0011#\u001a=f[B$X*\u001a;sS\u000et\u0015-\\3!\u00031)\u00070Z7qiN+gn]8s+\t\t9\bE\u0002c\u0003sJ1!a\u001fd\u0005\u0019\u0019VM\\:pe\u00069bn\u001c8Fq\u0016l\u0007\u000f^\"ba\u0006\u001c\u0017\u000e^=TK:\u001cxN]\u0001\u001ae\u0016\u001cwN\u001d3Fq\u0016l\u0007\u000f\u001e(fi^|'o\u001b+ie\u0016\fG\r\u0006\u0005\u0002N\u0005\r\u0015qQAF\u0011\u0019\t)\t\ta\u0001\t\u0006)a/\u00197vK\"1\u0011\u0011\u0012\u0011A\u0002a\fA\u0002\\5ti\u0016tWM\u001d(b[\u0016Dq!!$!\u0001\u0004\ti&\u0001\u0004uS6,Wj]\u0001\u0015e\u0016\u001cwN\u001d3Fq\u0016l\u0007\u000f^%p)\"\u0014X-\u00193\u0015\r\u00055\u00131SAK\u0011\u0019\t))\ta\u0001\t\"9\u0011QR\u0011A\u0002\u0005u\u0013!\u0006:f[>4X\rT5ti\u0016tWM]'fiJL7m\u001d\u000b\u0005\u0003\u001b\nY\n\u0003\u0004\u0002\n\n\u0002\r\u0001_\u0001 [\u0006L(-\u001a*fG>\u0014H-\u00118e\u000f\u0016$H\u000b\u001b:piRdW\rV5nK6\u001bHCBAQ\u0003O\u000by\fE\u0002<\u0003GK1!!*=\u0005\rIe\u000e\u001e\u0005\b\u0003S\u001b\u0003\u0019AAV\u0003\u001d\u0011X-];fgR\u0004B!!,\u0002::!\u0011qVA[\u001b\t\t\tLC\u0002\u00024N\nqA\\3uo>\u00148.\u0003\u0003\u00028\u0006E\u0016A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0005\u0003w\u000biLA\u0004SKF,Xm\u001d;\u000b\t\u0005]\u0016\u0011\u0017\u0005\b\u0003\u001b\u001b\u0003\u0019AA/\u0003e)hN]3d_J$Gk\u001c;bYRC'o\u001c;uY\u0016$\u0016.\\3\u0015\u0011\u00055\u0013QYAd\u0003\u0013Dq!!+%\u0001\u0004\tY\u000b\u0003\u0004\u0002\u0006\u0012\u0002\r\u0001\u0012\u0005\b\u0003\u001b#\u0003\u0019AA/\u0003\t:W\r^(s\u0007J,\u0017\r^3U_R\fG\u000e\u00165s_R$H.\u001a+j[\u0016\u001cVM\\:peR1\u0011qOAh\u0003GDq!!5&\u0001\u0004\t\u0019.A\u0004tKN\u001c\u0018n\u001c8\u0011\t\u0005U\u0017q\u001c\b\u0005\u0003/\f)L\u0004\u0003\u0002Z\u0006ugbA>\u0002\\&\tA'C\u0002\u00024NJA!!9\u0002>\n91+Z:tS>t\u0007BBAsK\u0001\u0007\u00010\u0001\u0005dY&,g\u000e^%e\u0003Ei\u0017-\u001f2f%\u0016\u001cwN\u001d3Fq\u0016l\u0007\u000f\u001e\u000b\u0005\u0003\u001b\nY\u000fC\u0004\u0002*\u001a\u0002\r!a+\u0002'\t\f7m\u001b9sKN\u001cXO]3F]\u0006\u0014G.\u001a3\u0016\u0005\u0005E\bcA\u001e\u0002t&\u0019\u0011Q\u001f\u001f\u0003\u000f\t{w\u000e\\3b]\u0006aA\u000f\u001b:piRdW\rV5nKR1\u0011QLA~\u0005\u000bAq!!@)\u0001\u0004\ty0A\u0001f!\r\u0011'\u0011A\u0005\u0004\u0005\u0007\u0019'aF)v_R\fg+[8mCRLwN\\#yG\u0016\u0004H/[8o\u0011\u001d\ti\t\u000ba\u0001\u0003;\nQc\u00197jK:$\u0018+^8uC6+GO]5d\u001d\u0006lW\r\u0006\u0003\u0002j\t-\u0001b\u0002B\u0007S\u0001\u0007!qB\u0001\u0010cV|G/Y'fiJL7\rV1hgB)\u0011P!\u0005yq&!!1CA\u0002\u0005\ri\u0015\r]\u0001\u0012]\u0006twn\u001d+p!\u0016\u00148-\u001a8uC\u001e,Gc\u0001#\u0003\u001a!9!1\u0004\u0016A\u0002\u0005u\u0013!\u00028b]>\u001c\u0018aE4fi\n\u0013xn[3s#V|G/\u0019'j[&$\u0018A\u0005:fG>\u0014HMT3uo>\u00148.V:bO\u0016$\"\"!\u0014\u0003$\t\u0015\"q\u0005B\u0019\u0011\u0019\t)\t\fa\u0001\t\"1\u0011\u0011\u0012\u0017A\u0002aDqA!\u000b-\u0001\u0004\u0011Y#\u0001\u0007uQJ|G\u000f\u001e7f)f\u0004X\rE\u00028\u0005[I1Aa\f2\u0005M\u0011V-];fgR$\u0006N]8ui2,G+\u001f9f\u0011\u001d\ti\t\fa\u0001\u0003;\na#\u001e9eCR,'I]8lKJ\fVo\u001c;b\u0019&l\u0017\u000e\u001e\u000b\u0005\u0003\u001b\u00129\u0004C\u0004\u0002\u000e6\u0002\r!!\u0018\u0002-U\u0004H-\u0019;f\u0003\u0012TWo\u001d;fI\u000e\u000b\u0007/Y2jif$2\u0001\u0012B\u001f\u0011\u0019\u0011yD\fa\u0001\t\u0006\u0011\"M]8lKJ\u0014V-];fgRd\u0015.\\5u\u0003)\u0019X\u000f]3sIQLW.Z\u000b\u0002_\u0002")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private Sensor exemptSensor;
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> quotaCallback;
    private final ThreadUsageSensors threadUsageSensors;
    private double lastLimitCorrection;
    private final long maxThrottleTimeMs;
    private MetricName exemptMetricName;
    private volatile boolean bitmap$0;

    public static double NanosToPercentagePerSecond() {
        return ClientRequestQuotaManager$.MODULE$.NanosToPercentagePerSecond();
    }

    public static double QuotaRequestPercentDefault() {
        return ClientRequestQuotaManager$.MODULE$.QuotaRequestPercentDefault();
    }

    private /* synthetic */ Time super$time() {
        return super.time();
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> quotaCallback() {
        return this.quotaCallback;
    }

    private ThreadUsageSensors threadUsageSensors() {
        return this.threadUsageSensors;
    }

    private double lastLimitCorrection() {
        return this.lastLimitCorrection;
    }

    private void lastLimitCorrection_$eq(double x$1) {
        this.lastLimitCorrection = x$1;
    }

    private long maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    private MetricName exemptMetricName() {
        return this.exemptMetricName;
    }

    private Sensor exemptSensor$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.exemptSensor = this.getOrCreateSensor(ClientRequestQuotaManager$.MODULE$.kafka$server$ClientRequestQuotaManager$$ExemptSensorName(), this.exemptMetricName());
                this.bitmap$0 = true;
            }
        }
        this.exemptMetricName = null;
        return this.exemptSensor;
    }

    public Sensor exemptSensor() {
        if (!this.bitmap$0) {
            return this.exemptSensor$lzycompute();
        }
        return this.exemptSensor;
    }

    public Sensor nonExemptCapacitySensor() {
        return this.getOrCreateValueSensor("non-exempt-capacity", BrokerBackpressureMetrics$.MODULE$.nonExemptRequestCapacityMetricName(this.metrics()));
    }

    public void recordExemptNetworkThread(double value, String listenerName, long timeMs) {
        this.exemptSensor().record(value, timeMs);
        this.recordNetworkUsage(value, listenerName, ExemptRequest$.MODULE$, timeMs);
    }

    public void recordExemptIoThread(double value, long timeMs) {
        this.exemptSensor().record(value, timeMs);
    }

    public void removeListenerMetrics(String listenerName) {
        this.threadUsageSensors().removeListenerMetrics(listenerName);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request, long timeMs) {
        double d = (double)request.requestThreadTimeNanos() * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
        String listenerName = request.context().listenerName.value();
        this.threadUsageSensors().recordIoThreadUsage(d, timeMs, this.threadUsageSensors().recordIoThreadUsage$default$3());
        if (this.quotasEnabled()) {
            this.threadUsageSensors().recordIoThreadUsage(d, timeMs, (Option<RequestThrottleType>)new Some((Object)NonExemptRequest$.MODULE$));
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable)timeNanos -> {
                this.recordNoThrottle(request.session(), request.header().clientId(), (double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond());
                this.recordNetworkUsage((double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), listenerName, NonExemptRequest$.MODULE$, this.super$time().milliseconds());
            }));
            int throttleTimeMs = this.recordAndGetThrottleTimeMs(request.session(), request.header().clientId(), d, timeMs);
            this.getOrCreateTotalThrottleTimeSensor(request.session(), request.header().clientId()).record((double)throttleTimeMs, timeMs, false);
            return throttleTimeMs;
        }
        request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable)timeNanos -> this.recordNetworkUsage((double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), listenerName, NonExemptRequest$.MODULE$, this.super$time().milliseconds())));
        return 0;
    }

    public void unrecordTotalThrottleTime(RequestChannel.Request request, double value, long timeMs) {
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Unrecording previously recorded total-throttle-time value: {}", (Object)BoxesRunTime.boxToDouble((double)value));
        }
        this.getOrCreateTotalThrottleTimeSensor(request.session(), request.header().clientId()).record(value * (double)-1, timeMs, false);
    }

    public Sensor getOrCreateTotalThrottleTimeSensor(RequestChannel.Session session, String clientId) {
        scala.collection.immutable.Map<String, String> metricTags = this.getMetricTags(session, clientId);
        return this.getOrCreateAvgSensor(new StringBuilder(18).append(this.quotaType()).append("ThrottleTotalTime-").append(metricTags.values().mkString(":")).toString(), this.metrics().metricName("total-throttle-time", "Request", "Tracking throttled time for all requests per user/client-id", CollectionConverters$.MODULE$.MapHasAsJava(metricTags).asJava()));
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        long currentTimeMs = super.time().milliseconds();
        double d = (double)request.requestThreadTimeNanos() * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
        String listenerName = request.context().listenerName.value();
        this.threadUsageSensors().recordIoThreadUsage(d, currentTimeMs, this.threadUsageSensors().recordIoThreadUsage$default$3());
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable)timeNanos -> this.recordExemptNetworkThread((double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), listenerName, this.super$time().milliseconds())));
            this.recordExemptIoThread(d, currentTimeMs);
            return;
        }
        request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable)timeNanos -> this.recordNetworkUsage((double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), listenerName, ExemptRequest$.MODULE$, this.super$time().milliseconds())));
    }

    @Override
    public boolean backpressureEnabled() {
        return this.dynamicBackpressureConfig().backpressureEnabledInConfig() && this.dynamicBackpressureConfig().tenantEndpointListenerNames().nonEmpty();
    }

    @Override
    public long throttleTime(QuotaViolationException e, long timeMs) {
        return QuotaUtils$.MODULE$.boundedThrottleTime(e, this.maxThrottleTimeMs(), timeMs);
    }

    @Override
    public MetricName clientQuotaMetricName(scala.collection.immutable.Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("request-time", "Request", "Tracking request-time per user/client-id", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    private double nanosToPercentage(long nanos) {
        return (double)nanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    @Override
    public double getBrokerQuotaLimit() {
        Option metricOpt = Option$.MODULE$.apply((Object)this.metrics().metric(BrokerBackpressureMetrics$.MODULE$.nonExemptRequestCapacityMetricName(this.metrics())));
        double d = metricOpt instanceof Some ? BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((Some)metricOpt).value()).metricValue()) : Double.MAX_VALUE;
        return d;
    }

    private void recordNetworkUsage(double value, String listenerName, RequestThrottleType throttleType, long timeMs) {
        this.threadUsageSensors().recordNetworkThreadUsage(value, timeMs, listenerName, this.threadUsageSensors().recordNetworkThreadUsage$default$4());
        if (this.quotasEnabled() && NonExemptRequest$.MODULE$.equals(throttleType)) {
            this.threadUsageSensors().recordNetworkThreadUsage(value, timeMs, listenerName, (Option<RequestThrottleType>)new Some((Object)NonExemptRequest$.MODULE$));
            return;
        }
    }

    @Override
    public void updateBrokerQuotaLimit(long timeMs) {
        Seq<String> tenantEndpointsListenerNames = this.dynamicBackpressureConfig().tenantEndpointListenerNames();
        if (this.quotasEnabled() && tenantEndpointsListenerNames.nonEmpty()) {
            double nonExemptIoThreadUsage = ThreadUsageMetrics$.MODULE$.ioThreadsUsage(this.metrics(), (Option<RequestThrottleType>)new Some((Object)NonExemptRequest$.MODULE$));
            double ioThreadUsage = ThreadUsageMetrics$.MODULE$.ioThreadsUsage(this.metrics(), (Option<RequestThrottleType>)None$.MODULE$);
            double nonExemptNetworkThreadUsage = ThreadUsageMetrics$.MODULE$.networkThreadsUsage(this.metrics(), tenantEndpointsListenerNames, (Option<RequestThrottleType>)new Some((Object)NonExemptRequest$.MODULE$));
            double networkThreadUsage = ThreadUsageMetrics$.MODULE$.networkThreadsUsage(this.metrics(), tenantEndpointsListenerNames, (Option<RequestThrottleType>)None$.MODULE$);
            double nonExemptIoThreadLimit = ClientRequestQuotaManager.nonExemptThreadUsageLimit$1(nonExemptIoThreadUsage, ioThreadUsage, ThreadUsageMetrics$.MODULE$.ioThreadsCapacity(this.metrics()));
            double nonExemptNetworkThreadLimit = ClientRequestQuotaManager.nonExemptThreadUsageLimit$1(nonExemptNetworkThreadUsage, networkThreadUsage, ThreadUsageMetrics$.MODULE$.networkThreadsCapacity(this.metrics(), tenantEndpointsListenerNames));
            double brokerRequestQuotaLimit = ioThreadUsage >= nonExemptIoThreadLimit && networkThreadUsage >= nonExemptNetworkThreadLimit || ioThreadUsage < nonExemptIoThreadLimit && networkThreadUsage < nonExemptNetworkThreadLimit ? nonExemptIoThreadLimit + nonExemptNetworkThreadLimit : package$.MODULE$.min(networkThreadUsage, nonExemptNetworkThreadLimit) + package$.MODULE$.min(ioThreadUsage, nonExemptIoThreadLimit);
            double correctedLimit = this.updateAdjustedCapacity(brokerRequestQuotaLimit);
            this.nonExemptCapacitySensor().record(correctedLimit);
        }
    }

    public double updateAdjustedCapacity(double brokerRequestLimit) {
        double d;
        double d2 = QueueSizePercentiles.dataPlaneQueueSize$(RequestQueueSizePercentiles$.MODULE$, this.metrics(), this.dynamicBackpressureConfig().queueSizePercentile(), (Map)Map$.MODULE$.empty());
        double minCap = this.dynamicBackpressureConfig().minBrokerRequestQuota();
        if (d2 >= this.dynamicBackpressureConfig().queueSizeCap()) {
            double maxAdjustmentLimit = package$.MODULE$.max(brokerRequestLimit - minCap, 0.0);
            d = this.lastLimitCorrection() < maxAdjustmentLimit ? this.lastLimitCorrection() + BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaAdjustment() : this.lastLimitCorrection();
        } else {
            d = package$.MODULE$.max(0.0, this.lastLimitCorrection() - BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaAdjustment());
        }
        this.lastLimitCorrection_$eq(d);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("queueSize(p95)=").append(d2).append(",  lastLimitCorrection=").append(this.lastLimitCorrection()).toString());
        return package$.MODULE$.max(brokerRequestLimit - this.lastLimitCorrection(), minCap);
    }

    private static final double nonExemptThreadUsageLimit$1(double nonExemptUsage, double totalUsage, double totalCapacity) {
        double exemptUsage = totalUsage - nonExemptUsage;
        double nonExemptCapacity = totalCapacity * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization() - exemptUsage;
        double minNonExemptCapacity = totalCapacity * BrokerBackpressureConfig$.MODULE$.DefaultMinNonExemptRequestUtilization();
        return package$.MODULE$.max(nonExemptCapacity, minNonExemptCapacity);
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> quotaCallback, Option<ActiveTenantsManager> activeTenantsManager) {
        this.config = config;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.quotaCallback = quotaCallback;
        super(config, metrics, QuotaType$Request$.MODULE$, time, threadNamePrefix, quotaCallback, activeTenantsManager);
        this.threadUsageSensors = new ThreadUsageSensors(metrics, ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds());
        this.lastLimitCorrection = 0.0;
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds());
        this.exemptMetricName = metrics.metricName("exempt-request-time", "Request", "Tracking exempt-request-time utilization percentage");
    }
}

