/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t]d\u0001\u0002\u000b\u0016\u0001iA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011!9\u0005A!b\u0001\n\u0003A\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u000bQ\u0003A\u0011A+\t\u000bq\u0003A\u0011A/\t\u000be\u0004A\u0011\u0001>\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m\u0006bBAp\u0001\u0011\u0005\u0011\u0011\u001d\u0005\b\u0003w\u0004A\u0011BA\u007f\u0011\u001d\u0011i\u0001\u0001C\u0005\u0005\u001fAqA!\u0007\u0001\t\u0013\u0011Y\u0002C\u0004\u00032\u0001!IAa\r\t\u000f\t]\u0002\u0001\"\u0003\u0003:!9!Q\b\u0001\u0005\n\t}\u0002b\u0002B5\u0001\u0011%!1\u000e\u0002\r\u0007>tg-[4IK2\u0004XM\u001d\u0006\u0003-]\taa]3sm\u0016\u0014(\"\u0001\r\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001aG\u0011\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g!\t\u0011S%D\u0001$\u0015\t!s#A\u0003vi&d7/\u0003\u0002'G\t9Aj\\4hS:<\u0017!D7fi\u0006$\u0017\r^1DC\u000eDW\r\u0005\u0002*U5\tQ#\u0003\u0002,+\tiQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016\faaY8oM&<\u0007CA\u0015/\u0013\tySCA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001E2p]\u001aLwMU3q_NLGo\u001c:z!\t\u0011T'D\u00014\u0015\t!T#\u0001\u0005nKR\fG-\u0019;b\u0013\t14G\u0001\tD_:4\u0017n\u001a*fa>\u001c\u0018\u000e^8ss\u0006\t\u0012\r\u001c;fe\u000e{gNZ5h!>d\u0017nY=\u0011\u0007qI4(\u0003\u0002;;\t1q\n\u001d;j_:\u0004\"\u0001P#\u000e\u0003uR!AP \u0002\rA|G.[2z\u0015\t1\u0002I\u0003\u0002\u0019\u0003*\u0011!iQ\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\u000b1a\u001c:h\u0013\t1UHA\tBYR,'oQ8oM&<\u0007k\u001c7jGf\f!c\u00197vgR,'\u000fT5oW6\u000bg.Y4feV\t\u0011\n\u0005\u0002K!:\u00111JT\u0007\u0002\u0019*\u0011Q*F\u0001\u0005Y&t7.\u0003\u0002P\u0019\u0006\u00112\t\\;ti\u0016\u0014H*\u001b8l\r\u0006\u001cGo\u001c:z\u0013\t\t&KA\u0006MS:\\W*\u00198bO\u0016\u0014(BA(M\u0003M\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:!\u0003\u0019a\u0014N\\5u}Q1ak\u0016-Z5n\u0003\"!\u000b\u0001\t\u000b\u001d:\u0001\u0019\u0001\u0015\t\u000b1:\u0001\u0019A\u0017\t\u000bA:\u0001\u0019A\u0019\t\u000b]:\u0001\u0019\u0001\u001d\t\u000b\u001d;\u0001\u0019A%\u0002\u0015\u0005dGnQ8oM&<7\u000f\u0006\u0002_cB!q\f\u001a4o\u001b\u0005\u0001'BA1c\u0003\u001diW\u000f^1cY\u0016T!aY\u000f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002fA\n\u0019Q*\u00199\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017\u0001\u00027b]\u001eT\u0011a[\u0001\u0005U\u00064\u0018-\u0003\u0002nQ\n11\u000b\u001e:j]\u001e\u0004\"aZ8\n\u0005AD'AB(cU\u0016\u001cG\u000fC\u0003-\u0011\u0001\u0007!\u000f\u0005\u0002to6\tAO\u0003\u0002-k*\u0011a\u000fQ\u0001\u0007G>lWn\u001c8\n\u0005a$(AD!cgR\u0014\u0018m\u0019;D_:4\u0017nZ\u0001\u0010I\u0016\u001c8M]5cK\u000e{gNZ5hgRI10a\t\u0002L\u0005U\u0013\u0011\u000e\t\u0006y\u0006%\u0011q\u0002\b\u0004{\u0006\u0015ab\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002e\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0010\n\u0007\u0005\u001dQ$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0011Q\u0002\u0002\u0005\u0019&\u001cHOC\u0002\u0002\bu\u0001B!!\u0005\u0002\u001e9!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018U\fq!\\3tg\u0006<W-\u0003\u0003\u0002\u001c\u0005U\u0011a\u0007#fg\u000e\u0014\u0018NY3D_:4\u0017nZ:SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0002 \u0005\u0005\"!\u0006#fg\u000e\u0014\u0018NY3D_:4\u0017nZ:SKN,H\u000e\u001e\u0006\u0005\u00037\t)\u0002C\u0004\u0002&%\u0001\r!a\n\u0002+I,7o\\;sG\u0016$vnQ8oM&<g*Y7fgB)A0!\u0003\u0002*A!\u00111FA#\u001d\u0011\ti#!\u0011\u000f\t\u0005=\u0012q\b\b\u0005\u0003c\tiD\u0004\u0003\u00024\u0005mb\u0002BA\u001b\u0003sq1A`A\u001c\u0013\u0005!\u0015B\u0001\"D\u0013\tA\u0012)\u0003\u0002w\u0001&\u0019\u0011qC;\n\t\u0005\r\u0013QC\u0001\u001b\t\u0016\u001c8M]5cK\u000e{gNZ5hgJ+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0003\u000f\nIEA\fEKN\u001c'/\u001b2f\u0007>tg-[4t%\u0016\u001cx.\u001e:dK*!\u00111IA\u000b\u0011\u001d\ti%\u0003a\u0001\u0003\u001f\nq\"\u001b8dYV$WmU=o_:LXn\u001d\t\u00049\u0005E\u0013bAA*;\t9!i\\8mK\u0006t\u0007bBA,\u0013\u0001\u0007\u0011\u0011L\u0001\naJLgnY5qC2\u0004B!a\u0017\u0002f5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'\u0001\u0003bkRD'bAA2k\u0006A1/Z2ve&$\u00180\u0003\u0003\u0002h\u0005u#AD&bM.\f\u0007K]5oG&\u0004\u0018\r\u001c\u0005\b\u0003WJ\u0001\u0019AA(\u0003QIgn\u00197vI\u0016$unY;nK:$\u0018\r^5p]\u000612M]3bi\u0016$v\u000e]5d\u0007>tg-[4F]R\u0014\u0018\u0010\u0006\u0006\u0002r\u0005U\u0015QUA[\u0003o#b!a\u001d\u0002z\u0005-\u0005\u0003BA\t\u0003kJA!a\u001e\u0002\"\tiB)Z:de&\u0014WmQ8oM&<7OU3t_V\u00148-\u001a*fgVdG\u000fC\u0004\u0002|)\u0001\r!! \u0002\t9\fW.\u001a\t\u0005\u0003\u007f\n9I\u0004\u0003\u0002\u0002\u0006\r\u0005C\u0001@\u001e\u0013\r\t))H\u0001\u0007!J,G-\u001a4\n\u00075\fIIC\u0002\u0002\u0006vAq!!$\u000b\u0001\u0004\ty)A\u0003wC2,X\rE\u0002\u001d\u0003#K1!a%\u001e\u0005\r\te.\u001f\u0005\b\u0003/S\u0001\u0019AAM\u0003%awnZ\"p]\u001aLw\r\u0005\u0003\u0002\u001c\u0006\u0005VBAAO\u0015\r\tyjF\u0001\u0004Y><\u0017\u0002BAR\u0003;\u0013\u0011\u0002T8h\u0007>tg-[4\t\u000f\u0005\u001d&\u00021\u0001\u0002*\u0006QAo\u001c9jGB\u0013x\u000e]:\u0011\t\u0005-\u0016\u0011W\u0007\u0003\u0003[S1!a,k\u0003\u0011)H/\u001b7\n\t\u0005M\u0016Q\u0016\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBA'\u0015\u0001\u0007\u0011q\n\u0005\b\u0003WR\u0001\u0019AA(\u0003I1\u0017\u000e\u001c;feR{\u0007/[2D_:4\u0017nZ:\u0015\r\u0005u\u0016\u0011ZAj!\u0015y\u0016qXAb\u0013\r\t\t\r\u0019\u0002\u0007\u0005V4g-\u001a:\u0011\u000fq\t)-! \u0002\u0010&\u0019\u0011qY\u000f\u0003\rQ+\b\u000f\\33\u0011\u001d\tYm\u0003a\u0001\u0003\u001b\fqaY8oM&<7\u000f\u0005\u0005\u0002P\u0006E\u0017QPAH\u001b\u0005\u0011\u0017BA3c\u0011\u001d\t)n\u0003a\u0001\u0003/\f1bY8oM&<g*Y7fgB!A$OAm!\u0019\ty-a7\u0002~%\u0019\u0011Q\u001c2\u0003\u0007M+G/\u0001\u000bwC2LG-\u0019;f\u0007>tg-[4Q_2L7-\u001f\u000b\t\u0003G\fI/a=\u0002zB\u0019A$!:\n\u0007\u0005\u001dXD\u0001\u0003V]&$\bbBAv\u0019\u0001\u0007\u0011Q^\u0001\te\u0016\u001cx.\u001e:dKB\u00191/a<\n\u0007\u0005EHO\u0001\bD_:4\u0017n\u001a*fg>,(oY3\t\u000f\u0005UH\u00021\u0001\u0002x\u0006\u00012m\u001c8gS\u001e,e\u000e\u001e:jKNl\u0015\r\u001d\t\t\u0003\u001f\f\t.! \u0002~!9\u0011q\u000b\u0007A\u0002\u0005e\u0013aF2sK\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e,e\u000e\u001e:z)!\tyP!\u0002\u0003\n\t-ACBA:\u0005\u0003\u0011\u0019\u0001C\u0004\u0002|5\u0001\r!! \t\u000f\u00055U\u00021\u0001\u0002\u0010\"9!qA\u0007A\u0002\u0005=\u0013a\u00049fe\n\u0013xn[3s\u0007>tg-[4\t\u000f\u00055S\u00021\u0001\u0002P!9\u00111N\u0007A\u0002\u0005=\u0013\u0001H2sK\u0006$Xm\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u000b:$(/\u001f\u000b\u0005\u0005#\u00119\u0002\u0006\u0004\u0002t\tM!Q\u0003\u0005\b\u0003wr\u0001\u0019AA?\u0011\u001d\tiI\u0004a\u0001\u0003\u001fCQ\u0001\f\bA\u0002I\fabY8oM&<7+\u001f8p]fl7\u000f\u0006\u0005\u0003\u001e\t\u0015\"q\u0005B\u0017!\u0015a\u0018\u0011\u0002B\u0010!\u0011\t\tB!\t\n\t\t\r\u0012\u0011\u0005\u0002\u0017\t\u0016\u001c8M]5cK\u000e{gNZ5hgNKhn\u001c8z[\"9\u00111P\bA\u0002\u0005u\u0004b\u0002B\u0015\u001f\u0001\u0007!1F\u0001\tgftwN\\=ngB)A0!\u0003\u0002~!9!qF\bA\u0002\u0005=\u0013aC5t'\u0016t7/\u001b;jm\u0016\faB\u0019:pW\u0016\u00148+\u001f8p]fl7\u000f\u0006\u0003\u0003,\tU\u0002bBA>!\u0001\u0007\u0011QP\u0001\u0014EJ|7.\u001a:E_\u000e,X.\u001a8uCRLwN\u001c\u000b\u0005\u0003{\u0012Y\u0004C\u0004\u0002|E\u0001\r!! \u0002%\r|gNZ5h%\u0016\u001c\bo\u001c8tKRK\b/\u001a\u000b\u0005\u0005\u0003\u0012)\u0006\u0005\u0003\u0003D\t=c\u0002\u0002B#\u0005\u0017j!Aa\u0012\u000b\u0007\t%S/\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011iEa\u0012\u0002/\u0011+7o\u0019:jE\u0016\u001cuN\u001c4jON\u0014Vm\u001d9p]N,\u0017\u0002\u0002B)\u0005'\u0012!bQ8oM&<G+\u001f9f\u0015\u0011\u0011iEa\u0012\t\u000f\t]#\u00031\u0001\u0003Z\u0005Q1m\u001c8gS\u001e$\u0016\u0010]3\u0011\tqI$1\f\t\u0005\u0005;\u0012\u0019GD\u0002t\u0005?J1A!\u0019u\u0003%\u0019uN\u001c4jO\u0012+g-\u0003\u0003\u0003f\t\u001d$\u0001\u0002+za\u0016T1A!\u0019u\u0003Y\u0011Xm]8ve\u000e,g*Y7f)>\u0014%o\\6fe&#G\u0003\u0002B7\u0005g\u00022\u0001\bB8\u0013\r\u0011\t(\b\u0002\u0004\u0013:$\bb\u0002B;'\u0001\u0007\u0011QP\u0001\re\u0016\u001cx.\u001e:dK:\u000bW.\u001a")
public class ConfigHelper
implements Logging {
    private final MetadataCache metadataCache;
    private final KafkaConfig config;
    private final ConfigRepository configRepository;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private final ClusterLinkFactory.LinkManager clusterLinkManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public scala.collection.mutable.Map<String, Object> allConfigs(AbstractConfig config) {
        return (scala.collection.mutable.Map)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(config.originals()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$allConfigs$1(x$1)))).$plus$plus((IterableOnce)CollectionConverters$.MODULE$.MapHasAsScala(config.nonInternalValues()).asScala());
    }

    public List<DescribeConfigsResponseData.DescribeConfigsResult> describeConfigs(List<DescribeConfigsRequestData.DescribeConfigsResource> resourceToConfigNames, boolean includeSynonyms, KafkaPrincipal principal, boolean includeDocumentation) {
        return resourceToConfigNames.map((Function1 & Serializable)x0$1 -> {
            try {
                DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult;
                ConfigResource.Type type = ConfigResource.Type.forId((byte)x0$1.resourceType());
                if (ConfigResource.Type.TOPIC.equals(type)) {
                    DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult2;
                    String topic = x0$1.resourceName();
                    Topic.validate((String)topic);
                    if ($this.metadataCache.contains(topic)) {
                        void createResponseConfig$1_createConfigEntry;
                        Properties topicProps = $this.configRepository.topicConfig(topic);
                        LogConfig logConfig = LogConfig$.MODULE$.fromProps(LogConfig$.MODULE$.extractLogConfigMap($this.config), topicProps);
                        Function2 & Serializable intersect = (Function2 & Serializable)(name, value) -> this.createTopicConfigEntry(logConfig, topicProps, includeSynonyms, includeDocumentation, (String)name, value);
                        scala.collection.mutable.Map<String, Object> createResponseConfig$1_configs = this.allConfigs(logConfig);
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala().toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0));
                        describeConfigsResult2 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(createResponseConfig$1_configEntries).asJava());
                        Object var18_10 = null;
                        intersect = null;
                        Object var20_11 = null;
                    } else {
                        describeConfigsResult2 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setConfigs(Collections.emptyList());
                    }
                    describeConfigsResult = describeConfigsResult2;
                } else if (ConfigResource.Type.BROKER.equals(type)) {
                    DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult3;
                    if (x0$1.resourceName() == null || x0$1.resourceName().isEmpty()) {
                        void createResponseConfig$1_createConfigEntry;
                        Function2 & Serializable intersect = (Function2 & Serializable)(name, value) -> this.createBrokerConfigEntry(false, includeSynonyms, includeDocumentation, (String)name, value);
                        Map<String, String> createResponseConfig$1_configs = $this.config.dynamicConfig().currentDynamicDefaultConfigs();
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs(createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala().toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0));
                        describeConfigsResult3 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(createResponseConfig$1_configEntries).asJava());
                        Object var21_14 = null;
                        intersect = null;
                        Object var23_15 = null;
                    } else if (this.resourceNameToBrokerId(x0$1.resourceName()) == $this.config.brokerId()) {
                        void createResponseConfig$1_createConfigEntry;
                        Function2 & Serializable intersect = (Function2 & Serializable)(name, value) -> this.createBrokerConfigEntry(true, includeSynonyms, includeDocumentation, (String)name, value);
                        scala.collection.mutable.Map<String, Object> createResponseConfig$1_configs = this.allConfigs($this.config);
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala().toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0));
                        describeConfigsResult3 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(createResponseConfig$1_configEntries).asJava());
                        Object var24_17 = null;
                        intersect = null;
                        Object var26_18 = null;
                    } else {
                        throw new InvalidRequestException(new StringBuilder(62).append("Unexpected broker id, expected ").append($this.config.brokerId()).append(" or empty string, but received ").append(x0$1.resourceName()).toString());
                    }
                    describeConfigsResult = describeConfigsResult3;
                } else if (ConfigResource.Type.BROKER_LOGGER.equals(type)) {
                    DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult4;
                    void createResponseConfig$1_createConfigEntry;
                    if (x0$1.resourceName() == null || x0$1.resourceName().isEmpty()) {
                        throw new InvalidRequestException("Broker id must not be empty");
                    }
                    if (this.resourceNameToBrokerId(x0$1.resourceName()) != $this.config.brokerId()) {
                        throw new InvalidRequestException(new StringBuilder(45).append("Unexpected broker id, expected ").append($this.config.brokerId()).append(" but received ").append(x0$1.resourceName()).toString());
                    }
                    ConfigResource configResource = new ConfigResource(ConfigResource.Type.forId((byte)x0$1.resourceType()), x0$1.resourceName());
                    this.validateConfigPolicy(configResource, (Map<String, String>)((Map)Map$.MODULE$.empty()), principal);
                    Function2 & Serializable intersect = (Function2 & Serializable)(name, value) -> new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(value.toString()).setConfigSource(DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG.id()).setIsSensitive(false).setReadOnly(false).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
                    scala.collection.mutable.Map<String, String> createResponseConfig$1_configs = Log4jController$.MODULE$.loggers();
                    Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala().toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0));
                    DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult5 = describeConfigsResult4 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(createResponseConfig$1_configEntries).asJava());
                    Object var27_21 = null;
                    intersect = null;
                    Object var29_22 = null;
                    describeConfigsResult4 = null;
                    describeConfigsResult = describeConfigsResult5;
                } else if (ConfigResource.Type.CLUSTER_LINK.equals(type)) {
                    DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult6;
                    String linkName = x0$1.resourceName();
                    if (linkName == null || linkName.isEmpty()) {
                        throw new InvalidRequestException("Cluster link name must not be empty");
                    }
                    UUID linkId = this.clusterLinkManager().resolveLinkIdOrThrow(linkName);
                    this.clusterLinkManager().ensureClusterLinkExists(linkId);
                    Properties persistentProps = $this.configRepository.config(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString()));
                    try {
                        void createResponseConfig$1_createConfigEntry;
                        ClusterLinkConfig config = this.clusterLinkManager().configEncoder().clusterLinkConfig(persistentProps);
                        Function2 & Serializable intersect = (Function2 & Serializable)(name, value) -> this.createClusterLinkConfigEntry(config, (String)name, value);
                        scala.collection.mutable.Map<String, Object> createResponseConfig$1_configs = this.allConfigs(config);
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala().toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0));
                        describeConfigsResult6 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(createResponseConfig$1_configEntries).asJava());
                        Object var31_29 = null;
                        intersect = null;
                        Object var33_30 = null;
                    }
                    catch (ConfigException configException) {
                        throw new InvalidConfigurationException(new StringBuilder(0).append(new StringBuilder(58).append("Cluster link configs could not be decoded for link '").append(linkName).append("', '").append(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()).append("' ").toString()).append("may be misconfigured on some brokers. Configure all brokers with the same encoder secret and reconfigure link by providing the full link config.").toString());
                    }
                    describeConfigsResult = describeConfigsResult6;
                } else {
                    throw new InvalidRequestException(new StringBuilder(27).append("Unsupported resource type: ").append(type).toString());
                }
                return describeConfigsResult.setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType());
            }
            catch (Throwable e) {
                String message = new StringBuilder(55).append("Error processing describe configs request for resource ").append(x0$1).toString();
                if (e instanceof ApiException) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable)() -> e);
                } else {
                    this.error((Function0<String>)(Function0 & Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
                ApiError err = ApiError.fromThrowable((Throwable)e);
                return new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType()).setErrorMessage(err.message()).setErrorCode(err.error().code()).setConfigs(Collections.emptyList());
            }
        });
    }

    public DescribeConfigsResponseData.DescribeConfigsResourceResult createTopicConfigEntry(LogConfig logConfig, Properties topicProps, boolean includeSynonyms, boolean includeDocumentation, String name, Object value) {
        List list;
        Option<ConfigDef.Type> configEntryType = LogConfig$.MODULE$.configType(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive(configEntryType);
        String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)configEntryType.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        List list2 = (List)LogConfig$.MODULE$.TopicConfigSynonyms().get((Object)name).map((Function1 & Serializable)s -> this.configSynonyms((String)s, DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms((String)s, true), isSensitive)).getOrElse((Function0 & Serializable)() -> package$.MODULE$.List().empty());
        if (!topicProps.containsKey(name)) {
            list = list2;
        } else {
            DescribeConfigsResponseData.DescribeConfigsSynonym describeConfigsSynonym = new DescribeConfigsResponseData.DescribeConfigsSynonym().setName(name).setValue(valueAsString).setSource(DescribeConfigsResponse.ConfigSource.TOPIC_CONFIG.id());
            list = (List)list2.$plus$colon((Object)describeConfigsSynonym);
        }
        List allSynonyms = list;
        byte source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id() : ((DescribeConfigsResponseData.DescribeConfigsSynonym)allSynonyms.head()).source();
        List synonyms = !includeSynonyms ? package$.MODULE$.List().empty() : allSynonyms;
        DescribeConfigsResponse.ConfigType dataType = this.configResponseType(configEntryType);
        String configDocumentation = includeDocumentation ? logConfig.documentationOf(name) : null;
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(source).setIsSensitive(isSensitive).setReadOnly(false).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)synonyms).asJava()).setDocumentation(configDocumentation).setConfigType(dataType.id());
    }

    public Buffer<Tuple2<String, Object>> filterTopicConfigs(Map<String, Object> configs, Option<Set<String>> configNames) {
        return ((IterableOnceOps)configs.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$filterTopicConfigs$1(configNames, x0$1)))).toBuffer();
    }

    public void validateConfigPolicy(ConfigResource resource, Map<String, String> configEntriesMap, KafkaPrincipal principal) {
        Option<AlterConfigPolicy> option = this.alterConfigPolicy;
        if (option instanceof Some) {
            ((AlterConfigPolicy)((Some)option).value()).validate(new AlterConfigPolicy.RequestMetadata(new ConfigResource(resource.type(), resource.name()), CollectionConverters$.MODULE$.MapHasAsJava(configEntriesMap).asJava(), principal));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    private DescribeConfigsResponseData.DescribeConfigsResourceResult createBrokerConfigEntry(boolean perBrokerConfig, boolean includeSynonyms, boolean includeDocumentation, String name, Object value) {
        String string;
        List<String> list;
        List<String> list2 = list = DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
        list = null;
        List<String> allNames = list2;
        Option<ConfigDef.Type> configEntryType = KafkaConfig$.MODULE$.configType(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive(configEntryType);
        if (isSensitive) {
            string = null;
        } else {
            String string2 = value instanceof String ? (String)value : ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)configEntryType.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
            string = string2;
        }
        String valueAsString = string;
        List allSynonyms = this.configSynonyms(name, allNames, isSensitive).filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$createBrokerConfigEntry$1(perBrokerConfig, x$5)));
        List synonyms = !includeSynonyms ? package$.MODULE$.List().empty() : allSynonyms;
        byte source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id() : ((DescribeConfigsResponseData.DescribeConfigsSynonym)allSynonyms.head()).source();
        boolean readOnly = !DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains((Object)name);
        DescribeConfigsResponse.ConfigType dataType = this.configResponseType(configEntryType);
        String configDocumentation = includeDocumentation ? this.brokerDocumentation(name) : null;
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(source).setIsSensitive(isSensitive).setReadOnly(readOnly).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)synonyms).asJava()).setDocumentation(configDocumentation).setConfigType(dataType.id());
    }

    private DescribeConfigsResponseData.DescribeConfigsResourceResult createClusterLinkConfigEntry(AbstractConfig config, String name, Object value) {
        ConfigDef.Type configEntryType;
        ConfigDef.Type type = configEntryType = config.typeOf(name);
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        boolean isSensitive = !(type != null ? !type.equals(type2) : type2 != null);
        String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value, (ConfigDef.Type)configEntryType);
        new DescribeConfigsResponse.ConfigEntry(name, valueAsString, DescribeConfigsResponse.ConfigSource.CLUSTER_LINK_CONFIG, isSensitive, false, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(DescribeConfigsResponse.ConfigSource.CLUSTER_LINK_CONFIG.id()).setIsSensitive(isSensitive).setReadOnly(false).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
    }

    private List<DescribeConfigsResponseData.DescribeConfigsSynonym> configSynonyms(String name2, List<String> synonyms, boolean isSensitive) {
        DynamicBrokerConfig dynamicConfig = this.config.dynamicConfig();
        Buffer allSynonyms = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        synonyms.foreach(arg_0 -> ConfigHelper.$anonfun$configSynonyms$2$adapted(dynamicConfig.currentDynamicBrokerConfigs(), isSensitive, allSynonyms, arg_0));
        synonyms.foreach(arg_0 -> ConfigHelper.$anonfun$configSynonyms$3$adapted(dynamicConfig.currentDynamicDefaultConfigs(), isSensitive, allSynonyms, arg_0));
        synonyms.foreach((Function1 & Serializable)name -> {
            ConfigHelper.maybeAddSynonym$1(dynamicConfig.staticBrokerConfigs(), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        synonyms.foreach((Function1 & Serializable)name -> {
            ConfigHelper.maybeAddSynonym$1(dynamicConfig.staticDefaultConfigs(), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        return ((IterableOnceOps)allSynonyms.dropWhile((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$configSynonyms$6(name2, s)))).toList();
    }

    private List<String> brokerSynonyms(String name) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
    }

    private String brokerDocumentation(String name) {
        return this.config.documentationOf(name);
    }

    private DescribeConfigsResponse.ConfigType configResponseType(Option<ConfigDef.Type> configType) {
        if (configType.isEmpty()) {
            return DescribeConfigsResponse.ConfigType.UNKNOWN;
        }
        ConfigDef.Type type = (ConfigDef.Type)configType.get();
        DescribeConfigsResponse.ConfigType configType2 = ConfigDef.Type.BOOLEAN.equals(type) ? DescribeConfigsResponse.ConfigType.BOOLEAN : (ConfigDef.Type.STRING.equals(type) ? DescribeConfigsResponse.ConfigType.STRING : (ConfigDef.Type.INT.equals(type) ? DescribeConfigsResponse.ConfigType.INT : (ConfigDef.Type.SHORT.equals(type) ? DescribeConfigsResponse.ConfigType.SHORT : (ConfigDef.Type.LONG.equals(type) ? DescribeConfigsResponse.ConfigType.LONG : (ConfigDef.Type.DOUBLE.equals(type) ? DescribeConfigsResponse.ConfigType.DOUBLE : (ConfigDef.Type.LIST.equals(type) ? DescribeConfigsResponse.ConfigType.LIST : (ConfigDef.Type.CLASS.equals(type) ? DescribeConfigsResponse.ConfigType.CLASS : (ConfigDef.Type.PASSWORD.equals(type) ? DescribeConfigsResponse.ConfigType.PASSWORD : DescribeConfigsResponse.ConfigType.UNKNOWN))))))));
        return configType2;
    }

    private int resourceNameToBrokerId(String resourceName) {
        try {
            return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(resourceName));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException(new StringBuilder(41).append("Broker id must be an integer, but it is: ").append(resourceName).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$allConfigs$1(Tuple2 x$1) {
        return x$1._2() != null;
    }

    private final DescribeConfigsResponseData.DescribeConfigsResult createResponseConfig$1(Map configs, Function2 createConfigEntry, DescribeConfigsRequestData.DescribeConfigsResource x1$1) {
        Buffer configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x1$1.configurationKeys()).filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala().toSet())).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            Object value = x0$1._2();
            DescribeConfigsResponseData.DescribeConfigsResourceResult describeConfigsResourceResult = (DescribeConfigsResponseData.DescribeConfigsResourceResult)createConfigEntry.apply((Object)name, value);
            return describeConfigsResourceResult;
        });
        return new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(configEntries).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$filterTopicConfigs$1(Option configNames$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String configName = (String)x0$1._1();
        boolean recordInterceptorCheck = !configName.equals(LogConfig$.MODULE$.AppendRecordInterceptorClassesProp());
        boolean schemaRegistryUrlCheck = !configName.equals("confluent.schema.registry.url");
        boolean schemaValidatorSamplesPerMinCheck = !configName.equals("confluent.schema.validator.samples.per.min");
        boolean schemaValidatorInterceptorClassCheck = !configName.equals("confluent.schema.validator.interceptor.class");
        boolean multitenantSchemaValidationEnabledCheck = !configName.equals("confluent.schema.validator.multitenant.enable");
        boolean basicAuthCredentialsSourceCheck = !configName.equals("confluent.basic.auth.credentials.source");
        boolean userInfoCheck = !configName.equals("confluent.basic.auth.user.info");
        boolean bearerAuthCredentialsCheck = !configName.equals("confluent.bearer.auth.credentials.source");
        boolean bearerAuthTokenCheck = !configName.equals("confluent.bearer.auth.token");
        boolean sslProtocolCheck = !configName.equals("confluent.ssl.protocol");
        boolean sslKeystoreTypeCheck = !configName.equals("confluent.ssl.keystore.type");
        boolean sslKeystoreLocationCheck = !configName.equals("confluent.ssl.keystore.location");
        boolean sslKeystorePasswordCheck = !configName.equals("confluent.ssl.keystore.password");
        boolean sslKeyPasswordCheck = !configName.equals("confluent.ssl.key.password");
        boolean sslTruststoreTypeCheck = !configName.equals("confluent.ssl.truststore.type");
        boolean sslTruststoreLocationCheck = !configName.equals("confluent.ssl.truststore.location");
        boolean sslTruststorePasswordCheck = !configName.equals("confluent.ssl.truststore.password");
        boolean bl = basicAuthCredentialsSourceCheck && userInfoCheck && bearerAuthCredentialsCheck && bearerAuthTokenCheck && recordInterceptorCheck && schemaRegistryUrlCheck && schemaValidatorSamplesPerMinCheck && schemaValidatorInterceptorClassCheck && multitenantSchemaValidationEnabledCheck && sslProtocolCheck && sslKeystoreTypeCheck && sslKeystoreLocationCheck && sslKeystorePasswordCheck && sslKeyPasswordCheck && sslTruststoreTypeCheck && sslTruststoreLocationCheck && sslTruststorePasswordCheck && configNames$1.forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.contains((Object)configName)));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfigEntry$1(boolean perBrokerConfig$1, DescribeConfigsResponseData.DescribeConfigsSynonym x$5) {
        return perBrokerConfig$1 || x$5.source() == DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG.id();
    }

    private static final void maybeAddSynonym$1(Map map, DescribeConfigsResponse.ConfigSource source, String name, boolean isSensitive$2, Buffer allSynonyms$1) {
        map.get((Object)name).map((Function1 & Serializable)value -> {
            String configValue = isSensitive$2 ? null : value;
            return (Buffer)allSynonyms$1.$plus$eq((Object)new DescribeConfigsResponseData.DescribeConfigsSynonym().setName(name).setValue(configValue).setSource(source.id()));
        });
    }

    public static final /* synthetic */ boolean $anonfun$configSynonyms$6(String name$2, DescribeConfigsResponseData.DescribeConfigsSynonym s) {
        String string = s.name();
        return string == null ? name$2 != null : !string.equals(name$2);
    }

    public ConfigHelper(MetadataCache metadataCache, KafkaConfig config, ConfigRepository configRepository, Option<AlterConfigPolicy> alterConfigPolicy, ClusterLinkFactory.LinkManager clusterLinkManager) {
        this.metadataCache = metadataCache;
        this.config = config;
        this.configRepository = configRepository;
        this.alterConfigPolicy = alterConfigPolicy;
        this.clusterLinkManager = clusterLinkManager;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$2$adapted(Map eta$0$1$1, boolean isSensitive$2, Buffer allSynonyms$1, String name) {
        ConfigHelper.maybeAddSynonym$1(eta$0$1$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, name, isSensitive$2, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$3$adapted(Map eta$0$2$1, boolean isSensitive$2, Buffer allSynonyms$1, String name) {
        ConfigHelper.maybeAddSynonym$1(eta$0$2$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, name, isSensitive$2, allSynonyms$1);
        return BoxedUnit.UNIT;
    }
}

