/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import kafka.controller.KafkaController;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.AutoTopicCreationManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerMutationQuota;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.ForwardingManager$;
import kafka.server.KafkaConfig;
import kafka.server.ZkAdminManager;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\u00055f\u0001\u0002\n\u0014\u0001aA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t[\u0001\u0011\t\u0011)A\u0005]!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u000bA\u0003A\u0011A)\t\u000fe\u0003!\u0019!C\u00055\"1a\u000e\u0001Q\u0001\nmCQa\u001c\u0001\u0005BADq!a\u0012\u0001\t\u0013\tI\u0005C\u0004\u0002h\u0001!I!!\u001b\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r!9\u00111\u0010\u0001\u0005\n\u0005u\u0004bBAB\u0001\u0011%\u0011Q\u0011\u0005\b\u0003+\u0003A\u0011BAL\u0011\u001d\t\t\u000b\u0001C\u0005\u0003G\u0013q\u0004R3gCVdG/Q;u_R{\u0007/[2De\u0016\fG/[8o\u001b\u0006t\u0017mZ3s\u0015\t!R#\u0001\u0004tKJ4XM\u001d\u0006\u0002-\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\u001a?\r\u0002\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0007C\u0001\u0011\"\u001b\u0005\u0019\u0012B\u0001\u0012\u0014\u0005a\tU\u000f^8U_BL7m\u0011:fCRLwN\\'b]\u0006<WM\u001d\t\u0003I\u001dj\u0011!\n\u0006\u0003MU\tQ!\u001e;jYNL!\u0001K\u0013\u0003\u000f1{wmZ5oO\u000611m\u001c8gS\u001e\u0004\"\u0001I\u0016\n\u00051\u001a\"aC&bM.\f7i\u001c8gS\u001e\fab\u00195b]:,G.T1oC\u001e,'\u000fE\u0002\u001b_EJ!\u0001M\u000e\u0003\r=\u0003H/[8o!\t\u0001#'\u0003\u00024'\t\u0001#I]8lKJ$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u00031\tG-\\5o\u001b\u0006t\u0017mZ3s!\rQrF\u000e\t\u0003A]J!\u0001O\n\u0003\u001di[\u0017\tZ7j]6\u000bg.Y4fe\u0006Q1m\u001c8ue>dG.\u001a:\u0011\u0007iy3\b\u0005\u0002=}5\tQH\u0003\u0002:+%\u0011q(\u0010\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\u0006\u0001rM]8va\u000e{wN\u001d3j]\u0006$xN\u001d\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000bQa\u001a:pkBT!AR\u000b\u0002\u0017\r|wN\u001d3j]\u0006$xN]\u0005\u0003\u0011\u000e\u0013\u0001c\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:\u0002\u001dQDhnQ8pe\u0012Lg.\u0019;peB\u00111JT\u0007\u0002\u0019*\u0011Q*R\u0001\fiJ\fgn]1di&|g.\u0003\u0002P\u0019\n1BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'/\u0001\u0004=S:LGO\u0010\u000b\b%N#VKV,Y!\t\u0001\u0003\u0001C\u0003*\u000f\u0001\u0007!\u0006C\u0003.\u000f\u0001\u0007a\u0006C\u00035\u000f\u0001\u0007Q\u0007C\u0003:\u000f\u0001\u0007!\bC\u0003A\u000f\u0001\u0007\u0011\tC\u0003J\u000f\u0001\u0007!*\u0001\bj]\u001ad\u0017n\u001a5u)>\u0004\u0018nY:\u0016\u0003m\u00032\u0001X1d\u001b\u0005i&B\u00010`\u0003\u0011)H/\u001b7\u000b\u0003\u0001\fAA[1wC&\u0011!-\u0018\u0002\u0004'\u0016$\bC\u00013l\u001d\t)\u0017\u000e\u0005\u0002g75\tqM\u0003\u0002i/\u00051AH]8pizJ!A[\u000e\u0002\rA\u0013X\rZ3g\u0013\taWN\u0001\u0004TiJLgn\u001a\u0006\u0003Un\tq\"\u001b8gY&<\u0007\u000e\u001e+pa&\u001c7\u000fI\u0001\rGJ,\u0017\r^3U_BL7m\u001d\u000b\bc\u0006\r\u00121FA\u001b!\r\u0011Xo^\u0007\u0002g*\u0011AoG\u0001\u000bG>dG.Z2uS>t\u0017B\u0001<t\u0005\r\u0019V-\u001d\t\u0004q\u0006uabA=\u0002\u00189\u0019!0!\u0005\u000f\u0007m\fYAD\u0002}\u0003\u000fq1!`A\u0001\u001d\t1g0C\u0001\u0000\u0003\ry'oZ\u0005\u0005\u0003\u0007\t)!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u007f&\u0019a#!\u0003\u000b\t\u0005\r\u0011QA\u0005\u0005\u0003\u001b\ty!\u0001\u0004d_6lwN\u001c\u0006\u0004-\u0005%\u0011\u0002BA\n\u0003+\tq!\\3tg\u0006<WM\u0003\u0003\u0002\u000e\u0005=\u0011\u0002BA\r\u00037\tA#T3uC\u0012\fG/\u0019*fgB|gn]3ECR\f'\u0002BA\n\u0003+IA!a\b\u0002\"\t)R*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a+pa&\u001c'\u0002BA\r\u00037Aq!!\n\u000b\u0001\u0004\t9#\u0001\u0004u_BL7m\u001d\t\u0005e\u0006%2-\u0003\u0002cg\"9\u0011Q\u0006\u0006A\u0002\u0005=\u0012aF2p]R\u0014x\u000e\u001c7fe6+H/\u0019;j_:\fVo\u001c;b!\r\u0001\u0013\u0011G\u0005\u0004\u0003g\u0019\"aF\"p]R\u0014x\u000e\u001c7fe6+H/\u0019;j_:\fVo\u001c;b\u0011\u001d\t9D\u0003a\u0001\u0003s\ta#\\3uC\u0012\fG/\u0019*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\t\u00055=\nY\u0004\u0005\u0003\u0002>\u0005\rSBAA \u0015\u0011\t\t%!\u0006\u0002\u0011I,\u0017/^3tiNLA!!\u0012\u0002@\tq!+Z9vKN$8i\u001c8uKb$\u0018\u0001E2sK\u0006$X\rV8qS\u000e\u001c\u0018J\u001c.l)\u001d\t\u00181JA2\u0003KBq!!\u0014\f\u0001\u0004\ty%A\bde\u0016\fG/\u00192mKR{\u0007/[2t!\u0019\u0011\u0018\u0011K2\u0002V%\u0019\u00111K:\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002X\u0005ucbA=\u0002Z%!\u00111LA\u000e\u0003]\u0019%/Z1uKR{\u0007/[2t%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0002`\u0005\u0005$AD\"sK\u0006$\u0018M\u00197f)>\u0004\u0018n\u0019\u0006\u0005\u00037\nY\u0002C\u0004\u0002.-\u0001\r!a\f\t\u000f\u0005]2\u00021\u0001\u0002:\u000512/\u001a8e\u0007J,\u0017\r^3U_BL7MU3rk\u0016\u001cH\u000fF\u0003r\u0003W\ni\u0007C\u0004\u0002N1\u0001\r!a\u0014\t\u000f\u0005]B\u00021\u0001\u0002:\u0005)2\r\\3be&sg\r\\5hQR\u0014V-];fgR\u001cH\u0003BA:\u0003s\u00022AGA;\u0013\r\t9h\u0007\u0002\u0005+:LG\u000fC\u0004\u0002N5\u0001\r!a\u0014\u0002\u001d\r\u0014X-\u0019;bE2,Gk\u001c9jGR!\u0011QKA@\u0011\u0019\t\tI\u0004a\u0001G\u0006)Ao\u001c9jG\u0006y2m\u001c8wKJ$Hk\u001c+pa&\u001c7i\u001c8gS\u001e\u001cu\u000e\u001c7fGRLwN\\:\u0015\t\u0005\u001d\u0015Q\u0012\t\u0005\u0003/\nI)\u0003\u0003\u0002\f\u0006\u0005$aH\"sK\u0006$X-\u00192mKR{\u0007/[2D_:4\u0017nZ\"pY2,7\r^5p]\"1\u0011f\u0004a\u0001\u0003\u001f\u00032\u0001XAI\u0013\r\t\u0019*\u0018\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001E5t-\u0006d\u0017\u000e\u001a+pa&\u001cg*Y7f)\u0011\tI*a(\u0011\u0007i\tY*C\u0002\u0002\u001en\u0011qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002\u0002B\u0001\raY\u0001\u0016M&dG/\u001a:De\u0016\fG/\u00192mKR{\u0007/[2t)\u0011\t)+a+\u0011\ri\t9+a\u0014r\u0013\r\tIk\u0007\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005\u0015\u0012\u00031\u0001\u0002(\u0001")
public class DefaultAutoTopicCreationManager
implements AutoTopicCreationManager,
Logging {
    private final KafkaConfig config;
    private final Option<BrokerToControllerChannelManager> channelManager;
    private final Option<ZkAdminManager> adminManager;
    private final Option<KafkaController> controller;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final java.util.Set<String> inflightTopics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private java.util.Set<String> inflightTopics() {
        return this.inflightTopics;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> createTopics(Set<String> topics, ControllerMutationQuota controllerMutationQuota, Option<RequestContext> metadataRequestContext) {
        void var6_6;
        void var5_5;
        Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> tuple2 = this.filterCreatableTopics(topics);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map creatableTopics = (Map)tuple2._1();
        Seq uncreatableTopicResponses = (Seq)tuple2._2();
        Seq<MetadataResponseData.MetadataResponseTopic> creatableTopicResponses = var5_5.isEmpty() ? (Seq<MetadataResponseData.MetadataResponseTopic>)Seq$.MODULE$.empty() : (this.controller.isEmpty() || !((KafkaController)this.controller.get()).isActive() && this.channelManager.isDefined() ? this.sendCreateTopicRequest((Map<String, CreateTopicsRequestData.CreatableTopic>)var5_5, metadataRequestContext) : this.createTopicsInZk((Map<String, CreateTopicsRequestData.CreatableTopic>)var5_5, controllerMutationQuota, metadataRequestContext));
        return (Seq)var6_6.$plus$plus((IterableOnce)creatableTopicResponses);
    }

    private Seq<MetadataResponseData.MetadataResponseTopic> createTopicsInZk(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics, ControllerMutationQuota controllerMutationQuota, Option<RequestContext> metadataRequestContext) {
        scala.collection.immutable.Seq seq;
        AtomicReference topicErrors = new AtomicReference();
        try {
            scala.collection.immutable.Seq seq2;
            ((ZkAdminManager)this.adminManager.get()).createTopics(0, false, creatableTopics, (Map<String, CreateTopicsResponseData.CreatableTopicResult>)((Map)scala.collection.Map$.MODULE$.empty()), controllerMutationQuota, (Option<KafkaPrincipal>)metadataRequestContext.map((Function1 & Serializable)x$2 -> x$2.principal), (Function1<Map<String, ApiError>, BoxedUnit>)(Function1 & Serializable)x$1 -> {
                topicErrors.set(x$1);
                return BoxedUnit.UNIT;
            });
            Option option = Option$.MODULE$.apply(topicErrors.get());
            if (option instanceof Some) {
                seq2 = (scala.collection.immutable.Seq)((Map)((Some)option).value()).toSeq().map((Function1 & Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    String topic = (String)x0$1._1();
                    Errors errors = ((ApiError)x0$1._2()).error();
                    boolean bl = Errors.TOPIC_ALREADY_EXISTS.equals(errors) ? true : Errors.REQUEST_TIMED_OUT.equals(errors);
                    Errors errors2 = bl ? Errors.LEADER_NOT_AVAILABLE : (Errors.POLICY_VIOLATION.equals(errors) ? Errors.TOPIC_AUTHORIZATION_FAILED : errors);
                    MetadataResponseData.MetadataResponseTopic metadataResponseTopic = new MetadataResponseData.MetadataResponseTopic().setErrorCode(errors2.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic));
                    return metadataResponseTopic;
                });
            } else if (None$.MODULE$.equals(option)) {
                seq2 = (scala.collection.immutable.Seq)creatableTopics.keySet().toSeq().map((Function1 & Serializable)topic -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)));
            } else {
                throw new MatchError((Object)option);
            }
            seq = seq2;
        }
        finally {
            this.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(creatableTopics);
        }
        return seq;
    }

    private Seq<MetadataResponseData.MetadataResponseTopic> sendCreateTopicRequest(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics, Option<RequestContext> metadataRequestContext) {
        CreateTopicsRequestData.CreatableTopicCollection topicsToCreate = new CreateTopicsRequestData.CreatableTopicCollection(creatableTopics.size());
        topicsToCreate.addAll(CollectionConverters$.MODULE$.IterableHasAsJava(creatableTopics.values()).asJavaCollection());
        CreateTopicsRequest.Builder createTopicsRequest = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTimeoutMs(Predef$.MODULE$.Integer2int(this.config.requestTimeoutMs())).setTopics(topicsToCreate));
        ControllerRequestCompletionHandler requestCompletionHandler = new ControllerRequestCompletionHandler(this, creatableTopics){
            private final /* synthetic */ DefaultAutoTopicCreationManager $outer;
            private final Map creatableTopics$1;

            public void onTimeout() {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests((Map<String, CreateTopicsRequestData.CreatableTopic>)this.creatableTopics$1);
                this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Auto topic creation timed out for ").append($this.creatableTopics$1.keys()).append(".").toString());
            }

            public void onComplete(ClientResponse response) {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests((Map<String, CreateTopicsRequestData.CreatableTopic>)this.creatableTopics$1);
                if (response.authenticationException() != null) {
                    this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Auto topic creation failed for ").append($this.creatableTopics$1.keys()).append(" with authentication exception").toString());
                    return;
                }
                if (response.versionMismatch() != null) {
                    this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Auto topic creation failed for ").append($this.creatableTopics$1.keys()).append(" with invalid version exception").toString());
                    return;
                }
                this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Auto topic creation completed for ").append($this.creatableTopics$1.keys()).append(" with response ").append(response.responseBody()).append(".").toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.creatableTopics$1 = creatableTopics$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$2(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$3(kafka.server.DefaultAutoTopicCreationManager$$anon$1 org.apache.kafka.clients.ClientResponse ), $anonfun$onTimeout$1(kafka.server.DefaultAutoTopicCreationManager$$anon$1 )}, serializedLambda);
            }
        };
        BrokerToControllerChannelManager channelManager = (BrokerToControllerChannelManager)this.channelManager.getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Channel manager must be defined in order to send CreateTopic requests.");
        });
        AbstractRequest.Builder request = (AbstractRequest.Builder)metadataRequestContext.map((Function1 & Serializable)context -> {
            short s;
            Option<NodeApiVersions> option = channelManager.controllerApiVersions();
            if (None$.MODULE$.equals(option)) {
                s = ApiKeys.CREATE_TOPICS.latestVersion();
            } else if (option instanceof Some) {
                s = ((NodeApiVersions)((Some)option).value()).latestUsableVersion(ApiKeys.CREATE_TOPICS);
            } else {
                throw new MatchError(option);
            }
            RequestHeader requestHeader = new RequestHeader(ApiKeys.CREATE_TOPICS, s, context.clientId(), context.correlationId());
            return ForwardingManager$.MODULE$.buildEnvelopeRequest((RequestContext)context, createTopicsRequest.build(s).serializeWithHeader(requestHeader));
        }).getOrElse((Function0 & Serializable)() -> createTopicsRequest);
        channelManager.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)request, requestCompletionHandler);
        scala.collection.immutable.Seq creatableTopicResponses = (scala.collection.immutable.Seq)creatableTopics.keySet().toSeq().map((Function1 & Serializable)topic -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)));
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Sent auto-creation request for ").append(creatableTopics.keys()).append(" to the active controller.").toString());
        return creatableTopicResponses;
    }

    public void kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics) {
        creatableTopics.keySet().foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultAutoTopicCreationManager.$anonfun$clearInflightRequests$1(this, x$1)));
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Cleared inflight topic creation state for ").append(creatableTopics).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CreateTopicsRequestData.CreatableTopic creatableTopic(String topic) {
        switch (topic == null ? 0 : topic.hashCode()) {
            case -970371369: {
                if (!"__consumer_offsets".equals(topic)) return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.numPartitions())).setReplicationFactor((short)this.config.defaultReplicationFactor());
                return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.offsetsTopicPartitions())).setReplicationFactor(Predef$.MODULE$.Short2short(this.config.offsetsTopicReplicationFactor())).setConfigs(this.convertToTopicConfigCollections(this.groupCoordinator.offsetsTopicConfigs()));
            }
            case -253293552: {
                if (!"__transaction_state".equals(topic)) return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.numPartitions())).setReplicationFactor((short)this.config.defaultReplicationFactor());
                return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.transactionTopicPartitions())).setReplicationFactor(Predef$.MODULE$.Short2short(this.config.transactionTopicReplicationFactor())).setConfigs(this.convertToTopicConfigCollections(this.txnCoordinator.transactionTopicConfigs()));
            }
            default: {
                return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.numPartitions())).setReplicationFactor((short)this.config.defaultReplicationFactor());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private CreateTopicsRequestData.CreateableTopicConfigCollection convertToTopicConfigCollections(Properties config) {
        void var2_2;
        CreateTopicsRequestData.CreateableTopicConfigCollection topicConfigs = new CreateTopicsRequestData.CreateableTopicConfigCollection();
        config.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(x0$1, x1$1) -> topicConfigs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName(x0$1.toString()).setValue(x1$1.toString()))));
        return var2_2;
    }

    private boolean isValidTopicName(String topic) {
        try {
            Topic.validate((String)topic);
            return true;
        }
        catch (InvalidTopicException invalidTopicException) {
            return false;
        }
    }

    private Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> filterCreatableTopics(Set<String> topics) {
        scala.collection.mutable.Map creatableTopics = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Buffer uncreatableTopics = (Buffer)Buffer$.MODULE$.empty();
        topics.foreach((Function1 & Serializable)topic -> {
            Option option;
            Some validationError;
            Object object = !this.isValidTopicName((String)topic) ? new Some((Object)Errors.INVALID_TOPIC_EXCEPTION) : (validationError = !this.inflightTopics().add((String)topic) ? new Some((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION) : None$.MODULE$);
            if (validationError instanceof Some) {
                Errors error = (Errors)validationError.value();
                option = uncreatableTopics.$plus$eq((Object)new MetadataResponseData.MetadataResponseTopic().setErrorCode(error.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)));
            } else if (None$.MODULE$.equals(validationError)) {
                option = creatableTopics.put(topic, (Object)this.creatableTopic((String)topic));
            } else {
                throw new MatchError((Object)validationError);
            }
            return option;
        });
        return new Tuple2((Object)creatableTopics, (Object)uncreatableTopics);
    }

    public static final /* synthetic */ boolean $anonfun$clearInflightRequests$1(DefaultAutoTopicCreationManager $this, Object x$1) {
        return $this.inflightTopics().remove(x$1);
    }

    public DefaultAutoTopicCreationManager(KafkaConfig config, Option<BrokerToControllerChannelManager> channelManager, Option<ZkAdminManager> adminManager, Option<KafkaController> controller, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator) {
        this.config = config;
        this.channelManager = channelManager;
        this.adminManager = adminManager;
        this.controller = controller;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        if (controller.isEmpty() && channelManager.isEmpty()) {
            throw new IllegalArgumentException("Must supply a channel manager if not supplying a controller");
        }
        this.inflightTopics = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

