/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_3_0_IV1$;
import kafka.cluster.EndPoint$;
import kafka.coordinator.group.OffsetConfig$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionStateManager$;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.common.config.SslClientAuth;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.internals.BrokerSecurityConfigs;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.raft.RaftConfig;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.Null$;

public final class Defaults$ {
    public static final Defaults$ MODULE$ = new Defaults$();
    private static final int ZkSessionTimeoutMs = 18000;
    private static final int ZkSyncTimeMs = 2000;
    private static final boolean ZkEnableSecureAcls = false;
    private static final int ZkMaxInFlightRequests = 10;
    private static final boolean ZkSslClientEnable = false;
    private static final String ZkSslProtocol = "TLSv1.2";
    private static final String ZkSslEndpointIdentificationAlgorithm = "HTTPS";
    private static final boolean ZkSslCrlEnable = false;
    private static final boolean ZkSslOcspEnable = false;
    private static final boolean BrokerIdGenerationEnable = true;
    private static final int MaxReservedBrokerId = 1000;
    private static final int BrokerId = -1;
    private static final int MessageMaxBytes = 0x10000C;
    private static final int NumNetworkThreads = 3;
    private static final int NumIoThreads = 8;
    private static final int BackgroundThreads = 10;
    private static final int QueuedMaxRequests = 500;
    private static final int QueuedMaxRequestBytes = -1;
    private static final int InitialBrokerRegistrationTimeoutMs = 60000;
    private static final int BrokerHeartbeatIntervalMs = 2000;
    private static final int BrokerSessionTimeoutMs = 9000;
    private static final int MetadataSnapshotMaxNewRecordBytes = 0x1400000;
    private static final int EmptyNodeId = -1;
    private static final String AuthorizerClassName = "";
    private static final String Listeners = "PLAINTEXT://:9092";
    private static final String ListenerSecurityProtocolMap = ((IterableOnceOps)EndPoint$.MODULE$.DefaultSecurityProtocolMap().map((Function1 & Serializable)x0$1 -> {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        ListenerName listenerName = (ListenerName)x0$1._1();
        SecurityProtocol securityProtocol = (SecurityProtocol)x0$1._2();
        String string = new StringBuilder(1).append(listenerName.value()).append(":").append(securityProtocol.name).toString();
        return string;
    })).mkString(",");
    private static final int SocketSendBufferBytes = 102400;
    private static final int SocketReceiveBufferBytes = 102400;
    private static final int SocketRequestMaxBytes = 0x6400000;
    private static final int MaxConnectionsPerIp = Integer.MAX_VALUE;
    private static final String MaxConnectionsPerIpOverrides = "";
    private static final int MaxConnections = Integer.MAX_VALUE;
    private static final int MaxConnectionCreationRate = Integer.MAX_VALUE;
    private static final long ConnectionsMaxIdleMs = 600000L;
    private static final int RequestTimeoutMs = 30000;
    private static final Long ConnectionSetupTimeoutMs = CommonClientConfigs.DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MS;
    private static final Long ConnectionSetupTimeoutMaxMs = CommonClientConfigs.DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS;
    private static final int FailedAuthenticationDelayMs = 100;
    private static final int NumPartitions = 1;
    private static final String LogDir = "/tmp/kafka-logs";
    private static final int LogSegmentBytes = 0x40000000;
    private static final int LogRollHours = 168;
    private static final int LogRollJitterHours = 0;
    private static final int LogRetentionHours = 168;
    private static final long LogRetentionBytes = -1L;
    private static final int LogDeletionMaxSegmentsPerRun = Integer.MAX_VALUE;
    private static final long LogCleanupIntervalMs = 300000L;
    private static final String Delete = "delete";
    private static final String Compact = "compact";
    private static final String LogCleanupPolicy = MODULE$.Delete();
    private static final int LogCleanerThreads = 1;
    private static final double LogCleanerIoMaxBytesPerSecond = Double.MAX_VALUE;
    private static final long LogCleanerDedupeBufferSize = 0x8000000L;
    private static final int LogCleanerIoBufferSize = 524288;
    private static final double LogCleanerDedupeBufferLoadFactor = 0.9;
    private static final int LogCleanerBackoffMs = 15000;
    private static final double LogCleanerMinCleanRatio = 0.5;
    private static final boolean LogCleanerEnable = true;
    private static final long LogCleanerDeleteRetentionMs = 86400000L;
    private static final long LogCleanerMinCompactionLagMs = 0L;
    private static final long LogCleanerMaxCompactionLagMs = Long.MAX_VALUE;
    private static final int LogIndexSizeMaxBytes = 0xA00000;
    private static final int LogIndexIntervalBytes = 4096;
    private static final long LogFlushIntervalMessages = Long.MAX_VALUE;
    private static final int LogDeleteDelayMs = 60000;
    private static final long LogFlushSchedulerIntervalMs = Long.MAX_VALUE;
    private static final int LogFlushOffsetCheckpointIntervalMs = 60000;
    private static final int LogFlushStartOffsetCheckpointIntervalMs = 60000;
    private static final boolean LogPreAllocateEnable = false;
    private static final String LogMessageFormatVersion = KAFKA_3_0_IV1$.MODULE$.version();
    private static final String LogMessageTimestampType = "CreateTime";
    private static final long LogMessageTimestampDifferenceMaxMs = Long.MAX_VALUE;
    private static final int NumRecoveryThreadsPerDataDir = 1;
    private static final boolean AutoCreateTopicsEnable = true;
    private static final int MinInSyncReplicas = 1;
    private static final boolean MessageDownConversionEnable = true;
    private static final int ControllerSocketTimeoutMs = MODULE$.RequestTimeoutMs();
    private static final int ControllerMessageQueueSize = Integer.MAX_VALUE;
    private static final int DefaultReplicationFactor = 1;
    private static final long ReplicaLagTimeMaxMs = 30000L;
    private static final int ReplicaSocketTimeoutMs = 30000;
    private static final int ReplicaSocketReceiveBufferBytes = 65536;
    private static final int ReplicaFetchMaxBytes = 0x100000;
    private static final int ReplicaFetchWaitMaxMs = 500;
    private static final int ReplicaFetchMinBytes = 1;
    private static final int ReplicaFetchResponseMaxBytes = 0xA00000;
    private static final int NumReplicaFetchers = 1;
    private static final int ReplicaFetchBackoffMs = 1000;
    private static final long ReplicaHighWatermarkCheckpointIntervalMs = 5000L;
    private static final int FetchPurgatoryPurgeIntervalRequests = 1000;
    private static final int ProducerPurgatoryPurgeIntervalRequests = 1000;
    private static final int DeleteRecordsPurgatoryPurgeIntervalRequests = 1;
    private static final boolean AutoLeaderRebalanceEnable = true;
    private static final int LeaderImbalancePerBrokerPercentage = 10;
    private static final int LeaderImbalanceCheckIntervalSeconds = 300;
    private static final boolean UncleanLeaderElectionEnable = false;
    private static final String InterBrokerSecurityProtocol = SecurityProtocol.PLAINTEXT.toString();
    private static final String InterBrokerProtocolVersion = ApiVersion$.MODULE$.latestVersion().toString();
    private static final int ControlledShutdownMaxRetries = 3;
    private static final int ControlledShutdownRetryBackoffMs = 5000;
    private static final boolean ControlledShutdownEnable = true;
    private static final int GroupMinSessionTimeoutMs = 6000;
    private static final int GroupMaxSessionTimeoutMs = 1800000;
    private static final int GroupInitialRebalanceDelayMs = 3000;
    private static final int GroupMaxSize = Integer.MAX_VALUE;
    private static final int OffsetMetadataMaxSize = OffsetConfig$.MODULE$.DefaultMaxMetadataSize();
    private static final int OffsetsLoadBufferSize = OffsetConfig$.MODULE$.DefaultLoadBufferSize();
    private static final short OffsetsTopicReplicationFactor = OffsetConfig$.MODULE$.DefaultOffsetsTopicReplicationFactor();
    private static final int OffsetsTopicPartitions = OffsetConfig$.MODULE$.DefaultOffsetsTopicNumPartitions();
    private static final int OffsetsTopicSegmentBytes = OffsetConfig$.MODULE$.DefaultOffsetsTopicSegmentBytes();
    private static final int OffsetsTopicCompressionCodec = OffsetConfig$.MODULE$.DefaultOffsetsTopicCompressionCodec().codec();
    private static final int OffsetsRetentionMinutes = 10080;
    private static final long OffsetsRetentionCheckIntervalMs = OffsetConfig$.MODULE$.DefaultOffsetsRetentionCheckIntervalMs();
    private static final int OffsetCommitTimeoutMs = OffsetConfig$.MODULE$.DefaultOffsetCommitTimeoutMs();
    private static final short OffsetCommitRequiredAcks = OffsetConfig$.MODULE$.DefaultOffsetCommitRequiredAcks();
    private static final int TransactionalIdExpirationMs = TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs();
    private static final int TransactionsMaxTimeoutMs = TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs();
    private static final int TransactionsTopicMinISR = TransactionLog$.MODULE$.DefaultMinInSyncReplicas();
    private static final int TransactionsLoadBufferSize = TransactionLog$.MODULE$.DefaultLoadBufferSize();
    private static final short TransactionsTopicReplicationFactor = TransactionLog$.MODULE$.DefaultReplicationFactor();
    private static final int TransactionsTopicPartitions = TransactionLog$.MODULE$.DefaultNumPartitions();
    private static final int TransactionsTopicSegmentBytes = TransactionLog$.MODULE$.DefaultSegmentBytes();
    private static final int TransactionsAbortTimedOutTransactionsCleanupIntervalMS = TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs();
    private static final int TransactionsRemoveExpiredTransactionsCleanupIntervalMS = TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs();
    private static final boolean TierFeature = false;
    private static final boolean TierEnable = false;
    private static final long TierMetadataMaxPollMs = 100L;
    private static final int TierMetadataRequestTimeoutMs = 30000;
    private static final Null$ TierMetadataBootstrapServers = null;
    private static final Null$ TierMetadataNamespace = null;
    private static final short TierMetadataNumPartitions = (short)50;
    private static final short TierMetadataReplicationFactor = (short)3;
    private static final String TierBackend = "";
    private static final Null$ TierS3Bucket = null;
    private static final Null$ TierS3Region = null;
    private static final String TierS3Prefix = "";
    private static final String TierS3SseAlgorithm = "AES256";
    private static final String TierS3SseCustomerEncryptionKey = null;
    private static final Null$ TierS3CredFilePath = null;
    private static final Null$ TierS3EndpointOverride = null;
    private static final boolean TierS3ForcePathStyleAccess = false;
    private static final Null$ TierS3SignerOverride = null;
    private static final Integer TierS3AutoAbortThresholdBytes = Predef$.MODULE$.int2Integer(500000);
    private static final String TierS3AssumeRoleArn = null;
    private static final String TierS3UserAgentPrefix = "APN/1.0 Confluent/1.0 TieredStorageS3/1.0";
    private static final String TierS3SslProtocol = SslConfigs.DEFAULT_SSL_PROTOCOL;
    private static final String TierS3SslEnabledProtocols = SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS;
    private static final String TierS3SslTrustStoreLocation = null;
    private static final Password TierS3SslTrustStorePassword = null;
    private static final String TierS3SslTrustStoreType = null;
    private static final String TierS3SslKeyStoreLocation = null;
    private static final Password TierS3SslKeyStorePassword = null;
    private static final String TierS3SslKeyStoreType = null;
    private static final Password TierS3SslKeyPassword = null;
    private static final Integer TierFetcherNumThreads = Predef$.MODULE$.int2Integer(4);
    private static final Integer TierFetcherOffsetCacheSize = Predef$.MODULE$.int2Integer(200000);
    private static final int TierFetcherOffsetCacheExpirationMs = 1800000;
    private static final int TierFetcherOffsetCacheExpiryPeriodMs = 60000;
    private static final int TierFetcherMemoryPoolSizeBytes = 0;
    private static final int TierMaxPartitionFetchBytesOverride = 0;
    private static final Integer TierObjectFetcherThreads = Predef$.MODULE$.int2Integer(1);
    private static final Integer TierPartitionStateCommitInterval = Predef$.MODULE$.int2Integer(15000);
    private static final Null$ TierGcsBucket = null;
    private static final String TierGcsPrefix = "";
    private static final Null$ TierGcsRegion = null;
    private static final int TierGcsWriteChunkSize = 0;
    private static final Null$ TierGcsCredFilePath = null;
    private static final String TierGcsSseCustomerEncryptionKey = null;
    private static final long TierTopicDeleteCheckIntervalMs = 300000L;
    private static final int TierTopicDeleteMaxInprogressPartitions = 100;
    private static final long PreferTierFetchMs = -1L;
    private static final Null$ TierAzureBlockBlobContainer = null;
    private static final String TierAzureBlockBlobPrefix = "";
    private static final Null$ TierAzureBlockBlobCredFilePath = null;
    private static final Null$ TierAzureBlockBlobEndpoint = null;
    private static final long TierLocalHotsetBytes = -1L;
    private static final long TierLocalHotsetMs = 86400000L;
    private static final long TierFencedSegmentDeleteDelayMs = 600000L;
    private static final Integer TierArchiverNumThreads = Predef$.MODULE$.int2Integer(2);
    private static final int TierSegmentHotsetRollMinBytes = 0x6400000;
    private static final long EncryptionKeyManagerKeyRotationIntervalMs = Duration.ofDays(365L).toMillis();
    private static final String TopicPlacementConstraints = "";
    private static final int MaxIncrementalFetchSessionCacheSlots = 1000;
    private static final int FetchMaxBytes = 0x3700000;
    private static final boolean FetchPartitionPruningEnable = true;
    private static final boolean SegmentSpeculativePrefetchEnable = false;
    private static final int StorageProbePeriodMs = -1;
    private static final int BrokerStartupRegistrationDelay = 0;
    private static final int DefaultNumQuotaSamples = 11;
    private static final int DefaultQuotaWindowSizeSeconds = 1;
    private static final long QuotaBytesPerSecond = Long.MAX_VALUE;
    private static final String NoThrottledReplicas = "none";
    private static final int NumQuotaSamples = MODULE$.DefaultNumQuotaSamples();
    private static final int QuotaWindowSizeSeconds = MODULE$.DefaultQuotaWindowSizeSeconds();
    private static final int NumReplicationQuotaSamples = MODULE$.DefaultNumQuotaSamples();
    private static final int ReplicationQuotaWindowSizeSeconds = MODULE$.DefaultQuotaWindowSizeSeconds();
    private static final long LeaderReplicationThrottledRate = MODULE$.QuotaBytesPerSecond();
    private static final long FollowerReplicationThrottledRate = MODULE$.QuotaBytesPerSecond();
    private static final String LeaderReplicationThrottledReplicas = MODULE$.NoThrottledReplicas();
    private static final String FollowerReplicationThrottledReplicas = MODULE$.NoThrottledReplicas();
    private static final int NumAlterLogDirsReplicationQuotaSamples = MODULE$.DefaultNumQuotaSamples();
    private static final int AlterLogDirsReplicationQuotaWindowSizeSeconds = MODULE$.DefaultQuotaWindowSizeSeconds();
    private static final int NumControllerQuotaSamples = MODULE$.DefaultNumQuotaSamples();
    private static final int ControllerQuotaWindowSizeSeconds = MODULE$.DefaultQuotaWindowSizeSeconds();
    private static final long ClusterLinkIoMaxBytesPerSecond = MODULE$.QuotaBytesPerSecond();
    private static final ConfluentConfigs.ClusterLinkQuotaMode ClusterLinkQuotaMode = ConfluentConfigs.ClusterLinkQuotaMode.CLUSTER_LINK_ONLY;
    private static final int NumClusterLinkReplicationQuotaSamples = MODULE$.DefaultNumQuotaSamples();
    private static final int ClusterLinkReplicationQuotaWindowSizeSeconds = 2;
    private static final int ClusterLinkFetchResponseMaxBytes = Integer.MAX_VALUE;
    private static final int ClusterLinkFetchResponseMinBytes = 1;
    private static final int TransactionalIdExpirationMsDefault = 604800000;
    private static final boolean DeleteTopicEnable = true;
    private static final String CompressionType = "producer";
    private static final int MaxIdMapSnapshots = 2;
    private static final int MetricNumSamples = 2;
    private static final int MetricSampleWindowMs = 30000;
    private static final String MetricReporterClasses = "";
    private static final String MetricRecordingLevel = Sensor.RecordingLevel.INFO.toString();
    private static final String KafkaMetricReporterClasses = "";
    private static final int KafkaMetricsPollingIntervalSeconds = 10;
    private static final String SslProtocol = SslConfigs.DEFAULT_SSL_PROTOCOL;
    private static final String SslEnabledProtocols = SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS;
    private static final String SslKeystoreType = "JKS";
    private static final String SslTruststoreType = "JKS";
    private static final String SslKeyManagerAlgorithm = SslConfigs.DEFAULT_SSL_KEYMANGER_ALGORITHM;
    private static final String SslTrustManagerAlgorithm = SslConfigs.DEFAULT_SSL_TRUSTMANAGER_ALGORITHM;
    private static final String SslEndpointIdentificationAlgorithm = "https";
    private static final String SslClientAuthentication = SslClientAuth.NONE.name().toLowerCase(Locale.ROOT);
    private static final String[] SslClientAuthenticationValidValues = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(SslClientAuth.VALUES).asScala().map((Function1 & Serializable)v -> v.toString().toLowerCase(Locale.ROOT))).asJava().toArray(new String[0]);
    private static final String SslPrincipalMappingRules = "DEFAULT";
    private static final String SslEngineFactoryClass = "org.apache.kafka.common.security.ssl.DefaultSslEngineFactory";
    private static final long ConnectionsMaxReauthMsDefault = 0L;
    private static final Class<DefaultKafkaPrincipalBuilder> DefaultPrincipalSerde = DefaultKafkaPrincipalBuilder.class;
    private static final String SaslMechanismInterBrokerProtocol = "GSSAPI";
    private static final List<String> SaslEnabledMechanisms = BrokerSecurityConfigs.DEFAULT_SASL_ENABLED_MECHANISMS;
    private static final String SaslKerberosKinitCmd = "/usr/bin/kinit";
    private static final double SaslKerberosTicketRenewWindowFactor = 0.8;
    private static final double SaslKerberosTicketRenewJitter = 0.05;
    private static final long SaslKerberosMinTimeBeforeRelogin = 60000L;
    private static final List<String> SaslKerberosPrincipalToLocalRules = BrokerSecurityConfigs.DEFAULT_SASL_KERBEROS_PRINCIPAL_TO_LOCAL_RULES;
    private static final double SaslLoginRefreshWindowFactor = 0.8;
    private static final double SaslLoginRefreshWindowJitter = 0.05;
    private static final short SaslLoginRefreshMinPeriodSeconds = (short)60;
    private static final short SaslLoginRefreshBufferSeconds = (short)300;
    private static final long DelegationTokenMaxLifeTimeMsDefault = 604800000L;
    private static final long DelegationTokenExpiryTimeMsDefault = 86400000L;
    private static final long DelegationTokenExpiryCheckIntervalMsDefault = 3600000L;
    private static final String PasswordEncoderCipherAlgorithm = "AES/CBC/PKCS5Padding";
    private static final int PasswordEncoderKeyLength = 128;
    private static final int PasswordEncoderIterations = 4096;
    private static final List<String> QuorumVoters = RaftConfig.DEFAULT_QUORUM_VOTERS;
    private static final int QuorumElectionTimeoutMs = 1000;
    private static final int QuorumFetchTimeoutMs = 2000;
    private static final int QuorumElectionBackoffMs = 1000;
    private static final int QuorumLingerMs = 25;
    private static final int QuorumRequestTimeoutMs = 2000;
    private static final int QuorumRetryBackoffMs = 20;

    public int ZkSessionTimeoutMs() {
        return ZkSessionTimeoutMs;
    }

    public int ZkSyncTimeMs() {
        return ZkSyncTimeMs;
    }

    public boolean ZkEnableSecureAcls() {
        return ZkEnableSecureAcls;
    }

    public int ZkMaxInFlightRequests() {
        return ZkMaxInFlightRequests;
    }

    public boolean ZkSslClientEnable() {
        return ZkSslClientEnable;
    }

    public String ZkSslProtocol() {
        return ZkSslProtocol;
    }

    public String ZkSslEndpointIdentificationAlgorithm() {
        return ZkSslEndpointIdentificationAlgorithm;
    }

    public boolean ZkSslCrlEnable() {
        return ZkSslCrlEnable;
    }

    public boolean ZkSslOcspEnable() {
        return ZkSslOcspEnable;
    }

    public boolean BrokerIdGenerationEnable() {
        return BrokerIdGenerationEnable;
    }

    public int MaxReservedBrokerId() {
        return MaxReservedBrokerId;
    }

    public int BrokerId() {
        return BrokerId;
    }

    public int MessageMaxBytes() {
        return MessageMaxBytes;
    }

    public int NumNetworkThreads() {
        return NumNetworkThreads;
    }

    public int NumIoThreads() {
        return NumIoThreads;
    }

    public int BackgroundThreads() {
        return BackgroundThreads;
    }

    public int QueuedMaxRequests() {
        return QueuedMaxRequests;
    }

    public int QueuedMaxRequestBytes() {
        return QueuedMaxRequestBytes;
    }

    public int InitialBrokerRegistrationTimeoutMs() {
        return InitialBrokerRegistrationTimeoutMs;
    }

    public int BrokerHeartbeatIntervalMs() {
        return BrokerHeartbeatIntervalMs;
    }

    public int BrokerSessionTimeoutMs() {
        return BrokerSessionTimeoutMs;
    }

    public int MetadataSnapshotMaxNewRecordBytes() {
        return MetadataSnapshotMaxNewRecordBytes;
    }

    public int EmptyNodeId() {
        return EmptyNodeId;
    }

    public String AuthorizerClassName() {
        return AuthorizerClassName;
    }

    public String Listeners() {
        return Listeners;
    }

    public String ListenerSecurityProtocolMap() {
        return ListenerSecurityProtocolMap;
    }

    public int SocketSendBufferBytes() {
        return SocketSendBufferBytes;
    }

    public int SocketReceiveBufferBytes() {
        return SocketReceiveBufferBytes;
    }

    public int SocketRequestMaxBytes() {
        return SocketRequestMaxBytes;
    }

    public int MaxConnectionsPerIp() {
        return MaxConnectionsPerIp;
    }

    public String MaxConnectionsPerIpOverrides() {
        return MaxConnectionsPerIpOverrides;
    }

    public int MaxConnections() {
        return MaxConnections;
    }

    public int MaxConnectionCreationRate() {
        return MaxConnectionCreationRate;
    }

    public long ConnectionsMaxIdleMs() {
        return ConnectionsMaxIdleMs;
    }

    public int RequestTimeoutMs() {
        return RequestTimeoutMs;
    }

    public Long ConnectionSetupTimeoutMs() {
        return ConnectionSetupTimeoutMs;
    }

    public Long ConnectionSetupTimeoutMaxMs() {
        return ConnectionSetupTimeoutMaxMs;
    }

    public int FailedAuthenticationDelayMs() {
        return FailedAuthenticationDelayMs;
    }

    public int NumPartitions() {
        return NumPartitions;
    }

    public String LogDir() {
        return LogDir;
    }

    public int LogSegmentBytes() {
        return LogSegmentBytes;
    }

    public int LogRollHours() {
        return LogRollHours;
    }

    public int LogRollJitterHours() {
        return LogRollJitterHours;
    }

    public int LogRetentionHours() {
        return LogRetentionHours;
    }

    public long LogRetentionBytes() {
        return LogRetentionBytes;
    }

    public int LogDeletionMaxSegmentsPerRun() {
        return LogDeletionMaxSegmentsPerRun;
    }

    public long LogCleanupIntervalMs() {
        return LogCleanupIntervalMs;
    }

    public String Delete() {
        return Delete;
    }

    public String Compact() {
        return Compact;
    }

    public String LogCleanupPolicy() {
        return LogCleanupPolicy;
    }

    public int LogCleanerThreads() {
        return LogCleanerThreads;
    }

    public double LogCleanerIoMaxBytesPerSecond() {
        return LogCleanerIoMaxBytesPerSecond;
    }

    public long LogCleanerDedupeBufferSize() {
        return LogCleanerDedupeBufferSize;
    }

    public int LogCleanerIoBufferSize() {
        return LogCleanerIoBufferSize;
    }

    public double LogCleanerDedupeBufferLoadFactor() {
        return LogCleanerDedupeBufferLoadFactor;
    }

    public int LogCleanerBackoffMs() {
        return LogCleanerBackoffMs;
    }

    public double LogCleanerMinCleanRatio() {
        return LogCleanerMinCleanRatio;
    }

    public boolean LogCleanerEnable() {
        return LogCleanerEnable;
    }

    public long LogCleanerDeleteRetentionMs() {
        return LogCleanerDeleteRetentionMs;
    }

    public long LogCleanerMinCompactionLagMs() {
        return LogCleanerMinCompactionLagMs;
    }

    public long LogCleanerMaxCompactionLagMs() {
        return LogCleanerMaxCompactionLagMs;
    }

    public int LogIndexSizeMaxBytes() {
        return LogIndexSizeMaxBytes;
    }

    public int LogIndexIntervalBytes() {
        return LogIndexIntervalBytes;
    }

    public long LogFlushIntervalMessages() {
        return LogFlushIntervalMessages;
    }

    public int LogDeleteDelayMs() {
        return LogDeleteDelayMs;
    }

    public long LogFlushSchedulerIntervalMs() {
        return LogFlushSchedulerIntervalMs;
    }

    public int LogFlushOffsetCheckpointIntervalMs() {
        return LogFlushOffsetCheckpointIntervalMs;
    }

    public int LogFlushStartOffsetCheckpointIntervalMs() {
        return LogFlushStartOffsetCheckpointIntervalMs;
    }

    public boolean LogPreAllocateEnable() {
        return LogPreAllocateEnable;
    }

    public String LogMessageFormatVersion() {
        return LogMessageFormatVersion;
    }

    public String LogMessageTimestampType() {
        return LogMessageTimestampType;
    }

    public long LogMessageTimestampDifferenceMaxMs() {
        return LogMessageTimestampDifferenceMaxMs;
    }

    public int NumRecoveryThreadsPerDataDir() {
        return NumRecoveryThreadsPerDataDir;
    }

    public boolean AutoCreateTopicsEnable() {
        return AutoCreateTopicsEnable;
    }

    public int MinInSyncReplicas() {
        return MinInSyncReplicas;
    }

    public boolean MessageDownConversionEnable() {
        return MessageDownConversionEnable;
    }

    public int ControllerSocketTimeoutMs() {
        return ControllerSocketTimeoutMs;
    }

    public int ControllerMessageQueueSize() {
        return ControllerMessageQueueSize;
    }

    public int DefaultReplicationFactor() {
        return DefaultReplicationFactor;
    }

    public long ReplicaLagTimeMaxMs() {
        return ReplicaLagTimeMaxMs;
    }

    public int ReplicaSocketTimeoutMs() {
        return ReplicaSocketTimeoutMs;
    }

    public int ReplicaSocketReceiveBufferBytes() {
        return ReplicaSocketReceiveBufferBytes;
    }

    public int ReplicaFetchMaxBytes() {
        return ReplicaFetchMaxBytes;
    }

    public int ReplicaFetchWaitMaxMs() {
        return ReplicaFetchWaitMaxMs;
    }

    public int ReplicaFetchMinBytes() {
        return ReplicaFetchMinBytes;
    }

    public int ReplicaFetchResponseMaxBytes() {
        return ReplicaFetchResponseMaxBytes;
    }

    public int NumReplicaFetchers() {
        return NumReplicaFetchers;
    }

    public int ReplicaFetchBackoffMs() {
        return ReplicaFetchBackoffMs;
    }

    public long ReplicaHighWatermarkCheckpointIntervalMs() {
        return ReplicaHighWatermarkCheckpointIntervalMs;
    }

    public int FetchPurgatoryPurgeIntervalRequests() {
        return FetchPurgatoryPurgeIntervalRequests;
    }

    public int ProducerPurgatoryPurgeIntervalRequests() {
        return ProducerPurgatoryPurgeIntervalRequests;
    }

    public int DeleteRecordsPurgatoryPurgeIntervalRequests() {
        return DeleteRecordsPurgatoryPurgeIntervalRequests;
    }

    public boolean AutoLeaderRebalanceEnable() {
        return AutoLeaderRebalanceEnable;
    }

    public int LeaderImbalancePerBrokerPercentage() {
        return LeaderImbalancePerBrokerPercentage;
    }

    public int LeaderImbalanceCheckIntervalSeconds() {
        return LeaderImbalanceCheckIntervalSeconds;
    }

    public boolean UncleanLeaderElectionEnable() {
        return UncleanLeaderElectionEnable;
    }

    public String InterBrokerSecurityProtocol() {
        return InterBrokerSecurityProtocol;
    }

    public String InterBrokerProtocolVersion() {
        return InterBrokerProtocolVersion;
    }

    public int ControlledShutdownMaxRetries() {
        return ControlledShutdownMaxRetries;
    }

    public int ControlledShutdownRetryBackoffMs() {
        return ControlledShutdownRetryBackoffMs;
    }

    public boolean ControlledShutdownEnable() {
        return ControlledShutdownEnable;
    }

    public int GroupMinSessionTimeoutMs() {
        return GroupMinSessionTimeoutMs;
    }

    public int GroupMaxSessionTimeoutMs() {
        return GroupMaxSessionTimeoutMs;
    }

    public int GroupInitialRebalanceDelayMs() {
        return GroupInitialRebalanceDelayMs;
    }

    public int GroupMaxSize() {
        return GroupMaxSize;
    }

    public int OffsetMetadataMaxSize() {
        return OffsetMetadataMaxSize;
    }

    public int OffsetsLoadBufferSize() {
        return OffsetsLoadBufferSize;
    }

    public short OffsetsTopicReplicationFactor() {
        return OffsetsTopicReplicationFactor;
    }

    public int OffsetsTopicPartitions() {
        return OffsetsTopicPartitions;
    }

    public int OffsetsTopicSegmentBytes() {
        return OffsetsTopicSegmentBytes;
    }

    public int OffsetsTopicCompressionCodec() {
        return OffsetsTopicCompressionCodec;
    }

    public int OffsetsRetentionMinutes() {
        return OffsetsRetentionMinutes;
    }

    public long OffsetsRetentionCheckIntervalMs() {
        return OffsetsRetentionCheckIntervalMs;
    }

    public int OffsetCommitTimeoutMs() {
        return OffsetCommitTimeoutMs;
    }

    public short OffsetCommitRequiredAcks() {
        return OffsetCommitRequiredAcks;
    }

    public int TransactionalIdExpirationMs() {
        return TransactionalIdExpirationMs;
    }

    public int TransactionsMaxTimeoutMs() {
        return TransactionsMaxTimeoutMs;
    }

    public int TransactionsTopicMinISR() {
        return TransactionsTopicMinISR;
    }

    public int TransactionsLoadBufferSize() {
        return TransactionsLoadBufferSize;
    }

    public short TransactionsTopicReplicationFactor() {
        return TransactionsTopicReplicationFactor;
    }

    public int TransactionsTopicPartitions() {
        return TransactionsTopicPartitions;
    }

    public int TransactionsTopicSegmentBytes() {
        return TransactionsTopicSegmentBytes;
    }

    public int TransactionsAbortTimedOutTransactionsCleanupIntervalMS() {
        return TransactionsAbortTimedOutTransactionsCleanupIntervalMS;
    }

    public int TransactionsRemoveExpiredTransactionsCleanupIntervalMS() {
        return TransactionsRemoveExpiredTransactionsCleanupIntervalMS;
    }

    public boolean TierFeature() {
        return TierFeature;
    }

    public boolean TierEnable() {
        return TierEnable;
    }

    public long TierMetadataMaxPollMs() {
        return TierMetadataMaxPollMs;
    }

    public int TierMetadataRequestTimeoutMs() {
        return TierMetadataRequestTimeoutMs;
    }

    public Null$ TierMetadataBootstrapServers() {
        return TierMetadataBootstrapServers;
    }

    public Null$ TierMetadataNamespace() {
        return TierMetadataNamespace;
    }

    public short TierMetadataNumPartitions() {
        return TierMetadataNumPartitions;
    }

    public short TierMetadataReplicationFactor() {
        return TierMetadataReplicationFactor;
    }

    public String TierBackend() {
        return TierBackend;
    }

    public Null$ TierS3Bucket() {
        return TierS3Bucket;
    }

    public Null$ TierS3Region() {
        return TierS3Region;
    }

    public String TierS3Prefix() {
        return TierS3Prefix;
    }

    public String TierS3SseAlgorithm() {
        return TierS3SseAlgorithm;
    }

    public String TierS3SseCustomerEncryptionKey() {
        return TierS3SseCustomerEncryptionKey;
    }

    public Null$ TierS3CredFilePath() {
        return TierS3CredFilePath;
    }

    public Null$ TierS3EndpointOverride() {
        return TierS3EndpointOverride;
    }

    public boolean TierS3ForcePathStyleAccess() {
        return TierS3ForcePathStyleAccess;
    }

    public Null$ TierS3SignerOverride() {
        return TierS3SignerOverride;
    }

    public Integer TierS3AutoAbortThresholdBytes() {
        return TierS3AutoAbortThresholdBytes;
    }

    public String TierS3AssumeRoleArn() {
        return TierS3AssumeRoleArn;
    }

    public String TierS3UserAgentPrefix() {
        return TierS3UserAgentPrefix;
    }

    public String TierS3SslProtocol() {
        return TierS3SslProtocol;
    }

    public String TierS3SslEnabledProtocols() {
        return TierS3SslEnabledProtocols;
    }

    public String TierS3SslTrustStoreLocation() {
        return TierS3SslTrustStoreLocation;
    }

    public Password TierS3SslTrustStorePassword() {
        return TierS3SslTrustStorePassword;
    }

    public String TierS3SslTrustStoreType() {
        return TierS3SslTrustStoreType;
    }

    public String TierS3SslKeyStoreLocation() {
        return TierS3SslKeyStoreLocation;
    }

    public Password TierS3SslKeyStorePassword() {
        return TierS3SslKeyStorePassword;
    }

    public String TierS3SslKeyStoreType() {
        return TierS3SslKeyStoreType;
    }

    public Password TierS3SslKeyPassword() {
        return TierS3SslKeyPassword;
    }

    public Integer TierFetcherNumThreads() {
        return TierFetcherNumThreads;
    }

    public Integer TierFetcherOffsetCacheSize() {
        return TierFetcherOffsetCacheSize;
    }

    public int TierFetcherOffsetCacheExpirationMs() {
        return TierFetcherOffsetCacheExpirationMs;
    }

    public int TierFetcherOffsetCacheExpiryPeriodMs() {
        return TierFetcherOffsetCacheExpiryPeriodMs;
    }

    public int TierFetcherMemoryPoolSizeBytes() {
        return TierFetcherMemoryPoolSizeBytes;
    }

    public int TierMaxPartitionFetchBytesOverride() {
        return TierMaxPartitionFetchBytesOverride;
    }

    public Integer TierObjectFetcherThreads() {
        return TierObjectFetcherThreads;
    }

    public Integer TierPartitionStateCommitInterval() {
        return TierPartitionStateCommitInterval;
    }

    public Null$ TierGcsBucket() {
        return TierGcsBucket;
    }

    public String TierGcsPrefix() {
        return TierGcsPrefix;
    }

    public Null$ TierGcsRegion() {
        return TierGcsRegion;
    }

    public int TierGcsWriteChunkSize() {
        return TierGcsWriteChunkSize;
    }

    public Null$ TierGcsCredFilePath() {
        return TierGcsCredFilePath;
    }

    public String TierGcsSseCustomerEncryptionKey() {
        return TierGcsSseCustomerEncryptionKey;
    }

    public long TierTopicDeleteCheckIntervalMs() {
        return TierTopicDeleteCheckIntervalMs;
    }

    public int TierTopicDeleteMaxInprogressPartitions() {
        return TierTopicDeleteMaxInprogressPartitions;
    }

    public long PreferTierFetchMs() {
        return PreferTierFetchMs;
    }

    public Null$ TierAzureBlockBlobContainer() {
        return TierAzureBlockBlobContainer;
    }

    public String TierAzureBlockBlobPrefix() {
        return TierAzureBlockBlobPrefix;
    }

    public Null$ TierAzureBlockBlobCredFilePath() {
        return TierAzureBlockBlobCredFilePath;
    }

    public Null$ TierAzureBlockBlobEndpoint() {
        return TierAzureBlockBlobEndpoint;
    }

    public long TierLocalHotsetBytes() {
        return TierLocalHotsetBytes;
    }

    public long TierLocalHotsetMs() {
        return TierLocalHotsetMs;
    }

    public long TierFencedSegmentDeleteDelayMs() {
        return TierFencedSegmentDeleteDelayMs;
    }

    public Integer TierArchiverNumThreads() {
        return TierArchiverNumThreads;
    }

    public int TierSegmentHotsetRollMinBytes() {
        return TierSegmentHotsetRollMinBytes;
    }

    public long EncryptionKeyManagerKeyRotationIntervalMs() {
        return EncryptionKeyManagerKeyRotationIntervalMs;
    }

    public String TopicPlacementConstraints() {
        return TopicPlacementConstraints;
    }

    public int MaxIncrementalFetchSessionCacheSlots() {
        return MaxIncrementalFetchSessionCacheSlots;
    }

    public int FetchMaxBytes() {
        return FetchMaxBytes;
    }

    public boolean FetchPartitionPruningEnable() {
        return FetchPartitionPruningEnable;
    }

    public boolean SegmentSpeculativePrefetchEnable() {
        return SegmentSpeculativePrefetchEnable;
    }

    public int StorageProbePeriodMs() {
        return StorageProbePeriodMs;
    }

    public int BrokerStartupRegistrationDelay() {
        return BrokerStartupRegistrationDelay;
    }

    public int DefaultNumQuotaSamples() {
        return DefaultNumQuotaSamples;
    }

    public int DefaultQuotaWindowSizeSeconds() {
        return DefaultQuotaWindowSizeSeconds;
    }

    public long QuotaBytesPerSecond() {
        return QuotaBytesPerSecond;
    }

    public String NoThrottledReplicas() {
        return NoThrottledReplicas;
    }

    public int NumQuotaSamples() {
        return NumQuotaSamples;
    }

    public int QuotaWindowSizeSeconds() {
        return QuotaWindowSizeSeconds;
    }

    public int NumReplicationQuotaSamples() {
        return NumReplicationQuotaSamples;
    }

    public int ReplicationQuotaWindowSizeSeconds() {
        return ReplicationQuotaWindowSizeSeconds;
    }

    public long LeaderReplicationThrottledRate() {
        return LeaderReplicationThrottledRate;
    }

    public long FollowerReplicationThrottledRate() {
        return FollowerReplicationThrottledRate;
    }

    public String LeaderReplicationThrottledReplicas() {
        return LeaderReplicationThrottledReplicas;
    }

    public String FollowerReplicationThrottledReplicas() {
        return FollowerReplicationThrottledReplicas;
    }

    public int NumAlterLogDirsReplicationQuotaSamples() {
        return NumAlterLogDirsReplicationQuotaSamples;
    }

    public int AlterLogDirsReplicationQuotaWindowSizeSeconds() {
        return AlterLogDirsReplicationQuotaWindowSizeSeconds;
    }

    public int NumControllerQuotaSamples() {
        return NumControllerQuotaSamples;
    }

    public int ControllerQuotaWindowSizeSeconds() {
        return ControllerQuotaWindowSizeSeconds;
    }

    public long ClusterLinkIoMaxBytesPerSecond() {
        return ClusterLinkIoMaxBytesPerSecond;
    }

    public ConfluentConfigs.ClusterLinkQuotaMode ClusterLinkQuotaMode() {
        return ClusterLinkQuotaMode;
    }

    public int NumClusterLinkReplicationQuotaSamples() {
        return NumClusterLinkReplicationQuotaSamples;
    }

    public int ClusterLinkReplicationQuotaWindowSizeSeconds() {
        return ClusterLinkReplicationQuotaWindowSizeSeconds;
    }

    public int ClusterLinkFetchResponseMaxBytes() {
        return ClusterLinkFetchResponseMaxBytes;
    }

    public int ClusterLinkFetchResponseMinBytes() {
        return ClusterLinkFetchResponseMinBytes;
    }

    public int TransactionalIdExpirationMsDefault() {
        return TransactionalIdExpirationMsDefault;
    }

    public boolean DeleteTopicEnable() {
        return DeleteTopicEnable;
    }

    public String CompressionType() {
        return CompressionType;
    }

    public int MaxIdMapSnapshots() {
        return MaxIdMapSnapshots;
    }

    public int MetricNumSamples() {
        return MetricNumSamples;
    }

    public int MetricSampleWindowMs() {
        return MetricSampleWindowMs;
    }

    public String MetricReporterClasses() {
        return MetricReporterClasses;
    }

    public String MetricRecordingLevel() {
        return MetricRecordingLevel;
    }

    public String KafkaMetricReporterClasses() {
        return KafkaMetricReporterClasses;
    }

    public int KafkaMetricsPollingIntervalSeconds() {
        return KafkaMetricsPollingIntervalSeconds;
    }

    public String SslProtocol() {
        return SslProtocol;
    }

    public String SslEnabledProtocols() {
        return SslEnabledProtocols;
    }

    public String SslKeystoreType() {
        return SslKeystoreType;
    }

    public String SslTruststoreType() {
        return SslTruststoreType;
    }

    public String SslKeyManagerAlgorithm() {
        return SslKeyManagerAlgorithm;
    }

    public String SslTrustManagerAlgorithm() {
        return SslTrustManagerAlgorithm;
    }

    public String SslEndpointIdentificationAlgorithm() {
        return SslEndpointIdentificationAlgorithm;
    }

    public String SslClientAuthentication() {
        return SslClientAuthentication;
    }

    public String[] SslClientAuthenticationValidValues() {
        return SslClientAuthenticationValidValues;
    }

    public String SslPrincipalMappingRules() {
        return SslPrincipalMappingRules;
    }

    public String SslEngineFactoryClass() {
        return SslEngineFactoryClass;
    }

    public long ConnectionsMaxReauthMsDefault() {
        return ConnectionsMaxReauthMsDefault;
    }

    public Class<DefaultKafkaPrincipalBuilder> DefaultPrincipalSerde() {
        return DefaultPrincipalSerde;
    }

    public String SaslMechanismInterBrokerProtocol() {
        return SaslMechanismInterBrokerProtocol;
    }

    public List<String> SaslEnabledMechanisms() {
        return SaslEnabledMechanisms;
    }

    public String SaslKerberosKinitCmd() {
        return SaslKerberosKinitCmd;
    }

    public double SaslKerberosTicketRenewWindowFactor() {
        return SaslKerberosTicketRenewWindowFactor;
    }

    public double SaslKerberosTicketRenewJitter() {
        return SaslKerberosTicketRenewJitter;
    }

    public long SaslKerberosMinTimeBeforeRelogin() {
        return SaslKerberosMinTimeBeforeRelogin;
    }

    public List<String> SaslKerberosPrincipalToLocalRules() {
        return SaslKerberosPrincipalToLocalRules;
    }

    public double SaslLoginRefreshWindowFactor() {
        return SaslLoginRefreshWindowFactor;
    }

    public double SaslLoginRefreshWindowJitter() {
        return SaslLoginRefreshWindowJitter;
    }

    public short SaslLoginRefreshMinPeriodSeconds() {
        return SaslLoginRefreshMinPeriodSeconds;
    }

    public short SaslLoginRefreshBufferSeconds() {
        return SaslLoginRefreshBufferSeconds;
    }

    public long DelegationTokenMaxLifeTimeMsDefault() {
        return DelegationTokenMaxLifeTimeMsDefault;
    }

    public long DelegationTokenExpiryTimeMsDefault() {
        return DelegationTokenExpiryTimeMsDefault;
    }

    public long DelegationTokenExpiryCheckIntervalMsDefault() {
        return DelegationTokenExpiryCheckIntervalMsDefault;
    }

    public String PasswordEncoderCipherAlgorithm() {
        return PasswordEncoderCipherAlgorithm;
    }

    public int PasswordEncoderKeyLength() {
        return PasswordEncoderKeyLength;
    }

    public int PasswordEncoderIterations() {
        return PasswordEncoderIterations;
    }

    public List<String> QuorumVoters() {
        return QuorumVoters;
    }

    public int QuorumElectionTimeoutMs() {
        return QuorumElectionTimeoutMs;
    }

    public int QuorumFetchTimeoutMs() {
        return QuorumFetchTimeoutMs;
    }

    public int QuorumElectionBackoffMs() {
        return QuorumElectionBackoffMs;
    }

    public int QuorumLingerMs() {
        return QuorumLingerMs;
    }

    public int QuorumRequestTimeoutMs() {
        return QuorumRequestTimeoutMs;
    }

    public int QuorumRetryBackoffMs() {
        return QuorumRetryBackoffMs;
    }

    private Defaults$() {
    }
}

