/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kafka.server.FetchContext;
import kafka.server.FetchContext$;
import kafka.server.FetchSessionCache;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.server.PartitionFetchMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\rb\u0001B\b\u0011\u0001UA\u0001\u0002\t\u0001\u0003\u0006\u0004%I!\t\u0005\t_\u0001\u0011\t\u0011)A\u0005E!A\u0001\u0007\u0001BC\u0002\u0013%\u0011\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u00033\u0011!1\u0004A!b\u0001\n\u00139\u0004\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011!\u0003!Q1A\u0005\n%C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\u0006\u001d\u0002!\ta\u0014\u0005\u0006\u001d\u0002!\t!\u0016\u0005\u0006C\u0002!\tE\u0019\u0005\u0006W\u0002!\t\u0005\u001c\u0005\u0006k\u0002!\tE\u001e\u0005\b\u0003#\u0001A\u0011IA\n\u0005A1U\u000f\u001c7GKR\u001c\u0007nQ8oi\u0016DHO\u0003\u0002\u0012%\u000511/\u001a:wKJT\u0011aE\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001a\u0003\b\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005uqR\"\u0001\t\n\u0005}\u0001\"\u0001\u0004$fi\u000eD7i\u001c8uKb$\u0018\u0001\u0002;j[\u0016,\u0012A\t\t\u0003G5j\u0011\u0001\n\u0006\u0003K\u0019\nQ!\u001e;jYNT!a\n\u0015\u0002\r\r|W.\\8o\u0015\t\u0019\u0012F\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<\u0017B\u0001\u0018%\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u000b\r\f7\r[3\u0016\u0003I\u0002\"!H\u001a\n\u0005Q\u0002\"!\u0005$fi\u000eD7+Z:tS>t7)Y2iK\u000611-Y2iK\u0002\n\u0011BZ3uG\"$\u0015\r^1\u0016\u0003a\u0002B!\u000f A\t6\t!H\u0003\u0002<y\u0005!Q\u000f^5m\u0015\u0005i\u0014\u0001\u00026bm\u0006L!a\u0010\u001e\u0003\u00075\u000b\u0007\u000f\u0005\u0002B\u00056\ta%\u0003\u0002DM\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007CA\u000fF\u0013\t1\u0005C\u0001\fQCJ$\u0018\u000e^5p]\u001a+Go\u00195NKR\fG-\u0019;b\u0003)1W\r^2i\t\u0006$\u0018\rI\u0001\u000fSN4%o\\7G_2dwn^3s+\u0005Q\u0005CA\fL\u0013\ta\u0005DA\u0004C_>dW-\u00198\u0002\u001f%\u001chI]8n\r>dGn\\<fe\u0002\na\u0001P5oSRtD#\u0002)R%N#\u0006CA\u000f\u0001\u0011\u0015\u0001\u0013\u00021\u0001#\u0011\u0015\u0001\u0014\u00021\u00013\u0011\u00151\u0014\u00021\u00019\u0011\u0015A\u0015\u00021\u0001K)\u0015\u0001fk\u0016-a\u0011\u0015\u0001#\u00021\u0001#\u0011\u0015\u0001$\u00021\u00013\u0011\u0015I&\u00021\u0001[\u000311W\r^2i%\u0016\fX/Z:u!\tYf,D\u0001]\u0015\tif%A\u0004nKN\u001c\u0018mZ3\n\u0005}c&\u0001\u0005$fi\u000eD'+Z9vKN$H)\u0019;b\u0011\u0015A%\u00021\u0001K\u000399W\r\u001e$fi\u000eDwJ\u001a4tKR$\"aY5\u0011\u0007]!g-\u0003\u0002f1\t1q\n\u001d;j_:\u0004\"aF4\n\u0005!D\"\u0001\u0002'p]\u001eDQA[\u0006A\u0002\u0001\u000bA\u0001]1si\u0006\u0001bm\u001c:fC\u000eD\u0007+\u0019:uSRLwN\u001c\u000b\u0003[B\u0004\"a\u00068\n\u0005=D\"\u0001B+oSRDQ!\u001d\u0007A\u0002I\f1AZ;o!\u001592\u000f\u0011#n\u0013\t!\bDA\u0005Gk:\u001cG/[8oe\u0005yq-\u001a;SKN\u0004xN\\:f'&TX\r\u0006\u0003xu\u0006\u001d\u0001CA\fy\u0013\tI\bDA\u0002J]RDQa_\u0007A\u0002q\fq!\u001e9eCR,7\u000fE\u0002~\u0003\u0003q!!\b@\n\u0005}\u0004\u0012\u0001\u0004$fi\u000eD7+Z:tS>t\u0017\u0002BA\u0002\u0003\u000b\u0011\u0001BU#T!~k\u0015\t\u0015\u0006\u0003\u007fBAq!!\u0003\u000e\u0001\u0004\tY!A\u0005wKJ\u001c\u0018n\u001c8JIB\u0019q#!\u0004\n\u0007\u0005=\u0001DA\u0003TQ>\u0014H/A\u000fva\u0012\fG/Z!oI\u001e+g.\u001a:bi\u0016\u0014Vm\u001d9p]N,G)\u0019;b)\u0011\t)\"!\t\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007'\u0003!\u0011X-];fgR\u001c\u0018\u0002BA\u0010\u00033\u0011QBR3uG\"\u0014Vm\u001d9p]N,\u0007\"B>\u000f\u0001\u0004a\b")
public class FullFetchContext
implements FetchContext {
    private final Time time;
    private final FetchSessionCache cache;
    private final Map<TopicPartition, PartitionFetchMetadata> fetchData;
    private final boolean isFromFollower;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String partitionsToLogString(Collection<TopicPartition> partitions) {
        return FetchContext.partitionsToLogString$(this, partitions);
    }

    @Override
    public FetchResponse getThrottledResponse(int throttleTimeMs) {
        return FetchContext.getThrottledResponse$(this, throttleTimeMs);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private FetchSessionCache cache() {
        return this.cache;
    }

    private Map<TopicPartition, PartitionFetchMetadata> fetchData() {
        return this.fetchData;
    }

    private boolean isFromFollower() {
        return this.isFromFollower;
    }

    @Override
    public Option<Object> getFetchOffset(TopicPartition part) {
        return Option$.MODULE$.apply((Object)this.fetchData().get(part)).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.fetchOffset()));
    }

    @Override
    public void foreachPartition(Function2<TopicPartition, PartitionFetchMetadata, BoxedUnit> fun) {
        this.fetchData().forEach((topicPartition, partition) -> fun.apply(topicPartition, partition));
    }

    @Override
    public int getResponseSize(LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> updates, short versionId) {
        return FetchResponse.sizeOf((short)versionId, updates.entrySet().iterator());
    }

    @Override
    public FetchResponse updateAndGenerateResponseData(LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> updates) {
        int responseSessionId = this.cache().maybeCreateSession(this.time().milliseconds(), this.isFromFollower(), updates.size(), (Function0<ImplicitLinkedHashCollection<IncrementalPartitionFetchMetadata>>)(Function0 & Serializable)() -> this.createNewSession$1(updates));
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(46).append("Full fetch context with session id ").append(responseSessionId).append(" returning ").toString()).append(String.valueOf(this.partitionsToLogString(updates.keySet()))).toString());
        return FetchResponse.of((Errors)Errors.NONE, (int)0, (int)responseSessionId, updates);
    }

    /*
     * WARNING - void declaration
     */
    private final ImplicitLinkedHashCollection createNewSession$1(LinkedHashMap updates$2) {
        void var2_2;
        ImplicitLinkedHashCollection cachedPartitions = new ImplicitLinkedHashCollection(updates$2.size());
        updates$2.forEach((part, respData) -> {
            PartitionFetchMetadata reqData = this.fetchData().get(part);
            IncrementalPartitionFetchMetadata cachedPartition = new IncrementalPartitionFetchMetadata((TopicPartition)part, reqData);
            cachedPartition.maybeUpdateResponseData((FetchResponseData.PartitionData)respData, true);
            cachedPartitions.mustAdd((ImplicitLinkedHashCollection.Element)cachedPartition);
        });
        return var2_2;
    }

    public FullFetchContext(Time time, FetchSessionCache cache, Map<TopicPartition, PartitionFetchMetadata> fetchData, boolean isFromFollower) {
        this.time = time;
        this.cache = cache;
        this.fetchData = fetchData;
        this.isFromFollower = isFromFollower;
    }

    public FullFetchContext(Time time, FetchSessionCache cache, FetchRequestData fetchRequest, boolean isFromFollower) {
        this(time, cache, FetchContext$.MODULE$.createFetchPartitions(fetchRequest), isFromFollower);
    }
}

