/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import kafka.server.FetchContext;
import kafka.server.FetchSession;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.server.PartitionFetchMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005\u0005-e\u0001B\r\u001b\u0001}A\u0001B\u000b\u0001\u0003\u0006\u0004%Ia\u000b\u0005\ts\u0001\u0011\t\u0011)A\u0005Y!A!\b\u0001BC\u0002\u0013%1\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003=\u0011!\u0001\u0005A!b\u0001\n\u0013\t\u0005\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u000b\u0019\u0003A\u0011A$\t\u000b1\u0003A\u0011I'\t\u000bi\u0003A\u0011I.\u0007\t\u001d\u0004A\u0001\u001b\u0005\tq*\u0011)\u0019!C\u0001s\"A!P\u0003B\u0001B\u0003%\u0011\u000f\u0003\u0005|\u0015\t\u0015\r\u0011\"\u0001}\u0011%\t\tA\u0003B\u0001B\u0003%Q\u0010\u0003\u0004G\u0015\u0011\u0005\u00111\u0001\u0005\n\u0003\u001bQ\u0001\u0019!C\u0001\u0003\u001fA\u0011\"!\u0010\u000b\u0001\u0004%\t!a\u0010\t\u0011\u0005\u0015#\u0002)Q\u0005\u0003#Aq!a\u0012\u000b\t\u0003\nI\u0005C\u0004\u0002L)!\t%!\u0014\t\u000f\u0005=#\u0002\"\u0011\u0002R!9\u0011\u0011\f\u0001\u0005B\u0005m\u0003bBA9\u0001\u0011\u0005\u00131\u000f\u0005\b\u0003\u0007\u0003A\u0011IAC\u0005]Ien\u0019:f[\u0016tG/\u00197GKR\u001c\u0007nQ8oi\u0016DHO\u0003\u0002\u001c9\u000511/\u001a:wKJT\u0011!H\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001E\n\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u001dBS\"\u0001\u000e\n\u0005%R\"\u0001\u0004$fi\u000eD7i\u001c8uKb$\u0018\u0001\u0002;j[\u0016,\u0012\u0001\f\t\u0003[]j\u0011A\f\u0006\u0003_A\nQ!\u001e;jYNT!!\r\u001a\u0002\r\r|W.\\8o\u0015\ti2G\u0003\u00025k\u00051\u0011\r]1dQ\u0016T\u0011AN\u0001\u0004_J<\u0017B\u0001\u001d/\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u0019I,\u0017/^3ti\u0016\u0003xn\u00195\u0016\u0003q\u0002\"!I\u001f\n\u0005y\u0012#aA%oi\u0006i!/Z9vKN$X\t]8dQ\u0002\nqa]3tg&|g.F\u0001C!\t93)\u0003\u0002E5\taa)\u001a;dQN+7o]5p]\u0006A1/Z:tS>t\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005\u0011&S5\n\u0005\u0002(\u0001!)!f\u0002a\u0001Y!)!h\u0002a\u0001y!)\u0001i\u0002a\u0001\u0005\u0006qq-\u001a;GKR\u001c\u0007n\u00144gg\u0016$HC\u0001(U!\r\ts*U\u0005\u0003!\n\u0012aa\u00149uS>t\u0007CA\u0011S\u0013\t\u0019&E\u0001\u0003M_:<\u0007\"B+\t\u0001\u00041\u0016A\u0001;q!\t9\u0006,D\u00011\u0013\tI\u0006G\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002!\u0019|'/Z1dQB\u000b'\u000f^5uS>tGC\u0001/`!\t\tS,\u0003\u0002_E\t!QK\\5u\u0011\u0015\u0001\u0017\u00021\u0001b\u0003\r1WO\u001c\t\u0006C\t4F\rX\u0005\u0003G\n\u0012\u0011BR;oGRLwN\u001c\u001a\u0011\u0005\u001d*\u0017B\u00014\u001b\u0005Y\u0001\u0016M\u001d;ji&|gNR3uG\"lU\r^1eCR\f'!\u0005)beRLG/[8o\u0013R,'/\u0019;peN\u0019!\"[9\u0011\u0005)|W\"A6\u000b\u00051l\u0017\u0001\u00027b]\u001eT\u0011A\\\u0001\u0005U\u00064\u0018-\u0003\u0002qW\n1qJ\u00196fGR\u0004\"A];\u000f\u0005\u001d\u001a\u0018B\u0001;\u001b\u000311U\r^2i'\u0016\u001c8/[8o\u0013\t1xOA\u0007S\u000bN\u0003v,T!Q?&#VI\u0015\u0006\u0003ij\tA!\u001b;feV\t\u0011/A\u0003ji\u0016\u0014\b%A\u0013va\u0012\fG/\u001a$fi\u000eD7i\u001c8uKb$\u0018I\u001c3SK6|g/Z+og\u0016dWm\u0019;fIV\tQ\u0010\u0005\u0002\"}&\u0011qP\t\u0002\b\u0005>|G.Z1o\u0003\u0019*\b\u000fZ1uK\u001a+Go\u00195D_:$X\r\u001f;B]\u0012\u0014V-\\8wKVs7/\u001a7fGR,G\r\t\u000b\u0007\u0003\u000b\tI!a\u0003\u0011\u0007\u0005\u001d!\"D\u0001\u0001\u0011\u0015Ax\u00021\u0001r\u0011\u0015Yx\u00021\u0001~\u0003-qW\r\u001f;FY\u0016lWM\u001c;\u0016\u0005\u0005E\u0001cBA\n\u0003G1\u0016\u0011\u0006\b\u0005\u0003+\tiB\u0004\u0003\u0002\u0018\u0005eQ\"A7\n\u0007\u0005mQ.\u0001\u0003vi&d\u0017\u0002BA\u0010\u0003C\t1!T1q\u0015\r\tY\"\\\u0005\u0005\u0003K\t9CA\u0003F]R\u0014\u0018P\u0003\u0003\u0002 \u0005\u0005\u0002\u0003BA\u0016\u0003oqA!!\f\u000245\u0011\u0011q\u0006\u0006\u0004\u0003c\u0001\u0014aB7fgN\fw-Z\u0005\u0005\u0003k\ty#A\tGKR\u001c\u0007NU3ta>t7/\u001a#bi\u0006LA!!\u000f\u0002<\ti\u0001+\u0019:uSRLwN\u001c#bi\u0006TA!!\u000e\u00020\u0005ya.\u001a=u\u000b2,W.\u001a8u?\u0012*\u0017\u000fF\u0002]\u0003\u0003B\u0011\"a\u0011\u0012\u0003\u0003\u0005\r!!\u0005\u0002\u0007a$\u0013'\u0001\u0007oKb$X\t\\3nK:$\b%A\u0004iCNtU\r\u001f;\u0015\u0003u\fAA\\3yiR\u0011\u0011\u0011C\u0001\u0007e\u0016lwN^3\u0015\u0005\u0005M\u0003cA\u0011\u0002V%\u0019\u0011q\u000b\u0012\u0003\u000f9{G\u000f[5oO\u0006yq-\u001a;SKN\u0004xN\\:f'&TX\rF\u0003=\u0003;\n9\u0007C\u0004\u0002`Y\u0001\r!!\u0019\u0002\u000fU\u0004H-\u0019;fgB\u0019!/a\u0019\n\u0007\u0005\u0015tO\u0001\u0005S\u000bN\u0003v,T!Q\u0011\u001d\tIG\u0006a\u0001\u0003W\n\u0011B^3sg&|g.\u00133\u0011\u0007\u0005\ni'C\u0002\u0002p\t\u0012Qa\u00155peR\fQ$\u001e9eCR,\u0017I\u001c3HK:,'/\u0019;f%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u000b\u0005\u0003k\n\t\t\u0005\u0003\u0002x\u0005uTBAA=\u0015\r\tY\bM\u0001\te\u0016\fX/Z:ug&!\u0011qPA=\u000551U\r^2i%\u0016\u001c\bo\u001c8tK\"9\u0011qL\fA\u0002\u0005\u0005\u0014\u0001F4fiRC'o\u001c;uY\u0016$'+Z:q_:\u001cX\r\u0006\u0003\u0002v\u0005\u001d\u0005BBAE1\u0001\u0007A(\u0001\buQJ|G\u000f\u001e7f)&lW-T:")
public class IncrementalFetchContext
implements FetchContext {
    private final Time time;
    private final int requestEpoch;
    private final FetchSession kafka$server$IncrementalFetchContext$$session;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String partitionsToLogString(Collection<TopicPartition> partitions) {
        return FetchContext.partitionsToLogString$(this, partitions);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private int requestEpoch() {
        return this.requestEpoch;
    }

    public FetchSession kafka$server$IncrementalFetchContext$$session() {
        return this.kafka$server$IncrementalFetchContext$$session;
    }

    @Override
    public Option<Object> getFetchOffset(TopicPartition tp) {
        return this.kafka$server$IncrementalFetchContext$$session().getFetchOffset(tp);
    }

    @Override
    public void foreachPartition(Function2<TopicPartition, PartitionFetchMetadata, BoxedUnit> fun) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            this.kafka$server$IncrementalFetchContext$$session().partitionMap().forEach(partition -> fun.apply((Object)new TopicPartition(partition.topic(), partition.partition()), partition));
            return;
        }
    }

    @Override
    public int getResponseSize(LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> updates, short versionId) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.requestEpoch());
            int n = this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch ? FetchResponse.sizeOf((short)versionId, new LinkedHashMap().entrySet().iterator()) : FetchResponse.sizeOf((short)versionId, (Iterator)new PartitionIterator(this, updates.entrySet().iterator(), false));
            return n;
        }
    }

    @Override
    public FetchResponse updateAndGenerateResponseData(LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> updates) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            FetchResponse fetchResponse;
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.requestEpoch());
            if (this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Incremental fetch session ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" expected epoch ").append(expectedEpoch).append(", but ").toString()).append(new StringBuilder(34).append("got ").append(this.kafka$server$IncrementalFetchContext$$session().epoch()).append(".  Possible duplicate request.").toString()).toString());
                fetchResponse = FetchResponse.of((Errors)Errors.INVALID_FETCH_SESSION_EPOCH, (int)0, (int)this.kafka$server$IncrementalFetchContext$$session().id(), new LinkedHashMap());
            } else {
                PartitionIterator partitionIter = new PartitionIterator(this, updates.entrySet().iterator(), true);
                while (partitionIter.hasNext()) {
                    partitionIter.next();
                }
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(53).append("Incremental fetch context with session id ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" returning ").toString()).append(String.valueOf(this.partitionsToLogString(updates.keySet()))).toString());
                fetchResponse = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)this.kafka$server$IncrementalFetchContext$$session().id(), updates);
            }
            FetchResponse fetchResponse2 = fetchResponse;
            return fetchResponse2;
        }
    }

    @Override
    public FetchResponse getThrottledResponse(int throttleTimeMs) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            FetchResponse fetchResponse;
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.requestEpoch());
            if (this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Incremental fetch session ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" expected epoch ").append(expectedEpoch).append(", but ").toString()).append(new StringBuilder(34).append("got ").append(this.kafka$server$IncrementalFetchContext$$session().epoch()).append(".  Possible duplicate request.").toString()).toString());
                fetchResponse = FetchResponse.of((Errors)Errors.INVALID_FETCH_SESSION_EPOCH, (int)throttleTimeMs, (int)this.kafka$server$IncrementalFetchContext$$session().id(), new LinkedHashMap());
            } else {
                fetchResponse = FetchResponse.of((Errors)Errors.NONE, (int)throttleTimeMs, (int)this.kafka$server$IncrementalFetchContext$$session().id(), new LinkedHashMap());
            }
            FetchResponse fetchResponse2 = fetchResponse;
            return fetchResponse2;
        }
    }

    public IncrementalFetchContext(Time time, int requestEpoch, FetchSession session) {
        this.time = time;
        this.requestEpoch = requestEpoch;
        this.kafka$server$IncrementalFetchContext$$session = session;
    }

    private class PartitionIterator
    implements Iterator<Map.Entry<TopicPartition, FetchResponseData.PartitionData>> {
        private final Iterator<Map.Entry<TopicPartition, FetchResponseData.PartitionData>> iter;
        private final boolean updateFetchContextAndRemoveUnselected;
        private Map.Entry<TopicPartition, FetchResponseData.PartitionData> nextElement;
        public final /* synthetic */ IncrementalFetchContext $outer;

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<TopicPartition, FetchResponseData.PartitionData>> x$1) {
            Iterator.super.forEachRemaining(x$1);
        }

        public Iterator<Map.Entry<TopicPartition, FetchResponseData.PartitionData>> iter() {
            return this.iter;
        }

        public boolean updateFetchContextAndRemoveUnselected() {
            return this.updateFetchContextAndRemoveUnselected;
        }

        public Map.Entry<TopicPartition, FetchResponseData.PartitionData> nextElement() {
            return this.nextElement;
        }

        public void nextElement_$eq(Map.Entry<TopicPartition, FetchResponseData.PartitionData> x$1) {
            this.nextElement = x$1;
        }

        @Override
        public boolean hasNext() {
            while (this.nextElement() == null && this.iter().hasNext()) {
                Map.Entry<TopicPartition, FetchResponseData.PartitionData> element = this.iter().next();
                TopicPartition topicPart = element.getKey();
                FetchResponseData.PartitionData respData = element.getValue();
                IncrementalPartitionFetchMetadata cachedPart = (IncrementalPartitionFetchMetadata)this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().find((ImplicitLinkedHashCollection.Element)new IncrementalPartitionFetchMetadata(topicPart));
                if (cachedPart.maybeUpdateResponseData(respData, this.updateFetchContextAndRemoveUnselected())) {
                    this.nextElement_$eq(element);
                    if (!this.updateFetchContextAndRemoveUnselected() || FetchResponse.recordsSize((FetchResponseData.PartitionData)respData) <= 0) continue;
                    this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().remove((Object)cachedPart);
                    this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().mustAdd((ImplicitLinkedHashCollection.Element)cachedPart);
                    continue;
                }
                if (!this.updateFetchContextAndRemoveUnselected()) continue;
                this.iter().remove();
            }
            return this.nextElement() != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<TopicPartition, FetchResponseData.PartitionData> next() {
            void var1_1;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry<TopicPartition, FetchResponseData.PartitionData> element = this.nextElement();
            this.nextElement_$eq(null);
            return var1_1;
        }

        public Nothing$ remove() {
            throw new UnsupportedOperationException();
        }

        public /* synthetic */ IncrementalFetchContext kafka$server$IncrementalFetchContext$PartitionIterator$$$outer() {
            return this.$outer;
        }

        public PartitionIterator(IncrementalFetchContext $outer, Iterator<Map.Entry<TopicPartition, FetchResponseData.PartitionData>> iter, boolean updateFetchContextAndRemoveUnselected) {
            this.iter = iter;
            this.updateFetchContextAndRemoveUnselected = updateFetchContextAndRemoveUnselected;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.nextElement = null;
        }
    }
}

