/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import kafka.server.LogDirFailureChannel;
import kafka.server.PartitionMetadata;
import kafka.server.PartitionMetadataFile$;
import kafka.server.PartitionMetadataFile$PartitionMetadataFileFormatter$;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InconsistentTopicIdException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Utils;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00055w!B\u0016-\u0011\u0003\td!B\u001a-\u0011\u0003!\u0004\"B\u001e\u0002\t\u0003a\u0004bB\u001f\u0002\u0005\u0004%IA\u0010\u0005\u0007\u000f\u0006\u0001\u000b\u0011B \t\u000f!\u000b!\u0019!C\u0005\u0013\"1!+\u0001Q\u0001\n)CqaU\u0001C\u0002\u0013%A\u000b\u0003\u0004Y\u0003\u0001\u0006I!\u0016\u0005\u00063\u0006!\tAW\u0004\u0006G\u0006A\t\u0001\u001a\u0004\u0006M\u0006A\ta\u001a\u0005\u0006w-!\t\u0001\u001b\u0005\u0006S.!\tA\u001b\u0004\u0005u\u0006\u00011\u0010C\u0005\u0002\b9\u0011\t\u0011)A\u0005W\"Q\u0011\u0011\u0002\b\u0003\u0002\u0003\u0006I!a\u0003\t\u0013\u0005EaB!A!\u0002\u0013)\u0006BB\u001e\u000f\t\u0003\t\u0019\u0002C\u0004\u000249!\t!!\u000e\u0007\u000bMb\u0003!a\u000e\t\u0015\u0005eBC!b\u0001\n\u0003\tY\u0004C\u0005\u0002>Q\u0011\t\u0011)A\u00057\"Q\u0011q\b\u000b\u0003\u0002\u0003\u0006I!!\u0011\t\rm\"B\u0011AA$\u0011%\ty\u0005\u0006b\u0001\n\u0013\t\t\u0006\u0003\u0005\u0002bQ\u0001\u000b\u0011BA*\u0011%\t\u0019\u0007\u0006b\u0001\n\u0013\t\t\u0006\u0003\u0005\u0002fQ\u0001\u000b\u0011BA*\u0011%\t9\u0007\u0006b\u0001\n\u0013\tI\u0007\u0003\u0005\u0002rQ\u0001\u000b\u0011BA6\u0011!\t\u0019\b\u0006b\u0001\n\u0013q\u0004bBA;)\u0001\u0006Ia\u0010\u0005\n\u0003o\"\u0002\u0019!C\u0005\u0003sB\u0011\"a&\u0015\u0001\u0004%I!!'\t\u0011\u0005\u0015F\u0003)Q\u0005\u0003wBq!a,\u0015\t\u0003\t\t\fC\u0004\u00028R!\t!!/\t\u000f\u0005MB\u0003\"\u0001\u00026!9\u00111\u0018\u000b\u0005\u0002\u0005u\u0006bBAc)\u0011\u0005\u0011Q\u0018\u0005\b\u0003\u000f$B\u0011AA]\u0011\u001d\tI\r\u0006C!\u0003\u0017\fQ\u0003U1si&$\u0018n\u001c8NKR\fG-\u0019;b\r&dWM\u0003\u0002.]\u000511/\u001a:wKJT\u0011aL\u0001\u0006W\u000647.Y\u0002\u0001!\t\u0011\u0014!D\u0001-\u0005U\u0001\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019$jY\u0016\u001c\"!A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011'A\rQCJ$\u0018\u000e^5p]6+G/\u00193bi\u00064\u0015\u000e\\3oC6,W#A \u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015\u0001\u00027b]\u001eT\u0011\u0001R\u0001\u0005U\u00064\u0018-\u0003\u0002G\u0003\n11\u000b\u001e:j]\u001e\f!\u0004U1si&$\u0018n\u001c8NKR\fG-\u0019;b\r&dWM\\1nK\u0002\n!c\u00165ji\u0016\u001c\u0006/Y2fgB\u000bG\u000f^3s]V\t!\n\u0005\u0002L!6\tAJ\u0003\u0002N\u001d\u0006)!/Z4fq*\u0011qjQ\u0001\u0005kRLG.\u0003\u0002R\u0019\n9\u0001+\u0019;uKJt\u0017aE,iSR,7\u000b]1dKN\u0004\u0016\r\u001e;fe:\u0004\u0013AD\"veJ,g\u000e\u001e,feNLwN\\\u000b\u0002+B\u0011aGV\u0005\u0003/^\u00121!\u00138u\u0003=\u0019UO\u001d:f]R4VM]:j_:\u0004\u0013a\u00028fo\u001aKG.\u001a\u000b\u00037\u0006\u0004\"\u0001X0\u000e\u0003uS!AX\"\u0002\u0005%|\u0017B\u00011^\u0005\u00111\u0015\u000e\\3\t\u000b\tL\u0001\u0019A.\u0002\u0007\u0011L'/\u0001\u0010QCJ$\u0018\u000e^5p]6+G/\u00193bi\u00064\u0015\u000e\\3G_Jl\u0017\r\u001e;feB\u0011QmC\u0007\u0002\u0003\tq\u0002+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1GS2,gi\u001c:nCR$XM]\n\u0003\u0017U\"\u0012\u0001Z\u0001\u0007i>4\u0015\u000e\\3\u0015\u0005-,\bC\u00017t\u001d\ti\u0017\u000f\u0005\u0002oo5\tqN\u0003\u0002qa\u00051AH]8pizJ!A]\u001c\u0002\rA\u0013X\rZ3g\u0013\t1EO\u0003\u0002so!)a/\u0004a\u0001o\u0006!A-\u0019;b!\t\u0011\u00040\u0003\u0002zY\t\t\u0002+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1\u00037A\u000b'\u000f^5uS>tW*\u001a;bI\u0006$\u0018MU3bI\n+hMZ3s+\ra\u00181D\n\u0004\u001dUj\bc\u0001@\u0002\u00045\tqPC\u0002\u0002\u00029\nQ!\u001e;jYNL1!!\u0002\u0000\u0005\u001daunZ4j]\u001e\f\u0001\u0002\\8dCRLwN\\\u0001\u0007e\u0016\fG-\u001a:\u0011\u0007q\u000bi!C\u0002\u0002\u0010u\u0013aBQ;gM\u0016\u0014X\r\u001a*fC\u0012,'/A\u0004wKJ\u001c\u0018n\u001c8\u0015\u0011\u0005U\u0011QFA\u0018\u0003c\u0001B!\u001a\b\u0002\u0018A!\u0011\u0011DA\u000e\u0019\u0001!q!!\b\u000f\u0005\u0004\tyBA\u0001U#\u0011\t\t#a\n\u0011\u0007Y\n\u0019#C\u0002\u0002&]\u0012qAT8uQ&tw\rE\u00027\u0003SI1!a\u000b8\u0005\r\te.\u001f\u0005\u0007\u0003\u000f\u0011\u0002\u0019A6\t\u000f\u0005%!\u00031\u0001\u0002\f!1\u0011\u0011\u0003\nA\u0002U\u000bAA]3bIR\tqoE\u0002\u0015ku\fAAZ5mKV\t1,A\u0003gS2,\u0007%\u0001\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\t\u0004e\u0005\r\u0013bAA#Y\t!Bj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2$b!!\u0013\u0002L\u00055\u0003C\u0001\u001a\u0015\u0011\u0019\tI\u0004\u0007a\u00017\"9\u0011q\b\rA\u0002\u0005\u0005\u0013\u0001\u00029bi\",\"!a\u0015\u0011\t\u0005U\u0013QL\u0007\u0003\u0003/RA!!\u000f\u0002Z)\u0019\u00111L\"\u0002\u00079Lw.\u0003\u0003\u0002`\u0005]#\u0001\u0002)bi\"\fQ\u0001]1uQ\u0002\n\u0001\u0002^3naB\u000bG\u000f[\u0001\ni\u0016l\u0007\u000fU1uQ\u0002\nA\u0001\\8dWV\u0011\u00111\u000e\t\u0004\u0001\u00065\u0014bAA8\u0003\n1qJ\u00196fGR\fQ\u0001\\8dW\u0002\na\u0001\\8h\t&\u0014\u0018a\u00027pO\u0012K'\u000fI\u0001\u0010I&\u0014H/\u001f+pa&\u001c\u0017\nZ(qiV\u0011\u00111\u0010\t\u0006m\u0005u\u0014\u0011Q\u0005\u0004\u0003\u007f:$AB(qi&|g\u000e\u0005\u0003\u0002\u0004\u0006MUBAAC\u0015\u0011\t9)!#\u0002\r\r|W.\\8o\u0015\ry\u00131\u0012\u0006\u0005\u0003\u001b\u000by)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003#\u000b1a\u001c:h\u0013\u0011\t)*!\"\u0003\tU+\u0018\u000eZ\u0001\u0014I&\u0014H/\u001f+pa&\u001c\u0017\nZ(qi~#S-\u001d\u000b\u0005\u00037\u000b\t\u000bE\u00027\u0003;K1!a(8\u0005\u0011)f.\u001b;\t\u0013\u0005\r&%!AA\u0002\u0005m\u0014a\u0001=%c\u0005\u0001B-\u001b:usR{\u0007/[2JI>\u0003H\u000f\t\u0015\u0004G\u0005%\u0006c\u0001\u001c\u0002,&\u0019\u0011QV\u001c\u0003\u0011Y|G.\u0019;jY\u0016\faA]3d_J$G\u0003BAN\u0003gCq!!.%\u0001\u0004\t\t)A\u0004u_BL7-\u00133\u0002\u00155\f\u0017PY3GYV\u001c\b\u000e\u0006\u0002\u0002\u001c\u00061Q\r_5tiN$\"!a0\u0011\u0007Y\n\t-C\u0002\u0002D^\u0012qAQ8pY\u0016\fg.A\u0004jg\u0016k\u0007\u000f^=\u0002\r\u0011,G.\u001a;f\u0003!!xn\u0015;sS:<G#A6")
public class PartitionMetadataFile
implements Logging {
    private final File file;
    private final LogDirFailureChannel logDirFailureChannel;
    private final Path path;
    private final Path tempPath;
    private final Object lock;
    private final String logDir;
    private volatile Option<Uuid> dirtyTopicIdOpt;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static File newFile(File dir) {
        return PartitionMetadataFile$.MODULE$.newFile(dir);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File file() {
        return this.file;
    }

    private Path path() {
        return this.path;
    }

    private Path tempPath() {
        return this.tempPath;
    }

    private Object lock() {
        return this.lock;
    }

    private String logDir() {
        return this.logDir;
    }

    private Option<Uuid> dirtyTopicIdOpt() {
        return this.dirtyTopicIdOpt;
    }

    private void dirtyTopicIdOpt_$eq(Option<Uuid> x$1) {
        this.dirtyTopicIdOpt = x$1;
    }

    public void record(Uuid topicId) {
        this.dirtyTopicIdOpt().foreach((Function1 & Serializable)dirtyTopicId -> {
            PartitionMetadataFile.$anonfun$record$1(topicId, dirtyTopicId);
            return BoxedUnit.UNIT;
        });
        this.dirtyTopicIdOpt_$eq((Option<Uuid>)new Some((Object)topicId));
    }

    public void maybeFlush() {
        this.dirtyTopicIdOpt().foreach((Function1 & Serializable)x$1 -> {
            PartitionMetadataFile.$anonfun$maybeFlush$1(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public PartitionMetadata read() {
        Object object = this.lock();
        synchronized (object) {
            PartitionMetadata partitionMetadata = this.liftedTree1$1();
            return partitionMetadata;
        }
    }

    public boolean exists() {
        return this.file().exists();
    }

    public boolean isEmpty() {
        return this.file().length() == 0L;
    }

    public void delete() {
        Files.delete(this.file().toPath());
    }

    public String toString() {
        return new StringBuilder(28).append("PartitionMetadataFile(path=").append(this.path()).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$record$1(Uuid topicId$1, Uuid dirtyTopicId) {
        Uuid uuid = dirtyTopicId;
        if (uuid == null ? topicId$1 != null : !uuid.equals(topicId$1)) {
            throw new InconsistentTopicIdException(new StringBuilder(0).append(new StringBuilder(34).append("Tried to record topic ID ").append(topicId$1).append(" to file ").toString()).append(new StringBuilder(25).append("but had already recorded ").append(dirtyTopicId).toString()).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$maybeFlush$2(PartitionMetadataFile $this, Uuid topicId) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream($this.tempPath().toFile());
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8));){
                writer.write(PartitionMetadataFile$PartitionMetadataFileFormatter$.MODULE$.toFile(new PartitionMetadata(PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion(), topicId)));
                writer.flush();
                fileOutputStream.getFD().sync();
            }
            Utils.atomicMoveWithFallback((Path)$this.tempPath(), (Path)$this.path(), (boolean)false);
        }
        catch (IOException e) {
            String msg = new StringBuilder(47).append("Error while writing to partition metadata file ").append($this.file().getAbsolutePath()).toString();
            $this.logDirFailureChannel.maybeAddOfflineLogDir($this.logDir(), (Function0<String>)(Function0 & Serializable)() -> msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
        $this.dirtyTopicIdOpt_$eq((Option<Uuid>)None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$maybeFlush$1(PartitionMetadataFile $this, Uuid x$1) {
        Object object = $this.lock();
        synchronized (object) {
            $this.dirtyTopicIdOpt().foreach((Function1 & Serializable)topicId -> {
                PartitionMetadataFile.$anonfun$maybeFlush$2($this, topicId);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private final /* synthetic */ PartitionMetadata liftedTree1$1() {
        try {
            PartitionMetadata partitionMetadata;
            try (BufferedReader reader = Files.newBufferedReader(this.path());){
                partitionMetadata = new PartitionMetadataReadBuffer(this.file().getAbsolutePath(), reader, PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion()).read();
            }
            return partitionMetadata;
        }
        catch (IOException e) {
            String msg = new StringBuilder(44).append("Error while reading partition metadata file ").append(this.file().getAbsolutePath()).toString();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir(), (Function0<String>)(Function0 & Serializable)() -> msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }

    public PartitionMetadataFile(File file, LogDirFailureChannel logDirFailureChannel) {
        this.file = file;
        this.logDirFailureChannel = logDirFailureChannel;
        this.path = file.toPath().toAbsolutePath();
        this.tempPath = Paths.get(new StringBuilder(4).append(((Object)this.path()).toString()).append(".tmp").toString(), new String[0]);
        this.lock = new Object();
        this.logDir = file.getParentFile().getParent();
        this.dirtyTopicIdOpt = None$.MODULE$;
    }

    public static class PartitionMetadataReadBuffer<T>
    implements Logging {
        private final String location;
        private final BufferedReader reader;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        public PartitionMetadata read() {
            String line = null;
            try {
                Uuid metadataTopicId;
                block11: {
                    block7: {
                        String version;
                        block8: {
                            Object object;
                            block10: {
                                block9: {
                                    Object object2;
                                    line = this.reader.readLine();
                                    String[] stringArray = PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$WhiteSpacesPattern().split(line);
                                    if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq((Object)stringArray))) break block7;
                                    new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2));
                                    if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 2) != 0) break block7;
                                    version = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 1);
                                    if (StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(version)) != PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion()) break block8;
                                    line = this.reader.readLine();
                                    String[] stringArray2 = PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$WhiteSpacesPattern().split(line);
                                    if (stringArray2 == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray2))) break block9;
                                    new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object));
                                    if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) break block10;
                                }
                                throw this.malformedLineException$1(line);
                            }
                            metadataTopicId = Uuid.fromString((String)((String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1)));
                            if (metadataTopicId.equals((Object)Uuid.ZERO_UUID)) {
                                throw new IOException(new StringBuilder(46).append("Invalid topic ID in partition metadata file (").append(this.location).append(")").toString());
                            }
                            break block11;
                        }
                        throw new IOException(new StringBuilder(0).append(new StringBuilder(52).append("Unrecognized version of partition metadata file (").append(this.location).append("): ").toString()).append(version).toString());
                    }
                    throw this.malformedLineException$1(line);
                }
                PartitionMetadata partitionMetadata = new PartitionMetadata(PartitionMetadataFile$.MODULE$.kafka$server$PartitionMetadataFile$$CurrentVersion(), metadataTopicId);
                return partitionMetadata;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.malformedLineException$1(line);
            }
        }

        private final IOException malformedLineException$1(String line) {
            return new IOException(new StringBuilder(40).append("Malformed line in checkpoint file (").append(this.location).append("): '").append(line).append("'").toString());
        }

        public PartitionMetadataReadBuffer(String location, BufferedReader reader, int version) {
            this.location = location;
            this.reader = reader;
        }
    }
}

