/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.SocketTimeoutException;
import kafka.cluster.BrokerEndPoint;
import kafka.server.BlockingSend;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaFetcherBlockingSend$;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.Option;
import scala.collection.Map;
import scala.collection.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001du!\u0002\n\u0014\u0011\u0003Ab!\u0002\u000e\u0014\u0011\u0003Y\u0002\"\u0002\u0012\u0002\t\u0003\u0019\u0003\"\u0002\u0013\u0002\t\u0003)\u0003\"CA8\u0003E\u0005I\u0011AA9\r\u0011Q2\u0003A\u0014\t\u0011-*!\u0011!Q\u0001\n1B\u0001BM\u0003\u0003\u0002\u0003\u0006Ia\r\u0005\tm\u0015\u0011\t\u0011)A\u0005o!A!(\u0002B\u0001B\u0003%1\b\u0003\u0005I\u000b\t\u0005\t\u0015!\u0003J\u0011!yUA!A!\u0002\u0013\u0001\u0006\"\u0002\u0012\u0006\t\u00039\u0006b\u00020\u0006\u0005\u0004%\ta\u0018\u0005\u0007G\u0016\u0001\u000b\u0011\u00021\t\u000b\u0011,A\u0011I3\t\u000f\u0005uQ\u0001\"\u0011\u0002 !9\u0011qE\u0003\u0005B\u0005}\u0011A\u0007*fa2L7-\u0019$fi\u000eDWM\u001d\"m_\u000e\\\u0017N\\4TK:$'B\u0001\u000b\u0016\u0003\u0019\u0019XM\u001d<fe*\ta#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005e\tQ\"A\n\u00035I+\u0007\u000f\\5dC\u001a+Go\u00195fe\ncwnY6j]\u001e\u001cVM\u001c3\u0014\u0005\u0005a\u0002CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00021\u0005)\u0011\r\u001d9msR\tb%!\u000b\u0002,\u00055\u00121HA\u001f\u0003\u0003\n)&a\u0018\u0011\u0005e)1cA\u0003\u001dQA\u0011\u0011$K\u0005\u0003UM\u0011AB\u00117pG.LgnZ*f]\u0012\fAb]8ve\u000e,'I]8lKJ\u0004\"!\f\u0019\u000e\u00039R!aL\u000b\u0002\u000f\rdWo\u001d;fe&\u0011\u0011G\f\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u00031\u0011'o\\6fe\u000e{gNZ5h!\tIB'\u0003\u00026'\tY1*\u00194lC\u000e{gNZ5h\u00035\u0019xnY6fiRKW.Z8viB\u0011Q\u0004O\u0005\u0003sy\u00111!\u00138u\u0003\u0011!\u0018.\\3\u0011\u0005q2U\"A\u001f\u000b\u0005yz\u0014!B;uS2\u001c(B\u0001!B\u0003\u0019\u0019w.\\7p]*\u0011aC\u0011\u0006\u0003\u0007\u0012\u000ba!\u00199bG\",'\"A#\u0002\u0007=\u0014x-\u0003\u0002H{\t!A+[7f\u00035qW\r^<pe.\u001cE.[3oiB\u0011!*T\u0007\u0002\u0017*\u0011A*Q\u0001\bG2LWM\u001c;t\u0013\tq5JA\u0006LC\u001a\\\u0017m\u00117jK:$\u0018\u0001\b:fG>tg-[4ve\u0006\u0014G.Z\"iC:tW\r\u001c\"vS2$WM\u001d\t\u0004;E\u001b\u0016B\u0001*\u001f\u0005\u0019y\u0005\u000f^5p]B\u0011A+V\u0007\u0002\u007f%\u0011ak\u0010\u0002\u000f%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f)\u001d1\u0003,\u0017.\\9vCQa\u000b\u0007A\u00021BQA\r\u0007A\u0002MBQA\u000e\u0007A\u0002]BQA\u000f\u0007A\u0002mBQ\u0001\u0013\u0007A\u0002%CQa\u0014\u0007A\u0002A\u000b!b]8ve\u000e,gj\u001c3f+\u0005\u0001\u0007C\u0001+b\u0013\t\u0011wH\u0001\u0003O_\u0012,\u0017aC:pkJ\u001cWMT8eK\u0002\n1b]3oIJ+\u0017/^3tiR\u0011a-\u001b\t\u0003\u0015\u001eL!\u0001[&\u0003\u001d\rc\u0017.\u001a8u%\u0016\u001c\bo\u001c8tK\")!n\u0004a\u0001W\u0006q!/Z9vKN$()^5mI\u0016\u0014\bg\u00017\u0002\nA!Qn`A\u0003\u001d\tqGP\u0004\u0002pu:\u0011\u0001/\u001f\b\u0003cbt!A]<\u000f\u0005M4X\"\u0001;\u000b\u0005U<\u0012A\u0002\u001fs_>$h(C\u0001F\u0013\t\u0019E)\u0003\u0002\u0017\u0005&\u0011\u0001)Q\u0005\u0003w~\n\u0001B]3rk\u0016\u001cHo]\u0005\u0003{z\fq\"\u00112tiJ\f7\r\u001e*fcV,7\u000f\u001e\u0006\u0003w~JA!!\u0001\u0002\u0004\t9!)^5mI\u0016\u0014(BA?\u007f!\u0011\t9!!\u0003\r\u0001\u0011Y\u00111B5\u0002\u0002\u0003\u0005)\u0011AA\u0007\u0005\ryFEM\t\u0005\u0003\u001f\t)\u0002E\u0002\u001e\u0003#I1!a\u0005\u001f\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a\u0006\u0002\u001a5\ta0C\u0002\u0002\u001cy\u0014q\"\u00112tiJ\f7\r\u001e*fcV,7\u000f^\u0001\u000eS:LG/[1uK\u000ecwn]3\u0015\u0005\u0005\u0005\u0002cA\u000f\u0002$%\u0019\u0011Q\u0005\u0010\u0003\tUs\u0017\u000e^\u0001\u0006G2|7/\u001a\u0005\u0006W\r\u0001\r\u0001\f\u0005\u0006e\r\u0001\ra\r\u0005\b\u0003_\u0019\u0001\u0019AA\u0019\u0003\u001diW\r\u001e:jGN\u0004B!a\r\u000285\u0011\u0011Q\u0007\u0006\u0004\u0003_y\u0014\u0002BA\u001d\u0003k\u0011q!T3ue&\u001c7\u000fC\u0003;\u0007\u0001\u00071\b\u0003\u0004\u0002@\r\u0001\raN\u0001\nM\u0016$8\r[3s\u0013\u0012Dq!a\u0011\u0004\u0001\u0004\t)%\u0001\u0005dY&,g\u000e^%e!\u0011\t9%a\u0014\u000f\t\u0005%\u00131\n\t\u0003gzI1!!\u0014\u001f\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011KA*\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\n\u0010\t\u000f\u0005]3\u00011\u0001\u0002Z\u0005QAn\\4D_:$X\r\u001f;\u0011\u0007q\nY&C\u0002\u0002^u\u0012!\u0002T8h\u0007>tG/\u001a=u\u0011%\t\tg\u0001I\u0001\u0002\u0004\t\u0019'A\bfqR\u0014\u0018-T3ue&\u001cG+Y4t!!\t)'a\u001b\u0002F\u0005\u0015SBAA4\u0015\r\tIGH\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA7\u0003O\u00121!T1q\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012BTCAA:U\u0011\t\u0019'!\u001e,\u0005\u0005]\u0004\u0003BA=\u0003\u0007k!!a\u001f\u000b\t\u0005u\u0014qP\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!!\u001f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000b\u000bYHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class ReplicaFetcherBlockingSend
implements BlockingSend {
    private final BrokerEndPoint sourceBroker;
    private final KafkaConfig brokerConfig;
    private final int socketTimeout;
    private final Time time;
    private final KafkaClient networkClient;
    private final Option<Reconfigurable> reconfigurableChannelBuilder;
    private final Node sourceNode;

    public static Map<String, String> apply$default$8() {
        return (Map)Map$.MODULE$.empty();
    }

    public static ReplicaFetcherBlockingSend apply(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, Metrics metrics, Time time, int fetcherId, String clientId, LogContext logContext, Map<String, String> extraMetricTags) {
        return ReplicaFetcherBlockingSend$.MODULE$.apply(sourceBroker, brokerConfig, metrics, time, fetcherId, clientId, logContext, extraMetricTags);
    }

    public Node sourceNode() {
        return this.sourceNode;
    }

    @Override
    public ClientResponse sendRequest(AbstractRequest.Builder<? extends AbstractRequest> requestBuilder) {
        try {
            if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient, (Node)this.sourceNode(), (Time)this.time, (long)this.socketTimeout)) {
                throw new SocketTimeoutException(new StringBuilder(28).append("Failed to connect within ").append(this.socketTimeout).append(" ms").toString());
            }
            ClientRequest clientRequest = this.networkClient.newClientRequest(Integer.toString(this.sourceBroker.id()), requestBuilder, this.time.milliseconds(), true);
            return NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient, (ClientRequest)clientRequest, (Time)this.time);
        }
        catch (Throwable e) {
            this.networkClient.close(Integer.toString(this.sourceBroker.id()));
            throw e;
        }
    }

    @Override
    public void initiateClose() {
        this.reconfigurableChannelBuilder.foreach((Function1 & Serializable)reconfigurable -> {
            this.brokerConfig.removeReconfigurable(reconfigurable);
            return BoxedUnit.UNIT;
        });
        this.networkClient.initiateClose();
    }

    @Override
    public void close() {
        this.networkClient.close();
    }

    public ReplicaFetcherBlockingSend(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, int socketTimeout, Time time, KafkaClient networkClient, Option<Reconfigurable> reconfigurableChannelBuilder) {
        this.sourceBroker = sourceBroker;
        this.brokerConfig = brokerConfig;
        this.socketTimeout = socketTimeout;
        this.time = time;
        this.networkClient = networkClient;
        this.reconfigurableChannelBuilder = reconfigurableChannelBuilder;
        this.sourceNode = new Node(sourceBroker.id(), sourceBroker.host(), sourceBroker.port());
    }
}

