/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.Defaults$;
import kafka.server.ReplicationQuotaManagerConfig;
import org.apache.kafka.common.config.ConfigDef;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class ReplicationQuotaManagerConfig$
implements Serializable {
    public static final ReplicationQuotaManagerConfig$ MODULE$ = new ReplicationQuotaManagerConfig$();
    private static final String NoThrottledReplicasValue = "none";
    private static final String AllThrottledReplicasValue = "*";
    private static final int InactiveSensorExpirationTimeSeconds = 3600;
    private static final String LeaderReplicationThrottledRateProp = "leader.replication.throttled.rate";
    private static final String FollowerReplicationThrottledRateProp = "follower.replication.throttled.rate";
    private static final String LeaderReplicationThrottledReplicasProp = "leader.replication.throttled.replicas";
    private static final String FollowerReplicationThrottledReplicasProp = "follower.replication.throttled.replicas";
    private static final Set<String> ReconfigurableConfigs = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.LeaderReplicationThrottledReplicasProp(), MODULE$.LeaderReplicationThrottledRateProp(), MODULE$.FollowerReplicationThrottledReplicasProp(), MODULE$.FollowerReplicationThrottledRateProp()}));

    public long $lessinit$greater$default$1() {
        return Defaults$.MODULE$.QuotaBytesPerSecond();
    }

    public int $lessinit$greater$default$2() {
        return Defaults$.MODULE$.DefaultNumQuotaSamples();
    }

    public int $lessinit$greater$default$3() {
        return Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
    }

    public boolean $lessinit$greater$default$4() {
        return false;
    }

    public String NoThrottledReplicasValue() {
        return NoThrottledReplicasValue;
    }

    public String AllThrottledReplicasValue() {
        return AllThrottledReplicasValue;
    }

    public int InactiveSensorExpirationTimeSeconds() {
        return InactiveSensorExpirationTimeSeconds;
    }

    public String LeaderReplicationThrottledRateProp() {
        return LeaderReplicationThrottledRateProp;
    }

    public String FollowerReplicationThrottledRateProp() {
        return FollowerReplicationThrottledRateProp;
    }

    public String LeaderReplicationThrottledReplicasProp() {
        return LeaderReplicationThrottledReplicasProp;
    }

    public String FollowerReplicationThrottledReplicasProp() {
        return FollowerReplicationThrottledReplicasProp;
    }

    public Set<String> ReconfigurableConfigs() {
        return ReconfigurableConfigs;
    }

    public boolean allReplicasThrottled(String throttledReplicas) {
        return this.AllThrottledReplicasValue().equals(throttledReplicas);
    }

    public ConfigDef.Validator throttledReplicasValidator() {
        return ConfigDef.ValidString.in((String[])new String[]{this.NoThrottledReplicasValue(), this.AllThrottledReplicasValue()});
    }

    public ReplicationQuotaManagerConfig apply(long quotaBytesPerSecond, int numQuotaSamples, int quotaWindowSizeSeconds, boolean allReplicasThrottled) {
        return new ReplicationQuotaManagerConfig(quotaBytesPerSecond, numQuotaSamples, quotaWindowSizeSeconds, allReplicasThrottled);
    }

    public long apply$default$1() {
        return Defaults$.MODULE$.QuotaBytesPerSecond();
    }

    public int apply$default$2() {
        return Defaults$.MODULE$.DefaultNumQuotaSamples();
    }

    public int apply$default$3() {
        return Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
    }

    public boolean apply$default$4() {
        return false;
    }

    public Option<Tuple4<Object, Object, Object, Object>> unapply(ReplicationQuotaManagerConfig x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)x$0.quotaBytesPerSecond()), (Object)BoxesRunTime.boxToInteger((int)x$0.numQuotaSamples()), (Object)BoxesRunTime.boxToInteger((int)x$0.quotaWindowSizeSeconds()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.allReplicasThrottled())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ReplicationQuotaManagerConfig$.class);
    }

    private ReplicationQuotaManagerConfig$() {
    }
}

