/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.IoThread$;
import kafka.server.NetworkThread$;
import kafka.server.RequestThrottleType;
import kafka.server.ThreadType;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ThreadUsageMetrics$ {
    public static final ThreadUsageMetrics$ MODULE$ = new ThreadUsageMetrics$();
    private static final String MetricGroup = "threads-usage-metrics";
    private static final String ListenerMetricTag = "listener";

    public String MetricGroup() {
        return MetricGroup;
    }

    public String ListenerMetricTag() {
        return ListenerMetricTag;
    }

    private double threadUsage(Metrics metrics, ThreadType threadType, Map<String, String> metricTags, Option<RequestThrottleType> throttleTypeOpt) {
        Option metricOpt = Option$.MODULE$.apply((Object)metrics.metric(this.threadUsageMetricName(metrics, threadType, metricTags, throttleTypeOpt)));
        double d = metricOpt instanceof Some ? BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((Some)metricOpt).value()).metricValue()) : 0.0;
        return d;
    }

    public double ioThreadsUsage(Metrics metrics, Option<RequestThrottleType> throttleTypeOpt) {
        return this.threadUsage(metrics, IoThread$.MODULE$, this.ioThreadUsageMetricTags(), throttleTypeOpt);
    }

    public Option<RequestThrottleType> ioThreadsUsage$default$2() {
        return None$.MODULE$;
    }

    public double networkThreadsUsage(Metrics metrics, Seq<String> listeners, Option<RequestThrottleType> throttleTypeOpt) {
        return BoxesRunTime.unboxToDouble((Object)listeners.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToDouble((double)ThreadUsageMetrics$.$anonfun$networkThreadsUsage$1(metrics, throttleTypeOpt, BoxesRunTime.unboxToDouble((Object)x0$1), x1$1))));
    }

    public Option<RequestThrottleType> networkThreadsUsage$default$3() {
        return None$.MODULE$;
    }

    public MetricName threadUsageMetricName(Metrics metrics, ThreadType threadType, Map<String, String> metricTags, Option<RequestThrottleType> throttleTypeOpt) {
        String throttleTypeMetricName = (String)throttleTypeOpt.map((Function1 & Serializable)throttleType -> new StringBuilder(1).append("-").append(throttleType.name()).toString()).getOrElse((Function0 & Serializable)() -> "");
        return metrics.metricName(new StringBuilder(13).append("request").append(throttleTypeMetricName).append("-").append(threadType.name()).append("-time").toString(), this.MetricGroup(), new StringBuilder(52).append("Tracking ").append(throttleTypeOpt.getOrElse((Function0 & Serializable)() -> "total")).append(" request utilization percentage of ").append(threadType.name()).append(" threads").toString(), CollectionConverters$.MODULE$.MapHasAsJava(metricTags).asJava());
    }

    public Seq<Map<String, String>> networkThreadUsageMetricTags(Seq<String> listeners) {
        return (Seq)listeners.map((Function1 & Serializable)listener -> (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.ListenerMetricTag()), listener)})));
    }

    public Map<String, String> listenerNetworkThreadUsageMetricTags(String listener) {
        return (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ListenerMetricTag()), (Object)listener)}));
    }

    public Map<String, String> ioThreadUsageMetricTags() {
        return Predef$.MODULE$.Map().empty();
    }

    public double networkThreadsCapacity(Metrics metrics, Seq<String> listeners) {
        return BoxesRunTime.unboxToDouble((Object)listeners.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToDouble((double)ThreadUsageMetrics$.$anonfun$networkThreadsCapacity$1(metrics, BoxesRunTime.unboxToDouble((Object)x0$1), x1$1))));
    }

    public double ioThreadsCapacity(Metrics metrics) {
        return this.threadPoolCapacity(metrics, IoThread$.MODULE$, this.ioThreadUsageMetricTags());
    }

    public MetricName ioThreadPoolCapacityMetricName(Metrics metrics) {
        return this.threadPoolCapacityMetricName(metrics, IoThread$.MODULE$, this.ioThreadUsageMetricTags(), "(current number of io threads)*100%");
    }

    public MetricName networkThreadPoolCapacityMetricName(Metrics metrics, String listener) {
        return this.threadPoolCapacityMetricName(metrics, NetworkThread$.MODULE$, this.listenerNetworkThreadUsageMetricTags(listener), new StringBuilder(45).append("(current number of network threads for ").append(listener).append(")*100%").toString());
    }

    public MetricName threadPoolCapacityMetricName(Metrics metrics, ThreadType threadType, Map<String, String> metricTags, String metricDescription) {
        return metrics.metricName(new StringBuilder(11).append("total-").append(threadType.name()).append("-time").toString(), this.MetricGroup(), metricDescription, CollectionConverters$.MODULE$.MapHasAsJava(metricTags).asJava());
    }

    private double threadPoolCapacity(Metrics metrics, ThreadType threadType, Map<String, String> metricTags) {
        MetricName metricName = this.threadPoolCapacityMetricName(metrics, threadType, metricTags, "");
        Option option = Option$.MODULE$.apply((Object)metrics.metric(metricName));
        double d = option instanceof Some ? BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((Some)option).value()).metricValue()) : 0.0;
        return d;
    }

    public static final /* synthetic */ double $anonfun$networkThreadsUsage$1(Metrics metrics$1, Option throttleTypeOpt$1, double x0$1, String x1$1) {
        return x0$1 + MODULE$.threadUsage(metrics$1, NetworkThread$.MODULE$, MODULE$.listenerNetworkThreadUsageMetricTags(x1$1), (Option<RequestThrottleType>)throttleTypeOpt$1);
    }

    public static final /* synthetic */ double $anonfun$networkThreadsCapacity$1(Metrics metrics$2, double x0$1, String x1$1) {
        return x0$1 + MODULE$.threadPoolCapacity(metrics$2, NetworkThread$.MODULE$, MODULE$.listenerNetworkThreadUsageMetricTags(x1$1));
    }

    private ThreadUsageMetrics$() {
    }
}

