/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kafka.server.AlterIsrItem;
import kafka.server.AlterIsrManager;
import kafka.server.IsrChangePropagationConfig;
import kafka.server.ZkIsrManager$;
import kafka.utils.Logging;
import kafka.utils.ReplicationUtils$;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.mutable.HashSet;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005}r!B\f\u0019\u0011\u0003ib!B\u0010\u0019\u0011\u0003\u0001\u0003\"B\u0014\u0002\t\u0003A\u0003bB\u0015\u0002\u0001\u0004%\tA\u000b\u0005\b]\u0005\u0001\r\u0011\"\u00010\u0011\u0019)\u0014\u0001)Q\u0005W\u0019!q\u0004\u0007\u0001;\u0011!!eA!A!\u0002\u0013)\u0005\u0002\u0003%\u0007\u0005\u0003\u0005\u000b\u0011B%\t\u0011U3!\u0011!Q\u0001\nYCQa\n\u0004\u0005\u0002qCq!\u0019\u0004C\u0002\u0013%!\u0006\u0003\u0004c\r\u0001\u0006Ia\u000b\u0005\tG\u001a\u0011\r\u0011\"\u0001\u0019I\"1\u0011O\u0002Q\u0001\n\u0015DqA\u001d\u0004C\u0002\u0013%1\u000fC\u0004\u0002\u0002\u0019\u0001\u000b\u0011\u0002;\t\u0011\u0005\raA1A\u0005\nMDq!!\u0002\u0007A\u0003%A\u000fC\u0004\u0002\b\u0019!\t%!\u0003\t\u000f\u0005-a\u0001\"\u0011\u0002\u000e!A\u0011q\u0004\u0004\u0005\u0002a\t\t\u0003\u0003\u0006\u0002(\u0019\t\n\u0011\"\u0001\u0019\u0003S\tABW6JgJl\u0015M\\1hKJT!!\u0007\u000e\u0002\rM,'O^3s\u0015\u0005Y\u0012!B6bM.\f7\u0001\u0001\t\u0003=\u0005i\u0011\u0001\u0007\u0002\r5.L5O]'b]\u0006<WM]\n\u0003\u0003\u0005\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001e\u0003m!UMZ1vYRL5O\u001d)s_B\fw-\u0019;j_:\u001cuN\u001c4jOV\t1\u0006\u0005\u0002\u001fY%\u0011Q\u0006\u0007\u0002\u001b\u0013N\u00148\t[1oO\u0016\u0004&o\u001c9bO\u0006$\u0018n\u001c8D_:4\u0017nZ\u0001 \t\u00164\u0017-\u001e7u\u0013N\u0014\bK]8qC\u001e\fG/[8o\u0007>tg-[4`I\u0015\fHC\u0001\u00194!\t\u0011\u0013'\u0003\u00023G\t!QK\\5u\u0011\u001d!D!!AA\u0002-\n1\u0001\u001f\u00132\u0003q!UMZ1vYRL5O\u001d)s_B\fw-\u0019;j_:\u001cuN\u001c4jO\u0002B#!B\u001c\u0011\u0005\tB\u0014BA\u001d$\u0005!1x\u000e\\1uS2,7\u0003\u0002\u0004\"wy\u0002\"A\b\u001f\n\u0005uB\"aD!mi\u0016\u0014\u0018j\u001d:NC:\fw-\u001a:\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005S\u0012!B;uS2\u001c\u0018BA\"A\u0005\u001daunZ4j]\u001e\f\u0011b]2iK\u0012,H.\u001a:\u0011\u0005}2\u0015BA$A\u0005%\u00196\r[3ek2,'/\u0001\u0003uS6,\u0007C\u0001&T\u001b\u0005Y%BA!M\u0015\tie*\u0001\u0004d_6lwN\u001c\u0006\u00037=S!\u0001U)\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0016aA8sO&\u0011Ak\u0013\u0002\u0005)&lW-\u0001\u0005{W\u000ec\u0017.\u001a8u!\t9&,D\u0001Y\u0015\tI&$\u0001\u0002{W&\u00111\f\u0017\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0015\tusv\f\u0019\t\u0003=\u0019AQ\u0001\u0012\u0006A\u0002\u0015CQ\u0001\u0013\u0006A\u0002%CQ!\u0016\u0006A\u0002Y\u000b1$[:s\u0007\"\fgnZ3O_RLg-[2bi&|gnQ8oM&<\u0017\u0001H5te\u000eC\u0017M\\4f\u001d>$\u0018NZ5dCRLwN\\\"p]\u001aLw\rI\u0001\rSN\u00148\t[1oO\u0016\u001cV\r^\u000b\u0002KB\u0019am[7\u000e\u0003\u001dT!\u0001[5\u0002\u000f5,H/\u00192mK*\u0011!nI\u0001\u000bG>dG.Z2uS>t\u0017B\u00017h\u0005\r\u0019V\r\u001e\t\u0003]>l\u0011\u0001T\u0005\u0003a2\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0007jgJ\u001c\u0005.\u00198hKN+G\u000fI\u0001\u0010Y\u0006\u001cH/S:s\u0007\"\fgnZ3NgV\tA\u000f\u0005\u0002v}6\taO\u0003\u0002xq\u00061\u0011\r^8nS\u000eT!!\u001f>\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002|y\u0006!Q\u000f^5m\u0015\u0005i\u0018\u0001\u00026bm\u0006L!a <\u0003\u0015\u0005#x.\\5d\u0019>tw-\u0001\tmCN$\u0018j\u001d:DQ\u0006tw-Z'tA\u0005!B.Y:u\u0013N\u0014\bK]8qC\u001e\fG/[8o\u001bN\fQ\u0003\\1ti&\u001b(\u000f\u0015:pa\u0006<\u0017\r^5p]6\u001b\b%A\u0003ti\u0006\u0014H\u000fF\u00011\u0003\u0019\u0019XOY7jiR!\u0011qBA\u000b!\r\u0011\u0013\u0011C\u0005\u0004\u0003'\u0019#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003/!\u0002\u0019AA\r\u00031\tG\u000e^3s\u0013N\u0014\u0018\n^3n!\rq\u00121D\u0005\u0004\u0003;A\"\u0001D!mi\u0016\u0014\u0018j\u001d:Ji\u0016l\u0017\u0001G7bs\n,\u0007K]8qC\u001e\fG/Z%te\u000eC\u0017M\\4fgR\u0019\u0001'a\t\t\u0013\u0005\u0015R\u0003%AA\u0002\u0005=\u0011\u0001\u00069s_B\fw-\u0019;f\u00136lW\rZ5bi\u0016d\u00170\u0001\u0012nCf\u0014W\r\u0015:pa\u0006<\u0017\r^3JgJ\u001c\u0005.\u00198hKN$C-\u001a4bk2$H%M\u000b\u0003\u0003WQC!a\u0004\u0002.-\u0012\u0011q\u0006\t\u0005\u0003c\tY$\u0004\u0002\u00024)!\u0011QGA\u001c\u0003%)hn\u00195fG.,GMC\u0002\u0002:\r\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti$a\r\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class ZkIsrManager
implements AlterIsrManager,
Logging {
    private final Scheduler scheduler;
    private final Time time;
    private final KafkaZkClient zkClient;
    private final IsrChangePropagationConfig isrChangeNotificationConfig;
    private final scala.collection.mutable.Set<TopicPartition> isrChangeSet;
    private final AtomicLong lastIsrChangeMs;
    private final AtomicLong lastIsrPropagationMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void DefaultIsrPropagationConfig_$eq(IsrChangePropagationConfig x$1) {
        ZkIsrManager$.MODULE$.DefaultIsrPropagationConfig_$eq(x$1);
    }

    public static IsrChangePropagationConfig DefaultIsrPropagationConfig() {
        return ZkIsrManager$.MODULE$.DefaultIsrPropagationConfig();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void shutdown() {
        AlterIsrManager.shutdown$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private IsrChangePropagationConfig isrChangeNotificationConfig() {
        return this.isrChangeNotificationConfig;
    }

    public scala.collection.mutable.Set<TopicPartition> isrChangeSet() {
        return this.isrChangeSet;
    }

    private AtomicLong lastIsrChangeMs() {
        return this.lastIsrChangeMs;
    }

    private AtomicLong lastIsrPropagationMs() {
        return this.lastIsrPropagationMs;
    }

    @Override
    public void start() {
        JFunction0.mcV.sp & Serializable x$2 = (JFunction0.mcV.sp & Serializable)() -> this.maybePropagateIsrChanges(false);
        long x$3 = this.isrChangeNotificationConfig().checkIntervalMs();
        long x$5 = this.scheduler.schedule$default$3();
        this.scheduler.schedule("isr-change-propagation", (Function0<BoxedUnit>)x$2, x$5, x$3, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean submit(AlterIsrItem alterIsrItem) {
        void var3_3;
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(43).append("Writing new ISR ").append(alterIsrItem.leaderAndIsr()).append(" to ZooKeeper with version ").toString()).append(new StringBuilder(15).append(alterIsrItem.leaderAndIsr().zkVersion()).append(" for partition ").append(alterIsrItem.topicPartition()).toString()).toString());
        Tuple2<Object, Object> tuple2 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient, alterIsrItem.topicPartition(), alterIsrItem.leaderAndIsr(), alterIsrItem.controllerEpoch());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean updateSucceeded = tuple2._1$mcZ$sp();
        int newVersion = tuple2._2$mcI$sp();
        if (var3_3 != false) {
            void var4_4;
            scala.collection.mutable.Set<TopicPartition> set = this.isrChangeSet();
            synchronized (set) {
                this.isrChangeSet().$plus$eq((Object)alterIsrItem.topicPartition());
                this.lastIsrChangeMs().set(this.time.milliseconds());
                if (alterIsrItem.propagateImmediately()) {
                    this.maybePropagateIsrChanges(true);
                }
            }
            alterIsrItem.callback().apply((Object)package$.MODULE$.Right().apply((Object)alterIsrItem.leaderAndIsr().withZkVersion((int)var4_4)));
        } else {
            alterIsrItem.callback().apply((Object)package$.MODULE$.Left().apply((Object)Errors.INVALID_UPDATE_VERSION));
        }
        return true;
    }

    public void maybePropagateIsrChanges(boolean propagateImmediately) {
        long now = this.time.milliseconds();
        scala.collection.mutable.Set<TopicPartition> set = this.isrChangeSet();
        synchronized (set) {
            if (this.isrChangeSet().nonEmpty() && (propagateImmediately || this.lastIsrChangeMs().get() + this.isrChangeNotificationConfig().lingerMs() < now || this.lastIsrPropagationMs().get() + this.isrChangeNotificationConfig().maxDelayMs() < now)) {
                this.zkClient.propagateIsrChanges((Set<TopicPartition>)this.isrChangeSet());
                this.isrChangeSet().clear();
                this.lastIsrPropagationMs().set(now);
            }
            return;
        }
    }

    public boolean maybePropagateIsrChanges$default$1() {
        return false;
    }

    public ZkIsrManager(Scheduler scheduler, Time time, KafkaZkClient zkClient) {
        this.scheduler = scheduler;
        this.time = time;
        this.zkClient = zkClient;
        this.isrChangeNotificationConfig = ZkIsrManager$.MODULE$.DefaultIsrPropagationConfig();
        this.isrChangeSet = new HashSet();
        this.lastIsrChangeMs = new AtomicLong(time.milliseconds());
        this.lastIsrPropagationMs = new AtomicLong(time.milliseconds());
    }
}

