/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.epoch.EpochEntry;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t]a\u0001B\u0013'\u00015B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\")Q\n\u0001C\u0001\u001d\"91\u000b\u0001b\u0001\n\u0013!\u0006BB1\u0001A\u0003%Q\u000bC\u0004c\u0001\t\u0007I\u0011B2\t\r9\u0004\u0001\u0015!\u0003e\u0011\u001dy\u0007\u00011A\u0005\nADq\u0001\u001e\u0001A\u0002\u0013%Q\u000f\u0003\u0004|\u0001\u0001\u0006K!\u001d\u0005\u0006y\u0002!\t\u0001\u001d\u0005\u0006{\u0002!\tA \u0005\u0007{\u0002!I!a\u0003\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!9\u0011\u0011\u0007\u0001\u0005\n\u0005M\u0002bBA\u001d\u0001\u0011%\u00111\b\u0005\b\u0003'\u0002A\u0011BA+\u0011\u001d\tI\u0006\u0001C\u0005\u00037Ba!! \u0001\t\u0003\u0001\bbBA@\u0001\u0011\u0005\u0011\u0011\u0011\u0005\b\u0003\u0013\u0003A\u0011AAF\u0011\u001d\ty\t\u0001C\u0001\u0003\u0017Cq!!%\u0001\t\u0003\t\t\tC\u0004\u0002\u0014\u0002!\t!!&\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002(\"9\u00111\u0016\u0001\u0005\u0002\u00055\u0006bBAb\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0003\u0017\u0004A\u0011AAg\u0011%\t)\u000eAI\u0001\n\u0003\t9\u000eC\u0004\u0002n\u0002!\t!a<\t\u000f\u0005E\b\u0001\"\u0001\u0002p\"9\u00111\u001f\u0001\u0005\u0002\u0005=\bbBA{\u0001\u0011\u0005\u0011q\u001f\u0005\b\u0003{\u0004A\u0011AA\u0000\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0005\u0007AqA!\u0006\u0001\t\u0013\tyO\u0001\u000bMK\u0006$WM]#q_\u000eDg)\u001b7f\u0007\u0006\u001c\u0007.\u001a\u0006\u0003O!\nQ!\u001a9pG\"T!!\u000b\u0016\u0002\rM,'O^3s\u0015\u0005Y\u0013!B6bM.\f7\u0001A\n\u0004\u00019\"\u0004CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$AB!osJ+g\r\u0005\u00026q5\taG\u0003\u00028U\u0005)Q\u000f^5mg&\u0011\u0011H\u000e\u0002\b\u0019><w-\u001b8h\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"\u0001\u0010#\u000e\u0003uR!AP \u0002\r\r|W.\\8o\u0015\tY\u0003I\u0003\u0002B\u0005\u00061\u0011\r]1dQ\u0016T\u0011aQ\u0001\u0004_J<\u0017BA#>\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f!b\u00195fG.\u0004x.\u001b8u!\tA5*D\u0001J\u0015\tQ\u0005&A\u0006dQ\u0016\u001c7\u000e]8j]R\u001c\u0018B\u0001'J\u0005UaU-\u00193fe\u0016\u0003xn\u00195DQ\u0016\u001c7\u000e]8j]R\fa\u0001P5oSRtDcA(R%B\u0011\u0001\u000bA\u0007\u0002M!)!h\u0001a\u0001w!)ai\u0001a\u0001\u000f\u0006!An\\2l+\u0005)\u0006C\u0001,`\u001b\u00059&B\u0001-Z\u0003\u0015awnY6t\u0015\tQ6,\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001X/\u0002\tU$\u0018\u000e\u001c\u0006\u0002=\u0006!!.\u0019<b\u0013\t\u0001wK\u0001\fSK\u0016tGO]1oiJ+\u0017\rZ,sSR,Gj\\2l\u0003\u0015awnY6!\u0003\u0019)\u0007o\\2igV\tA\r\u0005\u0003fM\"\\W\"A.\n\u0005\u001d\\&a\u0002+sK\u0016l\u0015\r\u001d\t\u0003_%L!A\u001b\u0019\u0003\u0007%sG\u000f\u0005\u0002QY&\u0011QN\n\u0002\u000b\u000bB|7\r[#oiJL\u0018aB3q_\u000eD7\u000fI\u0001\t?&\u001cH)\u001b:usV\t\u0011\u000f\u0005\u00020e&\u00111\u000f\r\u0002\b\u0005>|G.Z1o\u00031y\u0016n\u001d#jeRLx\fJ3r)\t1\u0018\u0010\u0005\u00020o&\u0011\u0001\u0010\r\u0002\u0005+:LG\u000fC\u0004{\u0013\u0005\u0005\t\u0019A9\u0002\u0007a$\u0013'A\u0005`SN$\u0015N\u001d;zA\u00059\u0011n\u001d#jeRL\u0018AB1tg&<g\u000e\u0006\u0003w\u007f\u0006\u0005\u0001\"B\u0014\r\u0001\u0004A\u0007bBA\u0002\u0019\u0001\u0007\u0011QA\u0001\fgR\f'\u000f^(gMN,G\u000fE\u00020\u0003\u000fI1!!\u00031\u0005\u0011auN\\4\u0015\u0007E\fi\u0001\u0003\u0004\u0002\u00105\u0001\ra[\u0001\u0006K:$(/_\u0001\be\u0016\u001cHo\u001c:f)\r1\u0018Q\u0003\u0005\b\u0003/q\u0001\u0019AA\r\u0003\u001d)g\u000e\u001e:jKN\u0004R!a\u0007\u0002,-tA!!\b\u0002(9!\u0011qDA\u0013\u001b\t\t\tCC\u0002\u0002$1\na\u0001\u0010:p_Rt\u0014\"A\u0019\n\u0007\u0005%\u0002'A\u0004qC\u000e\\\u0017mZ3\n\t\u00055\u0012q\u0006\u0002\u0005\u0019&\u001cHOC\u0002\u0002*A\n\u0001%\\1zE\u0016$&/\u001e8dCR,gj\u001c8N_:|Go\u001c8jG\u0016sGO]5fgR\u0019a/!\u000e\t\r\u0005]r\u00021\u0001l\u0003!qWm^#oiJL\u0018!\u0004:f[>4XM\u0012:p[\u0016sG\r\u0006\u0003\u0002>\u0005%\u0003#BA \u0003\u000bZWBAA!\u0015\r\t\u0019\u0005M\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA$\u0003\u0003\u00121aU3r\u0011\u001d\tY\u0005\u0005a\u0001\u0003\u001b\n\u0011\u0002\u001d:fI&\u001c\u0017\r^3\u0011\u000b=\nye[9\n\u0007\u0005E\u0003GA\u0005Gk:\u001cG/[8oc\u0005y!/Z7pm\u00164%o\\7Ti\u0006\u0014H\u000f\u0006\u0003\u0002>\u0005]\u0003bBA&#\u0001\u0007\u0011QJ\u0001\u0014e\u0016lwN^3XQ&dW-T1uG\"Lgn\u001a\u000b\u0007\u0003{\ti&a\u001f\t\u000f\u0005}#\u00031\u0001\u0002b\u0005A\u0011\u000e^3sCR|'\u000fE\u0003f\u0003G\n9'C\u0002\u0002fm\u0013\u0001\"\u0013;fe\u0006$xN\u001d\t\u0007\u0003S\n)\b[6\u000f\t\u0005-\u0014\u0011\u000f\b\u0005\u0003[\ny'D\u0001^\u0013\taV,C\u0002\u0002tm\u000b1!T1q\u0013\u0011\t9(!\u001f\u0003\u000b\u0015sGO]=\u000b\u0007\u0005M4\fC\u0004\u0002LI\u0001\r!!\u0014\u0002\u00119|g.R7qif\f1\u0002\\1uKN$XI\u001c;ssV\u0011\u00111\u0011\t\u0005_\u0005\u00155.C\u0002\u0002\bB\u0012aa\u00149uS>t\u0017a\u00037bi\u0016\u001cH/\u00129pG\",\"!!$\u0011\t=\n)\t[\u0001\u000eaJ,g/[8vg\u0016\u0003xn\u00195\u0002\u001b\u0015\f'\u000f\\5fgR,e\u000e\u001e:z\u00031)g\u000eZ(gMN,GOR8s)\u0019\t9*!(\u0002\"B1q&!'i\u0003\u000bI1!a'1\u0005\u0019!V\u000f\u001d7fe!1\u0011q\u0014\rA\u0002!\faB]3rk\u0016\u001cH/\u001a3Fa>\u001c\u0007\u000eC\u0004\u0002$b\u0001\r!!\u0002\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;\u0002\u001d=4gm]3u\r>\u0014X\t]8dQR!\u0011QAAU\u0011\u0019\ty*\u0007a\u0001Q\u0006Qb-\u001b8e\t&4XM]4f]\u000e,\u0017J\\#q_\u000eD7)Y2iKRa\u0011QAAX\u0003g\u000b9,a/\u0002@\"9\u0011\u0011\u0017\u000eA\u0002\u0005e\u0011\u0001\u0005;jKJ,G-\u00129pG\"\u001cF/\u0019;f\u0011\u001d\t)L\u0007a\u0001\u0003\u000b\t\u0011CZ5sgR$\u0016.\u001a:fI>3gm]3u\u0011\u001d\tIL\u0007a\u0001\u0003\u000b\t\u0001\u0003\\1tiRKWM]3e\u001f\u001a47/\u001a;\t\u000f\u0005u&\u00041\u0001\u0002\u0006\u0005\u0001b-\u001b:ti2{7-\u00197PM\u001a\u001cX\r\u001e\u0005\b\u0003\u0003T\u0002\u0019AA\u0003\u0003=a\u0017m\u001d;M_\u000e\fGn\u00144gg\u0016$\u0018a\u0004;sk:\u001c\u0017\r^3Ge>lWI\u001c3\u0015\u0007Y\f9\rC\u0004\u0002Jn\u0001\r!!\u0002\u0002\u0013\u0015tGm\u00144gg\u0016$\u0018!\u0005;sk:\u001c\u0017\r^3Ge>l7\u000b^1siR)a/a4\u0002R\"9\u00111\u0001\u000fA\u0002\u0005\u0015\u0001\u0002CAj9A\u0005\t\u0019A9\u0002!\u0019dWo\u001d5JMR\u0013XO\\2bi\u0016$\u0017a\u0007;sk:\u001c\u0017\r^3Ge>l7\u000b^1si\u0012\"WMZ1vYR$#'\u0006\u0002\u0002Z*\u001a\u0011/a7,\u0005\u0005u\u0007\u0003BAp\u0003Sl!!!9\u000b\t\u0005\r\u0018Q]\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a:1\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\f\tOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!\"\\1zE\u00164E.^:i)\u00051\u0018!D2mK\u0006\u0014\u0018I\u001c3GYV\u001c\b.A\u0003dY\u0016\f'/A\u0003dY>tW\rF\u0002P\u0003sDa!a?\"\u0001\u00049\u0015!\u00048fo\u000eCWmY6q_&tG/\u0001\u0007fa>\u001c\u0007.\u00128ue&,7/\u0006\u0002\u0002>\u0005\u00112O\\1qg\"|GOR8s'\u0016<W.\u001a8u)\u0011\u0011)A!\u0005\u0011\u000b=\u00129Aa\u0003\n\u0007\t%\u0001GA\u0003BeJ\f\u0017\u0010E\u00020\u0005\u001bI1Aa\u00041\u0005\u0011\u0011\u0015\u0010^3\t\u000f\tM1\u00051\u0001\u0002\u0006\u0005\u0011RM\u001c3PM\u001a\u001cX\r^%oG2,8/\u001b<f\u0003\u00151G.^:i\u0001")
public class LeaderEpochFileCache
implements Logging {
    private final TopicPartition topicPartition;
    private final LeaderEpochCheckpoint checkpoint;
    private final ReentrantReadWriteLock lock;
    private final TreeMap<Object, EpochEntry> epochs;
    private boolean _isDirty;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private TreeMap<Object, EpochEntry> epochs() {
        return this.epochs;
    }

    private boolean _isDirty() {
        return this._isDirty;
    }

    private void _isDirty_$eq(boolean x$1) {
        this._isDirty = x$1;
    }

    public boolean isDirty() {
        return this._isDirty();
    }

    public void assign(int epoch, long startOffset) {
        EpochEntry entry = new EpochEntry(epoch, startOffset);
        if (this.assign(entry)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Appended new epoch entry ").append(entry).append(". Cache now contains ").append(this.epochs().size()).append(" entries.").toString());
        }
    }

    private boolean assign(EpochEntry entry) {
        boolean bl;
        if (entry.epoch() < 0 || entry.startOffset() < 0L) {
            throw new IllegalArgumentException(new StringBuilder(46).append("Received invalid partition leader epoch entry ").append(entry).toString());
        }
        if (!this.isUpdateNeeded$1(entry)) {
            return false;
        }
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            bl = LeaderEpochFileCache.$anonfun$assign$2(this, entry);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        return bl;
    }

    public void restore(List<EpochEntry> entries) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$restore$1(this, entries);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private void maybeTruncateNonMonotonicEntries(EpochEntry newEntry) {
        Object var4_3;
        EpochEntry removeFromEnd_removeWhileMatching_entry;
        java.util.Iterator removeFromEnd_removeWhileMatching_iterator = this.epochs().descendingMap().entrySet().iterator();
        ListBuffer removeFromEnd_removeWhileMatching_removedEpochs = ListBuffer$.MODULE$.empty();
        while (removeFromEnd_removeWhileMatching_iterator.hasNext() && LeaderEpochFileCache.$anonfun$maybeTruncateNonMonotonicEntries$1(newEntry, removeFromEnd_removeWhileMatching_entry = (EpochEntry)removeFromEnd_removeWhileMatching_iterator.next().getValue())) {
            removeFromEnd_removeWhileMatching_removedEpochs.$plus$eq((Object)removeFromEnd_removeWhileMatching_entry);
            removeFromEnd_removeWhileMatching_iterator.remove();
        }
        void v0 = var4_3;
        Object var3_2 = null;
        var4_3 = null;
        Object var5_4 = null;
        void removedEpochs = v0;
        if (removedEpochs.size() > 1 || removedEpochs.nonEmpty() && ((EpochEntry)removedEpochs.head()).startOffset() != newEntry.startOffset()) {
            this.warn((Function0<String>)((Function0 & Serializable)() -> LeaderEpochFileCache.$anonfun$maybeTruncateNonMonotonicEntries$2(this, newEntry, (Seq)removedEpochs)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Seq<EpochEntry> removeFromEnd(Function1<EpochEntry, Object> predicate) {
        void var3_3;
        EpochEntry removeWhileMatching_entry;
        java.util.Iterator removeWhileMatching_iterator = this.epochs().descendingMap().entrySet().iterator();
        ListBuffer removeWhileMatching_removedEpochs = ListBuffer$.MODULE$.empty();
        while (removeWhileMatching_iterator.hasNext() && BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)(removeWhileMatching_entry = (EpochEntry)removeWhileMatching_iterator.next().getValue())))) {
            removeWhileMatching_removedEpochs.$plus$eq((Object)removeWhileMatching_entry);
            removeWhileMatching_iterator.remove();
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<EpochEntry> removeFromStart(Function1<EpochEntry, Object> predicate) {
        void var3_3;
        EpochEntry removeWhileMatching_entry;
        java.util.Iterator<Map.Entry<Object, EpochEntry>> removeWhileMatching_iterator = this.epochs().entrySet().iterator();
        ListBuffer removeWhileMatching_removedEpochs = ListBuffer$.MODULE$.empty();
        while (removeWhileMatching_iterator.hasNext() && BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)(removeWhileMatching_entry = removeWhileMatching_iterator.next().getValue())))) {
            removeWhileMatching_removedEpochs.$plus$eq((Object)removeWhileMatching_entry);
            removeWhileMatching_iterator.remove();
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<EpochEntry> removeWhileMatching(java.util.Iterator<Map.Entry<Object, EpochEntry>> iterator, Function1<EpochEntry, Object> predicate) {
        void var3_3;
        ListBuffer removedEpochs = ListBuffer$.MODULE$.empty();
        while (iterator.hasNext()) {
            EpochEntry entry = iterator.next().getValue();
            if (BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)entry))) {
                removedEpochs.$plus$eq((Object)entry);
                iterator.remove();
                continue;
            }
            return removedEpochs;
        }
        return var3_3;
    }

    public boolean nonEmpty() {
        boolean bl;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            bl = LeaderEpochFileCache.$anonfun$nonEmpty$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return bl;
    }

    public Option<EpochEntry> latestEntry() {
        Option option;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = LeaderEpochFileCache.$anonfun$latestEntry$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    public Option<Object> latestEpoch() {
        return this.latestEntry().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.epoch()));
    }

    public Option<Object> previousEpoch() {
        Option option;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = LeaderEpochFileCache.$anonfun$previousEpoch$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    public Option<EpochEntry> earliestEntry() {
        Option option;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = LeaderEpochFileCache.$anonfun$earliestEntry$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    public Tuple2<Object, Object> endOffsetFor(int requestedEpoch, long logEndOffset) {
        Tuple2 tuple2;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            tuple2 = LeaderEpochFileCache.$anonfun$endOffsetFor$1(this, requestedEpoch, logEndOffset);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return tuple2;
    }

    public long offsetForEpoch(int requestedEpoch) {
        long l;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            l = LeaderEpochFileCache.$anonfun$offsetForEpoch$1(this, requestedEpoch);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return l;
    }

    public long findDivergenceInEpochCache(List<EpochEntry> tieredEpochState, long firstTieredOffset, long lastTieredOffset, long firstLocalOffset, long lastLocalOffset) {
        Object object = new Object();
        try {
            long l;
            Lock inReadLock_inLock_lock = this.lock().readLock();
            inReadLock_inLock_lock.lock();
            try {
                l = LeaderEpochFileCache.$anonfun$findDivergenceInEpochCache$1(this, tieredEpochState, object, firstLocalOffset, lastLocalOffset, firstTieredOffset, lastTieredOffset);
            }
            finally {
                inReadLock_inLock_lock.unlock();
            }
            return l;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcJ$sp();
            }
            throw ex;
        }
    }

    public void truncateFromEnd(long endOffset) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$truncateFromEnd$1(this, endOffset);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void truncateFromStart(long startOffset, boolean flushIfTruncated) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$truncateFromStart$1(this, startOffset, flushIfTruncated);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public boolean truncateFromStart$default$2() {
        return true;
    }

    public void maybeFlush() {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$maybeFlush$1(this);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void clearAndFlush() {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$clearAndFlush$1(this);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void clear() {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$clear$1(this);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public LeaderEpochFileCache clone(LeaderEpochCheckpoint newCheckpoint) {
        LeaderEpochFileCache leaderEpochFileCache;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            leaderEpochFileCache = LeaderEpochFileCache.$anonfun$clone$1(this, newCheckpoint);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return leaderEpochFileCache;
    }

    public Seq<EpochEntry> epochEntries() {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(this.epochs().values()).asScala().toSeq();
    }

    public byte[] snapshotForSegment(long endOffsetInclusive) {
        byte[] byArray;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            byArray = this.checkpoint.toByteArray((Seq<EpochEntry>)((Seq)this.epochEntries().filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$snapshotForSegment$2(endOffsetInclusive$1, e)))));
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return byArray;
    }

    private void flush() {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Flushing leader epoch cache for partition ").append($this.topicPartition).append(", isDirty is ").append(this.isDirty()).toString());
        this.checkpoint.write((Iterable<EpochEntry>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.epochs().values()).asScala());
        this._isDirty_$eq(false);
    }

    public static final /* synthetic */ void $anonfun$new$1(LeaderEpochFileCache $this) {
        $this.checkpoint.read().foreach((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)$this.assign(entry)));
    }

    private final boolean isUpdateNeeded$1(EpochEntry entry$2) {
        boolean bl;
        Option<EpochEntry> option = this.latestEntry();
        if (option instanceof Some) {
            EpochEntry lastEntry = (EpochEntry)((Some)option).value();
            bl = entry$2.epoch() != lastEntry.epoch() || entry$2.startOffset() < lastEntry.startOffset();
        } else if (None$.MODULE$.equals(option)) {
            bl = true;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$assign$2(LeaderEpochFileCache $this, EpochEntry entry$2) {
        if ($this.isUpdateNeeded$1(entry$2)) {
            $this.maybeTruncateNonMonotonicEntries(entry$2);
            $this.epochs().put(BoxesRunTime.boxToInteger((int)entry$2.epoch()), entry$2);
            $this._isDirty_$eq(true);
            return true;
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$restore$1(LeaderEpochFileCache $this, List entries$1) {
        $this.epochs().clear();
        entries$1.foreach((Function1 & Serializable)entry -> {
            $this.maybeTruncateNonMonotonicEntries((EpochEntry)entry);
            return $this.epochs().put(BoxesRunTime.boxToInteger((int)entry.epoch()), (EpochEntry)entry);
        });
        $this.flush();
    }

    public static final /* synthetic */ boolean $anonfun$maybeTruncateNonMonotonicEntries$1(EpochEntry newEntry$1, EpochEntry entry) {
        return entry.epoch() >= newEntry$1.epoch() || entry.startOffset() >= newEntry$1.startOffset();
    }

    public static final /* synthetic */ String $anonfun$maybeTruncateNonMonotonicEntries$2(LeaderEpochFileCache $this, EpochEntry newEntry$1, Seq removedEpochs$1) {
        return new StringBuilder(0).append(new StringBuilder(60).append("New epoch entry ").append(newEntry$1).append(" caused truncation of conflicting entries ").append(removedEpochs$1).append(". ").toString()).append(new StringBuilder(28).append("Cache now contains ").append($this.epochs().size()).append(" entries.").toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$nonEmpty$1(LeaderEpochFileCache $this) {
        return !$this.epochs().isEmpty();
    }

    public static final /* synthetic */ Option $anonfun$latestEntry$1(LeaderEpochFileCache $this) {
        return Option$.MODULE$.apply($this.epochs().lastEntry()).map((Function1 & Serializable)x$1 -> (EpochEntry)x$1.getValue());
    }

    public static final /* synthetic */ int $anonfun$previousEpoch$3(Map.Entry x$3) {
        return BoxesRunTime.unboxToInt(x$3.getKey());
    }

    public static final /* synthetic */ Option $anonfun$previousEpoch$1(LeaderEpochFileCache $this) {
        return $this.latestEntry().flatMap((Function1 & Serializable)entry -> Option$.MODULE$.apply($this.epochs().lowerEntry(BoxesRunTime.boxToInteger((int)entry.epoch())))).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)LeaderEpochFileCache.$anonfun$previousEpoch$3(x$3)));
    }

    public static final /* synthetic */ Option $anonfun$earliestEntry$1(LeaderEpochFileCache $this) {
        return Option$.MODULE$.apply($this.epochs().firstEntry()).map((Function1 & Serializable)x$4 -> (EpochEntry)x$4.getValue());
    }

    public static final /* synthetic */ String $anonfun$endOffsetFor$2(LeaderEpochFileCache $this, int requestedEpoch$1, Tuple2 epochAndOffset$1) {
        return new StringBuilder(0).append(new StringBuilder(61).append("Processed end offset request for epoch ").append(requestedEpoch$1).append(" and returning epoch ").append(epochAndOffset$1._1$mcI$sp()).append(" ").toString()).append(new StringBuilder(42).append("with end offset ").append(epochAndOffset$1._2$mcJ$sp()).append(" from epoch cache of size ").append($this.epochs().size()).toString()).toString();
    }

    public static final /* synthetic */ Tuple2 $anonfun$endOffsetFor$1(LeaderEpochFileCache $this, int requestedEpoch$1, long logEndOffset$1) {
        Map.Entry<Object, EpochEntry> floorEntry;
        Map.Entry<Object, EpochEntry> higherEntry;
        Tuple2.mcIJ.sp epochAndOffset = requestedEpoch$1 == -1 ? new Tuple2.mcIJ.sp(-1, -1L) : ($this.latestEpoch().contains((Object)BoxesRunTime.boxToInteger((int)requestedEpoch$1)) ? new Tuple2.mcIJ.sp(requestedEpoch$1, logEndOffset$1) : ((higherEntry = $this.epochs().higherEntry(BoxesRunTime.boxToInteger((int)requestedEpoch$1))) == null ? new Tuple2.mcIJ.sp(-1, -1L) : ((floorEntry = $this.epochs().floorEntry(BoxesRunTime.boxToInteger((int)requestedEpoch$1))) == null ? new Tuple2.mcIJ.sp(requestedEpoch$1, higherEntry.getValue().startOffset()) : new Tuple2.mcIJ.sp(floorEntry.getValue().epoch(), higherEntry.getValue().startOffset()))));
        $this.trace((Function0<String>)((Function0 & Serializable)() -> LeaderEpochFileCache.$anonfun$endOffsetFor$2($this, requestedEpoch$1, (Tuple2)epochAndOffset)));
        return epochAndOffset;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$offsetForEpoch$1(LeaderEpochFileCache $this, int requestedEpoch$2) {
        void var2_2;
        long requestedStartOffset = requestedEpoch$2 == -1 || !$this.epochs().containsKey(BoxesRunTime.boxToInteger((int)requestedEpoch$2)) ? -1L : $this.epochs().get(BoxesRunTime.boxToInteger((int)requestedEpoch$2)).startOffset();
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Processed start offset request for epoch ").append(requestedEpoch$2).append(" and returning start offset ").append(requestedStartOffset).toString());
        return (long)var2_2;
    }

    public static final /* synthetic */ void $anonfun$findDivergenceInEpochCache$5(LeaderEpochFileCache $this, long lastLocalOffset$1, ObjectRef localEpochAndOffsetRanges$1, Map.Entry entry) {
        Map.Entry<Object, EpochEntry> nextEntry = $this.epochs().higherEntry(entry.getKey());
        long numMessages = nextEntry == null ? lastLocalOffset$1 - ((EpochEntry)entry.getValue()).startOffset() + 1L : nextEntry.getValue().startOffset() - ((EpochEntry)entry.getValue()).startOffset();
        localEpochAndOffsetRanges$1.elem = (Map)((Map)localEpochAndOffsetRanges$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)((EpochEntry)entry.getValue()).epoch())), (Object)new Tuple2.mcJJ.sp(((EpochEntry)entry.getValue()).startOffset(), numMessages)));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$findDivergenceInEpochCache$1(LeaderEpochFileCache $this, List tieredEpochState$1, Object nonLocalReturnKey1$1, long firstLocalOffset$1, long lastLocalOffset$1, long firstTieredOffset$1, long lastTieredOffset$1) {
        LongRef divergenceOffset = LongRef.create((long)-1L);
        if ($this.epochs().isEmpty() || tieredEpochState$1.isEmpty()) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> "Local epoch cache or the tiered state is empty. Hence, no divergence.");
            throw new NonLocalReturnControl.mcJ.sp(nonLocalReturnKey1$1, divergenceOffset.elem);
        }
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(79).append("Find divergence between local leader epoch cache ").append($this.epochs()).append(" [startOffset: ").append(firstLocalOffset$1).append(" lastOffset: ").append(lastLocalOffset$1).append("] ").toString()).append(new StringBuilder(59).append("and tiered leader epoch state ").append(tieredEpochState$1).append(" [startOffset: ").append(firstTieredOffset$1).append(" lastOffset: ").append(lastTieredOffset$1).append("]").toString()).toString());
        ObjectRef tieredEpochAndOffsetRanges = ObjectRef.create((Object)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        tieredEpochState$1.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            long numMessages = i + 1 == tieredEpochState$1.size() ? lastTieredOffset$1 - ((EpochEntry)tieredEpochState$1.apply(i)).startOffset() + 1L : ((EpochEntry)tieredEpochState$1.apply(i + 1)).startOffset() - ((EpochEntry)tieredEpochState$1.apply(i)).startOffset();
            tieredEpochAndOffsetRanges$1.elem = (List)((List)tieredEpochAndOffsetRanges$1.elem).$colon$plus((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)((EpochEntry)tieredEpochState$1.apply(i)).epoch()), (Object)BoxesRunTime.boxToLong((long)((EpochEntry)tieredEpochState$1.apply(i)).startOffset()), (Object)BoxesRunTime.boxToLong((long)numMessages)));
        });
        ObjectRef localEpochAndOffsetRanges = ObjectRef.create((Object)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        CollectionConverters$.MODULE$.SetHasAsScala($this.epochs().entrySet()).asScala().foreach((Function1 & Serializable)entry -> {
            LeaderEpochFileCache.$anonfun$findDivergenceInEpochCache$5($this, lastLocalOffset$1, localEpochAndOffsetRanges, entry);
            return BoxedUnit.UNIT;
        });
        Iterator it = ((List)tieredEpochAndOffsetRanges.elem).iterator();
        while (divergenceOffset.elem == -1L && it.hasNext()) {
            void var19_14;
            void var17_13;
            Tuple2 tuple2;
            void var16_12;
            Tuple3 tuple3 = (Tuple3)it.next();
            if (tuple3 == null) {
                throw new MatchError(null);
            }
            int tieredEpoch = BoxesRunTime.unboxToInt((Object)tuple3._1());
            long tieredEpochStartOffset = BoxesRunTime.unboxToLong((Object)tuple3._2());
            long tieredEpochNumMessages = BoxesRunTime.unboxToLong((Object)tuple3._3());
            Option option = ((Map)localEpochAndOffsetRanges.elem).get((Object)BoxesRunTime.boxToInteger((int)var16_12));
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                long localEpochStartOffset = tuple2._1$mcJ$sp();
                long localEpochNumMessages = tuple2._2$mcJ$sp();
                if (var17_13 != localEpochStartOffset && (var16_12 != $this.epochs().firstEntry().getValue().epoch() || localEpochStartOffset < var17_13)) {
                    divergenceOffset.elem = Math.min((long)var17_13, localEpochStartOffset);
                }
                if (divergenceOffset.elem != -1L) continue;
                if (var17_13 + var19_14 < localEpochStartOffset + localEpochNumMessages && var17_13 + var19_14 - 1L != lastTieredOffset$1) {
                    divergenceOffset.elem = var17_13 + var19_14;
                    continue;
                }
                if (var17_13 + var19_14 <= localEpochStartOffset + localEpochNumMessages || localEpochStartOffset + localEpochNumMessages - 1L == lastLocalOffset$1) continue;
                divergenceOffset.elem = localEpochStartOffset + localEpochNumMessages;
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                if (var17_13 + var19_14 - 1L < firstLocalOffset$1 || var17_13 > lastLocalOffset$1 || var19_14 == 0L) continue;
                divergenceOffset.elem = var17_13;
                continue;
            }
            throw new MatchError((Object)option);
        }
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Divergence reported: ").append(divergenceOffset$1.elem).toString());
        return divergenceOffset.elem;
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromEnd$2(long endOffset$1, EpochEntry x$6) {
        return x$6.startOffset() >= endOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromEnd$3(long endOffset$1, EpochEntry x$7) {
        return x$7.startOffset() >= endOffset$1;
    }

    public static final /* synthetic */ String $anonfun$truncateFromEnd$4(LeaderEpochFileCache $this, Seq removedEntries$1, long endOffset$1) {
        return new StringBuilder(0).append(new StringBuilder(40).append("Cleared entries ").append(removedEntries$1).append(" from epoch cache after ").toString()).append(new StringBuilder(57).append("truncating to end offset ").append(endOffset$1).append(", leaving ").append($this.epochs().size()).append(" entries in the cache.").toString()).toString();
    }

    public static final /* synthetic */ void $anonfun$truncateFromEnd$1(LeaderEpochFileCache $this, long endOffset$1) {
        if (endOffset$1 >= 0L && $this.latestEntry().exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromEnd$2(endOffset$1, x$6)))) {
            Object var5_3;
            EpochEntry removeFromEnd_removeWhileMatching_entry;
            java.util.Iterator removeFromEnd_removeWhileMatching_iterator = $this.epochs().descendingMap().entrySet().iterator();
            ListBuffer removeFromEnd_removeWhileMatching_removedEpochs = ListBuffer$.MODULE$.empty();
            while (removeFromEnd_removeWhileMatching_iterator.hasNext() && LeaderEpochFileCache.$anonfun$truncateFromEnd$3(endOffset$1, removeFromEnd_removeWhileMatching_entry = (EpochEntry)removeFromEnd_removeWhileMatching_iterator.next().getValue())) {
                removeFromEnd_removeWhileMatching_removedEpochs.$plus$eq((Object)removeFromEnd_removeWhileMatching_entry);
                removeFromEnd_removeWhileMatching_iterator.remove();
            }
            void v0 = var5_3;
            Object var4_2 = null;
            var5_3 = null;
            Object var6_4 = null;
            Object var7_5 = v0;
            void v1 = var7_5;
            var7_5 = null;
            void removedEntries = v1;
            $this.flush();
            $this.debug((Function0<String>)((Function0 & Serializable)() -> LeaderEpochFileCache.$anonfun$truncateFromEnd$4($this, (Seq)removedEntries, endOffset$1)));
        }
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromStart$2(long startOffset$1, EpochEntry entry) {
        return entry.startOffset() <= startOffset$1;
    }

    public static final /* synthetic */ void $anonfun$truncateFromStart$3(LeaderEpochFileCache $this, long startOffset$1, boolean flushIfTruncated$1, Seq removedEntries$2, EpochEntry firstBeforeStartOffset) {
        EpochEntry updatedFirstEntry = new EpochEntry(firstBeforeStartOffset.epoch(), startOffset$1);
        $this.epochs().put(BoxesRunTime.boxToInteger((int)updatedFirstEntry.epoch()), updatedFirstEntry);
        if (flushIfTruncated$1) {
            $this.flush();
        } else {
            $this._isDirty_$eq(true);
        }
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Cleared entries ").append(removedEntries$2).append(" and rewrote first entry ").append(updatedFirstEntry).append(" after ").toString()).append(new StringBuilder(51).append("truncating to start offset ").append(startOffset$1).append(", leaving ").append($this.epochs().size()).append(" in the cache.").toString()).toString());
    }

    public static final /* synthetic */ void $anonfun$truncateFromStart$1(LeaderEpochFileCache $this, long startOffset$1, boolean flushIfTruncated$1) {
        Object var6_4;
        EpochEntry removeFromStart_removeWhileMatching_entry;
        java.util.Iterator<Map.Entry<Object, EpochEntry>> removeFromStart_removeWhileMatching_iterator = $this.epochs().entrySet().iterator();
        ListBuffer removeFromStart_removeWhileMatching_removedEpochs = ListBuffer$.MODULE$.empty();
        while (removeFromStart_removeWhileMatching_iterator.hasNext() && LeaderEpochFileCache.$anonfun$truncateFromStart$2(startOffset$1, removeFromStart_removeWhileMatching_entry = removeFromStart_removeWhileMatching_iterator.next().getValue())) {
            removeFromStart_removeWhileMatching_removedEpochs.$plus$eq((Object)removeFromStart_removeWhileMatching_entry);
            removeFromStart_removeWhileMatching_iterator.remove();
        }
        void v0 = var6_4;
        Object var5_3 = null;
        var6_4 = null;
        Object var7_5 = null;
        void removedEntries = v0;
        removedEntries.lastOption().foreach(arg_0 -> LeaderEpochFileCache.$anonfun$truncateFromStart$3$adapted($this, startOffset$1, flushIfTruncated$1, (Seq)removedEntries, arg_0));
    }

    public static final /* synthetic */ void $anonfun$maybeFlush$1(LeaderEpochFileCache $this) {
        if ($this._isDirty()) {
            $this.flush();
        }
    }

    public static final /* synthetic */ void $anonfun$clearAndFlush$1(LeaderEpochFileCache $this) {
        $this.epochs().clear();
        $this.flush();
    }

    public static final /* synthetic */ void $anonfun$clear$1(LeaderEpochFileCache $this) {
        $this.epochs().clear();
        $this._isDirty_$eq(true);
    }

    public static final /* synthetic */ LeaderEpochFileCache $anonfun$clone$1(LeaderEpochFileCache $this, LeaderEpochCheckpoint newCheckpoint$1) {
        newCheckpoint$1.write((Iterable<EpochEntry>)CollectionConverters$.MODULE$.CollectionHasAsScala($this.epochs().values()).asScala());
        return new LeaderEpochFileCache($this.topicPartition, newCheckpoint$1);
    }

    public static final /* synthetic */ boolean $anonfun$snapshotForSegment$2(long endOffsetInclusive$1, EpochEntry e) {
        return e.startOffset() <= endOffsetInclusive$1;
    }

    public LeaderEpochFileCache(TopicPartition topicPartition, LeaderEpochCheckpoint checkpoint) {
        this.topicPartition = topicPartition;
        this.checkpoint = checkpoint;
        this.logIdent_$eq(new StringBuilder(20).append("[LeaderEpochCache ").append(topicPartition).append("] ").toString());
        this.lock = new ReentrantReadWriteLock();
        this.epochs = new TreeMap();
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$new$1(this);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        this._isDirty = false;
    }

    public static final /* synthetic */ Object $anonfun$maybeTruncateNonMonotonicEntries$1$adapted(EpochEntry newEntry$1, EpochEntry entry) {
        return BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$maybeTruncateNonMonotonicEntries$1(newEntry$1, entry));
    }

    public static final /* synthetic */ Object $anonfun$truncateFromEnd$3$adapted(long endOffset$1, EpochEntry x$7) {
        return BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromEnd$3(endOffset$1, x$7));
    }

    public static final /* synthetic */ Object $anonfun$truncateFromStart$2$adapted(long startOffset$1, EpochEntry entry) {
        return BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromStart$2(startOffset$1, entry));
    }

    public static final /* synthetic */ Object $anonfun$truncateFromStart$3$adapted(LeaderEpochFileCache $this, long startOffset$1, boolean flushIfTruncated$1, Seq removedEntries$2, EpochEntry firstBeforeStartOffset) {
        LeaderEpochFileCache.$anonfun$truncateFromStart$3($this, startOffset$1, flushIfTruncated$1, removedEntries$2, firstBeforeStartOffset);
        return BoxedUnit.UNIT;
    }
}

