/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import kafka.cluster.BrokerEndPoint;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaFetcherBlockingSend;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.FetchResponseSize;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class ClusterLinkFetcherThread$ {
    public static final ClusterLinkFetcherThread$ MODULE$ = new ClusterLinkFetcherThread$();

    public Option<LogContext> $lessinit$greater$default$16() {
        return None$.MODULE$;
    }

    public ClusterLinkFetcherThread apply(String name, int fetcherId, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata, ClusterLinkFetcherManager fetcherManager, ClusterLinkDestConnectionManager destConnectionManager, BrokerEndPoint sourceBroker, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics, Time time, Option<String> tenant, Function0<FetchResponseSize> dynamicFetchSize) {
        int brokerId = brokerConfig.brokerId();
        LogContext logContext = new LogContext(new StringBuilder(0).append(new StringBuilder(30).append("[ClusterLinkFetcher brokerId=").append(brokerId).append(" ").toString()).append(new StringBuilder(38).append("fetcherId=").append(fetcherId).append("] source(link=").append(clusterLinkMetadata.linkName()).append(", leaderId=").append(sourceBroker.id()).append(")] ").toString()).toString(), destConnectionManager.maxLogLevel());
        ClusterLinkNetworkClient clusterLinkClient = new ClusterLinkNetworkClient(clusterLinkConfig, ClusterLinkMetrics$.MODULE$.throttleTimeSensorName(clusterLinkMetadata.linkName()), (Option<ClusterLinkMetadata>)None$.MODULE$, (Option<MetadataUpdater>)new Some((Object)new ManualMetadataUpdater()), clusterLinkMetrics.metrics(), (Map<String, String>)((Map)ClusterLinkFactory$.MODULE$.linkMetricTags(clusterLinkMetadata.linkName()).$plus$plus((IterableOnce)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)Integer.toString(sourceBroker.id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-id"), (Object)Integer.toString(fetcherId))})))), time, new StringBuilder(22).append("link-").append(clusterLinkMetadata.linkName()).append("-broker-").append(brokerId).append("-fetcher-").append(fetcherId).toString(), "fetcher", logContext);
        destConnectionManager.enableClusterLink(clusterLinkClient, (Option<AdminMetadataManager>)None$.MODULE$);
        ReplicaFetcherBlockingSend leaderEndpoint = new ReplicaFetcherBlockingSend(sourceBroker, brokerConfig, Predef$.MODULE$.Integer2int(clusterLinkConfig.replicaSocketTimeoutMs()), time, clusterLinkClient.networkClient(), (Option<Reconfigurable>)None$.MODULE$);
        return new ClusterLinkFetcherThread(name, fetcherId, brokerConfig, clusterLinkConfig, clusterLinkMetadata, fetcherManager, sourceBroker, failedPartitions, replicaMgr, quota, clusterLinkMetrics, time, dynamicFetchSize, clusterLinkClient, leaderEndpoint, (Option<LogContext>)new Some((Object)logContext), tenant);
    }

    private ClusterLinkFetcherThread$() {
    }
}

