/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import kafka.server.ConfigType$;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.MirrorTopicConfigsDelegate;
import kafka.zk.TopicZNode;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r\u001dc\u0001B#G\u00015C\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0016\u0005\tI\u0002\u0011\t\u0011)A\u0005K\"A\u0001\u000e\u0001B\u0001B\u0003%\u0011\u000eC\u0005{\u0001\t\u0005\t\u0015!\u0003|}\"I\u0011\u0011\u0001\u0001\u0003\u0002\u0003\u0006Ia\u001f\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011%\t\u0019\u0002\u0001a\u0001\n\u0013\t)\u0002C\u0005\u0002\u001e\u0001\u0001\r\u0011\"\u0003\u0002 !A\u00111\u0006\u0001!B\u0013\t9\u0002C\u0005\u0002.\u0001\u0001\r\u0011\"\u0003\u0002\u0016!I\u0011q\u0006\u0001A\u0002\u0013%\u0011\u0011\u0007\u0005\t\u0003k\u0001\u0001\u0015)\u0003\u0002\u0018!I\u0011q\u0007\u0001A\u0002\u0013%\u0011Q\u0003\u0005\n\u0003s\u0001\u0001\u0019!C\u0005\u0003wA\u0001\"a\u0010\u0001A\u0003&\u0011q\u0003\u0005\n\u0003\u0003\u0002\u0001\u0019!C\u0005\u0003+A\u0011\"a\u0011\u0001\u0001\u0004%I!!\u0012\t\u0011\u0005%\u0003\u0001)Q\u0005\u0003/A\u0011\"a\u0013\u0001\u0001\u0004%I!!\u0014\t\u0013\u0005}\u0003\u00011A\u0005\n\u0005\u0005\u0004\u0002CA3\u0001\u0001\u0006K!a\u0014\t\u0013\u0005\u001d\u0004\u00011A\u0005\n\u00055\u0003\"CA5\u0001\u0001\u0007I\u0011BA6\u0011!\ty\u0007\u0001Q!\n\u0005=\u0003bCA9\u0001\u0001\u0007\t\u0019!C\u0005\u0003gB1\"a\"\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\n\"Y\u0011Q\u0012\u0001A\u0002\u0003\u0005\u000b\u0015BA;\u0011-\ty\t\u0001a\u0001\u0002\u0004%I!!%\t\u0017\u0005}\u0005\u00011AA\u0002\u0013%\u0011\u0011\u0015\u0005\f\u0003K\u0003\u0001\u0019!A!B\u0013\t\u0019\nC\u0006\u0002(\u0002\u0001\r\u00111A\u0005\n\u0005%\u0006bCAb\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000bD1\"!3\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002,\"9\u00111\u001a\u0001\u0005R\u00055\u0007bBAh\u0001\u0011\u0005\u0011Q\u001a\u0005\b\u0003#\u0004A\u0011BAg\u0011\u001d\t\u0019\u000e\u0001C\u0005\u0003+Dq!a?\u0001\t\u0013\ti\u0010C\u0004\u0003\b\u0001!I!!4\t\u000f\t%\u0001\u0001\"\u0003\u0003\f!9!\u0011\u0004\u0001\u0005\n\tm\u0001b\u0002B\u0011\u0001\u0011%\u0011Q\u001a\u0005\b\u0005G\u0001A\u0011\u0002B\u0013\u0011\u001d\u00119\u0004\u0001C\u0005\u0005sAqA!\u0011\u0001\t\u0013\u0011\u0019\u0005C\u0004\u0003H\u0001!IA!\u0013\t\u000f\t\r\u0004\u0001\"\u0003\u0003f!9!\u0011\u000f\u0001\u0005\n\tM\u0004b\u0002B>\u0001\u0011%!Q\u0010\u0005\b\u0005\u001b\u0003A\u0011BAg\u0011\u001d\u0011y\t\u0001C\u0005\u0005#CqA!'\u0001\t\u0013\u0011Y\nC\u0004\u0003<\u0002!IA!0\t\u000f\t%\u0007\u0001\"\u0003\u0003L\"9!q\u001b\u0001\u0005\n\te\u0007b\u0002Bt\u0001\u0011%\u0011Q\u001a\u0005\b\u0005S\u0004A\u0011\u0002Bv\u0011\u001d\u00119\u0010\u0001C\u0005\u0005sDQba\u0011\u0001!\u0003\r\t\u0011!C\u0005\u0007\u000brxa\u0002B\u0000\r\"\u00051\u0011\u0001\u0004\u0007\u000b\u001aC\taa\u0001\t\u000f\u0005\rQ\b\"\u0001\u0004\f\u001911QB\u001f\u0001\u0007\u001fA\u0011ba\u0006@\u0005\u0003\u0005\u000b\u0011B,\t\u0015\reqH!A!\u0002\u0013\u0011\t\u0010C\u0004\u0002\u0004}\"\taa\u0007\t\u0013\r\u0015R(%A\u0005\u0002\r\u001d\u0002\"CB\u001f{E\u0005I\u0011AB\u0014\u0005i\u0019E.^:uKJd\u0015N\\6Ti>\u0004X*\u001b:s_J$v\u000e]5d\u0015\t9\u0005*\u0001\u0003mS:\\'BA%K\u0003\u0019\u0019XM\u001d<fe*\t1*A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001q\u0005CA(T\u001d\t\u0001\u0016+D\u0001G\u0013\t\u0011f)\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0005\u0003)V\u0013A\u0002U3sS>$\u0017n\u0019+bg.T!A\u0015$\u0002\u000bQ|\u0007/[2\u0011\u0005a\u000bgBA-`!\tQV,D\u0001\\\u0015\taF*\u0001\u0004=e>|GO\u0010\u0006\u0002=\u0006)1oY1mC&\u0011\u0001-X\u0001\u0007!J,G-\u001a4\n\u0005\t\u001c'AB*ue&twM\u0003\u0002a;\u0006i1\r\\5f]Rl\u0015M\\1hKJ\u0004\"\u0001\u00154\n\u0005\u001d4%\u0001G\"mkN$XM\u001d'j].\u001cE.[3oi6\u000bg.Y4fe\u0006QAn\\2bY\u0006#W.\u001b8\u0011\u0007)\\W.D\u0001^\u0013\taWLA\u0005Gk:\u001cG/[8oaA\u0011a\u000e_\u0007\u0002_*\u0011\u0001/]\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003eN\fqa\u00197jK:$8O\u0003\u0002Li*\u0011QO^\u0001\u0007CB\f7\r[3\u000b\u0003]\f1a\u001c:h\u0013\tIxN\u0001\bD_:4G.^3oi\u0006#W.\u001b8\u0002\u0015%tG/\u001a:wC2l5\u000f\u0005\u0002ky&\u0011Q0\u0018\u0002\u0004\u0013:$\u0018BA@T\u0003E\u0011Xm]2iK\u0012,H.\u001a#fY\u0006LXj]\u0001\u000fC\u0012l\u0017N\u001c+j[\u0016|W\u000f^'t\u0003\u0019a\u0014N\\5u}Qa\u0011qAA\u0005\u0003\u0017\ti!a\u0004\u0002\u0012A\u0011\u0001\u000b\u0001\u0005\u0006-\u001a\u0001\ra\u0016\u0005\u0006I\u001a\u0001\r!\u001a\u0005\u0006Q\u001a\u0001\r!\u001b\u0005\bu\u001a\u0001\n\u00111\u0001|\u0011!\t\tA\u0002I\u0001\u0002\u0004Y\u0018aC:z]\u000eD'o\u001c8ju\u0016,\"!a\u0006\u0011\u0007)\fI\"C\u0002\u0002\u001cu\u0013qAQ8pY\u0016\fg.A\bts:\u001c\u0007N]8oSj,w\fJ3r)\u0011\t\t#a\n\u0011\u0007)\f\u0019#C\u0002\u0002&u\u0013A!\u00168ji\"I\u0011\u0011\u0006\u0005\u0002\u0002\u0003\u0007\u0011qC\u0001\u0004q\u0012\n\u0014\u0001D:z]\u000eD'o\u001c8ju\u0016\u0004\u0013AE;qI\u0006$X\r\u001a+pa&\u001c7i\u001c8gS\u001e\fa#\u001e9eCR,G\rV8qS\u000e\u001cuN\u001c4jO~#S-\u001d\u000b\u0005\u0003C\t\u0019\u0004C\u0005\u0002*-\t\t\u00111\u0001\u0002\u0018\u0005\u0019R\u000f\u001d3bi\u0016$Gk\u001c9jG\u000e{gNZ5hA\u0005\u0019R\u000f\u001d3bi\u0016$wI]8va>3gm]3ug\u00069R\u000f\u001d3bi\u0016$wI]8va>3gm]3ug~#S-\u001d\u000b\u0005\u0003C\ti\u0004C\u0005\u0002*9\t\t\u00111\u0001\u0002\u0018\u0005!R\u000f\u001d3bi\u0016$wI]8va>3gm]3ug\u0002\nA#\u001e9eCR,GMU3qY&\u001c\u0017m\u0015;biV\u001c\u0018\u0001G;qI\u0006$X\r\u001a*fa2L7-Y*uCR,8o\u0018\u0013fcR!\u0011\u0011EA$\u0011%\tI#EA\u0001\u0002\u0004\t9\"A\u000bva\u0012\fG/\u001a3SKBd\u0017nY1Ti\u0006$Xo\u001d\u0011\u000259,XNU3qY&\u001c\u0017m\u0015;biV\u001cX\t_2faRLwN\\:\u0016\u0005\u0005=\u0003\u0003BA)\u00037j!!a\u0015\u000b\t\u0005U\u0013qK\u0001\u0005Y\u0006twM\u0003\u0002\u0002Z\u0005!!.\u0019<b\u0013\u0011\ti&a\u0015\u0003\u000f%sG/Z4fe\u0006qb.^7SKBd\u0017nY1Ti\u0006$Xo]#yG\u0016\u0004H/[8og~#S-\u001d\u000b\u0005\u0003C\t\u0019\u0007C\u0005\u0002*Q\t\t\u00111\u0001\u0002P\u0005Yb.^7SKBd\u0017nY1Ti\u0006$Xo]#yG\u0016\u0004H/[8og\u0002\n\u0001D\\;n)>\u0004\u0018nY\"p]\u001aLw-\u0012=dKB$\u0018n\u001c8t\u0003qqW/\u001c+pa&\u001c7i\u001c8gS\u001e,\u0005pY3qi&|gn]0%KF$B!!\t\u0002n!I\u0011\u0011F\f\u0002\u0002\u0003\u0007\u0011qJ\u0001\u001a]VlGk\u001c9jG\u000e{gNZ5h\u000bb\u001cW\r\u001d;j_:\u001c\b%\u0001\u0006qCJ$\u0018\u000e^5p]N,\"!!\u001e\u0011\u000ba\u000b9(a\u001f\n\u0007\u0005e4MA\u0002TKR\u0004B!! \u0002\u00046\u0011\u0011q\u0010\u0006\u0004\u0003\u0003\u001b\u0018AB2p[6|g.\u0003\u0003\u0002\u0006\u0006}$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000fa\u0006\u0014H/\u001b;j_:\u001cx\fJ3r)\u0011\t\t#a#\t\u0013\u0005%\"$!AA\u0002\u0005U\u0014a\u00039beRLG/[8og\u0002\na\u0003]1si&$\u0018n\u001c8M_\u001e,e\u000eZ(gMN,Go]\u000b\u0003\u0003'\u0003r\u0001WAK\u0003w\nI*C\u0002\u0002\u0018\u000e\u00141!T1q!\rQ\u00171T\u0005\u0004\u0003;k&\u0001\u0002'p]\u001e\f!\u0004]1si&$\u0018n\u001c8M_\u001e,e\u000eZ(gMN,Go]0%KF$B!!\t\u0002$\"I\u0011\u0011F\u000f\u0002\u0002\u0003\u0007\u00111S\u0001\u0018a\u0006\u0014H/\u001b;j_:dunZ#oI>3gm]3ug\u0002\nAb\u001a:pkB4\u0015\u000e\u001c;feN,\"!a+\u0011\r\u00055\u0016qWA_\u001d\u0011\ty+a-\u000f\u0007i\u000b\t,C\u0001_\u0013\r\t),X\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI,a/\u0003\u0007M+\u0017OC\u0002\u00026v\u00032\u0001UA`\u0013\r\t\tM\u0012\u0002\u0016\u00072,8\u000f^3s\u0019&t7NR5mi\u0016\u0014\u0018J\u001c4p\u0003A9'o\\;q\r&dG/\u001a:t?\u0012*\u0017\u000f\u0006\u0003\u0002\"\u0005\u001d\u0007\"CA\u0015A\u0005\u0005\t\u0019AAV\u000359'o\\;q\r&dG/\u001a:tA\u0005\u0019!/\u001e8\u0015\u0005\u0005]\u0011A\u0003;sC:\u001c\u0018\u000e^5p]\u0006a\u0001O]8dKN\u001cHk\u001c9jG\u0006\u0019\u0002.\u00198eY\u0016\u0014V\r\u001d7jG\u0006\u001cF/\u0019;vgR!\u0011qCAl\u0011\u001d\tI.\na\u0001\u00037\faA]3tk2$\bc\u0002-\u0002\u0016\u0006m\u0014Q\u001c\t\u0007\u0003{\ny.a9\n\t\u0005\u0005\u0018q\u0010\u0002\f\u0017\u000647.\u0019$viV\u0014X\r\u0005\u0004\u0002f\u0006-\u0018q^\u0007\u0003\u0003OTA!!;\u0002X\u0005!Q\u000f^5m\u0013\u0011\ti/a:\u0003\t1K7\u000f\u001e\t\u0005\u0003c\f90\u0004\u0002\u0002t*!\u0011Q_A@\u0003\u001d\u0011X\r\u001d7jG\u0006LA!!?\u0002t\ni!+\u001a9mS\u000e\f7\u000b^1ukN\fA\u0003\u001d:pG\u0016\u001c8OU3qY&\u001c\u0017m\u0015;biV\u001cH\u0003BA\f\u0003\u007fDq!!7'\u0001\u0004\u0011\t\u0001E\u0004Y\u0003+\u000bYHa\u0001\u0011\r\u00055&QAAx\u0013\u0011\ti/a/\u0002\u001fMLhn\u0019+pa&\u001c7i\u001c8gS\u001e\fQ\u0003[1oI2,7+\u001f8d)>\u0004\u0018nY\"p]\u001aLw\r\u0006\u0003\u0002\u0018\t5\u0001b\u0002B\bQ\u0001\u0007!\u0011C\u0001\u0007MV$XO]3\u0011\r\u0005u\u0014q\u001cB\n!\rq'QC\u0005\u0004\u0005/y'AB\"p]\u001aLw-\u0001\fqe>\u001cWm]:Ts:\u001cGk\u001c9jG\u000e{gNZ5h)\u0011\t9B!\b\t\u000f\t}\u0011\u00061\u0001\u0003\u0014\u0005YAo\u001c9jG\u000e{gNZ5h\u0003)a\u0017n\u001d;He>,\bo]\u0001\u0011Q\u0006tG\r\\3MSN$xI]8vaN$B!a\u0006\u0003(!9!qB\u0016A\u0002\t%\u0002CBA?\u0003?\u0014Y\u0003\u0005\u0004\u0002f\n5\"\u0011G\u0005\u0005\u0005_\t9O\u0001\u0006D_2dWm\u0019;j_:\u00042A\u001cB\u001a\u0013\r\u0011)d\u001c\u0002\u0015\u0007>t7/^7fe\u001e\u0013x.\u001e9MSN$\u0018N\\4\u0002#A\u0014xnY3tg2K7\u000f^$s_V\u00048\u000f\u0006\u0003\u0002\u0018\tm\u0002b\u0002B\u001fY\u0001\u0007!qH\u0001\u0007OJ|W\u000f]:\u0011\ta\u000b9hV\u0001\u0011Y&\u001cHo\u0012:pkB|eMZ:fiN$B!a\u0006\u0003F!9!QH\u0017A\u0002\t}\u0012A\u00065b]\u0012dW\rT5ti\u001e\u0013x.\u001e9PM\u001a\u001cX\r^:\u0015\t\u0005]!1\n\u0005\b\u0005\u001br\u0003\u0019\u0001B(\u0003\u001d1W\u000f^;sKN\u0004b\u0001WAK/\nE\u0003CBA?\u0003?\u0014\u0019\u0006\u0005\u0005\u0002f\nU\u00131\u0010B,\u0013\u0011\t9*a:\u0011\t\te#qL\u0007\u0003\u00057R1A!\u0018r\u0003!\u0019wN\\:v[\u0016\u0014\u0018\u0002\u0002B1\u00057\u0012\u0011c\u00144gg\u0016$\u0018I\u001c3NKR\fG-\u0019;b\u0003Y1\u0017\u000e\u001c;fe2K7\u000f^$s_V\u0004xJ\u001a4tKR\u001cHC\u0002B4\u0005S\u0012i\u0007E\u0004Y\u0003+\u000bYHa\u0016\t\r\t-t\u00061\u0001X\u0003\u00159'o\\;q\u0011\u001d\u0011yg\fa\u0001\u0005O\nqa\u001c4gg\u0016$8/A\tbYR,'o\u0012:pkB|eMZ:fiN$B!a\u0006\u0003v!9!q\u000f\u0019A\u0002\te\u0014\u0001D4s_V\u0004xJ\u001a4tKR\u001c\bC\u0002-\u0002\u0016^\u00139'A\fiC:$G.Z!mi\u0016\u0014xI]8va>3gm]3ugR!\u0011q\u0003B@\u0011\u001d\u0011\t)\ra\u0001\u0005\u0007\u000bqA]3tk2$8\u000f\u0005\u0004Y\u0003+;&Q\u0011\t\u0007\u0003{\nyNa\"\u0011\t\u0005E#\u0011R\u0005\u0005\u0005\u0017\u000b\u0019F\u0001\u0003W_&$\u0017aD:u_Bl\u0015N\u001d:peR{\u0007/[2\u0002#\u001d\u0014x.\u001e9PM\u001a\u001cX\r^:BI6Lg.\u0006\u0002\u0003\u0014B\u0019aN!&\n\u0007\t]uNA\u0003BI6Lg.\u0001\u0004j]Z|7.Z\u000b\u0005\u0005;\u0013\u0019\u000b\u0006\u0003\u0003 \nU\u0006\u0003\u0002BQ\u0005Gc\u0001\u0001B\u0004\u0003&R\u0012\rAa*\u0003\u0003Q\u000bBA!+\u00030B\u0019!Na+\n\u0007\t5VLA\u0004O_RD\u0017N\\4\u0011\u0007)\u0014\t,C\u0002\u00034v\u00131!\u00118z\u0011\u001d\u00119\f\u000ea\u0001\u0005s\u000b!a\u00192\u0011\t)\\'qT\u0001\u0014S:4xn[3SKBd\u0017nY1Ti\u0006$Xo]\u000b\u0005\u0005\u007f\u0013\u0019\r\u0006\u0003\u0003B\n\u0015\u0007\u0003\u0002BQ\u0005\u0007$qA!*6\u0005\u0004\u00119\u000bC\u0004\u00038V\u0002\rAa2\u0011\t)\\'\u0011Y\u0001\u0016S:4xn[3Ts:\u001cGk\u001c9jG\u000e{gNZ5h+\u0011\u0011iM!5\u0015\t\t='1\u001b\t\u0005\u0005C\u0013\t\u000eB\u0004\u0003&Z\u0012\rAa*\t\u000f\t]f\u00071\u0001\u0003VB!!n\u001bBh\u0003YIgN^8lKNKhnY$s_V\u0004xJ\u001a4tKR\u001cX\u0003\u0002Bn\u0005?$bA!8\u0003b\n\r\b\u0003\u0002BQ\u0005?$qA!*8\u0005\u0004\u00119\u000b\u0003\u0004\u0003l]\u0002\ra\u0016\u0005\b\u0005o;\u0004\u0019\u0001Bs!\u0011Q7N!8\u0002\u0019=t7i\\7qY\u0016$\u0018n\u001c8\u0002\u0017%\u001c(+\u001a;sS\u0006\u0014G.\u001a\u000b\u0005\u0003/\u0011i\u000fC\u0004\u0003pf\u0002\rA!=\u0002\u0005\u0015D\b\u0003BAW\u0005gLAA!>\u0002<\nIA\u000b\u001b:po\u0006\u0014G.Z\u0001\nKb\u001cW\r\u001d;j_:$bAa?\u0004@\r\u0005\u0003c\u0001B\u007f\u007f9\u0011\u0001\u000bP\u0001\u001b\u00072,8\u000f^3s\u0019&t7n\u0015;pa6K'O]8s)>\u0004\u0018n\u0019\t\u0003!v\u001a2!PB\u0003!\rQ7qA\u0005\u0004\u0007\u0013i&AB!osJ+g\r\u0006\u0002\u0004\u0002\tIQ\t_2faRLwN\\\n\u0004\u007f\rE\u0001\u0003BA?\u0007'IAa!\u0006\u0002\u0000\tq1*\u00194lC\u0016C8-\u001a9uS>t\u0017aB7fgN\fw-Z\u0001\u0002KR11QDB\u0011\u0007G\u00012aa\b@\u001b\u0005i\u0004BBB\f\u0005\u0002\u0007q\u000bC\u0004\u0004\u001a\t\u0003\rA!=\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019ICK\u0002|\u0007WY#a!\f\u0011\t\r=2\u0011H\u0007\u0003\u0007cQAaa\r\u00046\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007oi\u0016AC1o]>$\u0018\r^5p]&!11HB\u0019\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\t\r\r]!\b1\u0001X\u0011\u001d\u0011yO\u000fa\u0001\u0005c\fqc];qKJ$#/Z:dQ\u0016$W\u000f\\3EK2\f\u00170T:\u0016\u0003m\u0004")
public class ClusterLinkStopMirrorTopic
extends ClusterLinkScheduler.PeriodicTask {
    private final String topic;
    private final ClusterLinkClientManager clientManager;
    private final Function0<ConfluentAdmin> localAdmin;
    private final int adminTimeoutMs;
    private boolean synchronize;
    private boolean updatedTopicConfig;
    private boolean updatedGroupOffsets;
    private boolean updatedReplicaStatus;
    private Integer numReplicaStatusExceptions;
    private Integer numTopicConfigExceptions;
    private scala.collection.immutable.Set<TopicPartition> partitions;
    private scala.collection.immutable.Map<TopicPartition, Object> partitionLogEndOffsets;
    private scala.collection.immutable.Seq<ClusterLinkFilterInfo> groupFilters;

    public static int $lessinit$greater$default$5() {
        return 5000;
    }

    public static int $lessinit$greater$default$4() {
        return 500;
    }

    private /* synthetic */ int super$rescheduleDelayMs() {
        return super.rescheduleDelayMs();
    }

    private boolean synchronize() {
        return this.synchronize;
    }

    private void synchronize_$eq(boolean x$1) {
        this.synchronize = x$1;
    }

    private boolean updatedTopicConfig() {
        return this.updatedTopicConfig;
    }

    private void updatedTopicConfig_$eq(boolean x$1) {
        this.updatedTopicConfig = x$1;
    }

    private boolean updatedGroupOffsets() {
        return this.updatedGroupOffsets;
    }

    private void updatedGroupOffsets_$eq(boolean x$1) {
        this.updatedGroupOffsets = x$1;
    }

    private boolean updatedReplicaStatus() {
        return this.updatedReplicaStatus;
    }

    private void updatedReplicaStatus_$eq(boolean x$1) {
        this.updatedReplicaStatus = x$1;
    }

    private Integer numReplicaStatusExceptions() {
        return this.numReplicaStatusExceptions;
    }

    private void numReplicaStatusExceptions_$eq(Integer x$1) {
        this.numReplicaStatusExceptions = x$1;
    }

    private Integer numTopicConfigExceptions() {
        return this.numTopicConfigExceptions;
    }

    private void numTopicConfigExceptions_$eq(Integer x$1) {
        this.numTopicConfigExceptions = x$1;
    }

    private scala.collection.immutable.Set<TopicPartition> partitions() {
        return this.partitions;
    }

    private void partitions_$eq(scala.collection.immutable.Set<TopicPartition> x$1) {
        this.partitions = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> partitionLogEndOffsets() {
        return this.partitionLogEndOffsets;
    }

    private void partitionLogEndOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.partitionLogEndOffsets = x$1;
    }

    private scala.collection.immutable.Seq<ClusterLinkFilterInfo> groupFilters() {
        return this.groupFilters;
    }

    private void groupFilters_$eq(scala.collection.immutable.Seq<ClusterLinkFilterInfo> x$1) {
        this.groupFilters = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean run() {
        TopicZNode.TopicIdReplicaAssignment topicData = (TopicZNode.TopicIdReplicaAssignment)this.clientManager.zkClient().getReplicaAssignmentAndTopicIdForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic})))).head();
        if (topicData.assignment().isEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(84).append("Cannot stop mirror topic for deleted topic '").append($this.topic).append("'. Shutting down stop mirror topic task.").toString());
            return this.onCompletion();
        }
        boolean bl = false;
        Some some = null;
        Option<ClusterLinkTopicState> option = topicData.clusterLink();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            ClusterLinkTopicState clusterLinkTopicState = (ClusterLinkTopicState)some.value();
            if (clusterLinkTopicState instanceof ClusterLinkTopicState.PendingStoppedMirror) {
                boolean sync = ((ClusterLinkTopicState.PendingStoppedMirror)clusterLinkTopicState).synchronize();
                this.partitions_$eq((scala.collection.immutable.Set<TopicPartition>)topicData.assignment().keys().toSet());
                this.synchronize_$eq(sync);
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Attempting to stop mirror topic ").append($this.topic).append(" with synchronize=").append(this.synchronize()).toString());
                return this.updatedReplicaStatus() ? this.transition() : this.processTopic();
            }
        }
        if (bl) {
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("See mirror '").append(state).append("' for mirror topic '").append($this.topic).append("', not performing stop mirror topic task").toString());
            return this.onCompletion();
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("No mirror state for mirror topic '").append($this.topic).append("', not performing stop mirror topic task").toString());
        return this.onCompletion();
    }

    public boolean transition() {
        if (this.synchronize() && !this.updatedTopicConfig()) {
            return this.syncTopicConfig();
        }
        if (!this.updatedGroupOffsets() && this.clientManager.currentConfig().consumerOffsetSyncEnable()) {
            return this.listGroups();
        }
        return this.stopMirrorTopic();
    }

    private boolean processTopic() {
        ConfluentAdmin admin = (ConfluentAdmin)this.localAdmin.apply();
        ReplicaStatusOptions options = (ReplicaStatusOptions)new ReplicaStatusOptions().timeoutMs(Predef$.MODULE$.int2Integer(this.adminTimeoutMs));
        try {
            ReplicaStatusResult replicaStatusResult;
            ReplicaStatusResult replicaStatusResult2;
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Invoking replica status on mirror topic ").append($this.topic).toString());
            try {
                try {
                    replicaStatusResult2 = admin.replicaStatus(CollectionConverters$.MODULE$.SetHasAsJava(this.partitions()).asJava(), options);
                }
                catch (ExecutionException invokeReplicaStatus_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                    throw invokeReplicaStatus_invoke_e.getCause();
                }
                catch (Throwable invokeReplicaStatus_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                    throw invokeReplicaStatus_invoke_e;
                }
            }
            catch (Throwable invokeReplicaStatus_e) {
                throw this.exception(new StringBuilder(36).append("While fetching replica status for '").append(this.topic).append("'").toString(), invokeReplicaStatus_e);
            }
            ReplicaStatusResult replicaStatusResult3 = replicaStatusResult = replicaStatusResult2;
            replicaStatusResult = null;
            ReplicaStatusResult result = replicaStatusResult3;
            this.numReplicaStatusExceptions_$eq(Predef$.MODULE$.int2Integer(0));
            this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.handleReplicaStatus((scala.collection.immutable.Map<TopicPartition, KafkaFuture<java.util.List<ReplicaStatus>>>)CollectionConverters$.MODULE$.MapHasAsScala(result.result()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
            return false;
        }
        catch (Throwable e) {
            if (BoxesRunTime.equalsNumObject((Number)this.numReplicaStatusExceptions(), (Object)BoxesRunTime.boxToInteger((int)0))) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Encountered exception when trying to invoke replica status for mirror topic ").append(new StringBuilder(2).append($this.topic).append(": ").append(e.getCause()).toString()).toString());
            } else {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Encountered exception when trying to invoke replica status for mirror topic ").append(new StringBuilder(47).append($this.topic).append(". Replica status invocation has failed ").append(this.numReplicaStatusExceptions()).append(" times: ").append(e.getCause()).toString()).toString());
            }
            this.numReplicaStatusExceptions_$eq(Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(this.numReplicaStatusExceptions()) + 1));
            if (this.isRetriable(e)) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Encountered retriable exception, will retry in ").append(this.super$rescheduleDelayMs()).toString());
                return true;
            }
            throw e;
        }
    }

    private boolean handleReplicaStatus(scala.collection.immutable.Map<TopicPartition, KafkaFuture<java.util.List<ReplicaStatus>>> result) {
        try {
            scala.collection.immutable.Map map;
            scala.collection.immutable.Map map2;
            try {
                try {
                    map2 = ClusterLinkStopMirrorTopic.$anonfun$handleReplicaStatus$1(result);
                }
                catch (ExecutionException invokeReplicaStatus_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                    throw invokeReplicaStatus_invoke_e.getCause();
                }
                catch (Throwable invokeReplicaStatus_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                    throw invokeReplicaStatus_invoke_e;
                }
            }
            catch (Throwable invokeReplicaStatus_e) {
                throw this.exception(new StringBuilder(36).append("While fetching replica status for '").append(this.topic).append("'").toString(), invokeReplicaStatus_e);
            }
            scala.collection.immutable.Map map3 = map = map2;
            map = null;
            scala.collection.immutable.Map res = map3;
            this.numReplicaStatusExceptions_$eq(Predef$.MODULE$.int2Integer(0));
            return this.processReplicaStatus((scala.collection.immutable.Map<TopicPartition, List<ReplicaStatus>>)res);
        }
        catch (Throwable e) {
            if (BoxesRunTime.equalsNumObject((Number)this.numReplicaStatusExceptions(), (Object)BoxesRunTime.boxToInteger((int)0))) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Encountered exception when trying to handle replica status for mirror topic ").append(new StringBuilder(2).append($this.topic).append(": ").append(e.getCause()).toString()).toString());
            } else {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Encountered exception when trying to handle replica status for mirror topic ").append(new StringBuilder(36).append($this.topic).append(". Replica status has failed ").append(this.numReplicaStatusExceptions()).append(" times: ").append(e.getCause()).toString()).toString());
            }
            this.numReplicaStatusExceptions_$eq(Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(this.numReplicaStatusExceptions()) + 1));
            if (this.isRetriable(e)) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Encountered retriable exception, will retry in ").append(this.super$rescheduleDelayMs()).toString());
                return true;
            }
            throw e;
        }
    }

    private boolean processReplicaStatus(scala.collection.immutable.Map<TopicPartition, List<ReplicaStatus>> result) {
        this.partitionLogEndOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)result.flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition part = (TopicPartition)x0$1._1();
            List rsList = (List)x0$1._2();
            ReplicaStatus leader = (ReplicaStatus)rsList.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isLeader())).head();
            None$ none$ = Option$.MODULE$.apply(leader.mirrorInfo().orElse(null)).exists((Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkStopMirrorTopic.$anonfun$processReplicaStatus$3(this, info))) && rsList.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isInIsr())).forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkStopMirrorTopic.$anonfun$processReplicaStatus$5(leader, x$6))) ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)part), (Object)BoxesRunTime.boxToLong((long)leader.logEndOffset()))) : None$.MODULE$;
            return none$;
        })));
        if (this.partitionLogEndOffsets().size() == result.size()) {
            this.updatedReplicaStatus_$eq(true);
            return this.transition();
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(71).append("Not all mirror partitions are ready to be stopped for mirror topic '").append($this.topic).append("', ").toString()).append(new StringBuilder(40).append("awaiting state change. Will retry in ").append(this.super$rescheduleDelayMs()).append(" ms").toString()).toString());
        return true;
    }

    private boolean syncTopicConfig() {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, this.topic);
        ConfluentAdmin admin = this.clientManager.getAdmin();
        DescribeConfigsOptions options = new DescribeConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(this.adminTimeoutMs));
        try {
            DescribeConfigsResult describeConfigsResult;
            DescribeConfigsResult describeConfigsResult2;
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Syncing topic configs for mirror topic ").append($this.topic).toString());
            try {
                try {
                    describeConfigsResult2 = admin.describeConfigs(Collections.singleton(resource), options);
                }
                catch (ExecutionException invokeSyncTopicConfig_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                    throw invokeSyncTopicConfig_invoke_e.getCause();
                }
                catch (Throwable invokeSyncTopicConfig_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                    throw invokeSyncTopicConfig_invoke_e;
                }
            }
            catch (Throwable invokeSyncTopicConfig_e) {
                throw this.exception(new StringBuilder(36).append("While describing topic config for '").append(this.topic).append("'").toString(), invokeSyncTopicConfig_e);
            }
            DescribeConfigsResult describeConfigsResult3 = describeConfigsResult = describeConfigsResult2;
            describeConfigsResult = null;
            DescribeConfigsResult result = describeConfigsResult3;
            this.numTopicConfigExceptions_$eq(Predef$.MODULE$.int2Integer(0));
            this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.handleSyncTopicConfig((KafkaFuture<Config>)((KafkaFuture)result.values().get(resource))));
            return false;
        }
        catch (Throwable e) {
            if (BoxesRunTime.equalsNumObject((Number)this.numTopicConfigExceptions(), (Object)BoxesRunTime.boxToInteger((int)0))) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Encountered exception when trying invoke describeConfigs for ").append($this.topic).append(": ").append(e.getCause()).toString());
            } else {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(69).append("Encountered exception when trying invoke describeConfigs for ").append($this.topic).append(". Topic ").toString()).append(new StringBuilder(31).append("config sync has failed ").append(this.numTopicConfigExceptions()).append(" times: ").append(e.getCause()).toString()).toString());
            }
            this.numTopicConfigExceptions_$eq(Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(this.numTopicConfigExceptions()) + 1));
            if (this.isRetriable(e)) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Encountered retriable exception, will retry in ").append(this.super$rescheduleDelayMs()).toString());
                return true;
            }
            throw e;
        }
    }

    private boolean handleSyncTopicConfig(KafkaFuture<Config> future) {
        try {
            Config config;
            Config config2;
            try {
                try {
                    config2 = (Config)future.get();
                }
                catch (ExecutionException invokeSyncTopicConfig_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                    throw invokeSyncTopicConfig_invoke_e.getCause();
                }
                catch (Throwable invokeSyncTopicConfig_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                    throw invokeSyncTopicConfig_invoke_e;
                }
            }
            catch (Throwable invokeSyncTopicConfig_e) {
                throw this.exception(new StringBuilder(36).append("While describing topic config for '").append(this.topic).append("'").toString(), invokeSyncTopicConfig_e);
            }
            Config config3 = config = config2;
            config = null;
            Config config4 = config3;
            this.numTopicConfigExceptions_$eq(Predef$.MODULE$.int2Integer(0));
            return this.processSyncTopicConfig(config4);
        }
        catch (Throwable e) {
            if (BoxesRunTime.equalsNumObject((Number)this.numTopicConfigExceptions(), (Object)BoxesRunTime.boxToInteger((int)0))) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Encountered exception when trying to process topic configs for mirror topic ").append(new StringBuilder(2).append($this.topic).append(": ").append(e.getCause()).toString()).toString());
            } else {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Encountered exception when trying to process topic configs for mirror topic ").append(new StringBuilder(39).append($this.topic).append(". Topic config sync has failed ").append(this.numTopicConfigExceptions()).append(" times: ").append(e.getCause()).toString()).toString());
            }
            this.numTopicConfigExceptions_$eq(Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(this.numTopicConfigExceptions()) + 1));
            if (this.isRetriable(e)) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Encountered retriable exception, will retry in ").append(this.super$rescheduleDelayMs()).toString());
                return true;
            }
            throw e;
        }
    }

    private boolean processSyncTopicConfig(Config topicConfig) {
        try {
            Properties newProps;
            Properties curProps = this.clientManager.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.topic);
            MirrorTopicConfigsDelegate mirrorTopicConfigsDelegate = new MirrorTopicConfigsDelegate(curProps, topicConfig, this.clientManager.topicConfigSyncRules());
            Properties properties = newProps = ClusterLinkUtils$.MODULE$.restrictValidateTopicConfigPolicy(this.topic, mirrorTopicConfigsDelegate.updateMirrorProps(this.topic), this.clientManager.alterConfigPolicy());
            if (properties == null ? curProps != null : !((Object)properties).equals(curProps)) {
                this.clientManager.adminZkClient().changeTopicConfig(this.topic, newProps);
            }
        }
        catch (PolicyViolationException e) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(101).append("Encountered policy violation when finalizing topic configuration for '").append($this.topic).append("', skipping topic config update").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
        }
        catch (Throwable e) {
            throw this.exception(new StringBuilder(41).append("While updating topic configuration for '").append(this.topic).append("'").toString(), e);
        }
        this.updatedTopicConfig_$eq(true);
        return this.transition();
    }

    private boolean listGroups() {
        this.groupFilters_$eq(ClusterLinkUtils$.MODULE$.clusterLinkFilters(this.clientManager.currentConfig().consumerGroupFilters(), this.clientManager.linkData().tenantPrefix()));
        if (this.groupFilters().isEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Found empty group filters, no consumer group offsets to sync.");
            this.updatedGroupOffsets_$eq(true);
            return this.transition();
        }
        Admin admin = this.groupOffsetsAdmin();
        ListConsumerGroupsOptions options = (ListConsumerGroupsOptions)new ListConsumerGroupsOptions().timeoutMs(Predef$.MODULE$.int2Integer(this.adminTimeoutMs));
        try {
            ListConsumerGroupsResult listConsumerGroupsResult;
            ListConsumerGroupsResult listConsumerGroupsResult2;
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Syncing consumer group offsets for mirror topic ").append($this.topic).toString());
            String invokeSyncGroupOffsets_group = "(none)";
            try {
                try {
                    listConsumerGroupsResult2 = admin.listConsumerGroups(options);
                }
                catch (ExecutionException invokeSyncGroupOffsets_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                    throw invokeSyncGroupOffsets_invoke_e.getCause();
                }
                catch (Throwable invokeSyncGroupOffsets_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                    throw invokeSyncGroupOffsets_invoke_e;
                }
            }
            catch (Throwable invokeSyncGroupOffsets_e) {
                throw this.exception(new StringBuilder(0).append(new StringBuilder(59).append("While updating group offsets for mirror topic '").append(this.topic).append("' and group ").toString()).append(new StringBuilder(2).append("'").append(invokeSyncGroupOffsets_group).append("'").toString()).toString(), invokeSyncGroupOffsets_e);
            }
            ListConsumerGroupsResult listConsumerGroupsResult3 = listConsumerGroupsResult = listConsumerGroupsResult2;
            Object var5_3 = null;
            listConsumerGroupsResult = null;
            ListConsumerGroupsResult result = listConsumerGroupsResult3;
            this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.handleListGroups((KafkaFuture<Collection<ConsumerGroupListing>>)result.all()));
            return false;
        }
        catch (Throwable e) {
            if (!this.synchronize()) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Unable to list consumer groups. Skipping over syncing consumer group").append(new StringBuilder(26).append(" offsets for mirror topic ").append($this.topic).toString()).toString());
                this.updatedGroupOffsets_$eq(true);
                return this.transition();
            }
            if (this.isRetriable(e)) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(65).append("Encountered exception when trying to list groups: ").append(e.getCause()).append(" Will retry in ").toString()).append(String.valueOf(BoxesRunTime.boxToInteger((int)this.super$rescheduleDelayMs()))).toString());
                return true;
            }
            throw e;
        }
    }

    private boolean handleListGroups(KafkaFuture<Collection<ConsumerGroupListing>> future) {
        try {
            Collection collection;
            Collection collection2;
            String invokeSyncGroupOffsets_group = "(none)";
            try {
                try {
                    collection2 = (Collection)future.get();
                }
                catch (ExecutionException invokeSyncGroupOffsets_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                    throw invokeSyncGroupOffsets_invoke_e.getCause();
                }
                catch (Throwable invokeSyncGroupOffsets_invoke_e) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                    throw invokeSyncGroupOffsets_invoke_e;
                }
            }
            catch (Throwable invokeSyncGroupOffsets_e) {
                throw this.exception(new StringBuilder(0).append(new StringBuilder(59).append("While updating group offsets for mirror topic '").append(this.topic).append("' and group ").toString()).append(new StringBuilder(2).append("'").append(invokeSyncGroupOffsets_group).append("'").toString()).toString(), invokeSyncGroupOffsets_e);
            }
            Collection collection3 = collection = collection2;
            Object var4_2 = null;
            collection = null;
            Collection result = collection3;
            return this.processListGroups((scala.collection.immutable.Set<String>)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(result).asScala().map((Function1 & Serializable)x$7 -> x$7.groupId())).toSet());
        }
        catch (Throwable e) {
            if (!this.synchronize()) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Unable to process list consumer groups request. Skipping over syncing").append(new StringBuilder(41).append(" consumer group offsets for mirror topic ").append($this.topic).toString()).toString());
                this.updatedGroupOffsets_$eq(true);
                return this.transition();
            }
            if (this.isRetriable(e)) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(57).append("Encountered exception when trying to handle list groups: ").append(e.getCause()).toString()).append(new StringBuilder(15).append(" Will retry in ").append(this.super$rescheduleDelayMs()).toString()).toString());
                return true;
            }
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean processListGroups(scala.collection.immutable.Set<String> groups) {
        void var3_3;
        Tuple2<scala.collection.immutable.Set<String>, scala.collection.immutable.Seq<ClusterLinkFilterInfo>> tuple2 = ClusterLinkUtils$.MODULE$.doFilter(groups, this.groupFilters());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set matchedGroups = (scala.collection.immutable.Set)tuple2._1();
        if (var3_3.isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition();
        }
        return this.listGroupOffsets((scala.collection.immutable.Set<String>)var3_3);
    }

    private boolean listGroupOffsets(scala.collection.immutable.Set<String> groups) {
        ListConsumerGroupOffsetsOptions options = (ListConsumerGroupOffsetsOptions)new ListConsumerGroupOffsetsOptions().topicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.partitions().toList()).asJava()).timeoutMs(Predef$.MODULE$.int2Integer(this.adminTimeoutMs));
        Admin admin = this.groupOffsetsAdmin();
        ObjectRef futures = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        Set unSyncedGroups = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        groups.foreach((Function1 & Serializable)group -> {
            ClusterLinkStopMirrorTopic.$anonfun$listGroupOffsets$1(this, admin, options, futures, unSyncedGroups, group);
            return BoxedUnit.UNIT;
        });
        if (unSyncedGroups.nonEmpty()) {
            if (!this.synchronize()) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Got errors when trying to sync the following consumer groups' offsets when").append(" listing consumer group offsets. These consumer groups will be ").append(new StringBuilder(9).append("skipped: ").append(unSyncedGroups).toString()).toString());
            } else {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Got errors when trying to sync consumer groups' offsets when listing consumer").append(new StringBuilder(37).append(" group offsets. Will retry again in ").append(this.super$rescheduleDelayMs()).append(".").toString()).toString());
                return true;
            }
        }
        if (((scala.collection.immutable.Map)futures.elem).isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition();
        }
        KafkaFuture all = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])((scala.collection.immutable.Map)futures.elem).values().toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
        this.scheduleWhenComplete(all, (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.handleListGroupOffsets((scala.collection.immutable.Map<String, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>>)((scala.collection.immutable.Map)futures$1.elem)));
        return false;
    }

    private boolean handleListGroupOffsets(scala.collection.immutable.Map<String, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> futures) {
        Set unSyncedGroups = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.immutable.Map groupOffsets = (scala.collection.immutable.Map)futures.map((Function1 & Serializable)x0$1 -> {
            scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> map;
            String group;
            if (x0$1 != null) {
                group = (String)x0$1._1();
                try {
                    java.util.Map map2;
                    java.util.Map map3;
                    try {
                        try {
                            map3 = (java.util.Map)((KafkaFuture)x0$1._2()).get();
                        }
                        catch (ExecutionException invokeSyncGroupOffsets_invoke_e) {
                            this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                            throw invokeSyncGroupOffsets_invoke_e.getCause();
                        }
                        catch (Throwable invokeSyncGroupOffsets_invoke_e) {
                            this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                            throw invokeSyncGroupOffsets_invoke_e;
                        }
                    }
                    catch (Throwable invokeSyncGroupOffsets_e) {
                        throw this.exception(new StringBuilder(0).append(new StringBuilder(59).append("While updating group offsets for mirror topic '").append($this.topic).append("' and group ").toString()).append(new StringBuilder(2).append("'").append(group).append("'").toString()).toString(), invokeSyncGroupOffsets_e);
                    }
                    java.util.Map map4 = map2 = map3;
                    map2 = null;
                    java.util.Map result = map4;
                    map = this.filterListGroupOffsets(group, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                }
                catch (Throwable e) {
                    unSyncedGroups.$plus$eq((Object)group);
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Encountered error when trying to handle list consumer offsets request for ").append(new StringBuilder(8).append("group ").append(group).append(": ").append(e).toString()).toString());
                    map = Predef$.MODULE$.Map().empty();
                }
            } else {
                throw new MatchError(null);
            }
            scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> res = map;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), res);
            return tuple2;
        }).filterNot((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkStopMirrorTopic.$anonfun$handleListGroupOffsets$4(x$8)));
        if (unSyncedGroups.nonEmpty()) {
            if (!this.synchronize()) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Got errors when trying to sync the following consumer groups' offsets ").append("when handling the list consumer group offset request. These consumer ").append(new StringBuilder(24).append("groups will be skipped: ").append(unSyncedGroups).toString()).toString());
            } else {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Got errors when trying to sync the following consumer groups' offsets").append(" when handling the list consumer group offset request. Will retry again in").append(new StringBuilder(2).append(" ").append(this.super$rescheduleDelayMs()).append(".").toString()).toString());
                return true;
            }
        }
        if (groupOffsets.isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition();
        }
        return this.alterGroupOffsets((scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)groupOffsets);
    }

    private scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> filterListGroupOffsets(String group, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        return (scala.collection.immutable.Map)offsets.flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) throw new MatchError(null);
            TopicPartition partition = (TopicPartition)x0$1._1();
            OffsetAndMetadata offsetMeta = (OffsetAndMetadata)x0$1._2();
            Option option = this.partitionLogEndOffsets().get((Object)partition);
            if (option instanceof Some) {
                Object object;
                long logEndOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                if (offsetMeta == null) {
                    object = None$.MODULE$;
                    return object.map((Function1 & Serializable)off -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)new OffsetAndMetadata(BoxesRunTime.unboxToLong((Object)off), offsetMeta.leaderEpoch(), offsetMeta.metadata())));
                } else if (logEndOffset < offsetMeta.offset()) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Rolling back offset for group '").append(group).append("' and topic '").append($this.topic).append("' from '").append(offsetMeta.offset()).append(" to '").append(logEndOffset).append("'").toString());
                    object = new Some((Object)BoxesRunTime.boxToLong((long)logEndOffset));
                    return object.map((Function1 & Serializable)off -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)new OffsetAndMetadata(BoxesRunTime.unboxToLong((Object)off), offsetMeta.leaderEpoch(), offsetMeta.metadata())));
                } else {
                    object = this.synchronize() ? new Some((Object)BoxesRunTime.boxToLong((long)offsetMeta.offset())) : None$.MODULE$;
                }
                return object.map((Function1 & Serializable)off -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)new OffsetAndMetadata(BoxesRunTime.unboxToLong((Object)off), offsetMeta.leaderEpoch(), offsetMeta.metadata())));
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Unexpected partition '").append(partition).append("', skipping").toString());
            return None$.MODULE$;
        });
    }

    private boolean alterGroupOffsets(scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> groupOffsets) {
        ConfluentAdmin admin = (ConfluentAdmin)this.localAdmin.apply();
        AlterConsumerGroupOffsetsOptions options = (AlterConsumerGroupOffsetsOptions)new AlterConsumerGroupOffsetsOptions().timeoutMs(Predef$.MODULE$.int2Integer(this.adminTimeoutMs));
        ObjectRef futures = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        Set unSyncedGroups = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        groupOffsets.foreach((Function1 & Serializable)x0$1 -> {
            ClusterLinkStopMirrorTopic.$anonfun$alterGroupOffsets$1(this, admin, options, futures, unSyncedGroups, x0$1);
            return BoxedUnit.UNIT;
        });
        if (unSyncedGroups.nonEmpty()) {
            if (!this.synchronize()) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Got errors when trying to sync the following consumer groups' offsets when ").append(new StringBuilder(76).append("altering the consumer group offsets. These consumer groups will be skipped: ").append(unSyncedGroups).toString()).toString());
            } else {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Got errors when trying to sync the following consumer groups' offsets when ").append(new StringBuilder(58).append("altering the consumer group offsets. Will retry again in ").append(this.super$rescheduleDelayMs()).append(".").toString()).toString());
                return true;
            }
        }
        if (((scala.collection.immutable.Map)futures.elem).isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition();
        }
        KafkaFuture all = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])((scala.collection.immutable.Map)futures.elem).values().toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
        this.scheduleWhenComplete(all, (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.handleAlterGroupOffsets((scala.collection.immutable.Map<String, KafkaFuture<Void>>)((scala.collection.immutable.Map)futures$2.elem)));
        return false;
    }

    private boolean handleAlterGroupOffsets(scala.collection.immutable.Map<String, KafkaFuture<Void>> results) {
        Set unSyncedGroups = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        results.foreach((Function1 & Serializable)x0$1 -> {
            Void void_;
            if (x0$1 != null) {
                String group = (String)x0$1._1();
                try {
                    try {
                        try {
                            void_ = (Void)((KafkaFuture)x0$1._2()).get();
                        }
                        catch (ExecutionException invokeSyncGroupOffsets_invoke_e) {
                            this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                            throw invokeSyncGroupOffsets_invoke_e.getCause();
                        }
                        catch (Throwable invokeSyncGroupOffsets_invoke_e) {
                            this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                            throw invokeSyncGroupOffsets_invoke_e;
                        }
                    }
                    catch (Throwable invokeSyncGroupOffsets_e) {
                        throw this.exception(new StringBuilder(0).append(new StringBuilder(59).append("While updating group offsets for mirror topic '").append($this.topic).append("' and group ").toString()).append(new StringBuilder(2).append("'").append(group).append("'").toString()).toString(), invokeSyncGroupOffsets_e);
                    }
                }
                catch (Throwable e) {
                    unSyncedGroups.$plus$eq((Object)group);
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Encountered error when trying to handle alter consumer offsets request for ").append(new StringBuilder(8).append("group ").append(group).append(": ").append(e).toString()).toString());
                    void_ = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError(null);
            }
            Void void_2 = void_;
            return void_2;
        });
        if (unSyncedGroups.nonEmpty()) {
            if (!this.synchronize()) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Got errors when trying to sync the following consumer groups' offsets when ").append("handling the alter consumer group offset request. These consumer groups will be ").append(new StringBuilder(9).append("skipped: ").append(unSyncedGroups).toString()).toString());
            } else {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Got errors when trying to sync the following consumer groups' offsets when ").append(new StringBuilder(71).append("handling the alter consumer group offset request. Will retry again in ").append(this.super$rescheduleDelayMs()).append(".").toString()).toString());
                return true;
            }
        }
        this.updatedGroupOffsets_$eq(true);
        return this.transition();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean stopMirrorTopic() {
        TopicZNode.TopicIdReplicaAssignment topicData = (TopicZNode.TopicIdReplicaAssignment)this.clientManager.zkClient().getReplicaAssignmentAndTopicIdForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic})))).head();
        if (topicData.assignment().isEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("Detected deleted topic '").append($this.topic).append("' while stopping mirror topic. Shutting down stop mirror topic task.").toString());
            return this.onCompletion();
        }
        if (topicData.assignment().size() != this.partitions().size()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Detected change in partitions while stopping mirror topic. Retrying consumer group offset sync.");
            this.updatedGroupOffsets_$eq(false);
            return this.transition();
        }
        boolean bl = false;
        Some some = null;
        Option<ClusterLinkTopicState> option = topicData.clusterLink();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            ClusterLinkTopicState clusterLinkTopicState = (ClusterLinkTopicState)some.value();
            if (clusterLinkTopicState instanceof ClusterLinkTopicState.PendingStoppedMirror) {
                ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirror = (ClusterLinkTopicState.PendingStoppedMirror)clusterLinkTopicState;
                String linkName = pendingStoppedMirror.linkName();
                UUID linkId = pendingStoppedMirror.linkId();
                Uuid sourceTopicId = pendingStoppedMirror.sourceTopicId();
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(80).append("Recording stopped log end offsets for mirror topic ").append($this.topic).append(" and setting state to Stopped").toString());
                List logEndOffsets = ((List)this.partitionLogEndOffsets().toList().sortBy((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)ClusterLinkStopMirrorTopic.$anonfun$stopMirrorTopic$4(x$9)), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10._2$mcJ$sp()));
                ClusterLinkTopicState.StoppedMirror newState = new ClusterLinkTopicState.StoppedMirror(linkName, linkId, sourceTopicId, (scala.collection.immutable.Seq<Object>)logEndOffsets, Time.SYSTEM.milliseconds());
                this.clientManager.zkClient().setTopicClusterLink(this.topic, (Option<ClusterLinkTopicState>)new Some((Object)newState));
                return this.onCompletion();
            }
        }
        if (bl) {
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(67).append("See cluster link state '").append(state).append("' for mirror topic '").append($this.topic).append("', not performing stop ").toString()).append("mirror topic task").toString());
            return this.onCompletion();
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(70).append("No cluster link state for mirror topic '").append($this.topic).append("', not performing stop mirror ").toString()).append("topic task").toString());
        return this.onCompletion();
    }

    private Admin groupOffsetsAdmin() {
        if (this.synchronize()) {
            return this.clientManager.getAdmin();
        }
        return (Admin)this.localAdmin.apply();
    }

    private <T> T invoke(Function0<T> cb) {
        try {
            return (T)cb.apply();
        }
        catch (ExecutionException e) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
            throw e.getCause();
        }
        catch (Throwable e) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e);
            throw e;
        }
    }

    private <T> T invokeReplicaStatus(Function0<T> cb) {
        try {
            Object object;
            try {
                object = cb.apply();
            }
            catch (ExecutionException invoke_e) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                throw invoke_e.getCause();
            }
            catch (Throwable invoke_e) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                throw invoke_e;
            }
            return (T)object;
        }
        catch (Throwable e) {
            throw this.exception(new StringBuilder(36).append("While fetching replica status for '").append(this.topic).append("'").toString(), e);
        }
    }

    private <T> T invokeSyncTopicConfig(Function0<T> cb) {
        try {
            Object object;
            try {
                object = cb.apply();
            }
            catch (ExecutionException invoke_e) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                throw invoke_e.getCause();
            }
            catch (Throwable invoke_e) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                throw invoke_e;
            }
            return (T)object;
        }
        catch (Throwable e) {
            throw this.exception(new StringBuilder(36).append("While describing topic config for '").append(this.topic).append("'").toString(), e);
        }
    }

    private <T> T invokeSyncGroupOffsets(String group, Function0<T> cb) {
        try {
            Object object;
            try {
                object = cb.apply();
            }
            catch (ExecutionException invoke_e) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                throw invoke_e.getCause();
            }
            catch (Throwable invoke_e) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                throw invoke_e;
            }
            return (T)object;
        }
        catch (Throwable e) {
            throw this.exception(new StringBuilder(0).append(new StringBuilder(59).append("While updating group offsets for mirror topic '").append(this.topic).append("' and group ").toString()).append(new StringBuilder(2).append("'").append(group).append("'").toString()).toString(), e);
        }
    }

    private boolean onCompletion() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down stop mirror topic task.");
        this.shutdown();
        return true;
    }

    private boolean isRetriable(Throwable ex) {
        boolean bl;
        Throwable throwable = ex.getCause();
        if (throwable instanceof RetriableException) {
            bl = true;
        } else if (throwable instanceof AuthorizationException) {
            bl = true;
        } else if (throwable != null) {
            bl = false;
        } else {
            throw new MatchError(null);
        }
        return bl;
    }

    private Exception exception(String message, Throwable ex) {
        Exception exception;
        if (ex instanceof ExecutionException) {
            ExecutionException executionException = (ExecutionException)ex;
            exception = new Exception(message, executionException.getCause());
        } else if (ex != null) {
            exception = new Exception(message, ex);
        } else {
            throw new MatchError(null);
        }
        return exception;
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$handleReplicaStatus$1(scala.collection.immutable.Map result$2) {
        return (scala.collection.immutable.Map)result$2.map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e._1()), (Object)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)((KafkaFuture)e._2()).get()).asScala().toList()));
    }

    public static final /* synthetic */ boolean $anonfun$processReplicaStatus$3(ClusterLinkStopMirrorTopic $this, ReplicaStatus.MirrorInfo info) {
        block3: {
            block2: {
                ReplicaStatus.MirrorInfo.State state = info.state();
                ReplicaStatus.MirrorInfo.State state2 = ReplicaStatus.MirrorInfo.State.PENDING_STOPPED;
                if (!(state == null ? state2 != null : !state.equals(state2))) break block2;
                if ($this.synchronize()) break block3;
                ReplicaStatus.MirrorInfo.State state3 = info.state();
                ReplicaStatus.MirrorInfo.State state4 = ReplicaStatus.MirrorInfo.State.LINK_FAILED;
                if (state3 != null ? !state3.equals(state4) : state4 != null) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$processReplicaStatus$5(ReplicaStatus leader$1, ReplicaStatus x$6) {
        return x$6.logEndOffset() == leader$1.logEndOffset();
    }

    public static final /* synthetic */ Config $anonfun$handleSyncTopicConfig$1(KafkaFuture future$1) {
        return (Config)future$1.get();
    }

    public static final /* synthetic */ ListConsumerGroupsResult $anonfun$listGroups$3(Admin admin$3, ListConsumerGroupsOptions options$3) {
        return admin$3.listConsumerGroups(options$3);
    }

    public static final /* synthetic */ Collection $anonfun$handleListGroups$1(KafkaFuture future$2) {
        return (Collection)future$2.get();
    }

    public static final /* synthetic */ ListConsumerGroupOffsetsResult $anonfun$listGroupOffsets$2(Admin admin$4, String group$1, ListConsumerGroupOffsetsOptions options$4) {
        return admin$4.listConsumerGroupOffsets(group$1, options$4);
    }

    public static final /* synthetic */ void $anonfun$listGroupOffsets$1(ClusterLinkStopMirrorTopic $this, Admin admin$4, ListConsumerGroupOffsetsOptions options$4, ObjectRef futures$1, Set unSyncedGroups$1, String group) {
        try {
            ListConsumerGroupOffsetsResult listConsumerGroupOffsetsResult;
            ListConsumerGroupOffsetsResult listConsumerGroupOffsetsResult2;
            try {
                try {
                    listConsumerGroupOffsetsResult2 = admin$4.listConsumerGroupOffsets(group, options$4);
                }
                catch (ExecutionException invokeSyncGroupOffsets_invoke_e) {
                    $this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                    throw invokeSyncGroupOffsets_invoke_e.getCause();
                }
                catch (Throwable invokeSyncGroupOffsets_invoke_e) {
                    $this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                    throw invokeSyncGroupOffsets_invoke_e;
                }
            }
            catch (Throwable invokeSyncGroupOffsets_e) {
                throw $this.exception(new StringBuilder(0).append(new StringBuilder(59).append("While updating group offsets for mirror topic '").append($this.topic).append("' and group ").toString()).append(new StringBuilder(2).append("'").append(group).append("'").toString()).toString(), invokeSyncGroupOffsets_e);
            }
            ListConsumerGroupOffsetsResult listConsumerGroupOffsetsResult3 = listConsumerGroupOffsetsResult = listConsumerGroupOffsetsResult2;
            listConsumerGroupOffsetsResult = null;
            ListConsumerGroupOffsetsResult result = listConsumerGroupOffsetsResult3;
            futures$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)futures$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), (Object)result.partitionsToOffsetAndMetadata()));
            return;
        }
        catch (Throwable e) {
            unSyncedGroups$1.$plus$eq((Object)group);
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Encountered error when trying to list consumer offsets for group ").append(group).append(": ").append(e).toString());
            return;
        }
    }

    public static final /* synthetic */ java.util.Map $anonfun$handleListGroupOffsets$2(KafkaFuture future$3) {
        return (java.util.Map)future$3.get();
    }

    public static final /* synthetic */ boolean $anonfun$handleListGroupOffsets$4(Tuple2 x$8) {
        return ((IterableOnceOps)x$8._2()).isEmpty();
    }

    public static final /* synthetic */ void $anonfun$alterGroupOffsets$1(ClusterLinkStopMirrorTopic $this, ConfluentAdmin admin$5, AlterConsumerGroupOffsetsOptions options$5, ObjectRef futures$2, Set unSyncedGroups$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            String group = (String)x0$1._1();
            scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)x0$1._2();
            try {
                AlterConsumerGroupOffsetsResult alterConsumerGroupOffsetsResult;
                AlterConsumerGroupOffsetsResult alterConsumerGroupOffsetsResult2;
                try {
                    try {
                        alterConsumerGroupOffsetsResult2 = admin$5.alterConsumerGroupOffsets(group, CollectionConverters$.MODULE$.MapHasAsJava((Map)offsets).asJava(), options$5);
                    }
                    catch (ExecutionException invokeSyncGroupOffsets_invoke_e) {
                        $this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e.getCause());
                        throw invokeSyncGroupOffsets_invoke_e.getCause();
                    }
                    catch (Throwable invokeSyncGroupOffsets_invoke_e) {
                        $this.debug((Function0<String>)(Function0 & Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable)() -> invokeSyncGroupOffsets_invoke_e);
                        throw invokeSyncGroupOffsets_invoke_e;
                    }
                }
                catch (Throwable invokeSyncGroupOffsets_e) {
                    throw $this.exception(new StringBuilder(0).append(new StringBuilder(59).append("While updating group offsets for mirror topic '").append($this.topic).append("' and group ").toString()).append(new StringBuilder(2).append("'").append(group).append("'").toString()).toString(), invokeSyncGroupOffsets_e);
                }
                AlterConsumerGroupOffsetsResult alterConsumerGroupOffsetsResult3 = alterConsumerGroupOffsetsResult = alterConsumerGroupOffsetsResult2;
                alterConsumerGroupOffsetsResult = null;
                AlterConsumerGroupOffsetsResult result = alterConsumerGroupOffsetsResult3;
                futures$2.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)futures$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), (Object)result.all()));
                return;
            }
            catch (Throwable e) {
                unSyncedGroups$3.$plus$eq((Object)group);
                $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Encountered error when trying to alter consumer offsets for group ").append(group).append(": ").append(e).toString());
                return;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Void $anonfun$handleAlterGroupOffsets$2(KafkaFuture future$4) {
        return (Void)future$4.get();
    }

    public static final /* synthetic */ int $anonfun$stopMirrorTopic$4(Tuple2 x$9) {
        return ((TopicPartition)x$9._1()).partition();
    }

    public ClusterLinkStopMirrorTopic(String topic, ClusterLinkClientManager clientManager, Function0<ConfluentAdmin> localAdmin, int intervalMs, int adminTimeoutMs) {
        this.topic = topic;
        this.clientManager = clientManager;
        this.localAdmin = localAdmin;
        this.adminTimeoutMs = adminTimeoutMs;
        super(clientManager.scheduler(), "StopMirrorTopic", intervalMs);
        this.synchronize = true;
        this.updatedTopicConfig = false;
        this.updatedGroupOffsets = false;
        this.updatedReplicaStatus = false;
        this.numReplicaStatusExceptions = Predef$.MODULE$.int2Integer(0);
        this.numTopicConfigExceptions = Predef$.MODULE$.int2Integer(0);
    }

    public static class Exception
    extends KafkaException {
        public Exception(String message, Throwable e) {
            super(message, e);
        }
    }
}

