/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.log.AbstractLog;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.PartitionRegistration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.runtime.BoxesRunTime;

public final class BrokerMetadataPublisher$
implements Logging {
    public static final BrokerMetadataPublisher$ MODULE$ = new BrokerMetadataPublisher$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Option<TopicDelta> getTopicDelta(String topicName, MetadataImage newImage, MetadataDelta delta) {
        return Option$.MODULE$.apply((Object)newImage.topics().getTopic(topicName)).flatMap((Function1 & Serializable)topicImage -> Option$.MODULE$.apply((Object)delta.topicsDelta()).flatMap((Function1 & Serializable)topicDelta -> Option$.MODULE$.apply((Object)topicDelta.changedTopic(topicImage.id()))));
    }

    public Iterable<TopicPartition> findStrayPartitions(int brokerId, TopicsImage newTopicsImage, Iterable<AbstractLog> logs) {
        return (Iterable)logs.flatMap((Function1 & Serializable)log -> {
            None$ none$;
            int partitionId;
            Uuid topicId = (Uuid)log.topicId().getOrElse((Function0 & Serializable)() -> {
                throw new RuntimeException(new StringBuilder(48).append(new StringBuilder(39).append("The log dir ").append(log).append(" does not have a topic ID, ").toString()).append("which is not allowed when running in KRaft mode.").toString());
            });
            Option option = Option$.MODULE$.apply((Object)newTopicsImage.getPartition(topicId, partitionId = log.topicPartition().partition()));
            if (option instanceof Some) {
                None$ none$2;
                PartitionRegistration partition = (PartitionRegistration)((Some)option).value();
                if (!ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Object)BoxesRunTime.boxToInteger((int)brokerId))) {
                    BrokerMetadataPublisher$ info_this = MODULE$;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = BrokerMetadataPublisher$.$anonfun$findStrayPartitions$3(log, partition, brokerId);
                        Object var10_8 = null;
                        info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                    }
                    Object var8_7 = null;
                    none$2 = new Some((Object)log.topicPartition());
                } else {
                    none$2 = None$.MODULE$;
                }
                none$ = none$2;
            } else if (None$.MODULE$.equals(option)) {
                BrokerMetadataPublisher$ info_this = MODULE$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = BrokerMetadataPublisher$.$anonfun$findStrayPartitions$4(log, topicId);
                    Object var11_11 = null;
                    info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                }
                Object var9_10 = null;
                none$ = new Some((Object)log.topicPartition());
            } else {
                throw new MatchError((Object)option);
            }
            return none$;
        });
    }

    public static final /* synthetic */ String $anonfun$findStrayPartitions$3(AbstractLog log$1, PartitionRegistration partition$1, int brokerId$1) {
        return new StringBuilder(0).append(new StringBuilder(54).append("Found stray log dir ").append(log$1).append(": the current replica assignment ").append(partition$1.replicas).append(" ").toString()).append(new StringBuilder(37).append("does not contain the local brokerId ").append(brokerId$1).append(".").toString()).toString();
    }

    public static final /* synthetic */ String $anonfun$findStrayPartitions$4(AbstractLog log$1, Uuid topicId$1) {
        return new StringBuilder(71).append("Found stray log dir ").append(log$1).append(": the topicId ").append(topicId$1).append(" does not exist in the metadata image").toString();
    }

    private BrokerMetadataPublisher$() {
    }
}

