/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.io.InputStream;
import java.util.concurrent.CancellationException;
import kafka.log.TimestampOffset;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.fetcher.TierTimestampIndexIterator;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;

final class TimestampIndexFetchRequest {
    TimestampIndexFetchRequest() {
    }

    static TimestampOffset fetchOffsetForTimestamp(CancellationContext cancellationContext, TierObjectStore tierObjectStore, TierObjectStore.ObjectMetadata tierObjectMetadata, long targetTimestamp) throws Exception {
        long startOffset = tierObjectMetadata.baseOffset();
        TimestampOffset found = new TimestampOffset(targetTimestamp, tierObjectMetadata.baseOffset());
        try (TierObjectStoreResponse timestampResponse = tierObjectStore.getObject(tierObjectMetadata, TierObjectStore.FileType.TIMESTAMP_INDEX);){
            InputStream timestampStream = timestampResponse.getInputStream();
            TierTimestampIndexIterator tierTimestampIterator = new TierTimestampIndexIterator(timestampStream, startOffset);
            while (tierTimestampIterator.hasNext()) {
                if (cancellationContext.isCancelled()) {
                    throw new CancellationException("Tiered timestamp index fetch request cancelled");
                }
                TimestampOffset timestampOffset = (TimestampOffset)tierTimestampIterator.next();
                if (timestampOffset.timestamp() == targetTimestamp) {
                    TimestampOffset timestampOffset2 = timestampOffset;
                    return timestampOffset2;
                }
                if (timestampOffset.timestamp() >= targetTimestamp) {
                    TimestampOffset timestampOffset3 = found;
                    return timestampOffset3;
                }
                found = timestampOffset;
            }
        }
        return found;
    }
}

