/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.serdes;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kafka.tier.serdes.MaterializationTrackingInfo;
import kafka.tier.serdes.OffsetAndEpoch;
import kafka.tier.serdes.UUID;

public final class TierPartitionStateHeader
extends Table {
    public static TierPartitionStateHeader getRootAsTierPartitionStateHeader(ByteBuffer _bb) {
        return TierPartitionStateHeader.getRootAsTierPartitionStateHeader(_bb, new TierPartitionStateHeader());
    }

    public static TierPartitionStateHeader getRootAsTierPartitionStateHeader(ByteBuffer _bb, TierPartitionStateHeader obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
    }

    public TierPartitionStateHeader __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public byte version() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public boolean mutateVersion(byte version) {
        int o = this.__offset(4);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, version);
            return true;
        }
        return false;
    }

    public UUID topicId() {
        return this.topicId(new UUID());
    }

    public UUID topicId(UUID obj) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public int tierEpoch() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public boolean mutateTierEpoch(int tierEpoch) {
        int o = this.__offset(8);
        if (o != 0) {
            this.bb.putInt(o + this.bb_pos, tierEpoch);
            return true;
        }
        return false;
    }

    public byte status() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public boolean mutateStatus(byte status) {
        int o = this.__offset(10);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, status);
            return true;
        }
        return false;
    }

    public long endOffset() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : -1L;
    }

    public boolean mutateEndOffset(long endOffset) {
        int o = this.__offset(12);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, endOffset);
            return true;
        }
        return false;
    }

    public MaterializationTrackingInfo materializationInfo() {
        return this.materializationInfo(new MaterializationTrackingInfo());
    }

    public MaterializationTrackingInfo materializationInfo(MaterializationTrackingInfo obj) {
        int o = this.__offset(14);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public OffsetAndEpoch errorOffsetAndEpoch() {
        return this.errorOffsetAndEpoch(new OffsetAndEpoch());
    }

    public OffsetAndEpoch errorOffsetAndEpoch(OffsetAndEpoch obj) {
        int o = this.__offset(16);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public OffsetAndEpoch restoreOffsetAndEpoch() {
        return this.restoreOffsetAndEpoch(new OffsetAndEpoch());
    }

    public OffsetAndEpoch restoreOffsetAndEpoch(OffsetAndEpoch obj) {
        int o = this.__offset(18);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public long startOffset() {
        int o = this.__offset(20);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : -1L;
    }

    public boolean mutateStartOffset(long startOffset) {
        int o = this.__offset(20);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, startOffset);
            return true;
        }
        return false;
    }

    public static void startTierPartitionStateHeader(FlatBufferBuilder builder) {
        builder.startObject(9);
    }

    public static void addVersion(FlatBufferBuilder builder, byte version) {
        builder.addByte(0, version, 0);
    }

    public static void addTopicId(FlatBufferBuilder builder, int topicIdOffset) {
        builder.addStruct(1, topicIdOffset, 0);
    }

    public static void addTierEpoch(FlatBufferBuilder builder, int tierEpoch) {
        builder.addInt(2, tierEpoch, 0);
    }

    public static void addStatus(FlatBufferBuilder builder, byte status) {
        builder.addByte(3, status, 0);
    }

    public static void addEndOffset(FlatBufferBuilder builder, long endOffset) {
        builder.addLong(4, endOffset, -1L);
    }

    public static void addMaterializationInfo(FlatBufferBuilder builder, int materializationInfoOffset) {
        builder.addOffset(5, materializationInfoOffset, 0);
    }

    public static void addErrorOffsetAndEpoch(FlatBufferBuilder builder, int errorOffsetAndEpochOffset) {
        builder.addStruct(6, errorOffsetAndEpochOffset, 0);
    }

    public static void addRestoreOffsetAndEpoch(FlatBufferBuilder builder, int restoreOffsetAndEpochOffset) {
        builder.addStruct(7, restoreOffsetAndEpochOffset, 0);
    }

    public static void addStartOffset(FlatBufferBuilder builder, long startOffset) {
        builder.addLong(8, startOffset, -1L);
    }

    public static int endTierPartitionStateHeader(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }

    public static void finishTierPartitionStateHeaderBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public static void finishSizePrefixedTierPartitionStateHeaderBuffer(FlatBufferBuilder builder, int offset) {
        builder.finishSizePrefixed(offset);
    }
}

