/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import kafka.server.Defaults;
import kafka.server.KafkaConfig;
import kafka.tier.store.GcsTierObjectStoreConfig;
import kafka.tier.store.S3TierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import org.apache.kafka.common.config.types.Password;

public class TierObjectStoreUtils {
    public static TierObjectStoreConfig generateBackendConfig(TierObjectStore.Backend backend, Properties props) {
        switch (backend) {
            case S3: {
                ArrayList<String> mandatoryProps = new ArrayList<String>(){
                    {
                        this.add(KafkaConfig.TierS3BucketProp());
                        this.add(KafkaConfig.TierS3RegionProp());
                    }
                };
                TierObjectStoreUtils.verifyMandatoryProps(backend, props, (List<String>)mandatoryProps);
                String s3Bucket = props.getProperty(KafkaConfig.TierS3BucketProp());
                String s3Region = props.getProperty(KafkaConfig.TierS3RegionProp());
                return S3TierObjectStoreConfig.createWithEmptyClusterIdBrokerId(s3Bucket, s3Region, props.getProperty(KafkaConfig.TierS3CredFilePathProp()), props.getProperty(KafkaConfig.TierS3EndpointOverrideProp()), props.getProperty(KafkaConfig.TierS3SignerOverrideProp()), props.getProperty(KafkaConfig.TierS3SseAlgorithmProp(), Defaults.TierS3SseAlgorithm()), props.getProperty(KafkaConfig.TierS3SseCustomerEncryptionKeyProp(), Defaults.TierS3SseCustomerEncryptionKey()), Integer.parseInt(props.getOrDefault((Object)KafkaConfig.TierS3AutoAbortThresholdBytesProp(), Defaults.TierS3AutoAbortThresholdBytes()).toString()), props.getProperty(KafkaConfig.TierS3PrefixProp(), Defaults.TierS3Prefix()), props.getProperty(KafkaConfig.TierS3AssumeRoleArnProp(), Defaults.TierS3AssumeRoleArn()), Boolean.valueOf(props.getProperty(KafkaConfig.TierS3ForcePathStyleAccessProp(), Boolean.toString(Defaults.TierS3ForcePathStyleAccess()))), props.getProperty(KafkaConfig.TierS3UserAgentPrefix(), Defaults.TierS3UserAgentPrefix()), props.getProperty(KafkaConfig.TierS3SslProtocolProp(), Defaults.TierS3SslProtocol()), props.getProperty(KafkaConfig.TierS3SslEnabledProtocolsProp(), Defaults.TierS3SslEnabledProtocols()), props.getProperty(KafkaConfig.TierS3SslTrustStoreLocationProp()), (Password)props.get(KafkaConfig.TierS3SslTrustStorePasswordProp()), props.getProperty(KafkaConfig.TierS3SslTrustStoreTypeProp()), props.getProperty(KafkaConfig.TierS3SslKeyStoreLocationProp()), (Password)props.get(KafkaConfig.TierS3SslKeyStorePasswordProp()), props.getProperty(KafkaConfig.TierS3SslKeyStoreTypeProp()), (Password)props.get(KafkaConfig.TierS3SslKeyPasswordProp()));
            }
            case GCS: {
                ArrayList<String> mandatoryProps = new ArrayList<String>(){
                    {
                        this.add(KafkaConfig.TierGcsBucketProp());
                        this.add(KafkaConfig.TierGcsRegionProp());
                    }
                };
                TierObjectStoreUtils.verifyMandatoryProps(backend, props, (List<String>)mandatoryProps);
                String gcsBucket = props.getProperty(KafkaConfig.TierGcsBucketProp());
                String gcsRegion = props.getProperty(KafkaConfig.TierGcsRegionProp());
                String gcsPrefix = props.getProperty(KafkaConfig.TierGcsPrefixProp());
                return GcsTierObjectStoreConfig.createWithEmptyClusterIdBrokerId(gcsBucket, gcsPrefix, gcsRegion, Integer.parseInt(props.getOrDefault((Object)KafkaConfig.TierGcsWriteChunkSizeProp(), (Object)Defaults.TierGcsWriteChunkSize()).toString()), props.getProperty(KafkaConfig.TierGcsCredFilePathProp()), props.getProperty(KafkaConfig.TierGcsSseCustomerEncryptionKeyProp()), Duration.ofSeconds(30L));
            }
            case Mock: {
                return TierObjectStoreConfig.createEmpty();
            }
        }
        throw new UnsupportedOperationException("Unsupported backend for config generation: " + (Object)((Object)backend));
    }

    private static void verifyMandatoryProps(TierObjectStore.Backend backend, Properties props, List<String> mandatoryProps) {
        List absentProps = mandatoryProps.stream().filter(key -> !props.containsKey(key)).collect(Collectors.toList());
        if (absentProps.size() > 0) {
            throw new IllegalArgumentException("Missing mandatory props for backend: " + (Object)((Object)backend) + ": " + absentProps + " mandatoryProps: " + mandatoryProps);
        }
    }
}

