/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.ReplicaManager;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.TierReplicaManager;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.ChangeManager;
import kafka.tier.tasks.TierTaskQueue;
import kafka.tier.tasks.TierTasks$;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiverTaskQueue;
import kafka.tier.tasks.archive.TierArchiver;
import kafka.tier.tasks.delete.DeletionTask;
import kafka.tier.tasks.delete.TierDeletionManager;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.HeartbeatingShutdownableThread;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Uh\u0001B\u0013'\u00015B\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"A\u0011\n\u0001B\u0001B\u0003%!\n\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011!\u0011\u0006A!A!\u0002\u0013\u0019\u0006\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011\u0001\u0004!\u0011!Q\u0001\n\u0005DQ!\u001c\u0001\u0005\u00029DQa\u001e\u0001\u0005RaD\u0011\"!\u0004\u0001\u0001\u0004%I!a\u0004\t\u0013\u0005e\u0001\u00011A\u0005\n\u0005m\u0001\u0002CA\u0014\u0001\u0001\u0006K!!\u0005\t\u0013\u0005%\u0002A1A\u0005\n\u0005-\u0002\u0002CA\u001d\u0001\u0001\u0006I!!\f\t\u0013\u0005m\u0002A1A\u0005\n\u0005u\u0002\u0002CA*\u0001\u0001\u0006I!a\u0010\t\u0013\u0005U\u0003A1A\u0005\f\u0005]\u0003\u0002CA2\u0001\u0001\u0006I!!\u0017\t\u0013\u0005\u0015\u0004A1A\u0005\n\u0005\u001d\u0004\u0002CA;\u0001\u0001\u0006I!!\u001b\t\u0013\u0005]\u0004A1A\u0005\n\u0005e\u0004\u0002CAD\u0001\u0001\u0006I!a\u001f\t\u0013\u0005%\u0005A1A\u0005\n\u0005-\u0005\u0002CAJ\u0001\u0001\u0006I!!$\t\u0013\u0005U\u0005A1A\u0005\n\u0005]\u0005\u0002CAX\u0001\u0001\u0006I!!'\t\u000f\u0005E\u0006\u0001\"\u0011\u00024\"9\u0011Q\u0017\u0001\u0005\u0002\u0005M\u0006bBA\\\u0001\u0011\u0005\u00131\u0017\u0005\b\u0003s\u0003A\u0011AA^\u000f\u001d\t\u0019M\nE\u0001\u0003\u000b4a!\n\u0014\t\u0002\u0005\u001d\u0007BB7!\t\u0003\ty\rC\u0005\u0002R\u0002\u0012\r\u0011\"\u0002\u0002T\"A\u00111\u001c\u0011!\u0002\u001b\t)\u000eC\u0005\u0002^\u0002\n\n\u0011\"\u0001\u0002`\nIA+[3s)\u0006\u001c8n\u001d\u0006\u0003O!\nQ\u0001^1tWNT!!\u000b\u0016\u0002\tQLWM\u001d\u0006\u0002W\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001/ii\u0002\"a\f\u001a\u000e\u0003AR!!\r\u0016\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0002$A\b%fCJ$(-Z1uS:<7\u000b[;uI><h.\u00192mKRC'/Z1e!\t)\u0004(D\u00017\u0015\t9$&A\u0004nKR\u0014\u0018nY:\n\u0005e2$!E&bM.\fW*\u001a;sS\u000e\u001cxI]8vaB\u0011qfO\u0005\u0003yA\u0012q\u0001T8hO&tw-\u0001\u0004d_:4\u0017n\u001a\t\u0003\u007f\u0001k\u0011AJ\u0005\u0003\u0003\u001a\u0012q\u0002V5feR\u000b7o[:D_:4\u0017nZ\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\t!u)D\u0001F\u0015\t1%&\u0001\u0004tKJ4XM]\u0005\u0003\u0011\u0016\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'/\u0001\nuS\u0016\u0014(+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bCA&M\u001b\u0005A\u0013BA')\u0005I!\u0016.\u001a:SKBd\u0017nY1NC:\fw-\u001a:\u0002AQLWM\u001d#fY\u0016$X\r\u001a)beRLG/[8og\u000e{wN\u001d3j]\u0006$xN\u001d\t\u0003\u0017BK!!\u0015\u0015\u0003AQKWM\u001d#fY\u0016$X\r\u001a)beRLG/[8og\u000e{wN\u001d3j]\u0006$xN]\u0001\u0012i&,'\u000fV8qS\u000e\f\u0005\u000f]3oI\u0016\u0014\bC\u0001+X\u001b\u0005)&B\u0001,)\u0003\u0015!x\u000e]5d\u0013\tAVKA\tUS\u0016\u0014Hk\u001c9jG\u0006\u0003\b/\u001a8eKJ\fq\u0002^5fe>\u0013'.Z2u'R|'/\u001a\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\"\nQa\u001d;pe\u0016L!a\u0018/\u0003\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016\fA\u0001^5nKB\u0011!m[\u0007\u0002G*\u0011\u0011\u0007\u001a\u0006\u0003K\u001a\faaY8n[>t'BA\u0016h\u0015\tA\u0017.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0006\u0019qN]4\n\u00051\u001c'\u0001\u0002+j[\u0016\fa\u0001P5oSRtD\u0003C8qcJ\u001cH/\u001e<\u0011\u0005}\u0002\u0001\"B\u001f\t\u0001\u0004q\u0004\"\u0002\"\t\u0001\u0004\u0019\u0005\"B%\t\u0001\u0004Q\u0005\"\u0002(\t\u0001\u0004y\u0005\"\u0002*\t\u0001\u0004\u0019\u0006\"B-\t\u0001\u0004Q\u0006b\u00021\t!\u0003\u0005\r!Y\u0001\u000bY><w-\u001a:OC6,W#A=\u0011\u0007i\f9AD\u0002|\u0003\u0007\u0001\"\u0001`@\u000e\u0003uT!A \u0017\u0002\rq\u0012xn\u001c;?\u0015\t\t\t!A\u0003tG\u0006d\u0017-C\u0002\u0002\u0006}\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u0005\u0003\u0017\u0011aa\u0015;sS:<'bAA\u0003\u007f\u0006\u0011B.Y:u\u0019\u0006<\u0007K]5oiRKW.Z't+\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005UQ\"A@\n\u0007\u0005]qP\u0001\u0003M_:<\u0017A\u00067bgRd\u0015m\u001a)sS:$H+[7f\u001bN|F%Z9\u0015\t\u0005u\u00111\u0005\t\u0005\u0003'\ty\"C\u0002\u0002\"}\u0014A!\u00168ji\"I\u0011QE\u0006\u0002\u0002\u0003\u0007\u0011\u0011C\u0001\u0004q\u0012\n\u0014a\u00057bgRd\u0015m\u001a)sS:$H+[7f\u001bN\u0004\u0013aA2uqV\u0011\u0011Q\u0006\t\u0005\u0003_\t)$\u0004\u0002\u00022)\u0019\u00111\u0007\u0015\u0002\u000f\u0019,Go\u00195fe&!\u0011qGA\u0019\u0005M\u0019\u0015M\\2fY2\fG/[8o\u0007>tG/\u001a=u\u0003\u0011\u0019G\u000f\u001f\u0011\u0002\u0011\u0015DXmY;u_J,\"!a\u0010\u0011\t\u0005\u0005\u0013qJ\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005%\u00131J\u0001\u0005kRLGN\u0003\u0002\u0002N\u0005!!.\u0019<b\u0013\u0011\t\t&a\u0011\u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016\f\u0011\"\u001a=fGV$xN\u001d\u0011\u0002\tA|w\u000e\\\u000b\u0003\u00033\u0002B!a\u0017\u0002`5\u0011\u0011Q\f\u0006\u0004\u0003\u000bz\u0018\u0002BA1\u0003;\u0012\u0001$\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;Fq\u0016\u001cW\u000f^8s\u0003\u0015\u0001xn\u001c7!\u00031!\u0018.\u001a:Be\u000eD\u0017N^3s+\t\tI\u0007\u0005\u0003\u0002l\u0005ETBAA7\u0015\r\tyGJ\u0001\bCJ\u001c\u0007.\u001b<f\u0013\u0011\t\u0019(!\u001c\u0003\u0019QKWM]!sG\"Lg/\u001a:\u0002\u001bQLWM]!sG\"Lg/\u001a:!\u0003M!\u0018.\u001a:EK2,G/[8o\u001b\u0006t\u0017mZ3s+\t\tY\b\u0005\u0003\u0002~\u0005\rUBAA@\u0015\r\t\tIJ\u0001\u0007I\u0016dW\r^3\n\t\u0005\u0015\u0015q\u0010\u0002\u0014)&,'\u000fR3mKRLwN\\'b]\u0006<WM]\u0001\u0015i&,'\u000fR3mKRLwN\\'b]\u0006<WM\u001d\u0011\u0002\u001b\rD\u0017M\\4f\u001b\u0006t\u0017mZ3s+\t\ti\tE\u0002@\u0003\u001fK1!!%'\u00055\u0019\u0005.\u00198hK6\u000bg.Y4fe\u0006q1\r[1oO\u0016l\u0015M\\1hKJ\u0004\u0013aD2zG2,G+[7f\u001b\u0016$(/[2\u0016\u0005\u0005e\u0005\u0003BAN\u0003Wk!!!(\u000b\t\u0005}\u0015\u0011U\u0001\u0005G>\u0014XMC\u00028\u0003GSA!!*\u0002(\u00061\u00110Y7nKJT!!!+\u0002\u0007\r|W.\u0003\u0003\u0002.\u0006u%!B'fi\u0016\u0014\u0018\u0001E2zG2,G+[7f\u001b\u0016$(/[2!\u0003\u0019!wnV8sWR\u0011\u0011QD\u0001\u001c[\u0006L(-\u001a'pORKWM]!sG\"Lg/\u001a:MC\u001eLeNZ8\u0002\u0011MDW\u000f\u001e3po:\f\u0011#\u0019:dQ&4XM\u001d+bg.\fV/Z;f+\t\ti\f\u0005\u0003\u0002l\u0005}\u0016\u0002BAa\u0003[\u0012\u0011#\u0011:dQ&4XM\u001d+bg.\fV/Z;f\u0003%!\u0016.\u001a:UCN\\7\u000f\u0005\u0002@AM\u0019\u0001%!3\u0011\t\u0005M\u00111Z\u0005\u0004\u0003\u001b|(AB!osJ+g\r\u0006\u0002\u0002F\u0006\u0019\u0002+\u0012*J\u001f\u0012K5i\u0018'P\u000f~c\u0015iR0N'V\u0011\u0011Q\u001b\t\u0005\u0003'\t9.C\u0002\u0002Z~\u00141!\u00138u\u0003Q\u0001VIU%P\t&\u001bu\fT(H?2\u000buiX'TA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"!!9+\u0007\u0005\f\u0019o\u000b\u0002\u0002fB!\u0011q]Ay\u001b\t\tIO\u0003\u0003\u0002l\u00065\u0018!C;oG\",7m[3e\u0015\r\tyo`\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAz\u0003S\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class TierTasks
extends HeartbeatingShutdownableThread
implements KafkaMetricsGroup {
    private final TierTasksConfig config;
    private final TierTopicAppender tierTopicAppender;
    private final Time time;
    private long lastLagPrintTimeMs;
    private final CancellationContext ctx;
    private final ExecutorService executor;
    private final ExecutionContextExecutor pool;
    private final TierArchiver kafka$tier$tasks$TierTasks$$tierArchiver;
    private final TierDeletionManager kafka$tier$tasks$TierTasks$$tierDeletionManager;
    private final ChangeManager changeManager;
    private final Meter cycleTimeMetric;

    public static Time $lessinit$greater$default$7() {
        return Time.SYSTEM;
    }

    public static int PERIODIC_LOG_LAG_MS() {
        return TierTasks$.MODULE$.PERIODIC_LOG_LAG_MS();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return TierTasks.class.getName();
    }

    private long lastLagPrintTimeMs() {
        return this.lastLagPrintTimeMs;
    }

    private void lastLagPrintTimeMs_$eq(long x$1) {
        this.lastLagPrintTimeMs = x$1;
    }

    private CancellationContext ctx() {
        return this.ctx;
    }

    private ExecutorService executor() {
        return this.executor;
    }

    private ExecutionContextExecutor pool() {
        return this.pool;
    }

    public TierArchiver kafka$tier$tasks$TierTasks$$tierArchiver() {
        return this.kafka$tier$tasks$TierTasks$$tierArchiver;
    }

    public TierDeletionManager kafka$tier$tasks$TierTasks$$tierDeletionManager() {
        return this.kafka$tier$tasks$TierTasks$$tierDeletionManager;
    }

    private ChangeManager changeManager() {
        return this.changeManager;
    }

    private Meter cycleTimeMetric() {
        return this.cycleTimeMetric;
    }

    @Override
    public void doWork() {
        if (!this.tierTopicAppender.isReady()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "TierTopicAppender is not ready. Backing off.");
            while (!this.tierTopicAppender.isReady() && this.isRunning()) {
                this.time.sleep((long)this.config.mainLoopBackoffMs());
            }
            if (!this.isRunning()) {
                return;
            }
        }
        this.cycleTimeMetric().mark();
        this.changeManager().process();
        List<Future<ArchiveTask>> archiverFutures = this.kafka$tier$tasks$TierTasks$$tierArchiver().doWork();
        List<Future<DeletionTask>> deletionFutures = this.kafka$tier$tasks$TierTasks$$tierDeletionManager().doWork();
        this.maybeLogTierArchiverLagInfo();
        List futures = (List)archiverFutures.$plus$plus(deletionFutures);
        if (this.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue().taskCount() == 0 && this.kafka$tier$tasks$TierTasks$$tierDeletionManager().taskQueue().taskCount() == 0) {
            this.changeManager().processAtLeastOne();
            return;
        }
        if (futures.isEmpty()) {
            this.time.sleep((long)this.config.mainLoopBackoffMs());
            return;
        }
        this.time.sleep((long)this.config.updateIntervalMs());
    }

    public void maybeLogTierArchiverLagInfo() {
        if (this.time.milliseconds() > this.lastLagPrintTimeMs() + (long)TierTasks$.MODULE$.PERIODIC_LOG_LAG_MS()) {
            this.kafka$tier$tasks$TierTasks$$tierArchiver().logPartitionLagInfo();
            this.lastLagPrintTimeMs_$eq(this.time.milliseconds());
        }
    }

    @Override
    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "shutting down");
        this.initiateShutdown();
        this.ctx().cancel();
        this.changeManager().close();
        this.kafka$tier$tasks$TierTasks$$tierArchiver().shutdown();
        this.kafka$tier$tasks$TierTasks$$tierDeletionManager().shutdown();
        this.executor().shutdown();
        this.executor().awaitTermination(30L, TimeUnit.SECONDS);
        this.awaitShutdown();
    }

    public ArchiverTaskQueue archiverTaskQueue() {
        return this.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue();
    }

    public TierTasks(TierTasksConfig config, ReplicaManager replicaManager, TierReplicaManager tierReplicaManager, TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, Time time) {
        this.config = config;
        this.tierTopicAppender = tierTopicAppender;
        this.time = time;
        super("tier-tasks", true);
        this.lastLagPrintTimeMs = time.milliseconds();
        this.ctx = CancellationContext.newContext();
        this.executor = Executors.newFixedThreadPool(config.numThreads(), new ThreadFactory(null){
            private final AtomicInteger threadNum;

            private AtomicInteger threadNum() {
                return this.threadNum;
            }

            public Thread newThread(Runnable r) {
                int newThreadNum = this.threadNum().incrementAndGet();
                String nonDaemon_name = new StringBuilder(9).append("TierTask-").append(newThreadNum).toString();
                return new KafkaThread(nonDaemon_name, r, false);
            }
            {
                this.threadNum = new AtomicInteger(-1);
            }
        });
        this.pool = ExecutionContext$.MODULE$.fromExecutor((Executor)this.executor());
        this.kafka$tier$tasks$TierTasks$$tierArchiver = new TierArchiver(config, replicaManager, tierTopicAppender, tierObjectStore, this.ctx().subContext(), Integer.MAX_VALUE, time, (ExecutionContext)this.pool());
        this.kafka$tier$tasks$TierTasks$$tierDeletionManager = new TierDeletionManager(replicaManager, tierTopicAppender, tierObjectStore, this.ctx().subContext(), Integer.MAX_VALUE, config, time, (ExecutionContext)this.pool());
        this.changeManager = new ChangeManager(this.ctx().subContext(), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TierTaskQueue[]{this.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue(), this.kafka$tier$tasks$TierTasks$$tierDeletionManager().taskQueue()})), time);
        this.removeMetric("HeartbeatMs", this.removeMetric$default$2());
        this.newGauge("HeartbeatMs", new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public synchronized long value() {
                return System.currentTimeMillis() - this.$outer.lastHeartbeatMs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.removeMetric("CyclesPerSec", this.removeMetric$default$2());
        this.cycleTimeMetric = this.newMeter("CyclesPerSec", "tier tasks cycles per second", TimeUnit.SECONDS, this.newMeter$default$4());
        this.removeMetric("NumPartitionsInError", this.removeMetric$default$2());
        this.newGauge("NumPartitionsInError", new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public int value() {
                return this.$outer.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue().errorPartitionCount() + this.$outer.kafka$tier$tasks$TierTasks$$tierDeletionManager().taskQueue().errorPartitionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        this.removeMetric("NumPartitionsInErrorDuringArchival", this.removeMetric$default$2());
        this.newGauge("NumPartitionsInErrorDuringArchival", new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public int value() {
                return this.$outer.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue().errorPartitionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        this.removeMetric("NumPartitionsInErrorDuringDeletion", this.removeMetric$default$2());
        this.newGauge("NumPartitionsInErrorDuringDeletion", new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public int value() {
                return this.$outer.kafka$tier$tasks$TierTasks$$tierDeletionManager().taskQueue().errorPartitionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        tierReplicaManager.addListener(this.changeManager());
        tierDeletedPartitionsCoordinator.registerListener(this.changeManager());
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }
}

