/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierArchiverFailedException;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.exceptions.TierArchiverRestoreFencedException;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask$;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.Defaults$;
import kafka.tier.tasks.archive.FailedState;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.topic.TierTopicAppender;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.collection.Iterator;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\ruc\u0001\u0002\u001b6\u0005yB\u0001b\u0013\u0001\u0003\u0006\u0004%\t\u0005\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005\u001b\"AA\u000b\u0001BC\u0002\u0013\u0005S\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003W\u0011!Y\u0006A!a\u0001\n\u0003a\u0006\u0002\u00031\u0001\u0005\u0003\u0007I\u0011A1\t\u0011)\u0004!\u0011!Q!\nuC\u0001b\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\t_\u0002\u0011)\u0019!C\u0001a\"AA\u000f\u0001B\u0001B\u0003%\u0011\u000fC\u0003v\u0001\u0011\u0005a\u000fC\u0003}\u0001\u0011\u0005S\u0010C\u0004\u0002\u0014\u0001!\t%!\u0006\t\u0013\u0005\u0015\u0005!%A\u0005\u0002\u0005\u001d\u0005bBAO\u0001\u0011\u0005\u0013qT\u0004\b\u0003C+\u0004\u0012AAR\r\u0019!T\u0007#\u0001\u0002&\"1Q/\u0005C\u0001\u0003[CQ\u0001`\t\u0005RuDq!a,\u0012\t\u0003\t\t\f\u0003\u0005\u0002@F!\t!NAa\u0011!\t\t.\u0005C\u0001k\u0005M\u0007\u0002CAx#\u0011\u0005Q'!=\t\u0011\t\r\u0011\u0003\"\u00016\u0005\u000bA\u0001Ba\t\u0012\t\u0003)$Q\u0005\u0005\t\u0005#\nB\u0011A\u001b\u0003T!9!QO\t\u0005\n\t]dA\u0002BA#\u0001\u0013\u0019\tC\u0005\u0003*r\u0011)\u001a!C\u0001{\"I!1\u0016\u000f\u0003\u0012\u0003\u0006IA \u0005\u000b\u0005[c\"Q3A\u0005\u0002\t=\u0006B\u0003B\\9\tE\t\u0015!\u0003\u00032\"1Q\u000f\bC\u0001\u0005sC\u0011Ba1\u001d\u0003\u0003%\tA!2\t\u0013\t-G$%A\u0005\u0002\t5\u0007\"\u0003Bi9E\u0005I\u0011\u0001Bj\u0011%\u00119\u000eHA\u0001\n\u0003\u0012I\u000e\u0003\u0005\u0003jr\t\t\u0011\"\u0001q\u0011%\u0011Y\u000fHA\u0001\n\u0003\u0011i\u000fC\u0005\u0003xr\t\t\u0011\"\u0011\u0003z\"I1q\u0001\u000f\u0002\u0002\u0013\u00051\u0011\u0002\u0005\n\u0007\u001ba\u0012\u0011!C!\u0007\u001fA\u0011ba\u0005\u001d\u0003\u0003%\te!\u0006\t\u0013\r]A$!A\u0005B\req!CB\u000f#\u0005\u0005\t\u0012AB\u0010\r%\u0011\t)EA\u0001\u0012\u0003\u0019\t\u0003\u0003\u0004v]\u0011\u00051\u0011\b\u0005\n\u0003;s\u0013\u0011!C#\u0007wA\u0011\"a,/\u0003\u0003%\ti!\u0010\t\u0013\r\rc&!A\u0005\u0002\u000e\u0015\u0003\"CB*]\u0005\u0005I\u0011BB+\u0005-\t%o\u00195jm\u0016$\u0016m]6\u000b\u0005Y:\u0014aB1sG\"Lg/\u001a\u0006\u0003qe\nQ\u0001^1tWNT!AO\u001e\u0002\tQLWM\u001d\u0006\u0002y\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001@\u000bB\u0019\u0001)Q\"\u000e\u0003]J!AQ\u001c\u0003\u0011QKWM\u001d+bg.\u0004\"\u0001\u0012\u0001\u000e\u0003U\u0002\"AR%\u000e\u0003\u001dS!\u0001S\u001e\u0002\u000bU$\u0018\u000e\\:\n\u0005);%a\u0002'pO\u001eLgnZ\u0001\u0004GRDX#A'\u0011\u00059\u000bV\"A(\u000b\u0005AK\u0014a\u00024fi\u000eDWM]\u0005\u0003%>\u00131cQ1oG\u0016dG.\u0019;j_:\u001cuN\u001c;fqR\fAa\u0019;yA\u0005\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\\\u000b\u0002-B\u0011q\u000bW\u0007\u0002s%\u0011\u0011,\u000f\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\f\u0011\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8!\u0003\u0015\u0019H/\u0019;f+\u0005i\u0006C\u0001#_\u0013\tyVG\u0001\tBe\u000eD\u0017N^3UCN\\7\u000b^1uK\u0006I1\u000f^1uK~#S-\u001d\u000b\u0003E\"\u0004\"a\u00194\u000e\u0003\u0011T\u0011!Z\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0012\u0014A!\u00168ji\"9\u0011NBA\u0001\u0002\u0004i\u0016a\u0001=%c\u000511\u000f^1uK\u0002\nq\"\u0019:dQ&4XM]'fiJL7m\u001d\t\u0003\t6L!A\\\u001b\u0003\u001f\u0005\u00138\r[5wKJlU\r\u001e:jGN\f\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002cB\u00111M]\u0005\u0003g\u0012\u00141!\u00138u\u0003%\u0011'o\\6fe&#\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0007\u0007^D\u0018P_>\t\u000b-[\u0001\u0019A'\t\u000bQ[\u0001\u0019\u0001,\t\u000bm[\u0001\u0019A/\t\u000b-\\\u0001\u0019\u00017\t\u000b=\\\u0001\u0019A9\u0002\u00151|wmZ3s\u001d\u0006lW-F\u0001\u007f!\ry\u0018Q\u0002\b\u0005\u0003\u0003\tI\u0001E\u0002\u0002\u0004\u0011l!!!\u0002\u000b\u0007\u0005\u001dQ(\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0017!\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0010\u0005E!AB*ue&twMC\u0002\u0002\f\u0011\f!\u0002\u001e:b]NLG/[8o)1\t9\"a\f\u0002L\u0005m\u00131NA>)\u0011\tI\"!\n\u0011\u000b\u0005m\u0011\u0011E\"\u000e\u0005\u0005u!bAA\u0010I\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005\r\u0012Q\u0004\u0002\u0007\rV$XO]3\t\u000f\u0005\u001dR\u0002q\u0001\u0002*\u0005\u0011Qm\u0019\t\u0005\u00037\tY#\u0003\u0003\u0002.\u0005u!\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u001d\t\t$\u0004a\u0001\u0003g\tA\u0001^5nKB!\u0011QGA$\u001b\t\t9DC\u0002I\u0003sQA!a\u000f\u0002>\u000511m\\7n_:T1\u0001PA \u0015\u0011\t\t%a\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t)%A\u0002pe\u001eLA!!\u0013\u00028\t!A+[7f\u0011\u001d\ti%\u0004a\u0001\u0003\u001f\n\u0011\u0003^5feR{\u0007/[2BaB,g\u000eZ3s!\u0011\t\t&a\u0016\u000e\u0005\u0005M#bAA+s\u0005)Ao\u001c9jG&!\u0011\u0011LA*\u0005E!\u0016.\u001a:U_BL7-\u00119qK:$WM\u001d\u0005\b\u0003;j\u0001\u0019AA0\u0003=!\u0018.\u001a:PE*,7\r^*u_J,\u0007\u0003BA1\u0003Oj!!a\u0019\u000b\u0007\u0005\u0015\u0014(A\u0003ti>\u0014X-\u0003\u0003\u0002j\u0005\r$a\u0004+jKJ|%M[3diN#xN]3\t\u000f\u00055T\u00021\u0001\u0002p\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\u0003BA9\u0003oj!!a\u001d\u000b\u0007\u0005U4(\u0001\u0004tKJ4XM]\u0005\u0005\u0003s\n\u0019H\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u0013\u0005uT\u0002%AA\u0002\u0005}\u0014!E7bqJ+GO]=CC\u000e\\wN\u001a4NgB!1-!!r\u0013\r\t\u0019\t\u001a\u0002\u0007\u001fB$\u0018n\u001c8\u0002)Q\u0014\u0018M\\:ji&|g\u000e\n3fM\u0006,H\u000e\u001e\u00136+\t\tII\u000b\u0003\u0002\u0000\u0005-5FAAG!\u0011\ty)!'\u000e\u0005\u0005E%\u0002BAJ\u0003+\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]E-\u0001\u0006b]:|G/\u0019;j_:LA!a'\u0002\u0012\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A`\u0001\f\u0003J\u001c\u0007.\u001b<f)\u0006\u001c8\u000e\u0005\u0002E#M!\u0011#a*F!\r\u0019\u0017\u0011V\u0005\u0004\u0003W#'AB!osJ+g\r\u0006\u0002\u0002$\u0006)\u0011\r\u001d9msRY1)a-\u00026\u0006]\u00161XA_\u0011\u0015YE\u00031\u0001N\u0011\u0015!F\u00031\u0001W\u0011\u0019\tI\f\u0006a\u0001c\u0006YA.Z1eKJ,\u0005o\\2i\u0011\u0015YG\u00031\u0001m\u0011\u0015yG\u00031\u0001r\u0003A\u0019\u0007.Z2l\r\u0006LG.\u001a3Ti\u0006$X\r\u0006\u0005\u0002D\u0006\u0015\u0017QZAh!\u0015\tY\"!\t^\u0011\u0019YV\u00031\u0001\u0002HB\u0019A)!3\n\u0007\u0005-WGA\u0006GC&dW\rZ*uCR,\u0007\"\u0002+\u0016\u0001\u00041\u0006bBA7+\u0001\u0007\u0011qN\u0001\u0014KN$\u0018M\u00197jg\"dU-\u00193feND\u0017\u000e\u001d\u000b\u000b\u0003+\f\t/!;\u0002l\u00065H\u0003BAl\u0003?\u0004b!a\u0007\u0002\"\u0005e\u0007c\u0001#\u0002\\&\u0019\u0011Q\\\u001b\u0003\u0019\t+gm\u001c:f+Bdw.\u00193\t\u000f\u0005\u001db\u0003q\u0001\u0002*!11L\u0006a\u0001\u0003G\u00042\u0001RAs\u0013\r\t9/\u000e\u0002\r\u0005\u00164wN]3MK\u0006$WM\u001d\u0005\u0006)Z\u0001\rA\u0016\u0005\b\u0003\u001b2\u0002\u0019AA(\u0011\u0015yg\u00031\u0001r\u0003Mi\u0017-\u001f2f\u0013:LG/[1uKV\u0003Hn\\1e)9\t\u00190a>\u0002z\u0006m\u0018Q`A\u0000\u0005\u0003!B!a1\u0002v\"9\u0011qE\fA\u0004\u0005%\u0002BB.\u0018\u0001\u0004\tI\u000eC\u0003U/\u0001\u0007a\u000bC\u0004\u00022]\u0001\r!a\r\t\u000f\u00055s\u00031\u0001\u0002P!9\u0011QL\fA\u0002\u0005}\u0003bBA7/\u0001\u0007\u0011qN\u0001\u0007kBdw.\u00193\u0015\u0019\t\u001d!1\u0003B\u000e\u0005;\u0011yB!\t\u0015\t\t%!\u0011\u0003\t\u0007\u00037\t\tCa\u0003\u0011\u0007\u0011\u0013i!C\u0002\u0003\u0010U\u00121\"\u00114uKJ,\u0006\u000f\\8bI\"9\u0011q\u0005\rA\u0004\u0005%\u0002BB.\u0019\u0001\u0004\u0011)\u0002E\u0002E\u0005/I1A!\u00076\u0005\u0019)\u0006\u000f\\8bI\")A\u000b\u0007a\u0001-\"9\u0011\u0011\u0007\rA\u0002\u0005M\u0002\"B&\u0019\u0001\u0004i\u0005bBA/1\u0001\u0007\u0011qL\u0001\u000fM&t\u0017\r\\5{KV\u0003Hn\\1e)1\u00119Ca\u000b\u0003.\t=\"\u0011\u0007B\u001a)\u0011\t9N!\u000b\t\u000f\u0005\u001d\u0012\u0004q\u0001\u0002*!11,\u0007a\u0001\u0005\u0017AQ\u0001V\rA\u0002YCq!!\r\u001a\u0001\u0004\t\u0019\u0004C\u0004\u0002Ne\u0001\r!a\u0014\t\u000f\tU\u0012\u00041\u0001\u00038\u0005q!-\u001f;f%\u0006$X-T3ue&\u001c\u0007#B2\u0002\u0002\ne\u0002\u0003\u0002B\u001e\u0005\u001bj!A!\u0010\u000b\t\t}\"\u0011I\u0001\u0005G>\u0014XM\u0003\u0003\u0003D\t\u0015\u0013aB7fiJL7m\u001d\u0006\u0005\u0005\u000f\u0012I%\u0001\u0004zC6lWM\u001d\u0006\u0003\u0005\u0017\n1aY8n\u0013\u0011\u0011yE!\u0010\u0003\u000b5+G/\u001a:\u0002#U\u0004Hn\\1eC\ndWmU3h[\u0016tG\u000f\u0006\u0005\u0003V\t\u0005$\u0011\u000eB:!\u0011\u00119F!\u0018\u000e\u0005\te#b\u0001B.w\u0005\u0019An\\4\n\t\t}#\u0011\f\u0002\u0012+Bdw.\u00193bE2,7+Z4nK:$\bb\u0002B.5\u0001\u0007!1\r\t\u0005\u0005/\u0012)'\u0003\u0003\u0003h\te#aC!cgR\u0014\u0018m\u0019;M_\u001eDqAa\u001b\u001b\u0001\u0004\u0011i'\u0001\u0006m_\u001e\u001cVmZ7f]R\u0004BAa\u0016\u0003p%!!\u0011\u000fB-\u0005)aunZ*fO6,g\u000e\u001e\u0005\u0006)j\u0001\rAV\u0001\u0012g\u0016<W.\u001a8u\r&dWm]#ySN$H\u0003\u0002B=\u0005\u007f\u00022a\u0019B>\u0013\r\u0011i\b\u001a\u0002\b\u0005>|G.Z1o\u0011\u001d\u0011\tf\u0007a\u0001\u0005+\u0012qcU3h[\u0016tG\u000fR3mKR,G-\u0012=dKB$\u0018n\u001c8\u0014\u000fq\u0011)I!%\u0003\u0018B!!q\u0011BG\u001b\t\u0011II\u0003\u0003\u0003\f\u0006e\u0012AB3se>\u00148/\u0003\u0003\u0003\u0010\n%%A\u0005*fiJL\u0017M\u00197f\u000bb\u001cW\r\u001d;j_:\u00042a\u0019BJ\u0013\r\u0011)\n\u001a\u0002\b!J|G-^2u!\u0011\u0011IJa)\u000f\t\tm%q\u0014\b\u0005\u0003\u0007\u0011i*C\u0001f\u0013\r\u0011\t\u000bZ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011)Ka*\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0007\t\u0005F-A\u0002ng\u001e\fA!\\:hA\u0005)1-Y;tKV\u0011!\u0011\u0017\t\u0005\u00053\u0013\u0019,\u0003\u0003\u00036\n\u001d&!\u0003+ie><\u0018M\u00197f\u0003\u0019\u0019\u0017-^:fAQ1!1\u0018B`\u0005\u0003\u00042A!0\u001d\u001b\u0005\t\u0002B\u0002BUC\u0001\u0007a\u0010C\u0004\u0003.\u0006\u0002\rA!-\u0002\t\r|\u0007/\u001f\u000b\u0007\u0005w\u00139M!3\t\u0011\t%&\u0005%AA\u0002yD\u0011B!,#!\u0003\u0005\rA!-\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!q\u001a\u0016\u0004}\u0006-\u0015AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005+TCA!-\u0002\f\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"Aa7\u0011\t\tu'q]\u0007\u0003\u0005?TAA!9\u0003d\u0006!A.\u00198h\u0015\t\u0011)/\u0001\u0003kCZ\f\u0017\u0002BA\b\u0005?\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003p\nU\bcA2\u0003r&\u0019!1\u001f3\u0003\u0007\u0005s\u0017\u0010C\u0004jO\u0005\u0005\t\u0019A9\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa?\u0011\r\tu81\u0001Bx\u001b\t\u0011yPC\u0002\u0004\u0002\u0011\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019)Aa@\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005s\u001aY\u0001\u0003\u0005jS\u0005\u0005\t\u0019\u0001Bx\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\tm7\u0011\u0003\u0005\bS*\n\t\u00111\u0001r\u0003!A\u0017m\u001d5D_\u0012,G#A9\u0002\r\u0015\fX/\u00197t)\u0011\u0011Iha\u0007\t\u0011%d\u0013\u0011!a\u0001\u0005_\fqcU3h[\u0016tG\u000fR3mKR,G-\u0012=dKB$\u0018n\u001c8\u0011\u0007\tuffE\u0003/\u0007G\u0019y\u0003E\u0005\u0004&\r-bP!-\u0003<6\u00111q\u0005\u0006\u0004\u0007S!\u0017a\u0002:v]RLW.Z\u0005\u0005\u0007[\u00199CA\tBEN$(/Y2u\rVt7\r^5p]J\u0002Ba!\r\u000485\u001111\u0007\u0006\u0005\u0007k\u0011\u0019/\u0001\u0002j_&!!QUB\u001a)\t\u0019y\u0002\u0006\u0002\u0003\\R1!1XB \u0007\u0003BaA!+2\u0001\u0004q\bb\u0002BWc\u0001\u0007!\u0011W\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u00199ea\u0014\u0011\u000b\r\f\ti!\u0013\u0011\r\r\u001cYE BY\u0013\r\u0019i\u0005\u001a\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\rE#'!AA\u0002\tm\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u00111q\u000b\t\u0005\u0005;\u001cI&\u0003\u0003\u0004\\\t}'AB(cU\u0016\u001cG\u000f")
public final class ArchiveTask
extends TierTask<ArchiveTask> {
    private final CancellationContext ctx;
    private final TopicIdPartition topicIdPartition;
    private ArchiveTaskState state;
    private final ArchiverMetrics archiverMetrics;
    private final int brokerId;

    public static ArchiveTask apply(CancellationContext ctx, TopicIdPartition topicIdPartition, int leaderEpoch, ArchiverMetrics archiverMetrics, int brokerId) {
        return ArchiveTask$.MODULE$.apply(ctx, topicIdPartition, leaderEpoch, archiverMetrics, brokerId);
    }

    @Override
    public CancellationContext ctx() {
        return this.ctx;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public ArchiveTaskState state() {
        return this.state;
    }

    public void state_$eq(ArchiveTaskState x$1) {
        this.state = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    @Override
    public String loggerName() {
        return ArchiveTask.class.getName();
    }

    @Override
    public Future<ArchiveTask> transition(Time time, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, ReplicaManager replicaManager, Option<Object> maxRetryBackoffMs, ExecutionContext ec) {
        Future<BeforeUpload> future;
        if (this.ctx().isCancelled()) {
            future = Future$.MODULE$.successful((Object)this.state());
        } else {
            Object object;
            ArchiveTaskState archiveTaskState = this.state();
            if (archiveTaskState instanceof BeforeLeader) {
                BeforeLeader beforeLeader = (BeforeLeader)archiveTaskState;
                object = ArchiveTask$.MODULE$.establishLeadership(beforeLeader, this.topicIdPartition(), tierTopicAppender, this.brokerId(), ec);
            } else if (archiveTaskState instanceof BeforeUpload) {
                BeforeUpload beforeUpload = (BeforeUpload)archiveTaskState;
                object = ArchiveTask$.MODULE$.maybeInitiateUpload(beforeUpload, this.topicIdPartition(), time, tierTopicAppender, tierObjectStore, replicaManager, ec);
            } else if (archiveTaskState instanceof Upload) {
                Upload upload = (Upload)archiveTaskState;
                object = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), time, this.ctx(), tierObjectStore, ec);
            } else if (archiveTaskState instanceof AfterUpload) {
                AfterUpload afterUpload = (AfterUpload)archiveTaskState;
                object = ArchiveTask$.MODULE$.finalizeUpload(afterUpload, this.topicIdPartition(), time, tierTopicAppender, this.archiverMetrics.byteRateOpt(), ec);
            } else if (archiveTaskState instanceof FailedState) {
                FailedState failedState = (FailedState)archiveTaskState;
                object = ArchiveTask$.MODULE$.checkFailedState(failedState, this.topicIdPartition(), replicaManager);
            } else {
                throw new MatchError((Object)archiveTaskState);
            }
            future = object;
        }
        return future.map((Function1 & Serializable)result -> {
            this.onSuccessfulTransition();
            this.state_$eq((ArchiveTaskState)result);
            return this;
        }, ec).recover((PartialFunction)new Serializable(this, maxRetryBackoffMs, time){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchiveTask $outer;
            private final Option maxRetryBackoffMs$1;
            private final Time time$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 instanceof TierMetadataRetriableException) {
                    TierMetadataRetriableException tierMetadataRetriableException = (TierMetadataRetriableException)((Object)x1);
                    this.$outer.retryTaskLater(BoxesRunTime.unboxToInt((Object)this.maxRetryBackoffMs$1.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Defaults$.MODULE$.METADATA_EXCEPTION_RETRY_MS())), this.time$1.hiResClockMs(), (Throwable)((Object)tierMetadataRetriableException));
                    object = this.$outer;
                } else if (x1 instanceof TierObjectStoreRetriableException) {
                    TierObjectStoreRetriableException tierObjectStoreRetriableException = (TierObjectStoreRetriableException)((Object)x1);
                    this.$outer.retryTaskLater(BoxesRunTime.unboxToInt((Object)this.maxRetryBackoffMs$1.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Defaults$.MODULE$.OBJECT_STORE_EXCEPTION_RETRY_MS())), this.time$1.hiResClockMs(), (Throwable)((Object)tierObjectStoreRetriableException));
                    object = this.$outer;
                } else if (x1 instanceof TierArchiverFailedException) {
                    TierArchiverFailedException tierArchiverFailedException = (TierArchiverFailedException)x1;
                    ArchiveTask archiveTask = this.$outer;
                    if (archiveTask == null) {
                        throw null;
                    }
                    ArchiveTask warn_this = archiveTask;
                    if (warn_this.logger().underlying().isWarnEnabled()) {
                        warn_this.logger().underlying().warn(warn_this.msgWithLogIdent($anonfun$transition$2.$anonfun$applyOrElse$3(this)), (Throwable)tierArchiverFailedException);
                    }
                    Object var10_7 = null;
                    this.$outer.retryTaskLater(BoxesRunTime.unboxToInt((Object)this.maxRetryBackoffMs$1.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Defaults$.MODULE$.FENCED_STATE_EXCEPTION_RETRY_MS())), this.time$1.hiResClockMs(), tierArchiverFailedException);
                    this.$outer.state_$eq(new FailedState(this.$outer.state().leaderEpoch()));
                    object = this.$outer;
                } else if (x1 instanceof TierArchiverRestoreFencedException) {
                    ArchiveTask archiveTask = this.$outer;
                    if (archiveTask == null) {
                        throw null;
                    }
                    ArchiveTask debug_this = archiveTask;
                    if (debug_this.logger().underlying().isDebugEnabled()) {
                        debug_this.logger().underlying().debug(debug_this.msgWithLogIdent($anonfun$transition$2.$anonfun$applyOrElse$6(this)));
                    }
                    Object var11_8 = null;
                    this.$outer.state_$eq(new FailedState(this.$outer.state().leaderEpoch()));
                    object = this.$outer;
                } else if (x1 instanceof TierArchiverFencedException) {
                    TierArchiverFencedException tierArchiverFencedException = (TierArchiverFencedException)x1;
                    ArchiveTask archiveTask = this.$outer;
                    if (archiveTask == null) {
                        throw null;
                    }
                    ArchiveTask info_this = archiveTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$2.$anonfun$applyOrElse$7(this)), (Throwable)tierArchiverFencedException);
                    }
                    Object var12_10 = null;
                    this.$outer.ctx().cancel();
                    object = this.$outer;
                } else if (x1 instanceof NotTierablePartitionException) {
                    NotTierablePartitionException notTierablePartitionException = (NotTierablePartitionException)x1;
                    ArchiveTask archiveTask = this.$outer;
                    if (archiveTask == null) {
                        throw null;
                    }
                    ArchiveTask info_this = archiveTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$2.$anonfun$applyOrElse$9(this)), (Throwable)notTierablePartitionException);
                    }
                    Object var13_12 = null;
                    this.$outer.ctx().cancel();
                    object = this.$outer;
                } else if (x1 instanceof SegmentDeletedException) {
                    SegmentDeletedException segmentDeletedException = (SegmentDeletedException)((Object)x1);
                    this.$outer.state_$eq(this.$outer.state().handleSegmentDeletedException(segmentDeletedException));
                    this.$outer.retryTaskLater(BoxesRunTime.unboxToInt((Object)this.maxRetryBackoffMs$1.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Defaults$.MODULE$.SEGMENT_DELETED_RETRY_MS())), this.time$1.hiResClockMs(), (Throwable)((Object)segmentDeletedException));
                    object = this.$outer;
                } else if (x1 != null) {
                    ArchiveTask archiveTask = this.$outer;
                    if (archiveTask == null) {
                        throw null;
                    }
                    ArchiveTask error_this = archiveTask;
                    if (error_this.logger().underlying().isErrorEnabled()) {
                        error_this.logger().underlying().error(error_this.msgWithLogIdent($anonfun$transition$2.$anonfun$applyOrElse$12(this)), x1);
                    }
                    Object var14_14 = null;
                    this.$outer.cancelAndSetErrorState(this.$outer, x1);
                    object = this.$outer;
                } else {
                    object = function1.apply(null);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                boolean bl = x1 instanceof TierMetadataRetriableException ? true : (x1 instanceof TierObjectStoreRetriableException ? true : (x1 instanceof TierArchiverFailedException ? true : (x1 instanceof TierArchiverRestoreFencedException ? true : (x1 instanceof TierArchiverFencedException ? true : (x1 instanceof NotTierablePartitionException ? true : (x1 instanceof SegmentDeletedException ? true : x1 != null))))));
                return bl;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$3($anonfun$transition$2 $this) {
                return new StringBuilder(61).append($this.$outer.topicIdPartition()).append(" failed, pausing archival process and marking ").append($this.$outer.topicIdPartition()).append(" to be in error").toString();
            }

            public static final /* synthetic */ TierArchiverFailedException $anonfun$applyOrElse$4(TierArchiverFailedException x4$1) {
                return x4$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$6($anonfun$transition$2 $this) {
                return new StringBuilder(54).append($this.$outer.topicIdPartition()).append(" encountered metadata fencing due to state restoration").toString();
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$7($anonfun$transition$2 $this) {
                return new StringBuilder(38).append($this.$outer.topicIdPartition()).append(" was fenced, stopping archival process").toString();
            }

            public static final /* synthetic */ TierArchiverFencedException $anonfun$applyOrElse$8(TierArchiverFencedException x6$1) {
                return x6$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$9($anonfun$transition$2 $this) {
                return new StringBuilder(39).append($this.$outer.topicIdPartition()).append(" is not tierable and cannot be archived").toString();
            }

            public static final /* synthetic */ NotTierablePartitionException $anonfun$applyOrElse$10(NotTierablePartitionException x7$1) {
                return x7$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$12($anonfun$transition$2 $this) {
                return new StringBuilder(89).append($this.$outer.topicIdPartition()).append(" failed due to unhandled exception, stopping archival process and marking ").append($this.$outer.topicIdPartition()).append(" to be in error").toString();
            }

            public static final /* synthetic */ Throwable $anonfun$applyOrElse$13(Throwable x9$1) {
                return x9$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maxRetryBackoffMs$1 = maxRetryBackoffMs$1;
                this.time$1 = time$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$11(), $anonfun$applyOrElse$2(), $anonfun$applyOrElse$5()}, serializedLambda);
            }
        }, ec);
    }

    @Override
    public Option<Object> transition$default$5() {
        return None$.MODULE$;
    }

    public String toString() {
        return new StringBuilder(41).append("ArchiveTask(").append(this.topicIdPartition()).append(", state=").append(this.state().getClass().getName()).append(", epoch=").append(this.state().leaderEpoch()).append(", cancelled=").append(this.ctx().isCancelled()).append(")").toString();
    }

    public ArchiveTask(CancellationContext ctx, TopicIdPartition topicIdPartition, ArchiveTaskState state, ArchiverMetrics archiverMetrics, int brokerId) {
        this.ctx = ctx;
        this.topicIdPartition = topicIdPartition;
        this.state = state;
        this.archiverMetrics = archiverMetrics;
        this.brokerId = brokerId;
        super(archiverMetrics.retryRateOpt());
    }

    public static class SegmentDeletedException
    extends RetriableException
    implements Product {
        private final String msg;
        private final Throwable cause;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String msg() {
            return this.msg;
        }

        public Throwable cause() {
            return this.cause;
        }

        public SegmentDeletedException copy(String msg, Throwable cause) {
            return new SegmentDeletedException(msg, cause);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public Throwable copy$default$2() {
            return this.cause();
        }

        public String productPrefix() {
            return "SegmentDeletedException";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.msg();
                }
                case 1: {
                    return this.cause();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SegmentDeletedException;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "msg";
                }
                case 1: {
                    return "cause";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof SegmentDeletedException)) return false;
            boolean bl = true;
            if (!bl) return false;
            SegmentDeletedException segmentDeletedException = (SegmentDeletedException)((Object)x$1);
            String string = this.msg();
            String string2 = segmentDeletedException.msg();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Throwable throwable = this.cause();
            Throwable throwable2 = segmentDeletedException.cause();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!segmentDeletedException.canEqual((Object)this)) return false;
            return true;
        }

        public SegmentDeletedException(String msg, Throwable cause) {
            this.msg = msg;
            this.cause = cause;
            super(msg, cause);
            Product.$init$((Product)this);
        }
    }
}

