/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import kafka.log.Log;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.FileTierPartitionIterator;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import kafka.tier.store.TierObjectStore;
import kafka.utils.checksum.CheckedFileIO;
import org.apache.kafka.common.TopicPartition;

public class DumpTierPartitionState {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("usage: /path/to/kafka-run-class.sh kafka.tier.tools.DumpTierPartitionState /path/to/topic-partition");
            System.err.println("Optionally --print-checksum gives details related to the checksum of the file");
            System.exit(1);
        }
        boolean printChecksum = args.length >= 2 && args[1].equals("--print-checksum");
        File dir = new File(args[0]);
        TopicPartition topicPartition = Log.parseTopicPartitionName(dir);
        System.out.println("Reading tier partition state for " + topicPartition);
        for (File file : dir.listFiles()) {
            if (!file.isFile() || !Log.isTierStateFile(file)) continue;
            System.out.println("Dumping state in file " + file);
            DumpTierPartitionState.dumpTierState(topicPartition, file, false, printChecksum);
        }
    }

    public static void dumpTierState(TopicPartition topicPartition, File file, boolean headerOnly, boolean printChecksum) {
        try (CheckedFileIO fileChannel = CheckedFileIO.open(file.toPath(), StandardOpenOption.READ);){
            Optional<Header> headerOpt;
            if (printChecksum) {
                System.out.println(fileChannel);
            }
            if (!(headerOpt = FileTierPartitionState.readHeader(fileChannel)).isPresent()) {
                System.out.println("Empty header");
                return;
            }
            System.out.println(headerOpt.get().toString());
            if (headerOnly) {
                return;
            }
            Optional<FileTierPartitionIterator> iteratorOpt = FileTierPartitionState.iterator(topicPartition, fileChannel);
            if (!iteratorOpt.isPresent()) {
                System.out.println("Empty file");
                return;
            }
            while (iteratorOpt.get().hasNext()) {
                TierObjectMetadata metadata = (TierObjectMetadata)iteratorOpt.get().next();
                TierObjectStore.ObjectMetadata objectMetadata = new TierObjectStore.ObjectMetadata(metadata.topicIdPartition(), metadata.objectId(), metadata.tierEpoch(), metadata.baseOffset(), metadata.hasAbortedTxns(), metadata.hasProducerState(), metadata.hasEpochState(), metadata.opaqueData());
                System.out.println(metadata + " => " + objectMetadata.toPath("", TierObjectStore.FileType.SEGMENT));
            }
        }
        catch (IOException e) {
            System.err.println("Caught exception for file " + file);
            e.printStackTrace();
        }
    }
}

