/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.log.LogConfig;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import org.apache.kafka.common.errors.TopicExistsException;
import scala.Function0;
import scala.Predef$;
import scala.runtime.BoxesRunTime;

public final class TierTopicAdmin$
implements Logging {
    public static final TierTopicAdmin$ MODULE$ = new TierTopicAdmin$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public int ensureTopic(AdminZkClient adminZkClient, String topicName, int configuredNumPartitions, short configuredReplicationFactor) {
        int n;
        try {
            if (!adminZkClient.topicExists(topicName)) {
                adminZkClient.createTopic(topicName, configuredNumPartitions, configuredReplicationFactor, this.topicConfig(), adminZkClient.createTopic$default$5(), adminZkClient.createTopic$default$6(), adminZkClient.createTopic$default$7(), adminZkClient.createTopic$default$8());
                if (this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TierTopicAdmin$.$anonfun$ensureTopic$4(topicName, configuredNumPartitions);
                    Object var5_5 = null;
                    this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                return configuredNumPartitions;
            }
            n = this.numPartitions$1(adminZkClient, topicName, configuredNumPartitions);
        }
        catch (TopicExistsException topicExistsException) {
            n = this.numPartitions$1(adminZkClient, topicName, configuredNumPartitions);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public Properties topicConfig() {
        void var1_1;
        Properties properties = new Properties();
        properties.put("cleanup.policy", "delete");
        properties.put("retention.ms", "-1");
        properties.put("retention.bytes", "-1");
        properties.put("unclean.leader.election.enable", "false");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isConfigValid(LogConfig config, String topicName) {
        void var3_3;
        boolean isValid;
        boolean bl = isValid = config.delete() && !config.compact() && BoxesRunTime.equalsNumObject((Number)config.retentionMs(), (Object)BoxesRunTime.boxToInteger((int)-1)) && BoxesRunTime.equalsNumObject((Number)config.retentionSize(), (Object)BoxesRunTime.boxToInteger((int)-1));
        if (Predef$.MODULE$.Boolean2boolean(config.uncleanLeaderElectionEnable()) && isValid && this.logger().underlying().isWarnEnabled()) {
            String msgWithLogIdent_msg = TierTopicAdmin$.$anonfun$isConfigValid$1(topicName);
            Object var4_4 = null;
            this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        return (boolean)var3_3;
    }

    public static final /* synthetic */ String $anonfun$ensureTopic$2(String topicName$1, int numPartitions$2, int configuredNumPartitions$1) {
        return new StringBuilder(0).append(new StringBuilder(66).append("Topic ").append(topicName$1).append(" already exists. Mismatch between existing partition count ").append(numPartitions$2).append(" ").toString()).append(new StringBuilder(32).append("and configured partition count ").append(configuredNumPartitions$1).append(".").toString()).toString();
    }

    public static final /* synthetic */ String $anonfun$ensureTopic$3(String topicName$1, int numPartitions$2) {
        return new StringBuilder(30).append("Topic ").append(topicName$1).append(" exists with ").append(numPartitions$2).append(" partitions").toString();
    }

    private final int numPartitions$1(AdminZkClient adminZkClient$1, String topicName$1, int configuredNumPartitions$1) {
        int numPartitions = BoxesRunTime.unboxToInt((Object)adminZkClient$1.numPartitions(topicName$1).getOrElse((Function0 & Serializable)() -> {
            throw new TierMetadataRetriableException(new StringBuilder(22).append(topicName$1).append(" deleted unexpectedly.").toString());
        }));
        if (numPartitions != configuredNumPartitions$1) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = TierTopicAdmin$.$anonfun$ensureTopic$2(topicName$1, numPartitions, configuredNumPartitions$1);
                Object var5_5 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
        } else if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = TierTopicAdmin$.$anonfun$ensureTopic$3(topicName$1, numPartitions);
            Object var6_6 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        return numPartitions;
    }

    public static final /* synthetic */ String $anonfun$ensureTopic$4(String topicName$1, int configuredNumPartitions$1) {
        return new StringBuilder(31).append("Created topic ").append(topicName$1).append(" with ").append(configuredNumPartitions$1).append(" partitions").toString();
    }

    public static final /* synthetic */ String $anonfun$isConfigValid$1(String topicName$2) {
        return new StringBuilder(0).append(new StringBuilder(62).append("Unclean leader election is enabled on tier metadata topic (").append(topicName$2).append("). ").toString()).append("This could cause unintended data loss or inconsistencies. ").append("It is recommended that unclean leader election be disabled on this topic.").toString();
    }

    private TierTopicAdmin$() {
    }
}

