/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.checksum;

import java.nio.ByteBuffer;
import java.util.zip.Adler32;
import kafka.utils.checksum.ChecksumWithInPlaceUpdate;

public class Adler32WithInPlaceUpdate
implements ChecksumWithInPlaceUpdate {
    private volatile long checksum;
    private long length;
    private static final int MOD = 65521;

    public Adler32WithInPlaceUpdate() {
        this.reset();
    }

    @Override
    public void update(int b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(byte[] b, int off, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getValue() {
        return this.checksum;
    }

    @Override
    public void reset() {
        this.checksum = 1L;
        this.length = 0L;
    }

    @Override
    public void restore(long checksum, long length) {
        this.checksum = checksum;
        this.length = length;
    }

    @Override
    public long length() {
        return this.length;
    }

    private static long concatenate(long a, long b) {
        return a + (b << 16);
    }

    private static long getA(long x) {
        return x & 0xFFFFL;
    }

    private static long getB(long x) {
        return x >> 16;
    }

    private static long computeChecksum(ByteBuffer buffer) {
        Adler32 adler32 = new Adler32();
        adler32.update(buffer);
        return adler32.getValue();
    }

    @Override
    public void append(ByteBuffer buffer) {
        long l = buffer.remaining();
        long oldA = Adler32WithInPlaceUpdate.getA(this.checksum);
        long oldB = Adler32WithInPlaceUpdate.getB(this.checksum);
        long updatedChecksum = Adler32WithInPlaceUpdate.computeChecksum(buffer);
        long updA = Adler32WithInPlaceUpdate.getA(updatedChecksum);
        long updB = Adler32WithInPlaceUpdate.getB(updatedChecksum);
        long newA = updA + oldA - 1L;
        long newB = l * (oldA - 1L) + oldB + updB;
        newA = (newA % 65521L + 65521L) % 65521L;
        newB = (newB % 65521L + 65521L) % 65521L;
        this.checksum = Adler32WithInPlaceUpdate.concatenate(newA, newB);
        this.length += l;
    }

    @Override
    public void update(ByteBuffer updated, ByteBuffer previous, long position) {
        if (updated.remaining() != previous.remaining()) {
            throw new IllegalArgumentException("Adler32WithInPlaceUpdate Update failed as lengths of two buffers are different updated: " + updated.remaining() + " previous: " + previous.remaining());
        }
        if (position < 0L || position > this.length - (long)updated.remaining()) {
            throw new IndexOutOfBoundsException("Adler32WithInPlaceUpdate Update buffer contains data which exceeds file length position: " + position + " length: " + this.length + " buffer size: " + updated.remaining());
        }
        long newA = Adler32WithInPlaceUpdate.getA(this.checksum);
        long newB = Adler32WithInPlaceUpdate.getB(this.checksum);
        int updSz = updated.remaining();
        for (int iter = 0; iter < updSz; ++iter) {
            long newVal = Byte.toUnsignedLong(updated.get());
            long existingVal = Byte.toUnsignedLong(previous.get());
            long diff = newVal - existingVal;
            newA += diff;
            newB += diff * (this.length - position - (long)iter);
            newA = (newA % 65521L + 65521L) % 65521L;
            newB = (newB % 65521L + 65521L) % 65521L;
        }
        this.checksum = Adler32WithInPlaceUpdate.concatenate(newA, newB);
    }

    public String toString() {
        return "Adler32WithInPlaceUpdate{checksum=" + this.checksum + ", length=" + this.length + '}';
    }
}

