/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.cluster.Observer$;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.common.TopicPlacement;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$Ip$;
import kafka.server.DynamicConfig$User$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode;
import kafka.zk.TopicZNode$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.ClusterLinkExistsException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r}d\u0001\u0002!B\u0001\u0019C\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\u00061\u0002!\t!\u0017\u0005\u00069\u0002!\t!\u0018\u0005\n\u0003o\u0001\u0011\u0013!C\u0001\u0003sA\u0011\"a\u0014\u0001#\u0003%\t!!\u0015\t\u0013\u0005U\u0003!%A\u0005\u0002\u0005]\u0003\"CA.\u0001E\u0005I\u0011AA,\u0011%\ti\u0006AI\u0001\n\u0003\ty\u0006C\u0004\u0002d\u0001!\t!!\u001a\t\u0013\u0005\r\u0005!%A\u0005\u0002\u0005E\u0003\"CAC\u0001E\u0005I\u0011AAD\u0011\u001d\tY\t\u0001C\u0001\u0003\u001bC\u0011\"!.\u0001#\u0003%\t!a\u0016\t\u0013\u0005]\u0006!%A\u0005\u0002\u0005]\u0003\"CA]\u0001E\u0005I\u0011AA,\u0011%\tY\fAI\u0001\n\u0003\ty\u0006C\u0004\u0002>\u0002!\t!a0\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\"9\u0011q\u001a\u0001\u0005\u0002\u0005E\u0007\"CAr\u0001E\u0005I\u0011AA,\u0011%\t)\u000fAI\u0001\n\u0003\t9\u0006C\u0005\u0002h\u0002\t\n\u0011\"\u0001\u0002`!9\u0011\u0011\u001e\u0001\u0005\u0002\u0005-\bbBAx\u0001\u0011\u0005\u0011\u0011\u001f\u0005\n\u0005;\u0001\u0011\u0013!C\u0001\u0005?A\u0011Ba\t\u0001#\u0003%\tA!\n\t\u0013\t%\u0002!%A\u0005\u0002\u0005]\u0003\"\u0003B\u0016\u0001E\u0005I\u0011\u0001B\u0017\u0011%\u0011\t\u0004AI\u0001\n\u0003\ty\u0006C\u0004\u00034\u0001!\tA!\u000e\t\u0013\t\r\u0003!%A\u0005\u0002\t}\u0001b\u0002B#\u0001\u0011\u0005!q\t\u0005\b\u0005+\u0002A\u0011\u0001B,\u0011%\u0011\u0019\u0007AI\u0001\n\u0003\ty\u0006C\u0004\u0003f\u0001!IAa\u001a\t\u000f\te\u0004\u0001\"\u0001\u0003|!9!1\u0011\u0001\u0005\u0002\t\u0015\u0005b\u0002BJ\u0001\u0011\u0005!Q\u0013\u0005\b\u0005;\u0003A\u0011\u0001BP\u0011\u001d\u00119\u000b\u0001C\u0001\u0005SCqA!-\u0001\t\u0003\u0011\u0019\fC\u0004\u0003:\u0002!\tAa/\t\u000f\t\u0005\u0007\u0001\"\u0001\u0003D\"9!\u0011\u001a\u0001\u0005\u0002\t-\u0007b\u0002Be\u0001\u0011\u0005!1\u001b\u0005\b\u00053\u0004A\u0011\u0001Bn\u0011\u001d\u0011y\u000e\u0001C\u0001\u0005CDqA!=\u0001\t\u0003\u0011\u0019\u0010C\u0004\u0003x\u0002!\tA!?\t\u000f\tu\b\u0001\"\u0003\u0003\u0000\"911\u0002\u0001\u0005\u0002\r5\u0001bBB\n\u0001\u0011\u00051Q\u0003\u0005\b\u00073\u0001A\u0011AB\u000e\u0011\u001d\u0019y\u0002\u0001C\u0001\u0007CAq!a@\u0001\t\u0003\u0019I\u0003C\u0004\u0002\u0000\u0002!\taa\r\t\u000f\r]\u0002\u0001\"\u0001\u0004:!91\u0011\n\u0001\u0005\u0002\r-\u0003bBB)\u0001\u0011\u000511\u000b\u0005\b\u0007;\u0002A\u0011AB0\u0011\u001d\u0019\u0019\u0007\u0001C\u0001\u0007KBqa!\u001b\u0001\t\u0003\u0019Y\u0007C\u0004\u0004p\u0001!\ta!\u001d\u0003\u001b\u0005#W.\u001b8[W\u000ec\u0017.\u001a8u\u0015\t\u00115)\u0001\u0002{W*\tA)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u00019U\n\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015J\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u000e\u000bQ!\u001e;jYNL!AU(\u0003\u000f1{wmZ5oO\u0006A!p[\"mS\u0016tG\u000f\u0005\u0002V-6\t\u0011)\u0003\u0002X\u0003\ni1*\u00194lCj[7\t\\5f]R\fa\u0001P5oSRtDC\u0001.\\!\t)\u0006\u0001C\u0003T\u0005\u0001\u0007A+A\u0006de\u0016\fG/\u001a+pa&\u001cG\u0003\u00040b]N,x0a\u0004\u0002\u001a\u0005u\u0001C\u0001%`\u0013\t\u0001\u0017J\u0001\u0003V]&$\b\"\u00022\u0004\u0001\u0004\u0019\u0017!\u0002;pa&\u001c\u0007C\u00013l\u001d\t)\u0017\u000e\u0005\u0002g\u00136\tqM\u0003\u0002i\u000b\u00061AH]8pizJ!A[%\u0002\rA\u0013X\rZ3g\u0013\taWN\u0001\u0004TiJLgn\u001a\u0006\u0003U&CQa\\\u0002A\u0002A\f!\u0002]1si&$\u0018n\u001c8t!\tA\u0015/\u0003\u0002s\u0013\n\u0019\u0011J\u001c;\t\u000bQ\u001c\u0001\u0019\u00019\u0002#I,\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fC\u0004w\u0007A\u0005\t\u0019A<\u0002\u0017Q|\u0007/[2D_:4\u0017n\u001a\t\u0003qvl\u0011!\u001f\u0006\u0003un\fA!\u001e;jY*\tA0\u0001\u0003kCZ\f\u0017B\u0001@z\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\n\u0003\u0003\u0019\u0001\u0013!a\u0001\u0003\u0007\tQB]1dW\u0006;\u0018M]3N_\u0012,\u0007\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%1)A\u0003bI6Lg.\u0003\u0003\u0002\u000e\u0005\u001d!!\u0004*bG.\fu/\u0019:f\u001b>$W\rC\u0005\u0002\u0012\r\u0001\n\u00111\u0001\u0002\u0014\u0005\tRo]3t\u001b>$WM\u001d8U_BL7-\u00133\u0011\u0007!\u000b)\"C\u0002\u0002\u0018%\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002\u001c\r\u0001\n\u00111\u0001\u0002\u0014\u0005\tRo]3t\u0019\u0016<\u0017mY=U_BL7-\u00133\t\u0013\u0005}1\u0001%AA\u0002\u0005\u0005\u0012aC2mkN$XM\u001d'j].\u0004R\u0001SA\u0012\u0003OI1!!\nJ\u0005\u0019y\u0005\u000f^5p]B!\u0011\u0011FA\u001a\u001b\t\tYC\u0003\u0003\u0002.\u0005=\u0012\u0001\u00027j].T1!!\rD\u0003\u0019\u0019XM\u001d<fe&!\u0011QGA\u0016\u0005U\u0019E.^:uKJd\u0015N\\6U_BL7m\u0015;bi\u0016\fQc\u0019:fCR,Gk\u001c9jG\u0012\"WMZ1vYR$C'\u0006\u0002\u0002<)\u001aq/!\u0010,\u0005\u0005}\u0002\u0003BA!\u0003\u0017j!!a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0013J\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001b\n\u0019EA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQc\u0019:fCR,Gk\u001c9jG\u0012\"WMZ1vYR$S'\u0006\u0002\u0002T)\"\u00111AA\u001f\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIY*\"!!\u0017+\t\u0005M\u0011QH\u0001\u0016GJ,\u0017\r^3U_BL7\r\n3fM\u0006,H\u000e\u001e\u00138\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIa*\"!!\u0019+\t\u0005\u0005\u0012QH\u0001\u0013O\u0016$(I]8lKJlU\r^1eCR\f7\u000f\u0006\u0004\u0002h\u0005e\u00141\u0010\t\u0007\u0003S\ny'a\u001d\u000e\u0005\u0005-$bAA7\u0013\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005E\u00141\u000e\u0002\u0004'\u0016\f\b\u0003BA\u0003\u0003kJA!a\u001e\u0002\b\tq!I]8lKJlU\r^1eCR\f\u0007\"CA\u0001\u0013A\u0005\t\u0019AA\u0002\u0011%\ti(\u0003I\u0001\u0002\u0004\ty(\u0001\u0006ce>\\WM\u001d'jgR\u0004R\u0001SA\u0012\u0003\u0003\u0003R!!\u001b\u0002pA\fAdZ3u\u0005J|7.\u001a:NKR\fG-\u0019;bg\u0012\"WMZ1vYR$\u0013'\u0001\u000fhKR\u0014%o\\6fe6+G/\u00193bi\u0006\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005%%\u0006BA@\u0003{\t\u0011d\u0019:fCR,Gk\u001c9jG^KG\u000f[!tg&<g.\\3oiRya,a$\u0002\u0012\u0006U\u00151VAX\u0003c\u000b\u0019\fC\u0003c\u0019\u0001\u00071\r\u0003\u0004\u0002\u00142\u0001\ra^\u0001\u0007G>tg-[4\t\u000f\u0005]E\u00021\u0001\u0002\u001a\u0006Q\u0002/\u0019:uSRLwN\u001c*fa2L7-Y!tg&<g.\\3oiB9\u0011\u0011NANa\u0006}\u0015\u0002BAO\u0003W\u00121!T1q!\u0011\t\t+a*\u000e\u0005\u0005\r&bAAS\u0007\u0006Q1m\u001c8ue>dG.\u001a:\n\t\u0005%\u00161\u0015\u0002\u0012%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\b\"CAW\u0019A\u0005\t\u0019AA\n\u0003!1\u0018\r\\5eCR,\u0007\"CA\t\u0019A\u0005\t\u0019AA\n\u0011%\tY\u0002\u0004I\u0001\u0002\u0004\t\u0019\u0002C\u0005\u0002 1\u0001\n\u00111\u0001\u0002\"\u0005\u00193M]3bi\u0016$v\u000e]5d/&$\b.Q:tS\u001etW.\u001a8uI\u0011,g-Y;mi\u0012\"\u0014aI2sK\u0006$X\rV8qS\u000e<\u0016\u000e\u001e5BgNLwM\\7f]R$C-\u001a4bk2$H%N\u0001$GJ,\u0017\r^3U_BL7mV5uQ\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0003\r\u001a'/Z1uKR{\u0007/[2XSRD\u0017i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uI]\n1\u0002^8qS\u000e,\u00050[:ugR!\u00111CAa\u0011\u0019\t\u0019-\u0005a\u0001G\u0006IAo\u001c9jG:\u000bW.Z\u0001\u0014m\u0006d\u0017\u000eZ1uKR{\u0007/[2De\u0016\fG/\u001a\u000b\b=\u0006%\u00171ZAg\u0011\u0015\u0011'\u00031\u0001d\u0011\u001d\t9J\u0005a\u0001\u00033Ca!a%\u0013\u0001\u00049\u0018!H<sSR,Gk\u001c9jGB\u000b'\u000f^5uS>t\u0017i]:jO:lWM\u001c;\u0015\u001by\u000b\u0019.!6\u0002Z\u0006u\u0017q\\Aq\u0011\u0015\u00117\u00031\u0001d\u0011\u001d\t9n\u0005a\u0001\u00033\u000b\u0011C]3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u\u0011\u001d\tYn\u0005a\u0001\u0003'\t\u0001\"[:Va\u0012\fG/\u001a\u0005\n\u0003#\u0019\u0002\u0013!a\u0001\u0003'A\u0011\"a\u0007\u0014!\u0003\u0005\r!a\u0005\t\u0013\u0005}1\u0003%AA\u0002\u0005\u0005\u0012aJ<sSR,Gk\u001c9jGB\u000b'\u000f^5uS>t\u0017i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uIQ\nqe\u001e:ji\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\f5o]5h]6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%k\u00059sO]5uKR{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0003-!W\r\\3uKR{\u0007/[2\u0015\u0007y\u000bi\u000fC\u0003c/\u0001\u00071-A\u0007bI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0013\u00033\u000b\u00190!>\u0002z\u0006u(\u0011\u0001B\u0003\u0005\u0013\u0011Y\u0002C\u0003c1\u0001\u00071\rC\u0004\u0002xb\u0001\r!!'\u0002%\u0015D\u0018n\u001d;j]\u001e\f5o]5h]6,g\u000e\u001e\u0005\b\u0003wD\u0002\u0019AA4\u0003)\tG\u000e\u001c\"s_.,'o\u001d\u0005\t\u0003\u007fD\u0002\u0013!a\u0001a\u0006ia.^7QCJ$\u0018\u000e^5p]ND\u0011\"a6\u0019!\u0003\u0005\rAa\u0001\u0011\u000b!\u000b\u0019#!'\t\u0013\t\u001d\u0001\u0004%AA\u0002\u0005M\u0011\u0001\u0004<bY&$\u0017\r^3P]2L\b\"\u0003B\u00061A\u0005\t\u0019\u0001B\u0007\u00039!x\u000e]5d!2\f7-Z7f]R\u0004R\u0001SA\u0012\u0005\u001f\u0001BA!\u0005\u0003\u00185\u0011!1\u0003\u0006\u0004\u0005+\u0019\u0015AB2p[6|g.\u0003\u0003\u0003\u001a\tM!A\u0004+pa&\u001c\u0007\u000b\\1dK6,g\u000e\u001e\u0005\n\u0003?A\u0002\u0013!a\u0001\u0003C\tq#\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\u0005\"f\u00019\u0002>\u00059\u0012\r\u001a3QCJ$\u0018\u000e^5p]N$C-\u001a4bk2$H%N\u000b\u0003\u0005OQCAa\u0001\u0002>\u00059\u0012\r\u001a3QCJ$\u0018\u000e^5p]N$C-\u001a4bk2$HEN\u0001\u0018C\u0012$\u0007+\u0019:uSRLwN\\:%I\u00164\u0017-\u001e7uI]*\"Aa\f+\t\t5\u0011QH\u0001\u0018C\u0012$\u0007+\u0019:uSRLwN\\:%I\u00164\u0017-\u001e7uIa\nQd\u0019:fCR,g*Z<QCJ$\u0018\u000e^5p]N\f5o]5h]6,g\u000e\u001e\u000b\u000f\u00033\u00139D!\u000f\u0003<\tu\"q\bB!\u0011\u0015\u0011g\u00041\u0001d\u0011\u001d\t9P\ba\u0001\u00033Cq!a?\u001f\u0001\u0004\t9\u0007\u0003\u0005\u0002\u0000z\u0001\n\u00111\u0001q\u0011\u001d\t9N\ba\u0001\u0005\u0007AqAa\u0003\u001f\u0001\u0004\u0011i!A\u0014de\u0016\fG/\u001a(foB\u000b'\u000f^5uS>t7/Q:tS\u001etW.\u001a8uI\u0011,g-Y;mi\u0012\"\u0014!\u0006<bY&$\u0017\r^3OK^\u0004\u0016M\u001d;ji&|gn\u001d\u000b\t\u0005\u0013\u0012yE!\u0015\u0003TA1\u0001Ja\u0013\u0002\u0002BL1A!\u0014J\u0005\u0019!V\u000f\u001d7fe!)!\r\ta\u0001G\"9\u0011q\u001f\u0011A\u0002\u0005e\u0005BBA\u0000A\u0001\u0007\u0001/\u0001\u0010de\u0016\fG/\u001a)beRLG/[8og^KG\u000f[!tg&<g.\\3oiRQ\u0011\u0011\u0014B-\u00057\u0012iF!\u0019\t\u000b\t\f\u0003\u0019A2\t\u000f\u0005]\u0018\u00051\u0001\u0002\u001a\"9!qL\u0011A\u0002\u0005e\u0015A\u00068foB\u000b'\u000f^5uS>t\u0017i]:jO:lWM\u001c;\t\u0013\u0005}\u0011\u0005%AA\u0002\u0005\u0005\u0012\u0001K2sK\u0006$X\rU1si&$\u0018n\u001c8t/&$\b.Q:tS\u001etW.\u001a8uI\u0011,g-Y;mi\u0012\"\u0014!\u0007<bY&$\u0017\r^3SKBd\u0017nY1BgNLwM\\7f]R$rA\u0018B5\u0005W\u0012y\u0007C\u0004\u0002X\u000e\u0002\r!!'\t\r\t54\u00051\u0001q\u0003e)\u0007\u0010]3di\u0016$'+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\t\u000f\tE4\u00051\u0001\u0003t\u0005\u0011\u0012M^1jY\u0006\u0014G.\u001a\"s_.,'/\u00133t!\u0011!'Q\u000f9\n\u0007\t]TNA\u0002TKR\f1\u0002]1sg\u0016\u0014%o\\6feR!!Q\u0010B@!\u0011A\u00151\u00059\t\r\t\u0005E\u00051\u0001d\u0003\u0019\u0011'o\\6fe\u0006i1\r[1oO\u0016\u001cuN\u001c4jON$rA\u0018BD\u0005\u0017\u0013y\t\u0003\u0004\u0003\n\u0016\u0002\raY\u0001\u000bK:$\u0018\u000e^=UsB,\u0007B\u0002BGK\u0001\u00071-\u0001\u0006f]RLG/\u001f(b[\u0016DaA!%&\u0001\u00049\u0018aB2p]\u001aLwm]\u0001\u0015G\"\fgnZ3DY&,g\u000e^%e\u0007>tg-[4\u0015\u000by\u00139Ja'\t\r\tee\u00051\u0001d\u0003E\u0019\u0018M\\5uSj,Gm\u00117jK:$\u0018\n\u001a\u0005\u0007\u0005#3\u0003\u0019A<\u0002=\rD\u0017M\\4f+N,'o\u0014:Vg\u0016\u00148\t\\5f]RLEmQ8oM&<G#\u00020\u0003\"\n\u0015\u0006B\u0002BRO\u0001\u00071-A\ntC:LG/\u001b>fI\u0016sG/\u001b;z\u001d\u0006lW\r\u0003\u0004\u0003\u0012\u001e\u0002\ra^\u0001\u0011m\u0006d\u0017\u000eZ1uK&\u00038i\u001c8gS\u001e$RA\u0018BV\u0005_CaA!,)\u0001\u0004\u0019\u0017AA5q\u0011\u0019\u0011\t\n\u000ba\u0001o\u0006q1\r[1oO\u0016L\u0005oQ8oM&<G#\u00020\u00036\n]\u0006B\u0002BWS\u0001\u00071\r\u0003\u0004\u0003\u0012&\u0002\ra^\u0001\u0014m\u0006d\u0017\u000eZ1uKR{\u0007/[2D_:4\u0017n\u001a\u000b\u0006=\nu&q\u0018\u0005\u0006E*\u0002\ra\u0019\u0005\u0007\u0005#S\u0003\u0019A<\u0002#\rD\u0017M\\4f)>\u0004\u0018nY\"p]\u001aLw\rF\u0003_\u0005\u000b\u00149\rC\u0003cW\u0001\u00071\r\u0003\u0004\u0003\u0012.\u0002\ra^\u0001\u0013G\"\fgnZ3Ce>\\WM]\"p]\u001aLw\rF\u0003_\u0005\u001b\u0014\t\u000eC\u0004\u0003P2\u0002\r!!!\u0002\u000f\t\u0014xn[3sg\"1!\u0011\u0013\u0017A\u0002]$RA\u0018Bk\u0005/DqA!!.\u0001\u0004\u0011i\b\u0003\u0004\u0003\u00126\u0002\ra^\u0001\u0015m\u0006d\u0017\u000eZ1uK\n\u0013xn[3s\u0007>tg-[4\u0015\u0007y\u0013i\u000e\u0003\u0004\u0003\u0012:\u0002\ra^\u0001\u0018G\"\fgnZ3DYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e$RA\u0018Br\u0005[DqA!:0\u0001\u0004\u00119/\u0001\u0004mS:\\\u0017\n\u001a\t\u0004q\n%\u0018b\u0001Bvs\n!Q+V%E\u0011\u0019\u0011yo\fa\u0001o\u0006y\u0001/\u001a:tSN$XM\u001c;Qe>\u00048/\u0001\fgKR\u001c\u0007n\u00117vgR,'\u000fT5oW\u000e{gNZ5h)\r9(Q\u001f\u0005\b\u0005K\u0004\u0004\u0019\u0001Bt\u0003])gn];sK\u000ecWo\u001d;fe2Kgn[#ySN$8\u000fF\u0002_\u0005wDqA!:2\u0001\u0004\u00119/\u0001\ndQ\u0006tw-Z#oi&$\u0018pQ8oM&<Gc\u00020\u0004\u0002\r\u00151\u0011\u0002\u0005\u0007\u0007\u0007\u0011\u0004\u0019A2\u0002\u001dI|w\u000e^#oi&$\u0018\u0010V=qK\"11q\u0001\u001aA\u0002\r\fqCZ;mYN\u000bg.\u001b;ju\u0016$WI\u001c;jift\u0015-\\3\t\r\tE%\u00071\u0001x\u0003E1W\r^2i\u000b:$\u0018\u000e^=D_:4\u0017n\u001a\u000b\u0006o\u000e=1\u0011\u0003\u0005\u0007\u0007\u0007\u0019\u0004\u0019A2\t\r\t\r6\u00071\u0001d\u0003I9W\r^!mYR{\u0007/[2D_:4\u0017nZ:\u0015\u0005\r]\u0001CBA5\u00037\u001bw/A\u000bgKR\u001c\u0007.\u00117m\u000b:$\u0018\u000e^=D_:4\u0017nZ:\u0015\t\r]1Q\u0004\u0005\u0007\u0005\u0013+\u0004\u0019A2\u00025\u0019,Go\u00195BY2\u001c\u0005.\u001b7e\u000b:$\u0018\u000e^=D_:4\u0017nZ:\u0015\r\r]11EB\u0013\u0011\u0019\u0019\u0019A\u000ea\u0001G\"11q\u0005\u001cA\u0002\r\fqb\u00195jY\u0012,e\u000e^5usRK\b/\u001a\u000b\u0005\u0007W\u0019i\u0003\u0005\u0004\u0002j\u0005m5\r\u001d\u0005\b\u0007_9\u0004\u0019AB\u0019\u0003\u0019!x\u000e]5dgB!AM!\u001ed)\u0011\u0011ih!\u000e\t\u000b\tD\u0004\u0019A2\u0002#\r\u0014X-\u0019;f\u00072,8\u000f^3s\u0019&t7\u000eF\u0003_\u0007w\u0019)\u0005C\u0004\u0004>e\u0002\raa\u0010\u0002\u001f\rdWo\u001d;fe2Kgn\u001b#bi\u0006\u00042!VB!\u0013\r\u0019\u0019%\u0011\u0002\u0010\u00072,8\u000f^3s\u0019&t7\u000eR1uC\"11qI\u001dA\u0002]\f\u0011\u0003]3sg&\u001cH/\u001a8u\u0007>tg-[4t\u000399W\r^\"mkN$XM\u001d'j].$Ba!\u0014\u0004PA)\u0001*a\t\u0004@!9!Q\u001d\u001eA\u0002\t\u001d\u0018aD4fi\u000ecWo\u001d;fe2Kgn[:\u0015\t\rU3q\u000b\t\t\u0003S\nYJa:\u0004@!91\u0011L\u001eA\u0002\rm\u0013a\u00027j].LEm\u001d\t\u0006I\nU$q]\u0001\u0013O\u0016$\u0018\t\u001c7DYV\u001cH/\u001a:MS:\\7\u000f\u0006\u0002\u0004bA1\u0011\u0011NA8\u0007\u007f\tab]3u\u00072,8\u000f^3s\u0019&t7\u000eF\u0002_\u0007OBqa!\u0010>\u0001\u0004\u0019y$A\teK2,G/Z\"mkN$XM\u001d'j].$2AXB7\u0011\u001d\u0011)O\u0010a\u0001\u0005O\f\u0001%\\1zE\u0016\u0014V-\u001a8def\u0004Ho\u00117vgR,'\u000fT5oW\u000e{gNZ5hgR\u0019ala\u001d\t\u000f\rUt\b1\u0001\u0004x\u0005\t2m\u001c8gS\u001e$&/\u00198tM>\u0014X.\u001a:\u0011\r!\u001bIh^B?\u0013\r\u0019Y(\u0013\u0002\n\rVt7\r^5p]F\u0002B\u0001SA\u0012o\u0002")
public class AdminZkClient
implements Logging {
    private final KafkaZkClient zkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void createTopic(String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode, boolean usesModernTopicId, boolean usesLegacyTopicId, Option<ClusterLinkTopicState> clusterLink) {
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(rackAwareMode, this.getBrokerMetadatas$default$2());
        Map replicaAssignment = (Map)AdminUtils$.MODULE$.assignReplicasToBrokers((Iterable<BrokerMetadata>)brokerMetadatas, partitions, replicationFactor, -1, -1).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partition = x0$1._1$mcI$sp();
            Seq replicas = (Seq)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)partition), (Object)ReplicaAssignment$.MODULE$.apply((Seq<Object>)replicas, (Seq<Object>)((Seq)Seq$.MODULE$.empty())));
            return tuple2;
        });
        boolean x$7 = this.createTopicWithAssignment$default$4();
        this.createTopicWithAssignment(topic, topicConfig, (Map<Object, ReplicaAssignment>)replicaAssignment, x$7, usesModernTopicId, usesLegacyTopicId, clusterLink);
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$5() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public boolean createTopic$default$6() {
        return false;
    }

    public boolean createTopic$default$7() {
        return false;
    }

    public Option<ClusterLinkTopicState> createTopic$default$8() {
        return None$.MODULE$;
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        Seq<Broker> allBrokers = this.zkClient.getAllBrokersInCluster();
        Seq brokers = (Seq)brokerList.map((Function1 & Serializable)brokerIds -> (Seq)allBrokers.filter((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).getOrElse((Function0 & Serializable)() -> allBrokers);
        Seq brokersWithRack = (Seq)brokers.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$getBrokerMetadatas$4(x$1)));
        RackAwareMode rackAwareMode2 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (rackAwareMode2 != null && rackAwareMode2.equals(rackAwareMode$Enforced$) && brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
            throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
        }
        Seq seq = RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode) ? (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$)) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode) && brokersWithRack.size() < brokers.size() ? (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$)) : (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), broker.rack())));
        return (Seq)seq.sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$1() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$2() {
        return None$.MODULE$;
    }

    public void createTopicWithAssignment(String topic, Properties config, Map<Object, ReplicaAssignment> partitionReplicaAssignment, boolean validate, boolean usesModernTopicId, boolean usesLegacyTopicId, Option<ClusterLinkTopicState> clusterLink) {
        if (validate) {
            this.validateTopicCreate(topic, partitionReplicaAssignment, config);
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(58).append("Creating topic ").append(topic).append(" with configuration ").append(config).append(" and initial partition ").toString()).append(new StringBuilder(11).append("assignment ").append(partitionReplicaAssignment).toString()).toString());
        this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), topic, config);
        this.writeTopicPartitionAssignment(topic, partitionReplicaAssignment, false, usesModernTopicId, usesLegacyTopicId, clusterLink);
    }

    public boolean createTopicWithAssignment$default$4() {
        return true;
    }

    public boolean createTopicWithAssignment$default$5() {
        return false;
    }

    public boolean createTopicWithAssignment$default$6() {
        return false;
    }

    public Option<ClusterLinkTopicState> createTopicWithAssignment$default$7() {
        return None$.MODULE$;
    }

    public boolean topicExists(String topicName) {
        return this.zkClient.topicExists(topicName);
    }

    public void validateTopicCreate(String topic, Map<Object, ReplicaAssignment> partitionReplicaAssignment, Properties config) {
        Topic.validate((String)topic);
        if (this.zkClient.topicExists(topic)) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        if (Topic.hasCollisionChars((String)topic)) {
            scala.collection.immutable.Set<String> allTopics = this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1());
            if (allTopics.contains((Object)topic)) {
                throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
            }
            scala.collection.immutable.Set collidingTopics = (scala.collection.immutable.Set)allTopics.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateTopicCreate$1(topic, x$3)));
            if (collidingTopics.nonEmpty()) {
                throw new InvalidTopicException(new StringBuilder(40).append("Topic '").append(topic).append("' collides with existing topics: ").append(collidingTopics.mkString(", ")).toString());
            }
        }
        if (((IterableOnceOps)partitionReplicaAssignment.values().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateTopicCreate$2(x$4)))).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        if (((IterableOnceOps)partitionReplicaAssignment.values().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateTopicCreate$3(x$5)))).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of observers");
        }
        partitionReplicaAssignment.values().foreach((Function1 & Serializable)assignment -> {
            AdminZkClient.$anonfun$validateTopicCreate$4(partitionReplicaAssignment, assignment);
            return BoxedUnit.UNIT;
        });
        int partitionSize = partitionReplicaAssignment.size();
        int sequenceSum = partitionSize * (partitionSize - 1) / 2;
        if (partitionReplicaAssignment.size() != partitionReplicaAssignment.toSet().size() || BoxesRunTime.unboxToInt((Object)((IterableOnceOps)partitionReplicaAssignment.keys().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$6 -> x$6 >= 0)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) != sequenceSum) {
            throw new InvalidReplicaAssignmentException("partitions should be a consecutive 0-based integer sequence");
        }
        LogConfig$.MODULE$.validate(config);
    }

    public void writeTopicPartitionAssignment(String topic, Map<Object, ReplicaAssignment> replicaAssignment, boolean isUpdate, boolean usesModernTopicId, boolean usesLegacyTopicId, Option<ClusterLinkTopicState> clusterLink) {
        try {
            scala.collection.immutable.Map assignment = replicaAssignment.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                int partitionId = x0$1._1$mcI$sp();
                ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
                Tuple2 tuple2 = new Tuple2((Object)new TopicPartition(topic, partitionId), (Object)replicas);
                return tuple2;
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (!isUpdate) {
                None$ legacyTopicIdOpt = usesLegacyTopicId ? new Some((Object)Uuid.randomUuid()) : None$.MODULE$;
                None$ topicIdOpt = usesModernTopicId ? new Some((Object)Uuid.randomUuid()) : None$.MODULE$;
                this.zkClient.createTopicAssignment(topic, (Option<Uuid>)topicIdOpt, (Option<Uuid>)legacyTopicIdOpt, (Map<TopicPartition, ReplicaAssignment>)assignment, clusterLink);
            } else {
                TopicZNode.TopicIdReplicaAssignment oldAssignment = (TopicZNode.TopicIdReplicaAssignment)this.zkClient.getReplicaAssignmentAndTopicIdForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).head();
                this.zkClient.setTopicAssignment(topic, oldAssignment.topicId(), oldAssignment.legacyTopicId(), (Map<TopicPartition, ReplicaAssignment>)assignment, clusterLink, this.zkClient.setTopicAssignment$default$6());
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{TopicZNode$.MODULE$.path(topic), assignment})));
            return;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    public boolean writeTopicPartitionAssignment$default$4() {
        return false;
    }

    public boolean writeTopicPartitionAssignment$default$5() {
        return false;
    }

    public Option<ClusterLinkTopicState> writeTopicPartitionAssignment$default$6() {
        return None$.MODULE$;
    }

    public void deleteTopic(String topic) {
        if (this.zkClient.topicExists(topic)) {
            try {
                this.zkClient.createDeleteTopicPath(topic);
                return;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                throw new TopicAlreadyMarkedForDeletionException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("topic %s is already marked for deletion"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            catch (Throwable e) {
                throw new AdminOperationException(e.getMessage());
            }
        }
        throw new UnknownTopicOrPartitionException(new StringBuilder(33).append("Topic `").append(topic).append("` to delete does not exist").toString());
    }

    public Map<Object, ReplicaAssignment> addPartitions(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, ReplicaAssignment>> replicaAssignment, boolean validateOnly, Option<TopicPlacement> topicPlacement, Option<ClusterLinkTopicState> clusterLink) {
        Map<Object, ReplicaAssignment> proposedAssignmentForNewPartitions = this.createNewPartitionsAssignment(topic, existingAssignment, allBrokers, numPartitions, replicaAssignment, topicPlacement);
        if (validateOnly) {
            return (Map)existingAssignment.$plus$plus(proposedAssignmentForNewPartitions);
        }
        return this.createPartitionsWithAssignment(topic, existingAssignment, proposedAssignmentForNewPartitions, clusterLink);
    }

    public int addPartitions$default$4() {
        return 1;
    }

    public Option<Map<Object, ReplicaAssignment>> addPartitions$default$5() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$6() {
        return false;
    }

    public Option<TopicPlacement> addPartitions$default$7() {
        return None$.MODULE$;
    }

    public Option<ClusterLinkTopicState> addPartitions$default$8() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public Map<Object, ReplicaAssignment> createNewPartitionsAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, ReplicaAssignment>> replicaAssignment, Option<TopicPlacement> topicPlacement) {
        void var8_8;
        Tuple2<Seq<Object>, Object> tuple2 = this.validateNewPartitions(topic, existingAssignment, numPartitions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq existingAssignmentPartition0 = (Seq)tuple2._1();
        int n = tuple2._2$mcI$sp();
        replicaAssignment.foreach(arg_0 -> AdminZkClient.$anonfun$createNewPartitionsAssignment$1$adapted(this, (Seq)var8_8, allBrokers, arg_0));
        return (Map)((Map)replicaAssignment.getOrElse(() -> AdminZkClient.$anonfun$createNewPartitionsAssignment$3(allBrokers, (Seq)var8_8, topicPlacement, n, existingAssignment))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int tp = x0$1._1$mcI$sp();
            ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp)), (Object)replicas);
            return tuple2;
        });
    }

    public int createNewPartitionsAssignment$default$4() {
        return 1;
    }

    public Tuple2<Seq<Object>, Object> validateNewPartitions(String topic, Map<Object, ReplicaAssignment> existingAssignment, int numPartitions) {
        Seq<Object> existingAssignmentPartition0 = ((ReplicaAssignment)existingAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable)() -> {
            throw new AdminOperationException(new StringBuilder(0).append(new StringBuilder(80).append("Unexpected existing replica assignment for topic '").append(topic).append("', partition id 0 is missing. ").toString()).append(new StringBuilder(12).append("Assignment: ").append(existingAssignment).toString()).toString());
        })).replicas();
        int partitionsToAdd = numPartitions - existingAssignment.size();
        if (partitionsToAdd <= 0) {
            throw new InvalidPartitionsException(new StringBuilder(0).append("The number of partitions for a topic can only be increased. ").append(new StringBuilder(34).append("Topic ").append(topic).append(" currently has ").append(existingAssignment.size()).append(" partitions, ").toString()).append(new StringBuilder(26).append(numPartitions).append(" would not be an increase.").toString()).toString());
        }
        return new Tuple2(existingAssignmentPartition0, (Object)BoxesRunTime.boxToInteger((int)partitionsToAdd));
    }

    public Map<Object, ReplicaAssignment> createPartitionsWithAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Map<Object, ReplicaAssignment> newPartitionAssignment, Option<ClusterLinkTopicState> clusterLink) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(67).append("Creating ").append(newPartitionAssignment.size()).append(" partitions for '").append(topic).append("' with the following replica assignment: ").toString()).append(new StringBuilder(1).append(newPartitionAssignment).append(".").toString()).toString());
        Map combinedAssignment = (Map)existingAssignment.$plus$plus(newPartitionAssignment);
        boolean x$5 = this.writeTopicPartitionAssignment$default$4();
        boolean x$6 = this.writeTopicPartitionAssignment$default$5();
        this.writeTopicPartitionAssignment(topic, (Map<Object, ReplicaAssignment>)combinedAssignment, true, x$5, x$6, clusterLink);
        return combinedAssignment;
    }

    public Option<ClusterLinkTopicState> createPartitionsWithAssignment$default$4() {
        return None$.MODULE$;
    }

    private void validateReplicaAssignment(Map<Object, ReplicaAssignment> replicaAssignment, int expectedReplicationFactor, scala.collection.immutable.Set<Object> availableBrokerIds) {
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(partitionId, assignment) -> {
            AdminZkClient.$anonfun$validateReplicaAssignment$1(availableBrokerIds, BoxesRunTime.unboxToInt((Object)partitionId), assignment);
            return BoxedUnit.UNIT;
        };
        replicaAssignment.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var8_4 = null;
        Map badRepFactors = (Map)replicaAssignment.collect((PartialFunction)new Serializable(null, expectedReplicationFactor){
            private static final long serialVersionUID = 0L;
            private final int expectedReplicationFactor$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, ReplicaAssignment>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    ReplicaAssignment assignment = (ReplicaAssignment)x1._2();
                    if (assignment.replicas().size() != this.expectedReplicationFactor$1) {
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)BoxesRunTime.boxToInteger((int)assignment.replicas().size()));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, ReplicaAssignment> x1) {
                boolean bl = x1 != null && ((ReplicaAssignment)x1._2()).replicas().size() != this.expectedReplicationFactor$1;
                return bl;
            }
            {
                this.expectedReplicationFactor$1 = expectedReplicationFactor$1;
            }
        });
        if (badRepFactors.nonEmpty()) {
            scala.collection.immutable.Seq sortedBadRepFactors = (scala.collection.immutable.Seq)badRepFactors.toSeq().sortBy((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$2(x0$1)), (Ordering)Ordering.Int$.MODULE$);
            scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)sortedBadRepFactors.map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$3(x0$2)));
            scala.collection.immutable.Seq repFactors = (scala.collection.immutable.Seq)sortedBadRepFactors.map((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$4(x0$3)));
            throw new InvalidReplicaAssignmentException(new StringBuilder(0).append("Inconsistent replication factor between partitions, ").append(new StringBuilder(42).append("partition 0 has ").append(expectedReplicationFactor).append(" while partitions [").append(partitions.mkString(", ")).append("] have ").toString()).append(new StringBuilder(37).append("replication factors [").append(repFactors.mkString(", ")).append("], respectively.").toString()).toString());
        }
    }

    public Option<Object> parseBroker(String broker) {
        None$ none$;
        String string = ConfigEntityName$.MODULE$.Default();
        if (!(string != null ? !string.equals(broker) : broker != null)) {
            none$ = None$.MODULE$;
        } else {
            Some some;
            try {
                some = new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(broker))));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(new StringBuilder(78).append("Error parsing broker ").append(broker).append(". The broker's Entity Name must be a single integer value").toString());
            }
            none$ = some;
        }
        return none$;
    }

    public void changeConfigs(String entityType, String entityName, Properties configs) {
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            this.changeTopicConfig(entityName, configs);
            return;
        }
        String string2 = ConfigType$.MODULE$.Client();
        if (!(string2 != null ? !string2.equals(entityType) : entityType != null)) {
            this.changeClientIdConfig(entityName, configs);
            return;
        }
        String string3 = ConfigType$.MODULE$.User();
        if (!(string3 != null ? !string3.equals(entityType) : entityType != null)) {
            this.changeUserOrUserClientIdConfig(entityName, configs);
            return;
        }
        String string4 = ConfigType$.MODULE$.Broker();
        if (!(string4 != null ? !string4.equals(entityType) : entityType != null)) {
            this.changeBrokerConfig(this.parseBroker(entityName), configs);
            return;
        }
        String string5 = ConfigType$.MODULE$.Ip();
        if (!(string5 != null ? !string5.equals(entityType) : entityType != null)) {
            this.changeIpConfig(entityName, configs);
            return;
        }
        String string6 = ConfigType$.MODULE$.ClusterLink();
        if (!(string6 != null ? !string6.equals(entityType) : entityType != null)) {
            throw new IllegalArgumentException("Cluster link configs can be altered only using Admin API");
        }
        throw new IllegalArgumentException(new StringBuilder(45).append(entityType).append(" is not a known entityType. Should be one of ").append(ConfigType$.MODULE$.all()).toString());
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Client(), sanitizedClientId, configs);
    }

    public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        String string = sanitizedEntityName;
        String string2 = ConfigEntityName$.MODULE$.Default();
        if (!(string == null ? string2 != null : !string.equals(string2)) || sanitizedEntityName.contains("/clients")) {
            DynamicConfig$Client$.MODULE$.validate(configs);
        } else {
            DynamicConfig$User$.MODULE$.validate(configs);
        }
        this.changeEntityConfig(ConfigType$.MODULE$.User(), sanitizedEntityName, configs);
    }

    public void validateIpConfig(String ip, Properties configs) {
        if (!DynamicConfig$Ip$.MODULE$.isValidIpEntity(ip)) {
            throw new AdminOperationException(new StringBuilder(38).append(ip).append(" is not a valid IP or resolvable host.").toString());
        }
        DynamicConfig$Ip$.MODULE$.validate(configs);
    }

    public void changeIpConfig(String ip, Properties configs) {
        this.validateIpConfig(ip, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Ip(), ip, configs);
    }

    public void validateTopicConfig(String topic, Properties configs) {
        Topic.validate((String)topic);
        if (!this.zkClient.topicExists(topic)) {
            throw new UnknownTopicOrPartitionException(new StringBuilder(24).append("Topic '").append(topic).append("' does not exist.").toString());
        }
        LogConfig$.MODULE$.validate(configs);
    }

    public void changeTopicConfig(String topic, Properties configs) {
        this.validateTopicConfig(topic, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Topic(), topic, configs);
    }

    public void changeBrokerConfig(Seq<Object> brokers, Properties configs) {
        this.validateBrokerConfig(configs);
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable)broker -> this.changeEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString(broker), configs));
    }

    public void changeBrokerConfig(Option<Object> broker, Properties configs) {
        this.validateBrokerConfig(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Broker(), (String)broker.map((Function1 & Serializable)x$10 -> AdminZkClient.$anonfun$changeBrokerConfig$2(BoxesRunTime.unboxToInt((Object)x$10))).getOrElse((Function0 & Serializable)() -> ConfigEntityName$.MODULE$.Default()), configs);
    }

    public void validateBrokerConfig(Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
    }

    public void changeClusterLinkConfig(UUID linkId, Properties persistentProps) {
        this.ensureClusterLinkExists(linkId);
        this.changeEntityConfig(ConfigType$.MODULE$.ClusterLink(), linkId.toString(), persistentProps);
    }

    public Properties fetchClusterLinkConfig(UUID linkId) {
        return this.fetchEntityConfig(ConfigType$.MODULE$.ClusterLink(), linkId.toString());
    }

    public void ensureClusterLinkExists(UUID linkId) {
        if (!this.zkClient.clusterLinkExists(linkId)) {
            throw new ClusterLinkNotFoundException(new StringBuilder(39).append("Cluster link with ID '").append(linkId).append("' does not exist.").toString());
        }
    }

    private void changeEntityConfig(String rootEntityType, String fullSanitizedEntityName, Properties configs) {
        String sanitizedEntityPath = new StringBuilder(0).append(rootEntityType).append('/').append(fullSanitizedEntityName).toString();
        this.zkClient.setOrCreateEntityConfigs(rootEntityType, fullSanitizedEntityName, configs);
        this.zkClient.createConfigChangeNotification(sanitizedEntityPath);
    }

    public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
        return this.zkClient.getEntityConfigs(rootEntityType, sanitizedEntityName);
    }

    public Map<String, Properties> getAllTopicConfigs() {
        return ((IterableOnceOps)this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1()).map((Function1 & Serializable)topic -> new Tuple2(topic, (Object)this.fetchEntityConfig(ConfigType$.MODULE$.Topic(), (String)topic)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Properties> fetchAllEntityConfigs(String entityType) {
        return ((IterableOnceOps)this.zkClient.getAllEntitiesWithConfig(entityType).map((Function1 & Serializable)entity -> new Tuple2(entity, (Object)this.fetchEntityConfig(entityType, (String)entity)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(String rootEntityType, String childEntityType) {
        return ((IterableOnceOps)((IterableOps)this.entityPaths$1((Option)None$.MODULE$, rootEntityType).flatMap((Function1 & Serializable)entity -> this.entityPaths$1((Option)new Some((Object)new StringBuilder(0).append((String)entity).append('/').append(childEntityType).toString()), rootEntityType))).map((Function1 & Serializable)entityPath -> new Tuple2(entityPath, (Object)this.fetchEntityConfig(rootEntityType, (String)entityPath)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Object> numPartitions(scala.collection.immutable.Set<String> topics) {
        return (Map)this.zkClient.getPartitionsForTopics(topics).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String topic = (String)x0$1._1();
            Seq partitions = (Seq)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitions.size()));
            return tuple2;
        });
    }

    public Option<Object> numPartitions(String topic) {
        return this.zkClient.getTopicPartitionCount(topic);
    }

    public void createClusterLink(ClusterLinkData clusterLinkData, Properties persistentConfigs) {
        UUID linkId = clusterLinkData.linkId();
        if (this.zkClient.clusterLinkExists(linkId)) {
            throw new ClusterLinkExistsException(new StringBuilder(39).append("Cluster link with ID '").append(linkId).append("' already exists.").toString());
        }
        this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.ClusterLink(), linkId.toString(), persistentConfigs);
        this.zkClient.createClusterLink(clusterLinkData);
        this.zkClient.createConfigChangeNotification(new StringBuilder(0).append(ConfigType$.MODULE$.ClusterLink()).append('/').append(linkId).toString());
    }

    public Option<ClusterLinkData> getClusterLink(UUID linkId) {
        return this.zkClient.getClusterLinks((scala.collection.immutable.Set<UUID>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{linkId})))).get((Object)linkId);
    }

    public Map<UUID, ClusterLinkData> getClusterLinks(scala.collection.immutable.Set<UUID> linkIds) {
        return this.zkClient.getClusterLinks(linkIds);
    }

    public Seq<ClusterLinkData> getAllClusterLinks() {
        return this.zkClient.getClusterLinks((scala.collection.immutable.Set<UUID>)((IterableOnceOps)this.zkClient.getChildren("/cluster_links").map((Function1 & Serializable)x$1 -> UUID.fromString(x$1))).toSet()).values().toSeq();
    }

    public void setClusterLink(ClusterLinkData clusterLinkData) {
        UUID linkId = clusterLinkData.linkId();
        this.ensureClusterLinkExists(linkId);
        this.zkClient.setClusterLink(clusterLinkData);
        this.zkClient.createConfigChangeNotification(new StringBuilder(0).append(ConfigType$.MODULE$.ClusterLink()).append('/').append(linkId).toString());
    }

    public void deleteClusterLink(UUID linkId) {
        this.ensureClusterLinkExists(linkId);
        this.zkClient.deleteClusterLink(linkId);
        this.zkClient.deleteEntityConfig(ConfigType$.MODULE$.ClusterLink(), linkId.toString(), this.zkClient.deleteEntityConfig$default$3());
        this.zkClient.createConfigChangeNotification(new StringBuilder(0).append(ConfigType$.MODULE$.ClusterLink()).append('/').append(linkId).toString());
    }

    public void maybeReencryptClusterLinkConfigs(Function1<Properties, Option<Properties>> configTransformer) {
        this.getAllClusterLinks().foreach((Function1 & Serializable)link -> {
            this.zkClient.transformEntityConfigs(ConfigType$.MODULE$.ClusterLink(), link.linkId().toString(), (Function1<Properties, Option<Properties>>)configTransformer);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadatas$4(Broker x$1) {
        return x$1.rack().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicCreate$1(String topic$2, String x$3) {
        return Topic.hasCollision((String)topic$2, (String)x$3);
    }

    public static final /* synthetic */ int $anonfun$validateTopicCreate$2(ReplicaAssignment x$4) {
        return x$4.replicas().size();
    }

    public static final /* synthetic */ int $anonfun$validateTopicCreate$3(ReplicaAssignment x$5) {
        return x$5.observers().size();
    }

    public static final /* synthetic */ void $anonfun$validateTopicCreate$4(Map partitionReplicaAssignment$2, ReplicaAssignment assignment) {
        if (assignment.replicas().size() != assignment.replicas().toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(36).append("Duplicate replica assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
        if (assignment.observers().size() != assignment.observers().toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(38).append("Duplicate observers assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$createNewPartitionsAssignment$4(Seq existingAssignmentPartition0$1, BrokerMetadata x$9) {
        return x$9.id() >= BoxesRunTime.unboxToInt((Object)existingAssignmentPartition0$1.head());
    }

    public static final /* synthetic */ Map $anonfun$createNewPartitionsAssignment$3(Seq allBrokers$2, Seq existingAssignmentPartition0$1, Option topicPlacement$1, int partitionsToAdd$1, Map existingAssignment$1) {
        int startIndex = package$.MODULE$.max(0, allBrokers$2.indexWhere((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$createNewPartitionsAssignment$4(existingAssignmentPartition0$1, x$9))));
        return Observer$.MODULE$.getReplicaAssignment((Seq<BrokerMetadata>)allBrokers$2, (Option<TopicPlacement>)topicPlacement$1, partitionsToAdd$1, existingAssignmentPartition0$1.size(), startIndex, existingAssignment$1.size());
    }

    public static final /* synthetic */ void $anonfun$validateReplicaAssignment$1(scala.collection.immutable.Set availableBrokerIds$1, int partitionId, ReplicaAssignment assignment) {
        if (assignment.replicas().isEmpty()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(54).append("Cannot have replication factor of 0 for partition id ").append(partitionId).append(".").toString());
        }
        if (assignment.replicas().size() != assignment.replicas().toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(0).append("Duplicate brokers not allowed in replica assignment: ").append(new StringBuilder(19).append(assignment.replicas().mkString(", ")).append(" for partition id ").append(partitionId).append(".").toString()).toString());
        }
        if (!assignment.replicas().toSet().subsetOf((Set)availableBrokerIds$1)) {
            throw new BrokerNotAvailableException(new StringBuilder(0).append(new StringBuilder(60).append("Some brokers specified for partition id ").append(partitionId).append(" are not available. ").toString()).append(new StringBuilder(21).append("Specified brokers: ").append(assignment.replicas().mkString(", ")).append(", ").toString()).append(new StringBuilder(20).append("available brokers: ").append(availableBrokerIds$1.mkString(", ")).append(".").toString()).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$2(Tuple2 x0$1) {
        void var1_1;
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        int partitionId = x0$1._1$mcI$sp();
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$3(Tuple2 x0$2) {
        void var1_1;
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        int partitionId = x0$2._1$mcI$sp();
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$4(Tuple2 x0$3) {
        void var1_1;
        if (x0$3 == null) {
            throw new MatchError(null);
        }
        int rf = x0$3._2$mcI$sp();
        return (int)var1_1;
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2(int x$10) {
        return Integer.toString(x$10);
    }

    private final Seq entityPaths$1(Option rootPath, String rootEntityType$1) {
        Seq seq;
        String string;
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            string = new StringBuilder(0).append(rootEntityType$1).append('/').append(path).toString();
        } else if (None$.MODULE$.equals(rootPath)) {
            string = rootEntityType$1;
        } else {
            throw new MatchError((Object)rootPath);
        }
        Seq entityNames = this.zkClient.getAllEntitiesWithConfig(string);
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            seq = (Seq)entityNames.map((Function1 & Serializable)entityName -> new StringBuilder(0).append(path).append('/').append((String)entityName).toString());
        } else if (None$.MODULE$.equals(rootPath)) {
            seq = entityNames;
        } else {
            throw new MatchError((Object)rootPath);
        }
        return seq;
    }

    public AdminZkClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
    }

    public static final /* synthetic */ Object $anonfun$createNewPartitionsAssignment$1$adapted(AdminZkClient $this, Seq existingAssignmentPartition0$1, Seq allBrokers$2, Map proposedReplicaAssignment) {
        $this.validateReplicaAssignment((Map<Object, ReplicaAssignment>)proposedReplicaAssignment, existingAssignmentPartition0$1.size(), (scala.collection.immutable.Set<Object>)((IterableOnceOps)allBrokers$2.map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.id()))).toSet());
        return BoxedUnit.UNIT;
    }
}

