/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterBrokerReplicaExclusionsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.clients.admin.ExclusionOpResult;
import org.apache.kafka.clients.admin.ExclusionOperationError;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidBrokerReplicaExclusionException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnrepresentableBrokerIdException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.test.ValuelessCallable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.scalactic.source.Position;
import org.scalatest.Matchers$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.collection.mutable.Buffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t]g\u0001B\u000e\u001d\u0001\rBQA\u000b\u0001\u0005\u0002-BQA\f\u0001\u0005R=BqA\u000e\u0001A\u0002\u0013\u0005q\u0007C\u0004F\u0001\u0001\u0007I\u0011\u0001$\t\r1\u0003\u0001\u0015)\u00039\u0011\u0015i\u0005\u0001\"\u0011O\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017Aq!!\u0006\u0001\t\u0003\t9\u0002C\u0004\u0002\"\u0001!\t!a\t\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBA#\u0001\u0011\u0005\u0011q\t\u0005\b\u0003c\u0003A\u0011BAZ\u0011\u001d\ty\u000f\u0001C\u0005\u0003cDqAa\u0004\u0001\t\u0003\u0011\t\u0002C\u0004\u00038\u0001!\tA!\u000f\t\u000f\t]\u0002\u0001\"\u0001\u0003H!9!q\u0002\u0001\u0005\u0002\t=\u0003b\u0002B/\u0001\u0011\u0005!q\f\u0005\b\u0005O\u0002A\u0011\u0001B5\u0011\u001d\u00119\u0007\u0001C\u0001\u0005kBqA!\"\u0001\t\u0013\u00119\tC\u0004\u0003(\u0002!\tA!+\t\u000f\tm\u0006\u0001\"\u0003\u0003>\"9!\u0011\u0019\u0001\u0005\n\t\r'a\b*fa2L7-Y#yG2,8/[8o\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011QDH\u0001\u0004CBL'BA\u0010!\u0003\u0015Y\u0017MZ6b\u0015\u0005\t\u0013aC5oi\u0016<'/\u0019;j_:\u001c\u0001a\u0005\u0002\u0001IA\u0011Q\u0005K\u0007\u0002M)\u0011Qd\n\u0006\u0002?%\u0011\u0011F\n\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012\u0001\f\t\u0003[\u0001i\u0011\u0001H\u0001\fEJ|7.\u001a:D_VtG/F\u00011!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\rIe\u000e^\u0001\fC\u0012l\u0017N\\\"mS\u0016tG/F\u00019!\tI4)D\u0001;\u0015\tYD(A\u0003bI6LgN\u0003\u0002>}\u000591\r\\5f]R\u001c(BA\u0010@\u0015\t\u0001\u0015)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011S$AD\"p]\u001adW/\u001a8u\u0003\u0012l\u0017N\\\u0001\u0010C\u0012l\u0017N\\\"mS\u0016tGo\u0018\u0013fcR\u0011qI\u0013\t\u0003c!K!!\u0013\u001a\u0003\tUs\u0017\u000e\u001e\u0005\b\u0017\u0012\t\t\u00111\u00019\u0003\rAH%M\u0001\rC\u0012l\u0017N\\\"mS\u0016tG\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u000f>CQ\u0001\u0015\u0004A\u0002E\u000b\u0001\u0002^3ti&sgm\u001c\t\u0003%bk\u0011a\u0015\u0006\u0003;QS!!\u0016,\u0002\u000f),\b/\u001b;fe*\u0011q+Q\u0001\u0006UVt\u0017\u000e^\u0005\u00033N\u0013\u0001\u0002V3ti&sgm\u001c\u0015\u0003\rm\u0003\"A\u0015/\n\u0005u\u001b&A\u0003\"fM>\u0014X-R1dQ\u0006\u0011C/Z:u\u000bb\u001cG.^:j_:\u001c%/Z1uKR{\u0007/[2WC2LG-\u0019;j_:$\"a\u00121\t\u000b\u0005<\u0001\u0019\u00012\u0002\rE,xN];n!\t\u0019'N\u0004\u0002eQB\u0011QMM\u0007\u0002M*\u0011qMI\u0001\u0007yI|w\u000e\u001e \n\u0005%\u0014\u0014A\u0002)sK\u0012,g-\u0003\u0002lY\n11\u000b\u001e:j]\u001eT!!\u001b\u001a)\t\u001dqgo\u001e\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\f\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003gR\u000ba\u0001]1sC6\u001c\u0018BA;q\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012\u0001P_\u0011\u0002s\u0006\u0011!p[\u0011\u0002w\u0006)1N]1gi\"2q!`A\u0002\u0003\u000b\u0001\"A`@\u000e\u0003IL1!!\u0001s\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-\t\u0002\u0002\b\u0005A2\u0010Z5ta2\f\u0017PT1nKvt\u0013/^8sk6l4\u0010M?\u0002OQ,7\u000f^#yG2,8/[8o\u0007J,\u0017\r^3QCJ$\u0018\u000e^5p]N4\u0016\r\\5eCRLwN\u001c\u000b\u0004\u000f\u00065\u0001\"B1\t\u0001\u0004\u0011\u0007&\u0002\u0005om\u0006EAF\u0001={Q\u0019AQ0a\u0001\u0002\u0006\u0005IB/Z:u\u000bb\u001cG.^:j_:\u0014V-Y:tS\u001etW.\u001a8u)\r9\u0015\u0011\u0004\u0005\u0006C&\u0001\rA\u0019\u0015\u0006\u001394\u0018Q\u0004\u0017\u0003qjDc!C?\u0002\u0004\u0005\u0015\u0011!\u0007;fgR,\u0005p\u00197vg&|g.\u00119j'\u0016l\u0017M\u001c;jGN$2aRA\u0013\u0011\u0015\t'\u00021\u0001cQ\u0015QaN^A\u0015Y\tA(\u0010\u000b\u0004\u000b{\u0006\r\u0011QA\u0001$i\u0016\u001cH/\u0012=dYV\u001c\u0018n\u001c8Bi>l\u0017nY5us\u0006sG-\u0012:s_J\u001c\u0015m]3t)\r9\u0015\u0011\u0007\u0005\u0006C.\u0001\rA\u0019\u0015\u0006\u001794\u0018Q\u0007\u0017\u0003qjDcaC?\u0002\u0004\u0005\u0015\u0011!\u0006;fgR,\u0005p\u00197vg&|gNR1jY>4XM\u001d\u000b\u0004\u000f\u0006u\u0002\"B1\r\u0001\u0004\u0011\u0007&\u0002\u0007om\u0006\u0005C&\u0001>)\r1i\u00181AA\u0003\u0003]\t7o]3si\u0006#W.\u001b8DY&,g\u000e\u001e+ie><8/\u0006\u0003\u0002J\u0005mD\u0003BA&\u0003C#b!!\u0014\u0002h\u00055\u0005\u0003BA(\u0003CrA!!\u0015\u0002\\9!\u00111KA,\u001d\r)\u0017QK\u0005\u0002\u0005&\u0019\u0011\u0011L!\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018\u0002BA/\u0003?\nq\u0001]1dW\u0006<WMC\u0002\u0002Z\u0005KA!a\u0019\u0002f\tI\u0011i]:feRLwN\u001c\u0006\u0005\u0003;\ny\u0006C\u0004\u0002j5\u0001\u001d!a\u001b\u0002\u0011\rd\u0017m]:UC\u001e\u0004b!!\u001c\u0002t\u0005]TBAA8\u0015\r\t\tHM\u0001\be\u00164G.Z2u\u0013\u0011\t)(a\u001c\u0003\u0011\rc\u0017m]:UC\u001e\u0004B!!\u001f\u0002|1\u0001AaBA?\u001b\t\u0007\u0011q\u0010\u0002\u0002)F!\u0011\u0011QAD!\r\t\u00141Q\u0005\u0004\u0003\u000b\u0013$a\u0002(pi\"Lgn\u001a\t\u0004c\u0005%\u0015bAAFe\t1\u0011I\\=SK\u001aDq!a$\u000e\u0001\b\t\t*A\u0002q_N\u0004B!a%\u0002\u001e6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000bI*\u0001\u0004t_V\u00148-\u001a\u0006\u0004\u00037\u000b\u0015!C:dC2\f7\r^5d\u0013\u0011\ty*!&\u0003\u0011A{7/\u001b;j_:D\u0001\"a)\u000e\t\u0003\u0007\u0011QU\u0001\u0002MB)\u0011'a*\u0002,&\u0019\u0011\u0011\u0016\u001a\u0003\u0011q\u0012\u0017P\\1nKz\u00022!MAW\u0013\r\tyK\r\u0002\u0004\u0003:L\u0018a\u0006<fe&4\u00170\u0012=qK\u000e$X\rZ#yG\u0016\u0004H/[8o)\u001d9\u0015QWAl\u00037Dq!a.\u000f\u0001\u0004\tI,A\bfq\u000edWo]5p]J+7/\u001e7u!\u0011\tY,!5\u000f\t\u0005u\u0016Q\u001a\b\u0005\u0003\u007f\u000bYM\u0004\u0003\u0002B\u0006%g\u0002BAb\u0003\u000ftA!a\u0015\u0002F&\u0011\u0001)Q\u0005\u0003?}J!!\u0010 \n\u0005mb\u0014bAAhu\u0005\u0011\u0013\t\u001c;fe\n\u0013xn[3s%\u0016\u0004H.[2b\u000bb\u001cG.^:j_:\u001c(+Z:vYRLA!a5\u0002V\n\u0001R\t_2mkNLwN\\:SKN,H\u000e\u001e\u0006\u0004\u0003\u001fT\u0004BBAm\u001d\u0001\u0007\u0001'\u0001\u0005ce>\\WM]%e\u0011\u001d\tiN\u0004a\u0001\u0003?\fQ!\u001a:s_J\u0004B!!9\u0002l6\u0011\u00111\u001d\u0006\u0005\u0003K\f9/\u0001\u0005qe>$xnY8m\u0015\r\tIOP\u0001\u0007G>lWn\u001c8\n\t\u00055\u00181\u001d\u0002\u0007\u000bJ\u0014xN]:\u00027\u0005\u001c8/\u001a:u'V\u001c7-Z:tMVd\u0017\t\u001c;feJ+7/\u001e7u)\u00159\u00151_A~\u0011\u001d\t)p\u0004a\u0001\u0003o\faA]3tk2$\b\u0003BA}\u0003#t1!OAg\u0011\u001d\tip\u0004a\u0001\u0003\u007f\fqA]3bg>t7\u000fE\u0003\u0003\u0002\t%!M\u0004\u0003\u0003\u0004\t\u001dabA3\u0003\u0006%\t1'C\u0002\u0002^IJAAa\u0003\u0003\u000e\t!A*[:u\u0015\r\tiFM\u0001\fGJ,\u0017\r^3U_BL7\rF\u0004H\u0005'\u0011YBa\b\t\rY\u0002\u0002\u0019\u0001B\u000b!\rI$qC\u0005\u0004\u00053Q$!B!e[&t\u0007B\u0002B\u000f!\u0001\u0007!-A\u0005u_BL7MT1nK\"9!\u0011\u0005\tA\u0002\t\r\u0012a\u0004;pa&\u001c\u0017i]:jO:lWM\u001c;\u0011\u000f\t\u0015\"q\u0006\u0019\u000345\u0011!q\u0005\u0006\u0005\u0005S\u0011Y#A\u0005j[6,H/\u00192mK*\u0019!Q\u0006\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00032\t\u001d\"aA'baB)!Q\u0005B\u001ba%!!1\u0002B\u0014\u0003A\u0019'/Z1uKB\u000b'\u000f^5uS>t7\u000fF\u0005H\u0005w\u0011iDa\u0010\u0003D!1a'\u0005a\u0001\u0005+AaA!\b\u0012\u0001\u0004\u0011\u0007B\u0002B!#\u0001\u0007\u0001'A\foK^$v\u000e^1m\u0007>,h\u000e\u001e)beRLG/[8og\"9!QI\tA\u0002\t\r\u0012a\u00059beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$HcB$\u0003J\t-#Q\n\u0005\u0007mI\u0001\rA!\u0006\t\r\tu!\u00031\u0001c\u0011\u0019\u0011\tE\u0005a\u0001aQIqI!\u0015\u0003T\tU#\u0011\f\u0005\u0007mM\u0001\rA!\u0006\t\r\tu1\u00031\u0001c\u0011\u0019\u00119f\u0005a\u0001a\u0005ia.^7QCJ$\u0018\u000e^5p]NDaAa\u0017\u0014\u0001\u0004\u0001\u0014!\u0005:fa2L7-\u0019;j_:4\u0015m\u0019;pe\u00069b/\u00197jI\u0006$X\rV8qS\u000e\f5o]5h]6,g\u000e\u001e\u000b\u0006\u000f\n\u0005$1\r\u0005\u0007\u0005;!\u0002\u0019\u00012\t\u000f\t\u0015D\u00031\u0001\u0003$\u0005\u0019R\r\u001f9fGR,G-Q:tS\u001etW.\u001a8ug\u0006Yb/\u00197jI\u0006$X\rU1si&$\u0018n\u001c8BgNLwM\\7f]R$ra\u0012B6\u0005[\u0012\t\b\u0003\u0004\u0003\u001eU\u0001\rA\u0019\u0005\u0007\u0005_*\u0002\u0019\u0001\u0019\u0002\u0013A\f'\u000f^5uS>t\u0007b\u0002B:+\u0001\u0007!1G\u0001\u0013Kb\u0004Xm\u0019;fI\u0006\u001b8/[4o[\u0016tG\u000fF\u0004H\u0005o\u0012\tIa!\t\u000f\ted\u00031\u0001\u0003|\u0005\u0001Bo\u001c9jG\u0012+7o\u0019:jaRLwN\u001c\t\u0004s\tu\u0014b\u0001B@u\t\u0001Bk\u001c9jG\u0012+7o\u0019:jaRLwN\u001c\u0005\u0007\u0005_2\u0002\u0019\u0001\u0019\t\u000f\tMd\u00031\u0001\u00034\u0005iq/Y5u\r>\u0014\u0018i]:feR$ra\u0012BE\u00053\u0013\u0019\u000bC\u0004\u0003\f^\u0001\rA!$\u0002\u001bQ,7\u000f^\"p]\u0012LG/[8o!\u0011\u0011yI!&\u000e\u0005\tE%b\u0001BJ}\u0005!A/Z:u\u0013\u0011\u00119J!%\u0003\u001bQ+7\u000f^\"p]\u0012LG/[8o\u0011\u001d\u0011Yj\u0006a\u0001\u0005;\u000b\u0011\"\\1y/\u0006LG/T:\u0011\u0007E\u0012y*C\u0002\u0003\"J\u0012A\u0001T8oO\"1!QU\fA\u0002\t\f\u0001cY8oI&$\u0018n\u001c8EKR\f\u0017\u000e\\:\u0002KY\fG.\u001b3bi\u0016$v\u000e]5d\t>,7O\u001c;Ta\u0006tW\t_2mk\u0012,GM\u0011:pW\u0016\u0014HcB$\u0003,\n5&q\u0017\u0005\u0007\u0005;A\u0002\u0019\u00012\t\u000f\t=\u0006\u00041\u0001\u00032\u0006\tR\r_2mk\u0012,GM\u0011:pW\u0016\u0014\u0018\nZ:\u0011\t\r\u0014\u0019\fM\u0005\u0004\u0005kc'aA*fi\"1!\u0011\u0018\rA\u0002A\nQ#\u001a=qK\u000e$X\r\u001a(v[B\u000b'\u000f^5uS>t7/A\u0007eKN\u001c'/\u001b2f)>\u0004\u0018n\u0019\u000b\u0005\u0005w\u0012y\f\u0003\u0004\u0003\u001ee\u0001\rAY\u0001\te\u0016\f7o]5h]R)qI!2\u0003R\"9!q\u0019\u000eA\u0002\t%\u0017A\u0001;q!\u0011\u0011YM!4\u000e\u0005\u0005\u001d\u0018\u0002\u0002Bh\u0003O\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0003Tj\u0001\rA!6\u0002\u001dQ\f'oZ3u%\u0016\u0004H.[2bgB)!\u0011\u0001B\u0005a\u0001")
public class ReplicaExclusionIntegrationTest
extends IntegrationTestHarness {
    private ConfluentAdmin adminClient = null;

    @Override
    public int brokerCount() {
        return 3;
    }

    public ConfluentAdmin adminClient() {
        return this.adminClient;
    }

    public void adminClient_$eq(ConfluentAdmin x$1) {
        this.adminClient = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.adminClient_$eq(this.createConfluentAdminClient(this.createConfluentAdminClient$default$1()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testExclusionCreateTopicValidation(String quorum) {
        String topicName = "topic";
        int p0 = 0;
        int p1 = 1;
        int p2 = 2;
        int excludedBrokerId = 0;
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)excludedBrokerId)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result, (List<String>)new .colon.colon((Object)"maintenance", (List)Nil$.MODULE$));
        scala.collection.immutable.Map invalidAssignment = (scala.collection.immutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{excludedBrokerId, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, excludedBrokerId}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p2)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, excludedBrokerId, 1})))}));
        this.assertAdminClientThrows((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.createTopic((Admin)this.adminClient(), topicName, (scala.collection.immutable.Map<Object, List<Object>>)invalidAssignment), ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        scala.collection.immutable.Map validAssignment = (scala.collection.immutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p2)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1})))}));
        this.createTopic((Admin)this.adminClient(), topicName, (scala.collection.immutable.Map<Object, List<Object>>)validAssignment);
        this.validateTopicAssignment(topicName, (scala.collection.immutable.Map<Object, List<Object>>)validAssignment);
        String secondTopic = new StringBuilder(2).append(topicName).append("-2").toString();
        this.createTopic((Admin)this.adminClient(), secondTopic, 5, 2);
        this.validateTopicDoesntSpanExcludedBroker(secondTopic, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{excludedBrokerId}))), 5);
        String thirdTopic = new StringBuilder(2).append(topicName).append("-3").toString();
        this.assertAdminClientThrows((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.createTopic((Admin)this.adminClient(), thirdTopic, 5, this.brokerCount()), ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        AlterBrokerReplicaExclusionsResult.ExclusionsResult deleteResult = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)excludedBrokerId)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(deleteResult, (List<String>)new .colon.colon((Object)"", (List)Nil$.MODULE$));
        this.createTopic((Admin)this.adminClient(), thirdTopic, 5, this.brokerCount());
        this.createTopic((Admin)this.adminClient(), "fourthTopic", (scala.collection.immutable.Map<Object, List<Object>>)invalidAssignment);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testExclusionCreatePartitionsValidation(String quorum) {
        String rf3Topic = "rf-3-topic";
        String rf2Topic = "rf-2-topic";
        int newP3 = 3;
        int newP4 = 4;
        int newPartitionCount = 5;
        int excludedBrokerId = 0;
        this.createTopic((Admin)this.adminClient(), rf3Topic, 3, 3);
        this.createTopic((Admin)this.adminClient(), rf2Topic, 3, 2);
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)excludedBrokerId)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result, (List<String>)new .colon.colon((Object)"maintenance", (List)Nil$.MODULE$));
        scala.collection.immutable.Map invalidAssignment = (scala.collection.immutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)newP3)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{excludedBrokerId, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)newP4)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        this.assertAdminClientThrows((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.createPartitions((Admin)this.adminClient(), rf2Topic, newPartitionCount, (scala.collection.immutable.Map<Object, List<Object>>)invalidAssignment), ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.createTopic((Admin)this.adminClient(), "rf-2-topic-2", 3, 2);
        this.validateTopicDoesntSpanExcludedBroker("rf-2-topic-2", (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{excludedBrokerId}))), 3);
        this.createPartitions((Admin)this.adminClient(), "rf-2-topic-2", 20);
        this.validateTopicDoesntSpanExcludedBroker("rf-2-topic-2", (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{excludedBrokerId}))), 20);
        this.assertAdminClientThrows((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.createPartitions((Admin)this.adminClient(), rf3Topic, newPartitionCount), ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        AlterBrokerReplicaExclusionsResult.ExclusionsResult deleteResult = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)excludedBrokerId)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(deleteResult, (List<String>)new .colon.colon((Object)"", (List)Nil$.MODULE$));
        this.createPartitions((Admin)this.adminClient(), rf3Topic, newPartitionCount);
        this.createPartitions((Admin)this.adminClient(), rf2Topic, newPartitionCount, (scala.collection.immutable.Map<Object, List<Object>>)invalidAssignment);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testExclusionReassignment(String quorum) {
        String topic = "reassignment-topic";
        int excludedBrokerId = 0;
        TopicPartition tp = new TopicPartition(topic, 0);
        this.createTopic((Admin)this.adminClient(), topic, (scala.collection.immutable.Map<Object, List<Object>>)((scala.collection.immutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{excludedBrokerId, 1})))}))));
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)excludedBrokerId)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result, (List<String>)new .colon.colon((Object)"maintenance", (List)Nil$.MODULE$));
        ObjectRef newAssignment = ObjectRef.create((Object)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, excludedBrokerId}))));
        this.reassign(tp, (List<Object>)((List)newAssignment.elem));
        this.waitForAssert(() -> {
            this.validatePartitionAssignment(tp.topic(), tp.partition(), (List<Object>)((List)newAssignment$1.elem));
            return true;
        }, 10000L, new StringBuilder(31).append("Partition ").append(tp).append(" was not assigned to ").append((List)newAssignment.elem).toString());
        newAssignment.elem = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
        this.reassign(tp, (List<Object>)((List)newAssignment.elem));
        this.waitForAssert(() -> {
            this.validatePartitionAssignment(tp.topic(), tp.partition(), (List<Object>)((List)newAssignment$1.elem));
            return true;
        }, 10000L, new StringBuilder(31).append("Partition ").append(tp).append(" was not assigned to ").append((List)newAssignment.elem).toString());
        List invalidAssignment = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, excludedBrokerId}));
        this.assertAdminClientThrows((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.reassign(tp, (List<Object>)invalidAssignment), ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        AlterBrokerReplicaExclusionsResult.ExclusionsResult deletionResult = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)excludedBrokerId)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(deletionResult, (List<String>)new .colon.colon((Object)"", (List)Nil$.MODULE$));
        this.reassign(tp, (List<Object>)invalidAssignment);
        this.waitForAssert(() -> {
            this.validatePartitionAssignment(tp.topic(), tp.partition(), (List<Object>)invalidAssignment);
            return true;
        }, 10000L, new StringBuilder(31).append("Partition ").append(tp).append(" was not assigned to ").append(invalidAssignment).toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testExclusionApiSemantics(String quorum) {
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4101)), (Object)new ExclusionOp(ExclusionOp.OpType.SET)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result, (List<String>)new .colon.colon((Object)"", (List)new .colon.colon((Object)"maintenance", (List)Nil$.MODULE$)));
        java.util.List describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertEquals((int)2, (int)describedExclusions.size());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4101})), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(describedExclusions).asScala().map((Function1 & Serializable)a -> BoxesRunTime.boxToInteger((int)a.brokerId()))).sorted((Ordering)Ordering.Int$.MODULE$));
        Assertions.assertEquals((Object)new .colon.colon((Object)"", (List)new .colon.colon((Object)"maintenance", (List)Nil$.MODULE$)), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(describedExclusions).asScala().map((Function1 & Serializable)a -> a.reason())).sorted((Ordering)Ordering.String$.MODULE$));
        result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4101)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance-2")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance-3"))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result, (List<String>)new .colon.colon((Object)"", (List)new .colon.colon((Object)"maintenance-2", (List)new .colon.colon((Object)"maintenance-3", (List)Nil$.MODULE$))));
        describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertEquals((int)2, (int)describedExclusions.size());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(describedExclusions).asScala().map((Function1 & Serializable)a -> BoxesRunTime.boxToInteger((int)a.brokerId()))).sorted((Ordering)Ordering.Int$.MODULE$));
        Assertions.assertEquals((Object)new .colon.colon((Object)"maintenance-2", (List)new .colon.colon((Object)"maintenance-3", (List)Nil$.MODULE$)), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(describedExclusions).asScala().map((Function1 & Serializable)a -> a.reason())).sorted((Ordering)Ordering.String$.MODULE$));
        result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance-2")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance-3")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result, (List<String>)new .colon.colon((Object)"", (List)new .colon.colon((Object)"maintenance-2", (List)new .colon.colon((Object)"maintenance-3", (List)Nil$.MODULE$))));
        result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result, (List<String>)new .colon.colon((Object)"", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)));
        describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertEquals((int)2, (int)describedExclusions.size());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(describedExclusions).asScala().map((Function1 & Serializable)a -> BoxesRunTime.boxToInteger((int)a.brokerId()))).sorted((Ordering)Ordering.Int$.MODULE$));
        Assertions.assertEquals((Object)new .colon.colon((Object)"maintenance-2", (List)new .colon.colon((Object)"maintenance-3", (List)Nil$.MODULE$)), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(describedExclusions).asScala().map((Function1 & Serializable)a -> a.reason())).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testExclusionAtomicityAndErrorCases(String quorum) {
        this.assertAdminClientThrows((Function0<Object>)(Function0 & Serializable)() -> (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-10)), (Object)new ExclusionOp(ExclusionOp.OpType.SET)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get(), ClassTag$.MODULE$.apply(UnrepresentableBrokerIdException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        java.util.List describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertTrue((boolean)describedExclusions.isEmpty(), (String)new StringBuilder(65).append("Expected no broker replica exclusions to be present, instead got ").append(describedExclusions).toString());
        this.assertAdminClientThrows((Function0<Object>)(Function0 & Serializable)() -> (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new ExclusionOp(ExclusionOp.OpType.SET)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance=maintenance=][]asmaintenancemaintenancemaintenance"))}))).asJava()).result().get(), ClassTag$.MODULE$.apply(InvalidBrokerReplicaExclusionException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertTrue((boolean)describedExclusions.isEmpty(), (String)new StringBuilder(65).append("Expected no broker replica exclusions to be present, instead got ").append(describedExclusions).toString());
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected replica exclusion alteration with an exception to not be applied");
        Assertions.assertEquals((int)2, (int)result.exclusionResultByBroker().size());
        Assertions.assertTrue((boolean)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(((ExclusionOpResult)result.exclusionResultByBroker().get(BoxesRunTime.boxToInteger((int)2))).errorOpt())).isEmpty(), (String)"Expected broker 2 to not have an exception with its exclusion");
        this.verifyExpectedException(result, 1, Errors.BROKER_REPLICA_PLACEMENT_EXCLUSION_NOT_FOUND);
        describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertTrue((boolean)describedExclusions.isEmpty(), (String)new StringBuilder(65).append("Expected no broker replica exclusions to be present, instead got ").append(describedExclusions).toString());
        result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        Assertions.assertTrue((boolean)result.isSuccessful(), (String)"Expected replica exclusion to be applied");
        result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE))}))).asJava()).result().get();
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected replica exclusion alteration with an exception to not be applied");
        Assertions.assertEquals((int)3, (int)result.exclusionResultByBroker().size());
        Assertions.assertTrue((boolean)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(((ExclusionOpResult)result.exclusionResultByBroker().get(BoxesRunTime.boxToInteger((int)2))).errorOpt())).isEmpty(), (String)"Expected broker 2 to not have an exception with its exclusion");
        this.verifyExpectedException(result, 10, Errors.BROKER_REPLICA_PLACEMENT_EXCLUSION_NOT_FOUND);
        this.verifyExpectedException(result, 11, Errors.BROKER_REPLICA_PLACEMENT_EXCLUSION_NOT_FOUND);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testExclusionFailover(String quorum) {
        int b2;
        IntRef b1 = IntRef.create((int)-1);
        if (this.isKRaftTest()) {
            b1.elem = ((KafkaBroker)this.brokers().head()).config().brokerId();
            b2 = ((KafkaBroker)((IterableOps)this.brokers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ReplicaExclusionIntegrationTest.$anonfun$testExclusionFailover$1(b1, s)))).head()).config().brokerId();
        } else {
            b1.elem = ((KafkaServer)this.servers().head()).config().brokerId();
            b2 = ((KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ReplicaExclusionIntegrationTest.$anonfun$testExclusionFailover$2(b1, s)))).head()).config().brokerId();
        }
        List excludedBrokers = (List)((StrictOptimizedSeqOps)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{b1.elem, b2}))).sorted((Ordering)Ordering.Int$.MODULE$);
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)b1.elem)), (Object)new ExclusionOp(ExclusionOp.OpType.SET)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)b2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result, (List<String>)new .colon.colon((Object)"", (List)new .colon.colon((Object)"maintenance", (List)Nil$.MODULE$)));
        java.util.List describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertEquals((int)2, (int)describedExclusions.size());
        Assertions.assertEquals((Object)excludedBrokers, (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(describedExclusions).asScala().map((Function1 & Serializable)a -> BoxesRunTime.boxToInteger((int)a.brokerId()))).sorted((Ordering)Ordering.Int$.MODULE$));
        Assertions.assertEquals((Object)new .colon.colon((Object)"", (List)new .colon.colon((Object)"maintenance", (List)Nil$.MODULE$)), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(describedExclusions).asScala().map((Function1 & Serializable)a -> a.reason())).sorted((Ordering)Ordering.String$.MODULE$));
        if (this.isKRaftTest()) {
            this.restartController();
        } else {
            this.getController().shutdown();
        }
        describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertEquals((int)2, (int)describedExclusions.size());
        Assertions.assertEquals((Object)excludedBrokers, (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(describedExclusions).asScala().map((Function1 & Serializable)a -> BoxesRunTime.boxToInteger((int)a.brokerId()))).sorted((Ordering)Ordering.Int$.MODULE$));
        Assertions.assertEquals((Object)new .colon.colon((Object)"", (List)new .colon.colon((Object)"maintenance", (List)Nil$.MODULE$)), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(describedExclusions).asScala().map((Function1 & Serializable)a -> a.reason())).sorted((Ordering)Ordering.String$.MODULE$));
        excludedBrokers.foreach((Function1 & Serializable)excludedBroker -> ReplicaExclusionIntegrationTest.$anonfun$testExclusionFailover$7(this, BoxesRunTime.unboxToInt((Object)excludedBroker)));
    }

    public <T> Assertion assertAdminClientThrows(Function0<Object> f, ClassTag<T> classTag, Position pos) {
        return Matchers$.MODULE$.assertThrows((Function0 & Serializable)() -> {
            try {
                return f.apply();
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
        }, classTag, pos);
    }

    private void verifyExpectedException(AlterBrokerReplicaExclusionsResult.ExclusionsResult exclusionResult, int brokerId, Errors error) {
        java.util.Map exclusionsByBroker = exclusionResult.exclusionResultByBroker();
        Assertions.assertTrue((boolean)exclusionsByBroker.containsKey(BoxesRunTime.boxToInteger((int)brokerId)), (String)new StringBuilder(44).append("Expected exclusions by broker (").append(exclusionsByBroker).append(") to contain ").append(brokerId).toString());
        Optional brokerErrorOpt = ((ExclusionOpResult)exclusionsByBroker.get(BoxesRunTime.boxToInteger((int)brokerId))).errorOpt();
        Assertions.assertTrue((boolean)brokerErrorOpt.isPresent(), (String)new StringBuilder(56).append("Expected broker ").append(brokerId).append(" to have an exception with its exclusion").toString());
        Exception receivedException = ((ExclusionOperationError)brokerErrorOpt.get()).exception();
        ApiException expectedException = error.exception();
        Assertions.assertTrue((boolean)expectedException.getClass().isInstance(receivedException), (String)new StringBuilder(60).append("Expected broker ").append(brokerId).append("'s exception to be of type ").append(expectedException.getClass()).append(", instead it was ").append(receivedException).toString());
    }

    private void assertSuccessfulAlterResult(AlterBrokerReplicaExclusionsResult.ExclusionsResult result, List<String> reasons) {
        Assertions.assertTrue((boolean)result.isSuccessful(), (String)new StringBuilder(53).append("Expected result ").append(result).append(" to have been applied, but it was not").toString());
        scala.collection.mutable.Map resultByBroker = CollectionConverters$.MODULE$.MapHasAsScala(result.exclusionResultByBroker()).asScala();
        Assertions.assertTrue((boolean)resultByBroker.values().forall((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ReplicaExclusionIntegrationTest.$anonfun$assertSuccessfulAlterResult$1(r))), (String)new StringBuilder(69).append("Expected no exclusion results to have errors, but instead found some ").append(resultByBroker).toString());
        Assertions.assertEquals(reasons, (Object)((IterableOnceOps)resultByBroker.values().map((Function1 & Serializable)value -> value.reason())).toList().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public void createTopic(Admin adminClient, String topicName, scala.collection.immutable.Map<Object, List<Object>> topicAssignment) {
        java.util.Map replicasAssignments = CollectionConverters$.MODULE$.MapHasAsJava((Map)topicAssignment.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int key = x0$1._1$mcI$sp();
                List value = (List)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)value.map((Function1 & Serializable)x -> ReplicaExclusionIntegrationTest.$anonfun$createTopic$2(BoxesRunTime.unboxToInt((Object)x)))).asJava());
            }
            throw new MatchError(null);
        })).asJava();
        adminClient.createTopics(Collections.singletonList(new NewTopic(topicName, replicasAssignments))).all().get();
    }

    public void createPartitions(Admin adminClient, String topicName, int newTotalCountPartitions, scala.collection.immutable.Map<Object, List<Object>> partitionAssignment) {
        java.util.List newAssignments = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)partitionAssignment.toSeq().sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)x$2._2()).map((Function1 & Serializable)x -> ReplicaExclusionIntegrationTest.$anonfun$createPartitions$3(BoxesRunTime.unboxToInt((Object)x)))).asJava())).asJava();
        adminClient.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)NewPartitions.increaseTo((int)newTotalCountPartitions, (java.util.List)newAssignments))}))).asJava()).all().get();
    }

    public void createPartitions(Admin adminClient, String topicName, int newTotalCountPartitions) {
        adminClient.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)NewPartitions.increaseTo((int)newTotalCountPartitions))}))).asJava()).all().get();
    }

    public void createTopic(Admin adminClient, String topicName, int numPartitions, int replicationFactor) {
        adminClient.createTopics(Collections.singletonList(new NewTopic(topicName, numPartitions, (short)replicationFactor))).all().get();
    }

    public void validateTopicAssignment(String topicName, scala.collection.immutable.Map<Object, List<Object>> expectedAssignments) {
        TopicDescription topicDescription = this.describeTopic(topicName);
        Assertions.assertEquals((int)topicDescription.partitions().size(), (int)expectedAssignments.size());
        expectedAssignments.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaExclusionIntegrationTest.$anonfun$validateTopicAssignment$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            ReplicaExclusionIntegrationTest.$anonfun$validateTopicAssignment$2(this, topicDescription, x$3);
            return BoxedUnit.UNIT;
        });
    }

    public void validatePartitionAssignment(String topicName, int partition, List<Object> expectedAssignment) {
        TopicDescription topicDescription = this.describeTopic(topicName);
        this.validatePartitionAssignment(topicDescription, partition, expectedAssignment);
    }

    public void validatePartitionAssignment(TopicDescription topicDescription, int partition, List<Object> expectedAssignment) {
        Assertions.assertTrue((topicDescription.partitions().size() > partition ? 1 : 0) != 0, (String)new StringBuilder(83).append("Topic description for topic ").append(topicDescription.name()).append(" did not have enough partitions - wanted ").append(partition).append(" but had only ").append(topicDescription.partitions().size()).toString());
        Assertions.assertEquals(expectedAssignment, (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)topicDescription.partitions().get(partition)).replicas()).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()))).toList());
    }

    private void waitForAssert(TestCondition testCondition, long maxWaitMs, String conditionDetails) {
        AtomicReference<String> failureReason = new AtomicReference<String>("");
        Supplier<String> waitForCondition_conditionDetailsSupplier = () -> new StringBuilder(28).append(conditionDetails).append(" ; last reason for failure: ").append((Object)(((String)failureReason.get()).isEmpty() ? "<empty>" : failureReason.get())).toString();
        TestUtils.waitForCondition(() -> {
            try {
                return testCondition.conditionMet();
            }
            catch (AssertionError err) {
                failureReason.set(((Throwable)((Object)err)).toString());
                return false;
            }
        }, (long)maxWaitMs, (long)100L, waitForCondition_conditionDetailsSupplier);
    }

    public void validateTopicDoesntSpanExcludedBroker(String topicName, Set<Object> excludedBrokerIds, int expectedNumPartitions) {
        ObjectRef topicDescription = ObjectRef.create(null);
        ValuelessCallable retryOnExceptionWithTimeout_runnable = () -> {
            topicDescription$2.elem = this.describeTopic(topicName);
            Assertions.assertEquals((int)expectedNumPartitions, (int)((TopicDescription)topicDescription$2.elem).partitions().size(), (String)new StringBuilder(41).append("Expected topic ").append(topicName).append(" to").append(" have ").append(expectedNumPartitions).append(" but instead got ").append(((TopicDescription)topicDescription$2.elem).partitions().size()).toString());
        };
        TestUtils.retryOnExceptionWithTimeout((long)30000L, (long)100L, (ValuelessCallable)retryOnExceptionWithTimeout_runnable);
        Object var5_5 = null;
        CollectionConverters$.MODULE$.ListHasAsScala(((TopicDescription)topicDescription.elem).partitions()).asScala().foreach((Function1 & Serializable)pInfo -> {
            ReplicaExclusionIntegrationTest.$anonfun$validateTopicDoesntSpanExcludedBroker$2(excludedBrokerIds, topicName, pInfo);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private TopicDescription describeTopic(String topicName) {
        ObjectRef topicDescription = ObjectRef.create(null);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReplicaExclusionIntegrationTest.$anonfun$describeTopic$1(this, topicDescription, topicName)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicaExclusionIntegrationTest.$anonfun$describeTopic$2(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return (TopicDescription)topicDescription.elem;
    }

    private void reassign(TopicPartition tp, List<Object> targetReplicas) {
        NewPartitionReassignment reassignment = new NewPartitionReassignment(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)targetReplicas.map((Function1 & Serializable)x -> ReplicaExclusionIntegrationTest.$anonfun$reassign$1(BoxesRunTime.unboxToInt((Object)x)))).asJava());
        this.adminClient().alterPartitionReassignments(Collections.singletonMap(tp, Optional.of(reassignment))).all().get();
    }

    public static final /* synthetic */ boolean $anonfun$testExclusionFailover$1(IntRef b1$1, KafkaBroker s) {
        return s.config().brokerId() != b1$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$testExclusionFailover$2(IntRef b1$1, KafkaServer s) {
        return s.config().brokerId() != b1$1.elem;
    }

    public static final /* synthetic */ Assertion $anonfun$testExclusionFailover$7(ReplicaExclusionIntegrationTest $this, int excludedBroker) {
        scala.collection.immutable.Map invalidAssignment = (scala.collection.immutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{excludedBroker})))}));
        return $this.assertAdminClientThrows((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.createTopic((Admin)$this.adminClient(), "topic", (scala.collection.immutable.Map<Object, List<Object>>)invalidAssignment), ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
    }

    public static final /* synthetic */ boolean $anonfun$assertSuccessfulAlterResult$1(ExclusionOpResult r) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(r.errorOpt())).isEmpty();
    }

    public static final /* synthetic */ Integer $anonfun$createTopic$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$createPartitions$3(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicAssignment$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$validateTopicAssignment$2(ReplicaExclusionIntegrationTest $this, TopicDescription topicDescription$1, Tuple2 x$3) {
        if (x$3 != null) {
            int partition = x$3._1$mcI$sp();
            List expectedAssignment = (List)x$3._2();
            $this.validatePartitionAssignment(topicDescription$1, partition, (List<Object>)expectedAssignment);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$validateTopicDoesntSpanExcludedBroker$2(Set excludedBrokerIds$1, String topicName$2, TopicPartitionInfo pInfo) {
        Buffer replicas = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(pInfo.replicas()).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()));
        Assertions.assertTrue((boolean)replicas.forall((Function1)(JFunction1.mcZI.sp & Serializable)r -> !excludedBrokerIds$1.contains((Object)BoxesRunTime.boxToInteger((int)r))), (String)new StringBuilder(93).append("Expected replicas for ").append(topicName$2).append("-").append(pInfo.partition()).append(" to not include excluded brokers ").append(excludedBrokerIds$1).append(" but instead it had a replica set of ").append(replicas).toString());
    }

    public static final /* synthetic */ boolean $anonfun$describeTopic$1(ReplicaExclusionIntegrationTest $this, ObjectRef topicDescription$3, String topicName$3) {
        try {
            topicDescription$3.elem = (TopicDescription)((KafkaFuture)$this.adminClient().describeTopics(Collections.singletonList(topicName$3)).topicNameValues().get(topicName$3)).get();
            return true;
        }
        catch (ExecutionException e) {
            if (e.getCause() != null && e.getCause() instanceof UnknownTopicOrPartitionException) {
                return false;
            }
            throw e;
        }
    }

    public static final /* synthetic */ String $anonfun$describeTopic$2(String topicName$3) {
        return new StringBuilder(24).append("Failed describing topic ").append(topicName$3).toString();
    }

    public static final /* synthetic */ Integer $anonfun$reassign$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }
}

