/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.link;

import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.MirrorTopicConfigSyncRules$;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.network.ListenerName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005U4Aa\u0003\u0007\u0001'!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0003y\u0002B\u0002\u0015\u0001A\u0003%\u0001\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u0003^\u0001\u0011\u0005a\fC\u0003`\u0001\u0011\u0005a\fC\u0003a\u0001\u0011\u0005a\fC\u0003b\u0001\u0011\u0005a\fC\u0003c\u0001\u0011%1\rC\u0003j\u0001\u0011%!N\u0001\u0010NSJ\u0014xN\u001d+pa&\u001c7i\u001c8gS\u001e\u001c\u0016P\\2Sk2,7\u000fV3ti*\u0011QBD\u0001\u0005Y&t7N\u0003\u0002\u0010!\u0005)1.\u00194lC*\t\u0011#A\u0006j]R,wM]1uS>t7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!!D\f\u000b\u0003=I!!\u0007\f\u0003E\u0005\u00137\u000f\u001e:bGR\u001cE.^:uKJd\u0015N\\6J]R,wM]1uS>tG+Z:u\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u001e\u00015\tA\"A\nu_BL7mU=oG&sG/\u001a:wC2l5/F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u0015;sS:<\u0017\u0001\u0006;pa&\u001c7+\u001f8d\u0013:$XM\u001d<bY6\u001b\b%\u0001\u000euKN$Hk\u001c9jG\u000e{gNZ5h'ft7-\u00138dYV$W\rF\u0002,cu\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012A!\u00168ji\")!\u0007\u0002a\u0001g\u00051\u0011/^8sk6\u0004\"\u0001N\u001e\u000f\u0005UJ\u0004C\u0001\u001c.\u001b\u00059$B\u0001\u001d\u0013\u0003\u0019a$o\\8u}%\u0011!(L\u0001\u0007!J,G-\u001a4\n\u0005\u001db$B\u0001\u001e.\u0011\u0015qD\u00011\u0001@\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u0011\u00051\u0002\u0015BA!.\u0005\u001d\u0011un\u001c7fC:DC\u0001B\"R%B\u0011AiT\u0007\u0002\u000b*\u0011aiR\u0001\taJ|g/\u001b3fe*\u0011\u0001*S\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\u0005)[\u0015a\u00026va&$XM\u001d\u0006\u0003\u00196\u000bQA[;oSRT\u0011AT\u0001\u0004_J<\u0017B\u0001)F\u00051iU\r\u001e5pIN{WO]2f\u0003\u00151\u0018\r\\;fY\u0005\u0019\u0016%\u0001+\u0002\u001f\u0005dGnQ8nE&t\u0017\r^5p]NDC\u0001\u0002,[7B\u0011q\u000bW\u0007\u0002\u000f&\u0011\u0011l\u0012\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f\u0013\u0001X\u0001)w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBjhfY8pe\u0012Lg.\u0019;pevZ\u0018'`\u0001\u0013m\u0016\u0014\u0018NZ=J]Z\fG.\u001b3WC2,X\rF\u0001,\u0003M2XM]5gs6K'O]8s)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8Pm\u0016\u0014(/\u001b3fg\u0006cw/Y=t'ft7mQ8oM&<7/\u0001\bwKJLg-_(wKJ\u0014\u0018\u000eZ3\u0002\u001bY,'/\u001b4z\t\u00164\u0017-\u001e7u\u00031\u0019wN\u001c4jO2K7\u000f^(g)\t\u0019D\rC\u0003f\u0013\u0001\u0007a-A\u0003fY\u0016l7\u000fE\u0002-ONJ!\u0001[\u0017\u0003\u0015q\u0012X\r]3bi\u0016$g(\u0001\u0007baB,g\u000eZ!mo\u0006L8\u000f\u0006\u00024W\")AN\u0003a\u0001g\u0005\u0011Ao\u001c\u0015\u0005\u00019\fF\u000f\u0005\u0002pe6\t\u0001O\u0003\u0002r\u0013\u0006\u0019\u0011\r]5\n\u0005M\u0004(a\u0001+bO\u0006\n\u0011\u0003")
public class MirrorTopicConfigSyncRulesTest
extends AbstractClusterLinkIntegrationTest {
    private final String topicSyncIntervalMs;

    public String topicSyncIntervalMs() {
        return this.topicSyncIntervalMs;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testTopicConfigSyncInclude(String quorum, boolean coordinator) {
        this.verifyInvalidValue();
        this.verifyMirrorTopicCreationOverridesAlwaysSyncConfigs();
        this.verifyOverride();
        this.verifyDefault();
    }

    public void verifyInvalidValue() {
        String linkName = UUID.randomUUID().toString();
        new .colon.colon((Object)this.configListOf((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"retention.bytes"})), (List)new .colon.colon((Object)this.appendAlways(this.configListOf((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.tier.enable"}))), (List)new .colon.colon((Object)"", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)value -> {
            Properties linkConfigOverrides = new Properties(this, (String)value){
                {
                    this.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), value$1);
                    this.putAll((java.util.Map<?, ?>)$outer.destLinkProps($outer.destLinkProps$default$1()));
                }
            };
            return (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.createClusterLink(linkName, linkConfigOverrides, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5()));
        });
    }

    public void verifyMirrorTopicCreationOverridesAlwaysSyncConfigs() {
        String topic = UUID.randomUUID().toString();
        String linkName = UUID.randomUUID().toString();
        String topicConfigSyncInclude = this.appendAlways(this.configListOf((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"flush.ms"})));
        Properties linkConfigOverrides = new Properties(null, topicConfigSyncInclude){
            {
                this.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), topicConfigSyncInclude$1);
                this.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp(), "100");
            }
        };
        linkConfigOverrides.putAll((java.util.Map<?, ?>)this.destLinkProps(this.destLinkProps$default$1()));
        this.createClusterLink(linkName, linkConfigOverrides, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        scala.collection.immutable.Map mirrorTopicConfigsOverride = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flush.ms"), (Object)"14141414")}));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            ClusterLinkTestHarness qual$1 = this.destCluster();
            short x$2 = this.replicationFactor();
            String x$5 = qual$1.linkTopic$default$5();
            qual$1.linkTopic(topic, x$2, linkName, (Map<String, String>)mirrorTopicConfigsOverride, x$5);
        });
    }

    /*
     * WARNING - void declaration
     */
    public void verifyOverride() {
        String topic = UUID.randomUUID().toString();
        String linkName = UUID.randomUUID().toString();
        String topicConfigSyncInclude = this.appendAlways(this.configListOf((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"min.compaction.lag.ms", "flush.ms"})));
        Properties linkConfigOverrides = new Properties(null, topicConfigSyncInclude){
            {
                this.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), topicConfigSyncInclude$2);
                this.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp(), "100");
            }
        };
        linkConfigOverrides.putAll((java.util.Map<?, ?>)this.destLinkProps(this.destLinkProps$default$1()));
        String minCompactionLagMs = "2222";
        String flushMs = "4444";
        String maxMessageBytesOverride = "3333333";
        String tierEnable = "true";
        Properties topicConfigs = new Properties(null, minCompactionLagMs, flushMs, maxMessageBytesOverride, tierEnable){
            {
                this.put("min.compaction.lag.ms", minCompactionLagMs$1);
                this.put("flush.ms", flushMs$1);
                this.put("max.message.bytes", maxMessageBytesOverride$1);
                this.put("confluent.tier.enable", tierEnable$1);
            }
        };
        this.createClusterLink(linkName, linkConfigOverrides, this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topic, x$2, x$3, topicConfigs, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        short x$8 = this.replicationFactor();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(topic, x$8, linkName, x$10, x$11);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MirrorTopicConfigSyncRulesTest.$anonfun$verifyOverride$1(this, topic, maxMessageBytesOverride)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)MirrorTopicConfigSyncRulesTest.$anonfun$verifyOverride$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.immutable.Map expect = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min.compaction.lag.ms"), (Object)minCompactionLagMs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flush.ms"), (Object)flushMs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.tier.enable"), (Object)Boolean.toString(false))}));
        Assertions.assertTrue((boolean)this.destCluster().describeTopicConfigEquals(topic, (Map<String, String>)expect), (String)"min.compaction.lag.ms should sync, flush.ms should sync, confluent.tier.enable shouldn't sync");
    }

    /*
     * WARNING - void declaration
     */
    public void verifyDefault() {
        String topic = UUID.randomUUID().toString();
        String linkName = UUID.randomUUID().toString();
        String minCompactionLagMs = "3333333333";
        String flushMs = "11111111";
        Properties topicConfigs = new Properties(null, minCompactionLagMs, flushMs){
            {
                this.put("min.compaction.lag.ms", minCompactionLagMs$2);
                this.put("flush.ms", flushMs$2);
            }
        };
        this.createClusterLink(linkName, this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topic, x$2, x$3, topicConfigs, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        short x$8 = this.replicationFactor();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(topic, x$8, linkName, x$10, x$11);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MirrorTopicConfigSyncRulesTest.$anonfun$verifyDefault$1(this, topic, minCompactionLagMs)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)MirrorTopicConfigSyncRulesTest.$anonfun$verifyDefault$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)this.destCluster().describeTopicConfigEquals(topic, "flush.ms", Long.toString(Long.MAX_VALUE)), (String)"flush.ms shouldn't sync");
    }

    private String configListOf(Seq<String> elems) {
        return elems.mkString(",");
    }

    private String appendAlways(String to) {
        List elems = (List)new .colon.colon((Object)to, (List)Nil$.MODULE$).$plus$plus((IterableOnce)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().toList());
        Predef$.MODULE$.println((Object)new StringBuilder(8).append("elems = ").append(elems).toString());
        return elems.mkString(",");
    }

    public static final /* synthetic */ boolean $anonfun$verifyOverride$1(MirrorTopicConfigSyncRulesTest $this, String topic$2, String maxMessageBytesOverride$1) {
        return $this.destCluster().describeTopicConfigEquals(topic$2, "max.message.bytes", maxMessageBytesOverride$1);
    }

    public static final /* synthetic */ String $anonfun$verifyOverride$2() {
        return new StringBuilder(29).append("max.message.bytes").append(" should sync").toString();
    }

    public static final /* synthetic */ boolean $anonfun$verifyDefault$1(MirrorTopicConfigSyncRulesTest $this, String topic$3, String minCompactionLagMs$2) {
        return $this.destCluster().describeTopicConfigEquals(topic$3, "min.compaction.lag.ms", minCompactionLagMs$2);
    }

    public static final /* synthetic */ String $anonfun$verifyDefault$2() {
        return "min.compaction.lag.ms should sync by default";
    }

    public MirrorTopicConfigSyncRulesTest() {
        this.numPartitions_$eq(1);
        this.topicSyncIntervalMs = "1000";
    }
}

