/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.controller.ControllerContext;
import kafka.server.KafkaConfig;
import kafka.server.QuorumTestHarness;
import kafka.server.cell.ZkCellControlManager;
import kafka.server.cell.ZkTenantControlManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellLoad;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.errors.CellNotFoundException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.placement.CellAssignor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\u0005ub\u0001B\f\u0019\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013\u00051\u0006\u0003\u00043\u0001\u0001\u0006I\u0001\f\u0005\bg\u0001\u0011\r\u0011\"\u00015\u0011\u0019Y\u0004\u0001)A\u0005k!)A\b\u0001C!{!)1\u000b\u0001C\u0001)\")\u0011\f\u0001C\u0001)\")1\f\u0001C\u0001)\")Q\f\u0001C\u0001)\")q\f\u0001C\u0001)\")\u0011\r\u0001C\u0001)\")1\r\u0001C\u0001)\")Q\r\u0001C\u0001)\")q\r\u0001C\u0001)\")\u0011\u000e\u0001C\u0001)\")1\u000e\u0001C\u0001)\")Q\u000e\u0001C\u0001)\")q\u000e\u0001C\u0001)\")\u0011\u000f\u0001C\u0001)\")1\u000f\u0001C\u0005i\"9\u00111\u0007\u0001\u0005\n\u0005U\"\u0001\u0007.l\u0007\u0016dGnQ8oiJ|G.T1oC\u001e,'\u000fV3ti*\u0011\u0011DG\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005ma\u0012!B6bM.\f'\"A\u000f\u0002\u0017%tG/Z4sCRLwN\\\u0002\u0001'\t\u0001\u0001\u0005\u0005\u0002\"I5\t!E\u0003\u0002\u001aG)\t1$\u0003\u0002&E\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005A\u0003CA\u0015\u0001\u001b\u0005A\u0012aB2p]R,\u0007\u0010^\u000b\u0002YA\u0011Q\u0006M\u0007\u0002])\u0011qfI\u0001\u000bG>tGO]8mY\u0016\u0014\u0018BA\u0019/\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u0001\tG>tG/\u001a=uA\u0005\t\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\u0016\u0003U\u0002\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012Qa\u00155peR\f!C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sA\u0005)1/\u001a;VaR\u0011a(\u0011\t\u0003m}J!\u0001Q\u001c\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0005\u001a\u0001\raQ\u0001\ti\u0016\u001cH/\u00138g_B\u0011A)T\u0007\u0002\u000b*\u0011aiR\u0001\u0004CBL'B\u0001%J\u0003\u001dQW\u000f]5uKJT!AS&\u0002\u000b),h.\u001b;\u000b\u00031\u000b1a\u001c:h\u0013\tqUI\u0001\u0005UKN$\u0018J\u001c4pQ\t1\u0001\u000b\u0005\u0002E#&\u0011!+\u0012\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017A\u0004;fgR\u001cU\r\u001c7De\u0016\fG/\u001a\u000b\u0002}!\u0012qA\u0016\t\u0003\t^K!\u0001W#\u0003\tQ+7\u000f^\u0001\u0016i\u0016\u001cH/Q:tS\u001et'I]8lKJ\u001cU\r\u001c7tQ\tAa+\u0001\u0014uKN$\u0018i]:jO:\u0014%o\\6fe\u000e+G\u000e\\:XSRDW\t_5ti&twmQ3mYND#!\u0003,\u0002[Q,7\u000f^!tg&<gN\u0011:pW\u0016\u00148)\u001a7mg^KG\u000f[#ySN$\u0018N\\4DK2d7o\u0014<fe6\u000b\u0007\u0010\u000b\u0002\u000b-\u0006qC/Z:u\u000bb\u0004H.[2ji\u0006\u001b8/[4o\u0005J|7.\u001a:DK2d7oV5uQ\u0016C\u0018n\u001d;j]\u001e\u001cU\r\u001c7tQ\tYa+A\u0016uKN$X\t\u001f9mS\u000eLG/Q:tS\u001et'I]8lKJ\u001cU\r\u001c7t)\"\u0014xn^:JM:{7)\u001a7mQ\taa+A\buKN$x)\u001a;BY2\u001cU\r\u001c7tQ\tia+A\u000buKN$8i\\7qkR,Wk]1cY\u0016\u001cU\r\u001c7)\u000591\u0016!\u000b;fgR\u001cu.\u001c9vi\u0016,6/\u00192mK\u000e+G\u000e\u001c)po\u0016\u0014xJ\u001a+x_NKW.\u001e7bi&|g\u000e\u000b\u0002\u0010-\u0006iC/Z:u\u0007>l\u0007/\u001e;f+N\f'\r\\3DK2d'I]8lKJ\u001cu.\u001e8u\u0007>t7/\u001b3fe\u0006$\u0018n\u001c8)\u0005A1\u0016A\u0006;fgR,\u0006\u000fZ1uK\u000e+G\u000e\\'fi\u0006$\u0017\r^1)\u0005E1\u0016A\u0003;fgR$U\r\\3uK\"\u0012!CV\u0001\u0014i\u0016\u001cHoR3u\u0005J|7.\u001a:DK2d\u0017\n\u001a\u0015\u0003'Y\u000b1\u0004^3tiVs\u0017m]:jO:\u0014%o\\6feN4%o\\7DK2d\u0007F\u0001\u000bW\u0003)\u0019'/Z1uK\u000e+G\u000e\u001c\u000b\u000bkz\f9!!\t\u0002,\u0005=\u0002C\u0001<}\u001b\u00059(B\u0001=z\u0003\u0019\u0019w.\\7p]*\u00111D\u001f\u0006\u0003w.\u000ba!\u00199bG\",\u0017BA?x\u0005\u0011\u0019U\r\u001c7\t\r},\u0002\u0019AA\u0001\u0003\u0019\u0019W\r\u001c7JIB\u0019a'a\u0001\n\u0007\u0005\u0015qGA\u0002J]RDq!!\u0003\u0016\u0001\u0004\tY!A\u0004ce>\\WM]:\u0011\r\u00055\u00111DA\u0001\u001d\u0011\ty!a\u0006\u0011\u0007\u0005Eq'\u0004\u0002\u0002\u0014)\u0019\u0011Q\u0003\u0010\u0002\rq\u0012xn\u001c;?\u0013\r\tIbN\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0011q\u0004\u0002\u0004'\u0016$(bAA\ro!9\u00111E\u000bA\u0002\u0005\u0015\u0012!B:uCR,\u0007c\u0001<\u0002(%\u0019\u0011\u0011F<\u0003\u0013\r+G\u000e\\*uCR,\u0007BBA\u0017+\u0001\u0007Q'A\u0004nS:\u001c\u0016N_3\t\r\u0005ER\u00031\u00016\u0003\u001di\u0017\r_*ju\u0016\f1b[1gW\u0006\u001cuN\u001c4jOR\u0011\u0011q\u0007\t\u0004C\u0005e\u0012bAA\u001eE\tY1*\u00194lC\u000e{gNZ5h\u0001")
public class ZkCellControlManagerTest
extends QuorumTestHarness {
    private final ControllerContext context = new ControllerContext();
    private final short replicationFactor = (short)3;

    public ControllerContext context() {
        return this.context;
    }

    public short replicationFactor() {
        return this.replicationFactor;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.zkClient().createControllerEpochRaw(1);
    }

    @Test
    public void testCellCreate() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        int cellId = 0;
        scala.collection.immutable.Seq brokers = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        CellState state = CellState.READY;
        short minSize = (short)3;
        short maxSize = (short)6;
        Cell cell = cellControl.createCell(cellId, (Seq)brokers, state, minSize, maxSize);
        Assertions.assertEquals((Object)this.createCell(cellId, (scala.collection.immutable.Set<Object>)brokers.toSet(), state, minSize, maxSize), (Object)cellControl.getCell(cellId).get());
        Assertions.assertEquals((Object)cell, (Object)cellControl.getCell(cellId).get());
        int secondCellId = 1;
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.createCell(cellId, (Seq)brokers, state, minSize, maxSize));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.createCell(-1, (Seq)brokers, state, minSize, maxSize));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.createCell(secondCellId, (Seq)brokers, CellState.UNKNOWN, minSize, maxSize));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.createCell(secondCellId, (Seq)brokers, CellState.READY, (short)(maxSize + 1), maxSize));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.createCell(secondCellId, (Seq)brokers, state, (short)0, maxSize));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.createCell(secondCellId, (Seq)brokers, state, minSize, (short)0));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.createCell(secondCellId, (Seq)brokers, state, minSize, (short)(brokers.size() - 1)));
    }

    @Test
    public void testAssignBrokerCells() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        int cellId = 0;
        Range brokers = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 15);
        Cell firstCell = cellControl.createCell(cellId, (Seq)brokers, CellState.READY, (short)6, (short)15);
        int secondCellId = 1;
        Range secondBrokers = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(15), 30);
        Cell secondCell = cellControl.createCell(secondCellId, (Seq)secondBrokers, CellState.READY, (short)6, (short)15);
        int thirdCellId = 2;
        Cell thirdCell = this.createCell(thirdCellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{30}))), CellState.READY, (short)6, (short)15);
        cellControl.assignBrokersToCells((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 30));
        Assertions.assertEquals((Object)new Some((Object)firstCell), (Object)cellControl.getCell(cellId));
        Assertions.assertEquals((Object)new Some((Object)secondCell), (Object)cellControl.getCell(secondCellId));
        Assertions.assertEquals((Object)new Some((Object)thirdCell), (Object)cellControl.getCell(thirdCellId));
    }

    @Test
    public void testAssignBrokerCellsWithExistingCells() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        int cellId = 0;
        int secondCellId = 1;
        cellControl.createCell(cellId, (Seq)Nil$.MODULE$, CellState.READY, (short)6, (short)15);
        cellControl.createCell(secondCellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), CellState.READY, (short)3, (short)15);
        cellControl.assignBrokersToCells((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 30));
        Cell cell = this.createCell(cellId, (scala.collection.immutable.Set<Object>)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(3), 15).toSet(), CellState.READY, (short)6, (short)15);
        Assertions.assertEquals((Object)new Some((Object)cell), (Object)cellControl.getCell(cellId));
        Cell secondCell = this.createCell(secondCellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26}))), CellState.READY, (short)3, (short)15);
        Assertions.assertEquals((Object)new Some((Object)secondCell), (Object)cellControl.getCell(secondCellId));
    }

    @Test
    public void testAssignBrokerCellsWithExistingCellsOverMax() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        int cellId = 0;
        Cell cell = cellControl.createCell(cellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10, 11, 12, 13, 14, 15})), CellState.READY, (short)3, (short)6);
        cellControl.assignBrokersToCells((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5));
        Assertions.assertEquals((Object)new Some((Object)cell), (Object)cellControl.getCell(cellId));
    }

    @Test
    public void testExplicitAssignBrokerCellsWithExistingCells() {
        KafkaConfig config = this.kafkaConfig();
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, config, new Random(0), this.replicationFactor());
        int cellId = 0;
        int secondCellId = 1;
        Range brokerIds = (Range)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), (int)config.cellDefaultSize()).toSeq();
        cellControl.createCell(cellId, (Seq)Nil$.MODULE$, CellState.READY, (short)3, config.cellMaxSize());
        cellControl.createCell(secondCellId, (Seq)brokerIds, CellState.READY, (short)3, config.cellMaxSize());
        cellControl.assignBrokersToCell((Seq)brokerIds, 0, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), false);
        Cell cell = this.createCell(cellId, (scala.collection.immutable.Set<Object>)brokerIds.toSet(), CellState.READY, (short)3, config.cellMaxSize());
        Assertions.assertEquals((Object)new Some((Object)cell), (Object)cellControl.getCell(cellId));
        Cell otherCell = this.createCell(secondCellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), CellState.READY, (short)3, config.cellMaxSize());
        Assertions.assertEquals((Object)new Some((Object)otherCell), (Object)cellControl.getCell(secondCellId));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.assignBrokersToCell((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6})), 0, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), false));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.assignBrokersToCell((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6})), 1, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), false));
    }

    @Test
    public void testExplicitAssignBrokerCellsThrowsIfNoCell() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        Assertions.assertThrows(CellNotFoundException.class, () -> cellControl.assignBrokersToCell((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), 0, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), false));
    }

    @Test
    public void testGetAllCells() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)cellControl.sortedCells());
        cellControl.createCell(0, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), CellState.READY, (short)3, (short)6);
        cellControl.createCell(1, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6})), CellState.READY, (short)4, (short)6);
        cellControl.createCell(2, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7})), CellState.READY, (short)1, (short)2);
        Assertions.assertEquals((Object)new .colon.colon((Object)this.createCell(0, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.READY, (short)3, (short)6), (List)new .colon.colon((Object)this.createCell(1, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6}))), CellState.READY, (short)4, (short)6), (List)new .colon.colon((Object)this.createCell(2, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7}))), CellState.READY, (short)1, (short)2), (List)Nil$.MODULE$))), (Object)cellControl.sortedCells());
    }

    @Test
    public void testComputeUsableCell() {
        long currTime = 1000L;
        MockTime time = new MockTime(0L, currTime, 0L);
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), (Time)time, this.kafkaConfig(), new Random(0), (short)3);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        cellControl.createCell(0, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), CellState.READY, (short)3, (short)6);
        cellControl.createCell(1, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6})), CellState.READY, (short)4, (short)6);
        cellControl.createCell(2, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), CellState.READY, (short)1, (short)3);
        cellControl.createCell(3, (Seq)Nil$.MODULE$, CellState.QUARANTINED, (short)1, (short)2);
        cellControl.createCell(4, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10})), CellState.READY, (short)1, (short)2);
        cellControl.createCell(5, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{11})), CellState.READY, (short)1, (short)2);
        cellControl.createCell(6, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{12})), CellState.READY, (short)1, (short)2);
        cellControl.createCell(7, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{13})), CellState.READY, (short)1, (short)2);
        scala.collection.immutable.Set cellLoads = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CellLoad[]{new CellLoad(0, 0.1), new CellLoad(1, 0.05), new CellLoad(3, 0.0), new CellLoad(4, 0.101), new CellLoad(5, 0.102), new CellLoad(6, 0.103), new CellLoad(7, 0.104)}));
        cellControl.fullUpdateCellLoadCache(CollectionConverters$.MODULE$.SetHasAsJava((Set)cellLoads).asJava(), currTime);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3, 4, 7}))));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7}))));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{8}))));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 101, 102, 103}))));
        Assertions.assertEquals((Object)new Some((Object)this.createCell(0, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.READY, (short)3, (short)6)), (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        Assertions.assertEquals((Object)new Some((Object)this.createCell(1, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6}))), CellState.READY, (short)4, (short)6)), (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6}))));
        Assertions.assertEquals((Object)new Some((Object)this.createCell(1, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6}))), CellState.READY, (short)4, (short)6)), (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}))));
        time.setCurrentTimeMs(currTime + CellAssignor.CELL_LOAD_FRESH_DURATION_MS + 1L);
        Assertions.assertEquals((Object)new Some((Object)this.createCell(0, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.READY, (short)3, (short)6)), (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}))));
        Assertions.assertEquals((Object)new Some((Object)this.createCell(1, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6}))), CellState.READY, (short)4, (short)6)), (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}))));
        Assertions.assertEquals((Object)new Some((Object)this.createCell(2, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9}))), CellState.READY, (short)1, (short)3)), (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}))));
        Assertions.assertEquals((Object)new Some((Object)this.createCell(0, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.READY, (short)3, (short)6)), (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}))));
        Assertions.assertEquals((Object)new Some((Object)this.createCell(1, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6}))), CellState.READY, (short)4, (short)6)), (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}))));
        Assertions.assertEquals((Object)new Some((Object)this.createCell(2, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9}))), CellState.READY, (short)1, (short)3)), (Object)cellControl.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}))));
    }

    @Test
    public void testComputeUsableCellPowerOfTwoSimulation() {
        int runs = 1000000;
        long currTime = 0L;
        MockTime time = new MockTime(0L, currTime, currTime);
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), (Time)time, this.kafkaConfig(), new Random(0), (short)1);
        cellControl.createCell(0, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), CellState.READY, (short)1, (short)2);
        cellControl.createCell(1, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), CellState.READY, (short)1, (short)2);
        cellControl.createCell(2, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), CellState.READY, (short)1, (short)2);
        cellControl.createCell(3, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), CellState.READY, (short)1, (short)2);
        cellControl.createCell(4, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4})), CellState.READY, (short)1, (short)2);
        scala.collection.immutable.Set cellLoads = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CellLoad[]{new CellLoad(0, 0.0), new CellLoad(1, 0.1), new CellLoad(2, 0.2), new CellLoad(3, 0.3), new CellLoad(4, 0.4)}));
        cellControl.fullUpdateCellLoadCache(CollectionConverters$.MODULE$.SetHasAsJava((Set)cellLoads).asJava(), currTime);
        .colon.colon cellsChosen = new .colon.colon((Object)new AtomicInteger(), (List)new .colon.colon((Object)new AtomicInteger(), (List)new .colon.colon((Object)new AtomicInteger(), (List)new .colon.colon((Object)new AtomicInteger(), (List)new .colon.colon((Object)new AtomicInteger(), (List)Nil$.MODULE$)))));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), runs).foreach((Function1)((JFunction1.mcII.sp & Serializable)arg_0 -> ZkCellControlManagerTest.$anonfun$testComputeUsableCellPowerOfTwoSimulation$1(cellControl, (scala.collection.immutable.Seq)cellsChosen, arg_0)));
        float firstChosenRatio = (float)((AtomicInteger)cellsChosen.head()).get() / (float)runs;
        float secondChosenRatio = (float)((AtomicInteger)cellsChosen.apply(1)).get() / (float)runs;
        float thirdChosenRatio = (float)((AtomicInteger)cellsChosen.apply(2)).get() / (float)runs;
        float fourthChosenRatio = (float)((AtomicInteger)cellsChosen.apply(3)).get() / (float)runs;
        float fifthChosenRatio = (float)((AtomicInteger)cellsChosen.apply(4)).get() / (float)runs;
        double error = 0.01;
        Assertions.assertTrue((Math.abs((double)firstChosenRatio - 0.4) < error ? 1 : 0) != 0);
        Assertions.assertTrue((Math.abs((double)secondChosenRatio - 0.3) < error ? 1 : 0) != 0);
        Assertions.assertTrue((Math.abs((double)thirdChosenRatio - 0.2) < error ? 1 : 0) != 0);
        Assertions.assertTrue((Math.abs((double)fourthChosenRatio - 0.1) < error ? 1 : 0) != 0);
        Assertions.assertEquals((float)0.0f, (float)fifthChosenRatio);
    }

    @Test
    public void testComputeUsableCellBrokerCountConsideration() {
        int runs = 100;
        long currTime = 1000L;
        MockTime time = new MockTime(0L, currTime, 0L);
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), (Time)time, this.kafkaConfig(), new Random(0), this.replicationFactor());
        cellControl.createCell(0, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), CellState.READY, (short)1, (short)1);
        cellControl.createCell(1, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5})), CellState.READY, (short)5, (short)5);
        scala.collection.immutable.Set cellLoads = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CellLoad[]{new CellLoad(0, 0.0), new CellLoad(1, 0.1)}));
        cellControl.fullUpdateCellLoadCache(CollectionConverters$.MODULE$.SetHasAsJava((Set)cellLoads).asJava(), currTime);
        .colon.colon cellsChosen = new .colon.colon((Object)new AtomicInteger(), (List)new .colon.colon((Object)new AtomicInteger(), (List)Nil$.MODULE$));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), runs).foreach((Function1)((JFunction1.mcII.sp & Serializable)arg_0 -> ZkCellControlManagerTest.$anonfun$testComputeUsableCellBrokerCountConsideration$1(cellControl, (scala.collection.immutable.Seq)cellsChosen, arg_0)));
        float firstChosenRatio = (float)((AtomicInteger)cellsChosen.head()).get() / (float)runs;
        float secondChosenRatio = (float)((AtomicInteger)cellsChosen.apply(1)).get() / (float)runs;
        Assertions.assertTrue(((double)firstChosenRatio == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue(((double)secondChosenRatio == 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateCellMetadata() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        int cellId = 0;
        cellControl.createCell(cellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), CellState.READY, (short)3, (short)6);
        scala.collection.immutable.Set cellBrokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Assertions.assertThrows(CellNotFoundException.class, () -> cellControl.updateCellMetadata(1, CellState.READY, (short)3, (short)6, cellBrokers));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.updateCellMetadata(cellId, CellState.READY, (short)0, (short)6, cellBrokers));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.updateCellMetadata(cellId, CellState.READY, (short)6, (short)0, cellBrokers));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.updateCellMetadata(cellId, CellState.READY, (short)0, (short)0, cellBrokers));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.updateCellMetadata(cellId, CellState.READY, (short)0, (short)0, cellBrokers));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.updateCellMetadata(cellId, CellState.READY, (short)4, (short)3, cellBrokers));
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.updateCellMetadata(cellId, CellState.UNKNOWN, (short)3, (short)6, cellBrokers));
        Assertions.assertThrows(CellNotFoundException.class, () -> cellControl.updateCellMetadata(-1, CellState.READY, (short)3, (short)6, cellBrokers));
        cellControl.updateCellMetadata(cellId, CellState.QUARANTINED, (short)4, (short)5, cellBrokers);
        Cell cell = this.createCell(cellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.QUARANTINED, (short)4, (short)5);
        Assertions.assertEquals((Object)new Some((Object)cell), (Object)cellControl.getCell(cellId));
    }

    @Test
    public void testDelete() {
        KafkaConfig config = this.kafkaConfig();
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, config, new Random(0), this.replicationFactor());
        ZkTenantControlManager tenantControl = new ZkTenantControlManager(this.zkClient(), cellControl, this.context(), config, this.replicationFactor());
        int cellId = 0;
        int secondCellId = 1;
        String tenantId = "lkc-0000";
        cellControl.createCell(cellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), CellState.READY, (short)3, config.cellMaxSize());
        cellControl.createCell(secondCellId, (Seq)Nil$.MODULE$, CellState.READY, (short)3, config.cellMaxSize());
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.deleteCell(cellId));
        Range brokerIds = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), (int)config.cellDefaultSize());
        cellControl.assignBrokersToCell((Seq)brokerIds, secondCellId, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), false);
        tenantControl.createTenant(tenantId, cellId);
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.deleteCell(cellId));
        tenantControl.deleteTenant(tenantId);
        cellControl.deleteCell(cellId);
        Assertions.assertEquals((Object)new .colon.colon((Object)this.createCell(secondCellId, (scala.collection.immutable.Set<Object>)brokerIds.toSet(), CellState.READY, (short)3, config.cellMaxSize()), (List)Nil$.MODULE$), (Object)cellControl.sortedCells());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cellControl.getCell(cellId));
        Assertions.assertThrows(CellNotFoundException.class, () -> cellControl.deleteCell(cellId));
    }

    @Test
    public void testGetBrokerCellId() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        ZkCellControlManager cellDescriber = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        int cellId = 0;
        int secondCellId = 1;
        cellControl.createCell(cellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), CellState.READY, (short)3, (short)6);
        cellControl.createCell(secondCellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), CellState.READY, (short)3, (short)6);
        Assertions.assertEquals((int)cellId, (int)cellDescriber.getBrokerCellId(0));
        Assertions.assertEquals((int)cellId, (int)cellDescriber.getBrokerCellId(1));
        Assertions.assertEquals((int)cellId, (int)cellDescriber.getBrokerCellId(2));
        Assertions.assertEquals((int)secondCellId, (int)cellDescriber.getBrokerCellId(3));
        Assertions.assertEquals((int)secondCellId, (int)cellDescriber.getBrokerCellId(4));
        Assertions.assertEquals((int)secondCellId, (int)cellDescriber.getBrokerCellId(5));
        Assertions.assertEquals((int)-1, (int)cellDescriber.getBrokerCellId(6));
        Assertions.assertEquals((int)-1, (int)cellDescriber.getBrokerCellId(7));
    }

    @Test
    public void testUnassignBrokersFromCell() {
        KafkaConfig config = this.kafkaConfig();
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, config, new Random(0), this.replicationFactor());
        int cellId = 0;
        Range brokerIds = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), (int)config.cellDefaultSize());
        cellControl.assignBrokersToCells((Seq)brokerIds);
        Assertions.assertThrows(InvalidRequestException.class, () -> cellControl.unassignBrokersFromCell((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).toSet()));
        cellControl.unassignBrokersFromCell((Seq)brokerIds, brokerIds.toSet());
        Cell cell = this.createCell(cellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), CellState.READY, (short)6, (short)15);
        Assertions.assertEquals((Object)new Some((Object)cell), (Object)cellControl.getCell(cellId));
    }

    private Cell createCell(int cellId, scala.collection.immutable.Set<Object> brokers, CellState state, short minSize, short maxSize) {
        return new Cell(cellId, CollectionConverters$.MODULE$.SetHasAsJava((Set)brokers.map((Function1 & Serializable)x -> ZkCellControlManagerTest.$anonfun$createCell$1(BoxesRunTime.unboxToInt((Object)x)))).asJava(), state, minSize, maxSize);
    }

    private KafkaConfig kafkaConfig() {
        boolean apply_doLog = true;
        Properties apply_props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnectOrNull(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        return new KafkaConfig((Map)apply_props, apply_doLog);
    }

    public static final /* synthetic */ int $anonfun$testComputeUsableCellPowerOfTwoSimulation$1(ZkCellControlManager cellControl$4, scala.collection.immutable.Seq cellsChosen$1, int i) {
        Cell chosenCell = (Cell)cellControl$4.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}))).get();
        return ((AtomicInteger)cellsChosen$1.apply(chosenCell.cellId())).getAndIncrement();
    }

    public static final /* synthetic */ int $anonfun$testComputeUsableCellBrokerCountConsideration$1(ZkCellControlManager cellControl$5, scala.collection.immutable.Seq cellsChosen$2, int i) {
        Cell chosenCell = (Cell)cellControl$5.computeUsableCell((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5}))).get();
        return ((AtomicInteger)cellsChosen$2.apply(chosenCell.cellId())).getAndIncrement();
    }

    public static final /* synthetic */ Integer $anonfun$createCell$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }
}

