/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.controller.ControllerContext;
import kafka.server.KafkaConfig;
import kafka.server.QuorumTestHarness;
import kafka.server.cell.ZkCellControlManager;
import kafka.server.cell.ZkTenantControlManager;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellLoad;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.errors.CellNotFoundException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.ResourceNotFoundException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001B\u0007\u000f\u0001UAQ\u0001\b\u0001\u0005\u0002uAq\u0001\t\u0001C\u0002\u0013\u0005\u0011\u0005\u0003\u0004)\u0001\u0001\u0006IA\t\u0005\bS\u0001\u0011\r\u0011\"\u0001+\u0011\u0019\t\u0004\u0001)A\u0005W!)!\u0007\u0001C!g!)\u0011\n\u0001C\u0001\u0015\")q\n\u0001C\u0001\u0015\")\u0011\u000b\u0001C\u0001\u0015\")1\u000b\u0001C\u0001\u0015\")Q\u000b\u0001C\u0005-\")1\u0010\u0001C\u0005y\nQ\"l\u001b+f]\u0006tGoQ8oiJ|G.T1oC\u001e,'\u000fV3ti*\u0011q\u0002E\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005E\u0011\u0012!B6bM.\f'\"A\n\u0002\u0017%tG/Z4sCRLwN\\\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001855\t\u0001D\u0003\u0002\u00103)\t\u0011#\u0003\u0002\u001c1\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005q\u0002CA\u0010\u0001\u001b\u0005q\u0011aB2p]R,\u0007\u0010^\u000b\u0002EA\u00111EJ\u0007\u0002I)\u0011Q%G\u0001\u000bG>tGO]8mY\u0016\u0014\u0018BA\u0014%\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u0001\tG>tG/\u001a=uA\u0005\t\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\u0016\u0003-\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012Qa\u00155peR\f!C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sA\u0005)1/\u001a;VaR\u0011Ag\u000e\t\u0003YUJ!AN\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0006q\u0019\u0001\r!O\u0001\ti\u0016\u001cH/\u00138g_B\u0011!hQ\u0007\u0002w)\u0011A(P\u0001\u0004CBL'B\u0001 @\u0003\u001dQW\u000f]5uKJT!\u0001Q!\u0002\u000b),h.\u001b;\u000b\u0003\t\u000b1a\u001c:h\u0013\t!5H\u0001\u0005UKN$\u0018J\u001c4pQ\t1a\t\u0005\u0002;\u000f&\u0011\u0001j\u000f\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0006;fgR\f5o]5h]R+g.\u00198u\u0007\u0016dG\u000eF\u00015Q\t9A\n\u0005\u0002;\u001b&\u0011aj\u000f\u0002\u0005)\u0016\u001cH/\u0001\u0010uKN$\u0018i]:jO:$VM\\1oi\u000e+G\u000e\\#ya2L7-\u001b;ms\"\u0012\u0001\u0002T\u0001\u0011i\u0016\u001cH\u000fR3mKR,G+\u001a8b]RD#!\u0003'\u0002!Q,7\u000f^\"sK\u0006$X\rV3oC:$\bF\u0001\u0006M\u0003)\u0019'/Z1uK\u000e+G\u000e\u001c\u000b\u0007/\u0002,'o^=\u0011\u0005asV\"A-\u000b\u0005i[\u0016AB2p[6|gN\u0003\u0002\u00129*\u0011Q,Q\u0001\u0007CB\f7\r[3\n\u0005}K&\u0001B\"fY2DQ!Y\u0006A\u0002\t\faaY3mY&#\u0007C\u0001\u0017d\u0013\t!WFA\u0002J]RDQAZ\u0006A\u0002\u001d\fqA\u0019:pW\u0016\u00148\u000fE\u0002i_\nt!![7\u0011\u0005)lS\"A6\u000b\u00051$\u0012A\u0002\u001fs_>$h(\u0003\u0002o[\u00051\u0001K]3eK\u001aL!\u0001]9\u0003\u0007M+GO\u0003\u0002o[!)1o\u0003a\u0001i\u0006)1\u000f^1uKB\u0011\u0001,^\u0005\u0003mf\u0013\u0011bQ3mYN#\u0018\r^3\t\u000ba\\\u0001\u0019A\u0016\u0002\u000f5LgnU5{K\")!p\u0003a\u0001W\u00059Q.\u0019=TSj,\u0017aC6bM.\f7i\u001c8gS\u001e$\u0012! \t\u0003/yL!a \r\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a")
public class ZkTenantControlManagerTest
extends QuorumTestHarness {
    private final ControllerContext context = new ControllerContext();
    private final short replicationFactor = (short)3;

    public ControllerContext context() {
        return this.context;
    }

    public short replicationFactor() {
        return this.replicationFactor;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.zkClient().createControllerEpochRaw(1);
    }

    @Test
    public void testAssignTenantCell() {
        ControllerContext context = new ControllerContext();
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), context, (Time)new MockTime(0L, 0L), this.kafkaConfig(), new Random(0), this.replicationFactor());
        ZkTenantControlManager tenantControl = new ZkTenantControlManager(this.zkClient(), cellControl, context, this.kafkaConfig(), this.replicationFactor());
        String tenantId = "lkc-abcd";
        int cellId = 0;
        int secondCellId = 1;
        cellControl.createCell(cellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), CellState.READY, (short)3, (short)6);
        cellControl.createCell(secondCellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), CellState.READY, (short)3, (short)6);
        cellControl.fullUpdateCellLoadCache(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CellLoad[]{new CellLoad(cellId, 0.3), new CellLoad(secondCellId, 0.5)}))).asJava(), 0L);
        Assertions.assertThrows(ResourceNotFoundException.class, () -> tenantControl.getOrCreateTenantToCellAssignment(tenantId, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), false));
        tenantControl.getOrCreateTenantToCellAssignment(tenantId, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), false);
        Assertions.assertEquals((Object)new Some((Object)this.createCell(cellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.READY, (short)3, (short)6)), (Object)tenantControl.getTenantCell(tenantId));
        tenantControl.deleteTenant(tenantId);
        tenantControl.getOrCreateTenantToCellAssignment(tenantId, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), true);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)tenantControl.getTenantCell(tenantId));
        Cell expectedCell = this.createCell(cellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.READY, (short)3, (short)6);
        Assertions.assertEquals((Object)expectedCell, (Object)tenantControl.getOrCreateTenantToCellAssignment(tenantId, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5})), false));
        Assertions.assertEquals((Object)new Some((Object)expectedCell), (Object)tenantControl.getTenantCell(tenantId));
    }

    @Test
    public void testAssignTenantCellExplicitly() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        ZkTenantControlManager tenantControl = new ZkTenantControlManager(this.zkClient(), cellControl, this.context(), this.kafkaConfig(), this.replicationFactor());
        String tenantId = "lkc-abcd";
        int cellId = 0;
        cellControl.createCell(cellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), CellState.READY, (short)3, (short)6);
        Assertions.assertThrows(CellNotFoundException.class, () -> tenantControl.assignTenantToCell(tenantId, 1, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), true));
        tenantControl.createTenant(tenantId, cellId);
        Assertions.assertEquals((Object)new Some((Object)this.createCell(cellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.READY, (short)3, (short)6)), (Object)tenantControl.getTenantCell(tenantId));
        int secondCellId = 1;
        cellControl.createCell(secondCellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), CellState.QUARANTINED, (short)3, (short)6);
        int thirdCellId = 2;
        cellControl.createCell(thirdCellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6, 7, 8})), CellState.QUARANTINED, (short)3, (short)6);
        Assertions.assertThrows(InvalidRequestException.class, () -> tenantControl.assignTenantToCell(tenantId, secondCellId, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), false));
        Assertions.assertThrows(InvalidRequestException.class, () -> tenantControl.assignTenantToCell(tenantId, thirdCellId, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), false));
        scala.collection.immutable.Set clusterBrokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8}));
        cellControl.updateCellMetadata(cellId, CellState.EXCLUDED, (short)3, (short)6, clusterBrokers);
        cellControl.updateCellMetadata(secondCellId, CellState.READY, (short)3, (short)6, clusterBrokers);
        tenantControl.assignTenantToCell(tenantId, secondCellId, clusterBrokers, false);
        Assertions.assertEquals((Object)new Some((Object)this.createCell(secondCellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5}))), CellState.READY, (short)3, (short)6)), (Object)tenantControl.getTenantCell(tenantId));
        cellControl.updateCellMetadata(secondCellId, CellState.QUARANTINED, (short)3, (short)6, clusterBrokers);
        Assertions.assertThrows(InvalidRequestException.class, () -> tenantControl.assignTenantToCell(tenantId, cellId, clusterBrokers, false));
        tenantControl.assignTenantToCell(tenantId, cellId, clusterBrokers, true);
        tenantControl.assignTenantToCell(tenantId, thirdCellId, clusterBrokers, true);
        cellControl.updateCellMetadata(thirdCellId, CellState.EXCLUDED, (short)3, (short)6, clusterBrokers);
        tenantControl.assignTenantToCell(tenantId, secondCellId, clusterBrokers, true);
        Assertions.assertEquals((Object)new Some((Object)this.createCell(secondCellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5}))), CellState.QUARANTINED, (short)3, (short)6)), (Object)tenantControl.getTenantCell(tenantId));
    }

    @Test
    public void testDeleteTenant() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        ZkTenantControlManager tenantControl = new ZkTenantControlManager(this.zkClient(), cellControl, this.context(), this.kafkaConfig(), this.replicationFactor());
        String tenantId = "lkc-abcd";
        int cellId = 0;
        cellControl.createCell(cellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), CellState.READY, (short)3, (short)6);
        tenantControl.createTenant(tenantId, cellId);
        tenantControl.deleteTenant(tenantId);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)tenantControl.getTenantCell(tenantId));
    }

    @Test
    public void testCreateTenant() {
        ZkCellControlManager cellControl = new ZkCellControlManager(this.zkClient(), this.context(), Time.SYSTEM, this.kafkaConfig(), new Random(0), this.replicationFactor());
        ZkTenantControlManager tenantControl = new ZkTenantControlManager(this.zkClient(), cellControl, this.context(), this.kafkaConfig(), this.replicationFactor());
        String tenantId = "lkc-abcd";
        int cellId = 0;
        cellControl.createCell(cellId, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), CellState.READY, (short)3, (short)6);
        tenantControl.createTenant(tenantId, cellId);
        Assertions.assertThrows(InvalidRequestException.class, () -> tenantControl.createTenant(tenantId, cellId));
        Assertions.assertEquals((Object)new Some((Object)this.createCell(cellId, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.READY, (short)3, (short)6)), (Object)tenantControl.getTenantCell(tenantId));
    }

    private Cell createCell(int cellId, scala.collection.immutable.Set<Object> brokers, CellState state, short minSize, short maxSize) {
        return new Cell(cellId, CollectionConverters$.MODULE$.SetHasAsJava((Set)brokers.map((Function1 & Serializable)x -> ZkTenantControlManagerTest.$anonfun$createCell$1(BoxesRunTime.unboxToInt((Object)x)))).asJava(), state, minSize, maxSize);
    }

    private KafkaConfig kafkaConfig() {
        boolean apply_doLog = true;
        Properties apply_props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnectOrNull(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        return new KafkaConfig((Map)apply_props, apply_doLog);
    }

    public static final /* synthetic */ Integer $anonfun$createCell$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }
}

