/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.tier;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.tier.state.TierPartitionState;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005ea\u0001B\t\u0013\u0001eAQ!\t\u0001\u0005\u0002\tBQ!\n\u0001\u0005R\u0019BQ!\f\u0001\u0005\n9BqA\r\u0001C\u0002\u0013%1\u0007\u0003\u0004=\u0001\u0001\u0006I\u0001\u000e\u0005\b{\u0001\u0011\r\u0011\"\u0003'\u0011\u0019q\u0004\u0001)A\u0005O!)q\b\u0001C\u0005\u0001\"9\u0001\f\u0001b\u0001\n\u0003I\u0006B\u00023\u0001A\u0003%!\fC\u0003f\u0001\u0011\u0005c\rC\u0003w\u0001\u0011\u0005c\u0006C\u0003|\u0001\u0011\u0005a\u0006C\u0004\u0002\u0002\u0001!I!a\u0001\t\r\u0005U\u0001\u0001\"\u0003/\u0011\u0019\t9\u0002\u0001C\u0005]\t)C+[3s\u0007>l\u0007/Y2uS>t7i\\7qC\u000e$H)\u001a7fi\u0016\u001cFO]3tgR+7\u000f\u001e\u0006\u0003'Q\tA\u0001^5fe*\u0011QCF\u0001\u0006W\u000647.\u0019\u0006\u0002/\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0007\u0001\u0019\"\u0001\u0001\u000e\u0011\u0005myR\"\u0001\u000f\u000b\u0005uq\u0012aA1qS*\tQ#\u0003\u0002!9\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002GA\u0011A\u0005A\u0007\u0002%\u0005Y!M]8lKJ\u001cu.\u001e8u+\u00059\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#aA%oi\u0006i1m\u001c8gS\u001e,(/Z'pG.$\u0012a\f\t\u0003QAJ!!M\u0015\u0003\tUs\u0017\u000e^\u0001\u0006i>\u0004\u0018nY\u000b\u0002iA\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\u0005Y\u0006twMC\u0001:\u0003\u0011Q\u0017M^1\n\u0005m2$AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\u0018a\u00039beRLG/[8og\u0002\nq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn]\u000b\u0002\u0003B\u0019!IS'\u000f\u0005\rCeB\u0001#H\u001b\u0005)%B\u0001$\u0019\u0003\u0019a$o\\8u}%\t!&\u0003\u0002JS\u00059\u0001/Y2lC\u001e,\u0017BA&M\u0005\r\u0019V-\u001d\u0006\u0003\u0013&\u0002\"A\u0014,\u000e\u0003=S!\u0001U)\u0002\r\r|W.\\8o\u0015\t)\"K\u0003\u0002T)\u00061\u0011\r]1dQ\u0016T\u0011!V\u0001\u0004_J<\u0017BA,P\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fa!\u001a=ji\u0016$W#\u0001.\u0011\u0005m\u0013W\"\u0001/\u000b\u0005us\u0016AB1u_6L7M\u0003\u0002`A\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u0005D\u0014\u0001B;uS2L!a\u0019/\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003\u001d)\u00070\u001b;fI\u0002\nQa]3u+B$\"aL4\t\u000b!\\\u0001\u0019A5\u0002\u0011Q,7\u000f^%oM>\u0004\"A\u001b9\u000e\u0003-T!!\b7\u000b\u00055t\u0017a\u00026va&$XM\u001d\u0006\u0003_R\u000bQA[;oSRL!!]6\u0003\u0011Q+7\u000f^%oM>D#aC:\u0011\u0005)$\u0018BA;l\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u0012A\u0002\u001f\t\u0003UfL!A_6\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017a\u0006;fgR\u001cFO]3tg\u000e{W\u000e]1di\u0012+G.\u001a;fQ\tiQ\u0010\u0005\u0002k}&\u0011qp\u001b\u0002\u0005)\u0016\u001cH/A\nqe>$WoY3LKf,GMU3d_J$7\u000fF\u00020\u0003\u000bAq!a\u0002\u000f\u0001\u0004\tI!A\u0005lKf4\u0016\r\\;fgB)!)a\u0003\u0002\u0010%\u0019\u0011Q\u0002'\u0003\t1K7\u000f\u001e\t\u0006Q\u0005EqeJ\u0005\u0004\u0003'I#A\u0002+va2,''A\u0012xC&$XK\u001c;jYN+w-\\3oiN$\u0016.\u001a:fI\u0006sGmQ8na\u0006\u001cG/\u001a3\u0002\u001dY\fG.\u001b3bi\u0016,%O]8sg\u0002")
public class TierCompactionCompactDeleteStressTest
extends IntegrationTestHarness {
    private final String topic;
    private final int partitions;
    private final AtomicBoolean exited;

    @Override
    public int brokerCount() {
        return 3;
    }

    private void configureMock() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
    }

    private String topic() {
        return this.topic;
    }

    private int partitions() {
        return this.partitions;
    }

    private Seq<TopicPartition> topicPartitions() {
        return package$.MODULE$.Range().apply(0, this.partitions()).map((Function1 & Serializable)p -> TierCompactionCompactDeleteStressTest.$anonfun$topicPartitions$1(this, BoxesRunTime.unboxToInt((Object)p)));
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    @Test
    public void testStressCompactDelete() {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "30000");
        props.put("confluent.tier.local.hotset.bytes", "0");
        props.put("retention.bytes", "50000");
        props.put("cleanup.policy", "compact,delete");
        props.put("confluent.tier.cleaner.enable", "true");
        props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(1.0E-4));
        this.createTopic(this.topic(), this.partitions(), 3, props, this.createTopic$default$5(), this.createTopic$default$6());
        int nRecords = 100000;
        Random random = new Random();
        List kvs = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nRecords).toList().map((Function1 & Serializable)i -> TierCompactionCompactDeleteStressTest.$anonfun$testStressCompactDelete$1(random, nRecords, BoxesRunTime.unboxToInt((Object)i)));
        this.produceKeyedRecords((List<Tuple2<Object, Object>>)kvs);
        this.waitUntilSegmentsTieredAndCompacted();
        this.validateErrors();
    }

    private void produceKeyedRecords(List<Tuple2<Object, Object>> keyValues) {
        try (KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());){
            keyValues.grouped(10).foreach((Function1 & Serializable)group -> group.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    int k = x0$1._1$mcI$sp();
                    int v = x0$1._2$mcI$sp();
                    long timestamp = System.currentTimeMillis();
                    return new ProducerRecord(this.topic(), null, Predef$.MODULE$.long2Long(timestamp), (Object)Integer.toString(k).getBytes(StandardCharsets.UTF_8), (Object)Integer.toString(v).getBytes(StandardCharsets.UTF_8));
                }
                throw new MatchError(null);
            }).map((Function1 & Serializable)x$1 -> producer.send(x$1)).map((Function1 & Serializable)x$3 -> (RecordMetadata)x$3.get(10L, TimeUnit.SECONDS)));
        }
    }

    private void waitUntilSegmentsTieredAndCompacted() {
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionCompactDeleteStressTest.$anonfun$waitUntilSegmentsTieredAndCompacted$1(this, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void validateErrors() {
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionCompactDeleteStressTest.$anonfun$validateErrors$1(this, tp);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ TopicPartition $anonfun$topicPartitions$1(TierCompactionCompactDeleteStressTest $this, int p) {
        return new TopicPartition($this.topic(), p);
    }

    public static final /* synthetic */ Tuple2 $anonfun$testStressCompactDelete$1(Random random$1, int nRecords$1, int i) {
        return new Tuple2.mcII.sp(random$1.nextInt(nRecords$1 / 10), i);
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilSegmentsTieredAndCompacted$3(TierPartitionState tierPartitionState$1, AbstractLog log$1) {
        tierPartitionState$1.flush();
        CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState$1.segments()).asScala().foreach((Function1 & Serializable)seg -> {
            Predef$.MODULE$.assert(!seg.metadata().hasAbortedTxns() && seg.metadata().hasEpochState() && seg.metadata().hasProducerState());
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)tierPartitionState$1.status().hasError());
        return log$1.tierableLogSegments().isEmpty() && log$1.localLogSegments().size() == 1 && tierPartitionState$1.compactDirtyStartOffset() > tierPartitionState$1.endOffset() && tierPartitionState$1.endOffset() == tierPartitionState$1.committedEndOffset();
    }

    public static final /* synthetic */ String $anonfun$waitUntilSegmentsTieredAndCompacted$5(AbstractLog log$1, TierPartitionState tierPartitionState$1) {
        return new StringBuilder(185).append("timeout waiting for tier partition state to contain a single segment.").append(" tierable segments: ").append(log$1.tierableLogSegments()).append(",").append(" local segments ").append(log$1.localLogSegments()).append(",").append(" tiered segments: ").append(CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState$1.segments()).asScala().toList()).append(",").append(" end offset: ").append(tierPartitionState$1.endOffset()).append(",").append(" committed end offset: ").append(tierPartitionState$1.committedEndOffset()).append(",").append(" dirty start offset: ").append(tierPartitionState$1.compactDirtyStartOffset()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTieredAndCompacted$2(TopicPartition tp$1, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(tp$1, x$2).get();
        TierPartitionState tierPartitionState = log.tierPartitionState();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 90000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionCompactDeleteStressTest.$anonfun$waitUntilSegmentsTieredAndCompacted$3(tierPartitionState, log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierCompactionCompactDeleteStressTest.$anonfun$waitUntilSegmentsTieredAndCompacted$5(log, tierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState.segments()).asScala().foreach((Function1 & Serializable)seg -> {
            Predef$.MODULE$.assert(!seg.metadata().hasAbortedTxns() && seg.metadata().hasEpochState() && seg.metadata().hasProducerState());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTieredAndCompacted$1(TierCompactionCompactDeleteStressTest $this, TopicPartition tp) {
        $this.servers().foreach((Function1 & Serializable)server -> {
            TierCompactionCompactDeleteStressTest.$anonfun$waitUntilSegmentsTieredAndCompacted$2(tp, server);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$validateErrors$2(TopicPartition tp$2, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Assertions.assertFalse((boolean)((AbstractLog)qual$1.getLog(tp$2, x$2).get()).tierPartitionState().status().hasError());
    }

    public static final /* synthetic */ int $anonfun$validateErrors$3(Attribute attr) {
        return BoxesRunTime.unboxToInt((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$validateErrors$4(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$validateErrors$5(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ void $anonfun$validateErrors$1(TierCompactionCompactDeleteStressTest $this, TopicPartition tp) {
        $this.servers().foreach((Function1 & Serializable)server -> {
            TierCompactionCompactDeleteStressTest.$anonfun$validateErrors$2(tp, server);
            return BoxedUnit.UNIT;
        });
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        int partitionsTaskInError = BoxesRunTime.unboxToInt((Object)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks:type=TierTasks,name=NumPartitionsInError"), new String[]{"Value"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToInteger((int)TierCompactionCompactDeleteStressTest.$anonfun$validateErrors$3(attr)))).head());
        Assertions.assertEquals((int)0, (int)partitionsTaskInError, (String)"task shows no partitions in error state");
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.log:type=CleanerStats,name=CompactionThroughputBytesPerSec,op=read,form=tier"), new String[]{"MeanRate"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToDouble((double)TierCompactionCompactDeleteStressTest.$anonfun$validateErrors$4(attr)))).head()) > 0.0 ? 1 : 0) != 0, (String)"Compaction read throughput should be > 0");
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.log:type=CleanerStats,name=CompactionThroughputBytesPerSec,op=write,form=tier"), new String[]{"MeanRate"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToDouble((double)TierCompactionCompactDeleteStressTest.$anonfun$validateErrors$5(attr)))).head()) > 0.0 ? 1 : 0) != 0, (String)"Compaction write throughput should be > 0");
    }

    public TierCompactionCompactDeleteStressTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerFeatureEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "3");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "3");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerCompactMinEfficiencyProp(), "0.001");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFetcherMemoryPoolSizeBytesProp(), Integer.toString(0x100000));
        this.configureMock();
        this.topic = "test_topic";
        this.partitions = 1;
        this.exited = new AtomicBoolean(false);
    }
}

