/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.tier;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogLoader$;
import kafka.log.LogManager;
import kafka.server.Defaults$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tier.client.TierTopicConsumerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u000514A\u0001C\u0005\u0001!!)q\u0003\u0001C\u00011!91\u0004\u0001b\u0001\n\u0003a\u0002BB\u0012\u0001A\u0003%Q\u0004C\u0004%\u0001\t\u0007I\u0011A\u0013\t\r9\u0002\u0001\u0015!\u0003'\u0011\u0015y\u0003\u0001\"\u00111\u0011\u0015i\u0004\u0001\"\u0001?\u0005%\"\u0016.\u001a:U_BL7\rR1uC2{7o\u001d,bY&$\u0017\r^8s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011!bC\u0001\u0005i&,'O\u0003\u0002\r\u001b\u0005)1.\u00194lC*\ta\"A\u0006j]R,wM]1uS>t7\u0001A\n\u0003\u0001E\u0001\"AE\u000b\u000e\u0003MQ!A\u0004\u000b\u000b\u00031I!AF\n\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A\r\u0011\u0005i\u0001Q\"A\u0005\u0002\u00159,XN\u0011:pW\u0016\u00148/F\u0001\u001e!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\rIe\u000e^\u0001\f]Vl'I]8lKJ\u001c\b%A\bpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9t+\u00051\u0003CA\u0014-\u001b\u0005A#BA\u0015+\u0003\u0011)H/\u001b7\u000b\u0003-\nAA[1wC&\u0011Q\u0006\u000b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001E8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:!\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#A\u0019\u0011\u0007I*t'D\u00014\u0015\t!t$\u0001\u0006d_2dWm\u0019;j_:L!AN\u001a\u0003\u0007M+\u0017\u000f\u0005\u00029w5\t\u0011H\u0003\u0002;)\u000511/\u001a:wKJL!\u0001P\u001d\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u001fi\u0016\u001cH\u000fV5feR{\u0007/[2ECR\fGj\\:t\t\u0016$Xm\u0019;j_:$\"a\u0010\"\u0011\u0005y\u0001\u0015BA! \u0005\u0011)f.\u001b;\t\u000b\r;\u0001\u0019\u0001#\u0002\rE,xN];n!\t)EJ\u0004\u0002G\u0015B\u0011qiH\u0007\u0002\u0011*\u0011\u0011jD\u0001\u0007yI|w\u000e\u001e \n\u0005-{\u0012A\u0002)sK\u0012,g-\u0003\u0002N\u001d\n11\u000b\u001e:j]\u001eT!aS\u0010)\t\u001d\u0001fl\u0018\t\u0003#rk\u0011A\u0015\u0006\u0003'R\u000b\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003+Z\u000ba\u0001]1sC6\u001c(BA,Y\u0003\u001dQW\u000f]5uKJT!!\u0017.\u0002\u000b),h.\u001b;\u000b\u0003m\u000b1a\u001c:h\u0013\ti&KA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0003A\n\f\u0013!Y\u0001\u0003u.\f\u0013aY\u0001\u0006WJ\fg\r\u001e\u0015\u0005\u000f\u0015L'\u000e\u0005\u0002gO6\tA+\u0003\u0002i)\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0002W\u0006A2\u0010Z5ta2\f\u0017PT1nKvt\u0013/^8sk6l4\u0010M?")
public class TierTopicDataLossValidatorIntegrationTest
extends KafkaServerTestHarness {
    private final int numBrokers;
    private final Properties overridingProps = new Properties();

    public int numBrokers() {
        return this.numBrokers;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numBrokers(), this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTierTopicDataLossDetection(String quorum) {
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$1(broker);
            return BoxedUnit.UNIT;
        });
        Properties userTopicConfig = new Properties();
        userTopicConfig.put("confluent.tier.enable", "true");
        userTopicConfig.put("cleanup.policy", "delete");
        userTopicConfig.put("retention.ms", "-1");
        userTopicConfig.put("retention.bytes", "-1");
        userTopicConfig.put("min.insync.replicas", "2");
        String topic = "foo-data-loss-detection";
        int x$3 = this.numBrokers();
        int x$4 = this.createTopic$default$2();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(topic, x$4, x$3, userTopicConfig, x$5, x$6);
        TopicPartition userTopicPartition = new TopicPartition(topic, 0);
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$4(userTopicPartition, broker);
            return BoxedUnit.UNIT;
        });
        this.killAllBrokers();
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$9(broker);
            return BoxedUnit.UNIT;
        });
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$10(broker);
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$13(userTopicPartition, broker);
            return BoxedUnit.UNIT;
        });
        this.killAllBrokers();
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$19(broker);
            return BoxedUnit.UNIT;
        });
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$20(broker);
            return BoxedUnit.UNIT;
        });
        TierTopicManagerConfig config = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1())), "", (short)1, Defaults$.MODULE$.TierMetadataReplicationFactor(), -1, "unknown", Predef$.MODULE$.long2Long(Defaults$.MODULE$.TierMetadataMaxPollMs()), Predef$.MODULE$.int2Integer(Defaults$.MODULE$.TierMetadataRequestTimeoutMs()), Defaults$.MODULE$.TierPartitionStateCommitInterval(), Collections.singletonList(TestUtils.tempDirectory(null, null).getAbsolutePath()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicProducerEnableIdempotence()), Predef$.MODULE$.boolean2Boolean(true), Predef$.MODULE$.boolean2Boolean(true));
        Consumer verificationConsumer = new TierTopicConsumerSupplier(config, "primary").get();
        Set tierTopicPartitions = TierTopicManager.partitions((String)"_confluent-tier-state", (int)1);
        verificationConsumer.assign((Collection)tierTopicPartitions);
        tierTopicPartitions.forEach(tp -> verificationConsumer.seekToBeginning(Collections.singletonList(tp)));
        ListBuffer records = new ListBuffer();
        Long endOffset = (Long)verificationConsumer.endOffsets((Collection)tierTopicPartitions).entrySet().iterator().next().getValue();
        LongRef consumedOffset = LongRef.create((long)-1L);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$25(verificationConsumer, config, records, consumedOffset, endOffset)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$26());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        verificationConsumer.close();
        IntRef numFencingEvents = IntRef.create((int)0);
        records.foreach((Function1 & Serializable)record -> {
            TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$27(userTopicPartition, numFencingEvents, record);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((numFencingEvents.elem > 3 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ String $anonfun$testTierTopicDataLossDetection$3() {
        return "timed out waiting for TierTopicManager to be ready";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testTierTopicDataLossDetection$1(KafkaBroker broker) {
        TierTopicManager tierTopicManager = (TierTopicManager)broker.tierTopicManagerOpt().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!tierTopicManager.isReadyForWrites()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicDataLossDetection$5(KafkaBroker broker$1, TopicPartition userTopicPartition$1) {
        boolean x$8;
        LogManager qual$1 = broker$1.logManager();
        Option partitionState = qual$1.getLog(userTopicPartition$1, x$8 = qual$1.getLog$default$2()).map((Function1 & Serializable)x$2 -> x$2.tierPartitionState());
        return partitionState.isDefined() && ((TierPartitionState)partitionState.get()).topicIdPartition().isPresent() && ((TierPartitionState)partitionState.get()).tierEpoch() == 0;
    }

    public static final /* synthetic */ String $anonfun$testTierTopicDataLossDetection$7() {
        return "InitLeader event not materialized.";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testTierTopicDataLossDetection$4(TopicPartition userTopicPartition$1, KafkaBroker broker) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$5(broker, userTopicPartition$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$2 = broker.logManager();
        boolean x$10 = qual$2.getLog$default$2();
        OffsetAndEpoch materializedOffsetAndEpoch = ((AbstractLog)qual$2.getLog(userTopicPartition$1, x$10).get()).tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((long)0L, (long)materializedOffsetAndEpoch.offset());
        Assertions.assertEquals((int)0, (Integer)materializedOffsetAndEpoch.epoch().orElseGet(() -> Predef$.MODULE$.int2Integer(-1)));
    }

    public static final /* synthetic */ void $anonfun$testTierTopicDataLossDetection$9(KafkaBroker broker) {
        Assertions.assertTrue((boolean)Files.deleteIfExists(new File((String)broker.config().logDirs().last(), LogLoader$.MODULE$.CleanShutdownFile()).toPath()));
    }

    public static final /* synthetic */ String $anonfun$testTierTopicDataLossDetection$12() {
        return "timed out waiting for TierTopicManager to be ready";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testTierTopicDataLossDetection$10(KafkaBroker broker) {
        TierTopicManager tierTopicManager = (TierTopicManager)broker.tierTopicManagerOpt().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 300000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!tierTopicManager.isReadyForWrites()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$12());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertFalse((boolean)broker.logManager().hadCleanShutdown());
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicDataLossDetection$14(KafkaBroker broker$2, TopicPartition userTopicPartition$1) {
        boolean x$12;
        LogManager qual$3 = broker$2.logManager();
        Option partitionState = qual$3.getLog(userTopicPartition$1, x$12 = qual$3.getLog$default$2()).map((Function1 & Serializable)x$3 -> x$3.tierPartitionState());
        return partitionState.isDefined() && ((TierPartitionState)partitionState.get()).topicIdPartition().isPresent() && ((TierPartitionState)partitionState.get()).tierEpoch() > 0;
    }

    public static final /* synthetic */ String $anonfun$testTierTopicDataLossDetection$16() {
        return "New initLeader event not materialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicDataLossDetection$17(KafkaBroker broker$2, TopicPartition userTopicPartition$1) {
        LogManager qual$4 = broker$2.logManager();
        boolean x$14 = qual$4.getLog$default$2();
        TierPartitionStatus tierPartitionStatus = ((AbstractLog)qual$4.getLog(userTopicPartition$1, x$14).get()).tierPartitionState().status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testTierTopicDataLossDetection$18() {
        return "FTPS status is not online.";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testTierTopicDataLossDetection$13(TopicPartition userTopicPartition$1, KafkaBroker broker) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$14(broker, userTopicPartition$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$16());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$17(broker, userTopicPartition$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$18());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testTierTopicDataLossDetection$19(KafkaBroker broker) {
        void logFile_suffix;
        void timeIndexFile_suffix;
        void offsetIndexFile_suffix;
        String logDir = (String)broker.config().logDirs().last();
        Assertions.assertTrue((boolean)Files.deleteIfExists(new File(logDir, LogLoader$.MODULE$.CleanShutdownFile()).toPath()));
        File tierTopicPartitionDir = new File(new StringBuilder(24).append(logDir).append("/").append("_confluent-tier-state").append("-0").toString());
        String string = "";
        long offsetIndexFile_offset = 0L;
        string = null;
        Assertions.assertTrue((boolean)Files.deleteIfExists(LogFileUtils.offsetIndexFile((File)tierTopicPartitionDir, (long)offsetIndexFile_offset, (String)offsetIndexFile_suffix).toPath()));
        String string2 = "";
        long timeIndexFile_offset = 0L;
        string2 = null;
        Assertions.assertTrue((boolean)Files.deleteIfExists(LogFileUtils.timeIndexFile((File)tierTopicPartitionDir, (long)timeIndexFile_offset, (String)timeIndexFile_suffix).toPath()));
        String string3 = "";
        long logFile_offset = 0L;
        string3 = null;
        Assertions.assertTrue((boolean)Files.deleteIfExists(LogFileUtils.logFile((File)tierTopicPartitionDir, (long)logFile_offset, (String)logFile_suffix).toPath()));
    }

    public static final /* synthetic */ String $anonfun$testTierTopicDataLossDetection$22() {
        return "timed out waiting for TierTopicManager to be ready";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testTierTopicDataLossDetection$20(KafkaBroker broker) {
        TierTopicManager tierTopicManager = (TierTopicManager)broker.tierTopicManagerOpt().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 300000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!tierTopicManager.isReady()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$22());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicDataLossDetection$25(Consumer verificationConsumer$1, TierTopicManagerConfig config$1, ListBuffer records$1, LongRef consumedOffset$1, Long endOffset$1) {
        for (ConsumerRecord record : verificationConsumer$1.poll(config$1.pollDuration)) {
            records$1.$plus$eq((Object)record);
            consumedOffset$1.elem = record.offset();
        }
        return consumedOffset$1.elem >= Predef$.MODULE$.Long2long(endOffset$1) - 1L;
    }

    public static final /* synthetic */ String $anonfun$testTierTopicDataLossDetection$26() {
        return "Timed out fetching record";
    }

    public static final /* synthetic */ void $anonfun$testTierTopicDataLossDetection$27(TopicPartition userTopicPartition$1, IntRef numFencingEvents$1, ConsumerRecord record) {
        Optional eventOpt = AbstractTierMetadata.deserialize((byte[])((byte[])record.key()), (byte[])((byte[])record.value()), (long)record.timestamp());
        Assertions.assertTrue((boolean)eventOpt.isPresent());
        if (TierRecordType.PartitionFence.equals(((AbstractTierMetadata)eventOpt.get()).type()) && userTopicPartition$1.equals((Object)((AbstractTierMetadata)eventOpt.get()).topicIdPartition().topicPartition())) {
            ++numFencingEvents$1.elem;
            return;
        }
    }

    public TierTopicDataLossValidatorIntegrationTest() {
        this.numBrokers = 3;
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "3");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierTopicDataLossDetectionEnableProp(), "true");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierTopicFencingDuringDataLossEnableProp(), "true");
    }
}

