/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.tier.tools;

import com.fasterxml.jackson.core.JsonParseException;
import integration.kafka.tier.tools.TierPartitionStateRestoreRawInputGeneratorTest$FenceOutput$;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import kafka.log.MergedLog$;
import kafka.restore.ResetTierPartitionState;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierPartitionStateRestoreRawInputGenerator;
import kafka.tier.tools.common.FenceEventInfo;
import kafka.tier.tools.common.RestoreInfo;
import kafka.utils.CoreUtils$;
import kafka.utils.checksum.Algorithm;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Matchers$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tmc\u0001B\u0015+\u0001MBQA\u000f\u0001\u0005\u0002mBQA\u0010\u0001\u0005\n}BQ!\u0016\u0001\u0005\nYCQ!\u0017\u0001\u0005\niCQ!\u0018\u0001\u0005\nyCQ\u0001\u001b\u0001\u0005\n%4a!a\u0007\u0001\u0001\u0006u\u0001BCA\u001c\u000f\tU\r\u0011\"\u0001\u0002:!I\u00111H\u0004\u0003\u0012\u0003\u0006I\u0001\u0011\u0005\u000b\u0003{9!Q3A\u0005\u0002\u0005}\u0002BCA&\u000f\tE\t\u0015!\u0003\u0002B!1!h\u0002C\u0001\u0003\u001bB\u0011\"a\u0016\b\u0003\u0003%\t!!\u0017\t\u0013\u0005}s!%A\u0005\u0002\u0005\u0005\u0004\"CA<\u000fE\u0005I\u0011AA=\u0011%\tihBA\u0001\n\u0003\ny\bC\u0005\u0002\u000e\u001e\t\t\u0011\"\u0001\u0002\u0010\"I\u0011qS\u0004\u0002\u0002\u0013\u0005\u0011\u0011\u0014\u0005\n\u0003K;\u0011\u0011!C!\u0003OC\u0011\"!.\b\u0003\u0003%\t!a.\t\u0013\u0005mv!!A\u0005B\u0005u\u0006\"CAa\u000f\u0005\u0005I\u0011IAb\u0011%\t)mBA\u0001\n\u0003\n9\rC\u0005\u0002J\u001e\t\t\u0011\"\u0011\u0002L\u001eI\u0011q\u001a\u0001\u0002\u0002#\u0005\u0011\u0011\u001b\u0004\n\u00037\u0001\u0011\u0011!E\u0001\u0003'DaA\u000f\u000e\u0005\u0002\u0005\u0015\b\"CAc5\u0005\u0005IQIAd\u0011%\t9OGA\u0001\n\u0003\u000bI\u000fC\u0005\u0002pj\t\t\u0011\"!\u0002r\"9\u0011q \u0001\u0005\n\t\u0005\u0001bBA\u0000\u0001\u0011%!q\u0002\u0005\b\u00057\u0001A\u0011\u0001B\u000f\u0011\u001d\u0011y\u0004\u0001C\u0001\u0005;AqAa\u0011\u0001\t\u0003\u0011i\u0002C\u0004\u0003H\u0001!\tA!\b\t\u000f\t-\u0003\u0001\"\u0001\u0003\u001e!9!q\n\u0001\u0005\u0002\tu\u0001b\u0002B*\u0001\u0011\u0005!Q\u0004\u0005\b\u0005/\u0002A\u0011\u0001B\u000f\u00059\"\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3SKN$xN]3SC^Le\u000e];u\u000f\u0016tWM]1u_J$Vm\u001d;\u000b\u0005-b\u0013!\u0002;p_2\u001c(BA\u0017/\u0003\u0011!\u0018.\u001a:\u000b\u0005=\u0002\u0014!B6bM.\f'\"A\u0019\u0002\u0017%tG/Z4sCRLwN\\\u0002\u0001'\t\u0001A\u0007\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdG\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0002\"!\u0010\u0001\u000e\u0003)\n\u0011d\u0019:fCR,gj\u001c8F[B$\u0018P\u00127vg\",GMR5mKR\u0019\u0001\t\u0013&\u0011\u0005\u00053U\"\u0001\"\u000b\u0005\r#\u0015AA5p\u0015\u0005)\u0015\u0001\u00026bm\u0006L!a\u0012\"\u0003\t\u0019KG.\u001a\u0005\u0006\u0013\n\u0001\r\u0001Q\u0001\ra\u0006\u0014H/\u001b;j_:$\u0015N\u001d\u0005\u0006\u0017\n\u0001\r\u0001T\u0001\nC2<wN]5uQ6\u0004\"!T*\u000e\u00039S!a\u0014)\u0002\u0011\rDWmY6tk6T!!\u0015*\u0002\u000bU$\u0018\u000e\\:\u000b\u0003=J!\u0001\u0016(\u0003\u0013\u0005cwm\u001c:ji\"l\u0017!G2sK\u0006$XMT8o\u000b6\u0004H/_'vi\u0006\u0014G.\u001a$jY\u0016$2\u0001Q,Y\u0011\u0015I5\u00011\u0001A\u0011\u0015Y5\u00011\u0001M\u0003y\u0019'/Z1uK:{g.R7qif\u0014Vm]3u\r2,8\u000f[3e\r&dW\rF\u0002A7rCQ!\u0013\u0003A\u0002\u0001CQa\u0013\u0003A\u00021\u000b!c\u0019:fCR,gj\u001c8F[B$\u0018PR5mKR)\u0001i\u00181bM\")\u0011*\u0002a\u0001\u0001\")1*\u0002a\u0001\u0019\")!-\u0002a\u0001G\u0006i\u0011n]'vi\u0006\u0014G.\u001a$jY\u0016\u0004\"!\u000e3\n\u0005\u00154$a\u0002\"p_2,\u0017M\u001c\u0005\u0006O\u0016\u0001\raY\u0001\fSN\u0014Vm]3u\r&dW-A\u0002sk:$RA[A\u0007\u0003/\u00012a\u001b8q\u001b\u0005a'BA7E\u0003\u0011)H/\u001b7\n\u0005=d'\u0001\u0002'jgR\u00042!]A\u0004\u001d\r\u0011\u0018\u0011\u0001\b\u0003gvt!\u0001^>\u000f\u0005UThB\u0001<z\u001b\u00059(B\u0001=3\u0003\u0019a$o\\8u}%\tq&\u0003\u0002.%&\u00111\u0006 \u0006\u0003[IK!A`@\u0002\r\r|W.\\8o\u0015\tYC0\u0003\u0003\u0002\u0004\u0005\u0015\u0011a\u0003*fgR|'/Z%oM>T!A`@\n\t\u0005%\u00111\u0002\u0002\u0010%\u0016\u001cHo\u001c:f%\u0006<\u0018J\u001c9vi*!\u00111AA\u0003\u0011\u001d\tyA\u0002a\u0001\u0003#\tqBZ3oG\u0016|U\u000f\u001e9vi\u001aKG.\u001a\t\u0005k\u0005M\u0001)C\u0002\u0002\u0016Y\u0012aa\u00149uS>t\u0007bBA\r\r\u0001\u0007\u0011\u0011C\u0001\be>|G\u000fR5s\u0005-1UM\\2f\u001fV$\b/\u001e;\u0014\r\u001d!\u0014qDA\u0013!\r)\u0014\u0011E\u0005\u0004\u0003G1$a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003O\t\tD\u0004\u0003\u0002*\u00055bb\u0001<\u0002,%\tq'C\u0002\u00020Y\nq\u0001]1dW\u0006<W-\u0003\u0003\u00024\u0005U\"\u0001D*fe&\fG.\u001b>bE2,'bAA\u0018m\u0005!a-\u001b7f+\u0005\u0001\u0015!\u00024jY\u0016\u0004\u0013AB3wK:$8/\u0006\u0002\u0002BA!1N\\A\"!\u0011\t)%a\u0012\u000e\u0005\u0005\u0015\u0011\u0002BA%\u0003\u000b\u0011aBR3oG\u0016,e/\u001a8u\u0013:4w.A\u0004fm\u0016tGo\u001d\u0011\u0015\r\u0005=\u00131KA+!\r\t\tfB\u0007\u0002\u0001!1\u0011q\u0007\u0007A\u0002\u0001Cq!!\u0010\r\u0001\u0004\t\t%\u0001\u0003d_BLHCBA(\u00037\ni\u0006\u0003\u0005\u000285\u0001\n\u00111\u0001A\u0011%\ti$\u0004I\u0001\u0002\u0004\t\t%\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\r$f\u0001!\u0002f-\u0012\u0011q\r\t\u0005\u0003S\n\u0019(\u0004\u0002\u0002l)!\u0011QNA8\u0003%)hn\u00195fG.,GMC\u0002\u0002rY\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)(a\u001b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m$\u0006BA!\u0003K\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAA!\u0011\t\u0019)!#\u000e\u0005\u0005\u0015%bAAD\t\u0006!A.\u00198h\u0013\u0011\tY)!\"\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t\nE\u00026\u0003'K1!!&7\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tY*!)\u0011\u0007U\ni*C\u0002\u0002 Z\u00121!\u00118z\u0011%\t\u0019KEA\u0001\u0002\u0004\t\t*A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003S\u0003b!a+\u00022\u0006mUBAAW\u0015\r\tyKN\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAZ\u0003[\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u00191-!/\t\u0013\u0005\rF#!AA\u0002\u0005m\u0015A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!!\u0002@\"I\u00111U\u000b\u0002\u0002\u0003\u0007\u0011\u0011S\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011S\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011Q\u0001\u0007KF,\u0018\r\\:\u0015\u0007\r\fi\rC\u0005\u0002$b\t\t\u00111\u0001\u0002\u001c\u0006Ya)\u001a8dK>+H\u000f];u!\r\t\tFG\n\u00065\u0005U\u0017\u0011\u001d\t\n\u0003/\fi\u000eQA!\u0003\u001fj!!!7\u000b\u0007\u0005mg'A\u0004sk:$\u0018.\\3\n\t\u0005}\u0017\u0011\u001c\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004cA!\u0002d&\u0019\u00111\u0007\"\u0015\u0005\u0005E\u0017!B1qa2LHCBA(\u0003W\fi\u000f\u0003\u0004\u00028u\u0001\r\u0001\u0011\u0005\b\u0003{i\u0002\u0019AA!\u0003\u001d)h.\u00199qYf$B!a=\u0002|B)Q'a\u0005\u0002vB1Q'a>A\u0003\u0003J1!!?7\u0005\u0019!V\u000f\u001d7fe!I\u0011Q \u0010\u0002\u0002\u0003\u0007\u0011qJ\u0001\u0004q\u0012\u0002\u0014!\u00024f]\u000e,G\u0003BA(\u0005\u0007AqA!\u0002 \u0001\u0004\u00119!\u0001\u0003ua&#\u0007\u0003\u0002B\u0005\u0005\u0017i\u0011\u0001`\u0005\u0004\u0005\u001ba(\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o)\u0011\tyE!\u0005\t\u000f\tM\u0001\u00051\u0001\u0003\u0016\u0005)A\u000f]%egB1\u0011q\u0005B\f\u0005\u000fIAA!\u0007\u00026\t\u00191+Z9\u00027Q,7\u000f\u001e$bS2,(/\u001a#vKR{W*[:tS:<\u0017I]4t)\t\u0011y\u0002E\u00026\u0005CI1Aa\t7\u0005\u0011)f.\u001b;)\u0007\u0005\u00129\u0003\u0005\u0003\u0003*\tmRB\u0001B\u0016\u0015\u0011\u0011iCa\f\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u00032\tM\u0012a\u00026va&$XM\u001d\u0006\u0005\u0005k\u00119$A\u0003kk:LGO\u0003\u0002\u0003:\u0005\u0019qN]4\n\t\tu\"1\u0006\u0002\u0005)\u0016\u001cH/A\u0012uKN$h)Y5mkJ,G)^3U_6K7o]5oOB\u000b'\u000f^5uS>tG)\u001b:)\u0007\t\u00129#A\u0016uKN$h)Y5mkJ,G)^3U_6K7o]5oO>\u0013X)\u001c9usRKWM]*uCR,g)\u001b7fQ\r\u0019#qE\u0001%i\u0016\u001cHOR1jYV\u0014X\rR;f)>lU\u000f^1cY\u0016$\u0016.\u001a:Ti\u0006$XMR5mK\"\u001aAEa\n\u0002UQ,7\u000f\u001e$bS2,(/\u001a#vKR{W*\u001e7uSBdWMV1mS\u0012$\u0016.\u001a:Ti\u0006$XMR5mK\"\u001aQEa\n\u0002EQ,7\u000f^*vG\u000e,7o\u001d#vKR{g+\u00197jIRKWM]*uCR,g)\u001b7fQ\r1#qE\u0001.i\u0016\u001cH/T;mi&\u0004H.\u001a)beRLG/[8og^KG\u000f\u001b,bY&$G+[3s'R\fG/\u001a$jY\u0016\u001c\bfA\u0014\u0003(\u0005yC/Z:u\u001bVdG/\u001b9mKB\u000b'\u000f^5uS>t7oV5uQ&sg/\u00197jIRKWM]*uCR,g)\u001b7fg\"\u001a\u0001Fa\n")
public class TierPartitionStateRestoreRawInputGeneratorTest {
    private volatile TierPartitionStateRestoreRawInputGeneratorTest$FenceOutput$ FenceOutput$module;

    public TierPartitionStateRestoreRawInputGeneratorTest$FenceOutput$ FenceOutput() {
        if (this.FenceOutput$module == null) {
            this.FenceOutput$lzycompute$1();
        }
        return this.FenceOutput$module;
    }

    private File createNonEmptyFlushedFile(File partitionDir, Algorithm algorithm) {
        return this.createNonEmptyFile(partitionDir, algorithm, false, false);
    }

    private File createNonEmptyMutableFile(File partitionDir, Algorithm algorithm) {
        return this.createNonEmptyFile(partitionDir, algorithm, true, false);
    }

    private File createNonEmptyResetFlushedFile(File partitionDir, Algorithm algorithm) {
        return this.createNonEmptyFile(partitionDir, algorithm, false, true);
    }

    private File createNonEmptyFile(File partitionDir, Algorithm algorithm, boolean isMutableFile, boolean isResetFile) {
        File file;
        File tierStateFile = MergedLog$.MODULE$.tierStateFile(partitionDir, 0L, "");
        Assertions.assertFalse((boolean)tierStateFile.exists());
        if (isMutableFile) {
            file = FileTierPartitionState.mutableFilePath((String)tierStateFile.getAbsolutePath(), (Algorithm)algorithm).toFile();
        } else {
            File flushedFile = FileTierPartitionState.flushedFilePath((String)tierStateFile.getAbsolutePath(), (Algorithm)algorithm).toFile();
            file = isResetFile ? new File(ResetTierPartitionState.outputFilePath((String)flushedFile.getAbsolutePath())) : flushedFile;
        }
        File file2 = file;
        Assertions.assertTrue((boolean)file2.createNewFile());
        PrintWriter pw = new PrintWriter(file2);
        pw.print("test");
        pw.close();
        return file2;
    }

    private java.util.List<RestoreInfo.RestoreRawInput> run(Option<File> fenceOutputFile, Option<File> rootDir2) {
        File outputFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        ArrayBuffer args = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        fenceOutputFile.foreach((Function1 & Serializable)file -> (ArrayBuffer)args.appendAll((IterableOnce)new .colon.colon((Object)RecoveryUtils.makeArgument((String)"fence.json"), (List)new .colon.colon((Object)file.getAbsolutePath(), (List)Nil$.MODULE$))));
        rootDir2.foreach((Function1 & Serializable)rootDir -> (ArrayBuffer)args.appendAll((IterableOnce)new .colon.colon((Object)RecoveryUtils.makeArgument((String)"restore.tier.state.root.dir"), (List)new .colon.colon((Object)rootDir.getAbsolutePath(), (List)Nil$.MODULE$))));
        args.appendAll((IterableOnce)new .colon.colon((Object)RecoveryUtils.makeArgument((String)"output.json"), (List)new .colon.colon((Object)outputFile.getAbsolutePath(), (List)Nil$.MODULE$)));
        TierPartitionStateRestoreRawInputGenerator.main((String[])((String[])args.toArray(ClassTag$.MODULE$.apply(String.class))));
        Assertions.assertTrue((boolean)outputFile.exists());
        Assertions.assertTrue((outputFile.length() > 0L ? 1 : 0) != 0);
        return RestoreInfo.RestoreRawInput.readJsonFromFile((Path)outputFile.toPath());
    }

    private FenceOutput fence(TopicIdPartition tpId) {
        return this.fence((scala.collection.immutable.Seq<TopicIdPartition>)new .colon.colon((Object)tpId, (List)Nil$.MODULE$));
    }

    private FenceOutput fence(scala.collection.immutable.Seq<TopicIdPartition> tpIds) {
        IntRef partition = IntRef.create((int)-1);
        java.util.List events = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)tpIds.map((Function1 & Serializable)tpId -> {
            ++partition$1.elem;
            return new FenceEventInfo(tpId.topic(), tpId.topicIdAsBase64(), tpId.partition(), CoreUtils$.MODULE$.uuidToBase64(UUID.randomUUID()), Predef$.MODULE$.boolean2Boolean(false), 0L, partition$1.elem, System.currentTimeMillis());
        })).asJava();
        File fenceResultJsonFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        String json = FenceEventInfo.listToJson((java.util.List)events);
        try (PrintWriter pw = new PrintWriter(fenceResultJsonFile);){
            pw.write(json);
        }
        return new FenceOutput(this, fenceResultJsonFile, events);
    }

    @Test
    public void testFailureDueToMissingArgs() {
        TopicIdPartition tpId = new TopicIdPartition("foo", UUID.randomUUID(), 27);
        FenceOutput fenceOutput = this.fence(tpId);
        File rootDir = TestUtils.tempDirectory(null, null);
        Assertions.assertTrue((boolean)Paths.get(rootDir.getAbsolutePath(), tpId.topicPartition().toString()).toFile().mkdirs());
        Matchers$.MODULE$.assertThrows((Function0 & Serializable)() -> this.run((Option<File>)Option$.MODULE$.empty(), (Option<File>)new Some((Object)rootDir)), ClassTag$.MODULE$.apply(ArgumentParserException.class), new Position("TierPartitionStateRestoreRawInputGeneratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        Matchers$.MODULE$.assertThrows((Function0 & Serializable)() -> this.run((Option<File>)new Some((Object)new File("/path/to/nonexisting/file")), (Option<File>)new Some((Object)rootDir)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TierPartitionStateRestoreRawInputGeneratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        Matchers$.MODULE$.assertThrows((Function0 & Serializable)() -> this.run((Option<File>)new Some((Object)fenceOutput.file()), (Option<File>)Option$.MODULE$.empty()), ClassTag$.MODULE$.apply(ArgumentParserException.class), new Position("TierPartitionStateRestoreRawInputGeneratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        Assertions.assertFalse((boolean)(((IllegalArgumentException)Matchers$.MODULE$.intercept((Function0 & Serializable)() -> this.run((Option<File>)new Some((Object)fenceOutput.file()), (Option<File>)new Some((Object)new File("/path/to/non_existing_dir"))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TierPartitionStateRestoreRawInputGeneratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138))).getCause() instanceof TierPartitionStateRestoreRawInputGenerator.InvalidInputException));
        new PrintWriter(null, fenceOutput){
            {
                try {
                    this.write("invalid-json");
                }
                finally {
                    this.close();
                }
            }
        };
        Assertions.assertTrue((boolean)(((IllegalStateException)Matchers$.MODULE$.intercept((Function0 & Serializable)() -> this.run((Option<File>)new Some((Object)fenceOutput.file()), (Option<File>)new Some((Object)rootDir)), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierPartitionStateRestoreRawInputGeneratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150))).getCause() instanceof JsonParseException));
    }

    @Test
    public void testFailureDueToMissingPartitionDir() {
        TopicIdPartition tpId = new TopicIdPartition("foo", UUID.randomUUID(), 27);
        FenceOutput fenceOutput = this.fence(tpId);
        File rootDir = TestUtils.tempDirectory(null, null);
        TierPartitionStateRestoreRawInputGenerator.InvalidInputException exception = (TierPartitionStateRestoreRawInputGenerator.InvalidInputException)((IllegalArgumentException)Matchers$.MODULE$.intercept((Function0 & Serializable)() -> this.run((Option<File>)new Some((Object)fenceOutput.file()), (Option<File>)new Some((Object)rootDir)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TierPartitionStateRestoreRawInputGeneratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162))).getCause();
        Assertions.assertFalse((boolean)exception.isEmpty());
        Assertions.assertTrue((boolean)exception.partitionsWithIncorrectTierStateFiles.isEmpty());
        Assertions.assertEquals((int)1, (int)exception.partitionsWithMissingDirs.size());
        Assertions.assertTrue((boolean)exception.partitionsWithMissingDirs.contains(tpId.topicPartition()));
    }

    @Test
    public void testFailureDueToMissingOrEmptyTierStateFile() {
        TopicIdPartition tpId = new TopicIdPartition("foo", UUID.randomUUID(), 27);
        TopicPartition tp = tpId.topicPartition();
        FenceOutput fenceOutput = this.fence(tpId);
        File rootDir = TestUtils.tempDirectory(null, null);
        File partitionDir = Paths.get(rootDir.getAbsolutePath(), tp.toString()).toFile();
        Assertions.assertTrue((boolean)partitionDir.mkdirs());
        this.runTest$1(fenceOutput, rootDir, tp);
        Assertions.assertTrue((boolean)MergedLog$.MODULE$.tierStateFile(partitionDir, 0L, "").createNewFile());
        this.runTest$1(fenceOutput, rootDir, tp);
    }

    @Test
    public void testFailureDueToMutableTierStateFile() {
        TopicIdPartition tpId = new TopicIdPartition("foo", UUID.randomUUID(), 27);
        TopicPartition tp = tpId.topicPartition();
        FenceOutput fenceOutput = this.fence(tpId);
        File rootDir = TestUtils.tempDirectory(null, null);
        File partitionDir = Paths.get(rootDir.getAbsolutePath(), tp.toString()).toFile();
        Assertions.assertTrue((boolean)partitionDir.mkdirs());
        ObjectRef previousMutableFile = ObjectRef.create((Object)Option$.MODULE$.empty());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])Algorithm.values()), (Function1 & Serializable)algorithm -> {
            TierPartitionStateRestoreRawInputGeneratorTest.$anonfun$testFailureDueToMutableTierStateFile$1(this, previousMutableFile, partitionDir, fenceOutput, rootDir, tp, algorithm);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFailureDueToMultipleValidTierStateFile() {
        TopicIdPartition tpId = new TopicIdPartition("foo", UUID.randomUUID(), 27);
        TopicPartition tp = tpId.topicPartition();
        FenceOutput fenceOutput = this.fence(tpId);
        File rootDir = TestUtils.tempDirectory(null, null);
        File partitionDir = Paths.get(rootDir.getAbsolutePath(), tp.toString()).toFile();
        Assertions.assertTrue((boolean)partitionDir.mkdirs());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])Algorithm.values()), (Function1 & Serializable)algorithm -> this.createNonEmptyFlushedFile(partitionDir, (Algorithm)algorithm));
        TierPartitionStateRestoreRawInputGenerator.InvalidInputException exception = (TierPartitionStateRestoreRawInputGenerator.InvalidInputException)((IllegalArgumentException)Matchers$.MODULE$.intercept((Function0 & Serializable)() -> this.run((Option<File>)new Some((Object)fenceOutput.file()), (Option<File>)new Some((Object)rootDir)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TierPartitionStateRestoreRawInputGeneratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245))).getCause();
        Assertions.assertFalse((boolean)exception.isEmpty());
        Assertions.assertTrue((boolean)exception.partitionsWithMissingDirs.isEmpty());
        Assertions.assertEquals((int)1, (int)exception.partitionsWithIncorrectTierStateFiles.size());
        Assertions.assertTrue((boolean)exception.partitionsWithIncorrectTierStateFiles.contains(tp));
    }

    @Test
    public void testSuccessDueToValidTierStateFile() {
        TopicIdPartition tpId = new TopicIdPartition("foo", UUID.randomUUID(), 27);
        FenceOutput fenceOutput = this.fence(tpId);
        File rootDir = TestUtils.tempDirectory(null, null);
        File partitionDir = Paths.get(rootDir.getAbsolutePath(), tpId.topicPartition().toString()).toFile();
        Assertions.assertTrue((boolean)partitionDir.mkdirs());
        ObjectRef previousValidTierStateFile = ObjectRef.create((Object)Option$.MODULE$.empty());
        Object[] combinations = (Tuple2[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])Algorithm.values()), (Function1 & Serializable)algorithm -> new .colon.colon((Object)new Tuple2(algorithm, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2(algorithm, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(Tuple2.class));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(combinations), (Function1 & Serializable)item -> {
            TierPartitionStateRestoreRawInputGeneratorTest.$anonfun$testSuccessDueToValidTierStateFile$2(this, previousValidTierStateFile, partitionDir, fenceOutput, rootDir, item);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMultiplePartitionsWithValidTierStateFiles() {
        .colon.colon tpIds = new .colon.colon((Object)new TopicIdPartition("foo", UUID.randomUUID(), 27), (List)new .colon.colon((Object)new TopicIdPartition("bar", UUID.randomUUID(), 345), (List)Nil$.MODULE$));
        FenceOutput fenceOutput = this.fence((scala.collection.immutable.Seq<TopicIdPartition>)tpIds);
        File rootDir = TestUtils.tempDirectory(null, null);
        java.util.List flushedFiles = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)tpIds.map((Function1 & Serializable)tpId -> {
            File partitionDir = Paths.get(rootDir.getAbsolutePath(), tpId.topicPartition().toString()).toFile();
            Assertions.assertTrue((boolean)partitionDir.mkdirs());
            return this.createNonEmptyFlushedFile(partitionDir, Algorithm.ADLER);
        })).toList()).asJava();
        java.util.List<RestoreInfo.RestoreRawInput> rawInputs = this.run((Option<File>)new Some((Object)fenceOutput.file()), (Option<File>)new Some((Object)rootDir));
        Assertions.assertFalse((boolean)rawInputs.isEmpty());
        Assertions.assertEquals((int)2, (int)rawInputs.size());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            RestoreInfo.RestoreRawInput rawInput = (RestoreInfo.RestoreRawInput)rawInputs.get(index);
            FenceEventInfo fenceEvent = fenceOutput.events().get(index);
            File flushedFile = (File)flushedFiles.get(index);
            Assertions.assertEquals((Object)rawInput.fenceEventInfo(), (Object)fenceEvent);
            Assertions.assertEquals((Object)flushedFile, (Object)rawInput.path().toFile());
        });
    }

    @Test
    public void testMultiplePartitionsWithInvalidTierStateFiles() {
        .colon.colon tpIds = new .colon.colon((Object)new TopicIdPartition("valid", UUID.randomUUID(), 27), (List)new .colon.colon((Object)new TopicIdPartition("invalid1", UUID.randomUUID(), 345), (List)new .colon.colon((Object)new TopicIdPartition("invalid2", UUID.randomUUID(), 4214), (List)Nil$.MODULE$)));
        FenceOutput fenceOutput = this.fence((scala.collection.immutable.Seq<TopicIdPartition>)tpIds);
        File rootDir = TestUtils.tempDirectory(null, null);
        TopicIdPartition validTpId = (TopicIdPartition)tpIds.apply(0);
        File validTpIdPartitionDir = Paths.get(rootDir.getAbsolutePath(), validTpId.topicPartition().toString()).toFile();
        Assertions.assertTrue((boolean)validTpIdPartitionDir.mkdirs());
        this.createNonEmptyFlushedFile(validTpIdPartitionDir, Algorithm.ADLER);
        TopicIdPartition invalidTpId1 = (TopicIdPartition)tpIds.apply(1);
        TopicIdPartition invalidTpId2 = (TopicIdPartition)tpIds.apply(2);
        File invalidTpIdPartitionDir2 = Paths.get(rootDir.getAbsolutePath(), invalidTpId2.topicPartition().toString()).toFile();
        Assertions.assertTrue((boolean)invalidTpIdPartitionDir2.mkdirs());
        this.createNonEmptyFlushedFile(invalidTpIdPartitionDir2, Algorithm.ADLER);
        this.createNonEmptyFlushedFile(invalidTpIdPartitionDir2, Algorithm.NO_CHECKSUM);
        TierPartitionStateRestoreRawInputGenerator.InvalidInputException exception = (TierPartitionStateRestoreRawInputGenerator.InvalidInputException)((IllegalArgumentException)Matchers$.MODULE$.intercept((Function0 & Serializable)() -> this.run((Option<File>)new Some((Object)fenceOutput.file()), (Option<File>)new Some((Object)rootDir)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TierPartitionStateRestoreRawInputGeneratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348))).getCause();
        Assertions.assertFalse((boolean)exception.isEmpty());
        Assertions.assertEquals((int)1, (int)exception.partitionsWithMissingDirs.size());
        Assertions.assertTrue((boolean)exception.partitionsWithMissingDirs.contains(invalidTpId1.topicPartition()));
        Assertions.assertEquals((int)1, (int)exception.partitionsWithIncorrectTierStateFiles.size());
        Assertions.assertTrue((boolean)exception.partitionsWithIncorrectTierStateFiles.contains(invalidTpId2.topicPartition()));
    }

    private final void FenceOutput$lzycompute$1() {
        synchronized (this) {
            if (this.FenceOutput$module == null) {
                this.FenceOutput$module = new TierPartitionStateRestoreRawInputGeneratorTest$FenceOutput$(this);
            }
            return;
        }
    }

    private final void runTest$1(FenceOutput fenceOutput$3, File rootDir$3, TopicPartition tp$1) {
        TierPartitionStateRestoreRawInputGenerator.InvalidInputException exception = (TierPartitionStateRestoreRawInputGenerator.InvalidInputException)((IllegalArgumentException)Matchers$.MODULE$.intercept((Function0 & Serializable)() -> this.run((Option<File>)new Some((Object)fenceOutput$3.file()), (Option<File>)new Some((Object)rootDir$3)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TierPartitionStateRestoreRawInputGeneratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183))).getCause();
        Assertions.assertFalse((boolean)exception.isEmpty());
        Assertions.assertTrue((boolean)exception.partitionsWithMissingDirs.isEmpty());
        Assertions.assertEquals((int)1, (int)exception.partitionsWithIncorrectTierStateFiles.size());
        Assertions.assertTrue((boolean)exception.partitionsWithIncorrectTierStateFiles.contains(tp$1));
    }

    public static final /* synthetic */ void $anonfun$testFailureDueToMutableTierStateFile$2(File file) {
        Assertions.assertTrue((boolean)Files.deleteIfExists(file.toPath()));
    }

    public static final /* synthetic */ void $anonfun$testFailureDueToMutableTierStateFile$1(TierPartitionStateRestoreRawInputGeneratorTest $this, ObjectRef previousMutableFile$1, File partitionDir$1, FenceOutput fenceOutput$4, File rootDir$4, TopicPartition tp$2, Algorithm algorithm) {
        ((Option)previousMutableFile$1.elem).foreach((Function1 & Serializable)file -> {
            TierPartitionStateRestoreRawInputGeneratorTest.$anonfun$testFailureDueToMutableTierStateFile$2(file);
            return BoxedUnit.UNIT;
        });
        File mutableTierStateFile = $this.createNonEmptyMutableFile(partitionDir$1, algorithm);
        TierPartitionStateRestoreRawInputGenerator.InvalidInputException exception = (TierPartitionStateRestoreRawInputGenerator.InvalidInputException)((IllegalArgumentException)Matchers$.MODULE$.intercept((Function0 & Serializable)() -> $this.run((Option<File>)new Some((Object)fenceOutput$4.file()), (Option<File>)new Some((Object)rootDir$4)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TierPartitionStateRestoreRawInputGeneratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221))).getCause();
        Assertions.assertFalse((boolean)exception.isEmpty());
        Assertions.assertTrue((boolean)exception.partitionsWithMissingDirs.isEmpty());
        Assertions.assertEquals((int)1, (int)exception.partitionsWithIncorrectTierStateFiles.size());
        Assertions.assertTrue((boolean)exception.partitionsWithIncorrectTierStateFiles.contains(tp$2));
        previousMutableFile$1.elem = new Some((Object)mutableTierStateFile);
    }

    public static final /* synthetic */ void $anonfun$testSuccessDueToValidTierStateFile$3(File file) {
        Assertions.assertTrue((boolean)Files.deleteIfExists(file.toPath()));
    }

    public static final /* synthetic */ void $anonfun$testSuccessDueToValidTierStateFile$2(TierPartitionStateRestoreRawInputGeneratorTest $this, ObjectRef previousValidTierStateFile$1, File partitionDir$3, FenceOutput fenceOutput$6, File rootDir$6, Tuple2 item) {
        Algorithm algorithm = (Algorithm)item._1();
        boolean shouldResetTierState = item._2$mcZ$sp();
        ((Option)previousValidTierStateFile$1.elem).foreach((Function1 & Serializable)file -> {
            TierPartitionStateRestoreRawInputGeneratorTest.$anonfun$testSuccessDueToValidTierStateFile$3(file);
            return BoxedUnit.UNIT;
        });
        File flushedFile = shouldResetTierState ? $this.createNonEmptyResetFlushedFile(partitionDir$3, algorithm) : $this.createNonEmptyFlushedFile(partitionDir$3, algorithm);
        java.util.List<RestoreInfo.RestoreRawInput> rawInputs = $this.run((Option<File>)new Some((Object)fenceOutput$6.file()), (Option<File>)new Some((Object)rootDir$6));
        Assertions.assertFalse((boolean)rawInputs.isEmpty());
        Assertions.assertEquals((int)1, (int)rawInputs.size());
        RestoreInfo.RestoreRawInput rawInput = rawInputs.get(0);
        FenceEventInfo fenceEvent = fenceOutput$6.events().get(0);
        Assertions.assertEquals((Object)rawInput.fenceEventInfo(), (Object)fenceEvent);
        Assertions.assertEquals((Object)flushedFile, (Object)rawInput.path().toFile());
        previousValidTierStateFile$1.elem = new Some((Object)flushedFile);
    }

    public class FenceOutput
    implements Product,
    Serializable {
        private final File file;
        private final java.util.List<FenceEventInfo> events;
        public final /* synthetic */ TierPartitionStateRestoreRawInputGeneratorTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public File file() {
            return this.file;
        }

        public java.util.List<FenceEventInfo> events() {
            return this.events;
        }

        public FenceOutput copy(File file, java.util.List<FenceEventInfo> events) {
            return new FenceOutput(this.integration$kafka$tier$tools$TierPartitionStateRestoreRawInputGeneratorTest$FenceOutput$$$outer(), file, events);
        }

        public File copy$default$1() {
            return this.file();
        }

        public java.util.List<FenceEventInfo> copy$default$2() {
            return this.events();
        }

        public String productPrefix() {
            return "FenceOutput";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.file();
                }
                case 1: {
                    return this.events();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FenceOutput;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "file";
                }
                case 1: {
                    return "events";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof FenceOutput && ((FenceOutput)x$1).integration$kafka$tier$tools$TierPartitionStateRestoreRawInputGeneratorTest$FenceOutput$$$outer() == this.integration$kafka$tier$tools$TierPartitionStateRestoreRawInputGeneratorTest$FenceOutput$$$outer())) break block3;
                    FenceOutput fenceOutput = (FenceOutput)x$1;
                    File file = this.file();
                    File file2 = fenceOutput.file();
                    if (file != null ? !((Object)file).equals(file2) : file2 != null) break block3;
                    java.util.List<FenceEventInfo> list = this.events();
                    java.util.List<FenceEventInfo> list2 = fenceOutput.events();
                    if ((list != null ? !((Object)list).equals(list2) : list2 != null) || !fenceOutput.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ TierPartitionStateRestoreRawInputGeneratorTest integration$kafka$tier$tools$TierPartitionStateRestoreRawInputGeneratorTest$FenceOutput$$$outer() {
            return this.$outer;
        }

        public FenceOutput(TierPartitionStateRestoreRawInputGeneratorTest $outer, File file, java.util.List<FenceEventInfo> events) {
            this.file = file;
            this.events = events;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

