/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Properties;
import kafka.Kafka$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tMa\u0001\u0002\u00180\u0001IBQ!\u000f\u0001\u0005\u0002iBQ!\u0010\u0001\u0005\u0002yBQa\u0014\u0001\u0005\u0002yBQ\u0001\u0016\u0001\u0005\u0002yBQ!\u0017\u0001\u0005\u0002yBQa\u0017\u0001\u0005\u0002yBQ!\u0018\u0001\u0005\u0002yBQa\u0018\u0001\u0005\u0002yBQ!\u0019\u0001\u0005\u0002yBQa\u0019\u0001\u0005\u0002yBQ!\u001a\u0001\u0005\u0002yBQa\u001a\u0001\u0005\u0002yBQ!\u001b\u0001\u0005\u0002yBQa\u001b\u0001\u0005\u0002yBQ!\u001c\u0001\u0005\n9DQ!\u001f\u0001\u0005\u0002yBQa\u001f\u0001\u0005\u0002yBq! \u0001C\u0002\u0013%a\u0010C\u0004\u0002\u0006\u0001\u0001\u000b\u0011B@\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0001\u0002CA\f\u0001\u0001\u0006I!a\u0003\t\u0013\u0005e\u0001A1A\u0005\n\u0005%\u0001\u0002CA\u000e\u0001\u0001\u0006I!a\u0003\t\u0013\u0005u\u0001A1A\u0005\n\u0005}\u0001\u0002CA\u0019\u0001\u0001\u0006I!!\t\t\r\u0005M\u0002\u0001\"\u0001?\u0011\u0019\t9\u0004\u0001C\u0001}!1\u00111\b\u0001\u0005\u0002yBa!a\u0010\u0001\t\u0003q\u0004BBA\"\u0001\u0011\u0005a\b\u0003\u0004\u0002H\u0001!\tA\u0010\u0005\u0007\u0003\u0017\u0002A\u0011\u0001 \t\r\u0005=\u0003\u0001\"\u0001?\u0011\u0019\t\u0019\u0006\u0001C\u0001}!1\u0011q\u000b\u0001\u0005\u0002yBa!a\u0017\u0001\t\u0003q\u0004BBA0\u0001\u0011\u0005a\b\u0003\u0004\u0002d\u0001!\tA\u0010\u0005\u0007\u0003O\u0002A\u0011\u0001 \t\r\u0005-\u0004\u0001\"\u0001?\u0011\u0019\ty\u0007\u0001C\u0001}!9\u00111\u000f\u0001\u0005\n\u0005U\u0004\"CAo\u0001E\u0005I\u0011BAp\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0005\u0007AqA!\u0002\u0001\t\u0003\u00119AA\u0005LC\u001a\\\u0017\rV3ti*\t\u0001'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0019\u0004C\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002wA\u0011A\bA\u0007\u0002_\u0005)1/\u001a;VaR\tq\b\u0005\u00025\u0001&\u0011\u0011)\u000e\u0002\u0005+:LG\u000f\u000b\u0002\u0003\u0007B\u0011A)T\u0007\u0002\u000b*\u0011aiR\u0001\u0004CBL'B\u0001%J\u0003\u001dQW\u000f]5uKJT!AS&\u0002\u000b),h.\u001b;\u000b\u00031\u000b1a\u001c:h\u0013\tqUI\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003\u0007E\u0003\"\u0001\u0012*\n\u0005M+%!C!gi\u0016\u0014X)Y2i\u0003i!Xm\u001d;HKR\\\u0015MZ6b\u0007>tg-[4Ge>l\u0017I]4tQ\t!a\u000b\u0005\u0002E/&\u0011\u0001,\u0012\u0002\u0005)\u0016\u001cH/A\u0015uKN$x)\u001a;LC\u001a\\\u0017mQ8oM&<gI]8n\u0003J<7OT8o\u0003J<7/\u0011;UQ\u0016,e\u000e\u001a\u0015\u0003\u000bY\u000bQ\u0005^3ti\u001e+GoS1gW\u0006\u001cuN\u001c4jO\u001a\u0013x.\\!sONtuN\\!sON|e\u000e\\=)\u0005\u00191\u0016!\f;fgR<U\r^&bM.\f7i\u001c8gS\u001e4%o\\7Be\u001e\u001chj\u001c8Be\u001e\u001c\u0018\t\u001e+iK\n+wmZ5oO\"\u0012qAV\u0001\u001fi\u0016\u001cHO\u0011:pW\u0016\u0014(k\u001c7f\u001d>$W-\u00133WC2LG-\u0019;j_:D#\u0001\u0003,\u0002EQ,7\u000f^\"p]R\u0014x\u000e\u001c7feJ{G.\u001a(pI\u0016LEMV1mS\u0012\fG/[8oQ\tIa+\u0001\u0011uKN$8i\\7cS:,GMU8mK:{G-Z%e-\u0006d\u0017\u000eZ1uS>t\u0007F\u0001\u0006W\u0003]!Xm\u001d;Jg.\u0013\u0016M\u001a;D_6\u0014\u0017N\\3e\u001b>$W\r\u000b\u0002\f-\u0006AB/Z:u\u0013NlU\u000f\u001c;ji\u0016t\u0017M\u001c;DYV\u001cH/\u001a:)\u000511\u0016\u0001\u0005;fgRL5/\u00143t\u000b:\f'\r\\3eQ\tia+\u0001\u0018uKN$X*^:u\u0007>tG/Y5o#V|'/^7W_R,'o]%g+NLgn\u001a)s_\u000e,7o\u001d*pY\u0016\u001c\bF\u0001\bW\u0003A\u0019X\r\u001e'jgR,g.\u001a:Qe>\u00048\u000f\u0006\u0002@_\")\u0001o\u0004a\u0001c\u0006)\u0001O]8qgB\u0011!o^\u0007\u0002g*\u0011A/^\u0001\u0005kRLGNC\u0001w\u0003\u0011Q\u0017M^1\n\u0005a\u001c(A\u0003)s_B,'\u000f^5fg\u0006)B/Z:u\u0017\u000647.Y*tYB\u000b7o]<pe\u0012\u001c\bF\u0001\tW\u0003\u0001\"Xm\u001d;LC\u001a\\\u0017mU:m!\u0006\u001c8o^8sIN<\u0016\u000e\u001e5Ts6\u0014w\u000e\\:)\u0005E1\u0016!\u00062p_2,\u0017M\u001c)s_B4\u0016\r\\;f)>\u001cV\r^\u000b\u0002\u007fB\u0019A'!\u0001\n\u0007\u0005\rQGA\u0004C_>dW-\u00198\u0002-\t|w\u000e\\3b]B\u0013x\u000e\u001d,bYV,Gk\\*fi\u0002\nAc\u001d;sS:<\u0007K]8q-\u0006dW/\u001a+p'\u0016$XCAA\u0006!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\tk\u0006!A.\u00198h\u0013\u0011\t)\"a\u0004\u0003\rM#(/\u001b8h\u0003U\u0019HO]5oOB\u0013x\u000e\u001d,bYV,Gk\\*fi\u0002\na\u0003]1tg^|'\u000f\u001a)s_B4\u0016\r\\;f)>\u001cV\r^\u0001\u0018a\u0006\u001c8o^8sIB\u0013x\u000e\u001d,bYV,Gk\\*fi\u0002\n!\u0003\\5tiB\u0013x\u000e\u001d,bYV,Gk\\*fiV\u0011\u0011\u0011\u0005\t\u0007\u0003G\ti#a\u0003\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005-R'\u0001\u0006d_2dWm\u0019;j_:LA!a\f\u0002&\t!A*[:u\u0003Ma\u0017n\u001d;Qe>\u0004h+\u00197vKR{7+\u001a;!\u0003U!Xm\u001d;[WN\u001bHn\u00117jK:$XI\\1cY\u0016D#A\u0007,\u00023Q,7\u000f\u001e.l'Nd7*Z=Ti>\u0014X\rT8dCRLwN\u001c\u0015\u00037Y\u000b1\u0004^3tij[7k\u001d7UeV\u001cHo\u0015;pe\u0016dunY1uS>t\u0007F\u0001\u000fW\u0003u!Xm\u001d;[_>\\W-\u001a9fe.+\u0017p\u0015;pe\u0016\u0004\u0016m]:x_J$\u0007FA\u000fW\u0003}!Xm\u001d;[_>\\W-\u001a9feR\u0013Xo\u001d;Ti>\u0014X\rU1tg^|'\u000f\u001a\u0015\u0003=Y\u000bQ\u0003^3tij[7k\u001d7LKf\u001cFo\u001c:f)f\u0004X\r\u000b\u0002 -\u00069B/Z:u5.\u001c6\u000f\u001c+skN$8\u000b^8sKRK\b/\u001a\u0015\u0003AY\u000b\u0011\u0003^3tij[7k\u001d7Qe>$xnY8mQ\t\tc+A\ruKN$(l[*tY\u0016s\u0017M\u00197fIB\u0013x\u000e^8d_2\u001c\bF\u0001\u0012W\u0003U!Xm\u001d;[WN\u001bHnQ5qQ\u0016\u00148+^5uKND#a\t,\u0002QQ,7\u000f\u001e.l'NdWI\u001c3q_&tG/\u00133f]RLg-[2bi&|g.\u00117h_JLG\u000f[7)\u0005\u00112\u0016A\u0005;fgRT6nU:m\u0007JdWI\\1cY\u0016D#!\n,\u0002'Q,7\u000f\u001e.l'NdwjY:q\u000b:\f'\r\\3)\u0005\u00192\u0016!\t;fgR\u001cuN\u001c8fGRLwN\\:NCb\u0014V-Y;uQ6\u001bH)\u001a4bk2$\bFA\u0014W\u0003\t\"Xm\u001d;D_:tWm\u0019;j_:\u001cX*\u0019=SK\u0006,H\u000f['t\u000bb\u0004H.[2ji\"\u0012\u0001FV\u0001=i\u0016\u001cH\u000fV8qS\u000e\u0014V\r\u001d7jG\u0006\f5o]5h]>\u0014(+\u001a;ve:\u001cX)\u001c9us>\u0003H/[8og^CWM\u001c(pi\u000e{gNZ5hkJ,G\r\u000b\u0002*-\u0006aA/Z:u5.\u001cuN\u001c4jOV1\u0011qOAQ\u0003+$rbPA=\u0003#\u000b)*!'\u00024\u0006=\u0017\u0011\u001c\u0005\b\u0003wR\u0003\u0019AA?\u00035Y\u0017MZ6b!J|\u0007OT1nKB!\u0011qPAG\u001d\u0011\t\t)!#\u0011\u0007\u0005\rU'\u0004\u0002\u0002\u0006*\u0019\u0011qQ\u0019\u0002\rq\u0012xn\u001c;?\u0013\r\tY)N\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0011q\u0012\u0006\u0004\u0003\u0017+\u0004bBAJU\u0001\u0007\u0011QP\u0001\u0016Kb\u0004Xm\u0019;fI.\u000bgm[1Qe>\u0004h*Y7f\u0011\u001d\t9J\u000ba\u0001\u0003{\n1b]=t!J|\u0007OT1nK\"9\u00111\u0014\u0016A\u0002\u0005u\u0015A\u00049s_B4\u0016\r\\;f)>\u001cV\r\u001e\t\u0005\u0003?\u000b\t\u000b\u0004\u0001\u0005\u000f\u0005\r&F1\u0001\u0002&\n\tA+\u0005\u0003\u0002(\u00065\u0006c\u0001\u001b\u0002*&\u0019\u00111V\u001b\u0003\u000f9{G\u000f[5oOB\u0019A'a,\n\u0007\u0005EVGA\u0002B]fDq!!.+\u0001\u0004\t9,\u0001\thKR\u0004&o\u001c9WC2,XM\u0012:p[B9A'!/\u0002>\u0006%\u0017bAA^k\tIa)\u001e8di&|g.\r\t\u0005\u0003\u007f\u000b)-\u0004\u0002\u0002B*\u0019\u00111Y\u0018\u0002\rM,'O^3s\u0013\u0011\t9-!1\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\t\u0006i\u0005-\u0017QT\u0005\u0004\u0003\u001b,$AB(qi&|g\u000eC\u0004\u0002R*\u0002\r!a5\u0002+\u0015D\b/Z2uK\u0012\u0004&o\u001c9feRLh+\u00197vKB!\u0011qTAk\t\u001d\t9N\u000bb\u0001\u0003K\u0013\u0011!\u0016\u0005\n\u00037T\u0003\u0013!a\u0001\u0003\u0013\fA#\u001a=qK\u000e$X\r\u001a#fM\u0006,H\u000e\u001e,bYV,\u0017A\u0006;fgRT6nQ8oM&<G\u0005Z3gCVdG\u000fJ\u001c\u0016\r\u0005\u0005\u0018Q`A\u0000+\t\t\u0019O\u000b\u0003\u0002f\u0006-hb\u0001\u001b\u0002h&\u0019\u0011\u0011^\u001b\u0002\t9{g.Z\u0016\u0003\u0003[\u0004B!a<\u0002z6\u0011\u0011\u0011\u001f\u0006\u0005\u0003g\f)0A\u0005v]\u000eDWmY6fI*\u0019\u0011q_\u001b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002|\u0006E(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00129\u00111U\u0016C\u0002\u0005\u0015FaBAlW\t\u0007\u0011QU\u0001\u0015aJ,\u0007/\u0019:f\t\u00164\u0017-\u001e7u\u0007>tg-[4\u0015\u0005\u0005u\u0014!\u00049sKB\f'/Z\"p]\u001aLw\r\u0006\u0003\u0002~\t%\u0001b\u0002B\u0006[\u0001\u0007!QB\u0001\u0006Y&tWm\u001d\t\u0006i\t=\u0011QP\u0005\u0004\u0005#)$!B!se\u0006L\b")
public class KafkaTest {
    private final boolean booleanPropValueToSet;
    private final String stringPropValueToSet;
    private final String passwordPropValueToSet;
    private final List<String> listPropValueToSet = new .colon.colon((Object)"A", (List)new .colon.colon((Object)"B", (List)Nil$.MODULE$));

    @BeforeEach
    public void setUp() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(status, x$1) -> KafkaTest.$anonfun$setUp$1(BoxesRunTime.unboxToInt((Object)status), x$1);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
    }

    @Test
    public void testGetKafkaConfigFromArgs() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config1 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
        Assertions.assertEquals((int)1, (int)config1.brokerId());
        KafkaConfig config2 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "broker.id=2"}));
        Assertions.assertEquals((int)2, (int)config2.brokerId());
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "log.cleanup.policy=compact"}));
        Assertions.assertEquals((int)1, (int)config3.brokerId());
        Assertions.assertEquals(Arrays.asList("compact"), (Object)config3.logCleanupPolicy());
        KafkaConfig config4 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "log.cleanup.policy=compact,delete", "--override", "broker.id=2"}));
        Assertions.assertEquals((int)2, (int)config4.brokerId());
        Assertions.assertEquals(Arrays.asList("compact", "delete"), (Object)config4.logCleanupPolicy());
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsAtTheEnd() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "broker.id=1", "broker.id=2"})));
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsOnly() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "broker.id=1", "broker.id=2"})));
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsAtTheBegging() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "broker.id=1", "--override", "broker.id=2"})));
    }

    @Test
    public void testBrokerRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "1@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains just the 'broker' role, the node id 1 must not be included in the set of voters");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testControllerRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "2@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains the 'controller' role, the node id 1 must be included in the set of voters");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testCombinedRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller,broker");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "2@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains the 'controller' role, the node id 1 must be included in the set of voters");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testIsKRaftCombinedMode() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller,broker");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "1@localhost:9092");
        this.setListenerProps(propertiesFile);
        Assertions.assertTrue((boolean)KafkaConfig$.MODULE$.fromProps(propertiesFile).isKRaftCombinedMode());
    }

    @Test
    public void testIsMultitenantCluster() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "1@localhost:9092");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), "io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer");
        this.setListenerProps(propertiesFile);
        Assertions.assertTrue((boolean)KafkaConfig$.MODULE$.fromProps(propertiesFile).isMultitenantCluster());
        propertiesFile.setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), "io.dummmy");
        this.setListenerProps(propertiesFile);
        Assertions.assertFalse((boolean)KafkaConfig$.MODULE$.fromProps(propertiesFile).isMultitenantCluster());
    }

    @Test
    public void testIsMdsEnabled() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "1@localhost:9092");
        propertiesFile.setProperty("confluent.metadata.server.listeners", "dummy:9092");
        this.setListenerProps(propertiesFile);
        Assertions.assertTrue((boolean)KafkaConfig$.MODULE$.fromProps(propertiesFile).isMdsEnabled());
        propertiesFile.setProperty("confluent.metadata.server.listeners", "");
        this.setListenerProps(propertiesFile);
        Assertions.assertFalse((boolean)KafkaConfig$.MODULE$.fromProps(propertiesFile).isMdsEnabled());
    }

    @Test
    public void testMustContainQuorumVotersIfUsingProcessRoles() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller,broker");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If using process.roles, controller.quorum.voters must contain a parseable set of voters.");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "");
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "Missing required configuration `zookeeper.connect` which has no default value.");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    private void setListenerProps(Properties props) {
        boolean hasBrokerRole = props.getProperty(KafkaConfig$.MODULE$.ProcessRolesProp()).contains("broker");
        boolean hasControllerRole = props.getProperty(KafkaConfig$.MODULE$.ProcessRolesProp()).contains("controller");
        String controllerListener = "SASL_PLAINTEXT://localhost:9092";
        String brokerListener = "PLAINTEXT://localhost:9093";
        if (hasBrokerRole || hasControllerRole) {
            props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SASL_PLAINTEXT");
            if (hasBrokerRole && hasControllerRole) {
                props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(1).append(brokerListener).append(",").append(controllerListener).toString());
            } else if (hasControllerRole) {
                props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), controllerListener);
            } else if (hasBrokerRole) {
                props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), brokerListener);
            }
        } else {
            props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), brokerListener);
        }
        if (!(hasControllerRole & !hasBrokerRole)) {
            props.setProperty(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "PLAINTEXT");
            props.setProperty(KafkaConfig$.MODULE$.AdvertisedListenersProp(), "PLAINTEXT://localhost:9092");
            return;
        }
    }

    @Test
    public void testKafkaSslPasswords() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", "ssl.keystore.password=keystore_password", "--override", "ssl.key.password=key_password", "--override", "ssl.truststore.password=truststore_password", "--override", "ssl.keystore.certificate.chain=certificate_chain", "--override", "ssl.keystore.key=private_key", "--override", "ssl.truststore.certificates=truststore_certificates"}));
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystoreKeyProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystoreCertificateChainProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststoreCertificatesProp()).toString());
        Assertions.assertEquals((Object)"key_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).value());
        Assertions.assertEquals((Object)"keystore_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).value());
        Assertions.assertEquals((Object)"truststore_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
        Assertions.assertEquals((Object)"private_key", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystoreKeyProp()).value());
        Assertions.assertEquals((Object)"certificate_chain", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystoreCertificateChainProp()).value());
        Assertions.assertEquals((Object)"truststore_certificates", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststoreCertificatesProp()).value());
    }

    @Test
    public void testKafkaSslPasswordsWithSymbols() {
        String password = "=!#-+!?*/\"'^%$=\\.,@:;=";
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", new StringBuilder(22).append("ssl.keystore.password=").append(password).toString(), "--override", new StringBuilder(17).append("ssl.key.password=").append(password).toString(), "--override", new StringBuilder(24).append("ssl.truststore.password=").append(password).toString()}));
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).toString());
        Assertions.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).value());
        Assertions.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).value());
        Assertions.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
    }

    private boolean booleanPropValueToSet() {
        return this.booleanPropValueToSet;
    }

    private String stringPropValueToSet() {
        return this.stringPropValueToSet;
    }

    private String passwordPropValueToSet() {
        return this.passwordPropValueToSet;
    }

    private List<String> listPropValueToSet() {
        return this.listPropValueToSet;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslClientEnable() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        String string = "zookeeper.client.secure";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.client.enable";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaTest.$anonfun$testZkSslClientEnable$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaTest.$anonfun$testZkSslClientEnable$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslClientEnable$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslClientEnable$1(testZkConfig_config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslKeyStoreLocation() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.keyStore.location";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.keystore.location";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslKeyStoreLocation().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslKeyStoreLocation());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreLocation());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreLocation());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslTrustStoreLocation() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.trustStore.location";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.truststore.location";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslTrustStoreLocation().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslTrustStoreLocation());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreLocation());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreLocation());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZookeeperKeyStorePassword() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        Password password = new Password(this.passwordPropValueToSet());
        String string = this.passwordPropValueToSet();
        String string2 = "zookeeper.ssl.keyStore.password";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.keystore.password";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslKeyStorePassword().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslKeyStorePassword());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStorePassword());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStorePassword());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZookeeperTrustStorePassword() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        Password password = new Password(this.passwordPropValueToSet());
        String string = this.passwordPropValueToSet();
        String string2 = "zookeeper.ssl.trustStore.password";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.truststore.password";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslTrustStorePassword().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslTrustStorePassword());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStorePassword());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStorePassword());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslKeyStoreType() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.keyStore.type";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.keystore.type";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslKeyStoreType().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslKeyStoreType());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreType());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreType());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslTrustStoreType() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.trustStore.type";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.truststore.type";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslTrustStoreType().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslTrustStoreType());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreType());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreType());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslProtocol() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)"TLSv1.2");
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.protocol";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.protocol";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslProtocolProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaTest.$anonfun$testZkSslProtocol$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaTest.$anonfun$testZkSslProtocol$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslProtocol$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslProtocol$1(testZkConfig_config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslEnabledProtocols() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        java.util.List list = CollectionConverters$.MODULE$.SeqHasAsJava(this.listPropValueToSet()).asJava();
        String string = this.listPropValueToSet().mkString(",");
        String string2 = "zookeeper.ssl.enabledProtocols";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.enabled.protocols";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.ZkSslEnabledProtocols().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.ZkSslEnabledProtocols());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslEnabledProtocols());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslEnabledProtocols());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslCipherSuites() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = None$.MODULE$;
        java.util.List list = CollectionConverters$.MODULE$.SeqHasAsJava(this.listPropValueToSet()).asJava();
        String string = this.listPropValueToSet().mkString(",");
        String string2 = "zookeeper.ssl.ciphersuites";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.cipher.suites";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.ZkSslCipherSuites().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.ZkSslCipherSuites());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslCipherSuites());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslCipherSuites());
    }

    @Test
    public void testZkSslEndpointIdentificationAlgorithm() {
        String kafkaPropName = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        Assertions.assertEquals((Object)"zookeeper.ssl.endpoint.identification.algorithm", (Object)kafkaPropName);
        String sysProp = "zookeeper.ssl.hostnameVerification";
        String expectedDefaultValue = "HTTPS";
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
        Assertions.assertNull(emptyConfig.originals().get(kafkaPropName));
        Assertions.assertEquals((Object)expectedDefaultValue, emptyConfig.values().get(kafkaPropName));
        Assertions.assertEquals((Object)expectedDefaultValue, (Object)emptyConfig.ZkSslEndpointIdentificationAlgorithm());
        ((IterableOnceOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"true"), (Object)"HTTPS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"false"), (Object)"")}))).foreach((Function1 & Serializable)x0$1 -> {
            KafkaTest.$anonfun$testZkSslEndpointIdentificationAlgorithm$1(sysProp, propertiesFile, kafkaPropName, expectedDefaultValue, x0$1);
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)"https", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)expected -> {
            KafkaTest.$anonfun$testZkSslEndpointIdentificationAlgorithm$2(propertiesFile, kafkaPropName, expected);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslCrlEnable() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        String string = "zookeeper.ssl.crl";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.crl.enable";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslOcspEnable() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        String string = "zookeeper.ssl.ocsp";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.ocsp.enable";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile}));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()}));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_config));
    }

    @Test
    public void testConnectionsMaxReauthMsDefault() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong(config.valuesWithPrefixOverride("sasl_ssl.oauthbearer.").get("connections.max.reauth.ms")));
    }

    @Test
    public void testConnectionsMaxReauthMsExplicit() {
        String propertiesFile = this.prepareDefaultConfig();
        int expected = 3600000;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", new StringBuilder(47).append("sasl_ssl.oauthbearer.connections.max.reauth.ms=").append(expected).toString()}));
        Assertions.assertEquals((long)expected, (long)BoxesRunTime.unboxToLong(config.valuesWithPrefixOverride("sasl_ssl.oauthbearer.").get("connections.max.reauth.ms")));
    }

    @Test
    public void testTopicReplicaAssignorReturnsEmptyOptionsWhenNotConfigured() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertFalse((boolean)KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile})).topicReplicaAssignorBuilder().isDefined(), (String)"Expected the assignor builder to not be loaded");
    }

    private <T, U> void testZkConfig(String kafkaPropName, String expectedKafkaPropName, String sysPropName, T propValueToSet, Function1<KafkaConfig, Option<T>> getPropValueFrom, U expectedPropertyValue, Option<T> expectedDefaultValue) {
        Assertions.assertEquals((Object)expectedKafkaPropName, (Object)kafkaPropName);
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
        Assertions.assertNull(emptyConfig.originals().get(kafkaPropName));
        if (expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)expectedDefaultValue.get(), emptyConfig.values().get(kafkaPropName));
            Assertions.assertEquals((Object)expectedDefaultValue.get(), (Object)((Option)getPropValueFrom.apply((Object)emptyConfig)).get());
        } else {
            Assertions.assertNull(emptyConfig.values().get(kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)getPropValueFrom.apply((Object)emptyConfig));
        }
        try {
            System.setProperty(sysPropName, String.valueOf(propValueToSet));
            KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile}));
            Assertions.assertNull(config.originals().get(kafkaPropName));
            if (expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)expectedDefaultValue.get(), config.values().get(kafkaPropName));
            } else {
                Assertions.assertNull(config.values().get(kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some(expectedPropertyValue), (Object)getPropValueFrom.apply((Object)config));
        }
        finally {
            System.clearProperty(sysPropName);
        }
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile, "--override", new StringBuilder(1).append(kafkaPropName).append("=").append(propValueToSet).toString()}));
        Assertions.assertEquals(expectedPropertyValue, config.values().get(kafkaPropName));
        Assertions.assertEquals((Object)new Some(expectedPropertyValue), (Object)getPropValueFrom.apply((Object)config));
    }

    private <T, U> None$ testZkConfig$default$7() {
        return None$.MODULE$;
    }

    public String prepareDefaultConfig() {
        return this.prepareConfig(new String[]{"broker.id=1", "zookeeper.connect=somewhere"});
    }

    public String prepareConfig(String[] lines) {
        String string;
        File file = TestUtils.tempFile((String)"kafkatest", (String)".properties");
        try (OutputStream writer = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])lines), (Function1 & Serializable)l -> {
                KafkaTest.$anonfun$prepareConfig$1(writer, l);
                return BoxedUnit.UNIT;
            });
            string = file.getAbsolutePath();
        }
        return string;
    }

    public static final /* synthetic */ Nothing$ $anonfun$setUp$1(int status, Option x$1) {
        throw new FatalExitError(status);
    }

    public static final /* synthetic */ Some $anonfun$testZkSslClientEnable$1(KafkaConfig config) {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.zkSslClientEnable()));
    }

    public static final /* synthetic */ Option $anonfun$testZkSslKeyStoreLocation$1(KafkaConfig config) {
        return config.zkSslKeyStoreLocation();
    }

    public static final /* synthetic */ Option $anonfun$testZkSslTrustStoreLocation$1(KafkaConfig config) {
        return config.zkSslTrustStoreLocation();
    }

    public static final /* synthetic */ Option $anonfun$testZookeeperKeyStorePassword$1(KafkaConfig config) {
        return config.zkSslKeyStorePassword();
    }

    public static final /* synthetic */ Option $anonfun$testZookeeperTrustStorePassword$1(KafkaConfig config) {
        return config.zkSslTrustStorePassword();
    }

    public static final /* synthetic */ Option $anonfun$testZkSslKeyStoreType$1(KafkaConfig config) {
        return config.zkSslKeyStoreType();
    }

    public static final /* synthetic */ Option $anonfun$testZkSslTrustStoreType$1(KafkaConfig config) {
        return config.zkSslTrustStoreType();
    }

    public static final /* synthetic */ Some $anonfun$testZkSslProtocol$1(KafkaConfig config) {
        return new Some((Object)config.ZkSslProtocol());
    }

    public static final /* synthetic */ Option $anonfun$testZkSslEnabledProtocols$1(KafkaConfig config) {
        return config.ZkSslEnabledProtocols();
    }

    public static final /* synthetic */ Option $anonfun$testZkSslCipherSuites$1(KafkaConfig config) {
        return config.ZkSslCipherSuites();
    }

    public static final /* synthetic */ void $anonfun$testZkSslEndpointIdentificationAlgorithm$1(String sysProp$1, String propertiesFile$4, String kafkaPropName$1, String expectedDefaultValue$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String sysPropValue = (String)x0$1._1();
            String expected = (String)x0$1._2();
            try {
                System.setProperty(sysProp$1, sysPropValue);
                KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile$4}));
                Assertions.assertNull(config.originals().get(kafkaPropName$1));
                Assertions.assertEquals((Object)expectedDefaultValue$1, config.values().get(kafkaPropName$1));
                Assertions.assertEquals((Object)expected, (Object)config.ZkSslEndpointIdentificationAlgorithm());
            }
            finally {
                System.clearProperty(sysProp$1);
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testZkSslEndpointIdentificationAlgorithm$2(String propertiesFile$4, String kafkaPropName$1, String expected) {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs(new String[]{propertiesFile$4, "--override", new StringBuilder(1).append(kafkaPropName$1).append("=").append(expected).toString()}));
        Assertions.assertEquals((Object)expected, config.originals().get(kafkaPropName$1));
        Assertions.assertEquals((Object)expected, config.values().get(kafkaPropName$1));
        Assertions.assertEquals((Object)expected, (Object)config.ZkSslEndpointIdentificationAlgorithm());
    }

    public static final /* synthetic */ Some $anonfun$testZkSslCrlEnable$1(KafkaConfig config) {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.ZkSslCrlEnable()));
    }

    public static final /* synthetic */ Some $anonfun$testZkSslOcspEnable$1(KafkaConfig config) {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.ZkSslOcspEnable()));
    }

    public static final /* synthetic */ void $anonfun$prepareConfig$1(OutputStream writer$1, String l) {
        writer$1.write(l.getBytes());
        writer$1.write("\n".getBytes());
    }

    public KafkaTest() {
        this.booleanPropValueToSet = true;
        this.stringPropValueToSet = "foo";
        this.passwordPropValueToSet = "ThePa$$word!";
    }
}

