/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ConcurrentHashMap;
import kafka.TestLinearWriteSpeed$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Mu!\u0002\u0016,\u0011\u0003qc!\u0002\u0019,\u0011\u0003\t\u0004\"\u0002\u001d\u0002\t\u0003I\u0004\"\u0002\u001e\u0002\t\u0003YdaB(\u0002!\u0003\r\n\u0001\u0015\u0005\u0006#\u00121\tA\u0015\u0005\u0006-\u00121\ta\u0016\u0004\u00051\u0006\u0001\u0011\f\u0003\u0005]\u000f\t\u0015\r\u0011\"\u0001^\u0011!1wA!A!\u0002\u0013q\u0006\u0002C4\b\u0005\u0003\u0005\u000b\u0011\u00025\t\u0011-<!Q1A\u0005\u00021D\u0001b]\u0004\u0003\u0002\u0003\u0006I!\u001c\u0005\u0006q\u001d!\t\u0001\u001e\u0005\bs\u001e\u0011\r\u0011\"\u0001{\u0011\u0019qx\u0001)A\u0005w\"Aqp\u0002b\u0001\n\u0003\t\t\u0001\u0003\u0005\u0002\n\u001d\u0001\u000b\u0011BA\u0002\u0011\u0015\tv\u0001\"\u0001S\u0011\u00151v\u0001\"\u0001X\r\u0019\tY!\u0001\u0001\u0002\u000e!AA\f\u0006BC\u0002\u0013\u0005Q\f\u0003\u0005g)\t\u0005\t\u0015!\u0003_\u0011!YGC!b\u0001\n\u0003a\u0007\u0002C:\u0015\u0005\u0003\u0005\u000b\u0011B7\t\ra\"B\u0011AA\b\u0011%\t9\u0002\u0006b\u0001\n\u0003\tI\u0002\u0003\u0005\u0002(Q\u0001\u000b\u0011BA\u000e\u0011\u0015\tF\u0003\"\u0001S\u0011\u00151F\u0003\"\u0001X\r\u0019\tI#\u0001\u0001\u0002,!I\u0011Q\u0006\u0010\u0003\u0006\u0004%\t!\u0018\u0005\n\u0003_q\"\u0011!Q\u0001\nyC!\"!\r\u001f\u0005\u0003\u0005\u000b\u0011BA\u001a\u0011)\t\tF\bB\u0001B\u0003%\u00111\u000b\u0005\u000b\u0003Gr\"Q1A\u0005\u0002\u0005\u0015\u0004BCA<=\t\u0005\t\u0015!\u0003\u0002h!1\u0001H\bC\u0001\u0003sB\u0011\"!\u000f\u001f\u0005\u0004%\t!!\"\t\u0011\u0005Ee\u0004)A\u0005\u0003\u000fCQ!\u0015\u0010\u0005\u0002ICQA\u0016\u0010\u0005\u0002]\u000bA\u0003V3ti2Kg.Z1s/JLG/Z*qK\u0016$'\"\u0001\u0017\u0002\u000b-\fgm[1\u0004\u0001A\u0011q&A\u0007\u0002W\t!B+Z:u\u0019&tW-\u0019:Xe&$Xm\u00159fK\u0012\u001c\"!\u0001\u001a\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta&\u0001\u0003nC&tGC\u0001\u001f@!\t\u0019T(\u0003\u0002?i\t!QK\\5u\u0011\u0015\u00015\u00011\u0001B\u0003\u0011\t'oZ:\u0011\u0007M\u0012E)\u0003\u0002Di\t)\u0011I\u001d:bsB\u0011Q\t\u0014\b\u0003\r*\u0003\"a\u0012\u001b\u000e\u0003!S!!S\u0017\u0002\rq\u0012xn\u001c;?\u0013\tYE'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001b:\u0013aa\u0015;sS:<'BA&5\u0005!9&/\u001b;bE2,7C\u0001\u00033\u0003\u00159(/\u001b;f)\u0005\u0019\u0006CA\u001aU\u0013\t)FGA\u0002J]R\fQa\u00197pg\u0016$\u0012\u0001\u0010\u0002\r\u001b6\f\u0007o\u0016:ji\u0006\u0014G.Z\n\u0004\u000fIR\u0006CA.\u0005\u001b\u0005\t\u0011\u0001\u00024jY\u0016,\u0012A\u0018\t\u0003?\u0012l\u0011\u0001\u0019\u0006\u0003C\n\f!![8\u000b\u0003\r\fAA[1wC&\u0011Q\r\u0019\u0002\u0005\r&dW-A\u0003gS2,\u0007%\u0001\u0003tSj,\u0007CA\u001aj\u0013\tQGG\u0001\u0003M_:<\u0017aB2p]R,g\u000e^\u000b\u0002[B\u0011a.]\u0007\u0002_*\u0011\u0001OY\u0001\u0004]&|\u0017B\u0001:p\u0005)\u0011\u0015\u0010^3Ck\u001a4WM]\u0001\tG>tG/\u001a8uAQ!QO^<y!\tYv\u0001C\u0003]\u001b\u0001\u0007a\fC\u0003h\u001b\u0001\u0007\u0001\u000eC\u0003l\u001b\u0001\u0007Q.A\u0002sC\u001a,\u0012a\u001f\t\u0003?rL!! 1\u0003!I\u000bg\u000eZ8n\u0003\u000e\u001cWm]:GS2,\u0017\u0001\u0002:bM\u0002\naAY;gM\u0016\u0014XCAA\u0002!\rq\u0017QA\u0005\u0004\u0003\u000fy'\u0001E'baB,GMQ=uK\n+hMZ3s\u0003\u001d\u0011WO\u001a4fe\u0002\u0012qb\u00115b]:,Gn\u0016:ji\u0006\u0014G.Z\n\u0004)IRFCBA\t\u0003'\t)\u0002\u0005\u0002\\)!)A,\u0007a\u0001=\")1.\u0007a\u0001[\u000691\r[1o]\u0016dWCAA\u000e!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011_\u0006A1\r[1o]\u0016d7/\u0003\u0003\u0002&\u0005}!a\u0003$jY\u0016\u001c\u0005.\u00198oK2\f\u0001b\u00195b]:,G\u000e\t\u0002\f\u0019><wK]5uC\ndWmE\u0002\u001fei\u000b1\u0001Z5s\u0003\u0011!\u0017N\u001d\u0011\u0002\r\r|gNZ5h!\u0011\t)$!\u0014\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\t1\u0001\\8h\u0015\u0011\ti$a\u0010\u0002\u0013%tG/\u001a:oC2\u001c(\u0002BA!\u0003\u0007\nqa\u001d;pe\u0006<WMC\u0002-\u0003\u000bRA!a\u0012\u0002J\u00051\u0011\r]1dQ\u0016T!!a\u0013\u0002\u0007=\u0014x-\u0003\u0003\u0002P\u0005]\"!\u0003'pO\u000e{gNZ5h\u0003%\u00198\r[3ek2,'\u000f\u0005\u0003\u0002V\u0005}SBAA,\u0015\u0011\tI&a\u0017\u0002\tU$\u0018\u000e\u001c\u0006\u0005\u0003;\n\u0019%\u0001\u0004tKJ4XM]\u0005\u0005\u0003C\n9FA\u0005TG\",G-\u001e7fe\u0006AQ.Z:tC\u001e,7/\u0006\u0002\u0002hA!\u0011\u0011NA:\u001b\t\tYG\u0003\u0003\u0002n\u0005=\u0014A\u0002:fG>\u0014HM\u0003\u0003\u0002r\u0005\r\u0013AB2p[6|g.\u0003\u0003\u0002v\u0005-$!D'f[>\u0014\u0018PU3d_J$7/A\u0005nKN\u001c\u0018mZ3tAQQ\u00111PA?\u0003\u007f\n\t)a!\u0011\u0005ms\u0002BBA\u0017K\u0001\u0007a\fC\u0004\u00022\u0015\u0002\r!a\r\t\u000f\u0005ES\u00051\u0001\u0002T!9\u00111M\u0013A\u0002\u0005\u001dTCAAD!\u0011\tI)!$\u000e\u0005\u0005-%bAA\u001dW%!\u0011qRAF\u0005%iUM]4fI2{w-\u0001\u0003m_\u001e\u0004\u0003")
public final class TestLinearWriteSpeed {
    public static void main(String[] args) {
        TestLinearWriteSpeed$.MODULE$.main(args);
    }

    public static class ChannelWritable
    implements Writable {
        private final File file;
        private final ByteBuffer content;
        private final FileChannel channel;

        public File file() {
            return this.file;
        }

        public ByteBuffer content() {
            return this.content;
        }

        public FileChannel channel() {
            return this.channel;
        }

        @Override
        public int write() {
            this.channel().write(this.content());
            this.content().rewind();
            return this.content().limit();
        }

        @Override
        public void close() {
            this.channel().close();
            Utils.delete((File)this.file(), (boolean)false);
        }

        public ChannelWritable(File file, ByteBuffer content) {
            this.file = file;
            this.content = content;
            file.deleteOnExit();
            this.channel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        }
    }

    public static class LogWritable
    implements Writable {
        private final File dir;
        private final MemoryRecords messages;
        private final MergedLog log;

        public File dir() {
            return this.dir;
        }

        public MemoryRecords messages() {
            return this.messages;
        }

        public MergedLog log() {
            return this.log;
        }

        @Override
        public int write() {
            this.log().appendAsLeader(this.messages(), 0, this.log().appendAsLeader$default$3(), this.log().appendAsLeader$default$4(), this.log().appendAsLeader$default$5());
            return this.messages().sizeInBytes();
        }

        @Override
        public void close() {
            this.log().close();
            Utils.delete((File)this.log().dir(), (boolean)false);
        }

        public LogWritable(File dir, LogConfig config, Scheduler scheduler, MemoryRecords messages) {
            this.dir = dir;
            this.messages = messages;
            Utils.delete((File)dir, (boolean)false);
            BrokerTopicStats x$6 = new BrokerTopicStats();
            Metrics x$7 = new Metrics();
            Time x$8 = Time.SYSTEM;
            ProducerStateManagerConfig x$10 = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs());
            int x$11 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
            LogDirFailureChannel x$12 = new LogDirFailureChannel(10);
            TierLogComponents x$13 = TierLogComponents$.MODULE$.EMPTY();
            None$ x$14 = None$.MODULE$;
            None$ x$17 = None$.MODULE$;
            LogOffsetsListener x$18 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
            None$ x$19 = None$.MODULE$;
            ConcurrentHashMap x$20 = new ConcurrentHashMap();
            this.log = MergedLog$.MODULE$.apply(dir, config, 0L, 0L, scheduler, x$6, x$7, x$8, 300000, x$10, x$11, (Option)x$17, x$12, x$13, true, (Option)x$14, true, x$18, (Option)x$19, x$20);
        }
    }

    public static class MmapWritable
    implements Writable {
        private final File file;
        private final ByteBuffer content;
        private final RandomAccessFile raf;
        private final MappedByteBuffer buffer;

        public File file() {
            return this.file;
        }

        public ByteBuffer content() {
            return this.content;
        }

        public RandomAccessFile raf() {
            return this.raf;
        }

        public MappedByteBuffer buffer() {
            return this.buffer;
        }

        @Override
        public int write() {
            this.buffer().put(this.content());
            this.content().rewind();
            return this.content().limit();
        }

        @Override
        public void close() {
            this.raf().close();
            Utils.delete((File)this.file(), (boolean)false);
        }

        public MmapWritable(File file, long size, ByteBuffer content) {
            this.file = file;
            this.content = content;
            file.deleteOnExit();
            this.raf = new RandomAccessFile(file, "rw");
            this.raf().setLength(size);
            this.buffer = this.raf().getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.raf().length());
        }
    }

    public static interface Writable {
        public int write();

        public void close();
    }
}

