/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import joptsimple.OptionException;
import kafka.admin.MirrorCommand$;
import kafka.admin.MirrorCommandOptions;
import kafka.admin.MirrorCommandTest$;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeMirrorsOptions;
import org.apache.kafka.clients.admin.DescribeMirrorsResult;
import org.apache.kafka.clients.admin.ListMirrorsOptions;
import org.apache.kafka.clients.admin.ListMirrorsResult;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.NewMirrorTopic;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r-b\u0001\u0002\u00192\u0005YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013%!\t\u0003\u0004G\u0001\u0001\u0006Ia\u0011\u0005\u0006\u000f\u0002!I\u0001\u0013\u0005\n\u0003\u000b\u0003!\u0019!C\u0005\u0003\u000fC\u0001\"a*\u0001A\u0003%\u0011\u0011\u0012\u0005\n\u0003S\u0003!\u0019!C\u0005\u0003WC\u0001\"!5\u0001A\u0003%\u0011Q\u0016\u0005\b\u0003'\u0004A\u0011BAk\u0011\u001d\tI\u0004\u0001C\u0005\u0003OD\u0011B!\u0002\u0001#\u0003%IAa\u0002\t\u0013\tu\u0001!%A\u0005\n\t}\u0001b\u0002B\u0012\u0001\u0011\u0005!Q\u0005\u0005\b\u0005{\u0001A\u0011\u0001B\u0013\u0011\u001d\tY\u0005\u0001C\u0005\u0005\u0003B\u0011Ba\u0019\u0001#\u0003%IAa\b\t\u0013\t\u0015\u0004!%A\u0005\n\t}\u0001\"\u0003B4\u0001E\u0005I\u0011\u0002B5\u0011\u001d\u0011i\u0007\u0001C\u0005\u0005_B\u0011Ba!\u0001#\u0003%IAa\u0002\t\u0013\t\u0015\u0005!%A\u0005\n\t}\u0001b\u0002BD\u0001\u0011\u0005!Q\u0005\u0005\b\u0005\u0017\u0003A\u0011\u0001B\u0013\u0011\u001d\u0011y\t\u0001C\u0005\u0005#C\u0011Ba(\u0001#\u0003%IAa\u0002\t\u0013\t\u0005\u0006!%A\u0005\n\t}\u0001b\u0002BR\u0001\u0011\u0005!Q\u0005\u0005\b\u0005O\u0003A\u0011\u0002BU\u0011%\u0011\u0019\rAI\u0001\n\u0013\u0011)\rC\u0004\u0003J\u0002!\tA!\n\t\u000f\t5\u0007\u0001\"\u0001\u0003&!9!\u0011\u001b\u0001\u0005\u0002\t\u0015\u0002b\u0002Bk\u0001\u0011\u0005!Q\u0005\u0005\b\u00053\u0004A\u0011\u0001B\u0013\u0011\u001d\u0011i\u000e\u0001C\u0001\u0005KAqA!9\u0001\t\u0013\u0011\u0019\u000fC\u0005\u0004\u000e\u0001\t\n\u0011\"\u0003\u0004\u0010!I11\u0003\u0001\u0012\u0002\u0013%1Q\u0003\u0005\b\u00073\u0001A\u0011BB\u000e\r\u0011i\u0006\u0001\u00010\t\u0011-D#\u0011!Q\u0001\n1DQ!\u0010\u0015\u0005\u0002IDQ\u0001\u001e\u0015\u0005BUDq!a\u0006)\t\u0003\nI\u0002C\u0004\u0002:!\"\t%a\u000f\t\u000f\u0005-\u0003\u0006\"\u0011\u0002N!9\u0011q\r\u0015\u0005B\u0005%$!E'jeJ|'oQ8n[\u0006tG\rV3ti*\u0011!gM\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002i\u0005)1.\u00194lC\u000e\u00011C\u0001\u00018!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0010\t\u0003\u0001\u0002i\u0011!M\u0001\fGV\u0014(/\u001a8u)&lW-F\u0001D!\tAD)\u0003\u0002Fs\t\u0019\u0011J\u001c;\u0002\u0019\r,(O]3oiRKW.\u001a\u0011\u0002\u0015I,hnQ8n[\u0006tG\rF\u0002J)f\u0003\"AS)\u000f\u0005-{\u0005C\u0001':\u001b\u0005i%B\u0001(6\u0003\u0019a$o\\8u}%\u0011\u0001+O\u0001\u0007!J,G-\u001a4\n\u0005I\u001b&AB*ue&twM\u0003\u0002Qs!)Q\u000b\u0002a\u0001-\u0006!\u0011M]4t!\rAt+S\u0005\u00031f\u0012Q!\u0011:sCfDQA\u0017\u0003A\u0002m\u000bq\"\\8dW\u0006#W.\u001b8DY&,g\u000e\u001e\t\u00039\"j\u0011\u0001\u0001\u0002\u0010)\u0016\u001cH/\u00113nS:\u001cE.[3oiN\u0011\u0001f\u0018\t\u0003A&l\u0011!\u0019\u0006\u0003e\tT!a\u00193\u0002\u000f\rd\u0017.\u001a8ug*\u0011A'\u001a\u0006\u0003M\u001e\fa!\u00199bG\",'\"\u00015\u0002\u0007=\u0014x-\u0003\u0002kC\nyQj\\2l\u0003\u0012l\u0017N\\\"mS\u0016tG/\u0001\u0003o_\u0012,\u0007CA7q\u001b\u0005q'BA8e\u0003\u0019\u0019w.\\7p]&\u0011\u0011O\u001c\u0002\u0005\u001d>$W\r\u0006\u0002\\g\")1N\u000ba\u0001Y\u0006i!/\u001a9mS\u000e\f7\u000b^1ukN$BA^=\u0002\u000eA\u0011\u0001m^\u0005\u0003q\u0006\u00141CU3qY&\u001c\u0017m\u0015;biV\u001c(+Z:vYRDQA_\u0016A\u0002m\f!\u0002]1si&$\u0018n\u001c8t!\u0015a\u00181AA\u0004\u001b\u0005i(B\u0001@\u0000\u0003\u0011)H/\u001b7\u000b\u0005\u0005\u0005\u0011\u0001\u00026bm\u0006L1!!\u0002~\u0005\r\u0019V\r\u001e\t\u0004[\u0006%\u0011bAA\u0006]\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA\bW\u0001\u0007\u0011\u0011C\u0001\b_B$\u0018n\u001c8t!\r\u0001\u00171C\u0005\u0004\u0003+\t'\u0001\u0006*fa2L7-Y*uCR,8o\u00149uS>t7/\u0001\u0007bYR,'/T5se>\u00148\u000f\u0006\u0004\u0002\u001c\u0005\u0005\u0012\u0011\u0007\t\u0004A\u0006u\u0011bAA\u0010C\n\u0011\u0012\t\u001c;fe6K'O]8sgJ+7/\u001e7u\u0011\u001d\t\u0019\u0003\fa\u0001\u0003K\t1a\u001c9t!\u0019a\u0018qE%\u0002,%\u0019\u0011\u0011F?\u0003\u00075\u000b\u0007\u000fE\u0002a\u0003[I1!a\fb\u00055\tE\u000e^3s\u001b&\u0014(o\u001c:Pa\"9\u0011q\u0002\u0017A\u0002\u0005M\u0002c\u00011\u00026%\u0019\u0011qG1\u0003'\u0005cG/\u001a:NSJ\u0014xN]:PaRLwN\\:\u0002\u00171L7\u000f^'jeJ|'o\u001d\u000b\u0005\u0003{\t\u0019\u0005E\u0002a\u0003\u007fI1!!\u0011b\u0005Ea\u0015n\u001d;NSJ\u0014xN]:SKN,H\u000e\u001e\u0005\b\u0003\u001fi\u0003\u0019AA#!\r\u0001\u0017qI\u0005\u0004\u0003\u0013\n'A\u0005'jgRl\u0015N\u001d:peN|\u0005\u000f^5p]N\fq\u0002Z3tGJL'-Z'jeJ|'o\u001d\u000b\u0007\u0003\u001f\n)&a\u0018\u0011\u0007\u0001\f\t&C\u0002\u0002T\u0005\u0014Q\u0003R3tGJL'-Z'jeJ|'o\u001d*fgVdG\u000fC\u0004\u0002X9\u0002\r!!\u0017\u0002\rQ|\u0007/[2t!\u0011a\u00181L%\n\u0007\u0005uSP\u0001\u0006D_2dWm\u0019;j_:Dq!a\u0004/\u0001\u0004\t\t\u0007E\u0002a\u0003GJ1!!\u001ab\u0005Y!Um]2sS\n,W*\u001b:s_J\u001cx\n\u001d;j_:\u001c\u0018\u0001D2sK\u0006$X\rV8qS\u000e\u001cHCBA6\u0003c\ni\bE\u0002a\u0003[J1!a\u001cb\u0005I\u0019%/Z1uKR{\u0007/[2t%\u0016\u001cX\u000f\u001c;\t\u000f\u0005Mt\u00061\u0001\u0002v\u0005Ia.Z<U_BL7m\u001d\t\u0006y\u0006m\u0013q\u000f\t\u0004A\u0006e\u0014bAA>C\nAa*Z<U_BL7\rC\u0004\u0002\u0010=\u0002\r!a \u0011\u0007\u0001\f\t)C\u0002\u0002\u0004\u0006\u00141c\u0011:fCR,Gk\u001c9jGN|\u0005\u000f^5p]N\fq\"\u00197m\t\u0016\u001c8M]5qi&|gn]\u000b\u0003\u0003\u0013\u0003\u0002\"a#\u0002\u0016\u0006]\u0015\u0011U\u0007\u0003\u0003\u001bSA!a$\u0002\u0012\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003'K\u0014AC2pY2,7\r^5p]&!\u0011\u0011FAG!\u0011\tI*a(\u000e\u0005\u0005m%bAAO\u007f\u0006!A.\u00198h\u0013\r\u0011\u00161\u0014\t\u0004A\u0006\r\u0016bAASC\n1R*\u001b:s_J$v\u000e]5d\t\u0016\u001c8M]5qi&|g.\u0001\tbY2$Um]2sSB$\u0018n\u001c8tA\u0005i\u0011\r\u001c7QCJ$\u0018\u000e^5p]N,\"!!,\u0011\u0011\u0005-\u0015QSAL\u0003_\u0003b!a#\u00022\u0006U\u0016\u0002BAZ\u0003\u001b\u0013A\u0001T5tiB1\u0011qWAa\u0003\u000btA!!/\u0002>:\u0019A*a/\n\u0003iJ1!a0:\u0003\u001d\u0001\u0018mY6bO\u0016LA!a-\u0002D*\u0019\u0011qX\u001d\u0011\t\u0005\u001d\u0017QZ\u0007\u0003\u0003\u0013T1!a3o\u0003\u001d\u0011X\r\u001d7jG\u0006LA!a4\u0002J\ni!+\u001a9mS\u000e\f7\u000b^1ukN\fa\"\u00197m!\u0006\u0014H/\u001b;j_:\u001c\b%A\u000emK\u0006$WM\u001d(pi\u00063\u0018-\u001b7bE2,W\t_2faRLwN\u001c\u000b\u0005\u0003/\f\u0019\u000f\u0005\u0003\u0002Z\u0006}WBAAn\u0015\r\tiN\\\u0001\u0007KJ\u0014xN]:\n\t\u0005\u0005\u00181\u001c\u0002\u001c\u0019\u0016\fG-\u001a:O_R\fe/Y5mC\ndW-\u0012=dKB$\u0018n\u001c8\t\u000f\u0005\u0015\u0018\u00021\u0001\u0002\b\u0005I\u0001/\u0019:uSRLwN\u001c\u000b\t\u0003S\fy/!=\u0002|B\u0019\u0001(a;\n\u0007\u00055\u0018H\u0001\u0003V]&$\b\"B+\u000b\u0001\u00041\u0006\"CAz\u0015A\u0005\t\u0019AA{\u0003!a\u0017N\\6OC6,\u0007\u0003\u0002\u001d\u0002x&K1!!?:\u0005\u0019y\u0005\u000f^5p]\"I\u0011Q \u0006\u0011\u0002\u0003\u0007\u0011q`\u0001\u000fS:\u001cG.\u001e3f'R|\u0007\u000f]3e!\rA$\u0011A\u0005\u0004\u0005\u0007I$a\u0002\"p_2,\u0017M\\\u0001\u0016Y&\u001cH/T5se>\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011IA\u000b\u0003\u0002v\n-1F\u0001B\u0007!\u0011\u0011yA!\u0007\u000e\u0005\tE!\u0002\u0002B\n\u0005+\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t]\u0011(\u0001\u0006b]:|G/\u0019;j_:LAAa\u0007\u0003\u0012\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002+1L7\u000f^'jeJ|'o\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u0005\u0016\u0005\u0003\u007f\u0014Y!A\buKN$H*[:u\u001b&\u0014(o\u001c:t)\t\tI\u000fK\u0002\u000e\u0005S\u0001BAa\u000b\u0003:5\u0011!Q\u0006\u0006\u0005\u0005_\u0011\t$A\u0002ba&TAAa\r\u00036\u00059!.\u001e9ji\u0016\u0014(b\u0001B\u001cO\u0006)!.\u001e8ji&!!1\bB\u0017\u0005\u0011!Vm\u001d;\u0002'Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3NSJ\u0014xN]:)\u00079\u0011I\u0003\u0006\b\u0002j\n\r#Q\tB(\u0005'\u00129Fa\u0017\t\u000bU{\u0001\u0019\u0001,\t\u000f\t\u001ds\u00021\u0001\u0003J\u0005)B-Z:de&\u0014W-T5se>\u00148\u000fV8qS\u000e\u001c\b#BA\\\u0005\u0017J\u0015\u0002\u0002B'\u0003\u0007\u00141aU3r\u0011\u001d\u0011\tf\u0004a\u0001\u0005\u0013\n\u0011$\u00193nS:\u001cE.[3oiJ+G/\u001e:oK\u0012$v\u000e]5dg\"I!QK\b\u0011\u0002\u0003\u0007\u0011q`\u0001\u000bKb\u0004Xm\u0019;MSN$\b\"\u0003B-\u001fA\u0005\t\u0019AA\u0000\u0003-\u0001XM\u001c3j]\u001e\u001cFo\u001c9\t\u0013\tus\u0002%AA\u0002\t}\u0013\u0001H1e[&t7\t\\5f]R4\u0015\u000e\u001c;fe\u0016$w*\u001e;U_BL7m\u001d\t\u0005\u0015\n\u0005\u0014*C\u0002\u0002\u0006M\u000b\u0011\u0004Z3tGJL'-Z'jeJ|'o\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005IB-Z:de&\u0014W-T5se>\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003e!Wm]2sS\n,W*\u001b:s_J\u001cH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\t-$\u0006\u0002B0\u0005\u0017\t1b\u001d;pa6K'O]8sgRa\u0011\u0011\u001eB9\u0005g\u00129Ha\u001f\u0003\u0000!)Qk\u0005a\u0001-\"9!QO\nA\u0002\t%\u0013AD3ya\u0016\u001cG/\u001a3U_BL7m\u001d\u0005\b\u0005s\u001a\u0002\u0019AA\u0000\u0003E)\u0007\u0010]3diNKhn\u00195s_:L'0\u001a\u0005\n\u0005{\u001a\u0002\u0013!a\u0001\u0003k\fa\"\u001a=qK\u000e$H*\u001b8l\u001d\u0006lW\rC\u0005\u0003\u0002N\u0001\n\u00111\u0001\u0002\u0000\u0006\u0011R\r\u001f9fGR4\u0016\r\\5eCR,wJ\u001c7z\u0003U\u0019Ho\u001c9NSJ\u0014xN]:%I\u00164\u0017-\u001e7uIQ\nQc\u001d;pa6K'O]8sg\u0012\"WMZ1vYR$S'\u0001\nuKN$\bK]8n_R,W*\u001b:s_J\u001c\bf\u0001\f\u0003*\u0005\u0019B/Z:u\r\u0006LGn\u001c<fe6K'O]8sg\"\u001aqC!\u000b\u0002\u0019A\fWo]3NSJ\u0014xN]:\u0015\u0019\u0005%(1\u0013BK\u00053\u0013YJ!(\t\u000bUC\u0002\u0019\u0001,\t\u000f\t]\u0005\u00041\u0001\u0002\u0000\u0006aQ\r\u001f9fGR,e.\u00192mK\"9!Q\u000f\rA\u0002\t%\u0003\"\u0003B?1A\u0005\t\u0019AA{\u0011%\u0011\t\t\u0007I\u0001\u0002\u0004\ty0\u0001\fqCV\u001cX-T5se>\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003Y\u0001\u0018-^:f\u001b&\u0014(o\u001c:tI\u0011,g-Y;mi\u0012*\u0014\u0001\u0005;fgR\u0004\u0016-^:f\u001b&\u0014(o\u001c:tQ\rY\"\u0011F\u0001\rGJ,\u0017\r^3NSJ\u0014xN\u001d\u000b\r\u0003S\u0014YK!,\u00032\nM&q\u0017\u0005\u0006+r\u0001\rA\u0016\u0005\b\u0005_c\u0002\u0019AA{\u0003-)\u0007\u0010]3diR{\u0007/[2\t\u000f\tuD\u00041\u0001\u0002v\"9!Q\u0017\u000fA\u0002\u0005U\u0018!E3ya\u0016\u001cG/T5se>\u0014Hk\u001c9jG\"I!\u0011\u0018\u000f\u0011\u0002\u0003\u0007!1X\u0001\u0018Kb\u0004Xm\u0019;SKBd\u0017nY1uS>tg)Y2u_J\u0004R\u0001OA|\u0005{\u0003B!!'\u0003@&!!\u0011YAN\u0005\u001dIe\u000e^3hKJ\fac\u0019:fCR,W*\u001b:s_J$C-\u001a4bk2$H%N\u000b\u0003\u0005\u000fTCAa/\u0003\f\u0005\u0001B/Z:u\u0007J,\u0017\r^3NSJ\u0014xN\u001d\u0015\u0004=\t%\u0012a\u0004;fgR\u0014\u0015\rZ\"p[6\fg\u000eZ:)\u0007}\u0011I#A\fuKN$X*[:tS:<'+Z9vSJ,G-\u0011:hg\"\u001a\u0001E!\u000b\u0002\u001fQ,7\u000f^%om\u0006d\u0017\u000eZ!sOND3!\tB\u0015\u0003y!Xm\u001d;NSJ\u0014xN\u001d)beRLG/[8o\u0013:4wN]7bi&|g\u000eK\u0002#\u0005S\t!\u0004^3ti6K'O]8s)>\u0004\u0018nY%oM>\u0014X.\u0019;j_:D3a\tB\u0015\u00039qWm\u001e#fg\u000e\u0014\u0018\u000e\u001d;j_:$\u0002#!)\u0003f\n\u001d(1\u001eBx\u0005g\u0014ipa\u0001\t\r\u0005MH\u00051\u0001J\u0011\u0019\u0011I\u000f\na\u0001\u0013\u0006Y1o\\;sG\u0016$v\u000e]5d\u0011\u0019\u0011i\u000f\na\u0001\u0007\u0006ia.^7QCJ$\u0018\u000e^5p]NDaA!=%\u0001\u0004I\u0015\u0001C:uCR,7\u000b\u001e:\t\u000f\tUH\u00051\u0001\u0003x\u0006Y1\u000f^1uKRKW.Z't!\rA$\u0011`\u0005\u0004\u0005wL$\u0001\u0002'p]\u001eD\u0011Ba@%!\u0003\u0005\ra!\u0001\u0002)M$x\u000e\u001d9fI2{w-\u00128e\u001f\u001a47/\u001a;t!\u0019\t9,!1\u0003x\"I1Q\u0001\u0013\u0011\u0002\u0003\u00071qA\u0001\bi>\u0004\u0018nY%e!\ri7\u0011B\u0005\u0004\u0007\u0017q'\u0001B+vS\u0012\f\u0001D\\3x\t\u0016\u001c8M]5qi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00137+\t\u0019\tB\u000b\u0003\u0004\u0002\t-\u0011\u0001\u00078fo\u0012+7o\u0019:jaRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%oU\u00111q\u0003\u0016\u0005\u0007\u000f\u0011Y!\u0001\u0007oK^\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0006\u00026\u000eu1qDB\u0012\u0007OAaA!=(\u0001\u0004I\u0005bBB\u0011O\u0001\u0007!q_\u0001\rY><WI\u001c3PM\u001a\u001cX\r\u001e\u0005\b\u0007K9\u0003\u0019\u0001B|\u0003ia\u0017m\u001d;NSJ\u0014xN\u001d$fi\u000eDG+[7f\t\u0016dG/Y't\u0011\u001d\u0019Ic\na\u0001\u0005o\f!\u0005\\1ti6K'O]8s\r\u0016$8\r[*pkJ\u001cW\rS5hQ^\u000bG/\u001a:nCJ\\\u0007")
public final class MirrorCommandTest {
    private final int currentTime;
    private final scala.collection.immutable.Map<String, MirrorTopicDescription> allDescriptions;
    private final scala.collection.immutable.Map<String, List<List<ReplicaStatus>>> allPartitions;

    private int currentTime() {
        return this.currentTime;
    }

    private String runCommand(String[] args, TestAdminClient mockAdminClient) {
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> MirrorCommand$.MODULE$.run((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", "localhost:9092"}), (Object)args, ClassTag$.MODULE$.apply(String.class)), (Option)new Some((Object)mockAdminClient));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return grabConsoleOutput_out.toString();
    }

    private scala.collection.immutable.Map<String, MirrorTopicDescription> allDescriptions() {
        return this.allDescriptions;
    }

    private scala.collection.immutable.Map<String, List<List<ReplicaStatus>>> allPartitions() {
        return this.allPartitions;
    }

    private LeaderNotAvailableException leaderNotAvailableException(TopicPartition partition) {
        return new LeaderNotAvailableException(new java.lang.StringBuilder(32).append("Leader for partition ").append(partition).append(" not found.").toString());
    }

    private void listMirrors(String[] args, Option<String> linkName, boolean includeStopped) {
        BooleanRef issuedCommand = BooleanRef.create((boolean)false);
        scala.collection.immutable.Set topics = ((MapOps)this.allDescriptions().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MirrorCommandTest.$anonfun$listMirrors$1(linkName, includeStopped, x0$1)))).keys().toSet();
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete((Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)topics).asJavaCollection());
        ListMirrorsResult result = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)result.result()).thenReturn((Object)future);
        Node node = new Node(1, "localhost", 9092);
        TestAdminClient mockAdminClient = new TestAdminClient(this, node, issuedCommand, linkName, includeStopped, result){
            private final BooleanRef issuedCommand$1;
            private final Option linkName$1;
            private final boolean includeStopped$1;
            private final ListMirrorsResult result$1;

            public ListMirrorsResult listMirrors(ListMirrorsOptions options) {
                this.issuedCommand$1.elem = true;
                Assertions.assertEquals((Object)this.linkName$1, (Object)Option$.MODULE$.apply(options.linkName().orElse(null)));
                Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.includeStopped$1), (Object)BoxesRunTime.boxToBoolean((boolean)options.includeStopped()));
                return this.result$1;
            }
            {
                this.issuedCommand$1 = issuedCommand$1;
                this.linkName$1 = linkName$1;
                this.includeStopped$1 = includeStopped$1;
                this.result$1 = result$1;
                super(node$1);
            }
        };
        String output = this.runCommand((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--list"}), (Object)args, ClassTag$.MODULE$.apply(String.class)), mockAdminClient);
        Assertions.assertTrue((boolean)issuedCommand.elem);
        ((ListMirrorsResult)Mockito.verify((Object)result)).result();
        Mockito.reset((Object[])new ListMirrorsResult[]{result});
        this.allDescriptions().foreach((Function1 & Serializable)x0$2 -> {
            MirrorCommandTest.$anonfun$listMirrors$3(topics, output, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private Option<String> listMirrors$default$2() {
        return None$.MODULE$;
    }

    private boolean listMirrors$default$3() {
        return false;
    }

    @Test
    public void testListMirrors() {
        this.listMirrors((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), (Option<String>)None$.MODULE$, false);
        this.listMirrors(new String[]{"--link", "link-1"}, (Option<String>)new Some((Object)"link-1"), false);
        String[] x$1 = new String[]{"--include-stopped"};
        None$ x$3 = None$.MODULE$;
        this.listMirrors(x$1, (Option<String>)x$3, true);
        this.listMirrors(new String[]{"--link", "link-2", "--include-stopped"}, (Option<String>)new Some((Object)"link-2"), true);
    }

    @Test
    public void testDescribeMirrors() {
        this.describeMirrors(new String[]{"--topics", "topic-3"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-3", (List)Nil$.MODULE$), (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-3", (List)Nil$.MODULE$), false, false, this.describeMirrors$default$6());
        this.describeMirrors(new String[]{"--topics", "topic-1,topic-4"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-1", (List)new .colon.colon((Object)"topic-4", (List)Nil$.MODULE$)), (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-1", (List)new .colon.colon((Object)"topic-4", (List)Nil$.MODULE$)), false, false, this.describeMirrors$default$6());
        this.describeMirrors(new String[]{"--topics", "topic-nonexistent"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-nonexistent", (List)Nil$.MODULE$), (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-nonexistent", (List)Nil$.MODULE$), false, false, this.describeMirrors$default$6());
        this.describeMirrors(new String[]{"--pending-stopped-only"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-6", (List)new .colon.colon((Object)"topic-16", (List)new .colon.colon((Object)"topic-1", (List)Nil$.MODULE$))), (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-6", (List)new .colon.colon((Object)"topic-16", (List)Nil$.MODULE$)), true, true, this.describeMirrors$default$6());
        this.describeMirrors(new String[]{"--topics", "topic-7"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-7", (List)Nil$.MODULE$), (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-7", (List)Nil$.MODULE$), false, false, this.describeMirrors$default$6());
        this.describeMirrors((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"topic-1", "topic-2", "topic-3", "topic-4", "topic-5", "topic-6", "topic-7", "topic-11", "topic-12", "topic-13", "topic-14", "topic-15", "topic-16", "topic-17", "topic-18"}))), (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"topic-1", "topic-2", "topic-3", "topic-4", "topic-5", "topic-6", "topic-7", "topic-11", "topic-12", "topic-13", "topic-14", "topic-15", "topic-16", "topic-17", "topic-18"}))), true, false, this.describeMirrors$default$6());
        String[] x$1 = new String[]{"--topics", "topic-1,topic-18", "--links", "link-1"};
        .colon.colon x$2 = new .colon.colon((Object)"topic-1", (List)new .colon.colon((Object)"topic-18", (List)Nil$.MODULE$));
        .colon.colon x$3 = new .colon.colon((Object)"topic-1", (List)Nil$.MODULE$);
        scala.collection.immutable.Set x$4 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"topic-18"}));
        boolean x$5 = false;
        boolean x$6 = false;
        this.describeMirrors(x$1, (scala.collection.immutable.Seq<String>)x$2, (scala.collection.immutable.Seq<String>)x$3, x$5, x$6, (scala.collection.immutable.Set<String>)x$4);
    }

    private void describeMirrors(String[] args, scala.collection.immutable.Seq<String> describeMirrorsTopics, scala.collection.immutable.Seq<String> adminClientReturnedTopics, boolean expectList, boolean pendingStop, scala.collection.immutable.Set<String> adminClientFilteredOutTopics) {
        BooleanRef issuedCommand = BooleanRef.create((boolean)false);
        BooleanRef issuedReplicaStatusCommand = BooleanRef.create((boolean)false);
        BooleanRef issuedListCommand = BooleanRef.create((boolean)false);
        scala.collection.immutable.Map ret = (scala.collection.immutable.Map)((IterableOnceOps)describeMirrorsTopics.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)this.allDescriptions().get(t)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) throw new MatchError(null);
            String t = (String)x0$1._1();
            Option d = (Option)x0$1._2();
            KafkaFutureImpl future = new KafkaFutureImpl();
            boolean bl = false;
            if (d instanceof Some) {
                bl = true;
                MirrorTopicDescription desc = (MirrorTopicDescription)((Some)d).value();
                if (!adminClientFilteredOutTopics.contains((Object)t)) {
                    future.complete((Object)desc);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), (Object)future);
                }
            }
            if (bl) {
                future.complete(null);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), (Object)future);
            }
            if (!None$.MODULE$.equals(d)) throw new MatchError((Object)d);
            future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException(""));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), (Object)future);
        });
        DescribeMirrorsResult result = (DescribeMirrorsResult)Mockito.mock(DescribeMirrorsResult.class);
        Mockito.when((Object)result.result()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)ret).asJava());
        scala.collection.immutable.Map partitions = ((IterableOnceOps)((IterableOps)adminClientReturnedTopics.flatMap((Function1 & Serializable)topic -> this.allDescriptions().get(topic).map((Function1 & Serializable)desc -> package$.MODULE$.Range().apply(0, desc.numPartitions()).map((Function1 & Serializable)part -> MirrorCommandTest.$anonfun$describeMirrors$5(this, topic, BoxesRunTime.unboxToInt((Object)part))).toList()))).flatten(Predef$.MODULE$.$conforms())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        ReplicaStatusResult replicaStatusResult = (ReplicaStatusResult)Mockito.mock(ReplicaStatusResult.class);
        Mockito.when((Object)replicaStatusResult.result()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)partitions).asJava());
        ListMirrorsResult listResult = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        if (expectList) {
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.complete((Object)CollectionConverters$.MODULE$.IterableHasAsJava(((MapOps)this.allDescriptions().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MirrorCommandTest.$anonfun$describeMirrors$6(x$2)))).keys()).asJavaCollection());
            Mockito.when((Object)listResult.result()).thenReturn((Object)future);
        }
        Node node = new Node(1, "localhost", 9092);
        TestAdminClient mockAdminClient = new TestAdminClient(this, node, issuedReplicaStatusCommand, replicaStatusResult, issuedListCommand, listResult, issuedCommand, pendingStop, adminClientReturnedTopics, adminClientFilteredOutTopics, result){
            private final BooleanRef issuedReplicaStatusCommand$1;
            private final ReplicaStatusResult replicaStatusResult$1;
            private final BooleanRef issuedListCommand$1;
            private final ListMirrorsResult listResult$1;
            private final BooleanRef issuedCommand$2;
            private final boolean pendingStop$1;
            private final scala.collection.immutable.Seq adminClientReturnedTopics$1;
            private final scala.collection.immutable.Set adminClientFilteredOutTopics$1;
            private final DescribeMirrorsResult result$2;

            public ReplicaStatusResult replicaStatus(Set<TopicPartition> partitions, ReplicaStatusOptions options) {
                this.issuedReplicaStatusCommand$1.elem = true;
                return this.replicaStatusResult$1;
            }

            public ListMirrorsResult listMirrors(ListMirrorsOptions options) {
                this.issuedListCommand$1.elem = true;
                return this.listResult$1;
            }

            public DescribeMirrorsResult describeMirrors(Collection<String> topics, DescribeMirrorsOptions options) {
                this.issuedCommand$2.elem = true;
                if (!this.pendingStop$1) {
                    Assertions.assertEquals((Object)((scala.collection.immutable.Set)this.adminClientReturnedTopics$1.toSet().$plus$plus((IterableOnce)this.adminClientFilteredOutTopics$1)), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(topics).asScala().toSet());
                }
                return this.result$2;
            }
            {
                this.issuedReplicaStatusCommand$1 = issuedReplicaStatusCommand$1;
                this.replicaStatusResult$1 = replicaStatusResult$1;
                this.issuedListCommand$1 = issuedListCommand$1;
                this.listResult$1 = listResult$1;
                this.issuedCommand$2 = issuedCommand$2;
                this.pendingStop$1 = pendingStop$1;
                this.adminClientReturnedTopics$1 = adminClientReturnedTopics$1;
                this.adminClientFilteredOutTopics$1 = adminClientFilteredOutTopics$1;
                this.result$2 = result$2;
                super(node$2);
            }
        };
        String output = this.runCommand((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--describe"}), (Object)args, ClassTag$.MODULE$.apply(String.class)), mockAdminClient);
        Assertions.assertTrue((boolean)issuedCommand.elem);
        Assertions.assertTrue((boolean)issuedReplicaStatusCommand.elem);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectList), (Object)BoxesRunTime.boxToBoolean((boolean)issuedListCommand.elem));
        ((DescribeMirrorsResult)Mockito.verify((Object)result)).result();
        ((ReplicaStatusResult)Mockito.verify((Object)replicaStatusResult)).result();
        Mockito.reset((Object[])new DescribeMirrorsResult[]{result});
        Mockito.reset((Object[])new ReplicaStatusResult[]{replicaStatusResult});
        if (expectList) {
            ((ListMirrorsResult)Mockito.verify((Object)listResult)).result();
            Mockito.reset((Object[])new ListMirrorsResult[]{listResult});
        }
        this.allDescriptions().foreach((Function1 & Serializable)x0$2 -> {
            MirrorCommandTest.$anonfun$describeMirrors$7(this, adminClientReturnedTopics, args, output, x0$2);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)output.contains(new StringBuilder().append('\n').append('\n').toString()));
        adminClientReturnedTopics.foreach((Function1 & Serializable)t -> {
            MirrorCommandTest.$anonfun$describeMirrors$10(this, output, t);
            return BoxedUnit.UNIT;
        });
    }

    private boolean describeMirrors$default$4() {
        return false;
    }

    private boolean describeMirrors$default$5() {
        return false;
    }

    private scala.collection.immutable.Set<String> describeMirrors$default$6() {
        return Predef$.MODULE$.Set().empty();
    }

    private void stopMirrors(String[] args, scala.collection.immutable.Seq<String> expectedTopics, boolean expectSynchronize, Option<String> expectLinkName, boolean expectValidateOnly) {
        BooleanRef issuedCommand = BooleanRef.create((boolean)false);
        BooleanRef issuedListCommand = BooleanRef.create((boolean)false);
        BooleanRef issuedDescribeCommand = BooleanRef.create((boolean)false);
        BooleanRef issuedReplicaStatusCommand = BooleanRef.create((boolean)false);
        DescribeMirrorsResult describeResult = (DescribeMirrorsResult)Mockito.mock(DescribeMirrorsResult.class);
        if (expectSynchronize && !expectValidateOnly) {
            scala.collection.immutable.Map ret = (scala.collection.immutable.Map)((IterableOnceOps)expectedTopics.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)this.allDescriptions().get(t)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String t = (String)x0$1._1();
                    Option d = (Option)x0$1._2();
                    KafkaFutureImpl future = new KafkaFutureImpl();
                    if (d instanceof Some) {
                        MirrorTopicDescription desc = (MirrorTopicDescription)((Some)d).value();
                        future.complete((Object)desc);
                    } else if (None$.MODULE$.equals(d)) {
                        future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException(""));
                    } else {
                        throw new MatchError((Object)d);
                    }
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), (Object)future);
                }
                throw new MatchError(null);
            });
            Mockito.when((Object)describeResult.result()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)ret).asJava());
        }
        ReplicaStatusResult replicaStatusResult = (ReplicaStatusResult)Mockito.mock(ReplicaStatusResult.class);
        if (expectSynchronize && !expectValidateOnly) {
            scala.collection.immutable.Map partitions = ((IterableOnceOps)((IterableOps)expectedTopics.flatMap((Function1 & Serializable)topic -> this.allDescriptions().get(topic).map((Function1 & Serializable)desc -> package$.MODULE$.Range().apply(0, desc.numPartitions()).map((Function1 & Serializable)part -> MirrorCommandTest.$anonfun$stopMirrors$5(this, topic, BoxesRunTime.unboxToInt((Object)part))).toList()))).flatten(Predef$.MODULE$.$conforms())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Mockito.when((Object)replicaStatusResult.result()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)partitions).asJava());
        }
        scala.collection.immutable.Map results = ((IterableOnceOps)expectedTopics.map((Function1 & Serializable)topic -> {
            KafkaFutureImpl future = new KafkaFutureImpl();
            Option option = this.allDescriptions().get(topic);
            if (option instanceof Some) {
                future.complete(null);
            } else if (None$.MODULE$.equals(option)) {
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException(""));
            } else {
                throw new MatchError((Object)option);
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)future);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        AlterMirrorsResult result = (AlterMirrorsResult)Mockito.mock(AlterMirrorsResult.class);
        Mockito.when((Object)result.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)results).asJava());
        ListMirrorsResult listResult = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        expectLinkName.foreach((Function1 & Serializable)linkName -> {
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.complete((Object)CollectionConverters$.MODULE$.IterableHasAsJava(((MapOps)this.allDescriptions().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MirrorCommandTest.$anonfun$stopMirrors$8(linkName, x$4)))).keys()).asJavaCollection());
            return Mockito.when((Object)listResult.result()).thenReturn((Object)future);
        });
        Node node = new Node(1, "localhost", 9092);
        TestAdminClient mockAdminClient = new TestAdminClient(this, node, issuedReplicaStatusCommand, replicaStatusResult, issuedListCommand, listResult, issuedCommand, expectedTopics, expectValidateOnly, expectSynchronize, result, issuedDescribeCommand, describeResult){
            private final BooleanRef issuedReplicaStatusCommand$2;
            private final ReplicaStatusResult replicaStatusResult$2;
            private final BooleanRef issuedListCommand$2;
            private final ListMirrorsResult listResult$2;
            private final BooleanRef issuedCommand$3;
            private final scala.collection.immutable.Seq expectedTopics$1;
            private final boolean expectValidateOnly$1;
            private final boolean expectSynchronize$1;
            private final AlterMirrorsResult result$3;
            private final BooleanRef issuedDescribeCommand$1;
            private final DescribeMirrorsResult describeResult$1;

            public ReplicaStatusResult replicaStatus(Set<TopicPartition> partitions, ReplicaStatusOptions options) {
                this.issuedReplicaStatusCommand$2.elem = true;
                return this.replicaStatusResult$2;
            }

            public ListMirrorsResult listMirrors(ListMirrorsOptions options) {
                this.issuedListCommand$2.elem = true;
                return this.listResult$2;
            }

            public AlterMirrorsResult alterMirrors(java.util.Map<String, AlterMirrorOp> ops, AlterMirrorsOptions options) {
                this.issuedCommand$3.elem = true;
                Assertions.assertEquals((int)this.expectedTopics$1.size(), (int)ops.size());
                Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.expectValidateOnly$1), (Object)BoxesRunTime.boxToBoolean((boolean)options.validateOnly()));
                CollectionConverters$.MODULE$.MapHasAsScala(ops).asScala().foreach((Function1 & Serializable)x0$1 -> {
                    $anon$3.$anonfun$alterMirrors$1(this, x0$1);
                    return BoxedUnit.UNIT;
                });
                return this.result$3;
            }

            public DescribeMirrorsResult describeMirrors(Collection<String> topics, DescribeMirrorsOptions options) {
                this.issuedDescribeCommand$1.elem = true;
                Assertions.assertEquals((Object)this.expectedTopics$1.toSet(), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(topics).asScala().toSet());
                return this.describeResult$1;
            }

            public static final /* synthetic */ void $anonfun$alterMirrors$1($anon$3 $this, Tuple2 x0$1) {
                if (x0$1 != null) {
                    String topic = (String)x0$1._1();
                    AlterMirrorOp op = (AlterMirrorOp)x0$1._2();
                    Assertions.assertTrue((boolean)$this.expectedTopics$1.contains((Object)topic));
                    Assertions.assertEquals((Object)($this.expectSynchronize$1 ? AlterMirrorOp.PROMOTE : AlterMirrorOp.FAILOVER), (Object)op);
                    return;
                }
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Unexpected op type");
            }
            {
                this.issuedReplicaStatusCommand$2 = issuedReplicaStatusCommand$2;
                this.replicaStatusResult$2 = replicaStatusResult$2;
                this.issuedListCommand$2 = issuedListCommand$2;
                this.listResult$2 = listResult$2;
                this.issuedCommand$3 = issuedCommand$3;
                this.expectedTopics$1 = expectedTopics$1;
                this.expectValidateOnly$1 = expectValidateOnly$1;
                this.expectSynchronize$1 = expectSynchronize$1;
                this.result$3 = result$3;
                this.issuedDescribeCommand$1 = issuedDescribeCommand$1;
                this.describeResult$1 = describeResult$1;
                super(node$3);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$alterMirrors$1$adapted(kafka.admin.MirrorCommandTest$$anon$3 scala.Tuple2 )}, serializedLambda);
            }
        };
        String command = expectSynchronize ? "--promote" : "--failover";
        this.runCommand((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{command}), (Object)args, ClassTag$.MODULE$.apply(String.class)), mockAdminClient);
        Assertions.assertTrue((boolean)issuedCommand.elem);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectLinkName.nonEmpty()), (Object)BoxesRunTime.boxToBoolean((boolean)issuedListCommand.elem));
        if (!expectValidateOnly) {
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectSynchronize), (Object)BoxesRunTime.boxToBoolean((boolean)issuedDescribeCommand.elem));
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectSynchronize), (Object)BoxesRunTime.boxToBoolean((boolean)issuedReplicaStatusCommand.elem));
        }
        ((AlterMirrorsResult)Mockito.verify((Object)result)).values();
        ((ListMirrorsResult)Mockito.verify((Object)listResult, (VerificationMode)Mockito.times((int)Option$.MODULE$.option2Iterable(expectLinkName).size()))).result();
        Mockito.reset((Object[])new AlterMirrorsResult[]{result});
        Mockito.reset((Object[])new ListMirrorsResult[]{listResult});
        if (expectSynchronize && !expectValidateOnly) {
            ((DescribeMirrorsResult)Mockito.verify((Object)describeResult)).result();
            ((ReplicaStatusResult)Mockito.verify((Object)replicaStatusResult)).result();
            Mockito.reset((Object[])new DescribeMirrorsResult[]{describeResult});
            Mockito.reset((Object[])new ReplicaStatusResult[]{replicaStatusResult});
            return;
        }
    }

    private Option<String> stopMirrors$default$4() {
        return None$.MODULE$;
    }

    private boolean stopMirrors$default$5() {
        return false;
    }

    @Test
    public void testPromoteMirrors() {
        this.stopMirrors(new String[]{"--topics", "topic-13"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-13", (List)Nil$.MODULE$), true, (Option<String>)None$.MODULE$, false);
        this.stopMirrors(new String[]{"--topics", "topic-11,topic-14"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-11", (List)new .colon.colon((Object)"topic-14", (List)Nil$.MODULE$)), true, (Option<String>)None$.MODULE$, false);
        this.stopMirrors(new String[]{"--topics", "topic-nonexistent"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-nonexistent", (List)Nil$.MODULE$), true, (Option<String>)None$.MODULE$, false);
        String[] x$1 = new String[]{"--link", "link-12"};
        .colon.colon x$2 = new .colon.colon((Object)"topic-13", (List)new .colon.colon((Object)"topic-14", (List)new .colon.colon((Object)"topic-15", (List)new .colon.colon((Object)"topic-16", (List)Nil$.MODULE$))));
        Some x$3 = new Some((Object)"link-12");
        boolean x$5 = false;
        this.stopMirrors(x$1, (scala.collection.immutable.Seq<String>)x$2, true, (Option<String>)x$3, x$5);
        String[] x$6 = new String[]{"--topics", "topic-11", "--validate-only"};
        .colon.colon x$7 = new .colon.colon((Object)"topic-11", (List)Nil$.MODULE$);
        None$ x$10 = None$.MODULE$;
        this.stopMirrors(x$6, (scala.collection.immutable.Seq<String>)x$7, true, (Option<String>)x$10, true);
    }

    @Test
    public void testFailoverMirrors() {
        this.stopMirrors(new String[]{"--topics", "topic-3"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-3", (List)Nil$.MODULE$), false, (Option<String>)None$.MODULE$, false);
        this.stopMirrors(new String[]{"--topics", "topic-1,topic-4"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-1", (List)new .colon.colon((Object)"topic-4", (List)Nil$.MODULE$)), false, (Option<String>)None$.MODULE$, false);
        this.stopMirrors(new String[]{"--topics", "topic-nonexistent"}, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-nonexistent", (List)Nil$.MODULE$), false, (Option<String>)None$.MODULE$, false);
        String[] x$1 = new String[]{"--link", "link-2"};
        .colon.colon x$2 = new .colon.colon((Object)"topic-3", (List)new .colon.colon((Object)"topic-4", (List)new .colon.colon((Object)"topic-5", (List)new .colon.colon((Object)"topic-6", (List)Nil$.MODULE$))));
        Some x$3 = new Some((Object)"link-2");
        boolean x$5 = false;
        this.stopMirrors(x$1, (scala.collection.immutable.Seq<String>)x$2, false, (Option<String>)x$3, x$5);
        String[] x$6 = new String[]{"--topics", "topic-1", "--validate-only"};
        .colon.colon x$7 = new .colon.colon((Object)"topic-1", (List)Nil$.MODULE$);
        None$ x$10 = None$.MODULE$;
        this.stopMirrors(x$6, (scala.collection.immutable.Seq<String>)x$7, false, (Option<String>)x$10, true);
    }

    private void pauseMirrors(String[] args, boolean expectEnable, scala.collection.immutable.Seq<String> expectedTopics, Option<String> expectLinkName, boolean expectValidateOnly) {
        BooleanRef issuedCommand = BooleanRef.create((boolean)false);
        BooleanRef issuedListCommand = BooleanRef.create((boolean)false);
        scala.collection.immutable.Map results = ((IterableOnceOps)expectedTopics.map((Function1 & Serializable)topic -> {
            KafkaFutureImpl future = new KafkaFutureImpl();
            Option option = this.allDescriptions().get(topic);
            if (option instanceof Some) {
                future.complete(null);
            } else if (None$.MODULE$.equals(option)) {
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException(""));
            } else {
                throw new MatchError((Object)option);
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)future);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        AlterMirrorsResult result = (AlterMirrorsResult)Mockito.mock(AlterMirrorsResult.class);
        Mockito.when((Object)result.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)results).asJava());
        ListMirrorsResult listResult = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        expectLinkName.foreach((Function1 & Serializable)linkName -> {
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.complete((Object)CollectionConverters$.MODULE$.IterableHasAsJava(((MapOps)this.allDescriptions().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MirrorCommandTest.$anonfun$pauseMirrors$3(linkName, x$5)))).keys()).asJavaCollection());
            return Mockito.when((Object)listResult.result()).thenReturn((Object)future);
        });
        Node node = new Node(1, "localhost", 9092);
        TestAdminClient mockAdminClient = new TestAdminClient(this, node, issuedListCommand, listResult, issuedCommand, expectedTopics, expectValidateOnly, expectEnable, result){
            private final BooleanRef issuedListCommand$3;
            private final ListMirrorsResult listResult$3;
            private final BooleanRef issuedCommand$4;
            private final scala.collection.immutable.Seq expectedTopics$2;
            private final boolean expectValidateOnly$2;
            private final boolean expectEnable$1;
            private final AlterMirrorsResult result$4;

            public ListMirrorsResult listMirrors(ListMirrorsOptions options) {
                this.issuedListCommand$3.elem = true;
                return this.listResult$3;
            }

            public AlterMirrorsResult alterMirrors(java.util.Map<String, AlterMirrorOp> ops, AlterMirrorsOptions options) {
                this.issuedCommand$4.elem = true;
                Assertions.assertEquals((int)this.expectedTopics$2.size(), (int)ops.size());
                Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.expectValidateOnly$2), (Object)BoxesRunTime.boxToBoolean((boolean)options.validateOnly()));
                CollectionConverters$.MODULE$.MapHasAsScala(ops).asScala().foreach((Function1 & Serializable)x0$1 -> {
                    $anon$4.$anonfun$alterMirrors$2(this, x0$1);
                    return BoxedUnit.UNIT;
                });
                return this.result$4;
            }

            public static final /* synthetic */ void $anonfun$alterMirrors$2($anon$4 $this, Tuple2 x0$1) {
                if (x0$1 != null) {
                    String topic = (String)x0$1._1();
                    AlterMirrorOp op = (AlterMirrorOp)x0$1._2();
                    Assertions.assertTrue((boolean)$this.expectedTopics$2.contains((Object)topic));
                    Assertions.assertEquals((Object)($this.expectEnable$1 ? AlterMirrorOp.PAUSE : AlterMirrorOp.RESUME), (Object)op);
                    return;
                }
                throw new MatchError(null);
            }
            {
                this.issuedListCommand$3 = issuedListCommand$3;
                this.listResult$3 = listResult$3;
                this.issuedCommand$4 = issuedCommand$4;
                this.expectedTopics$2 = expectedTopics$2;
                this.expectValidateOnly$2 = expectValidateOnly$2;
                this.expectEnable$1 = expectEnable$1;
                this.result$4 = result$4;
                super(node$4);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$alterMirrors$2$adapted(kafka.admin.MirrorCommandTest$$anon$4 scala.Tuple2 )}, serializedLambda);
            }
        };
        this.runCommand(args, mockAdminClient);
        Assertions.assertTrue((boolean)issuedCommand.elem);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectLinkName.nonEmpty()), (Object)BoxesRunTime.boxToBoolean((boolean)issuedListCommand.elem));
        ((AlterMirrorsResult)Mockito.verify((Object)result)).values();
        ((ListMirrorsResult)Mockito.verify((Object)listResult, (VerificationMode)Mockito.times((int)Option$.MODULE$.option2Iterable(expectLinkName).size()))).result();
        Mockito.reset((Object[])new AlterMirrorsResult[]{result});
        Mockito.reset((Object[])new ListMirrorsResult[]{listResult});
    }

    private Option<String> pauseMirrors$default$4() {
        return None$.MODULE$;
    }

    private boolean pauseMirrors$default$5() {
        return false;
    }

    @Test
    public void testPauseMirrors() {
        this.pauseMirrors(new String[]{"--pause", "--topics", "topic-3"}, true, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-3", (List)Nil$.MODULE$), (Option<String>)None$.MODULE$, false);
        this.pauseMirrors(new String[]{"--pause", "--topics", "topic-1,topic-4"}, true, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-1", (List)new .colon.colon((Object)"topic-4", (List)Nil$.MODULE$)), (Option<String>)None$.MODULE$, false);
        this.pauseMirrors(new String[]{"--unpause", "--topics", "topic-nonexistent"}, false, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-nonexistent", (List)Nil$.MODULE$), (Option<String>)None$.MODULE$, false);
        this.pauseMirrors(new String[]{"--unpause", "--link", "link-2"}, false, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"topic-3", (List)new .colon.colon((Object)"topic-4", (List)new .colon.colon((Object)"topic-5", (List)new .colon.colon((Object)"topic-6", (List)Nil$.MODULE$)))), (Option<String>)new Some((Object)"link-2"), false);
        String[] x$1 = new String[]{"--pause", "--topics", "topic-1", "--validate-only"};
        .colon.colon x$3 = new .colon.colon((Object)"topic-1", (List)Nil$.MODULE$);
        None$ x$5 = None$.MODULE$;
        this.pauseMirrors(x$1, true, (scala.collection.immutable.Seq<String>)x$3, (Option<String>)x$5, true);
    }

    private void createMirror(String[] args, Option<String> expectTopic, Option<String> expectLinkName, Option<String> expectMirrorTopic, Option<Integer> expectReplicationFactor) {
        BooleanRef issuedCommand = BooleanRef.create((boolean)false);
        KafkaFutureImpl future = new KafkaFutureImpl();
        if (this.allDescriptions().contains(expectTopic.get())) {
            future.completeExceptionally((Throwable)new TopicExistsException(String.format("Topic %s exists already.", expectTopic)));
        } else {
            future.complete(null);
        }
        scala.collection.immutable.Map results = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(expectTopic.get()), (Object)future)}));
        CreateTopicsResult result = (CreateTopicsResult)Mockito.mock(CreateTopicsResult.class);
        Mockito.when((Object)result.all()).thenReturn((Object)KafkaFuture.allOf((KafkaFuture[])new KafkaFuture[]{(KafkaFuture)results.values().head()}));
        Node node = new Node(1, "localhost", 9092);
        TestAdminClient mockAdminClient = new TestAdminClient(this, node, issuedCommand, expectTopic, expectMirrorTopic, expectLinkName, expectReplicationFactor, result){
            private final BooleanRef issuedCommand$5;
            private final Option expectTopic$1;
            private final Option expectMirrorTopic$1;
            private final Option expectLinkName$1;
            private final Option expectReplicationFactor$1;
            private final CreateTopicsResult result$5;

            public CreateTopicsResult createTopics(Collection<NewTopic> newTopics, CreateTopicsOptions options) {
                this.issuedCommand$5.elem = true;
                NewTopic newTopic = newTopics.stream().findFirst().get();
                Assertions.assertEquals((Object)this.expectTopic$1.get(), (Object)newTopic.name());
                Assertions.assertEquals((Object)this.expectMirrorTopic$1.get(), (Object)((NewMirrorTopic)newTopic.mirror().get()).sourceTopic());
                Assertions.assertEquals((Object)this.expectLinkName$1.get(), (Object)((NewMirrorTopic)newTopic.mirror().get()).linkName());
                Assertions.assertEquals((Integer)((Integer)this.expectReplicationFactor$1.get()), (int)newTopic.replicationFactor());
                return this.result$5;
            }
            {
                this.issuedCommand$5 = issuedCommand$5;
                this.expectTopic$1 = expectTopic$1;
                this.expectMirrorTopic$1 = expectMirrorTopic$1;
                this.expectLinkName$1 = expectLinkName$1;
                this.expectReplicationFactor$1 = expectReplicationFactor$1;
                this.result$5 = result$5;
                super(node$5);
            }
        };
        this.runCommand(args, mockAdminClient);
        Assertions.assertTrue((boolean)issuedCommand.elem);
        ((CreateTopicsResult)Mockito.verify((Object)result)).all();
        Mockito.reset((Object[])new CreateTopicsResult[]{result});
    }

    private Option<Integer> createMirror$default$5() {
        return new Some((Object)Predef$.MODULE$.int2Integer(-1));
    }

    @Test
    public void testCreateMirror() {
        this.createMirror(new String[]{"--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1"}, (Option<String>)new Some((Object)"topic"), (Option<String>)new Some((Object)"link-1"), (Option<String>)new Some((Object)"topic"), this.createMirror$default$5());
        this.createMirror(new String[]{"--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--replication-factor", "2"}, (Option<String>)new Some((Object)"topic"), (Option<String>)new Some((Object)"link-1"), (Option<String>)new Some((Object)"topic"), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(2)));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.createMirror(new String[]{"--create", "--source-topic", "topic-1", "--mirror-topic", "topic-1", "--link", "link-1"}, (Option<String>)new Some((Object)"topic-1"), (Option<String>)new Some((Object)"link-1"), (Option<String>)new Some((Object)"topic-1"), this.createMirror$default$5()), ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 494));
        this.createMirror(new String[]{"--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--from-latest"}, (Option<String>)new Some((Object)"topic"), (Option<String>)new Some((Object)"link-1"), (Option<String>)new Some((Object)"topic"), this.createMirror$default$5());
        this.createMirror(new String[]{"--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--from-earliest"}, (Option<String>)new Some((Object)"topic"), (Option<String>)new Some((Object)"link-1"), (Option<String>)new Some((Object)"topic"), this.createMirror$default$5());
        this.createMirror(new String[]{"--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--from-datetime", "2023-01-02T03:04:05.678"}, (Option<String>)new Some((Object)"topic"), (Option<String>)new Some((Object)"link-1"), (Option<String>)new Some((Object)"topic"), this.createMirror$default$5());
    }

    @Test
    public void testBadCommands() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--not-a-command"}).verifyArgs(), ClassTag$.MODULE$.apply(OptionException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--describe"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 510));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--topic"}).verifyArgs(), ClassTag$.MODULE$.apply(OptionException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 513));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--link"}).verifyArgs(), ClassTag$.MODULE$.apply(OptionException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", ""}).verifyArgs(), ClassTag$.MODULE$.apply(InvalidClusterLinkException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "test+link"}).verifyArgs(), ClassTag$.MODULE$.apply(InvalidClusterLinkException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 523));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "", "--link", "test-link"}).verifyArgs(), ClassTag$.MODULE$.apply(InvalidTopicException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 527));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "invalid+topic", "--link", "test-link"}).verifyArgs(), ClassTag$.MODULE$.apply(InvalidTopicException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 531));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--partitions", "1"}), ClassTag$.MODULE$.apply(OptionException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 535));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--replica-assignment", "3:0,5:1"}), ClassTag$.MODULE$.apply(OptionException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--from-datetime"}), ClassTag$.MODULE$.apply(OptionException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 543));
    }

    @Test
    public void testMissingRequiredArgs() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--list"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--describe"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 554));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--promote"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--failover"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 560));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--pause"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 563));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--unpause"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 566));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--link", "link-1"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 569));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 572));
    }

    @Test
    public void testInvalidArgs() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--topics", "topic"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 579));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--validate-only"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 583));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--describe", "--topics", "topic", "--include-stopped"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 587));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--describe", "--topics", "topic", "--link", "link-name"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--describe", "--topics", "topic", "--validate-only"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
        IllegalArgumentException describeWithLinkException = (IllegalArgumentException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--describe", "--topics", "topic", "--link", "link-1"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
        Assertions.assertEquals((Object)"Option --link cannot be used to filter with --describe. Please use --links instead.", (Object)describeWithLinkException.getMessage());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--promote", "--topics", "topic", "--include-stopped"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 604));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--failover", "--topics", "topic", "--include-stopped"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 608));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--pause", "--topics", "topic", "--include-stopped"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 612));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--unpause", "--topics", "topic", "--include-stopped"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 616));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--pause", "--unpause", "--topics", "topic"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 620));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> MirrorCommand$.MODULE$.parseTopicConfigsToBeAdded(new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--config", "confluent.placement.constraints={\"version\":1,\"replicas\":[{\"count\":3,\"constraints\":{\"rack\":\"us-west\"}}],\"observers\":[{\"count\":2,\"constraints\":{\"rack\":\"us-east\"}}]}"})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 624));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--from-latest", "--from-datetime", "2023-01-02T03:04:05.678"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 633));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--from-earliest", "--from-datetime", "2023-01-02T03:04:05.678"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 637));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--from-earliest", "--from-latest"}).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 641));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> new MirrorCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--create", "--source-topic", "topic", "--mirror-topic", "topic", "--link", "link-1", "--from-datetime", "01-02"}).fromTimestamp(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MirrorCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 645));
    }

    @Test
    public void testMirrorPartitionInformation() {
        int n = 100;
        int logEndOffset = 100;
        String info = MirrorCommand$.MODULE$.getMirrorPartitionInformation(new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.ACTIVE, -1L, (long)n), new ReplicaStatus(1, true, false, true, true, true, 0L, (long)logEndOffset, -1L, -1L, Optional.of("link"), Optional.of(new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.ACTIVE, -1L, (long)n))), 1, -1L);
        Assertions.assertTrue((boolean)info.contains("DestLogEndOffset: 100\tLastFetchSourceHighWatermark: 100\tLag: 0\t"), (String)new java.lang.StringBuilder(26).append("Incorrect partition info: ").append(info).toString());
        n = -1;
        info = MirrorCommand$.MODULE$.getMirrorPartitionInformation(new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.ACTIVE, -1L, (long)n), new ReplicaStatus(1, true, false, true, true, true, 0L, (long)logEndOffset, -1L, -1L, Optional.of("link"), Optional.of(new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.ACTIVE, -1L, (long)n))), 1, -1L);
        Assertions.assertTrue((boolean)info.contains("DestLogEndOffset: 100\tLastFetchSourceHighWatermark: -1\tLag: -1\t"), (String)new java.lang.StringBuilder(26).append("Incorrect partition info: ").append(info).toString());
        n = 150;
        info = MirrorCommand$.MODULE$.getMirrorPartitionInformation(new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.ACTIVE, -1L, (long)n), new ReplicaStatus(1, true, false, true, true, true, 0L, (long)logEndOffset, -1L, -1L, Optional.of("link"), Optional.of(new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.ACTIVE, -1L, (long)n))), 1, -1L);
        Assertions.assertTrue((boolean)info.contains("DestLogEndOffset: 100\tLastFetchSourceHighWatermark: 150\tLag: 50\t"), (String)new java.lang.StringBuilder(26).append("Incorrect partition info: ").append(info).toString());
    }

    @Test
    public void testMirrorTopicInformation() {
        this.allDescriptions().foreach((Function1 & Serializable)x0$1 -> {
            MirrorCommandTest.$anonfun$testMirrorTopicInformation$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private MirrorTopicDescription newDescription(String linkName, String sourceTopic, int numPartitions, String stateStr, long stateTimeMs, List<Object> stoppedLogEndOffsets, Uuid topicId) {
        MirrorTopicDescription.State state;
        MirrorTopicDescription.State state2 = state = Enum.valueOf(MirrorTopicDescription.State.class, stateStr);
        MirrorTopicDescription.State state3 = MirrorTopicDescription.State.FAILED;
        MirrorTopicError failureReason = !(state2 != null ? !state2.equals(state3) : state3 != null) ? MirrorTopicError.SOURCE_TOPIC_ID_CHANGED : null;
        return new MirrorTopicDescription(linkName, Uuid.randomUuid(), sourceTopic, numPartitions, state, stateTimeMs, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)stoppedLogEndOffsets.map((Function1 & Serializable)x$6 -> MirrorCommandTest.$anonfun$newDescription$1(BoxesRunTime.unboxToLong((Object)x$6)))).asJava(), topicId, failureReason);
    }

    private List<Object> newDescription$default$6() {
        return package$.MODULE$.List().empty();
    }

    private Uuid newDescription$default$7() {
        return Uuid.randomUuid();
    }

    private List<ReplicaStatus> newPartition(String stateStr, long logEndOffset, long lastMirrorFetchTimeDeltaMs, long lastMirrorFetchSourceHighWatermark) {
        ReplicaStatus.MirrorInfo.State state = Enum.valueOf(ReplicaStatus.MirrorInfo.State.class, stateStr);
        Optional<ReplicaStatus.MirrorInfo> mirrorInfo = Optional.of(new ReplicaStatus.MirrorInfo(state, (long)this.currentTime() - lastMirrorFetchTimeDeltaMs, lastMirrorFetchSourceHighWatermark));
        return new .colon.colon((Object)new ReplicaStatus(0, true, false, true, true, true, 0L, logEndOffset, (long)this.currentTime(), (long)this.currentTime(), Optional.empty(), mirrorInfo), (List)new .colon.colon((Object)new ReplicaStatus(1, false, false, true, true, true, 0L, logEndOffset - 10L, (long)this.currentTime(), (long)(this.currentTime() - 1000), Optional.empty(), Optional.empty()), (List)new .colon.colon((Object)new ReplicaStatus(2, false, false, true, false, false, 0L, logEndOffset - 20L, (long)this.currentTime(), (long)(this.currentTime() - 1500), Optional.empty(), Optional.empty()), (List)Nil$.MODULE$)));
    }

    public static final /* synthetic */ boolean $anonfun$listMirrors$2(MirrorTopicDescription d$1, String x$1) {
        String string = x$1;
        String string2 = d$1.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$listMirrors$1(Option linkName$1, boolean includeStopped$1, Tuple2 x0$1) {
        block2: {
            block3: {
                block4: {
                    if (x0$1 == null) break block2;
                    MirrorTopicDescription d = (MirrorTopicDescription)x0$1._2();
                    if (!linkName$1.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MirrorCommandTest.$anonfun$listMirrors$2(d, x$1)))) break block3;
                    if (includeStopped$1) break block4;
                    MirrorTopicDescription.State state = d.state();
                    MirrorTopicDescription.State state2 = MirrorTopicDescription.State.STOPPED;
                    if (!(state == null ? state2 != null : !state.equals(state2))) break block3;
                }
                return true;
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$listMirrors$3(scala.collection.immutable.Set topics$1, String output$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            String t = (String)x0$2._1();
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)topics$1.contains((Object)t)), (Object)BoxesRunTime.boxToBoolean((boolean)output$1.contains(t)));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Tuple2 $anonfun$describeMirrors$5(MirrorCommandTest $this, String topic$1, int part) {
        TopicPartition tp = new TopicPartition(topic$1, part);
        List rsList = (List)((LinearSeqOps)$this.allPartitions().apply((Object)topic$1)).apply(part);
        KafkaFutureImpl future = new KafkaFutureImpl();
        if (rsList != null) {
            future.complete((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)rsList).asJava());
        } else {
            future.completeExceptionally((Throwable)$this.leaderNotAvailableException(tp));
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)future);
    }

    public static final /* synthetic */ boolean $anonfun$describeMirrors$6(Tuple2 x$2) {
        return x$2._2() != null;
    }

    public static final /* synthetic */ void $anonfun$describeMirrors$7(MirrorCommandTest $this, scala.collection.immutable.Seq adminClientReturnedTopics$1, String[] args$2, String output$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            String t = (String)x0$2._1();
            MirrorTopicDescription d = (MirrorTopicDescription)x0$2._2();
            if (adminClientReturnedTopics$1.contains((Object)t)) {
                StringBuilder builder = new StringBuilder();
                builder.append(MirrorCommand$.MODULE$.getMirrorTopicInformation(t, d));
                builder.append('\n');
                ((List)((StrictOptimizedIterableOps)$this.allPartitions().apply((Object)t)).zipWithIndex()).foreach((Function1 & Serializable)x0$3 -> {
                    if (x0$3 != null) {
                        List rsList = (List)x0$3._1();
                        int index = x0$3._2$mcI$sp();
                        if (rsList != null) {
                            ReplicaStatus leader = (ReplicaStatus)rsList.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isLeader())).head();
                            ReplicaStatus.MirrorInfo mirrorInfo = (ReplicaStatus.MirrorInfo)leader.mirrorInfo().get();
                            if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])args$2), (Object)"--pending-stopped-only")) {
                                ReplicaStatus.MirrorInfo.State state = mirrorInfo.state();
                                ReplicaStatus.MirrorInfo.State state2 = ReplicaStatus.MirrorInfo.State.PENDING_STOPPED;
                                if (!(state != null ? !state.equals(state2) : state2 != null)) {
                                    builder.append(MirrorCommand$.MODULE$.getMirrorPartitionInformation(mirrorInfo, leader, index, -1L));
                                    return builder.append('\n');
                                }
                                return BoxedUnit.UNIT;
                            }
                            long stopLogEndOffset = d.stoppedLogEndOffsets().size() <= index ? mirrorInfo.lastFetchSourceHighWatermark() : Predef$.MODULE$.Long2long((Long)d.stoppedLogEndOffsets().get(index));
                            builder.append(MirrorCommand$.MODULE$.getMirrorPartitionInformation(mirrorInfo, leader, index, stopLogEndOffset));
                            return builder.append('\n');
                        }
                        TopicPartition tp = new TopicPartition(t, index);
                        builder.append(MirrorCommand$.MODULE$.getMirrorPartitionError(index, (Throwable)$this.leaderNotAvailableException(tp)));
                        return builder.append('\n');
                    }
                    throw new MatchError(null);
                });
                Assertions.assertTrue((boolean)output$2.contains(builder.toString()), (String)new java.lang.StringBuilder(46).append("Unexpected output: '").append(output$2).append("', expected to contain '").append((CharSequence)builder).append("''").toString());
                return;
            }
            Assertions.assertFalse((boolean)output$2.contains(new java.lang.StringBuilder(8).append("Topic: ").append(t).append(" ").toString()), (String)new java.lang.StringBuilder(49).append("Unexpected output: '").append(output$2).append("', contains unexpected topic ").append(t).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$describeMirrors$10(MirrorCommandTest $this, String output$2, String t) {
        if (!$this.allDescriptions().contains((Object)t)) {
            Assertions.assertTrue((boolean)output$2.contains(new java.lang.StringBuilder(15).append("Topic: ").append(t).append("\tError: ").toString()));
            return;
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$stopMirrors$5(MirrorCommandTest $this, String topic$2, int part) {
        TopicPartition tp = new TopicPartition(topic$2, part);
        List rsList = (List)((LinearSeqOps)$this.allPartitions().apply((Object)topic$2)).apply(part);
        KafkaFutureImpl future = new KafkaFutureImpl();
        if (rsList != null) {
            future.complete((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)rsList).asJava());
        } else {
            future.completeExceptionally((Throwable)$this.leaderNotAvailableException(tp));
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)future);
    }

    public static final /* synthetic */ boolean $anonfun$stopMirrors$8(String linkName$2, Tuple2 x$4) {
        String string = ((MirrorTopicDescription)x$4._2()).linkName();
        return !(string != null ? !string.equals(linkName$2) : linkName$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$pauseMirrors$3(String linkName$3, Tuple2 x$5) {
        String string = ((MirrorTopicDescription)x$5._2()).linkName();
        return !(string != null ? !string.equals(linkName$3) : linkName$3 != null);
    }

    private static final ReplicaStatus.MirrorInfo mirrorInfo$1(IntRef lastFetchHwm$1) {
        return new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.ACTIVE, -1L, (long)lastFetchHwm$1.elem);
    }

    private static final ReplicaStatus leaderInfo$1(int logEndOffset$1, IntRef lastFetchHwm$1) {
        return new ReplicaStatus(1, true, false, true, true, true, 0L, (long)logEndOffset$1, -1L, -1L, Optional.of("link"), Optional.of(new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.ACTIVE, -1L, (long)lastFetchHwm$1.elem)));
    }

    public static final /* synthetic */ void $anonfun$testMirrorTopicInformation$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            String topic = (String)x0$1._1();
            MirrorTopicDescription desc = (MirrorTopicDescription)x0$1._2();
            String info = MirrorCommand$.MODULE$.getMirrorTopicInformation(topic, desc);
            Assertions.assertTrue((boolean)info.contains(new java.lang.StringBuilder(7).append("Topic: ").append(topic).toString()));
            Assertions.assertTrue((boolean)info.contains(new java.lang.StringBuilder(10).append("LinkName: ").append(desc.linkName()).toString()));
            Assertions.assertTrue((boolean)info.contains(new java.lang.StringBuilder(8).append("LinkId: ").append(desc.clusterLinkId()).toString()));
            Assertions.assertTrue((boolean)info.contains(new java.lang.StringBuilder(13).append("SourceTopic: ").append(desc.sourceTopic()).toString()));
            Assertions.assertTrue((boolean)info.contains(new java.lang.StringBuilder(7).append("State: ").append(desc.state()).toString()));
            Assertions.assertTrue((boolean)info.contains(new java.lang.StringBuilder(15).append("SourceTopicId: ").append(desc.sourceTopicId()).toString()));
            Assertions.assertTrue((boolean)info.contains(new java.lang.StringBuilder(11).append("StateTime: ").append(MirrorCommand$.MODULE$.timeToDate(desc.stateTimeMs())).toString()));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Long $anonfun$newDescription$1(long x$6) {
        return BoxesRunTime.boxToLong((long)x$6);
    }

    public MirrorCommandTest() {
        this.currentTime = 500000000;
        Object[] objectArray = new Tuple2[15];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)this.newDescription("link-1", "topic-1", 2, "ACTIVE", 100000000L, this.newDescription$default$6(), Uuid.randomUuid()));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)this.newDescription("link-1", "topic-2", 2, "FAILED", 200000000L, this.newDescription$default$6(), Uuid.randomUuid()));
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)this.newDescription("link-2", "topic-3", 1, "ACTIVE", 300000000L, this.newDescription$default$6(), Uuid.randomUuid()));
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-4"), (Object)this.newDescription("link-2", "topic-4", 1, "FAILED", 400000000L, this.newDescription$default$6(), Uuid.randomUuid()));
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-5"), (Object)this.newDescription("link-2", "topic-5", 2, "STOPPED", 500000000L, (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{150L, 160L}))), Uuid.randomUuid()));
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-6"), (Object)this.newDescription("link-2", "topic-6", 2, "PENDING_STOPPED", 500000000L, this.newDescription$default$6(), Uuid.randomUuid()));
        objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-7"), (Object)this.newDescription("link-3", "topic-7", 5, "ACTIVE", 600000000L, this.newDescription$default$6(), Uuid.randomUuid()));
        objectArray[7] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-11"), (Object)this.newDescription("link-11", "topic-11", 2, "ACTIVE", 100000000L, this.newDescription$default$6(), Uuid.randomUuid()));
        objectArray[8] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-12"), (Object)this.newDescription("link-11", "topic-12", 2, "FAILED", 200000000L, this.newDescription$default$6(), Uuid.randomUuid()));
        objectArray[9] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-13"), (Object)this.newDescription("link-12", "topic-13", 1, "ACTIVE", 300000000L, this.newDescription$default$6(), Uuid.randomUuid()));
        objectArray[10] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-14"), (Object)this.newDescription("link-12", "topic-14", 1, "FAILED", 400000000L, this.newDescription$default$6(), Uuid.randomUuid()));
        objectArray[11] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-15"), (Object)this.newDescription("link-12", "topic-15", 2, "STOPPED", 500000000L, this.newDescription$default$6(), Uuid.randomUuid()));
        objectArray[12] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-16"), (Object)this.newDescription("link-12", "topic-16", 2, "PENDING_STOPPED", 500000000L, this.newDescription$default$6(), Uuid.randomUuid()));
        Uuid x$6 = Uuid.ZERO_UUID;
        List<Object> x$7 = this.newDescription$default$6();
        objectArray[13] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-17"), (Object)this.newDescription("link-no-source-topic-ids", "topic-17", 1, "PAUSED", 600000000L, x$7, x$6));
        objectArray[14] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-18"), (Object)this.newDescription("link-13", "topic-1", 1, "ACTIVE", 100000000L, this.newDescription$default$6(), Uuid.randomUuid()));
        this.allDescriptions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.allPartitions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)new .colon.colon(this.newPartition("ACTIVE", 100L, 10L, 150L), (List)new .colon.colon(this.newPartition("FAILED", 110L, 20L, 160L), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)new .colon.colon(this.newPartition("FAILED", 100L, -1L, -1L), (List)new .colon.colon(this.newPartition("FAILED", 120L, -1L, -1L), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)new .colon.colon(this.newPartition("FAILED", 130L, 30L, 2000L), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-4"), (Object)new .colon.colon(this.newPartition("FAILED", 140L, -1L, -1L), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-5"), (Object)new .colon.colon(this.newPartition("STOPPED", 150L, 40L, 160L), (List)new .colon.colon(this.newPartition("STOPPED", 160L, -1L, -1L), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-6"), (Object)new .colon.colon(this.newPartition("PENDING_STOPPED", 160L, 40L, 160L), (List)new .colon.colon(this.newPartition("PENDING_STOPPED", 200L, 50L, 200L), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-7"), (Object)new .colon.colon(null, (List)new .colon.colon(this.newPartition("ACTIVE", 100L, 10L, 150L), (List)new .colon.colon(null, (List)new .colon.colon(this.newPartition("FAILED", 110L, 20L, 160L), (List)new .colon.colon(null, (List)Nil$.MODULE$)))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-11"), (Object)new .colon.colon(this.newPartition("ACTIVE", 100L, 0L, 100L), (List)new .colon.colon(this.newPartition("FAILED", 110L, 20L, 110L), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-12"), (Object)new .colon.colon(this.newPartition("FAILED", 100L, -1L, -1L), (List)new .colon.colon(this.newPartition("FAILED", 120L, -1L, 120L), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-13"), (Object)new .colon.colon(this.newPartition("FAILED", 2000L, 0L, 2000L), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-14"), (Object)new .colon.colon(this.newPartition("FAILED", -1L, -1L, -1L), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-15"), (Object)new .colon.colon(this.newPartition("STOPPED", 150L, 0L, 150L), (List)new .colon.colon(this.newPartition("STOPPED", 160L, -1L, -1L), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-16"), (Object)new .colon.colon(this.newPartition("PENDING_STOPPED", 160L, 40L, 160L), (List)new .colon.colon(this.newPartition("PENDING_STOPPED", 200L, 50L, 200L), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-17"), (Object)new .colon.colon(this.newPartition("PAUSED", 400L, 10L, 100L), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-18"), (Object)new .colon.colon(this.newPartition("ACTIVE", 100L, 10L, 150L), (List)Nil$.MODULE$))}));
    }

    public class TestAdminClient
    extends MockAdminClient {
        public ReplicaStatusResult replicaStatus(Set<TopicPartition> partitions, ReplicaStatusOptions options) {
            return (ReplicaStatusResult)Mockito.mock(ReplicaStatusResult.class);
        }

        public AlterMirrorsResult alterMirrors(java.util.Map<String, AlterMirrorOp> ops, AlterMirrorsOptions options) {
            return (AlterMirrorsResult)Mockito.mock(AlterMirrorsResult.class);
        }

        public ListMirrorsResult listMirrors(ListMirrorsOptions options) {
            return (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        }

        public DescribeMirrorsResult describeMirrors(Collection<String> topics, DescribeMirrorsOptions options) {
            return (DescribeMirrorsResult)Mockito.mock(DescribeMirrorsResult.class);
        }

        public CreateTopicsResult createTopics(Collection<NewTopic> newTopics, CreateTopicsOptions options) {
            return (CreateTopicsResult)Mockito.mock(CreateTopicsResult.class);
        }

        public /* synthetic */ MirrorCommandTest kafka$admin$MirrorCommandTest$TestAdminClient$$$outer() {
            return MirrorCommandTest.this;
        }

        public TestAdminClient(Node node) {
            if (MirrorCommandTest.this == null) {
                throw null;
            }
            super(Collections.singletonList(node), node);
        }
    }
}

