/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignPartitionsIntegrationTest$;
import kafka.api.IntegrationTestHarness;
import kafka.common.AdminCommandFailedException;
import kafka.server.ConfluentObserverTest;
import kafka.server.ConfluentObserverTest$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001B\u0010!\u0001\u0015BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013\u0005\u0011\u0007\u0003\u00049\u0001\u0001\u0006IA\r\u0005\bs\u0001\u0011\r\u0011\"\u00012\u0011\u0019Q\u0004\u0001)A\u0005e!91\b\u0001b\u0001\n\u0003\t\u0004B\u0002\u001f\u0001A\u0003%!\u0007C\u0004>\u0001\t\u0007I\u0011A\u0019\t\ry\u0002\u0001\u0015!\u00033\u0011\u001dy\u0004A1A\u0005\u0002EBa\u0001\u0011\u0001!\u0002\u0013\u0011\u0004bB!\u0001\u0005\u0004%\t!\r\u0005\u0007\u0005\u0002\u0001\u000b\u0011\u0002\u001a\t\u000f\r\u0003!\u0019!C\u0001\t\"11\u000b\u0001Q\u0001\n\u0015CQ\u0001\u0016\u0001\u0005BUCQa\u0018\u0001\u0005BEBQ\u0001\u0019\u0001\u0005\u0002\u0005Dq!!\b\u0001\t\u0003\ty\u0002C\u0004\u0002*\u0001!\t!a\u000b\t\u000f\u0005U\u0002\u0001\"\u0001\u00028!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003bBA'\u0001\u0011\u0005\u0011q\n\u0005\b\u0003\u001b\u0003A\u0011AAH\u0011\u001d\ti\u000b\u0001C\u0001\u0003_Cq!!0\u0001\t\u0013\ty\fC\u0004\u0002J\u0002!I!a3\t\u000f\u0005M\u0007\u0001\"\u0003\u0002V\"9\u00111\u001c\u0001\u0005\n\u0005u\u0007bBAu\u0001\u0011\u0005\u00111\u001e\u0002/%\u0016\f7o]5h]B\u000b'\u000f^5uS>t7oV5uQ>\u00137/\u001a:wKJ\u001c\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\"E\u0005)\u0011\rZ7j]*\t1%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0003CA\u0014+\u001b\u0005A#BA\u0015#\u0003\r\t\u0007/[\u0005\u0003W!\u0012a#\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00039\u0002\"a\f\u0001\u000e\u0003\u0001\nqA\u0019:pW\u0016\u0014\u0018'F\u00013!\t\u0019d'D\u00015\u0015\u0005)\u0014!B:dC2\f\u0017BA\u001c5\u0005\rIe\u000e^\u0001\tEJ|7.\u001a:2A\u00059!M]8lKJ\u0014\u0014\u0001\u00032s_.,'O\r\u0011\u0002\u000f\t\u0014xn[3sg\u0005A!M]8lKJ\u001c\u0004%A\u0004ce>\\WM\u001d\u001b\u0002\u0011\t\u0014xn[3si\u0001\nqA\u0019:pW\u0016\u0014X'\u0001\u0005ce>\\WM]\u001b!\u0003\u001d\u0011'o\\6feZ\n\u0001B\u0019:pW\u0016\u0014h\u0007I\u0001\u0005e\u0006\u001c7.F\u0001F!\u00111\u0015JM&\u000e\u0003\u001dS!\u0001\u0013\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002K\u000f\n\u0019Q*\u00199\u0011\u00051\u000bV\"A'\u000b\u00059{\u0015\u0001\u00027b]\u001eT\u0011\u0001U\u0001\u0005U\u00064\u0018-\u0003\u0002S\u001b\n11\u000b\u001e:j]\u001e\fQA]1dW\u0002\nqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002-B\u0019aiV-\n\u0005a;%aA*fcB\u0011!,X\u0007\u00027*\u0011ALI\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005y[&aC&bM.\f7i\u001c8gS\u001e\f1B\u0019:pW\u0016\u00148i\\;oi\u0006\u0001B/Z:u%\u0016\f7o]5h]6,g\u000e\u001e\u000b\u0003E\u0016\u0004\"aM2\n\u0005\u0011$$\u0001B+oSRDQA\u001a\nA\u0002\u001d\fa!];peVl\u0007C\u00015p\u001d\tIW\u000e\u0005\u0002ki5\t1N\u0003\u0002mI\u00051AH]8pizJ!A\u001c\u001b\u0002\rA\u0013X\rZ3g\u0013\t\u0011\u0006O\u0003\u0002oi!2!C]A\u0001\u0003\u0007\u0001\"a\u001d@\u000e\u0003QT!!\u001e<\u0002\u0011A\u0014xN^5eKJT!a\u001e=\u0002\rA\f'/Y7t\u0015\tI(0A\u0004kkBLG/\u001a:\u000b\u0005md\u0018!\u00026v]&$(\"A?\u0002\u0007=\u0014x-\u0003\u0002\u0000i\nYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONdC!!\u0002\u0002\n\u0005\u0012\u0011qA\u0001\u0003u.\f#!a\u0003\u0002\u000b-\u0014\u0018M\u001a;)\u000fI\ty!a\u0006\u0002\u001aA!\u0011\u0011CA\n\u001b\u00051\u0018bAA\u000bm\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0003\u00037\t\u0001d\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~\u0003e!Xm\u001d;UQJ|G\u000f\u001e7fIJ+\u0017m]:jO:lWM\u001c;\u0015\u0007\t\f\t\u0003C\u0003g'\u0001\u0007q\r\u000b\u0004\u0014e\u0006\u0005\u0011Q\u0005\u0017\u0005\u0003\u000b\tI\u0001K\u0004\u0014\u0003\u001f\t9\"!\u0007\u0002oQ,7\u000f\u001e)s_\u0012,8-Z!oI\u000e{gn];nK^KG\u000f[(cg\u0016\u0014h/\u001a:SK\u0006\u001c8/[4o[\u0016tG/\u00138Qe><'/Z:t)\r\u0011\u0017Q\u0006\u0005\u0006MR\u0001\ra\u001a\u0015\u0007)I\f\t!!\r-\t\u0005\u0015\u0011\u0011\u0002\u0015\b)\u0005=\u0011qCA\r\u0003%\"Xm\u001d;GC&dw)\u001a8fe\u0006$X-Q:tS\u001etW.\u001a8u/&$\bnQ8ogR\u0014\u0018-\u001b8ugR\u0019!-!\u000f\t\u000b\u0019,\u0002\u0019A4)\rU\u0011\u0018\u0011AA\u001fY\u0011\t)!!\u0003)\u000fU\ty!a\u0006\u0002\u001a\u0005YC/Z:u\r\u0006LGnR3oKJ\fG/Z!tg&<g.\\3oi^KG\u000f[\"p]N$(/Y5oiNT6\u000eF\u0002c\u0003\u000bBQA\u001a\fA\u0002\u001dDcA\u0006:\u0002\u0002\u0005%C\u0006BA\u0003\u0003\u0013AsAFA\b\u0003/\tI\"\u0001\rhK:,'/\u0019;f%\u0016\f7o]5h]6,g\u000e\u001e&t_:$\u0002\"!\u0015\u0002n\u0005\u0015\u0015\u0011\u0012\t\u0007g\u0005Ms-a\u0016\n\u0007\u0005UCG\u0001\u0004UkBdWM\r\t\u0005\u00033\n9G\u0004\u0003\u0002\\\u0005\rd\u0002BA/\u0003Cr1A[A0\u0013\u0005\u0019\u0013BA\u0011#\u0013\r\t)\u0007I\u0001\u001a%\u0016\f7o]5h]B\u000b'\u000f^5uS>t7oQ8n[\u0006tG-\u0003\u0003\u0002j\u0005-$AC!tg&<g.\\3oi*\u0019\u0011Q\r\u0011\t\u000f\u0005=t\u00031\u0001\u0002r\u000511\r\\5f]R\u0004B!a\u001d\u0002\u00026\u0011\u0011Q\u000f\u0006\u0004C\u0005]$\u0002BA=\u0003w\nqa\u00197jK:$8OC\u0002$\u0003{R1!a }\u0003\u0019\t\u0007/Y2iK&!\u00111QA;\u0005\u0015\tE-\\5o\u0011\u0019\t9i\u0006a\u0001O\u0006)Ao\u001c9jG\"1\u00111R\fA\u0002I\n\u0011\u0002]1si&$\u0018n\u001c8\u0002/\u001d,g.\u001a:bi\u0016$\u0006N]8ui2,7i\u001c8gS\u001e\u001cHCBAI\u0003G\u000b9\u000bE\u0004\u0002\u0014\u0006e%'a'\u000e\u0005\u0005U%bAAL\u000f\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0004\u0015\u0006U\u0005#\u0002$JO\u0006u\u0005cA\u001a\u0002 &\u0019\u0011\u0011\u0015\u001b\u0003\t1{gn\u001a\u0005\b\u0003KC\u0002\u0019AAO\u0003!!\bN]8ui2,\u0007bBAU1\u0001\u0007\u00111V\u0001\bEJ|7.\u001a:t!\r1uKM\u0001\u0018o\u0006LGOR8s)>\u0004\u0018n\u0019#fg\u000e\u0014\u0018\u000e\u001d;j_:$b!!-\u00028\u0006e\u0006\u0003BA:\u0003gKA!!.\u0002v\t\u0001Bk\u001c9jG\u0012+7o\u0019:jaRLwN\u001c\u0005\b\u0003_J\u0002\u0019AA9\u0011\u0019\tY,\u0007a\u0001O\u0006iAo\u001c9jGR{w+Y5u\u001f:\f1d^1ji\u001a{'O\u0011:pW\u0016\u0014H*\u001a<fYRC'o\u001c;uY\u0016\u001cH#\u00022\u0002B\u0006\r\u0007bBA85\u0001\u0007\u0011\u0011\u000f\u0005\b\u0003\u000bT\u0002\u0019AAd\u0003=!\u0018M]4fiRC'o\u001c;uY\u0016\u001c\b#\u0002$Je\u0005m\u0015\u0001\b3fg\u000e\u0014\u0018NY3Ce>\\WM\u001d'fm\u0016dG\u000b\u001b:piRdWm\u001d\u000b\u0007\u0003\u000f\fi-a4\t\u000f\u0005=4\u00041\u0001\u0002r!9\u0011\u0011[\u000eA\u0002\u0005-\u0016!\u00032s_.,'/\u00133t\u0003\t:\u0018-\u001b;G_J$UMZ1vYR\u0014%o\\6fe2+g/\u001a7UQJ|G\u000f\u001e7fgR)!-a6\u0002Z\"9\u0011q\u000e\u000fA\u0002\u0005E\u0004bBAi9\u0001\u0007\u00111V\u0001\"Q\u0006\u001c\u0018\t\u001c7EK\u001a\fW\u000f\u001c;Ce>\\WM\u001d'fm\u0016dG\u000b\u001b:piRdWm\u001d\u000b\u0007\u0003?\f)/a:\u0011\u0007M\n\t/C\u0002\u0002dR\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002pu\u0001\r!!\u001d\t\u000f\u0005EW\u00041\u0001\u0002,\u000612/\u001a8e%\u0016\u001cwN\u001d3t)>\u0004\u0016M\u001d;ji&|g\u000eF\u0003c\u0003[\f\t\u0010\u0003\u0004\u0002pz\u0001\rAM\u0001\u000b]Vl'+Z2pe\u0012\u001c\bbBAz=\u0001\u0007\u0011Q_\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\t90!@\u000e\u0005\u0005e(\u0002BA~\u0003w\naaY8n[>t\u0017\u0002BA\u0000\u0003s\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e")
public class ReassignPartitionsWithObserversIntegrationTest
extends IntegrationTestHarness {
    private final int broker1;
    private final int broker2;
    private final int broker3;
    private final int broker4;
    private final int broker5;
    private final int broker6;
    private final Map<Object, String> rack = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker1())), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker2())), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker3())), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker4())), (Object)"b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker5())), (Object)"b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker6())), (Object)"b")}));

    public int broker1() {
        return this.broker1;
    }

    public int broker2() {
        return this.broker2;
    }

    public int broker3() {
        return this.broker3;
    }

    public int broker4() {
        return this.broker4;
    }

    public int broker5() {
        return this.broker5;
    }

    public int broker6() {
        return this.broker6;
    }

    public Map<Object, String> rack() {
        return this.rack;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)config -> {
            config.setProperty(KafkaConfig$.MODULE$.RackProp(), (String)this.rack().apply((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(config.getProperty(KafkaConfig$.MODULE$.BrokerIdProp()))))));
            config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
            config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownMaxRetriesProp(), "1");
            config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp(), "1000");
            config.setProperty(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), "1000");
            return KafkaConfig$.MODULE$.fromProps(config);
        });
    }

    @Override
    public int brokerCount() {
        return this.rack().keys().size();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testReassignment(String quorum) {
        try (AdminClient resource_resource = (AdminClient)Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(ConfluentObserverTest$.MODULE$.createConfig((Seq<KafkaBroker>)this.brokers())).asJava());){
            ReassignPartitionsWithObserversIntegrationTest.$anonfun$testReassignment$1(this, resource_resource);
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testThrottledReassignment(String quorum) {
        try (AdminClient resource_resource = (AdminClient)Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(ConfluentObserverTest$.MODULE$.createConfig((Seq<KafkaBroker>)this.brokers())).asJava());){
            ReassignPartitionsWithObserversIntegrationTest.$anonfun$testThrottledReassignment$1(this, resource_resource);
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testProduceAndConsumeWithObserverReassignmentInProgress(String quorum) {
        try (AdminClient resource_resource = (AdminClient)Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(ConfluentObserverTest$.MODULE$.createConfig((Seq<KafkaBroker>)this.brokers())).asJava());){
            ReassignPartitionsWithObserversIntegrationTest.$anonfun$testProduceAndConsumeWithObserverReassignmentInProgress$1(this, resource_resource);
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFailGenerateAssignmentWithConstraints(String quorum) {
        try (AdminClient resource_resource = (AdminClient)Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(ConfluentObserverTest$.MODULE$.createConfig((Seq<KafkaBroker>)this.brokers())).asJava());){
            ReassignPartitionsWithObserversIntegrationTest.$anonfun$testFailGenerateAssignmentWithConstraints$1(this, resource_resource);
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFailGenerateAssignmentWithConstraintsZk(String quorum) {
        try (AdminClient resource_resource = (AdminClient)Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(ConfluentObserverTest$.MODULE$.createConfig((Seq<KafkaBroker>)this.brokers())).asJava());){
            ReassignPartitionsWithObserversIntegrationTest.$anonfun$testFailGenerateAssignmentWithConstraintsZk$1(this, resource_resource);
        }
    }

    public Tuple2<String, ReassignPartitionsCommand.Assignment> generateReassignmentJson(Admin client, String topic, int partition) {
        TopicDescription topicDescription = this.waitForTopicDescription(client, topic);
        TopicPartitionInfo partitionFound = (TopicPartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(topicDescription.partitions()).asScala().find((Function1 & Serializable)part -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsWithObserversIntegrationTest.$anonfun$generateReassignmentJson$1(partition, part))).get();
        scala.collection.immutable.Seq replicas = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionFound.replicas()).asScala().map((Function1 & Serializable)node -> BoxesRunTime.boxToInteger((int)node.id()))).toSeq();
        scala.collection.immutable.Seq newObservers = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)CollectionConverters$.MODULE$.ListHasAsScala(partitionFound.observers()).asScala().toSeq().map((Function1 & Serializable)node -> BoxesRunTime.boxToInteger((int)node.id()))).toSeq().map((Function1)(JFunction1.mcII.sp & Serializable)i -> (i + 1) % 3 + 3);
        scala.collection.immutable.Seq newReplicas = (scala.collection.immutable.Seq)((IterableOps)((IterableOps)replicas.slice(0, 2)).map((Function1)(JFunction1.mcII.sp & Serializable)i -> (i + 1) % 3)).$plus$plus((IterableOnce)newObservers);
        ReassignPartitionsCommand.Assignment targetAssignment = new ReassignPartitionsCommand.Assignment((Seq)newReplicas, (Seq)newObservers);
        String replicaString = targetAssignment.replicas().mkString(",");
        String observerString = targetAssignment.observers().mkString(",");
        String json = new StringBuilder(120).append("{\"version\":1,\"partitions\":").append("[{\"topic\":\"").append(topic).append("\",\"partition\":").append(partition).append(",\"replicas\":[").append(replicaString).append("],\"observers\":[").append(observerString).append("],").append("\"log_dirs\":[\"any\",\"any\",\"any\",\"any\"]}]}").toString();
        return new Tuple2((Object)json, (Object)targetAssignment);
    }

    public scala.collection.immutable.Map<Object, Map<String, Object>> generateThrottleConfigs(long throttle, Seq<Object> brokers) {
        Map throttledConfigMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLeaderThrottle()), (Object)BoxesRunTime.boxToLong((long)throttle)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelFollowerThrottle()), (Object)BoxesRunTime.boxToLong((long)throttle)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle()), (Object)BoxesRunTime.boxToLong((long)-1L))}));
        return ((IterableOnceOps)brokers.map((Function1 & Serializable)brokerId -> ReassignPartitionsWithObserversIntegrationTest.$anonfun$generateThrottleConfigs$1(throttledConfigMap, BoxesRunTime.unboxToInt((Object)brokerId)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public TopicDescription waitForTopicDescription(Admin client, String topicToWaitOn) {
        Option option;
        long awaitValue_waitTimeMs = 15000L;
        long awaitValue_waitUntilTrue_pause = 100L;
        long awaitValue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(option = ReassignPartitionsWithObserversIntegrationTest.$anonfun$waitForTopicDescription$1(client, topicToWaitOn)).isDefined()) {
            if (System.currentTimeMillis() > awaitValue_waitUntilTrue_startTime + awaitValue_waitTimeMs) {
                Assertions.fail((String)ReassignPartitionsWithObserversIntegrationTest.$anonfun$waitForTopicDescription$2(topicToWaitOn));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(awaitValue_waitTimeMs), awaitValue_waitUntilTrue_pause));
        }
        return (TopicDescription)option.get();
    }

    private void waitForBrokerLevelThrottles(Admin client, Map<Object, Map<String, Object>> targetThrottles) {
        Map<Object, Map<String, Object>> map;
        Map cfr_ignored_0 = (Map)Map$.MODULE$.empty();
        long x$4 = 15000L;
        long waitUntilTrue_pause = 25L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!targetThrottles.equals(map = this.describeBrokerLevelThrottles(client, (Seq<Object>)targetThrottles.keySet().toSeq()))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)new StringBuilder(73).append("timed out waiting for broker throttle to become ").append(targetThrottles).append(".  ").append("Latest throttles were ").append(map).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), waitUntilTrue_pause));
        }
    }

    private Map<Object, Map<String, Object>> describeBrokerLevelThrottles(Admin client, Seq<Object> brokerIds) {
        return CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)client.describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokerIds.map((Function1 & Serializable)id -> ReassignPartitionsWithObserversIntegrationTest.$anonfun$describeBrokerLevelThrottles$1(BoxesRunTime.unboxToInt((Object)id)))).asJava()).all().get()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                Config config = (Config)x0$1._2();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(resource.name()))), (Object)((IterableOnceOps)ReassignPartitionsCommand$.MODULE$.brokerLevelThrottles().map((Function1 & Serializable)throttleName -> new Tuple2(throttleName, Option$.MODULE$.apply((Object)config.get(throttleName)).fold((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L, (Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$4.value()))))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    /*
     * WARNING - void declaration
     */
    private void waitForDefaultBrokerLevelThrottles(Admin client, Seq<Object> brokerIds) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!this.hasAllDefaultBrokerLevelThrottles(client, (Seq<Object>)brokerIds)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for brokerLevelThrottles to be removed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private boolean hasAllDefaultBrokerLevelThrottles(Admin client, Seq<Object> brokerIds) {
        return CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)client.describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokerIds.map((Function1 & Serializable)id -> ReassignPartitionsWithObserversIntegrationTest.$anonfun$hasAllDefaultBrokerLevelThrottles$1(BoxesRunTime.unboxToInt((Object)id)))).asJava()).all().get()).asScala().forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsWithObserversIntegrationTest.$anonfun$hasAllDefaultBrokerLevelThrottles$2(x0$1)));
    }

    public void sendRecordsToPartition(int numRecords, TopicPartition topicPartition) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        ConfluentObserverTest$.MODULE$.sendRecords(producer, numRecords, topicPartition);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testReassignment$1(ReassignPartitionsWithObserversIntegrationTest $this, AdminClient client) {
        void var8_8;
        void var7_7;
        String topic = "observer-topic";
        int partition = 0;
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new ConfluentObserverTest.BasicConstraint(2, "a"), (Option<ConfluentObserverTest.BasicConstraint>)new Some((Object)new ConfluentObserverTest.BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TestUtils$.MODULE$.waitForPartitionMetadata($this.brokers(), topic, 0, 15000L);
        Tuple2<String, ReassignPartitionsCommand.Assignment> tuple2 = $this.generateReassignmentJson((Admin)client, topic, partition);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String assignmentJson = (String)tuple2._1();
        ReassignPartitionsCommand.Assignment targetAssignment = (ReassignPartitionsCommand.Assignment)tuple2._2();
        ReassignPartitionsIntegrationTest$.MODULE$.runExecuteAssignment((Admin)client, false, (String)var7_7, -1L, -1L);
        TestUtils$.MODULE$.waitForReplicasAndObserversAssigned((Admin)client, topicPartition, (Seq<Object>)var8_8.replicas(), (Seq<Object>)var8_8.observers());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testThrottledReassignment$1(ReassignPartitionsWithObserversIntegrationTest $this, AdminClient client) {
        void var7_7;
        void var8_8;
        String topic = "observer-topic";
        int partition = 0;
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new ConfluentObserverTest.BasicConstraint(2, "a"), (Option<ConfluentObserverTest.BasicConstraint>)new Some((Object)new ConfluentObserverTest.BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TestUtils$.MODULE$.waitForPartitionMetadata($this.brokers(), topic, 0, 15000L);
        $this.sendRecordsToPartition(10, new TopicPartition(topic, 0));
        Tuple2<String, ReassignPartitionsCommand.Assignment> tuple2 = $this.generateReassignmentJson((Admin)client, topic, partition);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String assignmentJson = (String)tuple2._1();
        ReassignPartitionsCommand.Assignment targetAssignment = (ReassignPartitionsCommand.Assignment)tuple2._2();
        long interBrokerThrottle = 300000L;
        scala.collection.immutable.Map<Object, Map<String, Object>> throttledBrokerConfigs = $this.generateThrottleConfigs(interBrokerThrottle, (Seq<Object>)var8_8.replicas());
        ReassignPartitionsIntegrationTest$.MODULE$.runExecuteAssignment((Admin)client, false, (String)var7_7, interBrokerThrottle, -1L);
        $this.waitForBrokerLevelThrottles((Admin)client, (Map<Object, Map<String, Object>>)throttledBrokerConfigs);
        Map finalAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((ReassignPartitionsCommand.Assignment)var8_8, (ReassignPartitionsCommand.Assignment)var8_8, true))}));
        ReassignPartitionsIntegrationTest$.MODULE$.waitForVerifyAssignment((Admin)client, (String)var7_7, true, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
        $this.waitForBrokerLevelThrottles((Admin)client, (Map<Object, Map<String, Object>>)throttledBrokerConfigs);
        ReassignPartitionsIntegrationTest$.MODULE$.waitForVerifyAssignment((Admin)client, (String)var7_7, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
        $this.waitForDefaultBrokerLevelThrottles((Admin)client, (Seq<Object>)throttledBrokerConfigs.keySet().toSeq());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testProduceAndConsumeWithObserverReassignmentInProgress$1(ReassignPartitionsWithObserversIntegrationTest $this, AdminClient client) {
        void var7_7;
        void var8_8;
        String topic = "observer-topic";
        int partition = 0;
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new ConfluentObserverTest.BasicConstraint(2, "a"), (Option<ConfluentObserverTest.BasicConstraint>)new Some((Object)new ConfluentObserverTest.BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TestUtils$.MODULE$.waitForPartitionMetadata($this.brokers(), topic, 0, 15000L);
        Tuple2<String, ReassignPartitionsCommand.Assignment> tuple2 = $this.generateReassignmentJson((Admin)client, topic, partition);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String assignmentJson = (String)tuple2._1();
        ReassignPartitionsCommand.Assignment targetAssignment = (ReassignPartitionsCommand.Assignment)tuple2._2();
        long interBrokerThrottle = 300000L;
        scala.collection.immutable.Map<Object, Map<String, Object>> throttledBrokerConfigs = $this.generateThrottleConfigs(interBrokerThrottle, (Seq<Object>)var8_8.replicas());
        String bootstrapServers = TestUtils$.MODULE$.plaintextBootstrapServers($this.brokers());
        ReassignPartitionsIntegrationTest$.MODULE$.runExecuteAssignment((Admin)client, false, (String)var7_7, interBrokerThrottle, -1L);
        $this.sendRecordsToPartition(100, topicPartition);
        try (KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(bootstrapServers, "group", (Option<String>)None$.MODULE$, "earliest", true, false, 500, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArrayDeserializer(), new ByteArrayDeserializer(), (String)null);){
            consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$)).asJava());
            TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 100, 15000L);
        }
        $this.waitForBrokerLevelThrottles((Admin)client, (Map<Object, Map<String, Object>>)throttledBrokerConfigs);
        Map finalAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((ReassignPartitionsCommand.Assignment)var8_8, (ReassignPartitionsCommand.Assignment)var8_8, true))}));
        ReassignPartitionsIntegrationTest$.MODULE$.waitForVerifyAssignment((Admin)client, (String)var7_7, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
        $this.waitForDefaultBrokerLevelThrottles((Admin)client, (Seq<Object>)throttledBrokerConfigs.keySet().toSeq());
    }

    public static final /* synthetic */ void $anonfun$testFailGenerateAssignmentWithConstraints$1(ReassignPartitionsWithObserversIntegrationTest $this, AdminClient client) {
        String topic1 = "observer-topic";
        String topic2 = "test-not-constrained";
        NewTopic newTopic1 = new NewTopic(topic1, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        NewTopic newTopic2 = new NewTopic(topic2, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic1.configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new ConfluentObserverTest.BasicConstraint(2, "a"), (Option<ConfluentObserverTest.BasicConstraint>)new Some((Object)new ConfluentObserverTest.BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)newTopic1, (List)new .colon.colon((Object)newTopic2, (List)Nil$.MODULE$))).asJava()).all().get();
        TestUtils$.MODULE$.waitForPartitionMetadata($this.brokers(), topic1, 0, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata($this.brokers(), topic2, 0, 15000L);
        Assertions.assertEquals((Object)"Assignments could not be generated because the following topics have placement constraints observer-topic", (Object)Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.generateAssignment((Admin)client, new StringBuilder(38).append("{\"topics\":[{\"topic\":\"").append(topic1).append("\"},{\"topic\":\"").append(topic2).append("\"}]}").toString(), new StringBuilder(3).append($this.broker1()).append(",").append($this.broker2()).append(",").append($this.broker4()).append(",").append($this.broker5()).toString(), false)).getMessage());
    }

    public static final /* synthetic */ void $anonfun$testFailGenerateAssignmentWithConstraintsZk$1(ReassignPartitionsWithObserversIntegrationTest $this, AdminClient client) {
        String topic1 = "observer-topic";
        String topic2 = "test-not-constrained";
        NewTopic newTopic1 = new NewTopic(topic1, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        NewTopic newTopic2 = new NewTopic(topic2, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic1.configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new ConfluentObserverTest.BasicConstraint(2, "a"), (Option<ConfluentObserverTest.BasicConstraint>)new Some((Object)new ConfluentObserverTest.BasicConstraint(2, "b"))))}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)newTopic1, (List)new .colon.colon((Object)newTopic2, (List)Nil$.MODULE$))).asJava()).all().get();
        TestUtils$.MODULE$.waitForPartitionMetadata($this.brokers(), topic1, 0, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata($this.brokers(), topic2, 0, 15000L);
        Assertions.assertEquals((Object)"Assignments could not be generated because the following topics have placement constraints observer-topic", (Object)Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.generateAssignment((Admin)client, new StringBuilder(38).append("{\"topics\":[{\"topic\":\"").append(topic1).append("\"},{\"topic\":\"").append(topic2).append("\"}]}").toString(), new StringBuilder(3).append($this.broker1()).append(",").append($this.broker2()).append(",").append($this.broker4()).append(",").append($this.broker5()).toString(), false)).getMessage());
    }

    public static final /* synthetic */ boolean $anonfun$generateReassignmentJson$1(int partition$1, TopicPartitionInfo part) {
        return part.partition() == partition$1;
    }

    public static final /* synthetic */ Tuple2 $anonfun$generateThrottleConfigs$1(Map throttledConfigMap$1, int brokerId) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)brokerId), (Object)throttledConfigMap$1);
    }

    public static final /* synthetic */ Option $anonfun$waitForTopicDescription$1(Admin client$3, String topicToWaitOn$1) {
        DescribeTopicsResult describeTopicsResult = client$3.describeTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicToWaitOn$1, (List)Nil$.MODULE$)).asJava());
        return CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)describeTopicsResult.allTopicNames().get()).asScala().get((Object)topicToWaitOn$1);
    }

    public static final /* synthetic */ String $anonfun$waitForTopicDescription$2(String topicToWaitOn$1) {
        return new StringBuilder(43).append("Timed out waiting for description of topic ").append(topicToWaitOn$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitForBrokerLevelThrottles$1(ReassignPartitionsWithObserversIntegrationTest $this, ObjectRef curThrottles$1, Admin client$4, Map targetThrottles$1) {
        curThrottles$1.elem = $this.describeBrokerLevelThrottles(client$4, (Seq<Object>)targetThrottles$1.keySet().toSeq());
        return targetThrottles$1.equals((Object)((Map)curThrottles$1.elem));
    }

    public static final /* synthetic */ String $anonfun$waitForBrokerLevelThrottles$2(Map targetThrottles$1, ObjectRef curThrottles$1) {
        return new StringBuilder(73).append("timed out waiting for broker throttle to become ").append(targetThrottles$1).append(".  ").append("Latest throttles were ").append((Map)curThrottles$1.elem).toString();
    }

    public static final /* synthetic */ ConfigResource $anonfun$describeBrokerLevelThrottles$1(int id) {
        return new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(id));
    }

    public static final /* synthetic */ String $anonfun$waitForDefaultBrokerLevelThrottles$2() {
        return "Timed out waiting for brokerLevelThrottles to be removed";
    }

    public static final /* synthetic */ ConfigResource $anonfun$hasAllDefaultBrokerLevelThrottles$1(int id) {
        return new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(id));
    }

    public static final /* synthetic */ boolean $anonfun$hasAllDefaultBrokerLevelThrottles$4(ConfigEntry x$5) {
        ConfigEntry.ConfigSource configSource = x$5.source();
        ConfigEntry.ConfigSource configSource2 = ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG;
        return configSource == null ? configSource2 != null : !configSource.equals(configSource2);
    }

    public static final /* synthetic */ boolean $anonfun$hasAllDefaultBrokerLevelThrottles$3(Config config$2, String throttleName) {
        return Option$.MODULE$.apply((Object)config$2.get(throttleName)).forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsWithObserversIntegrationTest.$anonfun$hasAllDefaultBrokerLevelThrottles$4(x$5)));
    }

    public static final /* synthetic */ boolean $anonfun$hasAllDefaultBrokerLevelThrottles$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            Config config = (Config)x0$1._2();
            return ReassignPartitionsCommand$.MODULE$.brokerLevelThrottles().forall((Function1 & Serializable)throttleName -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsWithObserversIntegrationTest.$anonfun$hasAllDefaultBrokerLevelThrottles$3(config, throttleName)));
        }
        throw new MatchError(null);
    }

    public ReassignPartitionsWithObserversIntegrationTest() {
        this.broker1 = 0;
        this.broker2 = 1;
        this.broker3 = 2;
        this.broker4 = 3;
        this.broker5 = 4;
        this.broker6 = 5;
    }

    public static final /* synthetic */ Object $anonfun$testReassignment$1$adapted(ReassignPartitionsWithObserversIntegrationTest $this, AdminClient client) {
        ReassignPartitionsWithObserversIntegrationTest.$anonfun$testReassignment$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testThrottledReassignment$1$adapted(ReassignPartitionsWithObserversIntegrationTest $this, AdminClient client) {
        ReassignPartitionsWithObserversIntegrationTest.$anonfun$testThrottledReassignment$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testProduceAndConsumeWithObserverReassignmentInProgress$1$adapted(ReassignPartitionsWithObserversIntegrationTest $this, AdminClient client) {
        ReassignPartitionsWithObserversIntegrationTest.$anonfun$testProduceAndConsumeWithObserverReassignmentInProgress$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testFailGenerateAssignmentWithConstraints$1$adapted(ReassignPartitionsWithObserversIntegrationTest $this, AdminClient client) {
        ReassignPartitionsWithObserversIntegrationTest.$anonfun$testFailGenerateAssignmentWithConstraints$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testFailGenerateAssignmentWithConstraintsZk$1$adapted(ReassignPartitionsWithObserversIntegrationTest $this, AdminClient client) {
        ReassignPartitionsWithObserversIntegrationTest.$anonfun$testFailGenerateAssignmentWithConstraintsZk$1($this, client);
        return BoxedUnit.UNIT;
    }
}

