/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;
import kafka.api.ConsumerTopicCreationTest$;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaConfig$;
import kafka.utils.EmptyTestInfo;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005q4A!\u0006\f\u00017!)!\u0005\u0001C\u0001G!)a\u0005\u0001C\u0001O\u001d)qJ\u0006E\u0001!\u001a)QC\u0006E\u0001#\")!\u0005\u0002C\u0001%\u001a!1\u000b\u0002\u0003U\u0011!acA!A!\u0002\u0013i\u0003\u0002\u0003\u001c\u0007\u0005\u0003\u0005\u000b\u0011B\u0017\t\u000b\t2A\u0011\u0001-\t\u000fu3!\u0019!C\u0005=\"1!M\u0002Q\u0001\n}Cqa\u0019\u0004C\u0002\u0013%a\f\u0003\u0004e\r\u0001\u0006Ia\u0018\u0005\bK\u001a\u0011\r\u0011\"\u0003_\u0011\u00191g\u0001)A\u0005?\"9qM\u0002b\u0001\n\u0013q\u0006B\u00025\u0007A\u0003%q\fC\u0003j\r\u0011E#\u000eC\u0003o\r\u0011\u0005q\u000eC\u0003J\t\u0011\u0005\u0001OA\rD_:\u001cX/\\3s)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8UKN$(BA\f\u0019\u0003\r\t\u0007/\u001b\u0006\u00023\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\n\t\u0003K\u0001i\u0011AF\u0001\u0016i\u0016\u001cH/Q;u_R{\u0007/[2De\u0016\fG/[8o)\rA3&\u000e\t\u0003;%J!A\u000b\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006Y\t\u0001\r!L\u0001\u001eEJ|7.\u001a:BkR|Gk\u001c9jG\u000e\u0013X-\u0019;j_:,e.\u00192mKB\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0005Y\u0006twMC\u00013\u0003\u0011Q\u0017M^1\n\u0005Qz#a\u0002\"p_2,\u0017M\u001c\u0005\u0006m\t\u0001\r!L\u0001\u001eG>t7/^7fe\u0006cGn\\<BkR|7I]3bi\u0016$v\u000e]5dg\"\"!\u0001\u000f$H!\tID)D\u0001;\u0015\tYD(\u0001\u0005qe>4\u0018\u000eZ3s\u0015\tid(\u0001\u0004qCJ\fWn\u001d\u0006\u0003\u007f\u0001\u000bqA[;qSR,'O\u0003\u0002B\u0005\u0006)!.\u001e8ji*\t1)A\u0002pe\u001eL!!\u0012\u001e\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0003!\u000b\u0013!S\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\bF\u0001\u0002L!\taU*D\u0001=\u0013\tqEHA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\f\u0011dQ8ogVlWM\u001d+pa&\u001c7I]3bi&|g\u000eV3tiB\u0011Q\u0005B\n\u0003\tq!\u0012\u0001\u0015\u0002\t)\u0016\u001cHoQ1tKN\u0011a!\u0016\t\u0003KYK!a\u0016\f\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgN$2!W.]!\tQf!D\u0001\u0005\u0011\u0015a\u0013\u00021\u0001.\u0011\u00151\u0014\u00021\u0001.\u0003\u001d!x\u000e]5d?F*\u0012a\u0018\t\u0003]\u0001L!!Y\u0018\u0003\rM#(/\u001b8h\u0003!!x\u000e]5d?F\u0002\u0013a\u0002;pa&\u001cwLM\u0001\ti>\u0004\u0018nY03A\u0005\u0001\u0002O]8ek\u000e,'o\u00117jK:$\u0018\nZ\u0001\u0012aJ|G-^2fe\u000ec\u0017.\u001a8u\u0013\u0012\u0004\u0013\u0001E2p]N,X.\u001a:DY&,g\u000e^%e\u0003E\u0019wN\\:v[\u0016\u00148\t\\5f]RLE\rI\u0001\fEJ|7.\u001a:D_VtG/F\u0001l!\tiB.\u0003\u0002n=\t\u0019\u0011J\u001c;\u0002\tQ,7\u000f\u001e\u000b\u0002QU\t\u0011\u000fE\u0002sofl\u0011a\u001d\u0006\u0003iV\faa\u001d;sK\u0006l'B\u0001<2\u0003\u0011)H/\u001b7\n\u0005a\u001c(AB*ue\u0016\fW\u000e\u0005\u0002:u&\u00111P\u000f\u0002\n\u0003J<W/\\3oiN\u0004")
public class ConsumerTopicCreationTest {
    public static Stream<Arguments> parameters() {
        return ConsumerTopicCreationTest$.MODULE$.parameters();
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testAutoTopicCreation(Boolean brokerAutoTopicCreationEnable, Boolean consumerAllowAutoCreateTopics) {
        TestCase testCase = new TestCase(brokerAutoTopicCreationEnable, consumerAllowAutoCreateTopics);
        testCase.setUp(new EmptyTestInfo());
        try {
            testCase.test();
        }
        finally {
            testCase.tearDown();
        }
    }

    private static class TestCase
    extends IntegrationTestHarness {
        private final Boolean brokerAutoTopicCreationEnable;
        private final Boolean consumerAllowAutoCreateTopics;
        private final String topic_1;
        private final String topic_2;
        private final String producerClientId;
        private final String consumerClientId;

        private String topic_1() {
            return this.topic_1;
        }

        private String topic_2() {
            return this.topic_2;
        }

        private String producerClientId() {
            return this.producerClientId;
        }

        private String consumerClientId() {
            return this.consumerClientId;
        }

        @Override
        public int brokerCount() {
            return 1;
        }

        /*
         * WARNING - void declaration
         */
        public void test() {
            KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            ConfluentAdmin adminClient = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());
            ProducerRecord record = new ProducerRecord(this.topic_1(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
            adminClient.createTopics(Collections.singleton(new NewTopic(this.topic_1(), 1, (short)1))).all().get();
            producer.send(record).get();
            consumer.subscribe(Arrays.asList(this.topic_1(), this.topic_2()));
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TestCase.$anonfun$test$1(consumer)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting to consume");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            KafkaZkClient qual$1 = this.zkClient();
            boolean x$1 = qual$1.getAllTopicsInCluster$default$1();
            boolean topicCreated = qual$1.getAllTopicsInCluster(x$1).contains((Object)this.topic_2());
            if (Predef$.MODULE$.Boolean2boolean(this.brokerAutoTopicCreationEnable) && Predef$.MODULE$.Boolean2boolean(this.consumerAllowAutoCreateTopics)) {
                Assertions.assertTrue((boolean)topicCreated);
                return;
            }
            Assertions.assertFalse((boolean)topicCreated);
        }

        public static final /* synthetic */ boolean $anonfun$test$1(KafkaConsumer consumer$1) {
            return consumer$1.poll(Duration.ofMillis(100L)).count() > 0;
        }

        public static final /* synthetic */ String $anonfun$test$2() {
            return "Timed out waiting to consume";
        }

        public TestCase(Boolean brokerAutoTopicCreationEnable, Boolean consumerAllowAutoCreateTopics) {
            this.brokerAutoTopicCreationEnable = brokerAutoTopicCreationEnable;
            this.consumerAllowAutoCreateTopics = consumerAllowAutoCreateTopics;
            this.topic_1 = "topic-1";
            this.topic_2 = "topic-2";
            this.producerClientId = "ConsumerTestProducer";
            this.consumerClientId = "ConsumerTestConsumer";
            this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
            this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), brokerAutoTopicCreationEnable.toString());
            this.producerConfig().setProperty("client.id", this.producerClientId());
            this.consumerConfig().setProperty("client.id", this.consumerClientId());
            this.consumerConfig().setProperty("group.id", "my-test");
            this.consumerConfig().setProperty("auto.offset.reset", "earliest");
            this.consumerConfig().setProperty("enable.auto.commit", "false");
            this.consumerConfig().setProperty("metadata.max.age.ms", "100");
            this.consumerConfig().setProperty("allow.auto.create.topics", consumerAllowAutoCreateTopics.toString());
        }
    }
}

