/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import io.confluent.kafka.link.ClusterLinkConfig;
import io.confluent.protobuf.events.catalog.v1.ClusterLinkMetadata;
import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import io.confluent.protobuf.events.catalog.v1.MirrorTopicMetadata;
import io.confluent.protobuf.events.catalog.v1.OpType;
import io.confluent.protobuf.events.catalog.v1.TopicMetadata;
import io.confluent.telemetry.api.events.Event;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kafka.catalog.MetadataEventUtils;
import kafka.server.link.ConnectionMode;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.test.InterceptorUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MetadataEventUtilsTest {
    String tenant = "lkc-12345";
    String tenantPrefix = "lkc-12345_";

    private MetadataEvent getTestTopicMetadataEvent(Uuid topicId, MirrorTopicMetadata mirrorTopicMetadata) {
        Properties logProps = new Properties();
        logProps.setProperty("retention.ms", "100");
        logProps.setProperty("retention.bytes", "-1");
        logProps.setProperty("confluent.schema.registry.url", "foo");
        logProps.setProperty("confluent.schema.validator.interceptor.class", InterceptorUtils.MockRecordInterceptor.class.getName());
        logProps.setProperty("confluent.key.schema.validation", "false");
        logProps.setProperty("confluent.value.schema.validation", "true");
        logProps.setProperty("cleanup.policy", String.format("%s, %s", "delete", "compact"));
        Set override = Collections.emptySet();
        LogConfig logConfig = new LogConfig((Map)logProps, override);
        return MetadataEventUtils.topicMetadataEventFromLogConfig((LogConfig)logConfig, (String)(this.tenantPrefix + topicId), (Uuid)topicId, (int)1, (int)2, (MirrorTopicMetadata)mirrorTopicMetadata, null, null);
    }

    @Test
    public void testBuildTopicMetadataEventFromLogConfig() {
        Uuid topicId = Uuid.randomUuid();
        MetadataEvent event = this.getTestTopicMetadataEvent(topicId, null);
        Assertions.assertNotNull((Object)event);
        TopicMetadata topicEvent = event.getTopicMetadata();
        Assertions.assertNotNull((Object)topicEvent);
        Assertions.assertEquals((Object)(this.tenantPrefix + topicId), (Object)topicEvent.getTopicName());
        Assertions.assertEquals((Object)topicId.toString(), (Object)topicEvent.getTopicId());
        Assertions.assertEquals((long)100L, (long)topicEvent.getRetentionMs());
        Assertions.assertEquals((long)-1L, (long)topicEvent.getRetentionBytes());
        Assertions.assertEquals((int)1, (int)topicEvent.getPartitionsCount());
        Assertions.assertEquals((int)2, (int)topicEvent.getReplicationFactor());
        Assertions.assertEquals((long)0L, (long)topicEvent.getCreateTime().getSeconds());
        Assertions.assertEquals((long)0L, (long)topicEvent.getUpdateTime().getSeconds());
        Assertions.assertFalse((boolean)topicEvent.getKeySchemaValidation());
        Assertions.assertTrue((boolean)topicEvent.getValueSchemaValidation());
        Assertions.assertEquals((Object)TopicMetadata.CleanupPolicy.COMPACT_DELETE, (Object)topicEvent.getCleanupPolicy());
        Assertions.assertEquals((Object)"", (Object)topicEvent.getOwner());
    }

    @Test
    public void testBuildMirrorTopicMetadataEventFromLogConfig() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        String sourceTopicName = "sourceTopic";
        Uuid topicId = Uuid.randomUuid();
        String mirrorTopicState = "ACTIVE";
        String remoteClusterId = "remoteClusterId";
        MirrorTopicMetadata mirrorTopicMetadata = MetadataEventUtils.mirrorTopicMetadata((Uuid)linkId, (String)linkName, (Uuid)topicId, (String)sourceTopicName, (String)mirrorTopicState, (String)remoteClusterId, null);
        MetadataEvent event = this.getTestTopicMetadataEvent(topicId, mirrorTopicMetadata);
        Assertions.assertNotNull((Object)event);
        TopicMetadata topicEvent = event.getTopicMetadata();
        Assertions.assertNotNull((Object)topicEvent);
        MirrorTopicMetadata mirrorTopicEvent = event.getTopicMetadata().getMirrorTopicMetadata();
        Assertions.assertNotNull((Object)mirrorTopicEvent);
        Assertions.assertEquals((Object)linkId.toString(), (Object)mirrorTopicEvent.getLinkId());
        Assertions.assertEquals((Object)linkName, (Object)mirrorTopicEvent.getLinkName());
        Assertions.assertEquals((Object)topicId.toString(), (Object)mirrorTopicEvent.getSourceTopicId());
        Assertions.assertEquals((Object)sourceTopicName, (Object)mirrorTopicEvent.getSourceTopicName());
        Assertions.assertEquals((Object)mirrorTopicState, (Object)mirrorTopicEvent.getMirrorTopicState());
        Assertions.assertEquals((Object)remoteClusterId, (Object)mirrorTopicEvent.getRemoteClusterId());
        Assertions.assertEquals((Object)(this.tenantPrefix + topicId), (Object)topicEvent.getTopicName());
        Assertions.assertEquals((Object)topicId.toString(), (Object)topicEvent.getTopicId());
        Assertions.assertEquals((long)100L, (long)topicEvent.getRetentionMs());
        Assertions.assertEquals((long)-1L, (long)topicEvent.getRetentionBytes());
        Assertions.assertEquals((int)1, (int)topicEvent.getPartitionsCount());
        Assertions.assertEquals((int)2, (int)topicEvent.getReplicationFactor());
        Assertions.assertEquals((long)0L, (long)topicEvent.getCreateTime().getSeconds());
        Assertions.assertEquals((long)0L, (long)topicEvent.getUpdateTime().getSeconds());
        Assertions.assertFalse((boolean)topicEvent.getKeySchemaValidation());
        Assertions.assertTrue((boolean)topicEvent.getValueSchemaValidation());
        Assertions.assertEquals((Object)TopicMetadata.CleanupPolicy.COMPACT_DELETE, (Object)topicEvent.getCleanupPolicy());
        Assertions.assertEquals((Object)"", (Object)topicEvent.getOwner());
    }

    @Test
    public void testClusterLinkMetadataEvent() {
        String linkName = this.tenantPrefix + "test_linkName";
        Uuid linkId = Uuid.randomUuid();
        String srcClusterId = "srcClusterId";
        String destClusterId = "destClusterId";
        MetadataEvent event = MetadataEventUtils.clusterLinkMetadataEvent((String)linkName, (Uuid)linkId, (ClusterLinkConfig.LinkMode)ClusterLinkConfig.LinkMode.fromString((String)"destination"), (ConnectionMode)ConnectionMode.fromString((String)"outbound"), (String)srcClusterId, (String)destClusterId, null, null);
        Assertions.assertNotNull((Object)event);
        ClusterLinkMetadata clusterLinkEvent = event.getClusterLinkMetadata();
        Assertions.assertNotNull((Object)clusterLinkEvent);
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkEvent.getClusterLinkName());
        Assertions.assertEquals((Object)linkId.toString(), (Object)clusterLinkEvent.getClusterLinkId());
        Assertions.assertTrue((boolean)ClusterLinkConfig.LinkMode.fromString((String)"Destination").toString().equalsIgnoreCase(clusterLinkEvent.getLinkMode().toString()));
        Assertions.assertTrue((boolean)ConnectionMode.fromString((String)"Outbound").toString().equalsIgnoreCase(clusterLinkEvent.getConnectionMode().toString()));
        Assertions.assertEquals((Object)srcClusterId, (Object)clusterLinkEvent.getRemoteClusterId());
        Assertions.assertEquals((Object)destClusterId, (Object)clusterLinkEvent.getLocalClusterId());
        Assertions.assertEquals((long)0L, (long)clusterLinkEvent.getCreateTime().getSeconds());
        Assertions.assertEquals((long)0L, (long)clusterLinkEvent.getUpdateTime().getSeconds());
    }

    @Test
    public void testBuildMetadataChange() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        MetadataEvent event1 = this.getTestTopicMetadataEvent(topicId1, null);
        MetadataEvent event2 = this.getTestTopicMetadataEvent(topicId2, null);
        MetadataChange change = MetadataEventUtils.snapshotEvent((String)this.tenant, Arrays.asList(event1, event2));
        Assertions.assertEquals((Object)OpType.SNAPSHOT, (Object)change.getOp());
        Assertions.assertEquals((int)2, (int)change.getEventsCount());
        Assertions.assertEquals((Object)topicId1.toString(), (Object)change.getEvents(0).getTopicMetadata().getTopicId());
        Assertions.assertEquals((Object)topicId2.toString(), (Object)change.getEvents(1).getTopicMetadata().getTopicId());
        change = MetadataEventUtils.entityCreateEvent((String)this.tenant, (MetadataEvent)event1);
        Assertions.assertEquals((Object)OpType.CREATE, (Object)change.getOp());
        change = MetadataEventUtils.entityUpdateEvent((String)this.tenant, (MetadataEvent)event1);
        Assertions.assertEquals((Object)OpType.UPDATE, (Object)change.getOp());
        change = MetadataEventUtils.entityDeleteEvent((String)this.tenant, (MetadataEvent)event1);
        Assertions.assertEquals((Object)OpType.DELETE, (Object)change.getOp());
        Assertions.assertEquals((Object)topicId1.toString(), (Object)change.getEvents(0).getTopicMetadata().getTopicId());
    }

    @Test
    public void testBuildCloudEvent() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        MetadataEvent event1 = this.getTestTopicMetadataEvent(topicId1, null);
        MetadataEvent event2 = this.getTestTopicMetadataEvent(topicId2, null);
        MetadataChange change = MetadataEventUtils.snapshotEvent((String)this.tenant, Arrays.asList(event1, event2));
        Event snapshotCloudEvent = MetadataEventUtils.metadataSnapshotCloudEvent((MetadataChange)change, (int)0, (String)"_catalog_kafka_topic", (int)0, (int)1);
        Assertions.assertNotNull((Object)snapshotCloudEvent);
        Assertions.assertEquals((Object)"crn://confluent.cloud/kafka=lkc-12345/topics-and-cluster-links", (Object)snapshotCloudEvent.source().toString());
        Assertions.assertEquals((Object)"topicAndClusterLink", (Object)snapshotCloudEvent.subject());
        Assertions.assertEquals((Object)"SNAPSHOT", (Object)snapshotCloudEvent.type());
        Assertions.assertEquals((Object)"_catalog_kafka_topic", (Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.route.name()));
        Assertions.assertEquals((Object)"0", (Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.epoch.name()));
        Assertions.assertEquals((Object)"0", (Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.page.name()));
        Assertions.assertEquals((Object)"1", (Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.total.name()));
        change = MetadataEventUtils.entityCreateEvent((String)this.tenant, (MetadataEvent)event1);
        snapshotCloudEvent = MetadataEventUtils.topicMetadataDeltaCloudEvent((MetadataChange)change, (int)1, null);
        Assertions.assertNotNull((Object)snapshotCloudEvent);
        Assertions.assertEquals((Object)("crn://confluent.cloud/kafka=lkc-12345/topic=" + this.tenantPrefix + topicId1), (Object)snapshotCloudEvent.source().toString());
        Assertions.assertEquals((Object)"DELTA", (Object)snapshotCloudEvent.type());
        Assertions.assertEquals((Object)"1", (Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.epoch.name()));
        Assertions.assertNull((Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.route.name()));
        Assertions.assertNull((Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.page.name()));
        Assertions.assertNull((Object)snapshotCloudEvent.extension(MetadataEventUtils.Extensions.total.name()));
    }

    @Test
    public void testPaginationInput() {
        Assertions.assertTrue((boolean)MetadataEventUtils.checkIsPagination((int)0, (int)1));
        Assertions.assertTrue((boolean)MetadataEventUtils.checkIsPagination((int)1, (int)10));
        Assertions.assertFalse((boolean)MetadataEventUtils.checkIsPagination((int)-1, (int)-1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataEventUtils.checkIsPagination((int)2, (int)-1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataEventUtils.checkIsPagination((int)10, (int)1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataEventUtils.checkIsPagination((int)0, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataEventUtils.checkIsPagination((int)1, (int)1));
    }

    @Test
    public void testSnapshotEventNumber() {
        Assertions.assertEquals((int)0, (int)MetadataEventUtils.getNumberOfSnapshotPages((int)0, (int)5000));
        Assertions.assertEquals((int)1, (int)MetadataEventUtils.getNumberOfSnapshotPages((int)1, (int)5000));
        Assertions.assertEquals((int)1, (int)MetadataEventUtils.getNumberOfSnapshotPages((int)4999, (int)5000));
        Assertions.assertEquals((int)1, (int)MetadataEventUtils.getNumberOfSnapshotPages((int)5000, (int)5000));
        Assertions.assertEquals((int)2, (int)MetadataEventUtils.getNumberOfSnapshotPages((int)5001, (int)5000));
        Assertions.assertEquals((int)2, (int)MetadataEventUtils.getNumberOfSnapshotPages((int)9999, (int)5000));
    }

    @Test
    public void testEventHasChanged() {
        TopicMetadata.Builder topicMetadataBuilder = TopicMetadata.newBuilder().setTopicId("topic-123").setTopicName("topic-1").setReplicationFactor(3).setPartitionsCount(10).setKeySchemaValidation(false).setValueSchemaValidation(true).setRetentionBytes(100000L).setCleanupPolicy(TopicMetadata.CleanupPolicy.DELETE).setRetentionMs(86400000L);
        MetadataEvent event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.build()).build();
        MetadataEvent event2 = event1.toBuilder().build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged(null, null));
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, null));
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged(null, (MetadataEvent)event2));
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setTopicId("topic-456")).build();
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setTopicId("topic-123")).build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setTopicName("topic-2")).build();
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setTopicName("topic-1")).build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setReplicationFactor(5)).build();
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setReplicationFactor(3)).build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setPartitionsCount(6)).build();
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setPartitionsCount(10)).build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setKeySchemaValidation(true)).build();
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setKeySchemaValidation(false)).build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setValueSchemaValidation(false)).build();
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setValueSchemaValidation(true)).build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setRetentionBytes(200000L)).build();
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setRetentionBytes(100000L)).build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setCleanupPolicy(TopicMetadata.CleanupPolicy.COMPACT)).build();
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setCleanupPolicy(TopicMetadata.CleanupPolicy.DELETE)).build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setRetentionMs(604800000L)).build();
        Assertions.assertTrue((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
        event1 = MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.setRetentionMs(86400000L)).build();
        Assertions.assertFalse((boolean)MetadataEventUtils.eventHasChanged((MetadataEvent)event1, (MetadataEvent)event2));
    }
}

