/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.catalog.MetadataCollectorEventQueue;
import kafka.catalog.ZKMetadataCollector;
import kafka.catalog.ZKMetadataCollectorConfig;
import kafka.catalog.ZKMetadataCollectorContext;
import kafka.catalog.event.BrokerDefaultConfigChangeEvent;
import kafka.catalog.event.ClusterLinkConfigChangeEvent;
import kafka.catalog.event.ClusterLinkCreationEvent;
import kafka.catalog.event.ClusterLinkDeletionEvent;
import kafka.catalog.event.CollectorStartupEvent;
import kafka.catalog.event.CollectorStopEvent;
import kafka.catalog.event.MetadataCollectorEvent;
import kafka.catalog.event.MirrorTopicChangeEvent;
import kafka.catalog.event.TopicConfigChangeEvent;
import kafka.catalog.event.TopicCreationEvent;
import kafka.catalog.event.TopicDeletionEvent;
import kafka.catalog.event.TopicPartitionChangeEvent;
import kafka.catalog.metadata.ClusterLinkInfo;
import kafka.catalog.metadata.TopicInfo;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ConnectionMode;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;

public class ZKMetadataCollectorTest {
    @Mock
    private ZKMetadataCollectorConfig mockConfig;
    @Mock
    private KafkaConfig mockKafkaConfig;
    @Mock
    private KafkaZkClient mockZkClient;
    @Mock
    private MetadataCollectorEventQueue mockEventQueue;
    @Mock
    private Logger mockLogger;
    private ZKMetadataCollectorContext context;
    private ZKMetadataCollector collector;
    private ArgumentCaptor<MetadataCollectorEvent> submittedEvent;
    private Metrics metrics;
    private Time time;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        this.time = new MockTime();
        this.metrics = new Metrics();
        this.context = new ZKMetadataCollectorContext(this.mockConfig, Collections.emptyMap(), Collections.emptyMap(), this.mockEventQueue, this.metrics, this.mockZkClient, this.mockKafkaConfig, 0, this.time);
        this.submittedEvent = ArgumentCaptor.forClass(MetadataCollectorEvent.class);
        this.collector = new ZKMetadataCollector(this.mockKafkaConfig, this.mockConfig, this.mockZkClient, this.metrics, this.mockLogger, this.mockEventQueue, Optional.of(this.context), Boolean.valueOf(true), this.time);
    }

    @Test
    public void testCollectorStart() {
        this.metrics = new Metrics();
        this.collector = new ZKMetadataCollector(this.mockKafkaConfig, this.mockConfig, this.mockZkClient, this.metrics, this.mockLogger, this.mockEventQueue, Optional.empty(), Boolean.valueOf(false), this.time);
        this.collector.enable(Collections.singletonMap("lkc-abc_topic1", new TopicInfo("lkc-abc_topic1", Uuid.randomUuid(), 1, 1)), Collections.emptyMap(), 0);
        ((MetadataCollectorEventQueue)Mockito.verify((Object)this.mockEventQueue)).append((MetadataCollectorEvent)this.submittedEvent.capture());
        Assertions.assertNotNull((Object)this.submittedEvent.getValue());
        Assertions.assertEquals(CollectorStartupEvent.class, ((MetadataCollectorEvent)this.submittedEvent.getValue()).getClass());
    }

    @Test
    public void testCollectorStop() {
        this.collector.disable();
        ((MetadataCollectorEventQueue)Mockito.verify((Object)this.mockEventQueue)).append((MetadataCollectorEvent)this.submittedEvent.capture());
        Assertions.assertNotNull((Object)this.submittedEvent.getValue());
        Assertions.assertEquals(CollectorStopEvent.class, ((MetadataCollectorEvent)this.submittedEvent.getValue()).getClass());
    }

    @Test
    public void testCollectorListenClusterLinkCreate() {
        this.collector.onClusterLinkCreate(new ClusterLinkInfo("lkc-123_link1", Uuid.randomUuid(), ClusterLinkConfig.LinkMode.fromString((String)"destination"), ConnectionMode.fromString((String)"outbound"), "srcClusterId", "destClusterId"));
        ((MetadataCollectorEventQueue)Mockito.verify((Object)this.mockEventQueue)).append((MetadataCollectorEvent)this.submittedEvent.capture());
        Assertions.assertNotNull((Object)this.submittedEvent.getValue());
        Assertions.assertEquals(ClusterLinkCreationEvent.class, ((MetadataCollectorEvent)this.submittedEvent.getValue()).getClass());
    }

    @Test
    public void testCollectorListenClusterLinkConfigChange() {
        this.collector.onClusterLinkConfigChange("lkc-123_link1", ClusterLinkConfig.create((Map)new Properties(), (boolean)false));
        ((MetadataCollectorEventQueue)Mockito.verify((Object)this.mockEventQueue)).append((MetadataCollectorEvent)this.submittedEvent.capture());
        Assertions.assertNotNull((Object)this.submittedEvent.getValue());
        Assertions.assertEquals(ClusterLinkConfigChangeEvent.class, ((MetadataCollectorEvent)this.submittedEvent.getValue()).getClass());
    }

    @Test
    public void testCollectorListenClusterLinkDelete() {
        this.collector.onClusterLinkDelete("lkc-123_link1");
        ((MetadataCollectorEventQueue)Mockito.verify((Object)this.mockEventQueue)).append((MetadataCollectorEvent)this.submittedEvent.capture());
        Assertions.assertNotNull((Object)this.submittedEvent.getValue());
        Assertions.assertEquals(ClusterLinkDeletionEvent.class, ((MetadataCollectorEvent)this.submittedEvent.getValue()).getClass());
    }

    @Test
    public void testCollectorListenTopicCreate() {
        this.collector.onTopicCreate(Collections.singletonMap("lkc-123_topic1", new TopicInfo("lkc-123_topic1", Uuid.randomUuid(), 1, 1)));
        ((MetadataCollectorEventQueue)Mockito.verify((Object)this.mockEventQueue)).append((MetadataCollectorEvent)this.submittedEvent.capture());
        Assertions.assertNotNull((Object)this.submittedEvent.getValue());
        Assertions.assertEquals(TopicCreationEvent.class, ((MetadataCollectorEvent)this.submittedEvent.getValue()).getClass());
    }

    @Test
    public void testCollectorListenTopicDelete() {
        this.collector.onTopicDelete(Collections.singleton("lkc-123_topic1"));
        ((MetadataCollectorEventQueue)Mockito.verify((Object)this.mockEventQueue)).append((MetadataCollectorEvent)this.submittedEvent.capture());
        Assertions.assertNotNull((Object)this.submittedEvent.getValue());
        Assertions.assertEquals(TopicDeletionEvent.class, ((MetadataCollectorEvent)this.submittedEvent.getValue()).getClass());
    }

    @Test
    public void testCollectorListenTopicConfigChange() {
        this.collector.onTopicConfigChange("lkc-123_topic1", null, new Properties());
        ((MetadataCollectorEventQueue)Mockito.verify((Object)this.mockEventQueue)).append((MetadataCollectorEvent)this.submittedEvent.capture());
        Assertions.assertNotNull((Object)this.submittedEvent.getValue());
        Assertions.assertEquals(TopicConfigChangeEvent.class, ((MetadataCollectorEvent)this.submittedEvent.getValue()).getClass());
    }

    @Test
    public void testCollectorListenMirrorTopicChange() {
        this.collector.onMirrorTopicStateChange("lkc-123_topic1", "PENDING_STOPPED");
        ((MetadataCollectorEventQueue)Mockito.verify((Object)this.mockEventQueue)).append((MetadataCollectorEvent)this.submittedEvent.capture());
        Assertions.assertNotNull((Object)this.submittedEvent.getValue());
        Assertions.assertEquals(MirrorTopicChangeEvent.class, ((MetadataCollectorEvent)this.submittedEvent.getValue()).getClass());
    }

    @Test
    public void testCollectorListenTopicPartitionChange() {
        this.collector.onTopicPartitionChange("lkc-123_topic1", 1);
        ((MetadataCollectorEventQueue)Mockito.verify((Object)this.mockEventQueue)).append((MetadataCollectorEvent)this.submittedEvent.capture());
        Assertions.assertNotNull((Object)this.submittedEvent.getValue());
        Assertions.assertEquals(TopicPartitionChangeEvent.class, ((MetadataCollectorEvent)this.submittedEvent.getValue()).getClass());
    }

    @Test
    public void testCollectorListenBrokerDefaultConfigChange() {
        this.collector.onBrokerDefaultConfigChange(null, null);
        ((MetadataCollectorEventQueue)Mockito.verify((Object)this.mockEventQueue)).append((MetadataCollectorEvent)this.submittedEvent.capture());
        Assertions.assertNotNull((Object)this.submittedEvent.getValue());
        Assertions.assertEquals(BrokerDefaultConfigChangeEvent.class, ((MetadataCollectorEvent)this.submittedEvent.getValue()).getClass());
    }
}

